/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.config.Settings;
import ai.starlake.job.sink.bigquery.BigQueryJobBase;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.job.sink.bigquery.BigQueryJobResult;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.job.sink.bigquery.BigQueryNativeJob$;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.SinkType;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import com.google.cloud.Policy;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.hubspot.jinjava.Jinjava;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.DatasetLogging;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\r\u0001\u0003\u0006\u0004%\tE\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!9\u0005A!b\u0001\n\u0007A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000bA\u0003A\u0011A)\t\u000ba\u0003A\u0011I-\t\u000fi\u0003!\u0019!C!3\"11\f\u0001Q\u0001\naBQ\u0001\u0018\u0001\u0005\u0002uCQa\u001a\u0001\u0005\n!DQA\u001f\u0001\u0005BuCQa\u001f\u0001\u0005\u0002q<q!a\u0001\u0016\u0011\u0003\t)A\u0002\u0004\u0015+!\u0005\u0011q\u0001\u0005\u0007!B!\t!!\u0007\t\u000f\u0005m\u0001\u0003\"\u0001\u0002\u001e!9\u0011q\u0007\t\u0005\u0002\u0005e\"!\u0005\"jOF+XM]=OCRLg/\u001a&pE*\u0011acF\u0001\tE&<\u0017/^3ss*\u0011\u0001$G\u0001\u0005g&t7N\u0003\u0002\u001b7\u0005\u0019!n\u001c2\u000b\u0005qi\u0012\u0001C:uCJd\u0017m[3\u000b\u0003y\t!!Y5\u0004\u0001M!\u0001!I\u0014.!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001fK\u0007\u0002S)\u0011!fG\u0001\u0006kRLGn]\u0005\u0003Y%\u0012qAS8c\u0005\u0006\u001cX\r\u0005\u0002/_5\tQ#\u0003\u00021+\ty!)[4Rk\u0016\u0014\u0018PS8c\u0005\u0006\u001cX-A\u0005dY&\u001cuN\u001c4jOV\t1\u0007\u0005\u0002/i%\u0011Q'\u0006\u0002\u0013\u0005&<\u0017+^3ss2{\u0017\rZ\"p]\u001aLw-\u0001\u0006dY&\u001cuN\u001c4jO\u0002\n1a]9m!\tI\u0004I\u0004\u0002;}A\u00111hI\u0007\u0002y)\u0011QhH\u0001\u0007yI|w\u000e\u001e \n\u0005}\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!aP\u0012\u0002\u0007U$g\rE\u0002#\u000bbJ!AR\u0012\u0003\r=\u0003H/[8o\u0003!\u0019X\r\u001e;j]\u001e\u001cX#A%\u0011\u0005)kU\"A&\u000b\u00051[\u0012AB2p]\u001aLw-\u0003\u0002O\u0017\nA1+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u00051A(\u001b8jiz\"BAU+W/R\u00111\u000b\u0016\t\u0003]\u0001AQaR\u0004A\u0004%CQ!M\u0004A\u0002MBQaN\u0004A\u0002aBQaQ\u0004A\u0002\u0011\u000bAA\\1nKV\t\u0001(A\u0005qe>TWm\u0019;JI\u0006Q\u0001O]8kK\u000e$\u0018\n\u001a\u0011\u0002'I,h.\u00138uKJ\f7\r^5wKF+XM]=\u0015\u0003y\u00032a\u00182e\u001b\u0005\u0001'BA1$\u0003\u0011)H/\u001b7\n\u0005\r\u0004'a\u0001+ssB\u0011\u0001&Z\u0005\u0003M&\u0012\u0011BS8c%\u0016\u001cX\u000f\u001c;\u0002'\u0005$G-\u0016#G)>\fV/\u001a:z\u0007>tg-[4\u0015\u0005%D\bC\u00016v\u001d\tY7/D\u0001m\u0015\t1RN\u0003\u0002o_\u0006)1\r\\8vI*\u0011\u0001/]\u0001\u0007O>|w\r\\3\u000b\u0003I\f1aY8n\u0013\t!H.A\u000bRk\u0016\u0014\u0018PS8c\u0007>tg-[4ve\u0006$\u0018n\u001c8\n\u0005Y<(a\u0002\"vS2$WM\u001d\u0006\u0003i2DQ!\u001f\u0007A\u0002%\f1\"];fef\u001cuN\u001c4jO\u0006\u0019!/\u001e8\u0002\u001bI,hNQ1uG\"\fV/\u001a:z)\u0005i\bcA0c}B\u00111n`\u0005\u0004\u0003\u0003a'a\u0001&pE\u0006\t\")[4Rk\u0016\u0014\u0018PT1uSZ,'j\u001c2\u0011\u00059\u00022\u0003\u0002\t\"\u0003\u0013\u0001B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0007tG\u0006d\u0017\r\\8hO&twMC\u0002\u0002\u0014E\f\u0001\u0002^=qKN\fg-Z\u0005\u0005\u0003/\tiAA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u000b\u0003\u0003\u000b\t1b\u0019:fCR,G+\u00192mKRA\u0011qDA\u0013\u0003S\ti\u0003E\u0002#\u0003CI1!a\t$\u0005\u0011)f.\u001b;\t\r\u0005\u001d\"\u00031\u00019\u0003-!\u0017\r^1tKRt\u0015-\\3\t\r\u0005-\"\u00031\u00019\u0003%!\u0018M\u00197f\u001d\u0006lW\rC\u0004\u00020I\u0001\r!!\r\u0002\rM\u001c\u0007.Z7b!\rY\u00171G\u0005\u0004\u0003ka'AB*dQ\u0016l\u0017-A\u0006de\u0016\fG/\u001a,jK^\u001cHCBA\u0010\u0003w\t)\u0005C\u0004\u0002>M\u0001\r!a\u0010\u0002\u000bYLWm^:\u0011\u000be\n\t\u0005\u000f\u001d\n\u0007\u0005\r#IA\u0002NCBDQaQ\nA\u0002\u0011CsaEA%\u0003\u001f\n\u0019\u0006E\u0002#\u0003\u0017J1!!\u0014$\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003#\nQGV5foN\u0004\u0013M]3!]><\be\u0019:fCR,G\rI;tS:<\u0007\u0005\u001e5fAMLh\u000e^1yA]#\u0006\n\t\u0018/]\u0001\n5\u000b\t\u0018/]\u0005\u0012\u0011QK\u0001\u0007a9\ndFM\u001b")
public class BigQueryNativeJob
implements JobBase,
BigQueryJobBase {
    private final BigQueryLoadConfig cliConfig;
    private final String sql;
    private final Option<String> udf;
    private final Settings settings;
    private final String projectId;
    private final TableId tableId;
    private final DatasetId datasetId;
    private final String bqTable;
    private final Jinjava jinjava;
    private final Logger logger;

    public static void createViews(Map<String, String> map, Option<String> option) {
        BigQueryNativeJob$.MODULE$.createViews(map, option);
    }

    public static void createTable(String string, String string2, Schema schema) {
        BigQueryNativeJob$.MODULE$.createTable(string, string2, schema);
    }

    @Override
    public Try<BoxedUnit> applyRLSAndCLS(boolean forceApply, Settings settings) {
        return BigQueryJobBase.applyRLSAndCLS$(this, forceApply, settings);
    }

    @Override
    public boolean applyRLSAndCLS$default$1() {
        return BigQueryJobBase.applyRLSAndCLS$default$1$(this);
    }

    @Override
    public List<String> prepareRLS() {
        return BigQueryJobBase.prepareRLS$(this);
    }

    @Override
    public Dataset getOrCreateDataset() {
        return BigQueryJobBase.getOrCreateDataset$(this);
    }

    @Override
    public void setTagsOnTable(Table table) {
        BigQueryJobBase.setTagsOnTable$(this, table);
    }

    @Override
    public void setTagsOnDataset(Dataset dataset) {
        BigQueryJobBase.setTagsOnDataset$(this, dataset);
    }

    @Override
    public Policy applyACL(TableId tableId, List<AccessControlEntry> acl) {
        return BigQueryJobBase.applyACL$(this, tableId, acl);
    }

    @Override
    public TimePartitioning.Builder timePartitioning(String partitionField, Option<Object> days, boolean requirePartitionFilter) {
        return BigQueryJobBase.timePartitioning$(this, partitionField, days, requirePartitionFilter);
    }

    @Override
    public Option<Object> timePartitioning$default$2() {
        return BigQueryJobBase.timePartitioning$default$2$(this);
    }

    @Override
    public Tuple3<SinkType, Option<String>, String> parseViewDefinition(String valueWithEnv) {
        return JobBase.parseViewDefinition$(this, valueWithEnv);
    }

    @Override
    public String parseJinja(String str, Map<String, String> params) {
        return JobBase.parseJinja$((JobBase)this, str, params);
    }

    @Override
    public List<String> parseJinja(List<String> str, Map<String, String> params) {
        return JobBase.parseJinja$((JobBase)this, str, params);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(org.apache.spark.sql.Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public DatasetId datasetId() {
        return this.datasetId;
    }

    @Override
    public String bqTable() {
        return this.bqTable;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$_setter_$tableId_$eq(TableId x$1) {
        this.tableId = x$1;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$_setter_$datasetId_$eq(DatasetId x$1) {
        this.datasetId = x$1;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$_setter_$bqTable_$eq(String x$1) {
        this.bqTable = x$1;
    }

    @Override
    public Jinjava jinjava() {
        return this.jinjava;
    }

    @Override
    public void ai$starlake$utils$JobBase$_setter_$jinjava_$eq(Jinjava x$1) {
        this.jinjava = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public BigQueryLoadConfig cliConfig() {
        return this.cliConfig;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return new StringBuilder(8).append("bqload-").append(this.cliConfig().outputDataset()).append("-").append(this.cliConfig().outputTable()).toString();
    }

    @Override
    public String projectId() {
        return this.projectId;
    }

    public Try<JobResult> runInteractiveQuery() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            QueryJobConfiguration.Builder queryConfig = QueryJobConfiguration.newBuilder((String)$this.sql).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Running interactive BQ Query {}", new Object[]{$this.sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            QueryJobConfiguration.Builder queryConfigWithUDF = this.addUDFToQueryConfig(queryConfig);
            QueryJobConfiguration finalConfiguration = queryConfigWithUDF.setPriority(QueryJobConfiguration.Priority.INTERACTIVE).build();
            Job queryJob = BigQueryJobBase$.MODULE$.bigquery().create(JobInfo.of((JobConfiguration)finalConfiguration), new BigQuery.JobOption[0]);
            Long totalBytesProcessed = ((JobStatistics.QueryStatistics)queryJob.getStatistics()).getTotalBytesProcessed();
            TableResult results = queryJob.getQueryResults(new BigQuery.QueryResultsOption[0]);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Query large results performed successfully: {} rows returned.", new Object[]{BoxesRunTime.boxToLong((long)results.getTotalRows())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new BigQueryJobResult((Option<TableResult>)new Some((Object)results), Predef$.MODULE$.Long2long(totalBytesProcessed));
        });
    }

    private QueryJobConfiguration.Builder addUDFToQueryConfig(QueryJobConfiguration.Builder queryConfig) {
        QueryJobConfiguration.Builder queryConfigWithUDF = (QueryJobConfiguration.Builder)this.udf.map((Function1 & Serializable & scala.Serializable)udf -> queryConfig.setUserDefinedFunctions((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)UserDefinedFunction.fromUri((String)udf), (List)Nil$.MODULE$)).asJava())).getOrElse((Function0 & Serializable & scala.Serializable)() -> queryConfig);
        return queryConfigWithUDF;
    }

    @Override
    public Try<JobResult> run() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            QueryJobConfiguration.Builder queryConfigWithClustering;
            QueryJobConfiguration.Builder builder;
            BoxedUnit boxedUnit4;
            QueryJobConfiguration.Builder builder2;
            BoxedUnit boxedUnit5;
            Dataset targetDataset = this.getOrCreateDataset();
            QueryJobConfiguration.Builder queryConfig = QueryJobConfiguration.newBuilder((String)$this.sql).setCreateDisposition(JobInfo.CreateDisposition.valueOf((String)this.cliConfig().createDisposition())).setWriteDisposition(JobInfo.WriteDisposition.valueOf((String)this.cliConfig().writeDisposition())).setDefaultDataset(targetDataset.getDatasetId()).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Computing partitionning");
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            Option<String> option = this.cliConfig().outputPartition();
            if (option instanceof Some) {
                Some some = (Some)option;
                String partitionField = (String)some.value();
                TimePartitioning partitioning = this.timePartitioning(partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter()).build();
                builder2 = queryConfig.setTimePartitioning(partitioning);
            } else if (None$.MODULE$.equals(option)) {
                builder2 = queryConfig;
            } else {
                throw new MatchError(option);
            }
            QueryJobConfiguration.Builder queryConfigWithPartition = builder2;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Computing clustering");
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            Seq<String> seq = this.cliConfig().outputClustering();
            if (Nil$.MODULE$.equals(seq)) {
                builder = queryConfigWithPartition;
            } else {
                Clustering clustering = Clustering.newBuilder().setFields((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava()).build();
                builder = queryConfigWithClustering = queryConfigWithPartition.setClustering(clustering);
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Add user defined functions");
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            QueryJobConfiguration.Builder queryConfigWithUDF = this.addUDFToQueryConfig(queryConfigWithClustering);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Executing BQ Query {}", new Object[]{$this.sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            QueryJobConfiguration finalConfiguration = queryConfigWithUDF.setDestinationTable(this.tableId()).build();
            Job jobInfo = BigQueryJobBase$.MODULE$.bigquery().create(JobInfo.of((JobConfiguration)finalConfiguration), new BigQuery.JobOption[0]);
            Long totalBytesProcessed = ((JobStatistics.QueryStatistics)jobInfo.getStatistics()).getTotalBytesProcessed();
            TableResult results = jobInfo.getQueryResults(new BigQuery.QueryResultsOption[0]);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Query large results performed successfully: {} rows inserted.", new Object[]{BoxesRunTime.boxToLong((long)results.getTotalRows())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.applyRLSAndCLS(this.applyRLSAndCLS$default$1(), this.settings()).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BigQueryNativeJob $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Utils$.MODULE$.logException(this.$outer.logger(), A1);
                    throw new Exception(A1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return new BigQueryJobResult((Option<TableResult>)new Some((Object)results), Predef$.MODULE$.Long2long(totalBytesProcessed));
        });
    }

    public Try<Job> runBatchQuery() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            this.getOrCreateDataset();
            JobId jobId = JobId.newBuilder().setJob(UUID.randomUUID().toString()).setLocation(this.cliConfig().getLocation()).build();
            QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)$this.sql).setPriority(QueryJobConfiguration.Priority.BATCH).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).build();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Executing BQ Query {}", new Object[]{$this.sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Job job = BigQueryJobBase$.MODULE$.bigquery().create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(jobId).build(), new BigQuery.JobOption[0]);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Batch query wth jobId {} sent to BigQuery ", new Object[]{jobId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (job == null) {
                throw new Exception("Job not executed since it no longer exists.");
            }
            return job;
        });
    }

    public BigQueryNativeJob(BigQueryLoadConfig cliConfig, String sql, Option<String> udf, Settings settings) {
        BoxedUnit boxedUnit;
        this.cliConfig = cliConfig;
        this.sql = sql;
        this.udf = udf;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        BigQueryJobBase.$init$(this);
        this.projectId = ServiceOptions.getDefaultProjectId();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("BigQuery Config {}", new Object[]{cliConfig});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

