/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.validator;

import ai.starlake.config.CometColumns$;
import ai.starlake.config.PrivacyLevels$;
import ai.starlake.job.ingest.IngestionUtil$;
import ai.starlake.job.validator.GenericRowValidator;
import ai.starlake.job.validator.ValidationResult;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Format$DSV$;
import ai.starlake.schema.model.Format$POSITION$;
import ai.starlake.schema.model.Format$SIMPLE_JSON$;
import ai.starlake.schema.model.Rejection;
import ai.starlake.schema.model.Type;
import com.google.gson.Gson;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class FlatRowValidator$
implements GenericRowValidator {
    public static FlatRowValidator$ MODULE$;

    static {
        new FlatRowValidator$();
    }

    private String toOriginalFormat(Row row, Format format, String separator) {
        Format format2 = format;
        if (((Object)Format$DSV$.MODULE$).equals(format2)) {
            return ((TraversableOnce)((TraversableLike)row.toSeq().dropRight(1)).map((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.apply(x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> "").toString(), Seq$.MODULE$.canBuildFrom())).mkString(separator);
        }
        if (((Object)Format$SIMPLE_JSON$.MODULE$).equals(format2)) {
            Map rowAsMap = row.getValuesMap((Seq)Predef$.MODULE$.wrapRefArray((Object[])row.schema().fieldNames()));
            return new Gson().toJson((Object)rowAsMap.$minus((Object)CometColumns$.MODULE$.cometInputFileNameColumn()));
        }
        if (((Object)Format$POSITION$.MODULE$).equals(format2)) {
            return ((TraversableOnce)((TraversableLike)row.toSeq().dropRight(1)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Seq$.MODULE$.canBuildFrom())).mkString("");
        }
        throw new Exception("Should never happen");
    }

    @Override
    public ValidationResult validate(SparkSession session, Format format, String separator, Dataset<Row> dataset, List<Attribute> attributes, List<Type> types, StructType sparkType, Map<String, String> privacyOptions, StorageLevel cacheStorageLevel, boolean sinkReplayToFile) {
        Timestamp now = Timestamp.from(Instant.now());
        RDD checkedRDD = dataset.rdd().map((Function1 & Serializable & scala.Serializable)row -> {
            boolean validNumberOfColumns;
            LazyRef colMap$lzy = new LazyRef();
            Seq rowValues = (Seq)((TraversableLike)row.toSeq().zip((GenIterable)attributes, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object colValue = tuple2._1();
                    Attribute colAttribute = (Attribute)tuple2._2();
                    return new Tuple2((Object)Option$.MODULE$.apply(colValue).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString()), (Object)colAttribute);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            Seq rowCols = (Seq)rowValues.zip((GenIterable)types, Seq$.MODULE$.canBuildFrom());
            boolean bl = validNumberOfColumns = attributes.length() <= rowCols.length();
            if (!validNumberOfColumns) {
                List colResults = ((TraversableOnce)rowCols.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Type tpe = (Type)tuple2._2();
                        if (tuple22 != null) {
                            Option colRawValue = (Option)tuple22._1();
                            Attribute colAttribute = (Attribute)tuple22._2();
                            return new Rejection.ColResult(new Rejection.ColInfo((Option<String>)colRawValue, colAttribute.name(), tpe.name(), tpe.pattern(), false), "");
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }, Seq$.MODULE$.canBuildFrom())).toList();
                return new Rejection.RowResult((List<Rejection.ColResult>)colResults, false, (String)row.getAs(CometColumns$.MODULE$.cometInputFileNameColumn()), (Option<String>)new Some((Object)MODULE$.toOriginalFormat((Row)row, format, separator)));
            }
            List colResults = ((TraversableOnce)rowCols.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Type tpe = (Type)tuple2._2();
                    if (tuple22 != null) {
                        Option colRawValue = (Option)tuple22._1();
                        Attribute colAttribute = (Attribute)tuple22._2();
                        return IngestionUtil$.MODULE$.validateCol((Option<String>)colRawValue, colAttribute, tpe, (Function0<Map<String, Option<String>>>)(Function0 & Serializable & scala.Serializable)() -> FlatRowValidator$.colMap$1(colMap$lzy, rowValues), PrivacyLevels$.MODULE$.allPrivacyLevels(privacyOptions));
                    }
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).toList();
            boolean isRowAccepted = colResults.forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FlatRowValidator$.$anonfun$validate$8(x$4)));
            return new Rejection.RowResult((List<Rejection.ColResult>)colResults, isRowAccepted, (String)row.getAs(CometColumns$.MODULE$.cometInputFileNameColumn()), (Option<String>)(isRowAccepted || !sinkReplayToFile ? None$.MODULE$ : new Some((Object)MODULE$.toOriginalFormat((Row)row, format, separator))));
        }, ClassTag$.MODULE$.apply(Rejection.RowResult.class)).persist(cacheStorageLevel);
        RDD rejectedRDD = checkedRDD.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isRejected())).map((Function1 & Serializable & scala.Serializable)rowResult -> new Rejection.RowInfo(now, (List<Rejection.ColInfo>)((List)((List)rowResult.colResults().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)FlatRowValidator$.$anonfun$validate$11(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.colInfo(), List$.MODULE$.canBuildFrom())), rowResult.inputFileName()).toString(), ClassTag$.MODULE$.apply(String.class));
        RDD rejectedInputLinesRDD = checkedRDD.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isRejected())).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> Option$.MODULE$.option2Iterable(x$9.inputLine()), ClassTag$.MODULE$.apply(String.class));
        ExpressionEncoder enc = RowEncoder$.MODULE$.apply(sparkType);
        RDD acceptedRDD = checkedRDD.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isAccepted())).map((Function1 & Serializable & scala.Serializable)rowResult -> {
            List sparkValues = (List)rowResult.colResults().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.sparkValue(), List$.MODULE$.canBuildFrom());
            return new GenericRowWithSchema((Object[])sparkValues.toArray(ClassTag$.MODULE$.Any()), sparkType);
        }, ClassTag$.MODULE$.apply(Row.class));
        Dataset acceptedDS = session.createDataFrame(acceptedRDD, sparkType);
        Dataset rejectedDS = session.implicits().rddToDatasetHolder(rejectedRDD, session.implicits().newStringEncoder()).toDS();
        Dataset rejectedInputLinesDS = session.implicits().rddToDatasetHolder(rejectedInputLinesRDD, session.implicits().newStringEncoder()).toDS();
        return new ValidationResult((Dataset<String>)rejectedDS.persist(cacheStorageLevel), (Dataset<String>)rejectedInputLinesDS.persist(cacheStorageLevel), (Dataset<Row>)acceptedDS.persist(cacheStorageLevel));
    }

    private static final /* synthetic */ Map colMap$lzycompute$1(LazyRef colMap$lzy$1, Seq rowValues$1) {
        Map map;
        LazyRef lazyRef = colMap$lzy$1;
        synchronized (lazyRef) {
            map = colMap$lzy$1.initialized() ? (Map)colMap$lzy$1.value() : (Map)colMap$lzy$1.initialize((Object)((TraversableOnce)rowValues$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option colValue = (Option)tuple2._1();
                    Attribute colAttr = (Attribute)tuple2._2();
                    return new Tuple2((Object)colAttr.name(), (Object)colValue);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        return map;
    }

    private static final Map colMap$1(LazyRef colMap$lzy$1, Seq rowValues$1) {
        if (colMap$lzy$1.initialized()) {
            return (Map)colMap$lzy$1.value();
        }
        return FlatRowValidator$.colMap$lzycompute$1(colMap$lzy$1, rowValues$1);
    }

    public static final /* synthetic */ boolean $anonfun$validate$8(Rejection.ColResult x$4) {
        return x$4.colInfo().success();
    }

    public static final /* synthetic */ boolean $anonfun$validate$11(Rejection.ColResult x$6) {
        return !x$6.colInfo().success();
    }

    private FlatRowValidator$() {
        MODULE$ = this;
    }
}

