/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.repl;

import java.io.IOException;
import java.io.PrintWriter;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Main$ {
    public static Main$ MODULE$;

    static {
        new Main$();
    }

    public void usage() {
        System.out.println("Usage: java Example [none/simple/files/dictionary [trigger mask]]");
        System.out.println("  none - no completors");
        System.out.println("  simple - a simple completor that comples \"foo\", \"bar\", and \"baz\"");
        System.out.println("  files - a completor that comples file names");
        System.out.println("  classes - a completor that comples java class names");
        System.out.println("  trigger - a special word which causes it to assume the next line is a password");
        System.out.println("  mask - is the character to print in place of the actual password character");
        System.out.println("  color - colored prompt and feedback");
        System.out.println("\n  E.g - java Example simple su '*'\nwill use the simple compleator with 'su' triggering\nthe use of '*' as a password mask.");
    }

    public void main(String[] args) throws IOException {
        try {
            Character mask = null;
            String trigger = null;
            boolean color = false;
            ConsoleReader reader = new ConsoleReader();
            reader.setPrompt("prompt> ");
            if (args.length == 3) {
                mask = Predef$.MODULE$.char2Character(args[2].charAt(0));
                trigger = args[1];
            }
            reader.addCompleter((Completer)new StringsCompleter(new String[]{"foo", "bar", "baz"}));
            String line = reader.readLine();
            PrintWriter out = new PrintWriter(reader.getOutput());
            while (line != null) {
                if (color) {
                    out.println(new StringBuilder(18).append("\u001b[33m======>\u001b[0m\"").append(line).append("\"").toString());
                } else {
                    out.println(new StringBuilder(9).append("======>\"").append(line).append("\"").toString());
                }
                out.flush();
                if (trigger != null && line.compareTo(trigger) == 0) {
                    line = reader.readLine("password> ", mask);
                }
                Object object = line.equalsIgnoreCase("cls") ? BoxesRunTime.boxToBoolean((boolean)reader.clearScreen()) : BoxedUnit.UNIT;
                if (line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit")) {
                    System.exit(1);
                }
                line = reader.readLine();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Main$() {
        MODULE$ = this;
    }
}

