/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.generator;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.schema.generator.JDBC2Yml$;
import ai.starlake.schema.generator.JDBCSchema;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Domain$;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.MergeOptions;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.Mode;
import ai.starlake.schema.model.Partition;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.PrivacyLevel;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Schema$;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.Formatter$;
import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JDBCUtils$
implements LazyLogging {
    public static JDBCUtils$ MODULE$;
    private final scala.collection.immutable.Map<String, Object> sqlTypes;
    private final scala.collection.immutable.Map<Object, String> reverseSqlTypes;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new JDBCUtils$();
    }

    private Logger logger$lzycompute() {
        JDBCUtils$ jDBCUtils$ = this;
        synchronized (jDBCUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public scala.collection.immutable.Map<String, Object> sqlTypes() {
        return this.sqlTypes;
    }

    public scala.collection.immutable.Map<Object, String> reverseSqlTypes() {
        return this.reverseSqlTypes;
    }

    private <T> T withJDBCConnection(String connString, Function1<Connection, T> f, Settings settings) {
        Object object;
        Settings.Connection jdbcOptions = (Settings.Connection)settings.comet().connections().apply((Object)connString);
        Predef$.MODULE$.assert(jdbcOptions.options().contains((Object)"driver"), (Function0 & Serializable & scala.Serializable)() -> "driver class not found in JDBC connection options");
        Class.forName((String)jdbcOptions.options().apply((Object)"driver"));
        String string = jdbcOptions.format();
        String string2 = "jdbc";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        String url = (String)jdbcOptions.options().apply((Object)"url");
        Properties properties = new Properties();
        jdbcOptions.options().$minus((Object)"url").foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return properties.setProperty(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        Connection connection = DriverManager.getConnection(url, properties);
        try {
            Object result;
            object = result = f.apply((Object)connection);
        }
        catch (Throwable throwable) {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connection.close());
            if (try_ instanceof Success) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Closed connection to {}", new Object[]{connString});
                }
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new java.lang.StringBuilder(30).append("Could not close connection to ").append(connString).toString(), exception);
                }
            } else {
                throw new MatchError((Object)try_);
            }
            throw throwable;
        }
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connection.close());
        if (try_ instanceof Success) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Closed connection to {}", new Object[]{connString});
            }
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new java.lang.StringBuilder(30).append("Could not close connection to ").append(connString).toString(), exception);
            }
        } else {
            throw new MatchError((Object)try_);
        }
        return (T)object;
    }

    public boolean applyScript(String script, String connectionString, Settings settings) {
        return BoxesRunTime.unboxToBoolean(this.withJDBCConnection(connectionString, (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$applyScript$1(script, conn)), settings));
    }

    public Option<String> extractTableRemarks(JDBCSchema jdbcSchema, String table, Settings settings) {
        return jdbcSchema.tableRemarks().map((Function1 & Serializable & scala.Serializable)remarks -> {
            BoxedUnit boxedUnit;
            String sql = MODULE$.formatRemarksSQL(jdbcSchema, table, (String)remarks, settings);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Extracting table remarks using {}", new Object[]{sql});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (String)MODULE$.withJDBCConnection(jdbcSchema.connection(), (Function1 & Serializable & scala.Serializable)connection -> {
                BoxedUnit boxedUnit;
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery(sql);
                if (rs.next()) {
                    return rs.getString(1);
                }
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn("Not table remark found for table {}", new Object[]{table});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return "";
            }, settings);
        });
    }

    public Option<scala.collection.immutable.Map<String, String>> extractColumnRemarks(JDBCSchema jdbcSchema, String table, Settings settings) {
        return jdbcSchema.columnRemarks().map((Function1 & Serializable & scala.Serializable)remarks -> {
            BoxedUnit boxedUnit;
            String sql = MODULE$.formatRemarksSQL(jdbcSchema, table, (String)remarks, settings);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Extracting column remarks using {}", new Object[]{sql});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (scala.collection.immutable.Map)MODULE$.withJDBCConnection(jdbcSchema.connection(), (Function1 & Serializable & scala.Serializable)connection -> {
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery(sql);
                Map res = Map$.MODULE$.empty();
                while (rs.next()) {
                    res.put((Object)rs.getString(1), (Object)rs.getString(2));
                }
                return res.toMap(Predef$.MODULE$.$conforms());
            }, settings);
        });
    }

    public scala.collection.immutable.Map<String, Tuple3<String, List<Attribute>, List<String>>> extractJDBCTables(JDBCSchema jdbcSchema, Settings settings) {
        return (scala.collection.immutable.Map)this.withJDBCConnection(jdbcSchema.connection(), (Function1 & Serializable & scala.Serializable)connection -> {
            BoxedUnit boxedUnit;
            scala.collection.immutable.Map selectedTables;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            scala.collection.immutable.Map jdbcTableMap = ((TraversableOnce)jdbcSchema.tables().map((Function1 & Serializable & scala.Serializable)tblSchema -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tblSchema.name().toUpperCase()), tblSchema), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List tableNames = jdbcTableMap.keys().toList();
            List list = tableNames;
            scala.collection.immutable.Map map = Nil$.MODULE$.equals(list) ? JDBCUtils$.extractTables$1(JDBCUtils$.extractTables$default$1$1(), databaseMetaData, jdbcSchema, settings) : (selectedTables = list.contains((Object)"*") ? JDBCUtils$.extractTables$1(JDBCUtils$.extractTables$default$1$1(), databaseMetaData, jdbcSchema, settings) : JDBCUtils$.extractTables$1(list, databaseMetaData, jdbcSchema, settings));
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                selectedTables.keys().foreach((Function1 & Serializable & scala.Serializable)table -> {
                    JDBCUtils$.$anonfun$extractJDBCTables$4(table);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            scala.collection.immutable.Map selectedTablesAndColumns = (scala.collection.immutable.Map)selectedTables.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    List selectedColumns;
                    BoxedUnit boxedUnit2;
                    String tableName = (String)tuple2._1();
                    String tableRemarks = (String)tuple2._2();
                    ResultSet foreignKeysResultSet = databaseMetaData.getImportedKeys((String)jdbcSchema.catalog().orNull(Predef$.MODULE$.$conforms()), jdbcSchema.schema(), tableName);
                    scala.collection.immutable.Map foreignKeys = new Iterator<Tuple2<String, String>>(foreignKeysResultSet){
                        private final ResultSet foreignKeysResultSet$1;

                        public Iterator<Tuple2<String, String>> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.isTraversableAgain$((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public Iterator<Tuple2<String, String>> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<Tuple2<String, String>> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<Tuple2<String, String>> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<Tuple2<String, String>> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<Tuple2<String, String>, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.$plus$plus$((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<Tuple2<String, String>, GenTraversableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public Iterator<Tuple2<String, String>> filter(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<String, String>, B, Object> p) {
                            return Iterator.corresponds$((Iterator)this, that, p);
                        }

                        public Iterator<Tuple2<String, String>> withFilter(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public Iterator<Tuple2<String, String>> filterNot(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<Tuple2<String, String>, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<String, String>, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<Tuple2<String, String>, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public Iterator<Tuple2<String, String>> takeWhile(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<Tuple2<String, String>>, Iterator<Tuple2<String, String>>> partition(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<Tuple2<String, String>>, Iterator<Tuple2<String, String>>> span(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<Tuple2<String, String>> dropWhile(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<Tuple2<String, String>, B>> zip(Iterator<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<Tuple2<String, String>, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<Tuple2<String, String>, U> f) {
                            Iterator.foreach$((Iterator)this, f);
                        }

                        public boolean forall(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.forall$((Iterator)this, p);
                        }

                        public boolean exists(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.exists$((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public Option<Tuple2<String, String>> find(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.find$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<Tuple2<String, String>, Object> p) {
                            return Iterator.indexWhere$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<Tuple2<String, String>, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public BufferedIterator<Tuple2<String, String>> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public Tuple2<Iterator<Tuple2<String, String>>, Iterator<Tuple2<String, String>>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Traversable<Tuple2<String, String>> toTraversable() {
                            return Iterator.toTraversable$((Iterator)this);
                        }

                        public Iterator<Tuple2<String, String>> toIterator() {
                            return Iterator.toIterator$((Iterator)this);
                        }

                        public Stream<Tuple2<String, String>> toStream() {
                            return Iterator.toStream$((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public List<Tuple2<String, String>> reversed() {
                            return TraversableOnce.reversed$((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.size$((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.nonEmpty$((TraversableOnce)this);
                        }

                        public int count(Function1<Tuple2<String, String>, Object> p) {
                            return TraversableOnce.count$((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<Tuple2<String, String>, B> pf) {
                            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, Tuple2<String, String>, B> op) {
                            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<Tuple2<String, String>, B, B> op) {
                            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, Tuple2<String, String>, B> op) {
                            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<Tuple2<String, String>, B, B> op) {
                            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, Tuple2<String, String>, B> op) {
                            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<Tuple2<String, String>, B, B> op) {
                            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<String, String>, B> op) {
                            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<Tuple2<String, String>, B, B> op) {
                            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<String, String>, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.product$((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                        }

                        public List<Tuple2<String, String>> toList() {
                            return TraversableOnce.toList$((TraversableOnce)this);
                        }

                        public Iterable<Tuple2<String, String>> toIterable() {
                            return TraversableOnce.toIterable$((TraversableOnce)this);
                        }

                        public Seq<Tuple2<String, String>> toSeq() {
                            return TraversableOnce.toSeq$((TraversableOnce)this);
                        }

                        public IndexedSeq<Tuple2<String, String>> toIndexedSeq() {
                            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.toBuffer$((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.toSet$((TraversableOnce)this);
                        }

                        public Vector<Tuple2<String, String>> toVector() {
                            return TraversableOnce.toVector$((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<String, String>, Col> cbf) {
                            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                        }

                        public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Tuple2<String, String>, Tuple2<T, U>> ev) {
                            return TraversableOnce.toMap$((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.mkString$((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                        }

                        public int sizeHintIfCheap() {
                            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                        }

                        public boolean hasNext() {
                            return this.foreignKeysResultSet$1.next();
                        }

                        public Tuple2<String, String> next() {
                            String pkSchemaName = this.foreignKeysResultSet$1.getString("PKTABLE_SCHEM");
                            String pkTableName = this.foreignKeysResultSet$1.getString("PKTABLE_NAME");
                            String pkColumnName = this.foreignKeysResultSet$1.getString("PKCOLUMN_NAME");
                            String fkColumnName = this.foreignKeysResultSet$1.getString("FKCOLUMN_NAME").toUpperCase();
                            String pkCompositeName = pkSchemaName == null ? new java.lang.StringBuilder(1).append(pkTableName).append(".").append(pkColumnName).toString() : new java.lang.StringBuilder(2).append(pkSchemaName).append(".").append(pkTableName).append(".").append(pkColumnName).toString();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fkColumnName), (Object)pkCompositeName);
                        }
                        {
                            this.foreignKeysResultSet$1 = foreignKeysResultSet$1;
                            GenTraversableOnce.$init$((GenTraversableOnce)this);
                            TraversableOnce.$init$((TraversableOnce)this);
                            Iterator.$init$((Iterator)this);
                        }
                    }.toMap(Predef$.MODULE$.$conforms());
                    ResultSet columnsResultSet = databaseMetaData.getColumns((String)jdbcSchema.catalog().orNull(Predef$.MODULE$.$conforms()), jdbcSchema.schema(), tableName, null);
                    scala.collection.immutable.Map remarks = (scala.collection.immutable.Map)MODULE$.extractColumnRemarks(jdbcSchema, tableName, settings).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
                    ListBuffer attrs = (ListBuffer)new Iterator<Attribute>(columnsResultSet, tableName, remarks, foreignKeys){
                        private final ResultSet columnsResultSet$1;
                        private final String tableName$1;
                        private final scala.collection.immutable.Map remarks$1;
                        private final scala.collection.immutable.Map foreignKeys$1;

                        public Iterator<Attribute> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.isTraversableAgain$((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public Iterator<Attribute> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<Attribute> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<Attribute> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<Attribute> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<Attribute, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.$plus$plus$((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<Attribute, GenTraversableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public Iterator<Attribute> filter(Function1<Attribute, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Attribute, B, Object> p) {
                            return Iterator.corresponds$((Iterator)this, that, p);
                        }

                        public Iterator<Attribute> withFilter(Function1<Attribute, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public Iterator<Attribute> filterNot(Function1<Attribute, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<Attribute, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, Attribute, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<Attribute, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public Iterator<Attribute> takeWhile(Function1<Attribute, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<Attribute>, Iterator<Attribute>> partition(Function1<Attribute, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<Attribute>, Iterator<Attribute>> span(Function1<Attribute, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<Attribute> dropWhile(Function1<Attribute, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<Attribute, B>> zip(Iterator<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<Attribute, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<Attribute, U> f) {
                            Iterator.foreach$((Iterator)this, f);
                        }

                        public boolean forall(Function1<Attribute, Object> p) {
                            return Iterator.forall$((Iterator)this, p);
                        }

                        public boolean exists(Function1<Attribute, Object> p) {
                            return Iterator.exists$((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public Option<Attribute> find(Function1<Attribute, Object> p) {
                            return Iterator.find$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<Attribute, Object> p) {
                            return Iterator.indexWhere$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<Attribute, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public BufferedIterator<Attribute> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public Tuple2<Iterator<Attribute>, Iterator<Attribute>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Traversable<Attribute> toTraversable() {
                            return Iterator.toTraversable$((Iterator)this);
                        }

                        public Iterator<Attribute> toIterator() {
                            return Iterator.toIterator$((Iterator)this);
                        }

                        public Stream<Attribute> toStream() {
                            return Iterator.toStream$((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public List<Attribute> reversed() {
                            return TraversableOnce.reversed$((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.size$((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.nonEmpty$((TraversableOnce)this);
                        }

                        public int count(Function1<Attribute, Object> p) {
                            return TraversableOnce.count$((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<Attribute, B> pf) {
                            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, Attribute, B> op) {
                            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<Attribute, B, B> op) {
                            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, Attribute, B> op) {
                            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<Attribute, B, B> op) {
                            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, Attribute, B> op) {
                            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<Attribute, B, B> op) {
                            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, Attribute, B> op) {
                            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<Attribute, B, B> op) {
                            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, Attribute, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.product$((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                        }

                        public List<Attribute> toList() {
                            return TraversableOnce.toList$((TraversableOnce)this);
                        }

                        public Iterable<Attribute> toIterable() {
                            return TraversableOnce.toIterable$((TraversableOnce)this);
                        }

                        public Seq<Attribute> toSeq() {
                            return TraversableOnce.toSeq$((TraversableOnce)this);
                        }

                        public IndexedSeq<Attribute> toIndexedSeq() {
                            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.toBuffer$((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.toSet$((TraversableOnce)this);
                        }

                        public Vector<Attribute> toVector() {
                            return TraversableOnce.toVector$((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, Attribute, Col> cbf) {
                            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                        }

                        public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Attribute, Tuple2<T, U>> ev) {
                            return TraversableOnce.toMap$((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.mkString$((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                        }

                        public int sizeHintIfCheap() {
                            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                        }

                        public boolean hasNext() {
                            return this.columnsResultSet$1.next();
                        }

                        public Attribute next() {
                            BoxedUnit boxedUnit;
                            String colName = this.columnsResultSet$1.getString("COLUMN_NAME");
                            if (JDBCUtils$.MODULE$.logger().underlying().isInfoEnabled()) {
                                JDBCUtils$.MODULE$.logger().underlying().info("COLUMN_NAME={}.{}", new Object[]{this.tableName$1, colName});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            int colType = this.columnsResultSet$1.getInt("DATA_TYPE");
                            String colTypename = this.columnsResultSet$1.getString("TYPE_NAME");
                            String colRemarks = (String)this.remarks$1.getOrElse((Object)colName, (Function0 & Serializable & scala.Serializable)() -> $this.columnsResultSet$1.getString("REMARKS"));
                            boolean colRequired = this.columnsResultSet$1.getString("IS_NULLABLE").equals("NO");
                            Option foreignKey = this.foreignKeys$1.get((Object)colName.toUpperCase());
                            String x$1 = colName;
                            String x$2 = JDBCUtils$.MODULE$.ai$starlake$schema$generator$JDBCUtils$$sparkType(colType, this.tableName$1, colName, colTypename);
                            boolean x$3 = colRequired;
                            Option x$4 = Option$.MODULE$.apply((Object)colRemarks);
                            Option x$5 = foreignKey;
                            Option<Object> x$6 = Attribute$.MODULE$.apply$default$3();
                            PrivacyLevel x$7 = Attribute$.MODULE$.apply$default$5();
                            Option<String> x$8 = Attribute$.MODULE$.apply$default$7();
                            Option<MetricType> x$9 = Attribute$.MODULE$.apply$default$8();
                            Option<List<Attribute>> x$10 = Attribute$.MODULE$.apply$default$9();
                            Option<Position> x$11 = Attribute$.MODULE$.apply$default$10();
                            Option<String> x$12 = Attribute$.MODULE$.apply$default$11();
                            Option<Set<String>> x$13 = Attribute$.MODULE$.apply$default$12();
                            Option<Trim> x$14 = Attribute$.MODULE$.apply$default$13();
                            Option<String> x$15 = Attribute$.MODULE$.apply$default$14();
                            Option<Object> x$16 = Attribute$.MODULE$.apply$default$16();
                            Option<String> x$17 = Attribute$.MODULE$.apply$default$17();
                            return new Attribute(x$1, x$2, x$6, x$3, x$7, (Option<String>)x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$5, x$16, x$17);
                        }
                        {
                            this.columnsResultSet$1 = columnsResultSet$1;
                            this.tableName$1 = tableName$1;
                            this.remarks$1 = remarks$1;
                            this.foreignKeys$1 = foreignKeys$1;
                            GenTraversableOnce.$init$((GenTraversableOnce)this);
                            TraversableOnce.$init$((TraversableOnce)this);
                            Iterator.$init$((Iterator)this);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1(ai.starlake.schema.generator.JDBCUtils$$anon$2 )}, serializedLambda);
                        }
                    }.to(ListBuffer$.MODULE$.canBuildFrom());
                    scala.collection.immutable.Iterable columns = (scala.collection.immutable.Iterable)attrs.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            ListBuffer uniqAttr = (ListBuffer)tuple2._2();
                            return (Attribute)uniqAttr.head();
                        }
                        throw new MatchError((Object)tuple2);
                    }, Iterable$.MODULE$.canBuildFrom());
                    if (MODULE$.logger().underlying().isDebugEnabled()) {
                        columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                            JDBCUtils$.$anonfun$extractJDBCTables$9(tableName, column);
                            return BoxedUnit.UNIT;
                        });
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    List currentTableRequestedColumns = (List)jdbcTableMap.get((Object)tableName).map((Function1 & Serializable & scala.Serializable)x$3 -> (List)((List)x$3.columns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toUpperCase(), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                    List list = selectedColumns = currentTableRequestedColumns.isEmpty() ? columns.toList() : (List)columns.toList().filter((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)currentTableRequestedColumns.contains((Object)col.name().toUpperCase())));
                    if (MODULE$.logger().underlying().isDebugEnabled()) {
                        columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                            JDBCUtils$.$anonfun$extractJDBCTables$15(tableName, column);
                            return BoxedUnit.UNIT;
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    ResultSet primaryKeysResultSet = databaseMetaData.getPrimaryKeys((String)jdbcSchema.catalog().orNull(Predef$.MODULE$.$conforms()), jdbcSchema.schema(), tableName);
                    List<String> primaryKeys = new Iterator<String>(primaryKeysResultSet){
                        private final ResultSet primaryKeysResultSet$1;

                        public Iterator<String> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.isTraversableAgain$((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public Iterator<String> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<String> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<String> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<String> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<String, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.$plus$plus$((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public Iterator<String> filter(Function1<String, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
                            return Iterator.corresponds$((Iterator)this, that, p);
                        }

                        public Iterator<String> withFilter(Function1<String, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public Iterator<String> filterNot(Function1<String, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public Iterator<String> takeWhile(Function1<String, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<String> dropWhile(Function1<String, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<String, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<String, U> f) {
                            Iterator.foreach$((Iterator)this, f);
                        }

                        public boolean forall(Function1<String, Object> p) {
                            return Iterator.forall$((Iterator)this, p);
                        }

                        public boolean exists(Function1<String, Object> p) {
                            return Iterator.exists$((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public Option<String> find(Function1<String, Object> p) {
                            return Iterator.find$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<String, Object> p) {
                            return Iterator.indexWhere$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<String, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public BufferedIterator<String> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Traversable<String> toTraversable() {
                            return Iterator.toTraversable$((Iterator)this);
                        }

                        public Iterator<String> toIterator() {
                            return Iterator.toIterator$((Iterator)this);
                        }

                        public Stream<String> toStream() {
                            return Iterator.toStream$((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public List<String> reversed() {
                            return TraversableOnce.reversed$((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.size$((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.nonEmpty$((TraversableOnce)this);
                        }

                        public int count(Function1<String, Object> p) {
                            return TraversableOnce.count$((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, String, B> op) {
                            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, String, B> op) {
                            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<String, B, B> op) {
                            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, String, B> op) {
                            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<String, B, B> op) {
                            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.product$((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                        }

                        public List<String> toList() {
                            return TraversableOnce.toList$((TraversableOnce)this);
                        }

                        public Iterable<String> toIterable() {
                            return TraversableOnce.toIterable$((TraversableOnce)this);
                        }

                        public Seq<String> toSeq() {
                            return TraversableOnce.toSeq$((TraversableOnce)this);
                        }

                        public IndexedSeq<String> toIndexedSeq() {
                            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.toBuffer$((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.toSet$((TraversableOnce)this);
                        }

                        public Vector<String> toVector() {
                            return TraversableOnce.toVector$((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
                            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                        }

                        public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<String, Tuple2<T, U>> ev) {
                            return TraversableOnce.toMap$((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.mkString$((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                        }

                        public int sizeHintIfCheap() {
                            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                        }

                        public boolean hasNext() {
                            return this.primaryKeysResultSet$1.next();
                        }

                        public String next() {
                            return this.primaryKeysResultSet$1.getString("COLUMN_NAME");
                        }
                        {
                            this.primaryKeysResultSet$1 = primaryKeysResultSet$1;
                            GenTraversableOnce.$init$((GenTraversableOnce)this);
                            TraversableOnce.$init$((TraversableOnce)this);
                            Iterator.$init$((Iterator)this);
                        }
                    }.toList();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)new Tuple3((Object)tableRemarks, (Object)selectedColumns, primaryKeys));
                }
                throw new MatchError((Object)tuple2);
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            return selectedTablesAndColumns;
        }, settings);
    }

    private String formatRemarksSQL(JDBCSchema jdbcSchema, String table, String remarks, Settings settings) {
        String sql = Formatter$.MODULE$.RichFormatter(remarks).richFormat((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalog"), jdbcSchema.catalog().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)jdbcSchema.schema()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table)}))), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), settings);
        return sql;
    }

    public Domain extractDomain(JDBCSchema jdbcSchema, Option<Domain> domainTemplate, scala.collection.immutable.Map<String, Tuple3<String, List<Attribute>, List<String>>> selectedTablesAndColumns) {
        Option domainMetadata = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.metadata());
        Option patternTemplate = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.tables().headOption().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.pattern()));
        Option trimTemplate = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.tables().headOption().flatMap((Function1 & Serializable & scala.Serializable)x$9 -> ((Attribute)x$9.attributes().head()).trim()));
        scala.collection.immutable.Iterable cometSchema = (scala.collection.immutable.Iterable)selectedTablesAndColumns.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String tableName = (String)tuple2._1();
                Tuple3 tuple3 = (Tuple3)tuple2._2();
                if (tuple3 != null) {
                    String tableRemarks = (String)tuple3._1();
                    List selectedColumns = (List)tuple3._2();
                    List primaryKeys = (List)tuple3._3();
                    String x$18 = tableName;
                    Pattern x$19 = Pattern.compile(new java.lang.StringBuilder(2).append(tableName).append(".*").toString());
                    List x$20 = (List)selectedColumns.map((Function1 & Serializable & scala.Serializable)x$10 -> {
                        Option x$1 = trimTemplate;
                        String x$2 = x$10.copy$default$1();
                        String x$3 = x$10.copy$default$2();
                        Option<Object> x$4 = x$10.copy$default$3();
                        boolean x$5 = x$10.copy$default$4();
                        PrivacyLevel x$6 = x$10.copy$default$5();
                        Option<String> x$7 = x$10.copy$default$6();
                        Option<String> x$8 = x$10.copy$default$7();
                        Option<MetricType> x$9 = x$10.copy$default$8();
                        Option<List<Attribute>> x$102 = x$10.copy$default$9();
                        Option<Position> x$11 = x$10.copy$default$10();
                        Option<String> x$12 = x$10.copy$default$11();
                        Option<Set<String>> x$13 = x$10.copy$default$12();
                        Option<String> x$14 = x$10.copy$default$14();
                        Option<String> x$15 = x$10.copy$default$15();
                        Option<Object> x$16 = x$10.copy$default$16();
                        Option<String> x$17 = x$10.copy$default$17();
                        return x$10.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$102, x$11, x$12, x$13, (Option<Trim>)x$1, x$14, x$15, x$16, x$17);
                    }, List$.MODULE$.canBuildFrom());
                    None$ x$21 = None$.MODULE$;
                    None$ x$22 = None$.MODULE$;
                    Option x$23 = Option$.MODULE$.apply((Object)tableRemarks);
                    None$ x$24 = None$.MODULE$;
                    None$ x$25 = None$.MODULE$;
                    None$ x$26 = primaryKeys.isEmpty() ? None$.MODULE$ : new Some((Object)primaryKeys);
                    Option<Set<String>> x$27 = Schema$.MODULE$.apply$default$9();
                    Option<List<RowLevelSecurity>> x$28 = Schema$.MODULE$.apply$default$10();
                    Option<scala.collection.immutable.Map<String, String>> x$29 = Schema$.MODULE$.apply$default$11();
                    Option<List<AccessControlEntry>> x$30 = Schema$.MODULE$.apply$default$13();
                    Option<String> x$31 = Schema$.MODULE$.apply$default$14();
                    return new Schema(x$18, x$19, (List<Attribute>)x$20, (Option<Metadata>)x$21, (Option<MergeOptions>)x$22, (Option<String>)x$23, (Option<List<String>>)x$24, (Option<List<String>>)x$25, x$27, x$28, x$29, (Option<List<String>>)x$26, x$30, x$31);
                }
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        String domainName = jdbcSchema.schema().replaceAll("[^\\p{Alnum}]", "_");
        String incomingDir = (String)domainTemplate.map((Function1 & Serializable & scala.Serializable)dom -> DatasetArea$.MODULE$.substituteDomainAndSchemaInPath(domainName, "", dom.resolveDirectory()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(1).append("/").append(jdbcSchema.schema()).toString());
        Option extensions = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.resolveExtensions());
        Option ack = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.resolveAck());
        String x$53 = domainName;
        Option x$54 = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.metadata()).map((Function1 & Serializable & scala.Serializable)x$14 -> {
            Some x$32 = new Some((Object)incomingDir);
            Option x$33 = extensions;
            Option x$34 = ack;
            Option<Mode> x$35 = x$14.copy$default$1();
            Option<Format> x$36 = x$14.copy$default$2();
            Option<String> x$37 = x$14.copy$default$3();
            Option<Object> x$38 = x$14.copy$default$4();
            Option<Object> x$39 = x$14.copy$default$5();
            Option<Object> x$40 = x$14.copy$default$6();
            Option<String> x$41 = x$14.copy$default$7();
            Option<String> x$42 = x$14.copy$default$8();
            Option<String> x$43 = x$14.copy$default$9();
            Option<WriteMode> x$44 = x$14.copy$default$10();
            Option<Partition> x$45 = x$14.copy$default$11();
            Option<Sink> x$46 = x$14.copy$default$12();
            Option<String> x$47 = x$14.copy$default$13();
            Option<Seq<String>> x$48 = x$14.copy$default$14();
            Option<scala.collection.immutable.Map<String, String>> x$49 = x$14.copy$default$15();
            Option<scala.collection.immutable.Map<String, String>> x$50 = x$14.copy$default$19();
            Option<String> x$51 = x$14.copy$default$20();
            Option<scala.collection.immutable.Map<String, String>> x$52 = x$14.copy$default$21();
            return x$14.copy(x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, (Option<String>)x$32, (Option<List<String>>)x$33, (Option<String>)x$34, x$50, x$51, x$52);
        });
        None$ x$55 = None$.MODULE$;
        List x$56 = cometSchema.toList();
        None$ x$57 = None$.MODULE$;
        None$ x$58 = None$.MODULE$;
        None$ x$59 = None$.MODULE$;
        Option<String> x$60 = Domain$.MODULE$.apply$default$2();
        Option<Set<String>> x$61 = Domain$.MODULE$.apply$default$9();
        Option<String> x$62 = Domain$.MODULE$.apply$default$10();
        return new Domain(x$53, x$60, (Option<Metadata>)x$54, (Option<List<String>>)x$55, (List<Schema>)x$56, (Option<String>)x$57, (Option<List<String>>)x$58, (Option<String>)x$59, x$61, x$62);
    }

    public String ai$starlake$schema$generator$JDBCUtils$$sparkType(int jdbcType, String tableName, String colName, String colTypename) {
        BoxedUnit boxedUnit;
        String sqlType = (String)this.reverseSqlTypes().getOrElse((Object)BoxesRunTime.boxToInteger((int)jdbcType), (Function0 & Serializable & scala.Serializable)() -> colTypename);
        int n = jdbcType;
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return "string";
            }
            case -7: 
            case 16: {
                return "boolean";
            }
            case 6: 
            case 7: 
            case 8: {
                return "double";
            }
            case 2: 
            case 3: {
                return "decimal";
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "long";
            }
            case 91: {
                return "date";
            }
            case 93: {
                return "timestamp";
            }
            case 2014: {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("forced conversion for {}.{} from {} to timestamp", new Object[]{tableName, colName, sqlType});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return "timestamp";
            }
            case -3: 
            case -2: {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("forced conversion for {}.{} from {} to string", new Object[]{tableName, colName, sqlType});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                return "string";
            }
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Make sure user defined type  {} is defined. Context: {}.{}  -> {} ({})", new Object[]{colTypename, tableName, colName, sqlType, BoxesRunTime.boxToInteger((int)jdbcType)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return colTypename;
    }

    public void extractData(JDBCSchema jdbcSchema, File baseOutputDir, int limit, String separator, Settings settings) {
        String domainName = jdbcSchema.schema().replaceAll("[^\\p{Alnum}]", "_");
        File outputDir = File$.MODULE$.apply(baseOutputDir, domainName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        outputDir.createDirectories(outputDir.createDirectories$default$1(), outputDir.createDirectories$default$2());
        scala.collection.immutable.Map<String, Tuple3<String, List<Attribute>, List<String>>> selectedTablesAndColumns = this.extractJDBCTables(jdbcSchema, settings);
        selectedTablesAndColumns.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String tableName = (String)tuple2._1();
                Tuple3 tuple3 = (Tuple3)tuple2._2();
                if (tuple3 != null) {
                    BoxedUnit boxedUnit;
                    List selectedColumns = (List)tuple3._2();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
                    String dateTime = formatter.format(Instant.now());
                    File outFile = File$.MODULE$.apply(outputDir, new java.lang.StringBuilder(5).append(tableName).append("-").append(dateTime).append(".csv").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    String cols = ((TraversableOnce)selectedColumns.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), List$.MODULE$.canBuildFrom())).mkString(",");
                    String headers = ((TraversableOnce)selectedColumns.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.name(), List$.MODULE$.canBuildFrom())).mkString(";");
                    if (MODULE$.logger().underlying().isInfoEnabled()) {
                        MODULE$.logger().underlying().info("Exporting data to file {}", new Object[]{outFile.pathAsString()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    File qual$1 = outFile.parent();
                    Seq x$1 = qual$1.createDirectories$default$1();
                    Seq x$2 = qual$1.createDirectories$default$2();
                    qual$1.createDirectories(x$1, x$2);
                    outFile.delete(true, outFile.delete$default$2());
                    FileWriter outFileWriter = outFile.newFileWriter(false);
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        outFileWriter.append(new java.lang.StringBuilder(1).append(headers).append("\n").toString());
                        String sql = new java.lang.StringBuilder(14).append("select ").append(cols).append(" from ").append(jdbcSchema.schema()).append(".").append(tableName).toString();
                        MODULE$.withJDBCConnection(jdbcSchema.connection(), (Function1 & Serializable & scala.Serializable)connection -> {
                            JDBCUtils$.$anonfun$extractData$5(limit, sql, separator, outFileWriter, connection);
                            return BoxedUnit.UNIT;
                        }, settings);
                    });
                    if (try_ instanceof Success) {
                        outFileWriter.close();
                        return BoxedUnit.UNIT;
                    }
                    if (try_ instanceof Failure) {
                        outFileWriter.close();
                        return outFile.delete(true, outFile.delete$default$2());
                    }
                    throw new MatchError((Object)try_);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void main(String[] args) {
        JDBC2Yml$.MODULE$.run(args);
    }

    public static final /* synthetic */ boolean $anonfun$applyScript$1(String script$1, Connection conn) {
        return conn.createStatement().execute(script$1);
    }

    private static final scala.collection.immutable.Map extractTables$1(List tablesToExtract, DatabaseMetaData databaseMetaData$1, JDBCSchema jdbcSchema$3, Settings settings$3) {
        Map tableNames = Map$.MODULE$.empty();
        ResultSet resultSet = databaseMetaData$1.getTables((String)jdbcSchema$3.catalog().orNull(Predef$.MODULE$.$conforms()), jdbcSchema$3.schema(), "%", (String[])jdbcSchema$3.tableTypes().toArray(ClassTag$.MODULE$.apply(String.class)));
        while (resultSet.next()) {
            BoxedUnit boxedUnit;
            String tableName = resultSet.getString("TABLE_NAME");
            if (tablesToExtract.isEmpty() || tablesToExtract.contains((Object)tableName.toUpperCase())) {
                BoxedUnit boxedUnit2;
                Option<String> _remarks = MODULE$.extractTableRemarks(jdbcSchema$3, tableName, settings$3);
                String remarks = (String)_remarks.getOrElse((Function0 & Serializable & scala.Serializable)() -> resultSet.getString("REMARKS"));
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Extracting table {}: {}", new Object[]{tableName, remarks});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = tableNames.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)remarks));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        resultSet.close();
        return tableNames.toMap(Predef$.MODULE$.$conforms());
    }

    private static final List extractTables$default$1$1() {
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$4(String table) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Selected: {}", new Object[]{table});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$9(String tableName$1, Attribute column) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("column: {}.{}", new Object[]{tableName$1, column.name()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$15(String tableName$1, Attribute column) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("Final schema column: {}.{}", new Object[]{tableName$1, column.name()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$extractData$5(int limit$1, String sql$3, String separator$1, FileWriter outFileWriter$1, Connection connection) {
        Statement statement = connection.createStatement();
        statement.setMaxRows(limit$1);
        ResultSet rs = statement.executeQuery(sql$3);
        ResultSetMetaData rsMetadata = rs.getMetaData();
        while (rs.next()) {
            ListBuffer colList = (ListBuffer)ListBuffer$.MODULE$.empty();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsMetadata.getColumnCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)icol -> {
                String string;
                int sqlType;
                Option obj = Option$.MODULE$.apply(rs.getObject(icol));
                int n = sqlType = rsMetadata.getColumnType(icol);
                switch (n) {
                    case 12: {
                        string = rs.getString(icol);
                        break;
                    }
                    case 0: {
                        string = "null";
                        break;
                    }
                    case 1: {
                        string = new java.lang.StringBuilder(2).append("\"").append(obj.map((Function1 & Serializable & scala.Serializable)x$17 -> rs.getString(icol)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\"").toString();
                        break;
                    }
                    case 93: {
                        string = new java.lang.StringBuilder(2).append("\"").append(obj.map((Function1 & Serializable & scala.Serializable)x$18 -> rs.getTimestamp(icol).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\"").toString();
                        break;
                    }
                    case 8: {
                        string = (String)obj.map((Function1 & Serializable & scala.Serializable)x$19 -> Double.toString(rs.getDouble(icol))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                        break;
                    }
                    case 4: {
                        string = (String)obj.map((Function1 & Serializable & scala.Serializable)x$20 -> Integer.toString(rs.getInt(icol))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                        break;
                    }
                    case 5: {
                        string = (String)obj.map((Function1 & Serializable & scala.Serializable)x$21 -> Integer.toString(rs.getInt(icol))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                        break;
                    }
                    case 3: {
                        string = (String)obj.map((Function1 & Serializable & scala.Serializable)x$22 -> rs.getBigDecimal(icol).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                        break;
                    }
                    default: {
                        string = new java.lang.StringBuilder(2).append("\"").append(obj.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\"").toString();
                        break;
                    }
                }
                String colValue = string;
                colList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{colValue}));
            });
            String rowString = colList.mkString(separator$1);
            outFileWriter$1.append(new java.lang.StringBuilder(1).append(rowString).append("\n").toString());
        }
    }

    private JDBCUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.sqlTypes = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BIT"), (Object)BoxesRunTime.boxToInteger((int)-7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TINYINT"), (Object)BoxesRunTime.boxToInteger((int)-6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SMALLINT"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INTEGER"), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BIGINT"), (Object)BoxesRunTime.boxToInteger((int)-5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FLOAT"), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"REAL"), (Object)BoxesRunTime.boxToInteger((int)7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DOUBLE"), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NUMERIC"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DECIMAL"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CHAR"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"VARCHAR"), (Object)BoxesRunTime.boxToInteger((int)12)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LONGVARCHAR"), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DATE"), (Object)BoxesRunTime.boxToInteger((int)91)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIME"), (Object)BoxesRunTime.boxToInteger((int)92)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIMESTAMP"), (Object)BoxesRunTime.boxToInteger((int)93)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BINARY"), (Object)BoxesRunTime.boxToInteger((int)-2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"VARBINARY"), (Object)BoxesRunTime.boxToInteger((int)-3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LONGVARBINARY"), (Object)BoxesRunTime.boxToInteger((int)-4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NULL"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"OTHER"), (Object)BoxesRunTime.boxToInteger((int)1111)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BOOLEAN"), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NVARCHAR"), (Object)BoxesRunTime.boxToInteger((int)-9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NCHAR"), (Object)BoxesRunTime.boxToInteger((int)-15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LONGNVARCHAR"), (Object)BoxesRunTime.boxToInteger((int)-16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIME_WITH_TIMEZONE"), (Object)BoxesRunTime.boxToInteger((int)2013)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIMESTAMP_WITH_TIMEZONE"), (Object)BoxesRunTime.boxToInteger((int)2014))}));
        this.reverseSqlTypes = (scala.collection.immutable.Map)this.sqlTypes().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }
}

