/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.handlers;

import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.utils.conversion.Conversions$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u0011\"\u0001)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0006\u0005\")\u0001\n\u0001C\u0001\u0013\"9a\n\u0001b\u0001\n\u0003y\u0005BB.\u0001A\u0003%\u0001\u000b\u0003\u0005]\u0001!\u0015\r\u0011\"\u0001^\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015A\u0007\u0001\"\u0011`\u0011\u001dI\u0007A1A\u0005\u0002)Da\u0001\u001d\u0001!\u0002\u0013Y\u0007\"B9\u0001\t\u0003\u0011\b\"B>\u0001\t\u0003a\b\"\u0002@\u0001\t\u0003y\bbBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002\u0006\u0002!\t%a\"\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u0003G\u0003A\u0011IAS\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!a.\u0001\t\u0003\nI\fC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005/\u0001A\u0011\tB\r\u0011\u001d\u00119\u0003\u0001C!\u0005SAqA!\f\u0001\t\u0003\u0012yC\u0001\nII\u001a\u001c8\u000b^8sC\u001e,\u0007*\u00198eY\u0016\u0014(B\u0001\u0012$\u0003!A\u0017M\u001c3mKJ\u001c(B\u0001\u0013&\u0003\u0019\u00198\r[3nC*\u0011aeJ\u0001\tgR\f'\u000f\\1lK*\t\u0001&\u0001\u0002bS\u000e\u00011c\u0001\u0001,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u0004\"AM\u001a\u000e\u0003\u0005J!\u0001N\u0011\u0003\u001dM#xN]1hK\"\u000bg\u000e\u001a7fe\u0006Qa-\u001b7f'f\u001cH/Z7\u0011\u0005]rdB\u0001\u001d=!\tIT&D\u0001;\u0015\tY\u0014&\u0001\u0004=e>|GOP\u0005\u0003{5\na\u0001\u0015:fI\u00164\u0017BA A\u0005\u0019\u0019FO]5oO*\u0011Q(L\u0001\tg\u0016$H/\u001b8hgB\u00111IR\u0007\u0002\t*\u0011Q)J\u0001\u0007G>tg-[4\n\u0005\u001d#%\u0001C*fiRLgnZ:\u0002\rqJg.\u001b;?)\tQU\n\u0006\u0002L\u0019B\u0011!\u0007\u0001\u0005\u0006\u0003\u000e\u0001\u001dA\u0011\u0005\u0006k\r\u0001\rAN\u0001\u0005G>tg-F\u0001Q!\t\t\u0016,D\u0001S\u0015\tq5K\u0003\u0002U+\u00061\u0001.\u00193p_BT!AV,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0016aA8sO&\u0011!L\u0015\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000b\r|gN\u001a\u0011\u0002)9|'/\\1mSj,GMR5mKNK8\u000f^3n+\u00051\u0014a\u00067pG.\f5-];jg&$\u0018n\u001c8Q_2dG+[7f+\u0005\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003!!WO]1uS>t'BA3.\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003O\n\u0014aBR5oSR,G)\u001e:bi&|g.A\nm_\u000e\\'+\u001a4sKND\u0007k\u001c7m)&lW-\u0001\u0002ggV\t1\u000e\u0005\u0002m]6\tQN\u0003\u0002j'&\u0011q.\u001c\u0002\u000b\r&dWmU=ti\u0016l\u0017a\u00014tA\u0005yq-\u001a;PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0002tmB\u0011A\u000e^\u0005\u0003k6\u0014!CR*ECR\fw*\u001e;qkR\u001cFO]3b[\")qo\u0003a\u0001q\u0006!\u0001/\u0019;i!\ta\u00170\u0003\u0002{[\n!\u0001+\u0019;i\u0003\u0011\u0011X-\u00193\u0015\u0005Yj\b\"B<\r\u0001\u0004A\u0018!B<sSR,GCBA\u0001\u0003\u000f\tY\u0001E\u0002-\u0003\u0007I1!!\u0002.\u0005\u0011)f.\u001b;\t\r\u0005%Q\u00021\u00017\u0003\u0011!\u0017\r^1\t\u000b]l\u0001\u0019\u0001=\u0002\u0017]\u0014\u0018\u000e^3CS:\f'/\u001f\u000b\u0007\u0003\u0003\t\t\"a\b\t\u000f\u0005%a\u00021\u0001\u0002\u0014A)A&!\u0006\u0002\u001a%\u0019\u0011qC\u0017\u0003\u000b\u0005\u0013(/Y=\u0011\u00071\nY\"C\u0002\u0002\u001e5\u0012AAQ=uK\")qO\u0004a\u0001q\u0006yA.[:u\t&\u0014Xm\u0019;pe&,7\u000f\u0006\u0003\u0002&\u0005]\u0002#BA\u0014\u0003cAh\u0002BA\u0015\u0003[q1!OA\u0016\u0013\u0005q\u0013bAA\u0018[\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u0011A\u0001T5ti*\u0019\u0011qF\u0017\t\u000b]|\u0001\u0019\u0001=\u0002\t1L7\u000f\u001e\u000b\r\u0003K\ti$a\u0010\u0002D\u0005]\u0013\u0011\r\u0005\u0006oB\u0001\r\u0001\u001f\u0005\t\u0003\u0003\u0002\u0002\u0013!a\u0001m\u0005IQ\r\u001f;f]NLwN\u001c\u0005\n\u0003\u000b\u0002\u0002\u0013!a\u0001\u0003\u000f\nQa]5oG\u0016\u0004B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0003uS6,'BAA)\u0003\u0011Q\u0017M^1\n\t\u0005U\u00131\n\u0002\u000e\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000f\u0005e\u0003\u00031\u0001\u0002\\\u0005I!/Z2veNLg/\u001a\t\u0004Y\u0005u\u0013bAA0[\t9!i\\8mK\u0006t\u0007\"CA2!A\u0005\t\u0019AA3\u0003\u001d)\u0007p\u00197vI\u0016\u0004R\u0001LA4\u0003WJ1!!\u001b.\u0005\u0019y\u0005\u000f^5p]B!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014!\u0002:fO\u0016D(\u0002BA;\u0003\u001f\nA!\u001e;jY&!\u0011\u0011PA8\u0005\u001d\u0001\u0016\r\u001e;fe:\fA!\\8wKR1\u00111LA@\u0003\u0003CQa^\tA\u0002aDa!a!\u0012\u0001\u0004A\u0018\u0001\u00023fgR\fa\u0001Z3mKR,G\u0003BA.\u0003\u0013CQa\u001e\nA\u0002a\fa!\\6eSJ\u001cH\u0003BA.\u0003\u001fCQa^\nA\u0002a\fQbY8qs\u001a\u0013x.\u001c'pG\u0006dGCBA\u0001\u0003+\u000bI\n\u0003\u0004\u0002\u0018R\u0001\r\u0001_\u0001\u0007g>,(oY3\t\r\u0005\rE\u00031\u0001y\u0003-\u0019w\u000e]=U_2{7-\u00197\u0015\r\u0005\u0005\u0011qTAQ\u0011\u0019\t9*\u0006a\u0001q\"1\u00111Q\u000bA\u0002a\fQ\"\\8wK\u001a\u0013x.\u001c'pG\u0006dGCBA\u0001\u0003O\u000bI\u000b\u0003\u0004\u0002\u0018Z\u0001\r\u0001\u001f\u0005\u0007\u0003\u00073\u0002\u0019\u0001=\u0002#5|g/Z*qCJ\\\u0007+\u0019:u\r&dW\r\u0006\u0004\u00020\u0006E\u0016Q\u0017\t\u0005Y\u0005\u001d\u0004\u0010\u0003\u0004\u00024^\u0001\r\u0001_\u0001\fgB\f'o\u001b$pY\u0012,'\u000f\u0003\u0004\u0002B]\u0001\rAN\u0001\u0007KbL7\u000f^:\u0015\t\u0005m\u00131\u0018\u0005\u0006ob\u0001\r\u0001_\u0001\nE2|7m[*ju\u0016$B!!1\u0002HB\u0019A&a1\n\u0007\u0005\u0015WF\u0001\u0003M_:<\u0007\"B<\u001a\u0001\u0004A\u0018AD2p]R,g\u000e^*v[6\f'/\u001f\u000b\u0005\u0003\u001b\f\u0019\u000eE\u0002m\u0003\u001fL1!!5n\u00059\u0019uN\u001c;f]R\u001cV/\\7befDQa\u001e\u000eA\u0002a\fQb\u001d9bG\u0016\u001cuN\\:v[\u0016$G\u0003BAa\u00033DQa^\u000eA\u0002a\fA\u0002\\1ti6{G-\u001b4jK\u0012$B!a8\u0003\u0016A!\u0011\u0011\u001dB\b\u001d\u0011\t\u0019O!\u0003\u000f\t\u0005\u0015(1\u0001\b\u0005\u0003O\fiP\u0004\u0003\u0002j\u0006]h\u0002BAv\u0003gtA!!<\u0002r:\u0019\u0011(a<\n\u0003aK!AV,\n\u0007\u0005UX+A\u0003ta\u0006\u00148.\u0003\u0003\u0002z\u0006m\u0018aA:rY*\u0019\u0011Q_+\n\t\u0005}(\u0011A\u0001\nKb,7-\u001e;j_:TA!!?\u0002|&!!Q\u0001B\u0004\u0003%\u0019HO]3b[&twM\u0003\u0003\u0002\u0000\n\u0005\u0011\u0002\u0002B\u0006\u0005\u001b\t\u0001CR5mKN#(/Z1n'>,(oY3\u000b\t\t\u0015!qA\u0005\u0005\u0005#\u0011\u0019BA\u0005US6,7\u000f^1na*!!1\u0002B\u0007\u0011\u00159H\u00041\u0001y\u0003\u0019!x.^2iuR!!1\u0004B\u0013!\u0019\u0011iB!\t\u0002\u00025\u0011!q\u0004\u0006\u0004\u0003kj\u0013\u0002\u0002B\u0012\u0005?\u00111\u0001\u0016:z\u0011\u00159X\u00041\u0001y\u0003\u0015!x.^2i)\u0011\u0011YBa\u000b\t\u000b]t\u0002\u0019\u0001=\u0002\u000bUt'0\u001b9\u0015\r\tm!\u0011\u0007B\u001b\u0011\u0019\u0011\u0019d\ba\u0001q\u0006Q1o\\;sG\u00164\u0015\u000e\\3\t\r\t]r\u00041\u0001y\u0003%!\u0018M]4fi\u0012K'\u000f")
public class HdfsStorageHandler
implements StorageHandler {
    private String normalizedFileSystem;
    private final String fileSystem;
    private final Settings settings;
    private final Configuration conf;
    private final FileSystem fs;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public String list$default$2() {
        return StorageHandler.list$default$2$(this);
    }

    @Override
    public LocalDateTime list$default$3() {
        return StorageHandler.list$default$3$(this);
    }

    @Override
    public Option<Pattern> list$default$5() {
        return StorageHandler.list$default$5$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Configuration conf() {
        return this.conf;
    }

    private String normalizedFileSystem$lzycompute() {
        HdfsStorageHandler hdfsStorageHandler = this;
        synchronized (hdfsStorageHandler) {
            if (!this.bitmap$0) {
                this.normalizedFileSystem = this.fileSystem.endsWith(":") ? new StringBuilder(3).append(this.fileSystem).append("///").toString() : (!this.fileSystem.endsWith("://") && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(this.fileSystem)).last()) == '/' ? (String)new StringOps(Predef$.MODULE$.augmentString(this.fileSystem)).dropRight(1) : (this.fileSystem.endsWith("://") ? new StringBuilder(2).append(this.fileSystem).append("/.").toString() : this.fileSystem));
                this.bitmap$0 = true;
            }
        }
        return this.normalizedFileSystem;
    }

    public String normalizedFileSystem() {
        if (!this.bitmap$0) {
            return this.normalizedFileSystem$lzycompute();
        }
        return this.normalizedFileSystem;
    }

    @Override
    public FiniteDuration lockAcquisitionPollTime() {
        return this.settings.comet().lock().pollTime();
    }

    @Override
    public FiniteDuration lockRefreshPollTime() {
        return this.settings.comet().lock().refreshTime();
    }

    public FileSystem fs() {
        return this.fs;
    }

    @Override
    public FSDataOutputStream getOutputStream(Path path) {
        this.fs().delete(path, false);
        FSDataOutputStream outputStream = this.fs().create(path);
        return outputStream;
    }

    @Override
    public String read(Path path) {
        FSDataInputStream stream = this.fs().open(path);
        String content = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        return content;
    }

    @Override
    public void write(String data, Path path) {
        FSDataOutputStream os = this.getOutputStream(path);
        os.writeBytes(data);
        os.close();
    }

    public void writeBinary(byte[] data, Path path) {
        FSDataOutputStream os = this.getOutputStream(path);
        os.write(data, 0, data.length);
        os.close();
    }

    @Override
    public List<Path> listDirectories(Path path) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fs().listStatus(path))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory())))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toList();
    }

    @Override
    public List<Path> list(Path path, String extension, LocalDateTime since, boolean recursive, Option<Pattern> exclude) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("list({}, {}, {})", new Object[]{path, extension, since});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (this.exists(path)) {
                RemoteIterator iterator = this.fs().listFiles(path, recursive);
                return (List)((List)Conversions$.MODULE$.convertToScalaIterator(iterator).filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$list$2(this, exclude, since, extension, status))).toList().sortBy((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)BoxesRunTime.boxToLong((long)r.getModificationTime()), (Object)r.getPath().getName()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable & scala.Serializable)status -> status.getPath(), List$.MODULE$.canBuildFrom());
            }
            return Nil$.MODULE$;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List list = (List)success.value();
            return list;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(16).append("Ignoring folder ").append(path).toString(), e);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return Nil$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public boolean move(Path path, Path dest) {
        this.delete(dest);
        this.mkdirs(dest.getParent());
        return this.fs().rename(path, dest);
    }

    @Override
    public boolean delete(Path path) {
        return this.fs().delete(path, true);
    }

    @Override
    public boolean mkdirs(Path path) {
        return this.fs().mkdirs(path);
    }

    @Override
    public void copyFromLocal(Path source, Path dest) {
        this.fs().copyFromLocalFile(source, dest);
    }

    @Override
    public void copyToLocal(Path source, Path dest) {
        this.fs().copyToLocalFile(source, dest);
    }

    @Override
    public void moveFromLocal(Path source, Path dest) {
        String string = this.fs().getScheme();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.fs().moveFromLocalFile(source, dest);
            return;
        }
        this.move(source, dest);
    }

    @Override
    public Option<Path> moveSparkPartFile(Path sparkFolder, String extension) {
        Path x$1 = sparkFolder;
        String x$2 = extension;
        boolean x$3 = false;
        LocalDateTime x$4 = this.list$default$3();
        Option<Pattern> x$5 = this.list$default$5();
        Option files = this.list(x$1, x$2, x$4, x$3, x$5).headOption();
        return files.map((Function1 & Serializable & scala.Serializable)f -> {
            Path tmpFile = new Path(sparkFolder.getParent(), new StringBuilder(4).append(sparkFolder.getName()).append(".tmp").toString());
            this.move((Path)f, tmpFile);
            this.delete(sparkFolder);
            this.move(tmpFile, sparkFolder);
            return sparkFolder;
        });
    }

    @Override
    public boolean exists(Path path) {
        return this.fs().exists(path);
    }

    @Override
    public long blockSize(Path path) {
        return this.fs().getDefaultBlockSize(path);
    }

    @Override
    public ContentSummary contentSummary(Path path) {
        return this.fs().getContentSummary(path);
    }

    @Override
    public long spaceConsumed(Path path) {
        return this.contentSummary(path).getSpaceConsumed();
    }

    @Override
    public long lastModified(Path path) {
        return this.fs().getFileStatus(path).getModificationTime();
    }

    @Override
    public Try<BoxedUnit> touchz(Path path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fs().create(path, false).close());
    }

    @Override
    public Try<BoxedUnit> touch(Path path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fs().setTimes(path, System.currentTimeMillis(), -1L));
    }

    @Override
    public Try<BoxedUnit> unzip(Path sourceFile, Path targetDir) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.fs().exists(sourceFile)) {
                throw new Exception(new StringBuilder(15).append(sourceFile.toString()).append(" does not exist").toString());
            }
            FSDataInputStream fsInputStream = this.fs().open(sourceFile);
            ZipInputStream zipInputStream = new ZipInputStream((InputStream)fsInputStream);
            package$.MODULE$.Stream().continually((Function0 & Serializable & scala.Serializable)() -> zipInputStream.getNextEntry()).takeWhile((Function1 & Serializable & scala.Serializable)ze -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$unzip$3(ze))).foreach((Function1 & Serializable & scala.Serializable)zipEntry -> {
                HdfsStorageHandler.$anonfun$unzip$4(zipInputStream, zipEntry);
                return BoxedUnit.UNIT;
            });
            zipInputStream.close();
        });
    }

    public static final /* synthetic */ void $anonfun$new$1(HdfsStorageHandler $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            $this.conf().set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$list$3(LocatedFileStatus status$1, Pattern x$3) {
        return x$3.matcher(status$1.getPath().getName()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$list$2(HdfsStorageHandler $this, Option exclude$1, LocalDateTime since$1, String extension$1, LocatedFileStatus status) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("found file={}", new Object[]{status});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(status.getModificationTime()), ZoneId.systemDefault());
        boolean excludeFile = exclude$1.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$list$3(status, x$3)));
        return !excludeFile && time.isAfter(since$1) && status.getPath().getName().endsWith(extension$1);
    }

    public static final /* synthetic */ boolean $anonfun$unzip$3(ZipEntry ze) {
        return ze != null && !ze.isDirectory();
    }

    public static final /* synthetic */ void $anonfun$unzip$4(ZipInputStream zipInputStream$1, ZipEntry zipEntry) {
        String entryName = zipEntry.getName();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int bytesRead = zipInputStream$1.read(buf, 0, 4096);
        while (bytesRead > -1) {
            outputStream.write(buf, 0, bytesRead);
            bytesRead = zipInputStream$1.read(buf, 0, 4096);
        }
        outputStream.close();
        zipInputStream$1.closeEntry();
    }

    public HdfsStorageHandler(String fileSystem, Settings settings) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        this.fileSystem = fileSystem;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.conf = new Configuration();
        this.conf().set("fs.defaultFS", this.normalizedFileSystem());
        settings.comet().hadoop().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HdfsStorageHandler.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.fs = FileSystem.get((Configuration)this.conf());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(3).append("fs=").append(this.fs()).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(20).append("fs.getHomeDirectory=").append(this.fs().getHomeDirectory()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(10).append("fs.getUri=").append(this.fs().getUri()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

