/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.handlers;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.config.StorageArea;
import ai.starlake.config.StorageArea$;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.handlers.ValidateConfig;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AssertionDefinition;
import ai.starlake.schema.model.AssertionDefinitions;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.AutoJobDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.Env;
import ai.starlake.schema.model.MergeOptions;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.PrimitiveType$struct$;
import ai.starlake.schema.model.PrivacyLevel;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.SqlTaskExtractor;
import ai.starlake.schema.model.SqlTaskExtractor$;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.Type;
import ai.starlake.schema.model.Type$;
import ai.starlake.schema.model.Types;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.CometObjectMapper;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.Utils$;
import ai.starlake.utils.YamlSerializer$;
import better.files.File$;
import com.databricks.spark.xml.util.XSDToSchema$;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\rUe\u0001B\u001f?\u0001\u001dC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t;\u0002\u0011\t\u0011)A\u0006=\")A\r\u0001C\u0001K\"9!\u000e\u0001b\u0001\n\u0003Y\u0007bBA\u0003\u0001\u0001\u0006I\u0001\u001c\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011%\tY\bAI\u0001\n\u0003\ti\bC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u0016\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005\"CAV\u0001E\u0005I\u0011AAW\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!a/\u0001\t\u0003\ti\fC\u0004\u0002R\u0002!\t!a5\t\u0013\u0005]\u0007!%A\u0005\u0002\u0005u\u0004\"CAm\u0001\u0001\u0007I\u0011AAn\u0011%\ti\u000e\u0001a\u0001\n\u0003\ty\u000e\u0003\u0005\u0002f\u0002\u0001\u000b\u0015BA`\u0011\u001d\tY\f\u0001C\u0005\u0003ODq!!>\u0001\t\u0003\t9\u0010C\u0004\u0003\b\u0001!\tA!\u0003\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e!9!\u0011\t\u0001\u0005\n\t\r\u0003\"\u0003B&\u0001\u0001\u0007I\u0011\u0002B'\u0011%\u0011y\u0005\u0001a\u0001\n\u0013\u0011\t\u0006\u0003\u0005\u0003V\u0001\u0001\u000b\u0015\u0002B#\u0011\u001d\u00119\u0006\u0001C\u0001\u00053B\u0011B!\u001a\u0001\u0005\u0004%IAa\u001a\t\u0011\t\u0015\u0005\u0001)A\u0005\u0005SBqAa\"\u0001\t\u0003\u0011I\tC\u0005\u0003\u000e\u0002\t\n\u0011\"\u0001\u0002~!I!q\u0012\u0001A\u0002\u0013%!Q\n\u0005\n\u0005#\u0003\u0001\u0019!C\u0005\u0005'C\u0001Ba&\u0001A\u0003&!Q\t\u0005\b\u00053\u0003A\u0011\u0002BN\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005WC\u0011Ba-\u0001\u0001\u0004%\tA!.\t\u0013\t5\u0007\u00011A\u0005\u0002\t=\u0007\u0002\u0003Bj\u0001\u0001\u0006KAa.\t\u000f\tU\u0007\u0001\"\u0001\u0003X\"I!Q\u001c\u0001\u0012\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0005?\u0004\u0001\u0019!C\u0005\u0005CD\u0011Ba9\u0001\u0001\u0004%IA!:\t\u0011\t%\b\u0001)Q\u0005\u00053DqAa;\u0001\t\u0013\u0011i\u000fC\u0004\u0003|\u0002!\tA!@\t\u000f\r\u001d\u0001\u0001\"\u0001\u0004\n!91Q\u0003\u0001\u0005\n\r]\u0001bBB\u000f\u0001\u0011\u00051q\u0004\u0005\n\u0007K\u0001\u0011\u0013!C\u0001\u0003{B\u0011ba\n\u0001\u0001\u0004%Ia!\u000b\t\u0013\r-\u0002\u00011A\u0005\n\r5\u0002\u0002CB\u0019\u0001\u0001\u0006Ka!\t\t\u000f\rM\u0002\u0001\"\u0003\u00046!911\t\u0001\u0005\u0002\r\u0015\u0003bBB&\u0001\u0011\u00051Q\n\u0005\b\u00077\u0002A\u0011AB/\u0011\u001d\u0019I\u0007\u0001C\u0001\u0007WBqa!\u001b\u0001\t\u0003\u0019y\u0007C\u0004\u0004\u0002\u0002!\taa!\u0003\u001bM\u001b\u0007.Z7b\u0011\u0006tG\r\\3s\u0015\ty\u0004)\u0001\u0005iC:$G.\u001a:t\u0015\t\t%)\u0001\u0004tG\",W.\u0019\u0006\u0003\u0007\u0012\u000b\u0001b\u001d;be2\f7.\u001a\u0006\u0002\u000b\u0006\u0011\u0011-[\u0002\u0001'\r\u0001\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=3V\"\u0001)\u000b\u0005E\u0013\u0016\u0001D:dC2\fGn\\4hS:<'BA*U\u0003!!\u0018\u0010]3tC\u001a,'\"A+\u0002\u0007\r|W.\u0003\u0002X!\ni1\u000b\u001e:jGRdunZ4j]\u001e\fqa\u001d;pe\u0006<W\r\u0005\u0002[76\ta(\u0003\u0002]}\tq1\u000b^8sC\u001e,\u0007*\u00198eY\u0016\u0014\u0018\u0001C:fiRLgnZ:\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\u0014\u0015AB2p]\u001aLw-\u0003\u0002dA\nA1+\u001a;uS:<7/\u0001\u0004=S:LGO\u0010\u000b\u0003M&$\"a\u001a5\u0011\u0005i\u0003\u0001\"B/\u0004\u0001\bq\u0006\"\u0002-\u0004\u0001\u0004I\u0016AB7baB,'/F\u0001m%\riw.\u001f\u0004\u0005]\u0002\u0001AN\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0002qo6\t\u0011O\u0003\u0002sg\u0006AA-\u0019;bE&tGM\u0003\u0002uk\u00069!.Y2lg>t'B\u0001<U\u0003%1\u0017m\u001d;feblG.\u0003\u0002yc\naqJ\u00196fGRl\u0015\r\u001d9feB\u0019!0!\u0001\u000e\u0003mT!\u0001`?\u0002\u0019\u0015D\b/\u001a:j[\u0016tG/\u00197\u000b\u0005-s(BA@t\u0003\u0019iw\u000eZ;mK&\u0019\u00111A>\u0003#M\u001b\u0017\r\\1PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0002\u001b\rDWmY6WC2LG-\u001b;z)\u0011\tY!a\r\u0011\r\u00055\u0011QDA\u0012\u001d\u0011\ty!!\u0007\u000f\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006G\u0003\u0019a$o\\8u}%\t1*C\u0002\u0002\u001c)\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002 \u0005\u0005\"\u0001\u0002'jgRT1!a\u0007K!\u0011\t)#!\f\u000f\t\u0005\u001d\u0012\u0011\u0006\t\u0004\u0003#Q\u0015bAA\u0016\u0015\u00061\u0001K]3eK\u001aLA!a\f\u00022\t11\u000b\u001e:j]\u001eT1!a\u000bK\u0011%\t)D\u0002I\u0001\u0002\u0004\t9$\u0001\u0004sK2|\u0017\r\u001a\t\u0004\u0013\u0006e\u0012bAA\u001e\u0015\n9!i\\8mK\u0006t\u0007&\u0002\u0004\u0002@\u0005-\u0003#B%\u0002B\u0005\u0015\u0013bAA\"\u0015\n1A\u000f\u001b:poN\u0004B!!\u0004\u0002H%!\u0011\u0011JA\u0011\u0005%)\u0005pY3qi&|g.M\u0004\u001f\u0003G\ti%!\u001f2\u0013\r\ny%a\u0016\u0002p\u0005eS\u0003BA)\u0003'*\"!a\t\u0005\u000f\u0005UcI1\u0001\u0002`\t\tA+\u0003\u0003\u0002Z\u0005m\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002^)\u000ba\u0001\u001e5s_^\u001c\u0018\u0003BA1\u0003O\u00022!SA2\u0013\r\t)G\u0013\u0002\b\u001d>$\b.\u001b8h!\u0011\tI'a\u001b\u000f\u0007%\u000bI\"\u0003\u0003\u0002n\u0005\u0005\"!\u0003+ie><\u0018M\u00197fc%\u0019\u0013\u0011OA:\u0003k\niFD\u0002J\u0003gJ1!!\u0018Kc\u0015\u0011\u0013JSA<\u0005\u0015\u00198-\u00197bc\r1\u0013QI\u0001\u0018G\",7m\u001b,bY&$\u0017\u000e^=%I\u00164\u0017-\u001e7uIE*\"!a +\t\u0005]\u0012\u0011Q\u0016\u0003\u0003\u0007\u0003B!!\"\u0002\u00106\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0012&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0012\u0006\u001d%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00012\r[3dW\u0012{W.Y5ogZ\u000b'o\u001d\u000b\u0003\u0003\u0017\tQb\u00195fG.TuNY:WCJ\u001c\u0018A\u00044vY24\u0016\r\\5eCRLwN\u001c\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002J\u0003?K1!!)K\u0005\u0011)f.\u001b;\t\u0011\u0005T\u0001\u0013!a\u0001\u0003K\u00032AWAT\u0013\r\tIK\u0010\u0002\u000f-\u0006d\u0017\u000eZ1uK\u000e{gNZ5h\u0003a1W\u000f\u001c7WC2LG-\u0019;j_:$C-\u001a4bk2$H%M\u000b\u0003\u0003_SC!!*\u0002\u0002\u0006\u00112\r[3dWZKWm^:WC2LG-\u001b;z)\t\t)\f\u0005\u0005\u0002\u000e\u0005]\u00161BA\u001c\u0013\u0011\tI,!\t\u0003\r\u0015KG\u000f[3s\u0003%aw.\u00193UsB,7\u000f\u0006\u0003\u0002@\u00065\u0007CBA\u0007\u0003;\t\t\r\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9\rQ\u0001\u0006[>$W\r\\\u0005\u0005\u0003\u0017\f)M\u0001\u0003UsB,\u0007bBAh\u001b\u0001\u0007\u00111E\u0001\tM&dWM\\1nK\u0006)A/\u001f9fgR!\u0011qXAk\u0011%\t)D\u0004I\u0001\u0002\u0004\t9$A\busB,7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003\u0019yF/\u001f9fgV\u0011\u0011qX\u0001\u000b?RL\b/Z:`I\u0015\fH\u0003BAO\u0003CD\u0011\"a9\u0012\u0003\u0003\u0005\r!a0\u0002\u0007a$\u0013'A\u0004`if\u0004Xm\u001d\u0011\u0015\u0005\u0005}\u0006&B\n\u0002@\u0005-\u0018g\u0002\u0010\u0002$\u00055\u00181_\u0019\nG\u0005=\u0013qKAx\u00033\n\u0014bIA9\u0003g\n\t0!\u00182\u000b\tJ%*a\u001e2\u0007\u0019\n)%\u0001\bm_\u0006$\u0017i]:feRLwN\\:\u0015\t\u0005e(Q\u0001\t\t\u0003K\tY0a\t\u0002\u0000&!\u0011Q`A\u0019\u0005\ri\u0015\r\u001d\t\u0005\u0003\u0007\u0014\t!\u0003\u0003\u0003\u0004\u0005\u0015'aE!tg\u0016\u0014H/[8o\t\u00164\u0017N\\5uS>t\u0007bBAh)\u0001\u0007\u00111E\u0001\u000bCN\u001cXM\u001d;j_:\u001cH\u0003BA}\u0005\u0017AqA!\u0004\u0016\u0001\u0004\t\u0019#\u0001\u0003oC6,\u0007&B\u000b\u0002@\tE\u0011g\u0002\u0010\u0002$\tM!\u0011D\u0019\nG\u0005=\u0013q\u000bB\u000b\u00033\n\u0014bIA9\u0003g\u00129\"!\u00182\u000b\tJ%*a\u001e2\u0007\u0019\n)%A\u0007m_\u0006$7+\u001d7Ke\u0019KG.\u001a\u000b\u0005\u0005?\u0011)\u0003E\u0004J\u0005C\t\u0019#a\t\n\u0007\t\r\"J\u0001\u0004UkBdWM\r\u0005\b\u0005O1\u0002\u0019\u0001B\u0015\u0003\u001d\u0019\u0018\u000f\u001c$jY\u0016\u0004BAa\u000b\u0003>5\u0011!Q\u0006\u0006\u0005\u0005_\u0011\t$\u0001\u0002gg*!!1\u0007B\u001b\u0003\u0019A\u0017\rZ8pa*!!q\u0007B\u001d\u0003\u0019\t\u0007/Y2iK*\u0011!1H\u0001\u0004_J<\u0017\u0002\u0002B \u0005[\u0011A\u0001U1uQ\u0006yAn\\1e'Fd'*\u001b\u001aGS2,7\u000f\u0006\u0003\u0003F\t\u001d\u0003\u0003CA\u0013\u0003w\f\u0019#a\t\t\u000f\t%s\u00031\u0001\u0003*\u0005!\u0001/\u0019;i\u0003!1\u0018.Z<t\u001b\u0006\u0004XC\u0001B#\u000311\u0018.Z<t\u001b\u0006\u0004x\fJ3r)\u0011\tiJa\u0015\t\u0013\u0005\r\u0018$!AA\u0002\t\u0015\u0013!\u0003<jK^\u001cX*\u00199!\u0003\u00151\u0018.Z<t)\u0011\u0011YF!\u0019\u0011\u000b%\u0013i&a\t\n\u0007\t}#J\u0001\u0004PaRLwN\u001c\u0005\b\u0005GZ\u0002\u0019AA\u0012\u0003!1\u0018.Z<OC6,\u0017!D2p[\u0016$H)\u0019;f-\u0006\u00148/\u0006\u0002\u0003jAA!1\u000eB;\u0005o\u00129(\u0004\u0002\u0003n)!!q\u000eB9\u0003%IW.\\;uC\ndWMC\u0002\u0003t)\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tiP!\u001c\u0011\t\te$1Q\u0007\u0003\u0005wRAA! \u0003\u0000\u0005!A.\u00198h\u0015\t\u0011\t)\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0005w\nabY8nKR$\u0015\r^3WCJ\u001c\b%A\u0005bGRLg/Z#omR!!Q\tBF\u0011%\t)D\bI\u0001\u0002\u0004\t9$A\nbGRLg/Z#om\u0012\"WMZ1vYR$\u0013'\u0001\u0006`C\u000e$\u0018N^3F]Z\fabX1di&4X-\u00128w?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\nU\u0005\"CArC\u0005\u0005\t\u0019\u0001B#\u0003-y\u0016m\u0019;jm\u0016,eN\u001e\u0011\u0002\u001b1|\u0017\rZ!di&4X-\u00128w)\t\u0011)\u0005K\u0003$\u0003\u007f\u0011y*M\u0004\u001f\u0003G\u0011\tKa*2\u0013\r\ny%a\u0016\u0003$\u0006e\u0013'C\u0012\u0002r\u0005M$QUA/c\u0015\u0011\u0013JSA<c\r1\u0013QI\u0001\bO\u0016$H+\u001f9f)\u0011\u0011iKa,\u0011\u000b%\u0013i&!1\t\u000f\tEF\u00051\u0001\u0002$\u0005\u0019A\u000f]3\u0002'\u0011,7/\u001a:jC2L'0\u001a3E_6\f\u0017N\\:\u0016\u0005\t]\u0006CBA\u0007\u0003;\u0011I\fE\u0004J\u0005C\u0011ICa/\u0011\r\tu&1\u0019Bd\u001b\t\u0011yLC\u0002\u0003B*\u000bA!\u001e;jY&!!Q\u0019B`\u0005\r!&/\u001f\t\u0005\u0003\u0007\u0014I-\u0003\u0003\u0003L\u0006\u0015'A\u0002#p[\u0006Lg.A\feKN,'/[1mSj,G\rR8nC&t7o\u0018\u0013fcR!\u0011Q\u0014Bi\u0011%\t\u0019OJA\u0001\u0002\u0004\u00119,\u0001\u000beKN,'/[1mSj,G\rR8nC&t7\u000fI\u0001\bI>l\u0017-\u001b8t)\u0011\u0011INa7\u0011\r\u00055\u0011Q\u0004Bd\u0011%\t)\u0004\u000bI\u0001\u0002\u0004\t9$A\te_6\f\u0017N\\:%I\u00164\u0017-\u001e7uIE\n\u0001b\u00183p[\u0006Lgn]\u000b\u0003\u00053\fAb\u00183p[\u0006Lgn]0%KF$B!!(\u0003h\"I\u00111]\u0016\u0002\u0002\u0003\u0007!\u0011\\\u0001\n?\u0012|W.Y5og\u0002\n1\u0002\\8bI\u0012{W.Y5ogR\u0011!\u0011\u001c\u0015\u0006[\u0005}\"\u0011_\u0019\b=\u0005\r\"1\u001fB}c%\u0019\u0013qJA,\u0005k\fI&M\u0005$\u0003c\n\u0019Ha>\u0002^E*!%\u0013&\u0002xE\u001aa%!\u0012\u0002'\rDWmY6WCJ\u001c\u0018I]3EK\u001aLg.\u001a3\u0015\t\t}8Q\u0001\t\u0007\u0003K\u0019\t!a\t\n\t\r\r\u0011\u0011\u0007\u0002\u0004'\u0016$\bb\u0002B%]\u0001\u0007!\u0011F\u0001\u0010Y>\fGMS8c\rJ|WNR5mKR!11BB\n!\u0019\u0011iLa1\u0004\u000eA!\u00111YB\b\u0013\u0011\u0019\t\"!2\u0003\u0017\u0005+Ho\u001c&pE\u0012+7o\u0019\u0005\b\u0005\u0013z\u0003\u0019\u0001B\u0015\u0003Q1\u0017N\\1m\t>l\u0017-\u001b8Pe*{'MT1nKR1!qOB\r\u00077AqA!\u00131\u0001\u0004\u0011I\u0003C\u0004\u0003\u000eA\u0002\r!a\t\u0002\t)|'m\u001d\u000b\u0005\u0007C\u0019\u0019\u0003\u0005\u0005\u0002&\u0005m\u00181EB\u0007\u0011%\t)$\rI\u0001\u0002\u0004\t9$\u0001\bk_\n\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002\u000b}SwNY:\u0016\u0005\r\u0005\u0012!C0k_\n\u001cx\fJ3r)\u0011\tija\f\t\u0013\u0005\rH'!AA\u0002\r\u0005\u0012AB0k_\n\u001c\b%\u0001\u0005m_\u0006$'j\u001c2t)\t\u0019\t\u0003K\u00037\u0003\u007f\u0019I$M\u0004\u001f\u0003G\u0019Yd!\u00112\u0013\r\ny%a\u0016\u0004>\u0005e\u0013'C\u0012\u0002r\u0005M4qHA/c\u0015\u0011\u0013JSA<c\r1\u0013QI\u0001\nO\u0016$Hi\\7bS:$Baa\u0012\u0004JA)\u0011J!\u0018\u0003H\"9!QB\u001cA\u0002\u0005\r\u0012AC4fiN\u001b\u0007.Z7bgR!1qJB,!\u0019\ti!!\b\u0004RA!\u00111YB*\u0013\u0011\u0019)&!2\u0003\rM\u001b\u0007.Z7b\u0011\u001d\u0019I\u0006\u000fa\u0001\u0003G\ta\u0001Z8nC&t\u0017!C4fiN\u001b\u0007.Z7b)\u0019\u0019yf!\u0019\u0004fA)\u0011J!\u0018\u0004R!911M\u001dA\u0002\u0005\r\u0012A\u00033p[\u0006LgNT1nK\"91qM\u001dA\u0002\u0005\r\u0012AC:dQ\u0016l\u0017MT1nK\u00069aM]8n1N#E\u0003\u0002Bd\u0007[Bqa!\u0017;\u0001\u0004\u00119\r\u0006\u0004\u0004R\rE4Q\u000f\u0005\b\u0007gZ\u0004\u0019AB)\u0003%IX\u000e\\*dQ\u0016l\u0017\rC\u0004\u0004xm\u0002\ra!\u001f\u0002\u001d\u0011|W.Y5o\u001b\u0016$\u0018\rZ1uCB)\u0011J!\u0018\u0004|A!\u00111YB?\u0013\u0011\u0019y(!2\u0003\u00115+G/\u00193bi\u0006\fq\"\\3sO\u0016\fE\u000f\u001e:jEV$Xm\u001d\u000b\u0007\u0007\u000b\u001bii!%\u0011\r\u00055\u0011QDBD!\u0011\t\u0019m!#\n\t\r-\u0015Q\u0019\u0002\n\u0003R$(/\u001b2vi\u0016Dqaa$=\u0001\u0004\u0019))\u0001\u0005z[2\fE\u000f\u001e:t\u0011\u001d\u0019\u0019\n\u0010a\u0001\u0007\u000b\u000b\u0001\u0002_:e\u0003R$(o\u001d")
public class SchemaHandler
implements StrictLogging {
    private final StorageHandler storage;
    private final Settings settings;
    private final ObjectMapper mapper;
    private List<Type> _types;
    private Map<String, String> viewsMap;
    private final Map<String, String> cometDateVars;
    private Map<String, String> _activeEnv;
    private List<Tuple2<Path, Try<Domain>>> deserializedDomains;
    private List<Domain> _domains;
    private Map<String, AutoJobDesc> _jobs;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public List<String> checkValidity(boolean reload) throws Exception {
        List typesValidity = (List)this.types(reload).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.checkValidity(), List$.MODULE$.canBuildFrom());
        List domainsValidity = (List)this.domains(reload).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.checkValidity(this, $this.settings), List$.MODULE$.canBuildFrom());
        List<String> domainsVarsValidity = this.checkDomainsVars();
        List<String> jobsVarsValidity = this.checkJobsVars();
        List allErrors = (List)((SeqLike)typesValidity.$plus$plus((GenTraversableOnce)domainsValidity, List$.MODULE$.canBuildFrom())).$colon$plus(this.checkViewsValidity(), List$.MODULE$.canBuildFrom());
        List errs = (List)allErrors.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                List values = (List)left.value();
                return values;
            }
            if (either instanceof Right) {
                return Nil$.MODULE$;
            }
            throw new MatchError((Object)either);
        }, List$.MODULE$.canBuildFrom());
        return (List)((List)errs.$plus$plus(domainsVarsValidity, List$.MODULE$.canBuildFrom())).$plus$plus(jobsVarsValidity, List$.MODULE$.canBuildFrom());
    }

    public boolean checkValidity$default$1() {
        return false;
    }

    public List<String> checkDomainsVars() {
        Path x$1 = DatasetArea$.MODULE$.domains(this.settings);
        String x$2 = ".yml";
        boolean x$3 = true;
        Some x$4 = new Some((Object)Pattern.compile("_.*"));
        LocalDateTime x$5 = this.storage.list$default$3();
        List<Path> paths = this.storage.list(x$1, x$2, x$5, x$3, (Option<Pattern>)x$4);
        return (List)paths.flatMap((Function1 & Serializable & scala.Serializable)path -> this.checkVarsAreDefined((Path)path), List$.MODULE$.canBuildFrom());
    }

    public List<String> checkJobsVars() {
        Path x$1 = DatasetArea$.MODULE$.jobs(this.settings);
        String x$2 = ".yml";
        boolean x$3 = true;
        LocalDateTime x$4 = this.storage.list$default$3();
        Option<Pattern> x$5 = this.storage.list$default$5();
        List<Path> paths = this.storage.list(x$1, x$2, x$4, x$3, x$5);
        return (List)paths.flatMap((Function1 & Serializable & scala.Serializable)path -> this.checkVarsAreDefined((Path)path), List$.MODULE$.canBuildFrom());
    }

    public void fullValidation(ValidateConfig config) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            List<String> errs = this.checkValidity(config.reload());
            List deserErrors = (List)this.deserializedDomains().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$fullValidation$2(x0$1)));
            int errorCount = errs.length() + deserErrors.length();
            Option output = $this.settings.comet().rootServe().map((Function1 & Serializable & scala.Serializable)rootServe -> File$.MODULE$.apply(File$.MODULE$.apply(rootServe, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "validation.log", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            output.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                String x$1 = "";
                Seq x$2 = x$4.overwrite$default$2(x$1);
                Charset x$3 = x$4.overwrite$default$3(x$1);
                return x$4.overwrite(x$1, x$2, x$3);
            });
            if (errorCount > 0) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                output.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    String x$4 = new StringBuilder(39).append("START VALIDATION RESULTS: ").append(errorCount).append(" errors found").toString();
                    Charset x$52 = x$5.appendLine$default$2(x$4);
                    return x$5.appendLine(x$4, x$52);
                });
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("START VALIDATION RESULTS: {} errors found", new Object[]{BoxesRunTime.boxToInteger((int)errorCount)});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                deserErrors.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    SchemaHandler.$anonfun$fullValidation$6(this, output, x0$2);
                    return BoxedUnit.UNIT;
                });
                errs.foreach((Function1 & Serializable & scala.Serializable)err -> {
                    SchemaHandler.$anonfun$fullValidation$8(this, err);
                    return BoxedUnit.UNIT;
                });
                errs.foreach((Function1 & Serializable & scala.Serializable)err -> {
                    output.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                        String x$8 = err;
                        Charset x$9 = x$7.appendLine$default$2(x$8);
                        return x$7.appendLine(x$8, x$9);
                    });
                    return BoxedUnit.UNIT;
                });
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("END VALIDATION RESULTS");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                output.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                    String x$10 = "END VALIDATION RESULTS";
                    Charset x$11 = x$8.appendLine$default$2(x$10);
                    return x$8.appendLine(x$10, x$11);
                });
                return;
            }
        });
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            e.printStackTrace();
            if (this.settings.comet().validateOnLoad()) {
                throw e;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    public ValidateConfig fullValidation$default$1() {
        return new ValidateConfig(false);
    }

    public Either<List<String>, Object> checkViewsValidity() {
        Path viewsPath;
        MutableList errorList = (MutableList)MutableList$.MODULE$.empty();
        Path x$1 = viewsPath = DatasetArea$.MODULE$.views(this.settings);
        String x$2 = ".sql";
        boolean x$3 = true;
        LocalDateTime x$4 = this.storage.list$default$3();
        Option<Pattern> x$5 = this.storage.list$default$5();
        List<Path> sqlFiles = this.storage.list(x$1, x$2, x$4, x$3, x$5);
        Map duplicates = (Map)sqlFiles.groupBy((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getName()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$checkViewsValidity$2(x0$1)));
        duplicates.foreach((Function1 & Serializable & scala.Serializable)duplicate -> errorList.$plus$eq((Object)new StringBuilder(25).append("Found duplicate views => ").append(duplicate).toString()));
        if (errorList.nonEmpty()) {
            return package$.MODULE$.Left().apply((Object)errorList.toList());
        }
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public List<Type> loadTypes(String filename) {
        Path deprecatedTypesPath = new Path(DatasetArea$.MODULE$.types(this.settings), new StringBuilder(4).append(filename).append(".yml").toString());
        Path typesCometPath = new Path(DatasetArea$.MODULE$.types(this.settings), new StringBuilder(10).append(filename).append(".comet.yml").toString());
        if (this.storage.exists(typesCometPath)) {
            return ((Types)this.mapper().readValue(this.storage.read(typesCometPath), Types.class)).types();
        }
        if (this.storage.exists(deprecatedTypesPath)) {
            return ((Types)this.mapper().readValue(this.storage.read(deprecatedTypesPath), Types.class)).types();
        }
        return List$.MODULE$.empty();
    }

    public List<Type> types(boolean reload) {
        if (reload) {
            return this.loadTypes();
        }
        return this._types();
    }

    public boolean types$default$1() {
        return false;
    }

    public List<Type> _types() {
        return this._types;
    }

    public void _types_$eq(List<Type> x$1) {
        this._types = x$1;
    }

    private List<Type> loadTypes() throws Exception {
        List defaultTypes = (List)this.loadTypes("default").$colon$plus((Object)new Type("struct", ".*", PrimitiveType$struct$.MODULE$, Type$.MODULE$.apply$default$4(), Type$.MODULE$.apply$default$5(), Type$.MODULE$.apply$default$6(), Type$.MODULE$.apply$default$7(), Type$.MODULE$.apply$default$8()), List$.MODULE$.canBuildFrom());
        List<Type> types = this.loadTypes("types");
        List redefinedTypeNames = (List)((SeqLike)defaultTypes.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.name(), List$.MODULE$.canBuildFrom())).intersect((GenSeq)types.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.name(), List$.MODULE$.canBuildFrom()));
        this._types_$eq((List<Type>)((List)((List)defaultTypes.filter((Function1 & Serializable & scala.Serializable)defaultType -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$loadTypes$3(redefinedTypeNames, defaultType)))).$plus$plus(types, List$.MODULE$.canBuildFrom())));
        return this._types();
    }

    public Map<String, AssertionDefinition> loadAssertions(String filename) {
        BoxedUnit boxedUnit;
        Path assertionsPath = new Path(DatasetArea$.MODULE$.assertions(this.settings), filename);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Loading assertions {}", new Object[]{assertionsPath});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.storage.exists(assertionsPath)) {
            BoxedUnit boxedUnit2;
            String content = Formatter$.MODULE$.RichFormatter(this.storage.read(assertionsPath)).richFormat(this.activeEnv(this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), this.settings);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("reading content {}", new Object[]{content});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return ((AssertionDefinitions)this.mapper().readValue(content, AssertionDefinitions.class)).assertionDefinitions();
        }
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, AssertionDefinition> assertions(String name) throws Exception {
        Map<String, AssertionDefinition> defaultAssertions = this.loadAssertions("default.comet.yml");
        Map<String, AssertionDefinition> assertions = this.loadAssertions("assertions.comet.yml");
        Map<String, AssertionDefinition> resAssertions = this.loadAssertions(new StringBuilder(10).append(name).append(".comet.yml").toString());
        return defaultAssertions.$plus$plus(assertions).$plus$plus(resAssertions);
    }

    private Tuple2<String, String> loadSqlJ2File(Path sqlFile) {
        String sqlExpr = this.storage.read(sqlFile);
        String sqlName = (String)new StringOps(Predef$.MODULE$.augmentString(sqlFile.getName())).dropRight(".sql.j2".length());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sqlName), (Object)sqlExpr);
    }

    private Map<String, String> loadSqlJi2Files(Path path) {
        Path x$1 = path;
        String x$2 = ".sql.j2";
        boolean x$3 = true;
        LocalDateTime x$4 = this.storage.list$default$3();
        Option<Pattern> x$5 = this.storage.list$default$5();
        List<Path> sqlFiles = this.storage.list(x$1, x$2, x$4, x$3, x$5);
        return ((TraversableOnce)sqlFiles.map((Function1 & Serializable & scala.Serializable)sqlFile -> this.loadSqlJ2File((Path)sqlFile), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> viewsMap() {
        return this.viewsMap;
    }

    private void viewsMap_$eq(Map<String, String> x$1) {
        this.viewsMap = x$1;
    }

    public Option<String> views(String viewName) {
        return this.viewsMap().get((Object)viewName);
    }

    private Map<String, String> cometDateVars() {
        return this.cometDateVars;
    }

    public Map<String, String> activeEnv(boolean reload) {
        if (reload) {
            return this.loadActiveEnv();
        }
        return this._activeEnv();
    }

    public boolean activeEnv$default$1() {
        return false;
    }

    private Map<String, String> _activeEnv() {
        return this._activeEnv;
    }

    private void _activeEnv_$eq(Map<String, String> x$1) {
        this._activeEnv = x$1;
    }

    private Map<String, String> loadActiveEnv() throws Exception {
        Path globalsCometPath = new Path(DatasetArea$.MODULE$.metadata(this.settings), "env.comet.yml");
        Path envsCometPath = new Path(DatasetArea$.MODULE$.metadata(this.settings), new StringBuilder(14).append("env.").append(this.settings.comet().env()).append(".comet.yml").toString());
        Map globalEnv = this.loadEnv$1(globalsCometPath).mapValues((Function1 & Serializable & scala.Serializable)x$12 -> Formatter$.MODULE$.RichFormatter((String)x$12).richFormat((Map<String, String>)scala.sys.package$.MODULE$.env(), this.cometDateVars(), $this.settings));
        Map localEnv = this.loadEnv$1(envsCometPath).mapValues((Function1 & Serializable & scala.Serializable)x$13 -> Formatter$.MODULE$.RichFormatter((String)x$13).richFormat((Map<String, String>)scala.sys.package$.MODULE$.env(), (Map<String, String>)globalEnv.$plus$plus(this.cometDateVars()), $this.settings));
        this._activeEnv_$eq((Map<String, String>)this.cometDateVars().$plus$plus((GenTraversableOnce)globalEnv).$plus$plus((GenTraversableOnce)localEnv));
        return this._activeEnv();
    }

    public Option<Type> getType(String tpe) {
        return this.types(this.types$default$1()).find((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$getType$1(tpe, x$14)));
    }

    public List<Tuple2<Path, Try<Domain>>> deserializedDomains() {
        return this.deserializedDomains;
    }

    public void deserializedDomains_$eq(List<Tuple2<Path, Try<Domain>>> x$1) {
        this.deserializedDomains = x$1;
    }

    public List<Domain> domains(boolean reload) {
        if (reload) {
            return this.loadDomains();
        }
        return this._domains();
    }

    public boolean domains$default$1() {
        return false;
    }

    private List<Domain> _domains() {
        return this._domains;
    }

    private void _domains_$eq(List<Domain> x$1) {
        this._domains = x$1;
    }

    private List<Domain> loadDomains() throws Exception {
        Tuple2 tuple2 = ((TraversableLike)this.deserializedDomains().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Try try_;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                Try try_2 = (Try)tuple2._2();
                if (try_2 instanceof Success) {
                    Success success = (Success)try_2;
                    Domain domain = (Domain)success.value();
                    Path folder = path.getParent();
                    List schemaRefs = (List)((List)((List)domain.tableRefs().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)ref -> {
                        if (!ref.startsWith("_")) {
                            throw new Exception(new StringBuilder(74).append("reference to a schema should start with '_' in domain ").append(domain.name()).append(" in ").append(path).append(" for schema ref ").append((String)ref).toString());
                        }
                        String refFullName = ref.endsWith(".yml") || ref.endsWith(".yaml") ? ref : new StringBuilder(10).append((String)ref).append(".comet.yml").toString();
                        Path schemaPath = new Path(folder, refFullName);
                        return YamlSerializer$.MODULE$.deserializeSchemas(Formatter$.MODULE$.RichFormatter($this.storage.read(schemaPath)).richFormat(this.activeEnv(this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings), schemaPath.toString());
                    }, List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> x$15.tables(), List$.MODULE$.canBuildFrom());
                    List list = (List)Option$.MODULE$.apply(domain.tables()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                    List x$1 = schemaRefs.$colon$colon$colon(list);
                    String x$2 = domain.copy$default$1();
                    Option<String> x$3 = domain.copy$default$2();
                    Option<Metadata> x$4 = domain.copy$default$3();
                    Option<List<String>> x$5 = domain.copy$default$4();
                    Option<String> x$6 = domain.copy$default$6();
                    Option<List<String>> x$7 = domain.copy$default$7();
                    Option<String> x$8 = domain.copy$default$8();
                    Option<Set<String>> x$9 = domain.copy$default$9();
                    Option<String> x$10 = domain.copy$default$10();
                    return new Success((Object)domain.copy(x$2, x$3, x$4, x$5, (List<Schema>)x$1, x$6, x$7, x$8, x$9, x$10));
                }
            }
            if (tuple2 != null && (try_ = (Try)tuple2._2()) instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                Utils$.MODULE$.logException(this.logger(), e);
                return new Failure(e);
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.isSuccess()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List validDomainsFile = (List)tuple2._1();
        List invalidDomainsFiles = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validDomainsFile, (Object)invalidDomainsFiles);
        List validDomainsFile2 = (List)tuple22._1();
        List invalidDomainsFiles2 = (List)tuple22._2();
        invalidDomainsFiles2.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            SchemaHandler.$anonfun$loadDomains$7(this, x0$2);
            return BoxedUnit.UNIT;
        });
        List domains = (List)((List)validDomainsFile2.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Try<Domain>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    Domain domain = (Domain)success.value();
                    return (B1)domain;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Try<Domain> x1) {
                Try<Domain> try_ = x1;
                return try_ instanceof Success;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)domain -> this.fromXSD((Domain)domain), List$.MODULE$.canBuildFrom());
        Either<List<String>, Object> either = Utils$.MODULE$.duplicates((List<String>)((List)domains.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.name(), List$.MODULE$.canBuildFrom())), "%s is defined %d times. A domain can only be defined once.");
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                List errors = (List)left.value();
                errors.foreach((Function1 & Serializable & scala.Serializable)x$20 -> {
                    SchemaHandler.$anonfun$loadDomains$10(this, x$20);
                    return BoxedUnit.UNIT;
                });
                throw new Exception("Duplicated domain name(s)");
            }
            throw new MatchError(either);
        }
        Either<List<String>, Object> either2 = Utils$.MODULE$.duplicates((List<String>)((List)domains.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.resolveDirectory(), List$.MODULE$.canBuildFrom())), "%s is defined %d times. A directory can only appear once in a domain definition file.");
        if (!(either2 instanceof Right)) {
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                List errors = (List)left.value();
                errors.foreach((Function1 & Serializable & scala.Serializable)x$22 -> {
                    SchemaHandler.$anonfun$loadDomains$12(this, x$22);
                    return BoxedUnit.UNIT;
                });
                throw new Exception("Duplicated domain directory name");
            }
            throw new MatchError(either2);
        }
        this._domains_$eq((List<Domain>)domains);
        return this._domains();
    }

    public Set<String> checkVarsAreDefined(Path path) {
        Set<String> vars = Formatter$.MODULE$.RichFormatter(this.storage.read(path)).extractVars(this.settings);
        Set envVars = this.activeEnv(this.activeEnv$default$1()).keySet();
        Set undefinedVars = (Set)vars.diff((GenSet)envVars);
        return (Set)undefinedVars.map((Function1 & Serializable & scala.Serializable)undefVar -> new StringBuilder(26).append(path.toString()).append(" contains undefined vars: ").append((String)undefVar).toString(), Set$.MODULE$.canBuildFrom());
    }

    public Try<AutoJobDesc> loadJobFromFile(Path path) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            JsonNode jsonNode;
            JsonNode rootNode = this.mapper().readTree(Formatter$.MODULE$.RichFormatter($this.storage.read(path)).richFormat(this.activeEnv(this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings));
            JsonNode tranformNode = rootNode.path("transform");
            if (tranformNode.isNull() || tranformNode.isMissingNode()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Defining a autojob outside a transform node is now deprecated. Please update definition {}", new Object[]{path});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                jsonNode = rootNode;
            } else {
                jsonNode = tranformNode;
            }
            JsonNode autojobNode = jsonNode;
            ArrayNode tasksNode = (ArrayNode)autojobNode.path("tasks");
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tasksNode.size()).foreach((Function1 & Serializable & scala.Serializable)i -> SchemaHandler.$anonfun$loadJobFromFile$2(tasksNode, BoxesRunTime.unboxToInt((Object)i)));
            AutoJobDesc jobDesc = (AutoJobDesc)this.mapper().treeToValue((TreeNode)autojobNode, AutoJobDesc.class);
            String sqlFilePrefix = path.toString().substring(0, path.toString().length() - ".comet.yml".length());
            List tasks = (List)jobDesc.tasks().map(arg_0 -> SchemaHandler.$anonfun$loadJobFromFile$3(this, sqlFilePrefix, arg_0), List$.MODULE$.canBuildFrom());
            String jobName = this.finalDomainOrJobName(path, jobDesc.name());
            return jobDesc.copy(jobName, (List<AutoTaskDesc>)tasks, jobDesc.copy$default$3(), jobDesc.copy$default$4(), jobDesc.copy$default$5(), jobDesc.copy$default$6(), jobDesc.copy$default$7(), jobDesc.copy$default$8(), jobDesc.copy$default$9(), jobDesc.copy$default$10());
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AutoJobDesc value = (AutoJobDesc)success.value();
            return new Success((Object)value);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return new Failure((Throwable)new Exception(new StringBuilder(20).append("Invalid Job file: ").append(path).append("(").append(exception.getMessage()).append(")").toString(), exception));
        }
        throw new MatchError((Object)try_);
    }

    private String finalDomainOrJobName(Path path, String name) {
        String string = path.getName();
        String string2 = new StringBuilder(10).append(name).append(".comet.yml").toString();
        if (string == null ? string2 != null : !string.equals(string2)) {
            BoxedUnit boxedUnit;
            String newJobName = path.getName().substring(0, path.getName().length() - ".comet.yml".length());
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("deprecated: Please set the job name of {} to reflect the filename. Job renamed to {}. This feature will be removed soon", new Object[]{path.getName(), newJobName});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return newJobName;
        }
        return name;
    }

    public Map<String, AutoJobDesc> jobs(boolean reload) {
        if (reload) {
            return this.loadJobs();
        }
        return this._jobs();
    }

    public boolean jobs$default$1() {
        return false;
    }

    private Map<String, AutoJobDesc> _jobs() {
        return this._jobs;
    }

    private void _jobs_$eq(Map<String, AutoJobDesc> x$1) {
        this._jobs = x$1;
    }

    private Map<String, AutoJobDesc> loadJobs() throws Exception {
        Option<Pattern> x$5;
        Path x$1 = DatasetArea$.MODULE$.jobs(this.settings);
        String x$2 = ".yml";
        boolean x$3 = true;
        LocalDateTime x$4 = this.storage.list$default$3();
        List<Path> jobs = this.storage.list(x$1, x$2, x$4, x$3, x$5 = this.storage.list$default$5());
        Tuple2 tuple2 = ((TraversableLike)jobs.map((Function1 & Serializable & scala.Serializable)path -> this.loadJobFromFile((Path)path), List$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.isSuccess()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List validJobsFile = (List)tuple2._1();
        List invalidJobsFile = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validJobsFile, (Object)invalidJobsFile);
        List validJobsFile2 = (List)tuple22._1();
        List invalidJobsFile2 = (List)tuple22._2();
        invalidJobsFile2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SchemaHandler.$anonfun$loadJobs$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this._jobs_$eq((Map<String, AutoJobDesc>)((TraversableOnce)((List)validJobsFile2.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Try<AutoJobDesc>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    AutoJobDesc job = (AutoJobDesc)success.value();
                    return (B1)job;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Try<AutoJobDesc> x1) {
                Try<AutoJobDesc> try_ = x1;
                return try_ instanceof Success;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)job -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)job.name()), job), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        return this._jobs();
    }

    public Option<Domain> getDomain(String name) {
        return this.domains(this.domains$default$1()).find((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$getDomain$1(name, x$25)));
    }

    public List<Schema> getSchemas(String domain) {
        return (List)this.getDomain(domain).map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.tables()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Option<Schema> getSchema(String domainName, String schemaName) {
        return this.getDomain(domainName).flatMap((Function1 & Serializable & scala.Serializable)domain -> domain.tables().find((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)SchemaHandler.$anonfun$getSchema$2(schemaName, x$27))).map((Function1 & Serializable & scala.Serializable)schema -> schema));
    }

    public Domain fromXSD(Domain domain) {
        List tables;
        Option<Metadata> domainMetadata = domain.metadata();
        List x$1 = tables = (List)domain.tables().map((Function1 & Serializable & scala.Serializable)table -> this.fromXSD((Schema)table, domainMetadata), List$.MODULE$.canBuildFrom());
        String x$2 = domain.copy$default$1();
        Option<String> x$3 = domain.copy$default$2();
        Option<Metadata> x$4 = domain.copy$default$3();
        Option<List<String>> x$5 = domain.copy$default$4();
        Option<String> x$6 = domain.copy$default$6();
        Option<List<String>> x$7 = domain.copy$default$7();
        Option<String> x$8 = domain.copy$default$8();
        Option<Set<String>> x$9 = domain.copy$default$9();
        Option<String> x$10 = domain.copy$default$10();
        return domain.copy(x$2, x$3, x$4, x$5, (List<Schema>)x$1, x$6, x$7, x$8, x$9, x$10);
    }

    public Schema fromXSD(Schema ymlSchema, Option<Metadata> domainMetadata) {
        Metadata metadata = ymlSchema.mergedMetadata(domainMetadata);
        Option<String> option = metadata.getXsdPath();
        if (None$.MODULE$.equals(option)) {
            return ymlSchema;
        }
        if (option instanceof Some) {
            List<Attribute> merged;
            Some some = (Some)option;
            String xsd = (String)some.value();
            String xsdContent = this.storage.read(new Path(xsd));
            StructType sparkType = XSDToSchema$.MODULE$.read(xsdContent);
            Attribute[] topElement = (Attribute[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkType.fields())).map((Function1 & Serializable & scala.Serializable)field -> Attribute$.MODULE$.apply((StructField)field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            List xsdAttributes = (List)((Attribute)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topElement)).head()).attributes().map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            List<Attribute> x$1 = merged = this.mergeAttributes(ymlSchema.attributes(), (List<Attribute>)xsdAttributes);
            String x$2 = ymlSchema.copy$default$1();
            Pattern x$3 = ymlSchema.copy$default$2();
            Option<Metadata> x$4 = ymlSchema.copy$default$4();
            Option<MergeOptions> x$5 = ymlSchema.copy$default$5();
            Option<String> x$6 = ymlSchema.copy$default$6();
            Option<List<String>> x$7 = ymlSchema.copy$default$7();
            Option<List<String>> x$8 = ymlSchema.copy$default$8();
            Option<Set<String>> x$9 = ymlSchema.copy$default$9();
            Option<List<RowLevelSecurity>> x$10 = ymlSchema.copy$default$10();
            Option<Map<String, String>> x$11 = ymlSchema.copy$default$11();
            Option<List<String>> x$12 = ymlSchema.copy$default$12();
            Option<List<AccessControlEntry>> x$13 = ymlSchema.copy$default$13();
            Option<String> x$14 = ymlSchema.copy$default$14();
            return ymlSchema.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
        }
        throw new MatchError(option);
    }

    public List<Attribute> mergeAttributes(List<Attribute> ymlAttrs, List<Attribute> xsdAttrs) {
        String x$1 = "__dummy";
        String x$2 = "struct";
        Some x$3 = new Some(ymlAttrs);
        Option<Object> x$4 = Attribute$.MODULE$.apply$default$3();
        boolean x$5 = Attribute$.MODULE$.apply$default$4();
        PrivacyLevel x$6 = Attribute$.MODULE$.apply$default$5();
        Option<String> x$7 = Attribute$.MODULE$.apply$default$6();
        Option<String> x$8 = Attribute$.MODULE$.apply$default$7();
        Option<MetricType> x$9 = Attribute$.MODULE$.apply$default$8();
        Option<Position> x$10 = Attribute$.MODULE$.apply$default$10();
        Option<String> x$11 = Attribute$.MODULE$.apply$default$11();
        Option<Set<String>> x$12 = Attribute$.MODULE$.apply$default$12();
        Option<Trim> x$13 = Attribute$.MODULE$.apply$default$13();
        Option<String> x$14 = Attribute$.MODULE$.apply$default$14();
        Option<String> x$15 = Attribute$.MODULE$.apply$default$15();
        Option<Object> x$16 = Attribute$.MODULE$.apply$default$16();
        Option<String> x$17 = Attribute$.MODULE$.apply$default$17();
        Attribute ymlTopLevelAttr = new Attribute(x$1, x$2, x$4, x$5, x$6, x$7, x$8, x$9, (Option<List<Attribute>>)x$3, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        String x$18 = "__dummy";
        String x$19 = "struct";
        Some x$20 = new Some(xsdAttrs);
        Option<Object> x$21 = Attribute$.MODULE$.apply$default$3();
        boolean x$22 = Attribute$.MODULE$.apply$default$4();
        PrivacyLevel x$23 = Attribute$.MODULE$.apply$default$5();
        Option<String> x$24 = Attribute$.MODULE$.apply$default$6();
        Option<String> x$25 = Attribute$.MODULE$.apply$default$7();
        Option<MetricType> x$26 = Attribute$.MODULE$.apply$default$8();
        Option<Position> x$27 = Attribute$.MODULE$.apply$default$10();
        Option<String> x$28 = Attribute$.MODULE$.apply$default$11();
        Option<Set<String>> x$29 = Attribute$.MODULE$.apply$default$12();
        Option<Trim> x$30 = Attribute$.MODULE$.apply$default$13();
        Option<String> x$31 = Attribute$.MODULE$.apply$default$14();
        Option<String> x$32 = Attribute$.MODULE$.apply$default$15();
        Option<Object> x$33 = Attribute$.MODULE$.apply$default$16();
        Option<String> x$34 = Attribute$.MODULE$.apply$default$17();
        Attribute xsdTopLevelAttr = new Attribute(x$18, x$19, x$21, x$22, x$23, x$24, x$25, x$26, (Option<List<Attribute>>)x$20, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34);
        Attribute merged = xsdTopLevelAttr.importAttr(ymlTopLevelAttr);
        return (List)merged.attributes().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$fullValidation$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Try res = (Try)tuple2._2();
            return res.isFailure();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$fullValidation$6(SchemaHandler $this, Option output$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Path path = (Path)tuple2._1();
            output$1.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                String x$62 = new StringBuilder(26).append(path.toString()).append(" could not be deserialized").toString();
                Charset x$7 = x$6.appendLine$default$2(x$62);
                return x$6.appendLine(x$62, x$7);
            });
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("{} could not be deserialized", new Object[]{path.toString()});
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$fullValidation$8(SchemaHandler $this, String err) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error(err);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkViewsValidity$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            List paths = (List)tuple2._2();
            return paths.length() > 1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$loadTypes$3(List redefinedTypeNames$1, Type defaultType) {
        return !redefinedTypeNames$1.contains((Object)defaultType.name());
    }

    private final Map loadEnv$1(Path path) {
        if (this.storage.exists(path)) {
            return (Map)Option$.MODULE$.apply(((Env)this.mapper().readValue(this.storage.read(path), Env.class)).env().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        }
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ boolean $anonfun$getType$1(String tpe$1, Type x$14) {
        String string = x$14.name();
        String string2 = tpe$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$loadDomains$7(SchemaHandler $this, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("There is one or more invalid Yaml files in your domains folder:{}", new Object[]{err.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if ($this.settings.comet().validateOnLoad()) {
                throw err;
            }
            return;
        }
        if (try_ instanceof Success) {
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$loadDomains$10(SchemaHandler $this, String x$20) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error(x$20);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$loadDomains$12(SchemaHandler $this, String x$22) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isErrorEnabled()) {
            $this.logger().underlying().error(x$22);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ Object $anonfun$loadJobFromFile$2(ArrayNode tasksNode$1, int i) {
        ObjectNode taskNode = (ObjectNode)tasksNode$1.get(i);
        return YamlSerializer$.MODULE$.renameField(taskNode, "dataset", "table");
    }

    public static final /* synthetic */ String $anonfun$loadJobFromFile$4() {
        return "";
    }

    public static final /* synthetic */ StorageArea $anonfun$loadJobFromFile$5(SchemaHandler $this, StorageArea area) {
        return StorageArea$.MODULE$.fromString(Formatter$.MODULE$.RichFormatter(area.value()).richFormat($this.activeEnv($this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings), $this.settings);
    }

    public static final /* synthetic */ AutoTaskDesc $anonfun$loadJobFromFile$6(SchemaHandler $this, AutoTaskDesc taskDesc$1, Path taskFile) {
        SqlTaskExtractor sqlTask = SqlTaskExtractor$.MODULE$.apply($this.storage.read(taskFile));
        String x$15 = Formatter$.MODULE$.RichFormatter((String)Option$.MODULE$.apply((Object)taskDesc$1.domain()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).richFormat($this.activeEnv($this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings);
        String x$16 = Formatter$.MODULE$.RichFormatter(taskDesc$1.table()).richFormat($this.activeEnv($this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings);
        Option x$17 = taskDesc$1.area().map((Function1 & Serializable & scala.Serializable)area -> StorageArea$.MODULE$.fromString(Formatter$.MODULE$.RichFormatter(area.value()).richFormat($this.activeEnv($this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings), $this.settings));
        Option<List<String>> x$18 = sqlTask.presql();
        Option x$19 = Option$.MODULE$.apply((Object)sqlTask.sql());
        Option<List<String>> x$20 = sqlTask.postsql();
        Option<String> x$21 = taskDesc$1.copy$default$1();
        WriteMode x$22 = taskDesc$1.copy$default$5();
        Option<List<String>> x$23 = taskDesc$1.copy$default$6();
        Option<Sink> x$24 = taskDesc$1.copy$default$10();
        Option<List<RowLevelSecurity>> x$25 = taskDesc$1.copy$default$11();
        Option<Map<String, String>> x$26 = taskDesc$1.copy$default$12();
        Option<Engine> x$27 = taskDesc$1.copy$default$13();
        Option<List<AccessControlEntry>> x$28 = taskDesc$1.copy$default$14();
        return taskDesc$1.copy(x$21, (Option<String>)x$19, x$15, x$16, x$22, x$23, x$18, x$20, (Option<StorageArea>)x$17, x$24, x$25, x$26, x$27, x$28);
    }

    public static final /* synthetic */ AutoTaskDesc $anonfun$loadJobFromFile$9(AutoTaskDesc taskDesc$1) {
        return taskDesc$1;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ AutoTaskDesc $anonfun$loadJobFromFile$3(SchemaHandler $this, String sqlFilePrefix$1, AutoTaskDesc taskDesc) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        var7_3 = taskDesc.name();
                        if (var7_3 instanceof Some) {
                            var8_4 = (Some)var7_3;
                            taskName = (String)var8_4.value();
                            v0 = new Path(new StringBuilder(5).append(sqlFilePrefix$1).append(".").append(taskName).append(".sql").toString());
                        } else if (None$.MODULE$.equals(var7_3)) {
                            v0 = new Path(new StringBuilder(4).append(sqlFilePrefix$1).append(".sql").toString());
                        } else {
                            throw new MatchError(var7_3);
                        }
                        sqlTaskFile = v0;
                        var11_7 = taskDesc.name();
                        if (var11_7 instanceof Some) {
                            var12_8 = (Some)var11_7;
                            taskName = (String)var12_8.value();
                            v1 = new Path(new StringBuilder(8).append(sqlFilePrefix$1).append(".").append(taskName).append(".sql.j2").toString());
                        } else if (None$.MODULE$.equals(var11_7)) {
                            v1 = new Path(new StringBuilder(7).append(sqlFilePrefix$1).append(".sql.j2").toString());
                        } else {
                            throw new MatchError(var11_7);
                        }
                        j2TaskFile = v1;
                        x$1 = Formatter$.MODULE$.RichFormatter((String)Option$.MODULE$.apply((Object)taskDesc.domain()).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$loadJobFromFile$4(), ()Ljava/lang/String;)())).richFormat($this.activeEnv($this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings);
                        x$2 = Formatter$.MODULE$.RichFormatter(taskDesc.table()).richFormat($this.activeEnv($this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings);
                        x$3 = taskDesc.area().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$loadJobFromFile$5(ai.starlake.schema.handlers.SchemaHandler ai.starlake.config.StorageArea ), (Lai/starlake/config/StorageArea;)Lai/starlake/config/StorageArea;)((SchemaHandler)$this));
                        x$4 = taskDesc.copy$default$1();
                        x$5 = taskDesc.copy$default$2();
                        x$6 = taskDesc.copy$default$5();
                        x$7 = taskDesc.copy$default$6();
                        x$8 = taskDesc.copy$default$7();
                        x$9 = taskDesc.copy$default$8();
                        x$10 = taskDesc.copy$default$10();
                        x$11 = taskDesc.copy$default$11();
                        x$12 = taskDesc.copy$default$12();
                        x$13 = taskDesc.copy$default$13();
                        x$14 = taskDesc.copy$default$14();
                        commonTaskDesc = taskDesc.copy(x$4, x$5, x$1, x$2, x$6, x$7, x$8, x$9, (Option<StorageArea>)x$3, x$10, x$11, x$12, x$13, x$14);
                        var30_26 = new Tuple2.mcZZ.sp($this.storage.exists(sqlTaskFile), $this.storage.exists(j2TaskFile));
                        if (var30_26 == null) break block10;
                        var31_27 = var30_26._1$mcZ$sp();
                        var32_28 = var30_26._2$mcZ$sp();
                        if (!var31_27 || !var32_28) break block10;
                        v2 = new Some((Object)j2TaskFile);
                        break block11;
                    }
                    if (var30_26 == null) break block12;
                    var33_29 = var30_26._1$mcZ$sp();
                    var34_30 = var30_26._2$mcZ$sp();
                    if (!var33_29 || var34_30) break block12;
                    v2 = new Some((Object)sqlTaskFile);
                    break block11;
                }
                if (var30_26 == null) break block13;
                var35_31 = var30_26._1$mcZ$sp();
                var36_32 = var30_26._2$mcZ$sp();
                if (var35_31 || !var36_32) break block13;
                v2 = new Some((Object)j2TaskFile);
                break block11;
            }
            if (var30_26 == null) ** GOTO lbl-1000
            var37_33 = var30_26._1$mcZ$sp();
            var38_34 = var30_26._2$mcZ$sp();
            if (!var37_33 && !var38_34) {
                v2 = None$.MODULE$;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var30_26);
            }
        }
        taskFile = v2;
        return (AutoTaskDesc)taskFile.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$loadJobFromFile$6(ai.starlake.schema.handlers.SchemaHandler ai.starlake.schema.model.AutoTaskDesc org.apache.hadoop.fs.Path ), (Lorg/apache/hadoop/fs/Path;)Lai/starlake/schema/model/AutoTaskDesc;)((SchemaHandler)$this, (AutoTaskDesc)taskDesc)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$loadJobFromFile$9(ai.starlake.schema.model.AutoTaskDesc ), ()Lai/starlake/schema/model/AutoTaskDesc;)((AutoTaskDesc)taskDesc));
    }

    public static final /* synthetic */ void $anonfun$loadJobs$3(SchemaHandler $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            err.printStackTrace();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("There is one or more invalid Yaml files in your jobs folder:{}", new Object[]{err.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if ($this.settings.comet().validateOnLoad()) {
                throw err;
            }
            return;
        }
        if (try_ instanceof Success) {
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$getDomain$1(String name$1, Domain x$25) {
        String string = x$25.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSchema$2(String schemaName$1, Schema x$27) {
        String string = x$27.name();
        String string2 = schemaName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SchemaHandler(StorageHandler storage, Settings settings) {
        this.storage = storage;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        Tuple2 tuple2 = new Tuple2(Settings.class, (Object)settings);
        this.mapper = new CometObjectMapper((JsonFactory)new YAMLFactory(), (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$.$colon$colon((Object)tuple2));
        this._types = this.loadTypes();
        this.viewsMap = this.loadSqlJi2Files(DatasetArea$.MODULE$.views(settings));
        LocalDateTime today = LocalDateTime.now();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("yyyy");
        DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MM");
        DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("dd");
        DateTimeFormatter hourFormatter = DateTimeFormatter.ofPattern("HH");
        DateTimeFormatter minuteFormatter = DateTimeFormatter.ofPattern("mm");
        DateTimeFormatter secondFormatter = DateTimeFormatter.ofPattern("ss");
        DateTimeFormatter milliFormatter = DateTimeFormatter.ofPattern("SSS");
        long epochMillis = today.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        this.cometDateVars = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_date"), (Object)today.format(dateFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_datetime"), (Object)today.format(dateTimeFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_year"), (Object)today.format(yearFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_month"), (Object)today.format(monthFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_day"), (Object)today.format(dayFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_hour"), (Object)today.format(hourFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_minute"), (Object)today.format(minuteFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_second"), (Object)today.format(secondFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_milli"), (Object)today.format(milliFormatter)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_epoch_second"), (Object)Long.toString(epochMillis / 1000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comet_epoch_milli"), (Object)Long.toString(epochMillis))}));
        this._activeEnv = this.loadActiveEnv();
        Path x$1 = DatasetArea$.MODULE$.domains(settings);
        String x$2 = ".yml";
        boolean x$3 = true;
        Some x$4 = new Some((Object)Pattern.compile("_.*"));
        LocalDateTime x$5 = storage.list$default$3();
        List<Path> paths = storage.list(x$1, x$2, x$5, x$3, (Option<Pattern>)x$4);
        List domains = (List)paths.map((Function1 & Serializable & scala.Serializable)path -> YamlSerializer$.MODULE$.deserializeDomain(Formatter$.MODULE$.RichFormatter($this.storage.read((Path)path)).richFormat(this.activeEnv(this.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), $this.settings), path.toString()), List$.MODULE$.canBuildFrom());
        this.deserializedDomains = (List)paths.zip((GenIterable)domains, List$.MODULE$.canBuildFrom());
        this._domains = this.loadDomains();
        this._jobs = this.loadJobs();
    }
}

