/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.config.UdfRegistration;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.Metadata$;
import ai.starlake.schema.model.SinkType;
import ai.starlake.schema.model.SinkType$BQ$;
import ai.starlake.schema.model.SinkType$FS$;
import ai.starlake.schema.model.SinkType$JDBC$;
import ai.starlake.schema.model.SinkType$KAFKA$;
import ai.starlake.schema.model.Views;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.Utils$;
import ai.starlake.utils.kafka.KafkaClient;
import ai.starlake.utils.kafka.KafkaClient$;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015ea\u0002\t\u0012!\u0003\r\t\u0001\u0007\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006Q\u0001!\t\"\u000b\u0005\tm\u0001A)\u0019!C\u0005o!)a\b\u0001C\t\u007f!AQ\n\u0001EC\u0002\u0013\u0005a\nC\u0003V\u0001\u0011%a\u000bC\u0003s\u0001\u0011E1\u000fC\u0003~\u0001\u0011Ea\u0010C\u0004\u0002\u0004\u0001!\t\"!\u0002\t\u000f\u0005E\u0001\u0001\"\u0005\u0002\u0014!9\u00111\t\u0001\u0005\u0012\u0005\u0015\u0003bBA0\u0001\u0011%\u0011\u0011\r\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!! \u0001\t\u0013\tyH\u0001\u0005Ta\u0006\u00148NS8c\u0015\t\u00112#A\u0003vi&d7O\u0003\u0002\u0015+\u0005A1\u000f^1sY\u0006\\WMC\u0001\u0017\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011!E\u0005\u0003EE\u0011qAS8c\u0005\u0006\u001cX-\u0001\u0004%S:LG\u000f\n\u000b\u0002KA\u0011!DJ\u0005\u0003Om\u0011A!\u00168ji\u0006\u0011r/\u001b;i\u000bb$(/Y*qCJ\\7i\u001c8g)\tQC\u0007\u0005\u0002,e5\tAF\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0013\t\u0019DFA\u0005Ta\u0006\u00148nQ8oM\")QG\u0001a\u0001U\u0005a1o\\;sG\u0016\u001cuN\u001c4jO\u0006A1\u000f]1sW\u0016sg/F\u00019!\tID(D\u0001;\u0015\tY4#\u0001\u0004d_:4\u0017nZ\u0005\u0003{i\u0012\u0001b\u00159be.,eN^\u0001\fe\u0016<\u0017n\u001d;feV#g\r\u0006\u0002&\u0001\")\u0011\t\u0002a\u0001\u0005\u0006\u0019Q\u000f\u001a4\u0011\u0005\rSeB\u0001#I!\t)5$D\u0001G\u0015\t9u#\u0001\u0004=e>|GOP\u0005\u0003\u0013n\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011jG\u0001\bg\u0016\u001c8/[8o+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*-\u0003\r\u0019\u0018\u000f\\\u0005\u0003)F\u0013Ab\u00159be.\u001cVm]:j_:\f!CY;jY\u0012\u0004\u0016M\u001d;ji&|g.\u001a3E\rR\u0019qK\u001a5\u0011\u0005a\u001bgBA-b\u001d\tQ\u0006M\u0004\u0002\\?:\u0011AL\u0018\b\u0003\u000bvK\u0011!M\u0005\u0003_AJ!!\f\u0018\n\u0005Ic\u0013B\u00012R\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Z3\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00012R\u0011\u00159g\u00011\u0001X\u0003\u001d!\u0017\r^1tKRDQ!\u001b\u0004A\u0002)\fAaY8mgB\u00191n\u001c\"\u000f\u00051tgBA#n\u0013\u0005a\u0012B\u00012\u001c\u0013\t\u0001\u0018O\u0001\u0003MSN$(B\u00012\u001c\u0003a\u0001\u0018M\u001d;ji&|g.\u001a3ECR\f7/\u001a;Xe&$XM\u001d\u000b\u0004ij\\\bc\u0001)vo&\u0011a/\u0015\u0002\u0010\t\u0006$\u0018M\u0012:b[\u0016<&/\u001b;feB\u0011\u0001\u000b_\u0005\u0003sF\u00131AU8x\u0011\u00159w\u00011\u0001X\u0011\u0015ax\u00011\u0001k\u0003%\u0001\u0018M\u001d;ji&|g.\u0001\tqCJ$\u0018\u000e^5p]\u0012\u000bG/Y:fiR!qk`A\u0001\u0011\u00159\u0007\u00021\u0001X\u0011\u0015a\b\u00021\u0001k\u0003\u001d\tg.\u00197zu\u0016$B!a\u0002\u0002\u000eA\u0019!$!\u0003\n\u0007\u0005-1DA\u0002B]fDa!a\u0004\n\u0001\u0004\u0011\u0015!\u00044vY2$\u0016M\u00197f\u001d\u0006lW-\u0001\tde\u0016\fG/Z*qCJ\\g+[3xgR9!.!\u0006\u0002*\u0005e\u0002bBA\f\u0015\u0001\u0007\u0011\u0011D\u0001\u0006m&,wo\u001d\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0015iw\u000eZ3m\u0015\r\t\u0019cE\u0001\u0007g\u000eDW-\\1\n\t\u0005\u001d\u0012Q\u0004\u0002\u0006-&,wo\u001d\u0005\b\u0003WQ\u0001\u0019AA\u0017\u00035\u00198\r[3nC\"\u000bg\u000e\u001a7feB!\u0011qFA\u001b\u001b\t\t\tD\u0003\u0003\u00024\u0005\u0005\u0012\u0001\u00035b]\u0012dWM]:\n\t\u0005]\u0012\u0011\u0007\u0002\u000e'\u000eDW-\\1IC:$G.\u001a:\t\u000f\u0005m\"\u00021\u0001\u0002>\u0005i1/\u001d7QCJ\fW.\u001a;feN\u0004RaQA \u0005\nK1!!\u0011M\u0005\ri\u0015\r]\u0001\u0010GJ,\u0017\r^3Ta\u0006\u00148NV5foR9q+a\u0012\u0002R\u0005m\u0003bBA%\u0017\u0001\u0007\u00111J\u0001\tg&t7\u000eV=qKB!\u00111DA'\u0013\u0011\ty%!\b\u0003\u0011MKgn\u001b+za\u0016Dq!a\u0015\f\u0001\u0004\t)&\u0001\u0006tS:\\7i\u001c8gS\u001e\u0004BAGA,\u0005&\u0019\u0011\u0011L\u000e\u0003\r=\u0003H/[8o\u0011\u0019\tif\u0003a\u0001\u0005\u0006!\u0001/\u0019;i\u00039\u0019'/Z1uK*#%i\u0011,jK^$b!a\u0019\u0002j\u0005-\u0004\u0003\u0002)\u0002f]L1!a\u001aR\u0005\u001d!\u0015\r^1tKRDq!a\u0015\r\u0001\u0004\t)\u0006\u0003\u0004\u0002^1\u0001\rAQ\u0001\rGJ,\u0017\r^3G'ZKWm\u001e\u000b\u0005\u0003c\n)\bE\u0002\u0002t\rt!\u0001U1\t\r\u0005uS\u00021\u0001C\u00031\u0019'/Z1uK\n\u000bf+[3x)\u0011\t\u0019'a\u001f\t\r\u0005uc\u00021\u0001C\u0003=\u0019'/Z1uK.\u000bgm[1WS\u0016<H#B,\u0002\u0002\u0006\r\u0005bBA*\u001f\u0001\u0007\u0011Q\u000b\u0005\u0007\u0003;z\u0001\u0019\u0001\"")
public interface SparkJob
extends JobBase {
    public static /* synthetic */ SparkConf withExtraSparkConf$(SparkJob $this, SparkConf sourceConfig) {
        return $this.withExtraSparkConf(sourceConfig);
    }

    default public SparkConf withExtraSparkConf(SparkConf sourceConfig) {
        BoxedUnit boxedUnit;
        sourceConfig.remove("spark.datasource.bigquery.allowFieldAddition");
        sourceConfig.remove("spark.datasource.bigquery.allowFieldRelaxation");
        String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss.SSS"));
        String appName = new StringBuilder(1).append(this.name()).append("-").append(now).toString();
        SparkConf thisConf = sourceConfig.setAppName(appName).set("spark.app.id", appName);
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(thisConf.toDebugString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return thisConf;
    }

    public static /* synthetic */ SparkEnv ai$starlake$utils$SparkJob$$sparkEnv$(SparkJob $this) {
        return $this.ai$starlake$utils$SparkJob$$sparkEnv();
    }

    default public SparkEnv ai$starlake$utils$SparkJob$$sparkEnv() {
        return new SparkEnv(this.name(), (Function1<SparkConf, SparkConf>)(Function1 & Serializable & scala.Serializable)sourceConfig -> this.withExtraSparkConf((SparkConf)sourceConfig), this.settings());
    }

    public static /* synthetic */ void registerUdf$(SparkJob $this, String udf) {
        $this.registerUdf(udf);
    }

    default public void registerUdf(String udf) {
        UdfRegistration udfInstance = (UdfRegistration)Class.forName(udf).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        udfInstance.register(this.ai$starlake$utils$SparkJob$$sparkEnv().session());
    }

    public static /* synthetic */ SparkSession session$(SparkJob $this) {
        return $this.session();
    }

    default public SparkSession session() {
        List udfs2 = (List)this.settings().comet().udfs().map((Function1 & Serializable & scala.Serializable)udfs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(udfs)).split(','))).toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        udfs2.foreach((Function1 & Serializable & scala.Serializable)udf -> {
            this.registerUdf(udf);
            return BoxedUnit.UNIT;
        });
        return this.ai$starlake$utils$SparkJob$$sparkEnv().session();
    }

    private Dataset<Row> buildPartitionedDF(Dataset<Row> dataset, List<String> cols) {
        ObjectRef partitionedDF = ObjectRef.create((Object)dataset.withColumn("comet_date", functions$.MODULE$.current_timestamp()));
        List dataSetsCols = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.columns())).toList();
        cols.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            if ("comet_date".equals(string) && !dataSetsCols.contains((Object)"date")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("date", functions$.MODULE$.date_format(functions$.MODULE$.col("comet_date"), "yyyyMMdd").cast((DataType)IntegerType$.MODULE$));
                return BoxedUnit.UNIT;
            }
            if ("comet_year".equals(string) && !dataSetsCols.contains((Object)"year")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("year", functions$.MODULE$.year(functions$.MODULE$.col("comet_date")));
                return BoxedUnit.UNIT;
            }
            if ("comet_month".equals(string) && !dataSetsCols.contains((Object)"month")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("month", functions$.MODULE$.month(functions$.MODULE$.col("comet_date")));
                return BoxedUnit.UNIT;
            }
            if ("comet_day".equals(string) && !dataSetsCols.contains((Object)"day")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("day", functions$.MODULE$.dayofmonth(functions$.MODULE$.col("comet_date")));
                return BoxedUnit.UNIT;
            }
            if ("comet_hour".equals(string) && !dataSetsCols.contains((Object)"hour")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("hour", functions$.MODULE$.hour(functions$.MODULE$.col("comet_date")));
                return BoxedUnit.UNIT;
            }
            if ("comet_minute".equals(string) && !dataSetsCols.contains((Object)"minute")) {
                partitionedDF$1.elem = ((Dataset)partitionedDF$1.elem).withColumn("minute", functions$.MODULE$.minute(functions$.MODULE$.col("comet_date")));
                return BoxedUnit.UNIT;
            }
            return (Dataset)partitionedDF$1.elem;
        });
        return ((Dataset)partitionedDF.elem).drop("comet_date");
    }

    public static /* synthetic */ DataFrameWriter partitionedDatasetWriter$(SparkJob $this, Dataset dataset, List partition) {
        return $this.partitionedDatasetWriter((Dataset<Row>)dataset, (List<String>)partition);
    }

    default public DataFrameWriter<Row> partitionedDatasetWriter(Dataset<Row> dataset, List<String> partition) {
        List<String> list = partition;
        if (Nil$.MODULE$.equals(list)) {
            return dataset.write();
        }
        if (list.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)SparkJob.$anonfun$partitionedDatasetWriter$1(elem)))) {
            List strippedCols = (List)list.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.substring("comet_".length()), List$.MODULE$.canBuildFrom());
            Dataset<Row> partitionedDF = this.buildPartitionedDF(dataset, list);
            return partitionedDF.write().partitionBy((Seq)strippedCols);
        }
        if (!list.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)SparkJob.$anonfun$partitionedDatasetWriter$3(elem)))) {
            return dataset.write().partitionBy(list);
        }
        throw new Exception("Cannot mix comet & non comet col names");
    }

    public static /* synthetic */ Dataset partitionDataset$(SparkJob $this, Dataset dataset, List partition) {
        return $this.partitionDataset((Dataset<Row>)dataset, (List<String>)partition);
    }

    default public Dataset<Row> partitionDataset(Dataset<Row> dataset, List<String> partition) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Partitioning on {}", new Object[]{partition.mkString(",")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List<String> list = partition;
        if (Nil$.MODULE$.equals(list)) {
            return dataset;
        }
        if (list.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)SparkJob.$anonfun$partitionDataset$1(elem)))) {
            return this.buildPartitionedDF(dataset, list);
        }
        if (!list.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)SparkJob.$anonfun$partitionDataset$2(elem)))) {
            return dataset;
        }
        return dataset;
    }

    public static /* synthetic */ Object analyze$(SparkJob $this, String fullTableName) {
        return $this.analyze(fullTableName);
    }

    default public Object analyze(String fullTableName) {
        if (this.settings().comet().analyze()) {
            Some some;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("computing statistics on table {}", new Object[]{fullTableName});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String allCols = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.session().table(fullTableName).columns())).mkString(",");
            this.session().table(fullTableName);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Dataset partitionedColsDF = this.session().sql(new StringBuilder(16).append("show partitions ").append(fullTableName).toString());
                String partitionedCols = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)partitionedColsDF.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.getAs(0), this.session().implicits().newStringEncoder()).first())).split('/'))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.split("=")[0], Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList().mkString(",");
                return new Some((Object)new StringBuilder(46).append("ANALYZE TABLE ").append(fullTableName).append(" PARTITION (").append(partitionedCols).append(") COMPUTE STATISTICS").toString());
            });
            if (try_ instanceof Success) {
                Some value;
                Success success = (Success)try_;
                some = value = (Some)success.value();
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit2;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(Utils$.MODULE$.exceptionAsString(e));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            Some partitionedCols = some;
            StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString(this.session().version().substring(0, 3)));
            if (stringOps.toDouble() >= 2.4) {
                List analyzeCommands = (List)new .colon.colon((Object)new Some((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(fullTableName).append(" COMPUTE STATISTICS NOSCAN").toString()), (List)new .colon.colon((Object)partitionedCols, (List)new .colon.colon((Object)new Some((Object)new StringBuilder(46).append("ANALYZE TABLE ").append(fullTableName).append(" COMPUTE STATISTICS FOR COLUMNS ").append(allCols).toString()), (List)Nil$.MODULE$))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
                analyzeCommands.foreach((Function1 & Serializable & scala.Serializable)command -> {
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.session().sql(command));
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Dataset df = (Dataset)success.value();
                        return df;
                    }
                    if (try_ instanceof Failure) {
                        BoxedUnit boxedUnit;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Failed to compute statistics for table {} on columns {}", new Object[]{fullTableName, allCols});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        e.printStackTrace();
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)try_);
                });
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    public static /* synthetic */ List createSparkViews$(SparkJob $this, Views views, SchemaHandler schemaHandler, Map sqlParameters) {
        return $this.createSparkViews(views, schemaHandler, (Map<String, String>)sqlParameters);
    }

    default public List<String> createSparkViews(Views views, SchemaHandler schemaHandler, Map<String, String> sqlParameters) {
        return ((TraversableOnce)views.views().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Option option = Option$.MODULE$.apply((Object)value);
                if (None$.MODULE$.equals(option)) {
                    String viewContent = (String)schemaHandler.views(key).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw new Exception(new StringBuilder(13).append("Unknown view ").append(key).toString());
                    });
                    String parsedContent = this.parseJinja(viewContent, (Map<String, String>)schemaHandler.activeEnv(schemaHandler.activeEnv$default$1()).$plus$plus((GenTraversableOnce)sqlParameters));
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new StringBuilder(6).append(key).append(" AS (").append(parsedContent).append(")").toString()));
                }
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    Some some = (Some)option;
                    String value2 = (String)some.value();
                    String valueWithEnv = Formatter$.MODULE$.RichFormatter(this.parseJinja(value2, (Map<String, String>)schemaHandler.activeEnv(schemaHandler.activeEnv$default$1()).$plus$plus((GenTraversableOnce)sqlParameters))).richFormat(schemaHandler.activeEnv(schemaHandler.activeEnv$default$1()), sqlParameters, this.settings());
                    Tuple3<SinkType, Option<String>, String> tuple3 = this.parseViewDefinition(valueWithEnv);
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    SinkType sinkType = (SinkType)tuple3._1();
                    Option sinkConfig = (Option)tuple3._2();
                    String path = (String)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)sinkType, (Object)sinkConfig, (Object)path);
                    SinkType sinkType2 = (SinkType)tuple32._1();
                    Option sinkConfig2 = (Option)tuple32._2();
                    String path2 = (String)tuple32._3();
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Loading view {} from {}", new Object[]{path2, sinkType2});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    Dataset<Row> df = this.createSparkView(sinkType2, (Option<String>)sinkConfig2, path2);
                    df.createOrReplaceTempView(key);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Created view {}", new Object[]{key});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public static /* synthetic */ Dataset createSparkView$(SparkJob $this, SinkType sinkType, Option sinkConfig, String path) {
        return $this.createSparkView(sinkType, (Option<String>)sinkConfig, path);
    }

    default public Dataset<Row> createSparkView(SinkType sinkType, Option<String> sinkConfig, String path) {
        Dataset<Row> dataset;
        SinkType sinkType2 = sinkType;
        if (((Object)SinkType$FS$.MODULE$).equals(sinkType2)) {
            dataset = this.createFSView(path);
        } else if (((Object)SinkType$JDBC$.MODULE$).equals(sinkType2)) {
            dataset = this.createJDBCView(sinkConfig, path);
        } else if (((Object)SinkType$KAFKA$.MODULE$).equals(sinkType2)) {
            dataset = this.createKafkaView(sinkConfig, path);
        } else if (((Object)SinkType$BQ$.MODULE$).equals(sinkType2)) {
            dataset = this.createBQView(path);
        } else {
            throw new Exception("Should never happen");
        }
        Dataset<Row> df = dataset;
        return df;
    }

    private Dataset<Row> createJDBCView(Option<String> sinkConfig, String path) {
        Settings.Connection jdbcConfig = (Settings.Connection)this.settings().comet().connections().apply(sinkConfig.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("");
        }));
        return this.session().read().options(jdbcConfig.options()).format(jdbcConfig.format()).option(JDBCOptions$.MODULE$.JDBC_QUERY_STRING(), path).load().cache();
    }

    private Dataset<Row> createFSView(String path) {
        if (path.startsWith("/")) {
            return this.session().read().format(this.settings().comet().defaultFormat()).load(path);
        }
        if (path.trim().toLowerCase().startsWith("select ")) {
            return this.session().sql(path);
        }
        return this.session().read().format(this.settings().comet().defaultFormat()).load(new StringBuilder(1).append(this.settings().comet().datasets()).append("/").append(path).toString());
    }

    private Dataset<Row> createBQView(String path) {
        String string;
        Regex TablePathWithFilter = new StringOps(Predef$.MODULE$.augmentString("(.*)\\.comet_filter\\((.*)\\)")).r();
        Regex TablePathWithSelect = new StringOps(Predef$.MODULE$.augmentString("(.*)\\.comet_select\\((.*)\\)")).r();
        Regex TablePathWithFilterAndSelect = new StringOps(Predef$.MODULE$.augmentString("(.*)\\.comet_select\\((.*)\\)\\.comet_filter\\((.*)\\)")).r();
        Option option = TablePathWithFilterAndSelect.unapplySeq((CharSequence)(string = path));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            BoxedUnit boxedUnit;
            String tablePath = (String)((LinearSeqOptimized)option.get()).apply(0);
            String select = (String)((LinearSeqOptimized)option.get()).apply(1);
            String filter = (String)((LinearSeqOptimized)option.get()).apply(2);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("We are loading the Table with columns: {} and filters: {}", new Object[]{select, filter});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", tablePath).option("filter", filter).load().selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])select.replaceAll("\\s", "").split(","))).cache();
        }
        Option option2 = TablePathWithFilter.unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            BoxedUnit boxedUnit;
            String tablePath = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String filter = (String)((LinearSeqOptimized)option2.get()).apply(1);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("We are loading the Table with filters: {}", new Object[]{filter});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", tablePath).option("filter", filter).load().cache();
        }
        Option option3 = TablePathWithSelect.unapplySeq((CharSequence)string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
            BoxedUnit boxedUnit;
            String tablePath = (String)((LinearSeqOptimized)option3.get()).apply(0);
            String select = (String)((LinearSeqOptimized)option3.get()).apply(1);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("We are loading the Table with columns: {}", new Object[]{select});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", tablePath).load().selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])select.replaceAll("\\s", "").split(","))).cache();
        }
        return this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", path).load().cache();
    }

    private Dataset<Row> createKafkaView(Option<String> sinkConfig, String path) {
        Option<String> option = sinkConfig;
        if (option instanceof Some) {
            Some some = (Some)option;
            String x = (String)some.value();
            String string = x.toLowerCase();
            String string2 = "stream";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return (Dataset)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> KafkaClient$.MODULE$.consumeTopicStreaming(this.session(), (Settings.KafkaTopicConfig)this.settings().comet().kafka().topics().apply((Object)path), this.settings()));
            }
        }
        return (Dataset)Utils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> new KafkaClient(this.settings().comet().kafka(), this.settings()), (Function1 & Serializable & scala.Serializable)kafkaClient -> {
            Tuple2<Dataset<Row>, List<Tuple2<Object, Object>>> tuple2 = kafkaClient.consumeTopicBatch(path, this.session(), (Settings.KafkaTopicConfig)this.settings().comet().kafka().topics().apply((Object)path));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Dataset dataframe = (Dataset)tuple2._1();
            Dataset dataframe2 = dataframe;
            return dataframe2;
        });
    }

    public static /* synthetic */ boolean $anonfun$partitionedDatasetWriter$1(Object elem) {
        return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
    }

    public static /* synthetic */ boolean $anonfun$partitionedDatasetWriter$3(Object elem) {
        return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
    }

    public static /* synthetic */ boolean $anonfun$partitionDataset$1(Object elem) {
        return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
    }

    public static /* synthetic */ boolean $anonfun$partitionDataset$2(Object elem) {
        return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
    }

    public static void $init$(SparkJob $this) {
    }
}

