/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.config;

import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.utils.Utils$;
import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DatasetArea$
implements StrictLogging {
    public static DatasetArea$ MODULE$;
    private final Logger logger;

    static {
        new DatasetArea$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Path path(String domain, String area, Settings settings) {
        if (area.contains("://")) {
            return new Path(area);
        }
        if (settings.comet().datasets().contains("://")) {
            return new Path(new StringBuilder(2).append(settings.comet().datasets()).append("/").append(area).append("/").append(domain).toString());
        }
        return new Path(new StringBuilder(3).append(settings.comet().fileSystem()).append("/").append(settings.comet().datasets()).append("/").append(area).append("/").append(domain).toString());
    }

    public Path path(String domain, Settings settings) {
        if (settings.comet().datasets().contains("://")) {
            return new Path(new StringBuilder(1).append(settings.comet().datasets()).append("/").append(domain).toString());
        }
        return new Path(new StringBuilder(2).append(settings.comet().fileSystem()).append("/").append(settings.comet().datasets()).append("/").append(domain).toString());
    }

    public Path path(Path domainPath, String schema) {
        return new Path(domainPath, schema);
    }

    public Path pending(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().pending(), settings);
    }

    public Path unresolved(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().unresolved(), settings);
    }

    public Path archive(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().archive(), settings);
    }

    public Path ingesting(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().ingesting(), settings);
    }

    public Path accepted(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().accepted(), settings);
    }

    public Path rejected(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().rejected(), settings);
    }

    public Path metrics(String domain, String schema, Settings settings) {
        return this.substituteDomainAndSchemaInPath(domain, schema, settings.comet().metrics().path());
    }

    public Path assertions(String domain, String schema, Settings settings) {
        return this.substituteDomainAndSchemaInPath(domain, schema, settings.comet().assertions().path());
    }

    public Path replay(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().replay(), settings);
    }

    public Path substituteDomainAndSchemaInPath(String domain, String schema, String path) {
        return new Path(this.substituteDomainAndSchema(domain, schema, path));
    }

    public String substituteDomainAndSchema(String domain, String schema, String template) {
        String normalizedDomainName = Utils$.MODULE$.keepAlphaNum(domain);
        return template.replace("{{domain}}", domain).replace("{{normalized_domain}}", normalizedDomainName).replace("{{schema}}", schema);
    }

    public Path discreteMetrics(String domain, String schema, Settings settings) {
        return new Path(this.metrics(domain, schema, settings), "discrete");
    }

    public Path continuousMetrics(String domain, String schema, Settings settings) {
        return new Path(this.metrics(domain, schema, settings), "continuous");
    }

    public Path frequenciesMetrics(String domain, String schema, Settings settings) {
        return new Path(this.metrics(domain, schema, settings), "frequencies");
    }

    public Path business(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().business(), settings);
    }

    public Path metadata(Settings settings) {
        return new Path(String.valueOf(settings.comet().metadata()));
    }

    public Path types(Settings settings) {
        return new Path(this.metadata(settings), "types");
    }

    public Path dags(Settings settings) {
        return new Path(settings.comet().dags());
    }

    public Path assertions(Settings settings) {
        return new Path(this.metadata(settings), "assertions");
    }

    public Path mapping(Settings settings) {
        return new Path(this.metadata(settings), "mapping");
    }

    public Path domains(Settings settings) {
        return new Path(this.metadata(settings), "domains");
    }

    public Path external(Settings settings) {
        return new Path(this.metadata(settings), "external");
    }

    public Path extract(Settings settings) {
        return new Path(this.metadata(settings), "extract");
    }

    public Path jobs(Settings settings) {
        return new Path(this.metadata(settings), "jobs");
    }

    public Path views(Settings settings) {
        return new Path(this.metadata(settings), "views");
    }

    public Path views(String viewsPath, Settings settings) {
        if (viewsPath.startsWith("/")) {
            return new Path(this.views(settings), (String)new StringOps(Predef$.MODULE$.augmentString(viewsPath)).drop(1));
        }
        return new Path(this.views(settings), viewsPath);
    }

    public Path iamPolicyTags(Settings settings) {
        return new Path(this.metadata(settings), "iam-policy-tags.comet.yml");
    }

    public void initMetadata(StorageHandler storage, Settings settings) {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{this.metadata(settings), this.types(settings), this.domains(settings), this.external(settings), this.extract(settings), this.jobs(settings), this.assertions(settings), this.views(settings), this.mapping(settings)})).foreach((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)storage.mkdirs(path)));
    }

    public void initDomains(StorageHandler storage, Iterable<String> domains, Settings settings) {
        domains.foreach((Function1 & Serializable & scala.Serializable)domain -> {
            DatasetArea$.$anonfun$initDomains$1(settings, storage, domain);
            return BoxedUnit.UNIT;
        });
    }

    public void bootstrap(Option<String> template, Settings settings) {
        this.initMetadata(settings.storageHandler(), settings);
        new .colon.colon((Object)"out", (List)new .colon.colon((Object)"diagrams", (List)new .colon.colon((Object)"diagrams/domains", (List)new .colon.colon((Object)"diagrams/acl", (List)new .colon.colon((Object)"diagrams/jobs", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)folder -> {
            File root = File$.MODULE$.apply(settings.comet().metadata(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).parent();
            File qual$1 = File$.MODULE$.apply(root.pathAsString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringOps(Predef$.MODULE$.augmentString(folder)).split('/')));
            Seq x$1 = qual$1.createDirectories$default$1();
            Seq x$2 = qual$1.createDirectories$default$2();
            return qual$1.createDirectories(x$1, x$2);
        });
        File metadataFile = File$.MODULE$.apply(this.metadata(settings).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        metadataFile.createDirectories(metadataFile.createDirectories$default$1(), metadataFile.createDirectories$default$2());
        File incomingFolder = File$.MODULE$.apply(metadataFile.parent(), "incoming", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        incomingFolder.createDirectories(incomingFolder.createDirectories$default$1(), incomingFolder.createDirectories$default$2());
        File vscodeFolder = File$.MODULE$.apply(metadataFile.parent(), ".vscode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        vscodeFolder.createDirectories(vscodeFolder.createDirectories$default$1(), vscodeFolder.createDirectories$default$2());
        DatasetArea$.copyToFolder$1((List)new .colon.colon((Object)"extensions.json", (List)Nil$.MODULE$), "templates", vscodeFolder, settings);
        String string = (String)template.getOrElse((Function0 & Serializable & scala.Serializable)() -> "quickstart");
        if ("userguide".equals(string)) {
            List metadataResources = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"domains/hr.comet.yml", "domains/sales.comet.yml", "jobs/kpi.comet.yml", "jobs/kpi.byseller.sql.j2", "types/default.comet.yml", "types/types.comet.yml", "env.comet.yml", "env.BQ.comet.yml", "env.FS.comet.yml"}));
            DatasetArea$.copyToFolder$1(metadataResources, "templates/userguide/metadata", metadataFile, settings);
            List rootResources = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"incoming/hr/locations-2018-01-01.ack", "incoming/hr/locations-2018-01-01.json", "incoming/hr/sellers-2018-01-01.ack", "incoming/hr/sellers-2018-01-01.json", "incoming/sales/customers-2018-01-01.ack", "incoming/sales/customers-2018-01-01.psv", "incoming/sales/orders-2018-01-01.ack", "incoming/sales/orders-2018-01-01.csv"}));
            DatasetArea$.copyToFolder$1(rootResources, "templates/userguide", metadataFile.parent(), settings);
            return;
        }
        if ("quickstart".equals(string)) {
            .colon.colon metadataResources = new .colon.colon((Object)"types/default.comet.yml", (List)new .colon.colon((Object)"types/types.comet.yml", (List)new .colon.colon((Object)"env.comet.yml", (List)new .colon.colon((Object)"env.BQ.comet.yml", (List)new .colon.colon((Object)"env.FS.comet.yml", (List)Nil$.MODULE$)))));
            DatasetArea$.copyToFolder$1((List)metadataResources, "templates/quickstart/metadata", metadataFile, settings);
            .colon.colon rootResources = new .colon.colon((Object)"incoming/sales/customers-2018-01-01.ack", (List)new .colon.colon((Object)"incoming/sales/customers-2018-01-01.psv", (List)Nil$.MODULE$));
            DatasetArea$.copyToFolder$1((List)rootResources, "templates/quickstart", metadataFile.parent(), settings);
            .colon.colon dagResources = new .colon.colon((Object)"dags/default.comet.yml", (List)Nil$.MODULE$);
            DatasetArea$.copyToFolder$1((List)dagResources, "templates/quickstart", metadataFile.parent(), settings);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$initDomains$1(Settings settings$1, StorageHandler storage$2, String domain2) {
        ((List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.pending((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.unresolved((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.archive((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.accepted((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.rejected((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.business((String)domain, settings$1), (List)new .colon.colon((Function1 & Serializable & scala.Serializable)domain -> MODULE$.replay((String)domain, settings$1), (List)Nil$.MODULE$))))))).map((Function1 & Serializable & scala.Serializable)x$1 -> (Path)x$1.apply((Object)domain2), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)storage$2.mkdirs(path)));
    }

    private static final void copyToFolder$1(List resources, String resourceFolder, File targetFolder, Settings settings$2) {
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            String contents;
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("copying {}", new Object[]{resource});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BufferedSource source = Source$.MODULE$.fromResource(new StringBuilder(1).append(resourceFolder).append("/").append((String)resource).toString(), Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec());
            if (source == null) {
                throw new Exception(new StringBuilder(31).append("Resource ").append((String)resource).append(" not found in assembly").toString());
            }
            Iterator lines = source.getLines();
            File targetFile = File$.MODULE$.apply(targetFolder.pathAsString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringOps(Predef$.MODULE$.augmentString(resource)).split('/')));
            File qual$1 = targetFile.parent();
            Seq x$1 = qual$1.createDirectories$default$1();
            Seq x$2 = qual$1.createDirectories$default$2();
            qual$1.createDirectories(x$1, x$2);
            String x$3 = contents = lines.mkString("\n").replace("__SL_TEST_ROOT__", MODULE$.metadata(settings$2).getParent().toString());
            Seq x$4 = targetFile.overwrite$default$2(x$3);
            Charset x$5 = targetFile.overwrite$default$3(x$3);
            return targetFile.overwrite(x$3, x$4, x$5);
        });
    }

    private DatasetArea$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

