/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.Settings;
import ai.starlake.config.Settings$;
import ai.starlake.config.SparkEnv;
import ai.starlake.config.SparkEnv$;
import ai.starlake.extract.BigQueryFreshnessConfig;
import ai.starlake.extract.BigQueryFreshnessConfig$;
import ai.starlake.extract.BigQueryFreshnessInfo$;
import ai.starlake.extract.BigQueryTableInfo$;
import ai.starlake.extract.FreshnessStatus;
import ai.starlake.job.sink.bigquery.BigQuerySparkWriter$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.SchemaHandler$;
import ai.starlake.schema.model.AutoJobDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.schema.model.WriteMode$OVERWRITE$;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.Table;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.UUID;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BigQueryFreshnessInfo$ {
    public static BigQueryFreshnessInfo$ MODULE$;

    static {
        new BigQueryFreshnessInfo$();
    }

    public List<FreshnessStatus> freshness(BigQueryFreshnessConfig config, Settings settings) {
        Object object;
        List<Tuple2<Dataset, List<Table>>> tables = BigQueryTableInfo$.MODULE$.extractTableInfos(config.gcpProjectId(), config.tables(), settings);
        SchemaHandler schemaHandler = new SchemaHandler(settings.storageHandler(), SchemaHandler$.MODULE$.$lessinit$greater$default$2(), settings);
        List<Domain> domains = schemaHandler.domains(schemaHandler.domains$default$1(), schemaHandler.domains$default$2());
        List tablesFreshnessStatuses = (List)tables.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Dataset dsInfo = (Dataset)tuple2._1();
                List tableInfos = (List)tuple2._2();
                Option domain = domains.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BigQueryFreshnessInfo$.$anonfun$freshness$2(dsInfo, x$1)));
                Option option = domain;
                if (None$.MODULE$.equals(option)) {
                    return Nil$.MODULE$;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Domain domain2 = (Domain)some.value();
                    return (List)tableInfos.flatMap((Function1 & Serializable & scala.Serializable)tableInfo -> {
                        String tableName = tableInfo.getTableId().getTable();
                        Option table = domain2.tables().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BigQueryFreshnessInfo$.$anonfun$freshness$4(tableName, x$2)));
                        Option option = table;
                        if (None$.MODULE$.equals(option)) {
                            return Nil$.MODULE$;
                        }
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Schema table2 = (Schema)some.value();
                            Option freshness = table2.metadata().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.freshness()).orElse((Function0 & Serializable & scala.Serializable)() -> domain2.metadata().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.freshness()));
                            Option option2 = freshness;
                            if (None$.MODULE$.equals(option2)) {
                                return Nil$.MODULE$;
                            }
                            if (option2 instanceof Some) {
                                Some some2 = (Some)option2;
                                Freshness freshness2 = (Freshness)some2.value();
                                Option<FreshnessStatus> warnStatus = MODULE$.getFreshnessStatus(domain2.finalName(), (Table)tableInfo, table2.finalName(), freshness2.warn(), "WARN", "TABLE");
                                Option<FreshnessStatus> errorStatus = MODULE$.getFreshnessStatus(domain2.finalName(), (Table)tableInfo, table2.finalName(), freshness2.error(), "ERROR", "TABLE");
                                return (List)new .colon.colon(warnStatus, (List)new .colon.colon(errorStatus, (List)Nil$.MODULE$)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
                            }
                            throw new MatchError((Object)option2);
                        }
                        throw new MatchError((Object)option);
                    }, List$.MODULE$.canBuildFrom());
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        Map<String, AutoJobDesc> jobs = schemaHandler.jobs(schemaHandler.jobs$default$1());
        List jobsFreshnessStatuses = (List)tables.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Dataset dsInfo = (Dataset)tuple2._1();
                List tableInfos = (List)tuple2._2();
                Iterable tasks = (Iterable)jobs.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> ((AutoJobDesc)x$5._2()).tasks(), Iterable$.MODULE$.canBuildFrom());
                Option task = tasks.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)BigQueryFreshnessInfo$.$anonfun$freshness$11(dsInfo, x$6)));
                Option option = task;
                if (None$.MODULE$.equals(option)) {
                    return Nil$.MODULE$;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AutoTaskDesc task2 = (AutoTaskDesc)some.value();
                    Option tableInfo = tableInfos.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)BigQueryFreshnessInfo$.$anonfun$freshness$12(task2, x$7)));
                    Option option2 = tableInfo;
                    if (None$.MODULE$.equals(option2)) {
                        return Nil$.MODULE$;
                    }
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Table tableInfo2 = (Table)some2.value();
                        Option<Freshness> freshness = task2.freshness();
                        Option<Freshness> option3 = freshness;
                        if (None$.MODULE$.equals(option3)) {
                            return Nil$.MODULE$;
                        }
                        if (option3 instanceof Some) {
                            Some some3 = (Some)option3;
                            Freshness freshness2 = (Freshness)some3.value();
                            Option<FreshnessStatus> warnStatus = MODULE$.getFreshnessStatus(task2.domain(), tableInfo2, task2.name(), freshness2.warn(), "WARN", "JOB");
                            Option<FreshnessStatus> errorStatus = MODULE$.getFreshnessStatus(task2.domain(), tableInfo2, task2.name(), freshness2.error(), "ERROR", "JOB");
                            return (List)new .colon.colon(warnStatus, (List)new .colon.colon(errorStatus, (List)Nil$.MODULE$)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
                        }
                        throw new MatchError(option3);
                    }
                    throw new MatchError((Object)option2);
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        List statuses = (List)tablesFreshnessStatuses.$plus$plus((GenTraversableOnce)jobsFreshnessStatuses, List$.MODULE$.canBuildFrom());
        if (config.persist()) {
            SparkSession session = new SparkEnv(new StringBuilder(22).append("BigQueryFreshnessInfo-").append(UUID.randomUUID().toString()).toString(), SparkEnv$.MODULE$.$lessinit$greater$default$2(), settings).session();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Ai_starlake_extract_BigQueryFreshnessInfo$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.starlake.extract.FreshnessStatus").asType().toTypeConstructor();
                }

                public Ai_starlake_extract_BigQueryFreshnessInfo$$typecreator1$1() {
                }
            }
            org.apache.spark.sql.Dataset dfDataset = session.createDataFrame((Seq)statuses, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_starlake_extract_BigQueryFreshnessInfo$$typecreator1$1()));
            object = BigQuerySparkWriter$.MODULE$.sink(config.authInfo(), (org.apache.spark.sql.Dataset<Row>)dfDataset, "freshness_info", (Option<String>)new Some((Object)"Information related to table freshness"), (WriteMode)config.writeMode().getOrElse((Function0 & Serializable & scala.Serializable)() -> WriteMode$OVERWRITE$.MODULE$), settings);
        } else {
            object = BoxedUnit.UNIT;
        }
        return statuses;
    }

    private Option<FreshnessStatus> getFreshnessStatus(String domainName, Table tableInfo, String tableName, Option<String> duration, String level, String typ) {
        Option<String> option = duration;
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Long lastModifiedTime;
            Some some = (Some)option;
            String duration2 = (String)some.value();
            long warnOrErrorDuration = Duration$.MODULE$.apply(duration2).toMillis();
            long now = System.currentTimeMillis();
            if (now - warnOrErrorDuration > Predef$.MODULE$.Long2long(lastModifiedTime = tableInfo.getLastModifiedTime())) {
                return new Some((Object)new FreshnessStatus(domainName, tableName, new Timestamp(Predef$.MODULE$.Long2long(lastModifiedTime)), new Timestamp(now), warnOrErrorDuration, level));
            }
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public List<FreshnessStatus> run(String[] args) {
        Settings settings = Settings$.MODULE$.apply(ConfigFactory.load());
        BigQueryFreshnessConfig config = (BigQueryFreshnessConfig)BigQueryFreshnessConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("Could not parse arguments");
        });
        return this.freshness(config, settings);
    }

    public static final /* synthetic */ boolean $anonfun$freshness$2(Dataset dsInfo$1, Domain x$1) {
        return x$1.finalName().equalsIgnoreCase(dsInfo$1.getDatasetId().getDataset());
    }

    public static final /* synthetic */ boolean $anonfun$freshness$4(String tableName$1, Schema x$2) {
        return x$2.finalName().equalsIgnoreCase(tableName$1);
    }

    public static final /* synthetic */ boolean $anonfun$freshness$11(Dataset dsInfo$2, AutoTaskDesc x$6) {
        return x$6.domain().equalsIgnoreCase(dsInfo$2.getDatasetId().getDataset());
    }

    public static final /* synthetic */ boolean $anonfun$freshness$12(AutoTaskDesc task$1, Table x$7) {
        return x$7.getTableId().getTable().equalsIgnoreCase(task$1.name());
    }

    private BigQueryFreshnessInfo$() {
        MODULE$ = this;
    }
}

