/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.Settings;
import ai.starlake.config.Settings$;
import ai.starlake.config.SparkEnv;
import ai.starlake.config.SparkEnv$;
import ai.starlake.extract.BigQueryDatasetInfo$;
import ai.starlake.extract.BigQueryInfo$;
import ai.starlake.extract.BigQueryTableInfo;
import ai.starlake.extract.BigQueryTableInfo$;
import ai.starlake.job.sink.bigquery.BigQuerySparkWriter$;
import ai.starlake.schema.generator.BigQueryTablesConfig;
import ai.starlake.schema.generator.BigQueryTablesConfig$;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.schema.model.WriteMode$OVERWRITE$;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableInfo;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class BigQueryTableInfo$
implements scala.Serializable {
    public static BigQueryTableInfo$ MODULE$;

    static {
        new BigQueryTableInfo$();
    }

    public BigQueryTableInfo apply(TableInfo info, Timestamp logTime) {
        return new BigQueryTableInfo(info.getTableId().getProject(), info.getTableId().getDataset(), info.getTableId().getTable(), new Timestamp(Predef$.MODULE$.Long2long(info.getCreationTime())), new Timestamp(Predef$.MODULE$.Long2long(info.getExpirationTime())), new Timestamp(Predef$.MODULE$.Long2long(info.getLastModifiedTime())), info.getDescription(), Predef$.MODULE$.Long2long(info.getNumBytes()), Predef$.MODULE$.Long2long(info.getNumLongTermBytes()), info.getNumRows().longValue(), Predef$.MODULE$.Boolean2boolean(info.getRequirePartitionFilter()), logTime);
    }

    public void sink(BigQueryTablesConfig config, Settings settings) {
        Timestamp logTime = Timestamp.from(Instant.now());
        List<Tuple2<Dataset, List<Table>>> selectedInfos = this.extractTableInfos(config.gcpProjectId(), config.tables(), settings);
        List datasetInfos = (List)((List)selectedInfos.map((Function1 & Serializable & scala.Serializable)x$1 -> (Dataset)x$1._1(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> BigQueryDatasetInfo$.MODULE$.apply((DatasetInfo)x$2, logTime), List$.MODULE$.canBuildFrom());
        SparkSession session = new SparkEnv(new StringBuilder(19).append("BigQueryTablesInfo-").append(UUID.randomUUID().toString()).toString(), SparkEnv$.MODULE$.$lessinit$greater$default$2(), settings).session();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_starlake_extract_BigQueryTableInfo$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.starlake.extract.BigQueryDatasetInfo").asType().toTypeConstructor();
            }

            public Ai_starlake_extract_BigQueryTableInfo$$typecreator1$1() {
            }
        }
        org.apache.spark.sql.Dataset dfDataset = session.createDataFrame((Seq)datasetInfos, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_starlake_extract_BigQueryTableInfo$$typecreator1$1()));
        BigQuerySparkWriter$.MODULE$.sink(config.authInfo(), (org.apache.spark.sql.Dataset<Row>)dfDataset, "dataset_info", (Option<String>)new Some((Object)"Information related to datasets"), (WriteMode)config.writeMode().getOrElse((Function0 & Serializable & scala.Serializable)() -> WriteMode$OVERWRITE$.MODULE$), settings);
        List tableInfos = (List)((List)selectedInfos.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3._2(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.apply((TableInfo)x$4, logTime), List$.MODULE$.canBuildFrom());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ai_starlake_extract_BigQueryTableInfo$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ai.starlake.extract.BigQueryTableInfo").asType().toTypeConstructor();
            }

            public Ai_starlake_extract_BigQueryTableInfo$$typecreator2$1() {
            }
        }
        org.apache.spark.sql.Dataset dfTable = session.createDataFrame((Seq)tableInfos, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ai_starlake_extract_BigQueryTableInfo$$typecreator2$1()));
        BigQuerySparkWriter$.MODULE$.sink(config.authInfo(), (org.apache.spark.sql.Dataset<Row>)dfTable, "table_info", (Option<String>)new Some((Object)"Information related to tables"), (WriteMode)config.writeMode().getOrElse((Function0 & Serializable & scala.Serializable)() -> WriteMode$OVERWRITE$.MODULE$), settings);
    }

    public List<Tuple2<Dataset, List<Table>>> extractTableInfos(Option<String> gcpProjectId, Map<String, List<String>> tables, Settings settings) {
        List infos = BigQueryInfo$.MODULE$.extractInfo(gcpProjectId, settings);
        List selectedInfos = tables.isEmpty() ? infos : (List)infos.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Dataset dsInfo = (Dataset)tuple2._1();
                List tableInfos = (List)tuple2._2();
                Option key = tables.keys().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.equalsIgnoreCase(dsInfo.getDatasetId().getDataset())));
                Option option = key;
                if (None$.MODULE$.equals(option)) {
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String key2 = (String)some.value();
                    List configTables = (List)tables.apply((Object)key2);
                    List selectedTables = (List)tableInfos.filter((Function1 & Serializable & scala.Serializable)tableInfo -> BoxesRunTime.boxToBoolean((boolean)configTables.contains((Object)tableInfo.getTableId().getTable())));
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)dsInfo, (Object)selectedTables)));
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        return selectedInfos;
    }

    public void run(String[] args) {
        Settings settings = Settings$.MODULE$.apply(ConfigFactory.load());
        BigQueryTablesConfig config = (BigQueryTablesConfig)BigQueryTablesConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("Could not parse arguments");
        });
        this.sink(config, settings);
    }

    public BigQueryTableInfo apply(String project, String dataset, String table, Timestamp creationTime, Timestamp expirationTime, Timestamp lastModifiedTime, String description, long numBytes, long numLongTermBytes, long numRows, boolean requirePartitionFilter, Timestamp timestamp) {
        return new BigQueryTableInfo(project, dataset, table, creationTime, expirationTime, lastModifiedTime, description, numBytes, numLongTermBytes, numRows, requirePartitionFilter, timestamp);
    }

    public Option<Tuple12<String, String, String, Timestamp, Timestamp, Timestamp, String, Object, Object, Object, Object, Timestamp>> unapply(BigQueryTableInfo x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple12((Object)x$0.project(), (Object)x$0.dataset(), (Object)x$0.table(), (Object)x$0.creationTime(), (Object)x$0.expirationTime(), (Object)x$0.lastModifiedTime(), (Object)x$0.description(), (Object)BoxesRunTime.boxToLong((long)x$0.numBytes()), (Object)BoxesRunTime.boxToLong((long)x$0.numLongTermBytes()), (Object)BoxesRunTime.boxToLong((long)x$0.numRows()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.requirePartitionFilter()), (Object)x$0.timestamp()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BigQueryTableInfo$() {
        MODULE$ = this;
    }
}

