/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.Settings;
import ai.starlake.config.Settings$;
import ai.starlake.extract.Extract;
import ai.starlake.extract.ExtractSchemaConfig;
import ai.starlake.extract.ExtractSchemaConfig$;
import ai.starlake.extract.JDBCSchema;
import ai.starlake.extract.JDBCSchemas;
import ai.starlake.extract.JDBCUtils$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.SchemaHandler$;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.DagGenerationConfig;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.MergeOptions;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.Metadata$;
import ai.starlake.schema.model.Mode;
import ai.starlake.schema.model.Partition;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.SchemaRefs;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.YamlSerializer$;
import better.files.File;
import better.files.File$;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ExtractSchema$
extends Extract
implements LazyLogging {
    public static ExtractSchema$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ExtractSchema$();
    }

    private Logger logger$lzycompute() {
        ExtractSchema$ extractSchema$ = this;
        synchronized (extractSchema$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void run(String[] args) {
        Settings settings = Settings$.MODULE$.apply(ConfigFactory.load());
        Option<ExtractSchemaConfig> option = ExtractSchemaConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (option instanceof Some) {
            Some some = (Some)option;
            ExtractSchemaConfig config = (ExtractSchemaConfig)some.value();
            this.run(config, settings);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new Exception(new StringBuilder(26).append("Could not parse arguments ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).toString());
        }
        throw new MatchError(option);
    }

    public void run(ExtractSchemaConfig config, Settings settings) {
        SchemaHandler schemaHandler = new SchemaHandler(settings.storageHandler(), SchemaHandler$.MODULE$.$lessinit$greater$default$2(), settings);
        String content = Formatter$.MODULE$.RichFormatter(settings.storageHandler().read(this.mappingPath(config.mapping(), settings), settings.storageHandler().read$default$2())).richFormat(schemaHandler.activeEnv(schemaHandler.activeEnv$default$1()), (Map<String, String>)Predef$.MODULE$.Map().empty(), settings);
        JDBCSchemas jdbcSchemas = YamlSerializer$.MODULE$.deserializeJDBCSchemas(content, config.mapping());
        Map connectionOptions = (Map)jdbcSchemas.connectionRef().map((Function1 & Serializable & scala.Serializable)x$1 -> ((Settings.Connection)settings.comet().connections().apply(x$1)).options()).getOrElse((Function0 & Serializable & scala.Serializable)() -> jdbcSchemas.connection());
        jdbcSchemas.jdbcSchemas().foreach((Function1 & Serializable & scala.Serializable)jdbcSchema -> {
            ExtractSchema$.$anonfun$run$3(settings, schemaHandler, connectionOptions, config, jdbcSchema);
            return BoxedUnit.UNIT;
        });
    }

    public void extractSchema(JDBCSchema jdbcSchema, Map<String, String> connectionOptions, File baseOutputDir, Option<Domain> domainTemplate, Option<Domain> currentDomain, Settings settings) {
        String domainName = jdbcSchema.schema().replaceAll("[^\\p{Alnum}]", "_");
        baseOutputDir.createDirectories(baseOutputDir.createDirectories$default$1(), baseOutputDir.createDirectories$default$2());
        File qual$1 = File$.MODULE$.apply(baseOutputDir, domainName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Seq x$1 = qual$1.createDirectories$default$1();
        Seq x$22 = qual$1.createDirectories$default$2();
        qual$1.createDirectories(x$1, x$22);
        Domain extractedDomain = this.extractDomain(jdbcSchema, connectionOptions, domainTemplate, settings);
        Metadata qual$2 = Metadata$.MODULE$.mergeAll((List<Metadata>)((List)((List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(currentDomain.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.metadata())), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(extractedDomain.metadata()), List$.MODULE$.canBuildFrom())));
        boolean x$32 = false;
        Option<Mode> x$4 = qual$2.copy$default$1();
        Option<Format> x$5 = qual$2.copy$default$2();
        Option<String> x$6 = qual$2.copy$default$3();
        Option<Object> x$7 = qual$2.copy$default$4();
        Option<Object> x$8 = qual$2.copy$default$5();
        Option<Object> x$9 = qual$2.copy$default$6();
        Option<String> x$10 = qual$2.copy$default$7();
        Option<String> x$11 = qual$2.copy$default$8();
        Option<String> x$12 = qual$2.copy$default$9();
        Option<WriteMode> x$13 = qual$2.copy$default$10();
        Option<Partition> x$14 = qual$2.copy$default$11();
        Option<Sink> x$15 = qual$2.copy$default$12();
        Option<String> x$16 = qual$2.copy$default$13();
        Option<Seq<String>> x$17 = qual$2.copy$default$14();
        Option<Map<String, String>> x$18 = qual$2.copy$default$15();
        Option<String> x$19 = qual$2.copy$default$16();
        List<String> x$20 = qual$2.copy$default$17();
        Option<String> x$21 = qual$2.copy$default$18();
        Option<Map<String, String>> x$222 = qual$2.copy$default$19();
        Option<String> x$23 = qual$2.copy$default$20();
        Option<Object> x$24 = qual$2.copy$default$21();
        Option<DagGenerationConfig> x$25 = qual$2.copy$default$22();
        Option<Freshness> x$26 = qual$2.copy$default$23();
        Option<String> x$27 = qual$2.copy$default$24();
        Option<Metadata> x$28 = qual$2.copy(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$222, x$23, x$24, x$25, x$26, x$27, x$32).asOption();
        String x$29 = extractedDomain.copy$default$1();
        Option<String> x$30 = extractedDomain.copy$default$2();
        List<String> x$31 = extractedDomain.copy$default$4();
        List<Schema> x$322 = extractedDomain.copy$default$5();
        Option<String> x$33 = extractedDomain.copy$default$6();
        List<String> x$34 = extractedDomain.copy$default$7();
        Option<String> x$35 = extractedDomain.copy$default$8();
        Set<String> x$36 = extractedDomain.copy$default$9();
        Option<String> x$37 = extractedDomain.copy$default$10();
        Option<String> x$38 = extractedDomain.copy$default$11();
        Domain domain = extractedDomain.copy(x$29, x$30, x$28, x$31, x$322, x$33, x$34, x$35, x$36, x$37, x$38);
        List<Schema> tables = domain.tables();
        List tableRefs = (List)tables.map((Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(1).append("_").append(x$3.name()).toString(), List$.MODULE$.canBuildFrom());
        tables.foreach((Function1 & Serializable & scala.Serializable)table -> {
            Schema schema;
            Schema schema2;
            Option option = currentDomain.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.tables().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ExtractSchema$.$anonfun$extractSchema$5(table, x$5))));
            if (option instanceof Some) {
                Some some = (Some)option;
                Schema currentTable = (Schema)some.value();
                Schema mergedTable = table.mergeWith(currentTable, domain.metadata());
                Option x$64 = mergedTable.metadata().map((Function1 & Serializable & scala.Serializable)x$6 -> {
                    boolean x$39 = false;
                    Option<Mode> x$40 = x$6.copy$default$1();
                    Option<Format> x$41 = x$6.copy$default$2();
                    Option<String> x$42 = x$6.copy$default$3();
                    Option<Object> x$43 = x$6.copy$default$4();
                    Option<Object> x$44 = x$6.copy$default$5();
                    Option<Object> x$45 = x$6.copy$default$6();
                    Option<String> x$46 = x$6.copy$default$7();
                    Option<String> x$47 = x$6.copy$default$8();
                    Option<String> x$48 = x$6.copy$default$9();
                    Option<WriteMode> x$49 = x$6.copy$default$10();
                    Option<Partition> x$50 = x$6.copy$default$11();
                    Option<Sink> x$51 = x$6.copy$default$12();
                    Option<String> x$52 = x$6.copy$default$13();
                    Option<Seq<String>> x$53 = x$6.copy$default$14();
                    Option<Map<String, String>> x$54 = x$6.copy$default$15();
                    Option<String> x$55 = x$6.copy$default$16();
                    List<String> x$56 = x$6.copy$default$17();
                    Option<String> x$57 = x$6.copy$default$18();
                    Option<Map<String, String>> x$58 = x$6.copy$default$19();
                    Option<String> x$59 = x$6.copy$default$20();
                    Option<Object> x$60 = x$6.copy$default$21();
                    Option<DagGenerationConfig> x$61 = x$6.copy$default$22();
                    Option<Freshness> x$62 = x$6.copy$default$23();
                    Option<String> x$63 = x$6.copy$default$24();
                    return x$6.copy(x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$39);
                });
                String x$65 = mergedTable.copy$default$1();
                Pattern x$66 = mergedTable.copy$default$2();
                List<Attribute> x$67 = mergedTable.copy$default$3();
                Option<MergeOptions> x$68 = mergedTable.copy$default$5();
                Option<String> x$69 = mergedTable.copy$default$6();
                List<String> x$70 = mergedTable.copy$default$7();
                List<String> x$71 = mergedTable.copy$default$8();
                Set<String> x$72 = mergedTable.copy$default$9();
                List<RowLevelSecurity> x$73 = mergedTable.copy$default$10();
                Map<String, String> x$74 = mergedTable.copy$default$11();
                List<String> x$75 = mergedTable.copy$default$12();
                List<AccessControlEntry> x$76 = mergedTable.copy$default$13();
                Option<String> x$77 = mergedTable.copy$default$14();
                Option<String> x$78 = mergedTable.copy$default$15();
                Option<String> x$79 = mergedTable.copy$default$16();
                schema2 = mergedTable.copy(x$65, x$66, x$67, (Option<Metadata>)x$64, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79);
            } else if (None$.MODULE$.equals(option)) {
                Metadata qual$3 = Metadata$.MODULE$.mergeAll((List<Metadata>)((List)((List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(domain.metadata()), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(table.metadata()), List$.MODULE$.canBuildFrom()))).keepIfDifferent((Metadata)domain.metadata().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Metadata(Metadata$.MODULE$.apply$default$1(), Metadata$.MODULE$.apply$default$2(), Metadata$.MODULE$.apply$default$3(), Metadata$.MODULE$.apply$default$4(), Metadata$.MODULE$.apply$default$5(), Metadata$.MODULE$.apply$default$6(), Metadata$.MODULE$.apply$default$7(), Metadata$.MODULE$.apply$default$8(), Metadata$.MODULE$.apply$default$9(), Metadata$.MODULE$.apply$default$10(), Metadata$.MODULE$.apply$default$11(), Metadata$.MODULE$.apply$default$12(), Metadata$.MODULE$.apply$default$13(), Metadata$.MODULE$.apply$default$14(), Metadata$.MODULE$.apply$default$15(), Metadata$.MODULE$.apply$default$16(), Metadata$.MODULE$.apply$default$17(), Metadata$.MODULE$.apply$default$18(), Metadata$.MODULE$.apply$default$19(), Metadata$.MODULE$.apply$default$20(), Metadata$.MODULE$.apply$default$21(), Metadata$.MODULE$.apply$default$22(), Metadata$.MODULE$.apply$default$23(), Metadata$.MODULE$.apply$default$24(), Metadata$.MODULE$.apply$default$25())));
                boolean x$80 = false;
                Option<Mode> x$81 = qual$3.copy$default$1();
                Option<Format> x$82 = qual$3.copy$default$2();
                Option<String> x$83 = qual$3.copy$default$3();
                Option<Object> x$84 = qual$3.copy$default$4();
                Option<Object> x$85 = qual$3.copy$default$5();
                Option<Object> x$86 = qual$3.copy$default$6();
                Option<String> x$87 = qual$3.copy$default$7();
                Option<String> x$88 = qual$3.copy$default$8();
                Option<String> x$89 = qual$3.copy$default$9();
                Option<WriteMode> x$90 = qual$3.copy$default$10();
                Option<Partition> x$91 = qual$3.copy$default$11();
                Option<Sink> x$92 = qual$3.copy$default$12();
                Option<String> x$93 = qual$3.copy$default$13();
                Option<Seq<String>> x$94 = qual$3.copy$default$14();
                Option<Map<String, String>> x$95 = qual$3.copy$default$15();
                Option<String> x$96 = qual$3.copy$default$16();
                List<String> x$97 = qual$3.copy$default$17();
                Option<String> x$98 = qual$3.copy$default$18();
                Option<Map<String, String>> x$99 = qual$3.copy$default$19();
                Option<String> x$100 = qual$3.copy$default$20();
                Option<Object> x$101 = qual$3.copy$default$21();
                Option<DagGenerationConfig> x$102 = qual$3.copy$default$22();
                Option<Freshness> x$103 = qual$3.copy$default$23();
                Option<String> x$104 = qual$3.copy$default$24();
                Option<Metadata> x$105 = qual$3.copy(x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$80).asOption();
                String x$106 = table.copy$default$1();
                Pattern x$107 = table.copy$default$2();
                List<Attribute> x$108 = table.copy$default$3();
                Option<MergeOptions> x$109 = table.copy$default$5();
                Option<String> x$110 = table.copy$default$6();
                List<String> x$111 = table.copy$default$7();
                List<String> x$112 = table.copy$default$8();
                Set<String> x$113 = table.copy$default$9();
                List<RowLevelSecurity> x$114 = table.copy$default$10();
                Map<String, String> x$115 = table.copy$default$11();
                List<String> x$116 = table.copy$default$12();
                List<AccessControlEntry> x$117 = table.copy$default$13();
                Option<String> x$118 = table.copy$default$14();
                Option<String> x$119 = table.copy$default$15();
                Option<String> x$120 = table.copy$default$16();
                schema2 = table.copy(x$106, x$107, x$108, x$105, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120);
            } else {
                throw new MatchError((Object)option);
            }
            Schema restoredTable = schema2;
            Option<String> option2 = jdbcSchema.pattern();
            if (None$.MODULE$.equals(option2)) {
                schema = restoredTable;
            } else if (option2 instanceof Some) {
                Pattern pat;
                Some some = (Some)option2;
                String pattern = (String)some.value();
                String interpolatePattern = MODULE$.formatExtractPattern(jdbcSchema, table.name(), pattern, settings);
                Pattern x$121 = pat = Pattern.compile(interpolatePattern);
                String x$122 = restoredTable.copy$default$1();
                List<Attribute> x$123 = restoredTable.copy$default$3();
                Option<Metadata> x$124 = restoredTable.copy$default$4();
                Option<MergeOptions> x$125 = restoredTable.copy$default$5();
                Option<String> x$126 = restoredTable.copy$default$6();
                List<String> x$127 = restoredTable.copy$default$7();
                List<String> x$128 = restoredTable.copy$default$8();
                Set<String> x$129 = restoredTable.copy$default$9();
                List<RowLevelSecurity> x$130 = restoredTable.copy$default$10();
                Map<String, String> x$131 = restoredTable.copy$default$11();
                List<String> x$132 = restoredTable.copy$default$12();
                List<AccessControlEntry> x$133 = restoredTable.copy$default$13();
                Option<String> x$134 = restoredTable.copy$default$14();
                Option<String> x$135 = restoredTable.copy$default$15();
                Option<String> x$136 = restoredTable.copy$default$16();
                schema = restoredTable.copy(x$122, x$121, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136);
            } else {
                throw new MatchError(option2);
            }
            Schema tableWithPatternAndWrite = schema;
            String content = YamlSerializer$.MODULE$.serialize(new SchemaRefs((List<Schema>)new .colon.colon((Object)tableWithPatternAndWrite, (List)Nil$.MODULE$)));
            File file = File$.MODULE$.apply(baseOutputDir, domainName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append("_").append(table.name()).append(".comet.yml").toString()}));
            String x$137 = content;
            Seq x$138 = file.overwrite$default$2(x$137);
            Charset x$139 = file.overwrite$default$3(x$137);
            return file.overwrite(x$137, x$138, x$139);
        });
        List x$140 = tableRefs;
        Nil$ x$141 = Nil$.MODULE$;
        String x$142 = domain.copy$default$1();
        Option<String> x$143 = domain.copy$default$2();
        Option<Metadata> x$144 = domain.copy$default$3();
        Option<String> x$145 = domain.copy$default$6();
        List<String> x$146 = domain.copy$default$7();
        Option<String> x$147 = domain.copy$default$8();
        Set<String> x$148 = domain.copy$default$9();
        Option<String> x$149 = domain.copy$default$10();
        Option<String> x$150 = domain.copy$default$11();
        Domain finalDomain = domain.copy(x$142, x$143, x$144, (List<String>)x$140, (List<Schema>)x$141, x$145, x$146, x$147, x$148, x$149, x$150);
        YamlSerializer$.MODULE$.serializeToFile(File$.MODULE$.apply(baseOutputDir, domainName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(domainName).append(".comet.yml").toString()})), finalDomain);
    }

    private Domain extractDomain(JDBCSchema jdbcSchema, Map<String, String> connectionOptions, Option<Domain> domainTemplate, Settings settings) {
        Map<String, Tuple3<String, List<Attribute>, List<String>>> selectedTablesAndColumns = JDBCUtils$.MODULE$.extractJDBCTables(jdbcSchema, connectionOptions, false, JDBCUtils$.MODULE$.extractJDBCTables$default$4(), settings);
        return JDBCUtils$.MODULE$.extractDomain(jdbcSchema, domainTemplate, selectedTablesAndColumns);
    }

    private String formatExtractPattern(JDBCSchema jdbcSchema, String table, String pattern, Settings settings) {
        return Formatter$.MODULE$.RichFormatter(pattern).richFormat((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalog"), jdbcSchema.catalog().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)jdbcSchema.schema()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table)}))), (Map<String, String>)Predef$.MODULE$.Map().empty(), settings);
    }

    public static final /* synthetic */ void $anonfun$run$3(Settings settings$1, SchemaHandler schemaHandler$1, Map connectionOptions$1, ExtractSchemaConfig config$1, JDBCSchema jdbcSchema) {
        Option domainTemplate = jdbcSchema.template().map((Function1 & Serializable & scala.Serializable)ymlTemplate -> {
            String content = settings$1.storageHandler().read(MODULE$.mappingPath((String)ymlTemplate, settings$1), settings$1.storageHandler().read$default$2());
            Try<Domain> try_ = YamlSerializer$.MODULE$.deserializeDomain(content, (String)ymlTemplate);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Domain domain = (Domain)success.value();
                if (domain.resolveDirectoryOpt().isEmpty()) {
                    throw new Exception("Domain metadata directory property is mandatory in template file.");
                }
                return domain;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        });
        Option<Domain> currentDomain = schemaHandler$1.getDomain(jdbcSchema.schema(), true);
        MODULE$.extractSchema(jdbcSchema, (Map<String, String>)connectionOptions$1, MODULE$.outputDir(config$1.outputDir(), settings$1), (Option<Domain>)domainTemplate, currentDomain, settings$1);
    }

    public static final /* synthetic */ boolean $anonfun$extractSchema$5(Schema table$1, Schema x$5) {
        String string = x$5.name();
        String string2 = table$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ExtractSchema$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

