/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.extract.DeltaRow;
import ai.starlake.extract.JDBCSchema;
import ai.starlake.extract.JDBCTable;
import ai.starlake.extract.LastExportUtils;
import ai.starlake.extract.LastExportUtils$;
import ai.starlake.extract.SLResultSetHelperService;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.DagGenerationConfig;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Domain$;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.MergeOptions;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.Mode;
import ai.starlake.schema.model.Partition;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.PrimitiveType;
import ai.starlake.schema.model.PrimitiveType$date$;
import ai.starlake.schema.model.PrimitiveType$decimal$;
import ai.starlake.schema.model.PrimitiveType$int$;
import ai.starlake.schema.model.PrimitiveType$long$;
import ai.starlake.schema.model.PrimitiveType$short$;
import ai.starlake.schema.model.PrimitiveType$string$;
import ai.starlake.schema.model.PrimitiveType$timestamp$;
import ai.starlake.schema.model.PrivacyLevel;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Schema$;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.Type;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.Utils$;
import au.com.bytecode.opencsv.CSVWriter;
import au.com.bytecode.opencsv.ResultSetHelper;
import better.files.Disposable$;
import better.files.File;
import better.files.File$;
import better.files.package$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenSeq;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.ParIterable;
import scala.collection.parallel.TaskSupport;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class JDBCUtils$
implements LazyLogging {
    public static JDBCUtils$ MODULE$;
    private final scala.collection.immutable.Map<String, Object> sqlTypes;
    private final scala.collection.immutable.Map<Object, String> reverseSqlTypes;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new JDBCUtils$();
    }

    private Logger logger$lzycompute() {
        JDBCUtils$ jDBCUtils$ = this;
        synchronized (jDBCUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private scala.collection.immutable.Map<String, Object> sqlTypes() {
        return this.sqlTypes;
    }

    private scala.collection.immutable.Map<Object, String> reverseSqlTypes() {
        return this.reverseSqlTypes;
    }

    private <T> T withJDBCConnection(scala.collection.immutable.Map<String, String> connectionOptions, Function1<Connection, T> f, Settings settings) {
        Object object;
        Predef$.MODULE$.assert(connectionOptions.contains((Object)"driver"), (Function0 & Serializable & scala.Serializable)() -> "driver class not found in JDBC connection options");
        Class.forName((String)connectionOptions.apply((Object)"driver"));
        String url = (String)connectionOptions.apply((Object)"url");
        Properties properties = new Properties();
        connectionOptions.$minus((Object)"url").foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return properties.setProperty(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        Connection connection = DriverManager.getConnection(url, properties);
        try {
            object = f.apply((Object)connection);
        }
        catch (Throwable throwable) {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connection.close());
            if (try_ instanceof Success) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Closed connection {}", new Object[]{url});
                }
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new java.lang.StringBuilder(30).append("Could not close connection to ").append(url).toString(), exception);
                }
            } else {
                throw new MatchError((Object)try_);
            }
            throw throwable;
        }
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connection.close());
        if (try_ instanceof Success) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Closed connection {}", new Object[]{url});
            }
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new java.lang.StringBuilder(30).append("Could not close connection to ").append(url).toString(), exception);
            }
        } else {
            throw new MatchError((Object)try_);
        }
        return (T)object;
    }

    public boolean applyScript(String script, scala.collection.immutable.Map<String, String> connectionOptions, Settings settings) {
        return BoxesRunTime.unboxToBoolean(this.withJDBCConnection(connectionOptions, (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$applyScript$1(script, conn)), settings));
    }

    private Option<String> extractTableRemarks(JDBCSchema jdbcSchema, scala.collection.immutable.Map<String, String> connectionOptions, String table, Settings settings) {
        return jdbcSchema.tableRemarks().map((Function1 & Serializable & scala.Serializable)remarks -> {
            BoxedUnit boxedUnit;
            String sql = MODULE$.formatRemarksSQL(jdbcSchema, table, (String)remarks, settings);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Extracting table remarks using {}", new Object[]{sql});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (String)MODULE$.withJDBCConnection(connectionOptions, (Function1 & Serializable & scala.Serializable)connection -> {
                BoxedUnit boxedUnit;
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery(sql);
                if (rs.next()) {
                    return rs.getString(1);
                }
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn("Not table remark found for table {}", new Object[]{table});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return "";
            }, settings);
        });
    }

    private Option<scala.collection.immutable.Map<String, String>> extractColumnRemarks(JDBCSchema jdbcSchema, scala.collection.immutable.Map<String, String> connectionOptions, String table, Settings settings) {
        return jdbcSchema.columnRemarks().map((Function1 & Serializable & scala.Serializable)remarks -> {
            BoxedUnit boxedUnit;
            String sql = MODULE$.formatRemarksSQL(jdbcSchema, table, (String)remarks, settings);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Extracting column remarks using {}", new Object[]{sql});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (scala.collection.immutable.Map)MODULE$.withJDBCConnection(connectionOptions, (Function1 & Serializable & scala.Serializable)connection -> {
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery(sql);
                Map res = Map$.MODULE$.empty();
                while (rs.next()) {
                    res.put((Object)rs.getString(1), (Object)rs.getString(2));
                }
                return res.toMap(Predef$.MODULE$.$conforms());
            }, settings);
        });
    }

    private Try<String> extractCaseInsensitiveSchemaName(DatabaseMetaData databaseMetaData, Option<String> catalog, String schemaName) {
        return Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> databaseMetaData.getSchemas((String)catalog.orNull(Predef$.MODULE$.$conforms()), "%"), (Function1 & Serializable & scala.Serializable)resultSet -> {
            None$ result = None$.MODULE$;
            while (result.isEmpty() && resultSet.next()) {
                String tableSchema = resultSet.getString("TABLE_SCHEM");
                if (!schemaName.equalsIgnoreCase(tableSchema)) continue;
                result = new Some((Object)tableSchema);
            }
            return (String)result.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception(new java.lang.StringBuilder(17).append("Schema ").append(schemaName).append(" not found").toString());
            });
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public scala.collection.immutable.Map<String, Tuple3<String, List<Attribute>, List<String>>> extractJDBCTables(JDBCSchema jdbcSchema, scala.collection.immutable.Map<String, String> connectionOptions, boolean skipRemarks, Seq<String> excludeTables, Settings settings) {
        return (scala.collection.immutable.Map)this.withJDBCConnection(connectionOptions, (Function1 & Serializable & scala.Serializable)connection -> {
            BoxedUnit boxedUnit;
            scala.collection.immutable.Map map;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            scala.collection.immutable.Map jdbcTableMap = ((TraversableOnce)jdbcSchema.tables().map((Function1 & Serializable & scala.Serializable)tblSchema -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tblSchema.name().toUpperCase()), tblSchema), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List uppercaseTableNames = jdbcTableMap.keys().toList();
            Try<String> try_ = MODULE$.extractCaseInsensitiveSchemaName(databaseMetaData, jdbcSchema.catalog(), jdbcSchema.schema());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw exception;
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            String schemaName = (String)success.value();
            String schemaName2 = schemaName;
            List list = uppercaseTableNames;
            if (Nil$.MODULE$.equals(list)) {
                map = JDBCUtils$.extractTables$1(JDBCUtils$.extractTables$default$1$1(), databaseMetaData, jdbcSchema, schemaName2, skipRemarks, connectionOptions, settings);
            } else if (list.contains((Object)"*")) {
                map = JDBCUtils$.extractTables$1(JDBCUtils$.extractTables$default$1$1(), databaseMetaData, jdbcSchema, schemaName2, skipRemarks, connectionOptions, settings);
            } else {
                BoxedUnit boxedUnit2;
                scala.collection.immutable.Map extractedTableNames = JDBCUtils$.extractTables$1(list, databaseMetaData, jdbcSchema, schemaName2, skipRemarks, connectionOptions, settings);
                List notExtractedTable = (List)list.diff((GenSeq)((TraversableOnce)((TraversableLike)extractedTableNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String tableName = (String)tuple2._1();
                        return tableName;
                    }
                    throw new MatchError((Object)tuple2);
                }, Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toUpperCase(), Iterable$.MODULE$.canBuildFrom())).toList());
                if (notExtractedTable.nonEmpty()) {
                    String tablesNotExtractedStr = notExtractedTable.mkString(", ");
                    if (MODULE$.logger().underlying().isWarnEnabled()) {
                        MODULE$.logger().underlying().warn("The following tables where not extracted for {} : {}", new Object[]{jdbcSchema.schema(), tablesNotExtractedStr});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                map = extractedTableNames;
            }
            scala.collection.immutable.Map selectedTablesBeforeExclusion = map;
            Seq lowerCasedExcludeTables = (Seq)excludeTables.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toLowerCase(), Seq$.MODULE$.canBuildFrom());
            scala.collection.immutable.Map selectedTables = (scala.collection.immutable.Map)selectedTablesBeforeExclusion.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$extractJDBCTables$9(lowerCasedExcludeTables, x0$2)));
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                selectedTables.keys().foreach((Function1 & Serializable & scala.Serializable)table -> {
                    JDBCUtils$.$anonfun$extractJDBCTables$10(table);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            scala.collection.immutable.Map selectedTablesAndColumns = (scala.collection.immutable.Map)selectedTables.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String tableRemarks;
                    String tableName = (String)tuple2._1();
                    Try try_ = Using.Manager$.MODULE$.apply(arg_0 -> JDBCUtils$.$anonfun$extractJDBCTables$12(databaseMetaData, jdbcSchema, schemaName2, tableName, skipRemarks, connectionOptions, settings, jdbcTableMap, tableRemarks = (String)tuple2._2(), arg_0));
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw exception;
                    }
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Tuple2 value = (Tuple2)success.value();
                        return value;
                    }
                    throw new MatchError((Object)try_);
                }
                throw new MatchError((Object)tuple2);
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            return selectedTablesAndColumns;
        }, settings);
    }

    public Seq<String> extractJDBCTables$default$4() {
        return Nil$.MODULE$;
    }

    private String formatRemarksSQL(JDBCSchema jdbcSchema, String table, String remarks, Settings settings) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalog"), jdbcSchema.catalog().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)jdbcSchema.schema()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table)}));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Interpolating remark {} with parameters {}", new Object[]{remarks, parameters});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String sql = Formatter$.MODULE$.RichFormatter(remarks).richFormat((scala.collection.immutable.Map<String, String>)parameters, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), settings);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Remark interpolated as {}", new Object[]{sql});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sql;
    }

    public Domain extractDomain(JDBCSchema jdbcSchema, Option<Domain> domainTemplate, scala.collection.immutable.Map<String, Tuple3<String, List<Attribute>, List<String>>> selectedTablesAndColumns) {
        Option trimTemplate = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.tables().headOption().flatMap((Function1 & Serializable & scala.Serializable)x$8 -> ((Attribute)x$8.attributes().head()).trim()));
        scala.collection.immutable.Iterable cometSchema = (scala.collection.immutable.Iterable)selectedTablesAndColumns.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String tableName = (String)tuple2._1();
                Tuple3 tuple3 = (Tuple3)tuple2._2();
                if (tuple3 != null) {
                    String tableRemarks = (String)tuple3._1();
                    List selectedColumns = (List)tuple3._2();
                    List primaryKeys = (List)tuple3._3();
                    String sanitizedTableName = Utils$.MODULE$.keepAlphaNum(tableName);
                    String x$18 = tableName;
                    String string = sanitizedTableName;
                    String string2 = tableName;
                    None$ x$19 = (string == null ? string2 != null : !string.equals(string2)) ? new Some((Object)sanitizedTableName) : None$.MODULE$;
                    Pattern x$20 = Pattern.compile(new java.lang.StringBuilder(2).append(tableName).append(".*").toString());
                    List x$21 = (List)selectedColumns.map((Function1 & Serializable & scala.Serializable)attr -> {
                        Option x$1 = JDBCUtils$.isNumeric$1(attr.type()) ? jdbcSchema.numericTrim().orElse((Function0 & Serializable & scala.Serializable)() -> trimTemplate) : trimTemplate;
                        String x$2 = attr.copy$default$1();
                        String x$3 = attr.copy$default$2();
                        Option<Object> x$4 = attr.copy$default$3();
                        boolean x$5 = attr.copy$default$4();
                        PrivacyLevel x$6 = attr.copy$default$5();
                        Option<String> x$7 = attr.copy$default$6();
                        Option<String> x$8 = attr.copy$default$7();
                        Option<MetricType> x$9 = attr.copy$default$8();
                        List<Attribute> x$10 = attr.copy$default$9();
                        Option<Position> x$11 = attr.copy$default$10();
                        Option<String> x$12 = attr.copy$default$11();
                        Set<String> x$13 = attr.copy$default$12();
                        Option<String> x$14 = attr.copy$default$14();
                        Option<String> x$15 = attr.copy$default$15();
                        Option<Object> x$16 = attr.copy$default$16();
                        Option<String> x$17 = attr.copy$default$17();
                        return attr.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Trim>)x$1, x$14, x$15, x$16, x$17);
                    }, List$.MODULE$.canBuildFrom());
                    None$ x$22 = None$.MODULE$;
                    None$ x$23 = None$.MODULE$;
                    Option x$24 = Option$.MODULE$.apply((Object)tableRemarks);
                    Nil$ x$25 = Nil$.MODULE$;
                    Nil$ x$26 = Nil$.MODULE$;
                    List x$27 = primaryKeys;
                    Set<String> x$28 = Schema$.MODULE$.apply$default$9();
                    List<RowLevelSecurity> x$29 = Schema$.MODULE$.apply$default$10();
                    scala.collection.immutable.Map<String, String> x$30 = Schema$.MODULE$.apply$default$11();
                    List<AccessControlEntry> x$31 = Schema$.MODULE$.apply$default$13();
                    Option<String> x$32 = Schema$.MODULE$.apply$default$15();
                    Option<String> x$33 = Schema$.MODULE$.apply$default$16();
                    return new Schema(x$18, x$20, (List<Attribute>)x$21, (Option<Metadata>)x$22, (Option<MergeOptions>)x$23, (Option<String>)x$24, (List<String>)x$25, (List<String>)x$26, x$28, x$29, x$30, (List<String>)x$27, x$31, (Option<String>)x$19, x$32, x$33);
                }
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        String incomingDir = (String)domainTemplate.map((Function1 & Serializable & scala.Serializable)dom -> DatasetArea$.MODULE$.substituteDomainAndSchemaInPath(jdbcSchema.schema(), "", dom.resolveDirectory()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(1).append("/").append(jdbcSchema.schema()).toString());
        String normalizedDomainName = Utils$.MODULE$.keepAlphaNum(jdbcSchema.schema());
        Option rename = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.rename()).map((Function1 & Serializable & scala.Serializable)name -> DatasetArea$.MODULE$.substituteDomainAndSchema(jdbcSchema.schema(), "", (String)name)).orElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = normalizedDomainName;
            String string2 = jdbcSchema.schema();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return new Some((Object)normalizedDomainName);
            }
            return None$.MODULE$;
        });
        List extensions = (List)domainTemplate.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.resolveExtensions()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Option ack = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.resolveAck());
        String x$59 = jdbcSchema.schema();
        Option x$60 = rename;
        Option x$61 = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.metadata()).map((Function1 & Serializable & scala.Serializable)x$13 -> {
            Some x$34 = new Some((Object)incomingDir);
            List x$35 = extensions;
            Option x$36 = ack;
            Option<Mode> x$37 = x$13.copy$default$1();
            Option<Format> x$38 = x$13.copy$default$2();
            Option<String> x$39 = x$13.copy$default$3();
            Option<Object> x$40 = x$13.copy$default$4();
            Option<Object> x$41 = x$13.copy$default$5();
            Option<Object> x$42 = x$13.copy$default$6();
            Option<String> x$43 = x$13.copy$default$7();
            Option<String> x$44 = x$13.copy$default$8();
            Option<String> x$45 = x$13.copy$default$9();
            Option<WriteMode> x$46 = x$13.copy$default$10();
            Option<Partition> x$47 = x$13.copy$default$11();
            Option<Sink> x$48 = x$13.copy$default$12();
            Option<String> x$49 = x$13.copy$default$13();
            Option<Seq<String>> x$50 = x$13.copy$default$14();
            Option<scala.collection.immutable.Map<String, String>> x$51 = x$13.copy$default$15();
            Option<scala.collection.immutable.Map<String, String>> x$52 = x$13.copy$default$19();
            Option<String> x$53 = x$13.copy$default$20();
            Option<Object> x$54 = x$13.copy$default$21();
            Option<DagGenerationConfig> x$55 = x$13.copy$default$22();
            Option<Freshness> x$56 = x$13.copy$default$23();
            Option<String> x$57 = x$13.copy$default$24();
            boolean x$58 = x$13.copy$default$25();
            return x$13.copy(x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, (Option<String>)x$34, (List<String>)x$35, (Option<String>)x$36, x$52, x$53, x$54, x$55, x$56, x$57, x$58);
        });
        Nil$ x$62 = Nil$.MODULE$;
        List x$63 = cometSchema.toList();
        None$ x$64 = None$.MODULE$;
        Nil$ x$65 = Nil$.MODULE$;
        None$ x$66 = None$.MODULE$;
        Option<String> x$67 = Domain$.MODULE$.apply$default$2();
        Set<String> x$68 = Domain$.MODULE$.apply$default$9();
        Option<String> x$69 = Domain$.MODULE$.apply$default$11();
        return new Domain(x$59, x$67, (Option<Metadata>)x$61, (List<String>)x$62, (List<Schema>)x$63, (Option<String>)x$64, (List<String>)x$65, (Option<String>)x$66, x$68, (Option<String>)x$60, x$69);
    }

    public String ai$starlake$extract$JDBCUtils$$sparkType(int jdbcType, String tableName, String colName, String colTypename, Option<Object> decimalDigit, boolean isPostgres) {
        BoxedUnit boxedUnit;
        String sqlType = (String)this.reverseSqlTypes().getOrElse((Object)BoxesRunTime.boxToInteger((int)jdbcType), (Function0 & Serializable & scala.Serializable)() -> colTypename);
        int n = jdbcType;
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return "string";
            }
            case -7: 
            case 16: {
                return "boolean";
            }
            case 6: 
            case 7: 
            case 8: {
                return "double";
            }
            case 2: 
            case 3: {
                return "decimal";
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "long";
            }
            case 91: {
                return "date";
            }
            case 93: {
                return "timestamp";
            }
            case 2014: {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("forced conversion for {}.{} from {} to timestamp", new Object[]{tableName, colName, sqlType});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return "timestamp";
            }
            case -3: 
            case -2: {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("forced conversion for {}.{} from {} to string", new Object[]{tableName, colName, sqlType});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                return "string";
            }
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Extracting user defined type {} of type {} ({}) in {}.{}  as string", new Object[]{colTypename, sqlType, BoxesRunTime.boxToInteger((int)jdbcType), tableName, colName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return "string";
    }

    private char getColNameQuote(String jdbcConnectionUrl) {
        .colon.colon specialColNameQuote = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc:mysql"), (Object)BoxesRunTime.boxToCharacter((char)'`')), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc:h2"), (Object)BoxesRunTime.boxToCharacter((char)'`')), (List)Nil$.MODULE$));
        return BoxesRunTime.unboxToChar((Object)specialColNameQuote.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$getColNameQuote$1(jdbcConnectionUrl, x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToCharacter((char)JDBCUtils$.$anonfun$getColNameQuote$2(x0$2))).getOrElse((Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> '\"'));
    }

    private Option<ForkJoinTaskSupport> createForkSupport(int maxPar) {
        if (maxPar < 2) {
            return None$.MODULE$;
        }
        ForkJoinPool forkJoinPool = new ForkJoinPool(maxPar);
        return new Some((Object)new ForkJoinTaskSupport(forkJoinPool));
    }

    private <T> GenTraversable<T> makeParallel(GenTraversable<T> list, Option<ForkJoinTaskSupport> fjp) {
        Option<ForkJoinTaskSupport> option = fjp;
        if (option instanceof Some) {
            Some some = (Some)option;
            ForkJoinTaskSupport pool = (ForkJoinTaskSupport)some.value();
            ParIterable parList = (ParIterable)list.par();
            parList.tasksupport_$eq((TaskSupport)pool);
            return parList;
        }
        if (None$.MODULE$.equals(option)) {
            return list;
        }
        throw new MatchError(option);
    }

    public void extractData(SchemaHandler schemaHandler, JDBCSchema jdbcSchema, scala.collection.immutable.Map<String, String> connectionOptions, File baseOutputDir, int limit, char separator, int defaultNumPartitions, boolean clean, int parallelism, boolean fullExportCli, String datePattern, String timestampPattern, Option<Function1<Object, Object>> extractionPredicate, boolean cleanOnExtract, Seq<String> includeTables, Seq<String> excludeTables, Settings settings) {
        BoxedUnit boxedUnit;
        boolean doTablesExtraction;
        JDBCSchema jDBCSchema;
        Seq lowerCasedIncludeTables;
        scala.collection.immutable.Map auditConnectionOptions = (scala.collection.immutable.Map)settings.comet().connections().get((Object)"audit").map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.options()).getOrElse((Function0 & Serializable & scala.Serializable)() -> connectionOptions);
        String jdbcUrl = (String)connectionOptions.apply((Object)"url");
        char colNameQuoteData = this.getColNameQuote(jdbcUrl);
        char colNameQuoteAudit = this.getColNameQuote((String)auditConnectionOptions.apply((Object)"url"));
        String domainName = jdbcSchema.schema().replaceAll("[^\\p{Alnum}]", "_");
        baseOutputDir.createDirectories(baseOutputDir.createDirectories$default$1(), baseOutputDir.createDirectories$default$2());
        File outputDir = File$.MODULE$.apply(baseOutputDir, domainName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        outputDir.createDirectories(outputDir.createDirectories$default$1(), outputDir.createDirectories$default$2());
        if (clean) {
            outputDir.list().foreach((Function1 & Serializable & scala.Serializable)x$15 -> x$15.delete(true, x$15.delete$default$2()));
        }
        if ((lowerCasedIncludeTables = (Seq)includeTables.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.toLowerCase(), Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            List tablesToFetch;
            Object object;
            Option option = jdbcSchema.tables().find((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$extractData$5(x$17)));
            if (option instanceof Some) {
                Some some = (Some)option;
                JDBCTable allTableDef = (JDBCTable)some.value();
                object = (Seq)((TraversableLike)lowerCasedIncludeTables.diff((GenSeq)jdbcSchema.tables().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.name().toLowerCase(), List$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)n -> allTableDef.copy((String)n, allTableDef.copy$default$2(), allTableDef.copy$default$3(), allTableDef.copy$default$4(), allTableDef.copy$default$5(), allTableDef.copy$default$6(), allTableDef.copy$default$7()), Seq$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                object = jdbcSchema.tables().isEmpty() ? (Seq)lowerCasedIncludeTables.map((Function1 & Serializable & scala.Serializable)x$19 -> new JDBCTable((String)x$19, (List<String>)Nil$.MODULE$, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Nil$ additionalTables = object;
            List x$1 = tablesToFetch = (List)((List)jdbcSchema.tables().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)lowerCasedIncludeTables.contains((Object)t.name().toLowerCase())))).$plus$plus((GenTraversableOnce)additionalTables, List$.MODULE$.canBuildFrom());
            Option<String> x$2 = jdbcSchema.copy$default$1();
            String x$3 = jdbcSchema.copy$default$2();
            Option<String> x$4 = jdbcSchema.copy$default$3();
            Option<String> x$5 = jdbcSchema.copy$default$4();
            List<String> x$6 = jdbcSchema.copy$default$6();
            Option<String> x$7 = jdbcSchema.copy$default$7();
            Option<WriteMode> x$8 = jdbcSchema.copy$default$8();
            Option<String> x$9 = jdbcSchema.copy$default$9();
            Option<Trim> x$10 = jdbcSchema.copy$default$10();
            Option<String> x$11 = jdbcSchema.copy$default$11();
            Option<Object> x$12 = jdbcSchema.copy$default$12();
            scala.collection.immutable.Map<String, String> x$13 = jdbcSchema.copy$default$13();
            Option<Object> x$142 = jdbcSchema.copy$default$14();
            Option<String> x$152 = jdbcSchema.copy$default$15();
            Option<Object> x$162 = jdbcSchema.copy$default$16();
            jDBCSchema = jdbcSchema.copy(x$2, x$3, x$4, x$5, (List<JDBCTable>)x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$142, x$152, x$162);
        } else {
            jDBCSchema = jdbcSchema;
        }
        JDBCSchema filteredJdbcSchema = jDBCSchema;
        boolean bl = doTablesExtraction = jdbcSchema.tables().isEmpty() || filteredJdbcSchema.tables().nonEmpty();
        if (doTablesExtraction) {
            BoxedUnit boxedUnit2;
            scala.collection.immutable.Map<String, Tuple3<String, List<Attribute>, List<String>>> selectedTablesAndColumns = this.extractJDBCTables(filteredJdbcSchema, connectionOptions, true, excludeTables, settings);
            Option<ForkJoinTaskSupport> forkJoinTaskSupport = this.createForkSupport(parallelism);
            long globalStart = System.currentTimeMillis();
            this.makeParallel((GenTraversable)selectedTablesAndColumns, forkJoinTaskSupport).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String tableName = (String)tuple2._1();
                    Tuple3 tuple3 = (Tuple3)tuple2._2();
                    if (tuple3 != null) {
                        List selectedColumns = (List)tuple3._2();
                        String context = new java.lang.StringBuilder(3).append("[").append(jdbcSchema.schema()).append(".").append(tableName).append("]").toString();
                        Option currentTable = ((TraversableLike)((SeqLike)jdbcSchema.tables().flatMap((Function1 & Serializable & scala.Serializable)table -> {
                            if (table.name().contains("*") || table.name().equalsIgnoreCase(tableName)) {
                                return Option$.MODULE$.option2Iterable((Option)new Some(table));
                            }
                            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }, List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$extractData$12(tableName, x$20)), Ordering.Boolean$.MODULE$.reverse())).headOption();
                        scala.collection.immutable.Map currentTableConnectionOptions = (scala.collection.immutable.Map)currentTable.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.connectionOptions()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
                        boolean doExtraction = BoxesRunTime.unboxToBoolean((Object)extractionPredicate.flatMap((Function1 & Serializable & scala.Serializable)predicate -> ((Option)MODULE$.withJDBCConnection((scala.collection.immutable.Map<String, String>)auditConnectionOptions, (Function1 & Serializable & scala.Serializable)connection -> LastExportUtils$.MODULE$.getLastAllExport((Connection)connection, jdbcSchema.schema(), tableName, colNameQuoteAudit, settings), settings)).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)predicate.apply$mcZJ$sp(t.getTime())))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
                        if (doExtraction) {
                            int n;
                            if (cleanOnExtract) {
                                BoxedUnit boxedUnit;
                                if (MODULE$.logger().underlying().isInfoEnabled()) {
                                    MODULE$.logger().underlying().info("Deleting all files of {}", new Object[]{tableName});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                outputDir.list().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$extractData$19(tableName, f))).foreach((Function1 & Serializable & scala.Serializable)f -> {
                                    JDBCUtils$.$anonfun$extractData$20(f);
                                    return BoxedUnit.UNIT;
                                });
                            }
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneId.systemDefault());
                            String dateTime = formatter.format(Instant.now());
                            String cols = ((TraversableOnce)selectedColumns.map((Function1 & Serializable & scala.Serializable)x$22 -> new java.lang.StringBuilder(0).append(colNameQuoteData).append(x$22.name()).append(colNameQuoteData).toString(), List$.MODULE$.canBuildFrom())).mkString(",");
                            Option partitionColumn = currentTable.flatMap((Function1 & Serializable & scala.Serializable)x$23 -> x$23.partitionColumn()).orElse((Function0 & Serializable & scala.Serializable)() -> jdbcSchema.partitionColumn());
                            Option fetchSize = currentTable.flatMap((Function1 & Serializable & scala.Serializable)x$24 -> x$24.fetchSize()).orElse((Function0 & Serializable & scala.Serializable)() -> jdbcSchema.fetchSize());
                            boolean fullExport = fullExportCli ? fullExportCli : BoxesRunTime.unboxToBoolean((Object)currentTable.flatMap((Function1 & Serializable & scala.Serializable)x$25 -> x$25.fullExport()).orElse((Function0 & Serializable & scala.Serializable)() -> jdbcSchema.fullExport()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                            int numPartitions = BoxesRunTime.unboxToInt((Object)currentTable.flatMap((Function1 & Serializable & scala.Serializable)tbl -> tbl.numPartitions()).orElse((Function0 & Serializable & scala.Serializable)() -> jdbcSchema.numPartitions()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> defaultNumPartitions));
                            Option option = partitionColumn;
                            if (None$.MODULE$.equals(option)) {
                                long l;
                                String sql = new java.lang.StringBuilder(18).append("select ").append(cols).append(" from \"").append(jdbcSchema.schema()).append("\".\"").append(tableName).append("\"").toString();
                                long tableStart = System.currentTimeMillis();
                                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong(MODULE$.withJDBCConnection((scala.collection.immutable.Map<String, String>)connectionOptions.$plus$plus((GenTraversableOnce)currentTableConnectionOptions), (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToLong((long)JDBCUtils$.$anonfun$extractData$33(sql, fetchSize, context, limit, separator, outputDir, tableName, dateTime, datePattern, timestampPattern, connection)), settings)));
                                if (try_ instanceof Success) {
                                    long count;
                                    Success success = (Success)try_;
                                    l = count = BoxesRunTime.unboxToLong((Object)success.value());
                                } else if (try_ instanceof Failure) {
                                    Failure failure = (Failure)try_;
                                    Throwable e = failure.exception();
                                    Utils$.MODULE$.logException(MODULE$.logger(), e);
                                    l = -1;
                                } else {
                                    throw new MatchError((Object)try_);
                                }
                                long count = l;
                                long tableEnd = System.currentTimeMillis();
                                DeltaRow deltaRow = new DeltaRow(jdbcSchema.schema(), tableName, BoxesRunTime.boxToLong((long)tableStart), new Timestamp(tableStart), new Timestamp(tableEnd), (int)(tableEnd - tableStart), jdbcSchema.writeMode().toString(), count, count >= 0L, "FULL", "ALL");
                                n = BoxesRunTime.unboxToInt(MODULE$.withJDBCConnection((scala.collection.immutable.Map<String, String>)auditConnectionOptions, (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)LastExportUtils$.MODULE$.insertNewLastExport(connection, deltaRow, (Option<PrimitiveType>)None$.MODULE$, colNameQuoteAudit, colNameQuoteAudit, settings)), settings));
                            } else if (option instanceof Some) {
                                BoxedUnit boxedUnit;
                                boolean bl;
                                BoxedUnit boxedUnit2;
                                Some some = (Some)option;
                                String partitionColumn2 = (String)some.value();
                                LazyRef stringPartitionFuncTpl$lzy = new LazyRef();
                                PrimitiveType partitionColumnType = (PrimitiveType)selectedColumns.find((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$extractData$37(partitionColumn2, x$26))).flatMap((Function1 & Serializable & scala.Serializable)attr -> schemaHandler.types(schemaHandler.types$default$1()).find((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$extractData$39(attr, x$27)))).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.primitiveType()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                    throw new Exception(new java.lang.StringBuilder(59).append("Could not find column type for partition column ").append(partitionColumn2).append(" in table ").append(jdbcSchema.schema()).append(".").append(tableName).toString());
                                });
                                LastExportUtils.Bounds boundaries = (LastExportUtils.Bounds)MODULE$.withJDBCConnection(connectionOptions, (Function1 & Serializable & scala.Serializable)connection -> {
                                    scala.collection.immutable.Map map = connectionOptions;
                                    scala.collection.immutable.Map map2 = auditConnectionOptions;
                                    if (!(map != null ? !map.equals(map2) : map2 != null)) {
                                        return JDBCUtils$.getBoundariesWith$1(connection, connection, jdbcSchema, tableName, partitionColumn2, partitionColumnType, numPartitions, colNameQuoteData, colNameQuoteAudit, fullExport, settings, stringPartitionFuncTpl$lzy, jdbcUrl);
                                    }
                                    return (LastExportUtils.Bounds)MODULE$.withJDBCConnection((scala.collection.immutable.Map<String, String>)auditConnectionOptions, (Function1 & Serializable & scala.Serializable)auditConnection -> JDBCUtils$.getBoundariesWith$1(auditConnection, connection, jdbcSchema, tableName, partitionColumn2, partitionColumnType, numPartitions, colNameQuoteData, colNameQuoteAudit, fullExport, settings, stringPartitionFuncTpl$lzy, jdbcUrl), settings);
                                }, settings);
                                if (MODULE$.logger().underlying().isInfoEnabled()) {
                                    MODULE$.logger().underlying().info("{} Boundaries : {}", new Object[]{context, boundaries});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                long tableStart = System.currentTimeMillis();
                                ObjectRef tableCount = ObjectRef.create((Object)new AtomicLong());
                                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.makeParallel((GenTraversable)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])boundaries.partitions())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), forkJoinTaskSupport).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)JDBCUtils$.$anonfun$extractData$46(context, colNameQuoteData, partitionColumn2, boundaries, connectionOptions, partitionColumnType, numPartitions, settings, fetchSize, limit, separator, outputDir, tableName, dateTime, datePattern, timestampPattern, tableCount, tableStart, jdbcSchema, auditConnectionOptions, colNameQuoteAudit, cols, stringPartitionFuncTpl$lzy, jdbcUrl, x0$2))));
                                if (try_ instanceof Success) {
                                    bl = true;
                                } else if (try_ instanceof Failure) {
                                    Failure failure = (Failure)try_;
                                    Throwable e = failure.exception();
                                    Utils$.MODULE$.logException(MODULE$.logger(), e);
                                    bl = false;
                                } else {
                                    throw new MatchError((Object)try_);
                                }
                                boolean success = bl;
                                long tableEnd = System.currentTimeMillis();
                                int duration = (int)(tableEnd - tableStart);
                                String elapsedTime = Utils$.MODULE$.toHumanElapsedTime(duration);
                                if (MODULE$.logger().underlying().isInfoEnabled()) {
                                    MODULE$.logger().underlying().info("{} Extracted all lines in {}", new Object[]{context, elapsedTime});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                DeltaRow deltaRow = new DeltaRow(jdbcSchema.schema(), tableName, boundaries.max(), new Timestamp(tableStart), new Timestamp(tableEnd), duration, jdbcSchema.writeMode().toString(), boundaries.count(), success, partitionColumn2, "ALL");
                                n = BoxesRunTime.unboxToInt(MODULE$.withJDBCConnection((scala.collection.immutable.Map<String, String>)auditConnectionOptions, (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)LastExportUtils$.MODULE$.insertNewLastExport(connection, deltaRow, (Option<PrimitiveType>)new Some((Object)partitionColumnType), colNameQuoteAudit, colNameQuoteAudit, settings)), settings));
                            } else {
                                throw new MatchError((Object)option);
                            }
                            return BoxesRunTime.boxToInteger((int)n);
                        }
                        if (MODULE$.logger().underlying().isInfoEnabled()) {
                            MODULE$.logger().underlying().info("Extraction skipped. {}.{} data is fresh enough.", new Object[]{domainName, tableName});
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            forkJoinTaskSupport.foreach((Function1 & Serializable & scala.Serializable)x$37 -> {
                JDBCUtils$.$anonfun$extractData$58(x$37);
                return BoxedUnit.UNIT;
            });
            String elapsedTime = Utils$.MODULE$.toHumanElapsedTimeFrom(globalStart);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Extracted all tables in {}", new Object[]{elapsedTime});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Tables extraction skipped");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Option<String> getStringPartitionFunc(String jdbcUrl) {
        .colon.colon hashFunctions = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc:sqlserver"), (Object)"abs( binary_checksum({{col}}) % {{nb_partitions}} )"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc:postgres"), (Object)"abs( hashtext({{col}}) % {{nb_partitions}} )"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc:h2"), (Object)"ora_hash({{col}}, {{nb_partitions}} - 1)"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc:mysql"), (Object)"crc32({{col}}) % {{nb_partitions}}"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc:oracle"), (Object)"ora_hash({{col}}, {{nb_partitions}} - 1)"), (List)Nil$.MODULE$)))));
        return hashFunctions.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$getStringPartitionFunc$1(jdbcUrl, x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String partitionFunc = (String)tuple2._2();
                return partitionFunc;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private long extractPartitionToFile(String context, int limit, char separator, File outputDir, String tableName, String dateTime, Option<Object> index2, PreparedStatement statement, String datePattern, String timestampPattern) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String filename = (String)index2.map((Function1 & Serializable & scala.Serializable)index -> JDBCUtils$.$anonfun$extractPartitionToFile$1(tableName, dateTime, BoxesRunTime.unboxToInt((Object)index))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(5).append(tableName).append("-").append(dateTime).append(".csv").toString());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{} Starting extraction into {}", new Object[]{context, filename});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        File outFile = File$.MODULE$.apply(outputDir, filename, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        FileWriter outFileWriter = outFile.newFileWriter(false);
        CSVWriter csvWriterResource = new CSVWriter((Writer)outFileWriter, separator, '\"', '\\');
        statement.setMaxRows(limit);
        ResultSet rs = statement.executeQuery();
        SLResultSetHelperService resultService = new SLResultSetHelperService(datePattern, timestampPattern);
        LongRef count = LongRef.create((long)0L);
        long extractionStartMs = System.currentTimeMillis();
        package$.MODULE$.using((Object)csvWriterResource, (Function1 & Serializable & scala.Serializable)csvWriter -> {
            JDBCUtils$.$anonfun$extractPartitionToFile$3(resultService, rs, extractionStartMs, count, context, csvWriter);
            return BoxedUnit.UNIT;
        }, Disposable$.MODULE$.closableDisposer());
        String elapsedTime = Utils$.MODULE$.toHumanElapsedTimeFrom(extractionStartMs);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{} Extracted {} rows and saved into {} in {}", new Object[]{context, BoxesRunTime.boxToLong((long)count.elem), filename, elapsedTime});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return count.elem;
    }

    public static final /* synthetic */ boolean $anonfun$applyScript$1(String script$1, Connection conn) {
        return conn.createStatement().execute(script$1);
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$4(List tablesToExtract$1, boolean skipRemarks$1, JDBCSchema jdbcSchema$3, scala.collection.immutable.Map connectionOptions$3, Settings settings$3, Map tableNames$1, ResultSet resultSet) {
        while (resultSet.next()) {
            BoxedUnit boxedUnit;
            String tableName = resultSet.getString("TABLE_NAME");
            if (tablesToExtract$1.isEmpty() || tablesToExtract$1.contains((Object)tableName.toUpperCase())) {
                BoxedUnit boxedUnit2;
                Option<String> localRemarks = skipRemarks$1 ? None$.MODULE$ : MODULE$.extractTableRemarks(jdbcSchema$3, (scala.collection.immutable.Map<String, String>)connectionOptions$3, tableName, settings$3);
                String remarks = (String)localRemarks.getOrElse((Function0 & Serializable & scala.Serializable)() -> resultSet.getString("REMARKS"));
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Extracting table {}: {}", new Object[]{tableName, remarks});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = tableNames$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)remarks));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final scala.collection.immutable.Map extractTables$1(List tablesToExtract, DatabaseMetaData databaseMetaData$2, JDBCSchema jdbcSchema$3, String schemaName$2, boolean skipRemarks$1, scala.collection.immutable.Map connectionOptions$3, Settings settings$3) {
        Map tableNames = Map$.MODULE$.empty();
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> databaseMetaData$2.getTables((String)jdbcSchema$3.catalog().orNull(Predef$.MODULE$.$conforms()), schemaName$2, "%", (String[])jdbcSchema$3.tableTypes().toArray(ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable & scala.Serializable)resultSet -> {
            JDBCUtils$.$anonfun$extractJDBCTables$4(tablesToExtract, skipRemarks$1, jdbcSchema$3, connectionOptions$3, settings$3, tableNames, resultSet);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return tableNames.toMap(Predef$.MODULE$.$conforms());
    }

    private static final List extractTables$default$1$1() {
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$extractJDBCTables$9(Seq lowerCasedExcludeTables$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String tableName = (String)tuple2._1();
            return !lowerCasedExcludeTables$1.contains((Object)tableName.toLowerCase());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$10(String table) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Selected: {}", new Object[]{table});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$extractJDBCTables$15(Attribute element$1, Attribute x$4) {
        String string = x$4.name();
        String string2 = element$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final List removeDuplicatesColumns$1(List list) {
        return (List)list.foldLeft((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(partialResult, element) -> {
            if (partialResult.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JDBCUtils$.$anonfun$extractJDBCTables$15(element, x$4)))) {
                return partialResult;
            }
            return (List)partialResult.$colon$plus(element, List$.MODULE$.canBuildFrom());
        });
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$16(String tableName$1, Attribute column) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("column: {}.{}", new Object[]{tableName$1, column.name()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$21(String tableName$1, Attribute column) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("Final schema column: {}.{}", new Object[]{tableName$1, column.name()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$extractJDBCTables$12(DatabaseMetaData databaseMetaData$2, JDBCSchema jdbcSchema$3, String schemaName$2, String tableName$1, boolean skipRemarks$1, scala.collection.immutable.Map connectionOptions$3, Settings settings$3, scala.collection.immutable.Map jdbcTableMap$1, String tableRemarks$1, Using.Manager use) {
        BoxedUnit boxedUnit;
        List selectedColumns;
        BoxedUnit boxedUnit2;
        ResultSet foreignKeysResultSet = (ResultSet)use.apply((Object)databaseMetaData$2.getImportedKeys((String)jdbcSchema$3.catalog().orNull(Predef$.MODULE$.$conforms()), schemaName$2, tableName$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        scala.collection.immutable.Map foreignKeys = new Iterator<Tuple2<String, String>>(foreignKeysResultSet){
            private final ResultSet foreignKeysResultSet$1;

            public Iterator<Tuple2<String, String>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<String, String>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<String, String>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<String, String>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<String, String>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<String, String>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<String, String>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<String, String>> filter(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<String, String>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<String, String>> withFilter(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<String, String>> filterNot(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<String, String>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<String, String>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<String, String>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<String, String>> takeWhile(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<String, String>>, Iterator<Tuple2<String, String>>> partition(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<String, String>>, Iterator<Tuple2<String, String>>> span(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<String, String>> dropWhile(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<String, String>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<String, String>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<String, String>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<String, String>> find(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<String, String>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<String, String>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<String, String>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<String, String>>, Iterator<Tuple2<String, String>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<String, String>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<String, String>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<String, String>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple2<String, String>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<String, String>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<String, String>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<String, String>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<String, String>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<String, String>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<String, String>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<String, String>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<String, String>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<String, String>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<String, String>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<String, String>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<String, String>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<String, String>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<String, String>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<String, String>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple2<String, String>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<String, String>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Tuple2<String, String>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.foreignKeysResultSet$1.next();
            }

            public Tuple2<String, String> next() {
                String pkSchemaName = this.foreignKeysResultSet$1.getString("PKTABLE_SCHEM");
                String pkTableName = this.foreignKeysResultSet$1.getString("PKTABLE_NAME");
                String pkColumnName = this.foreignKeysResultSet$1.getString("PKCOLUMN_NAME");
                String fkColumnName = this.foreignKeysResultSet$1.getString("FKCOLUMN_NAME").toUpperCase();
                String pkCompositeName = pkSchemaName == null ? new java.lang.StringBuilder(1).append(pkTableName).append(".").append(pkColumnName).toString() : new java.lang.StringBuilder(2).append(pkSchemaName).append(".").append(pkTableName).append(".").append(pkColumnName).toString();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fkColumnName), (Object)pkCompositeName);
            }
            {
                this.foreignKeysResultSet$1 = foreignKeysResultSet$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        }.toMap(Predef$.MODULE$.$conforms());
        ResultSet columnsResultSet = (ResultSet)use.apply((Object)databaseMetaData$2.getColumns((String)jdbcSchema$3.catalog().orNull(Predef$.MODULE$.$conforms()), schemaName$2, tableName$1, null), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        scala.collection.immutable.Map remarks = (scala.collection.immutable.Map)(skipRemarks$1 ? None$.MODULE$ : MODULE$.extractColumnRemarks(jdbcSchema$3, (scala.collection.immutable.Map<String, String>)connectionOptions$3, tableName$1, settings$3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        boolean isPostgres = ((String)connectionOptions$3.apply((Object)"url")).contains("postgres");
        ListBuffer attrs = (ListBuffer)new Iterator<Attribute>(columnsResultSet, tableName$1, remarks, foreignKeys, isPostgres){
            private final ResultSet columnsResultSet$1;
            private final String tableName$1;
            private final scala.collection.immutable.Map remarks$1;
            private final scala.collection.immutable.Map foreignKeys$1;
            private final boolean isPostgres$1;

            public Iterator<Attribute> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Attribute> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Attribute> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Attribute> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Attribute> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Attribute, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Attribute, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Attribute> filter(Function1<Attribute, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Attribute, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Attribute> withFilter(Function1<Attribute, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Attribute> filterNot(Function1<Attribute, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Attribute, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Attribute, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Attribute, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Attribute> takeWhile(Function1<Attribute, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Attribute>, Iterator<Attribute>> partition(Function1<Attribute, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Attribute>, Iterator<Attribute>> span(Function1<Attribute, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Attribute> dropWhile(Function1<Attribute, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Attribute, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Attribute, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Attribute, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Attribute, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Attribute, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Attribute> find(Function1<Attribute, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Attribute, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Attribute, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Attribute> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Attribute>, Iterator<Attribute>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Attribute> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Attribute> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Attribute> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Attribute> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Attribute, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Attribute, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Attribute, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Attribute, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Attribute, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Attribute, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Attribute, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Attribute, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Attribute, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Attribute, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Attribute, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Attribute> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Attribute> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Attribute> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Attribute> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Attribute> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Attribute, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Attribute, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.columnsResultSet$1.next();
            }

            public Attribute next() {
                BoxedUnit boxedUnit;
                String colName = this.columnsResultSet$1.getString("COLUMN_NAME");
                if (JDBCUtils$.MODULE$.logger().underlying().isInfoEnabled()) {
                    JDBCUtils$.MODULE$.logger().underlying().info("COLUMN_NAME={}.{}", new Object[]{this.tableName$1, colName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                int colType = this.columnsResultSet$1.getInt("DATA_TYPE");
                String colTypename = this.columnsResultSet$1.getString("TYPE_NAME");
                String colRemarks = (String)this.remarks$1.getOrElse((Object)colName, (Function0 & Serializable & scala.Serializable)() -> $this.columnsResultSet$1.getString("REMARKS"));
                boolean colRequired = this.columnsResultSet$1.getString("IS_NULLABLE").equals("NO");
                Option foreignKey = this.foreignKeys$1.get((Object)colName.toUpperCase());
                Option colDecimalDigits = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.columnsResultSet$1.getInt("DECIMAL_DIGITS")));
                String x$1 = colName;
                String x$2 = JDBCUtils$.MODULE$.ai$starlake$extract$JDBCUtils$$sparkType(colType, this.tableName$1, colName, colTypename, (Option<Object>)colDecimalDigits, this.isPostgres$1);
                boolean x$3 = colRequired;
                Option x$4 = Option$.MODULE$.apply((Object)colRemarks);
                Option x$5 = foreignKey;
                Option<Object> x$6 = Attribute$.MODULE$.apply$default$3();
                PrivacyLevel x$7 = Attribute$.MODULE$.apply$default$5();
                Option<String> x$8 = Attribute$.MODULE$.apply$default$7();
                Option<MetricType> x$9 = Attribute$.MODULE$.apply$default$8();
                List<Attribute> x$10 = Attribute$.MODULE$.apply$default$9();
                Option<Position> x$11 = Attribute$.MODULE$.apply$default$10();
                Option<String> x$12 = Attribute$.MODULE$.apply$default$11();
                Set<String> x$13 = Attribute$.MODULE$.apply$default$12();
                Option<Trim> x$14 = Attribute$.MODULE$.apply$default$13();
                Option<String> x$15 = Attribute$.MODULE$.apply$default$14();
                Option<Object> x$16 = Attribute$.MODULE$.apply$default$16();
                Option<String> x$17 = Attribute$.MODULE$.apply$default$17();
                return new Attribute(x$1, x$2, x$6, x$3, x$7, (Option<String>)x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$5, x$16, x$17);
            }
            {
                this.columnsResultSet$1 = columnsResultSet$1;
                this.tableName$1 = tableName$1;
                this.remarks$1 = remarks$1;
                this.foreignKeys$1 = foreignKeys$1;
                this.isPostgres$1 = isPostgres$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1(ai.starlake.extract.JDBCUtils$$anon$2 )}, serializedLambda);
            }
        }.to(ListBuffer$.MODULE$.canBuildFrom());
        List columns = JDBCUtils$.removeDuplicatesColumns$1(attrs.toList());
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                JDBCUtils$.$anonfun$extractJDBCTables$16(tableName$1, column);
                return BoxedUnit.UNIT;
            });
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        List currentTableRequestedColumns = (List)jdbcTableMap$1.get((Object)tableName$1).map((Function1 & Serializable & scala.Serializable)x$5 -> (List)x$5.columns().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toUpperCase(), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        List list = selectedColumns = currentTableRequestedColumns.isEmpty() ? columns : (List)columns.filter((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)currentTableRequestedColumns.contains((Object)col.name().toUpperCase())));
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                JDBCUtils$.$anonfun$extractJDBCTables$21(tableName$1, column);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ResultSet primaryKeysResultSet = (ResultSet)use.apply((Object)databaseMetaData$2.getPrimaryKeys((String)jdbcSchema$3.catalog().orNull(Predef$.MODULE$.$conforms()), schemaName$2, tableName$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        List<String> primaryKeys = new Iterator<String>(primaryKeysResultSet){
            private final ResultSet primaryKeysResultSet$1;

            public Iterator<String> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<String> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<String> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<String> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<String> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<String, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<String> filter(Function1<String, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<String> withFilter(Function1<String, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<String> filterNot(Function1<String, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<String> takeWhile(Function1<String, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<String> dropWhile(Function1<String, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<String, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<String, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<String, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<String, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<String> find(Function1<String, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<String, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<String, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<String> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<String> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<String> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<String> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<String> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<String, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, String, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<String, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<String> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<String> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<String> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<String> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<String> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<String, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.primaryKeysResultSet$1.next();
            }

            public String next() {
                return this.primaryKeysResultSet$1.getString("COLUMN_NAME");
            }
            {
                this.primaryKeysResultSet$1 = primaryKeysResultSet$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        }.toList();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName$1), (Object)new Tuple3((Object)tableRemarks$1, (Object)selectedColumns, primaryKeys));
    }

    private static final boolean isNumeric$1(String sparkType) {
        String string = sparkType;
        return "double".equals(string) ? true : ("decimal".equals(string) ? true : "long".equals(string));
    }

    public static final /* synthetic */ boolean $anonfun$getColNameQuote$1(String jdbcConnectionUrl$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String jdbcPrefix = (String)tuple2._1();
            return jdbcConnectionUrl$1.contains(jdbcPrefix);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ char $anonfun$getColNameQuote$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            char colNameQuote = tuple2._2$mcC$sp();
            return colNameQuote;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$extractData$5(JDBCTable x$17) {
        String string = x$17.name().trim();
        String string2 = "*";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractData$12(String tableName$2, JDBCTable x$20) {
        return x$20.name().equalsIgnoreCase(tableName$2);
    }

    public static final /* synthetic */ boolean $anonfun$extractData$19(String tableName$2, File f) {
        return new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(16).append("^").append(tableName$2).append("-\\d{14}[\\.\\-].*").toString())).r().pattern().matcher(f.name()).matches();
    }

    public static final /* synthetic */ void $anonfun$extractData$20(File f) {
        BoxedUnit boxedUnit;
        f.delete(true, f.delete$default$2());
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            String arg$macro$1 = f.pathAsString();
            MODULE$.logger().underlying().debug(new StringOps("%s deleted").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ long $anonfun$extractData$33(String sql$3, Option fetchSize$1, String context$1, int limit$1, char separator$1, File outputDir$1, String tableName$2, String dateTime$1, String datePattern$1, String timestampPattern$1, Connection connection) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql$3);
        fetchSize$1.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fetchSize -> statement.setFetchSize(fetchSize));
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("{} Fetch size = {}", new Object[]{context$1, BoxesRunTime.boxToInteger((int)statement.getFetchSize())});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("{} SQL: {}", new Object[]{context$1, sql$3});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return MODULE$.extractPartitionToFile(context$1, limit$1, separator$1, outputDir$1, tableName$2, dateTime$1, (Option<Object>)None$.MODULE$, statement, datePattern$1, timestampPattern$1);
    }

    private static final /* synthetic */ Option stringPartitionFuncTpl$lzycompute$1(LazyRef stringPartitionFuncTpl$lzy$1, JDBCSchema jdbcSchema$5, String jdbcUrl$1) {
        Option option;
        LazyRef lazyRef = stringPartitionFuncTpl$lzy$1;
        synchronized (lazyRef) {
            option = stringPartitionFuncTpl$lzy$1.initialized() ? (Option)stringPartitionFuncTpl$lzy$1.value() : (Option)stringPartitionFuncTpl$lzy$1.initialize((Object)jdbcSchema$5.stringPartitionFunc().orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getStringPartitionFunc(jdbcUrl$1)));
        }
        return option;
    }

    private static final Option stringPartitionFuncTpl$1(LazyRef stringPartitionFuncTpl$lzy$1, JDBCSchema jdbcSchema$5, String jdbcUrl$1) {
        if (stringPartitionFuncTpl$lzy$1.initialized()) {
            return (Option)stringPartitionFuncTpl$lzy$1.value();
        }
        return JDBCUtils$.stringPartitionFuncTpl$lzycompute$1(stringPartitionFuncTpl$lzy$1, jdbcSchema$5, jdbcUrl$1);
    }

    private static final String sqlFirst$1(String columnToDistribute, String cols$1, char colNameQuoteData$1, JDBCSchema jdbcSchema$5, String tableName$2) {
        return new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(70).append("select ").append(cols$1).append("\n                     |from ").append(colNameQuoteData$1).append(jdbcSchema$5.schema()).append(colNameQuoteData$1).append(".").append(colNameQuoteData$1).append(tableName$2).append(colNameQuoteData$1).append("\n                     |where ").append(columnToDistribute).append(" <= ?").toString())).stripMargin();
    }

    private static final String sqlNext$1(String columnToDistribute, String cols$1, char colNameQuoteData$1, JDBCSchema jdbcSchema$5, String tableName$2) {
        return new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(79).append("select ").append(cols$1).append("\n                     |from ").append(colNameQuoteData$1).append(jdbcSchema$5.schema()).append(colNameQuoteData$1).append(".").append(colNameQuoteData$1).append(tableName$2).append(colNameQuoteData$1).append("\n                     |where ").append(columnToDistribute).append(" <= ? and ").append(columnToDistribute).append(" > ?").toString())).stripMargin();
    }

    public static final /* synthetic */ boolean $anonfun$extractData$37(String partitionColumn$1, Attribute x$26) {
        return x$26.name().equalsIgnoreCase(partitionColumn$1);
    }

    public static final /* synthetic */ boolean $anonfun$extractData$39(Attribute attr$1, Type x$27) {
        String string = x$27.name();
        String string2 = attr$1.type();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final LastExportUtils.Bounds getBoundariesWith$1(Connection auditConnection, Connection connection$2, JDBCSchema jdbcSchema$5, String tableName$2, String partitionColumn$1, PrimitiveType partitionColumnType$1, int numPartitions$1, char colNameQuoteData$1, char colNameQuoteAudit$1, boolean fullExport$1, Settings settings$4, LazyRef stringPartitionFuncTpl$lzy$1, String jdbcUrl$1) {
        auditConnection.setAutoCommit(false);
        return LastExportUtils$.MODULE$.getBoundaries(connection$2, auditConnection, jdbcSchema$5.schema(), tableName$2, partitionColumn$1, partitionColumnType$1, numPartitions$1, colNameQuoteData$1, colNameQuoteAudit$1, (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> JDBCUtils$.stringPartitionFuncTpl$1(stringPartitionFuncTpl$lzy$1, jdbcSchema$5, jdbcUrl$1), fullExport$1, settings$4);
    }

    private static final String sql$4(String columnToDistribute, LastExportUtils.Bounds boundaries$1, int index$1, String cols$1, char colNameQuoteData$1, JDBCSchema jdbcSchema$5, String tableName$2) {
        if (boundaries$1.firstExport() && index$1 == 0) {
            return JDBCUtils$.sqlFirst$1(columnToDistribute, cols$1, colNameQuoteData$1, jdbcSchema$5, tableName$2);
        }
        return JDBCUtils$.sqlNext$1(columnToDistribute, cols$1, colNameQuoteData$1, jdbcSchema$5, tableName$2);
    }

    private static final String sql$default$1$1(String quotedPartitionColumn$1) {
        return quotedPartitionColumn$1;
    }

    public static final /* synthetic */ void $anonfun$extractData$48(long upper$1, LastExportUtils.Bounds boundaries$1, int index$1, long lower$1, PreparedStatement st) {
        st.setLong(1, upper$1);
        if (!boundaries$1.firstExport() || index$1 != 0) {
            st.setLong(2, lower$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$extractData$49(BigDecimal upper$2, LastExportUtils.Bounds boundaries$1, int index$1, BigDecimal lower$2, PreparedStatement st) {
        st.setBigDecimal(1, upper$2);
        if (!boundaries$1.firstExport() || index$1 != 0) {
            st.setBigDecimal(2, lower$2);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$extractData$50(Date upper$3, LastExportUtils.Bounds boundaries$1, int index$1, Date lower$3, PreparedStatement st) {
        st.setDate(1, upper$3);
        if (!boundaries$1.firstExport() || index$1 != 0) {
            st.setDate(2, lower$3);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$extractData$51(Timestamp upper$4, LastExportUtils.Bounds boundaries$1, int index$1, Timestamp lower$4, PreparedStatement st) {
        st.setTimestamp(1, upper$4);
        if (!boundaries$1.firstExport() || index$1 != 0) {
            st.setTimestamp(2, lower$4);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$extractData$52(long upper$5, LastExportUtils.Bounds boundaries$1, int index$1, long lower$5, PreparedStatement st) {
        st.setLong(1, upper$5);
        if (!boundaries$1.firstExport() || index$1 != 0) {
            st.setLong(2, lower$5);
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$extractData$54(int x$35) {
        return "#";
    }

    public static final /* synthetic */ String $anonfun$extractData$55(int x$36) {
        return " ";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ int $anonfun$extractData$47(PrimitiveType partitionColumnType$1, Tuple2 bounds$1, LastExportUtils.Bounds boundaries$1, int index$1, String quotedPartitionColumn$1, int numPartitions$1, Settings settings$4, String boundaryContext$1, Option fetchSize$1, int limit$1, char separator$1, File outputDir$1, String tableName$2, String dateTime$1, String datePattern$1, String timestampPattern$1, ObjectRef tableCount$1, long tableStart$1, String context$1, JDBCSchema jdbcSchema$5, String partitionColumn$1, scala.collection.immutable.Map auditConnectionOptions$1, char colNameQuoteAudit$1, String cols$1, char colNameQuoteData$1, LazyRef stringPartitionFuncTpl$lzy$1, String jdbcUrl$1, Connection connection2) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Tuple2 tuple2;
        PrimitiveType primitiveType = partitionColumnType$1;
        if (((Object)PrimitiveType$int$.MODULE$).equals(primitiveType) ? true : (((Object)PrimitiveType$long$.MODULE$).equals(primitiveType) ? true : ((Object)PrimitiveType$short$.MODULE$).equals(primitiveType))) {
            Tuple2 tuple22 = bounds$1;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            long lower = tuple22._1$mcJ$sp();
            long upper = tuple22._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(lower, upper);
            long lower2 = sp2._1$mcJ$sp();
            long upper2 = sp2._2$mcJ$sp();
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCUtils$.sql$4(JDBCUtils$.sql$default$1$1(quotedPartitionColumn$1), boundaries$1, index$1, cols$1, colNameQuoteData$1, jdbcSchema$5, tableName$2)), (Function1 & Serializable & scala.Serializable)st -> {
                JDBCUtils$.$anonfun$extractData$48(upper2, boundaries$1, index$1, lower2, st);
                return BoxedUnit.UNIT;
            });
        } else if (((Object)PrimitiveType$decimal$.MODULE$).equals(primitiveType)) {
            Tuple2 tuple23 = bounds$1;
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            BigDecimal lower = (BigDecimal)tuple23._1();
            BigDecimal upper = (BigDecimal)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)lower, (Object)upper);
            BigDecimal lower3 = (BigDecimal)tuple24._1();
            BigDecimal upper3 = (BigDecimal)tuple24._2();
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCUtils$.sql$4(JDBCUtils$.sql$default$1$1(quotedPartitionColumn$1), boundaries$1, index$1, cols$1, colNameQuoteData$1, jdbcSchema$5, tableName$2)), (Function1 & Serializable & scala.Serializable)st -> {
                JDBCUtils$.$anonfun$extractData$49(upper3, boundaries$1, index$1, lower3, st);
                return BoxedUnit.UNIT;
            });
        } else if (((Object)PrimitiveType$date$.MODULE$).equals(primitiveType)) {
            Tuple2 tuple25 = bounds$1;
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            Date lower = (Date)tuple25._1();
            Date upper = (Date)tuple25._2();
            Tuple2 tuple26 = new Tuple2((Object)lower, (Object)upper);
            Date lower4 = (Date)tuple26._1();
            Date upper4 = (Date)tuple26._2();
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCUtils$.sql$4(JDBCUtils$.sql$default$1$1(quotedPartitionColumn$1), boundaries$1, index$1, cols$1, colNameQuoteData$1, jdbcSchema$5, tableName$2)), (Function1 & Serializable & scala.Serializable)st -> {
                JDBCUtils$.$anonfun$extractData$50(upper4, boundaries$1, index$1, lower4, st);
                return BoxedUnit.UNIT;
            });
        } else if (((Object)PrimitiveType$timestamp$.MODULE$).equals(primitiveType)) {
            Tuple2 tuple27 = bounds$1;
            if (tuple27 == null) {
                throw new MatchError((Object)tuple27);
            }
            Timestamp lower = (Timestamp)tuple27._1();
            Timestamp upper = (Timestamp)tuple27._2();
            Tuple2 tuple28 = new Tuple2((Object)lower, (Object)upper);
            Timestamp lower5 = (Timestamp)tuple28._1();
            Timestamp upper5 = (Timestamp)tuple28._2();
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCUtils$.sql$4(JDBCUtils$.sql$default$1$1(quotedPartitionColumn$1), boundaries$1, index$1, cols$1, colNameQuoteData$1, jdbcSchema$5, tableName$2)), (Function1 & Serializable & scala.Serializable)st -> {
                JDBCUtils$.$anonfun$extractData$51(upper5, boundaries$1, index$1, lower5, st);
                return BoxedUnit.UNIT;
            });
        } else {
            if (!((Object)PrimitiveType$string$.MODULE$).equals(primitiveType) || !JDBCUtils$.stringPartitionFuncTpl$1(stringPartitionFuncTpl$lzy$1, jdbcSchema$5, jdbcUrl$1).isDefined()) throw new Exception(new java.lang.StringBuilder(52).append("type ").append(partitionColumnType$1).append(" not supported for partition columnToDistribute").toString());
            Option option = JDBCUtils$.stringPartitionFuncTpl$1(stringPartitionFuncTpl$lzy$1, jdbcSchema$5, jdbcUrl$1);
            if (option instanceof Some) {
                Some some = (Some)option;
                String tpl = (String)some.value();
                String stringPartitionFunc = Utils$.MODULE$.parseJinjaTpl(tpl, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col"), (Object)quotedPartitionColumn$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nb_partitions"), (Object)Integer.toString(numPartitions$1))}))), settings$4);
                Tuple2 tuple29 = bounds$1;
                if (tuple29 == null) {
                    throw new MatchError((Object)tuple29);
                }
                long lower = tuple29._1$mcJ$sp();
                long upper = tuple29._2$mcJ$sp();
                Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(lower, upper);
                long lower6 = sp3._1$mcJ$sp();
                long upper6 = sp3._2$mcJ$sp();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCUtils$.sql$4(stringPartitionFunc, boundaries$1, index$1, cols$1, colNameQuoteData$1, jdbcSchema$5, tableName$2)), (Function1 & Serializable & scala.Serializable)st -> {
                    JDBCUtils$.$anonfun$extractData$52(upper6, boundaries$1, index$1, lower6, st);
                    return BoxedUnit.UNIT;
                });
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new RuntimeException("Should never happen since stringPartitionFuncTpl is always defined here");
            }
        }
        Tuple2 tuple210 = tuple2;
        if (tuple210 == null) {
            throw new MatchError((Object)tuple210);
        }
        String effectiveSql = (String)tuple210._1();
        Function1 statementFiller = (Function1)tuple210._2();
        Tuple2 tuple211 = new Tuple2((Object)effectiveSql, (Object)statementFiller);
        String effectiveSql2 = (String)tuple211._1();
        Function1 statementFiller2 = (Function1)tuple211._2();
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("{} SQL: {}", new Object[]{boundaryContext$1, effectiveSql2});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long partitionStart = System.currentTimeMillis();
        connection2.setAutoCommit(false);
        PreparedStatement statement = connection2.prepareStatement(effectiveSql2);
        statementFiller2.apply((Object)statement);
        fetchSize$1.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fetchSize -> statement.setFetchSize(fetchSize));
        long count = MODULE$.extractPartitionToFile(boundaryContext$1, limit$1, separator$1, outputDir$1, tableName$2, dateTime$1, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)index$1)), statement, datePattern$1, timestampPattern$1);
        long currentTableCount = ((AtomicLong)tableCount$1.elem).addAndGet(count);
        int lineLength = 100;
        int progressPercent = boundaries$1.count() == 0L ? lineLength : (int)(currentTableCount * (long)lineLength / boundaries$1.count());
        String progressPercentFilled = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), progressPercent).map((Function1 & Serializable & scala.Serializable)x$35 -> JDBCUtils$.$anonfun$extractData$54(BoxesRunTime.unboxToInt((Object)x$35)), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
        String progressPercentUnfilled = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(progressPercent), lineLength).map((Function1 & Serializable & scala.Serializable)x$36 -> JDBCUtils$.$anonfun$extractData$55(BoxesRunTime.unboxToInt((Object)x$36)), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
        String progressBar = new java.lang.StringBuilder(5).append("[").append(progressPercentFilled).append(progressPercentUnfilled).append("] ").append(progressPercent).append(" %").toString();
        long partitionEnd = System.currentTimeMillis();
        String elapsedTime = Utils$.MODULE$.toHumanElapsedTimeFrom(tableStart$1);
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("{} {}. Elapsed time: {}", new Object[]{context$1, progressBar, elapsedTime});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        DeltaRow deltaRow = new DeltaRow(jdbcSchema$5.schema(), tableName$2, boundaries$1.max(), new Timestamp(partitionStart), new Timestamp(partitionEnd), (int)(partitionEnd - partitionStart), jdbcSchema$5.writeMode().toString(), count, true, partitionColumn$1, Integer.toString(index$1));
        return BoxesRunTime.unboxToInt(MODULE$.withJDBCConnection((scala.collection.immutable.Map<String, String>)auditConnectionOptions$1, (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)LastExportUtils$.MODULE$.insertNewLastExport(connection, deltaRow, (Option<PrimitiveType>)new Some((Object)partitionColumnType$1), colNameQuoteAudit$1, colNameQuoteAudit$1, settings$4)), settings$4));
    }

    public static final /* synthetic */ int $anonfun$extractData$46(String context$1, char colNameQuoteData$1, String partitionColumn$1, LastExportUtils.Bounds boundaries$1, scala.collection.immutable.Map connectionOptions$4, PrimitiveType partitionColumnType$1, int numPartitions$1, Settings settings$4, Option fetchSize$1, int limit$1, char separator$1, File outputDir$1, String tableName$2, String dateTime$1, String datePattern$1, String timestampPattern$1, ObjectRef tableCount$1, long tableStart$1, JDBCSchema jdbcSchema$5, scala.collection.immutable.Map auditConnectionOptions$1, char colNameQuoteAudit$1, String cols$1, LazyRef stringPartitionFuncTpl$lzy$1, String jdbcUrl$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            Tuple2 bounds = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String boundaryContext = new java.lang.StringBuilder(2).append(context$1).append("[").append(index).append("]").toString();
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("{} (lower, upper) bounds = {}", new Object[]{boundaryContext, bounds});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String quotedPartitionColumn = new java.lang.StringBuilder(0).append(colNameQuoteData$1).append(partitionColumn$1).append(colNameQuoteData$1).toString();
            return BoxesRunTime.unboxToInt(MODULE$.withJDBCConnection((scala.collection.immutable.Map<String, String>)connectionOptions$4, (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)JDBCUtils$.$anonfun$extractData$47(partitionColumnType$1, bounds, boundaries$1, index, quotedPartitionColumn, numPartitions$1, settings$4, boundaryContext, fetchSize$1, limit$1, separator$1, outputDir$1, tableName$2, dateTime$1, datePattern$1, timestampPattern$1, tableCount$1, tableStart$1, context$1, jdbcSchema$5, partitionColumn$1, auditConnectionOptions$1, colNameQuoteAudit$1, cols$1, colNameQuoteData$1, stringPartitionFuncTpl$lzy$1, jdbcUrl$1, connection)), settings$4));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$extractData$58(ForkJoinTaskSupport x$37) {
        x$37.forkJoinPool().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$getStringPartitionFunc$1(String jdbcUrl$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String dbType = (String)tuple2._1();
            return jdbcUrl$2.contains(dbType);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$extractPartitionToFile$1(String tableName$3, String dateTime$2, int index) {
        return new java.lang.StringBuilder(6).append(tableName$3).append("-").append(dateTime$2).append("-").append(index).append(".csv").toString();
    }

    public static final /* synthetic */ void $anonfun$extractPartitionToFile$3(SLResultSetHelperService resultService$1, ResultSet rs$1, long extractionStartMs$1, LongRef count$1, String context$2, CSVWriter csvWriter) {
        csvWriter.setResultService((ResultSetHelper)resultService$1);
        csvWriter.writeNext(resultService$1.getColumnNames(rs$1));
        int heartBeatMs = 30000;
        long lastHeartBeat = extractionStartMs$1;
        while (rs$1.next()) {
            BoxedUnit boxedUnit;
            ++count$1.elem;
            csvWriter.writeNext(resultService$1.getColumnValues(rs$1));
            if (System.currentTimeMillis() - lastHeartBeat > (long)heartBeatMs) {
                lastHeartBeat = System.currentTimeMillis();
                String elapsedTime = Utils$.MODULE$.toHumanElapsedTimeFrom(extractionStartMs$1);
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("{} Extraction in progress. Already extracted {} rows in {}", new Object[]{context$2, BoxesRunTime.boxToLong((long)count$1.elem), elapsedTime});
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private JDBCUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.sqlTypes = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BIT"), (Object)BoxesRunTime.boxToInteger((int)-7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TINYINT"), (Object)BoxesRunTime.boxToInteger((int)-6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SMALLINT"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INTEGER"), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BIGINT"), (Object)BoxesRunTime.boxToInteger((int)-5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FLOAT"), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"REAL"), (Object)BoxesRunTime.boxToInteger((int)7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DOUBLE"), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NUMERIC"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DECIMAL"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CHAR"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"VARCHAR"), (Object)BoxesRunTime.boxToInteger((int)12)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LONGVARCHAR"), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DATE"), (Object)BoxesRunTime.boxToInteger((int)91)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIME"), (Object)BoxesRunTime.boxToInteger((int)92)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIMESTAMP"), (Object)BoxesRunTime.boxToInteger((int)93)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BINARY"), (Object)BoxesRunTime.boxToInteger((int)-2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"VARBINARY"), (Object)BoxesRunTime.boxToInteger((int)-3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LONGVARBINARY"), (Object)BoxesRunTime.boxToInteger((int)-4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NULL"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"OTHER"), (Object)BoxesRunTime.boxToInteger((int)1111)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BOOLEAN"), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NVARCHAR"), (Object)BoxesRunTime.boxToInteger((int)-9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NCHAR"), (Object)BoxesRunTime.boxToInteger((int)-15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LONGNVARCHAR"), (Object)BoxesRunTime.boxToInteger((int)-16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIME_WITH_TIMEZONE"), (Object)BoxesRunTime.boxToInteger((int)2013)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TIMESTAMP_WITH_TIMEZONE"), (Object)BoxesRunTime.boxToInteger((int)2014))}));
        this.reverseSqlTypes = (scala.collection.immutable.Map)this.sqlTypes().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }
}

