/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.Settings;
import ai.starlake.extract.DeltaRow;
import ai.starlake.extract.LastExportUtils;
import ai.starlake.schema.model.PrimitiveType;
import ai.starlake.schema.model.PrimitiveType$date$;
import ai.starlake.schema.model.PrimitiveType$decimal$;
import ai.starlake.schema.model.PrimitiveType$int$;
import ai.starlake.schema.model.PrimitiveType$long$;
import ai.starlake.schema.model.PrimitiveType$short$;
import ai.starlake.schema.model.PrimitiveType$string$;
import ai.starlake.schema.model.PrimitiveType$timestamp$;
import ai.starlake.utils.Utils$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

public final class LastExportUtils$
implements LazyLogging {
    public static LastExportUtils$ MODULE$;
    private final Timestamp MIN_TS;
    private final Date MIN_DATE;
    private final BigDecimal MIN_DECIMAL;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new LastExportUtils$();
    }

    private Logger logger$lzycompute() {
        LastExportUtils$ lastExportUtils$ = this;
        synchronized (lastExportUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Timestamp MIN_TS() {
        return this.MIN_TS;
    }

    private Date MIN_DATE() {
        return this.MIN_DATE;
    }

    private BigDecimal MIN_DECIMAL() {
        return this.MIN_DECIMAL;
    }

    public LastExportUtils.Bounds getBoundaries(Connection conn, Connection auditConnection, String domain, String table, String partitionColumn, PrimitiveType partitionColumnType, int nbPartitions, char colNameDataQuote, char colNameAuditQuote, Function0<Option<String>> stringPartitionFuncTpl, boolean fullExport, Settings settings) {
        Range partitionRange = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nbPartitions);
        boolean bl = false;
        PrimitiveType primitiveType = null;
        PrimitiveType primitiveType2 = partitionColumnType;
        if (((Object)PrimitiveType$long$.MODULE$).equals(primitiveType2) ? true : (((Object)PrimitiveType$short$.MODULE$).equals(primitiveType2) ? true : ((Object)PrimitiveType$int$.MODULE$).equals(primitiveType2))) {
            Option lastExport = this.lastExportValue(auditConnection, domain, table, "last_long", colNameAuditQuote, fullExport, (Function1 & Serializable & scala.Serializable)rs -> {
                if (rs.next()) {
                    long res = rs.getLong(1);
                    if (res == 0L) {
                        return None$.MODULE$;
                    }
                    return new Some((Object)BoxesRunTime.boxToLong((long)res));
                }
                return None$.MODULE$;
            }, settings);
            return (LastExportUtils.Bounds)this.internalBoundaries(conn, domain, table, partitionColumn, colNameDataQuote, (Option<String>)None$.MODULE$, (Function1 & Serializable & scala.Serializable)statement -> {
                statement.setLong(1, BoxesRunTime.unboxToLong((Object)lastExport.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MIN_VALUE)));
                return (LastExportUtils.Bounds)MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                    Tuple2.mcJJ.sp sp2;
                    Tuple2.mcJJ.sp sp3;
                    rs.next();
                    long count = rs.getLong(1);
                    PrimitiveType primitiveType = partitionColumnType;
                    PrimitiveType$long$ primitiveType$long$ = PrimitiveType$long$.MODULE$;
                    if (!(primitiveType != null ? !((Object)primitiveType).equals(primitiveType$long$) : primitiveType$long$ != null)) {
                        sp3 = new Tuple2.mcJJ.sp(rs.getLong(2), rs.getLong(3));
                    } else {
                        PrimitiveType primitiveType2 = partitionColumnType;
                        PrimitiveType$int$ primitiveType$int$ = PrimitiveType$int$.MODULE$;
                        sp3 = !(primitiveType2 != null ? !((Object)primitiveType2).equals(primitiveType$int$) : primitiveType$int$ != null) ? new Tuple2.mcJJ.sp((long)rs.getInt(2), (long)rs.getInt(3)) : (sp2 = new Tuple2.mcJJ.sp((long)rs.getShort(2), (long)rs.getShort(3)));
                    }
                    if (sp2 == null) {
                        throw new MatchError((Object)sp2);
                    }
                    long min = sp2._1$mcJ$sp();
                    long max = sp2._2$mcJ$sp();
                    Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(min, max);
                    long min2 = sp4._1$mcJ$sp();
                    long max2 = sp4._2$mcJ$sp();
                    long interval = (max2 - min2) / (long)nbPartitions;
                    Tuple2[] intervals = (Tuple2[])((TraversableOnce)partitionRange.map((Function1 & Serializable & scala.Serializable)index -> LastExportUtils$.$anonfun$getBoundaries$5(nbPartitions, max2, min2, interval, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                    return new LastExportUtils.Bounds(lastExport.isEmpty(), PrimitiveType$long$.MODULE$, count, BoxesRunTime.boxToLong((long)min2), BoxesRunTime.boxToLong((long)max2), intervals);
                });
            });
        }
        if (((Object)PrimitiveType$decimal$.MODULE$).equals(primitiveType2)) {
            Option lastExport = this.lastExportValue(auditConnection, domain, table, "last_decimal", colNameAuditQuote, fullExport, (Function1 & Serializable & scala.Serializable)rs -> {
                if (rs.next()) {
                    return new Some((Object)rs.getBigDecimal(1));
                }
                return None$.MODULE$;
            }, settings);
            return (LastExportUtils.Bounds)this.internalBoundaries(conn, domain, table, partitionColumn, colNameDataQuote, (Option<String>)None$.MODULE$, (Function1 & Serializable & scala.Serializable)statement -> {
                statement.setBigDecimal(1, (BigDecimal)lastExport.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DECIMAL()));
                return (LastExportUtils.Bounds)MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                    rs.next();
                    long count = rs.getLong(1);
                    BigDecimal min = (BigDecimal)Option$.MODULE$.apply((Object)rs.getBigDecimal(2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DECIMAL());
                    BigDecimal max = (BigDecimal)Option$.MODULE$.apply((Object)rs.getBigDecimal(3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DECIMAL());
                    BigDecimal interval = max.subtract(min).divide(new BigDecimal(nbPartitions));
                    Tuple2[] intervals = (Tuple2[])((TraversableOnce)partitionRange.map((Function1 & Serializable & scala.Serializable)index -> LastExportUtils$.$anonfun$getBoundaries$12(nbPartitions, max, min, interval, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                    return new LastExportUtils.Bounds(lastExport.isEmpty(), PrimitiveType$decimal$.MODULE$, count, min, max, intervals);
                });
            });
        }
        if (((Object)PrimitiveType$date$.MODULE$).equals(primitiveType2)) {
            Option lastExport = this.lastExportValue(auditConnection, domain, table, "last_date", colNameAuditQuote, fullExport, (Function1 & Serializable & scala.Serializable)rs -> {
                if (rs.next()) {
                    return new Some((Object)rs.getDate(1));
                }
                return None$.MODULE$;
            }, settings);
            return (LastExportUtils.Bounds)this.internalBoundaries(conn, domain, table, partitionColumn, colNameDataQuote, (Option<String>)None$.MODULE$, (Function1 & Serializable & scala.Serializable)statement -> {
                statement.setDate(1, (Date)lastExport.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DATE()));
                return (LastExportUtils.Bounds)MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                    rs.next();
                    long count = rs.getLong(1);
                    Date min = (Date)Option$.MODULE$.apply((Object)rs.getDate(2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DATE());
                    Date max = (Date)Option$.MODULE$.apply((Object)rs.getDate(3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DATE());
                    long interval = (max.getTime() - min.getTime()) / (long)nbPartitions;
                    Tuple2[] intervals = (Tuple2[])((TraversableOnce)partitionRange.map((Function1 & Serializable & scala.Serializable)index -> LastExportUtils$.$anonfun$getBoundaries$19(nbPartitions, max, min, interval, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                    return new LastExportUtils.Bounds(lastExport.isEmpty(), PrimitiveType$date$.MODULE$, count, min, max, intervals);
                });
            });
        }
        if (((Object)PrimitiveType$timestamp$.MODULE$).equals(primitiveType2)) {
            Option lastExport = this.lastExportValue(auditConnection, domain, table, "last_ts", colNameAuditQuote, fullExport, (Function1 & Serializable & scala.Serializable)rs -> {
                if (rs.next()) {
                    return new Some((Object)rs.getTimestamp(1));
                }
                return None$.MODULE$;
            }, settings);
            return (LastExportUtils.Bounds)this.internalBoundaries(conn, domain, table, partitionColumn, colNameDataQuote, (Option<String>)None$.MODULE$, (Function1 & Serializable & scala.Serializable)statement -> {
                statement.setTimestamp(1, (Timestamp)lastExport.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_TS()));
                return (LastExportUtils.Bounds)MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                    rs.next();
                    long count = rs.getLong(1);
                    Timestamp min = (Timestamp)Option$.MODULE$.apply((Object)rs.getTimestamp(2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_TS());
                    Timestamp max = (Timestamp)Option$.MODULE$.apply((Object)rs.getTimestamp(3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_TS());
                    long interval = (max.getTime() - min.getTime()) / (long)nbPartitions;
                    Tuple2[] intervals = (Tuple2[])((TraversableOnce)partitionRange.map((Function1 & Serializable & scala.Serializable)index -> LastExportUtils$.$anonfun$getBoundaries$26(nbPartitions, max, min, interval, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                    return new LastExportUtils.Bounds(lastExport.isEmpty(), PrimitiveType$timestamp$.MODULE$, count, min, max, intervals);
                });
            });
        }
        if (((Object)PrimitiveType$string$.MODULE$).equals(primitiveType2)) {
            bl = true;
            primitiveType = primitiveType2;
            if (((Option)stringPartitionFuncTpl.apply()).isDefined()) {
                BoxedUnit boxedUnit;
                if (!fullExport) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Delta fetching is not compatible with partition on string. Going to extract fully in parallel. To disable this warning please set fullExport in the table definition.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option stringPartitionFunc = ((Option)stringPartitionFuncTpl.apply()).map((Function1 & Serializable & scala.Serializable)x$39 -> Utils$.MODULE$.parseJinjaTpl((String)x$39, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col"), (Object)new StringBuilder(0).append(colNameDataQuote).append(partitionColumn).append(colNameDataQuote).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nb_partitions"), (Object)Integer.toString(nbPartitions))}))), settings));
                return (LastExportUtils.Bounds)this.internalBoundaries(conn, domain, table, partitionColumn, colNameDataQuote, (Option<String>)stringPartitionFunc, (Function1 & Serializable & scala.Serializable)statement -> {
                    statement.setLong(1, Long.MIN_VALUE);
                    return (LastExportUtils.Bounds)MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                        rs.next();
                        long count = rs.getLong(1);
                        long min = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)rs.getLong(2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                        long max = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)rs.getLong(3))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                        long l = count;
                        if (0L == l) {
                            return new LastExportUtils.Bounds(true, PrimitiveType$long$.MODULE$, count, BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
                        }
                        Tuple2[] partitions = (Tuple2[])((TraversableOnce)new RichLong(Predef$.MODULE$.longWrapper(min)).until((Object)BoxesRunTime.boxToLong((long)max)).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)p))), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)p) + 1L))), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                        return new LastExportUtils.Bounds(true, PrimitiveType$long$.MODULE$, count, BoxesRunTime.boxToLong((long)min), BoxesRunTime.boxToLong((long)max), partitions);
                    });
                });
            }
        }
        if (bl && ((Option)stringPartitionFuncTpl.apply()).isEmpty()) {
            throw new Exception(new StringBuilder(226).append("Unsupported type ").append(partitionColumnType).append(" for column partition column ").append(partitionColumn).append(" in table ").append(domain).append(".").append(table).append(". You may define your own hash to int function via stringPartitionFunc in jdbcSchema in order to support parallel fetch. Eg: abs( hashtext({{col}}) % {{nb_partitions}} )").toString());
        }
        throw new Exception(new StringBuilder(57).append("Unsupported type ").append(partitionColumnType).append(" for column partition column ").append(partitionColumn).append(" in table ").append(domain).append(".").append(table).toString());
    }

    private <T> Option<T> lastExportValue(Connection conn, String domain, String table, String columnName, char colQuote, boolean fullExport, Function1<ResultSet, Option<T>> apply, Settings settings) {
        String auditSchema = (String)settings.comet().audit().sink().name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit");
        if (fullExport) {
            return None$.MODULE$;
        }
        String SQL_LAST_EXPORT_VALUE = new StringBuilder(71).append("select max(").append(colQuote).append(columnName).append(colQuote).append(") from ").append(auditSchema).append(".SL_LAST_EXPORT where ").append(colQuote).append("domain").append(colQuote).append(" like ? and ").append(colQuote).append("schema").append(colQuote).append(" like ?").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(SQL_LAST_EXPORT_VALUE);
        preparedStatement.setString(1, domain);
        preparedStatement.setString(2, table);
        return this.executeQuery(preparedStatement, apply);
    }

    private <T> T internalBoundaries(Connection conn, String domain, String table, String partitionColumn, char colQuote, Option<String> hashFunc, Function1<PreparedStatement, T> apply) {
        String quotedColumn = new StringBuilder(0).append(colQuote).append(partitionColumn).append(colQuote).toString();
        String columnToDistribute = (String)hashFunc.getOrElse((Function0 & Serializable & scala.Serializable)() -> quotedColumn);
        String SQL_BOUNDARIES_VALUES = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("select count(").append(quotedColumn).append(") as count_value, min(").append(columnToDistribute).append(") as min_value, max(").append(columnToDistribute).append(") as max_value\n           |from ").append(colQuote).append(domain).append(colQuote).append(".").append(colQuote).append(table).append(colQuote).append("\n           |where ").append(columnToDistribute).append(" > ?").toString())).stripMargin();
        PreparedStatement preparedStatement = conn.prepareStatement(SQL_BOUNDARIES_VALUES);
        return (T)apply.apply((Object)preparedStatement);
    }

    public Option<Timestamp> getLastAllExport(Connection conn, String domain, String schema, char colNameQuote, Settings settings) {
        BoxedUnit boxedUnit;
        String auditSchema = (String)settings.comet().audit().sink().name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit");
        String lastExtractionSQL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n         |select max(").append(colNameQuote).append("start_ts").append(colNameQuote).append(")\n         |  from ").append(auditSchema).append(".SL_LAST_EXPORT\n         |where\n         |  ").append(colNameQuote).append("domain").append(colNameQuote).append(" = ?\n         |  and ").append(colNameQuote).append("schema").append(colNameQuote).append(" = ?").toString())).stripMargin();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(lastExtractionSQL);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        PreparedStatement preparedStatement = conn.prepareStatement(lastExtractionSQL);
        preparedStatement.setString(1, domain);
        preparedStatement.setString(2, schema);
        ResultSet rs = preparedStatement.executeQuery();
        if (rs.next()) {
            return Option$.MODULE$.apply((Object)rs.getTimestamp(1));
        }
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertNewLastExport(Connection conn, DeltaRow row, Option<PrimitiveType> partitionColumnType, char colStart, char colEnd, Settings settings) {
        String string;
        Some some;
        PrimitiveType primitiveType;
        conn.setAutoCommit(true);
        String cols = ((TraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"domain", "schema", "start_ts", "end_ts", "duration", "mode", "count", "success", "message", "step"})).map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(0).append(colStart).append((String)col).append(colEnd).toString(), List$.MODULE$.canBuildFrom())).mkString(",");
        String auditSchema = (String)settings.comet().audit().sink().name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit");
        String fullReport = new StringBuilder(66).append("insert into ").append(auditSchema).append(".SL_LAST_EXPORT(").append(cols).append(") values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)").toString();
        Option<PrimitiveType> option = partitionColumnType;
        if (None$.MODULE$.equals(option) ? true : option instanceof Some && ((Object)PrimitiveType$string$.MODULE$).equals(primitiveType = (PrimitiveType)(some = (Some)option).value())) {
            string = fullReport;
        } else {
            String string2;
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some2 = (Some)option;
            PrimitiveType partitionColumnType2 = (PrimitiveType)some2.value();
            PrimitiveType primitiveType2 = partitionColumnType2;
            if (((Object)PrimitiveType$int$.MODULE$).equals(primitiveType2) ? true : (((Object)PrimitiveType$long$.MODULE$).equals(primitiveType2) ? true : ((Object)PrimitiveType$short$.MODULE$).equals(primitiveType2))) {
                string2 = "last_long";
            } else if (((Object)PrimitiveType$decimal$.MODULE$).equals(primitiveType2)) {
                string2 = "last_decimal";
            } else if (((Object)PrimitiveType$date$.MODULE$).equals(primitiveType2)) {
                string2 = "last_date";
            } else {
                if (!((Object)PrimitiveType$timestamp$.MODULE$).equals(primitiveType2)) throw new Exception(new StringBuilder(52).append("type ").append(partitionColumnType2).append(" not supported for partition columnToDistribute").toString());
                string2 = "last_ts";
            }
            String lastExportColumn = string2;
            String auditSchema2 = (String)settings.comet().audit().sink().name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit");
            string = new StringBuilder(71).append("insert into ").append(auditSchema2).append(".SL_LAST_EXPORT(").append(cols).append(", ").append(colStart).append(lastExportColumn).append(colEnd).append(") values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)").toString();
        }
        String sqlInsert = string;
        PreparedStatement preparedStatement = conn.prepareStatement(sqlInsert);
        preparedStatement.setString(1, row.domain());
        preparedStatement.setString(2, row.schema());
        preparedStatement.setTimestamp(3, row.start());
        preparedStatement.setTimestamp(4, row.end());
        preparedStatement.setInt(5, row.duration());
        preparedStatement.setString(6, row.mode());
        preparedStatement.setLong(7, row.count());
        preparedStatement.setBoolean(8, row.success());
        preparedStatement.setString(9, row.message());
        preparedStatement.setString(10, row.step());
        Option<PrimitiveType> option2 = partitionColumnType;
        if (None$.MODULE$.equals(option2)) {
            return preparedStatement.executeUpdate();
        } else {
            if (!(option2 instanceof Some)) throw new MatchError(option2);
            Some some3 = (Some)option2;
            PrimitiveType partitionColumnType3 = (PrimitiveType)some3.value();
            PrimitiveType primitiveType3 = partitionColumnType3;
            if (((Object)PrimitiveType$int$.MODULE$).equals(primitiveType3) ? true : (((Object)PrimitiveType$long$.MODULE$).equals(primitiveType3) ? true : ((Object)PrimitiveType$short$.MODULE$).equals(primitiveType3))) {
                preparedStatement.setLong(11, BoxesRunTime.unboxToLong((Object)row.lastExport()));
                return preparedStatement.executeUpdate();
            } else if (((Object)PrimitiveType$decimal$.MODULE$).equals(primitiveType3)) {
                preparedStatement.setBigDecimal(11, (BigDecimal)row.lastExport());
                return preparedStatement.executeUpdate();
            } else if (((Object)PrimitiveType$date$.MODULE$).equals(primitiveType3)) {
                preparedStatement.setDate(11, (Date)row.lastExport());
                return preparedStatement.executeUpdate();
            } else if (((Object)PrimitiveType$timestamp$.MODULE$).equals(primitiveType3)) {
                preparedStatement.setTimestamp(11, (Timestamp)row.lastExport());
                return preparedStatement.executeUpdate();
            } else if (!((Object)PrimitiveType$string$.MODULE$).equals(primitiveType3)) throw new Exception(new StringBuilder(52).append("type ").append(partitionColumnType3).append(" not supported for partition columnToDistribute").toString());
        }
        return preparedStatement.executeUpdate();
    }

    private <T> T executeQuery(PreparedStatement stmt, Function1<ResultSet, T> apply) {
        ResultSet rs = stmt.executeQuery();
        Object result = apply.apply((Object)rs);
        rs.close();
        stmt.close();
        return (T)result;
    }

    public Try<Object> executeUpdate(PreparedStatement stmt) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            int count = stmt.executeUpdate();
            stmt.close();
            return count;
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$getBoundaries$5(int nbPartitions$1, long max$1, long min$1, long interval$1, int index) {
        long upper = index == nbPartitions$1 - 1 ? max$1 : min$1 + interval$1 * (long)(index + 1);
        return new Tuple2.mcJJ.sp(min$1 + interval$1 * (long)index, upper);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getBoundaries$12(int nbPartitions$1, BigDecimal max$2, BigDecimal min$2, BigDecimal interval$2, int index) {
        BigDecimal upper = index == nbPartitions$1 - 1 ? max$2 : min$2.add(interval$2.multiply(new BigDecimal(index + 1)));
        return new Tuple2((Object)min$2.add(interval$2.multiply(new BigDecimal(index))), (Object)upper);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getBoundaries$19(int nbPartitions$1, Date max$3, Date min$3, long interval$3, int index) {
        Date upper = index == nbPartitions$1 - 1 ? max$3 : new Date(min$3.getTime() + interval$3 * (long)(index + 1));
        return new Tuple2((Object)new Date(min$3.getTime() + interval$3 * (long)index), (Object)upper);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getBoundaries$26(int nbPartitions$1, Timestamp max$4, Timestamp min$4, long interval$4, int index) {
        Timestamp upper = index == nbPartitions$1 - 1 ? max$4 : new Timestamp(min$4.getTime() + interval$4 * (long)(index + 1));
        return new Tuple2((Object)new Timestamp(min$4.getTime() + interval$4 * (long)index), (Object)upper);
    }

    private LastExportUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.MIN_TS = Timestamp.valueOf("1970-01-01 00:00:00");
        this.MIN_DATE = Date.valueOf("1970-01-01");
        this.MIN_DECIMAL = BigDecimal.ZERO;
    }
}

