/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.infer;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.config.SparkEnv$;
import ai.starlake.schema.handlers.InferSchemaHandler$;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.DagGenerationConfig;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Format$;
import ai.starlake.schema.model.Format$DSV$;
import ai.starlake.schema.model.Format$POSITION$;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.Mode;
import ai.starlake.schema.model.Partition;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.PrivacyLevel;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.WriteMode;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\b\u0011\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006Y!\t\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006[\u0001!\tA\f\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019y\u0004\u0001)A\u0005y!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002(\u0001A\u0003%!\tC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003_\u0001\u0011\u0005q\fC\u0003l\u0001\u0011\u0005A\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0003w\u0001\u0011%q\u000fC\u0003z\u0001\u0011%!\u0010\u0003\u0004\u0012\u0001\u0011\u0005\u00111\u0004\u0002\u000f\u0013:4WM]*dQ\u0016l\u0017MS8c\u0015\t\t\"#A\u0003j]\u001a,'O\u0003\u0002\u0014)\u0005\u0019!n\u001c2\u000b\u0005U1\u0012\u0001C:uCJd\u0017m[3\u000b\u0003]\t!!Y5\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002\u0011M,G\u000f^5oON\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\u000b\u0002\r\r|gNZ5h\u0013\t13E\u0001\u0005TKR$\u0018N\\4t\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0006\u0002+YA\u00111\u0006A\u0007\u0002!!)\u0001E\u0001a\u0002C\u0005!a.Y7f+\u0005y\u0003C\u0001\u00198\u001d\t\tT\u0007\u0005\u0002395\t1G\u0003\u000251\u00051AH]8pizJ!A\u000e\u000f\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003mq\t\u0001b\u001d9be.,eN^\u000b\u0002yA\u0011!%P\u0005\u0003}\r\u0012\u0001b\u00159be.,eN^\u0001\ngB\f'o[#om\u0002\nqa]3tg&|g.F\u0001C!\t\u0019E*D\u0001E\u0015\t)e)A\u0002tc2T!a\u0012%\u0002\u000bM\u0004\u0018M]6\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'oZ\u0005\u0003\u001b\u0012\u0013Ab\u00159be.\u001cVm]:j_:\f\u0001b]3tg&|g\u000eI\u0001\te\u0016\fGMR5mKR\u0011\u0011\u000b\u0016\t\u0004\u0007J{\u0013BA*E\u0005\u001d!\u0015\r^1tKRDQ!\u0016\u0005A\u0002Y\u000bA\u0001]1uQB\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0003MNT!a\u0017%\u0002\r!\fGm\\8q\u0013\ti\u0006L\u0001\u0003QCRD\u0017!D4fi\u001a{'/\\1u\r&dW\r\u0006\u00020A\")\u0011-\u0003a\u0001E\u0006)A.\u001b8fgB\u00191\r[\u0018\u000f\u0005\u00114gB\u0001\u001af\u0013\u0005i\u0012BA4\u001d\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001b6\u0003\t1K7\u000f\u001e\u0006\u0003Or\tAbZ3u'\u0016\u0004\u0018M]1u_J$2aL7o\u0011\u0015\t'\u00021\u0001c\u0011\u0015y'\u00021\u0001q\u0003)9\u0018\u000e\u001e5IK\u0006$WM\u001d\t\u00037EL!A\u001d\u000f\u0003\u000f\t{w\u000e\\3b]\u00061r-\u001a;E_6\f\u0017N\u001c#je\u0016\u001cGo\u001c:z\u001d\u0006lW\r\u0006\u00020k\")Qk\u0003a\u0001-\u0006\u0001r-\u001a;TG\",W.\u0019)biR,'O\u001c\u000b\u0003_aDQ!\u0016\u0007A\u0002Y\u000b\u0011d\u0019:fCR,G)\u0019;b\rJ\fW.Z,ji\"4uN]7biR910a\u0005\u0002\u0016\u0005e\u0001c\u0001?\u0002\u000e9\u0019Q0a\u0003\u000f\u0007y\fIAD\u0002\u0000\u0003\u000fqA!!\u0001\u0002\u00069\u0019!'a\u0001\n\u0003-K!!\u0013&\n\u0005\u001dC\u0015BA#G\u0013\t9G)\u0003\u0003\u0002\u0010\u0005E!!\u0003#bi\u00064%/Y7f\u0015\t9G\tC\u0003b\u001b\u0001\u0007!\r\u0003\u0004\u0002\u00185\u0001\raL\u0001\tI\u0006$\u0018\rU1uQ\")q.\u0004a\u0001aRq\u0011QDA\u0018\u0003g\t9$!\u000f\u0002>\u0005}\u0002CBA\u0010\u0003K\tI#\u0004\u0002\u0002\")\u0019\u00111\u0005\u000f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003O\t\tCA\u0002Uef\u00042aGA\u0016\u0013\r\ti\u0003\b\u0002\u0005+:LG\u000f\u0003\u0004\u000229\u0001\raL\u0001\u000bI>l\u0017-\u001b8OC6,\u0007BBA\u001b\u001d\u0001\u0007q&\u0001\u0006tG\",W.\u0019(b[\u0016Da!a\u0006\u000f\u0001\u0004y\u0003BBA\u001e\u001d\u0001\u0007q&A\u0004tCZ,G)\u001b:\t\u000b=t\u0001\u0019\u00019\t\u000f\u0005\u0005c\u00021\u0001\u0002D\u0005Yam\u001c:dK\u001a{'/\\1u!\u0015Y\u0012QIA%\u0013\r\t9\u0005\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005)Qn\u001c3fY*\u0019\u00111\u000b\u000b\u0002\rM\u001c\u0007.Z7b\u0013\u0011\t9&!\u0014\u0003\r\u0019{'/\\1u\u0001")
public class InferSchemaJob {
    private final Settings settings;
    private final SparkEnv sparkEnv;
    private final SparkSession session;

    public String name() {
        return "InferSchema";
    }

    private SparkEnv sparkEnv() {
        return this.sparkEnv;
    }

    private SparkSession session() {
        return this.session;
    }

    public Dataset<String> readFile(Path path) {
        return this.session().read().textFile(path.toString());
    }

    public String getFormatFile(List<String> lines) {
        String firstLine = (String)lines.head();
        String lastLine = (String)lines.last();
        Regex jsonRegexStart = new StringOps(Predef$.MODULE$.augmentString("\\{.*")).r();
        Regex jsonArrayRegexStart = new StringOps(Predef$.MODULE$.augmentString("\\[.*")).r();
        Regex jsonRegexEnd = new StringOps(Predef$.MODULE$.augmentString(".*\\}")).r();
        Regex jsonArrayRegexEnd = new StringOps(Predef$.MODULE$.augmentString(".*\\]")).r();
        Regex xmlRegexStart = new StringOps(Predef$.MODULE$.augmentString("<.*")).r();
        Regex xmlRegexEnd = new StringOps(Predef$.MODULE$.augmentString(".*>")).r();
        Tuple2 tuple2 = new Tuple2((Object)firstLine, (Object)lastLine);
        if (tuple2 != null) {
            Option option;
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            Option option2 = jsonRegexStart.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0 && !(option = jsonRegexEnd.unapplySeq((CharSequence)string2)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                return "JSON";
            }
        }
        if (tuple2 != null) {
            Option option;
            String string = (String)tuple2._1();
            String string3 = (String)tuple2._2();
            Option option3 = jsonArrayRegexStart.unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0 && !(option = jsonArrayRegexEnd.unapplySeq((CharSequence)string3)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                return "ARRAY_JSON";
            }
        }
        if (tuple2 != null) {
            Option option;
            String string = (String)tuple2._1();
            String string4 = (String)tuple2._2();
            Option option4 = xmlRegexStart.unapplySeq((CharSequence)string);
            if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(0) == 0 && !(option = xmlRegexEnd.unapplySeq((CharSequence)string4)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                return "XML";
            }
        }
        return "DSV";
    }

    public String getSeparator(List<String> lines, boolean withHeader) {
        List linesWithoutHeader = withHeader ? lines.drop(1) : lines;
        String firstLine = (String)linesWithoutHeader.head();
        Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(firstLine.replaceAll("[A-Za-z0-9 \"'()@?!\u00e9\u00e8\u00ee\u00e0\u00c0\u00c9\u00c8\u00e7+\\-_]", "").toCharArray())).map((Function1 & Serializable & scala.Serializable)x$1 -> InferSchemaJob.$anonfun$getSeparator$1(BoxesRunTime.unboxToChar((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToCharacter((char)x$2._1$mcC$sp())).mapValues((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)InferSchemaJob.$anonfun$getSeparator$3(x$3))).toList().maxBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)InferSchemaJob.$anonfun$getSeparator$4(x0$1)), (Ordering)Ordering.Int$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        char separator = tuple2._1$mcC$sp();
        int count = tuple2._2$mcI$sp();
        Tuple2.mcCI.sp sp2 = new Tuple2.mcCI.sp(separator, count);
        char separator2 = sp2._1$mcC$sp();
        int count2 = sp2._2$mcI$sp();
        return Character.toString(separator2);
    }

    public String getDomainDirectoryName(Path path) {
        return path.toString().replace(path.getName(), "");
    }

    private String getSchemaPattern(Path path) {
        return path.getName();
    }

    private Dataset<Row> createDataFrameWithFormat(List<String> lines, String dataPath, boolean withHeader) {
        String formatFile = this.getFormatFile(lines);
        String string = formatFile;
        if ("ARRAY_JSON".equals(string)) {
            RDD jsonRDD = this.session().sparkContext().wholeTextFiles(dataPath, this.session().sparkContext().wholeTextFiles$default$2()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String content = (String)tuple2._2();
                    return content;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(String.class));
            return this.session().read().option("inferSchema", true).json(this.session().createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
        }
        if ("JSON".equals(string)) {
            return this.session().read().format("json").option("inferSchema", true).load(dataPath);
        }
        if ("XML".equals(string)) {
            return this.session().read().format("com.databricks.spark.xml").option("inferSchema", true).load(dataPath);
        }
        if ("DSV".equals(string)) {
            return this.session().read().format("com.databricks.spark.csv").option("header", withHeader).option("inferSchema", true).option("delimiter", this.getSeparator(lines, withHeader)).option("parserLib", "UNIVOCITY").load(dataPath);
        }
        throw new MatchError((Object)string);
    }

    public Try<BoxedUnit> infer(String domainName, String schemaName, String dataPath, String saveDir, boolean withHeader, Option<Format> forceFormat) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Schema schema;
            Some some;
            Format format;
            Path path = new Path(dataPath);
            List lines = (List)((TraversableLike)Source$.MODULE$.fromFile(path.toString(), Codec$.MODULE$.fallbackSystemCodec()).getLines().toList().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.trim(), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)InferSchemaJob.$anonfun$infer$3(x$6)));
            Option option = forceFormat;
            if (option instanceof Some && ((Object)Format$POSITION$.MODULE$).equals(format = (Format)(some = (Some)option).value())) {
                IntRef lastIndex = IntRef.create((int)-1);
                List attributes = (List)((List)lines.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        int endPosition;
                        String line = (String)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        int startPosition = lastIndex$1.elem + 1;
                        lastIndex$1.elem = endPosition = startPosition + line.length();
                        String x$1 = new StringBuilder(2).append("_c").append(index).toString();
                        Some x$2 = new Some((Object)new Position(startPosition, endPosition));
                        String x$3 = Attribute$.MODULE$.apply$default$2();
                        Option<Object> x$4 = Attribute$.MODULE$.apply$default$3();
                        boolean x$5 = Attribute$.MODULE$.apply$default$4();
                        PrivacyLevel x$6 = Attribute$.MODULE$.apply$default$5();
                        Option<String> x$7 = Attribute$.MODULE$.apply$default$6();
                        Option<String> x$8 = Attribute$.MODULE$.apply$default$7();
                        Option<MetricType> x$9 = Attribute$.MODULE$.apply$default$8();
                        List<Attribute> x$10 = Attribute$.MODULE$.apply$default$9();
                        Option<String> x$11 = Attribute$.MODULE$.apply$default$11();
                        Set<String> x$12 = Attribute$.MODULE$.apply$default$12();
                        Option<Trim> x$13 = Attribute$.MODULE$.apply$default$13();
                        Option<String> x$14 = Attribute$.MODULE$.apply$default$14();
                        Option<String> x$15 = Attribute$.MODULE$.apply$default$15();
                        Option<Object> x$16 = Attribute$.MODULE$.apply$default$16();
                        Option<String> x$17 = Attribute$.MODULE$.apply$default$17();
                        return new Attribute(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, (Option<Position>)x$2, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
                Metadata metadata = InferSchemaHandler$.MODULE$.createMetaData(Format$POSITION$.MODULE$, InferSchemaHandler$.MODULE$.createMetaData$default$2(), InferSchemaHandler$.MODULE$.createMetaData$default$3(), InferSchemaHandler$.MODULE$.createMetaData$default$4());
                schema = InferSchemaHandler$.MODULE$.createSchema(schemaName, Pattern.compile(this.getSchemaPattern(path)), (List<Attribute>)attributes, (Option<Metadata>)new Some((Object)metadata));
            } else {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Tuple2 tuple23;
                Dataset<Row> dataframeWithFormat = this.createDataFrameWithFormat((List<String>)lines, dataPath, withHeader);
                Option option2 = option;
                if (None$.MODULE$.equals(option2)) {
                    String formatAsStr = this.getFormatFile((List<String>)lines);
                    String string = formatAsStr;
                    String string2 = "ARRAY_JSON";
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    tuple23 = new Tuple2((Object)Format$.MODULE$.fromString(this.getFormatFile((List<String>)lines)), (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                } else if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Format f = (Format)some2.value();
                    tuple23 = new Tuple2((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    throw new MatchError((Object)option2);
                }
                Tuple2 tuple24 = tuple23;
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                Format format2 = (Format)tuple24._1();
                boolean array = tuple24._2$mcZ$sp();
                Tuple2 tuple25 = new Tuple2((Object)format2, (Object)BoxesRunTime.boxToBoolean((boolean)array));
                Format format3 = (Format)tuple25._1();
                boolean array2 = tuple25._2$mcZ$sp();
                Format format4 = format3;
                if (((Object)Format$DSV$.MODULE$).equals(format4)) {
                    String separator = this.getSeparator((List<String>)lines, withHeader);
                    List linesWithoutHeader = withHeader ? lines.drop(1) : lines;
                    tuple22 = new Tuple2(linesWithoutHeader.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.split(Pattern.quote(separator)), List$.MODULE$.canBuildFrom()), (Object)new Some((Object)separator));
                } else {
                    tuple22 = tuple2 = new Tuple2((Object)Nil$.MODULE$, (Object)None$.MODULE$);
                }
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List dataLines = (List)tuple2._1();
                Option separator = (Option)tuple2._2();
                Tuple2 tuple26 = new Tuple2((Object)dataLines, (Object)separator);
                List dataLines2 = (List)tuple26._1();
                Option separator2 = (Option)tuple26._2();
                List<Attribute> attributes = InferSchemaHandler$.MODULE$.createAttributes((List<String[]>)dataLines2, dataframeWithFormat.schema(), format3, $this.settings);
                Metadata metadata = InferSchemaHandler$.MODULE$.createMetaData(format3, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)array2)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)withHeader)), (Option<String>)separator2);
                schema = InferSchemaHandler$.MODULE$.createSchema(schemaName, Pattern.compile(this.getSchemaPattern(path)), attributes, (Option<Metadata>)new Some((Object)metadata));
            }
            Schema schema2 = schema;
            Domain domain = InferSchemaHandler$.MODULE$.createDomain(domainName, (Option<Metadata>)schema2.metadata().map((Function1 & Serializable & scala.Serializable)x$10 -> {
                Some x$18 = new Some((Object)new StringBuilder(23).append("{{root_path}}/incoming/").append(domainName).toString());
                Option<Mode> x$19 = x$10.copy$default$1();
                Option<Format> x$20 = x$10.copy$default$2();
                Option<String> x$21 = x$10.copy$default$3();
                Option<Object> x$22 = x$10.copy$default$4();
                Option<Object> x$23 = x$10.copy$default$5();
                Option<Object> x$24 = x$10.copy$default$6();
                Option<String> x$25 = x$10.copy$default$7();
                Option<String> x$26 = x$10.copy$default$8();
                Option<String> x$27 = x$10.copy$default$9();
                Option<WriteMode> x$28 = x$10.copy$default$10();
                Option<Partition> x$29 = x$10.copy$default$11();
                Option<Sink> x$30 = x$10.copy$default$12();
                Option<String> x$31 = x$10.copy$default$13();
                Option<Seq<String>> x$32 = x$10.copy$default$14();
                Option<Map<String, String>> x$33 = x$10.copy$default$15();
                List<String> x$34 = x$10.copy$default$17();
                Option<String> x$35 = x$10.copy$default$18();
                Option<Map<String, String>> x$36 = x$10.copy$default$19();
                Option<String> x$37 = x$10.copy$default$20();
                Option<Object> x$38 = x$10.copy$default$21();
                Option<DagGenerationConfig> x$39 = x$10.copy$default$22();
                Option<Freshness> x$40 = x$10.copy$default$23();
                Option<String> x$41 = x$10.copy$default$24();
                boolean x$42 = x$10.copy$default$25();
                return x$10.copy(x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, (Option<String>)x$18, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42);
            }), (List<Schema>)new .colon.colon((Object)schema2, (List)Nil$.MODULE$));
            InferSchemaHandler$.MODULE$.generateYaml(domain, saveDir, $this.settings);
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$getSeparator$1(char x$1) {
        return new Tuple2.mcCI.sp(x$1, 1);
    }

    public static final /* synthetic */ int $anonfun$getSeparator$3(Tuple2[] x$3) {
        return x$3.length;
    }

    public static final /* synthetic */ int $anonfun$getSeparator$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int count = tuple2._2$mcI$sp();
            return count;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$infer$3(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public InferSchemaJob(Settings settings) {
        this.settings = settings;
        this.sparkEnv = new SparkEnv(this.name(), SparkEnv$.MODULE$.$lessinit$greater$default$2(), settings);
        this.session = this.sparkEnv().session();
    }
}

