/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.ingest;

import ai.starlake.config.Settings;
import ai.starlake.job.ingest.AuditLog;
import ai.starlake.job.ingest.AuditLog$;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig$;
import ai.starlake.job.sink.bigquery.BigQueryNativeJob;
import ai.starlake.job.sink.jdbc.ConnectionLoadConfig;
import ai.starlake.job.sink.jdbc.ConnectionLoadConfig$;
import ai.starlake.job.sink.jdbc.ConnectionLoadJob;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AttributeDesc;
import ai.starlake.schema.model.BigQuerySink;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.EsSink;
import ai.starlake.schema.model.FsSink;
import ai.starlake.schema.model.JdbcSink;
import ai.starlake.schema.model.NoneSink;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.TableInfo;
import ai.starlake.schema.model.TableInfo$;
import ai.starlake.utils.FileLock;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableId;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;

public final class AuditLog$
implements StrictLogging,
scala.Serializable {
    public static AuditLog$ MODULE$;
    private final List<Tuple3<String, StandardSQLTypeName, AtomicType>> auditCols;
    private final Logger logger;

    static {
        new AuditLog$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<Tuple3<String, StandardSQLTypeName, AtomicType>> auditCols() {
        return this.auditCols;
    }

    private com.google.cloud.bigquery.Schema bqSchema() {
        List fields = (List)this.auditCols().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                String name = (String)tuple3._1();
                StandardSQLTypeName tpe = (StandardSQLTypeName)tuple3._2();
                return Field.newBuilder((String)name, (StandardSQLTypeName)tpe, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("").build();
            }
            throw new MatchError((Object)tuple3);
        }, List$.MODULE$.canBuildFrom());
        return com.google.cloud.bigquery.Schema.of((Field[])((Field[])fields.toArray(ClassTag$.MODULE$.apply(Field.class))));
    }

    public Object sink(Map<String, String> authInfo, Option<SparkSession> sessionOpt, AuditLog log, Settings settings) {
        Sink sink;
        if (settings.comet().sinkToFile()) {
            AuditLog$.sinkToFile$1(log, settings, sessionOpt);
        }
        if ((sink = settings.comet().audit().sink()) instanceof JdbcSink) {
            JdbcSink jdbcSink = (JdbcSink)sink;
            SparkSession session = (SparkSession)sessionOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception("Spark Session required");
            });
            RDD auditTypedRDD = session.sparkContext().parallelize((Seq)new .colon.colon((Object)log, (List)Nil$.MODULE$), session.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(AuditLog.class));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Ai_starlake_job_ingest_AuditLog$$typecreator6$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.starlake.job.ingest.AuditLog").asType().toTypeConstructor();
                }

                public Ai_starlake_job_ingest_AuditLog$$typecreator6$2() {
                }
            }
            Dataset auditDF = session.createDataFrame(session.implicits().rddToDatasetHolder(auditTypedRDD, session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_starlake_job_ingest_AuditLog$$typecreator6$2()))).toDF().rdd(), StructType$.MODULE$.apply((Seq)this.auditCols().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 != null) {
                    String name = (String)tuple3._1();
                    AtomicType sparkType = (AtomicType)tuple3._3();
                    return new StructField(name, (DataType)sparkType, true, StructField$.MODULE$.apply$default$4());
                }
                throw new MatchError((Object)tuple3);
            }, List$.MODULE$.canBuildFrom()))).toDF((Seq)this.auditCols().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 != null) {
                    String name = (String)tuple3._1();
                    return name;
                }
                throw new MatchError((Object)tuple3);
            }, List$.MODULE$.canBuildFrom()));
            String x$1 = jdbcSink.connection();
            Settings.Comet x$2 = settings.comet();
            Right x$3 = package$.MODULE$.Right().apply((Object)auditDF);
            String x$4 = new StringBuilder(6).append((String)settings.comet().audit().sink().name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit")).append(".").append("audit").toString();
            Map<String, String> x$5 = jdbcSink.getOptions();
            JobInfo.CreateDisposition x$6 = ConnectionLoadConfig$.MODULE$.fromComet$default$5();
            JobInfo.WriteDisposition x$7 = ConnectionLoadConfig$.MODULE$.fromComet$default$6();
            boolean x$8 = ConnectionLoadConfig$.MODULE$.fromComet$default$8();
            ConnectionLoadConfig jdbcConfig = ConnectionLoadConfig$.MODULE$.fromComet(x$1, x$2, (Either<String, Dataset<Row>>)x$3, x$4, x$6, x$7, x$5, x$8);
            return new ConnectionLoadJob(jdbcConfig, settings).run();
        }
        if (sink instanceof BigQuerySink) {
            BigQuerySink bigQuerySink = (BigQuerySink)sink;
            Try<Job> res = this.sinToBigQuery(authInfo, log, bigQuerySink, settings);
            return Utils$.MODULE$.logFailure(res, this.logger());
        }
        if (sink instanceof EsSink) {
            throw new Exception("Sinking Audit log to Elasticsearch not yet supported");
        }
        if ((sink instanceof NoneSink ? true : sink instanceof FsSink) && !settings.comet().sinkToFile()) {
            AuditLog$.sinkToFile$1(log, settings, sessionOpt);
            return BoxedUnit.UNIT;
        }
        if ((sink instanceof NoneSink ? true : sink instanceof FsSink) && settings.comet().sinkToFile()) {
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)sink);
    }

    public Try<Job> sinToBigQuery(Map<String, String> authInfo, AuditLog log, BigQuerySink sink, Settings settings) {
        TableId auditOutputTarget = BigQueryJobBase$.MODULE$.extractProjectDatasetAndTable(new StringBuilder(6).append((String)sink.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit")).append(".").append("audit").toString());
        Option x$1 = authInfo.get((Object)"gcpProjectId");
        Option x$2 = authInfo.get((Object)"gcpSAJsonKey");
        Left x$3 = package$.MODULE$.Left().apply((Object)"ignore");
        Some x$4 = new Some((Object)auditOutputTarget);
        None$ x$5 = None$.MODULE$;
        Nil$ x$6 = Nil$.MODULE$;
        String x$7 = settings.comet().defaultFormat();
        String x$8 = "CREATE_IF_NEEDED";
        String x$9 = "WRITE_APPEND";
        None$ x$10 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        Map<String, String> x$12 = sink.getOptions();
        List<RowLevelSecurity> x$13 = BigQueryLoadConfig$.MODULE$.apply$default$12();
        boolean x$14 = BigQueryLoadConfig$.MODULE$.apply$default$13();
        Engine x$15 = BigQueryLoadConfig$.MODULE$.apply$default$14();
        List<String> x$16 = BigQueryLoadConfig$.MODULE$.apply$default$16();
        List<AccessControlEntry> x$17 = BigQueryLoadConfig$.MODULE$.apply$default$17();
        Option<Schema> x$18 = BigQueryLoadConfig$.MODULE$.apply$default$18();
        Set<String> x$19 = BigQueryLoadConfig$.MODULE$.apply$default$19();
        Option<String> x$20 = BigQueryLoadConfig$.MODULE$.apply$default$20();
        boolean x$21 = BigQueryLoadConfig$.MODULE$.apply$default$21();
        Option<String> x$22 = BigQueryLoadConfig$.MODULE$.apply$default$22();
        Option<String> x$23 = BigQueryLoadConfig$.MODULE$.apply$default$23();
        List<AttributeDesc> x$24 = BigQueryLoadConfig$.MODULE$.apply$default$24();
        BigQueryLoadConfig bqConfig = new BigQueryLoadConfig((Option<String>)x$1, (Option<String>)x$2, (Either<String, Dataset<Row>>)x$3, (Option<TableId>)x$4, (Option<String>)x$5, (Seq<String>)x$6, x$7, x$8, x$9, (Option<String>)x$10, (Option<Object>)x$11, x$13, x$14, x$15, x$12, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
        BigQueryNativeJob bqJob = new BigQueryNativeJob(bqConfig, log.asBqInsert(BigQueryJobBase$.MODULE$.getBqNativeTable(auditOutputTarget)), (Option<String>)None$.MODULE$, settings);
        TableInfo tableInfo = new TableInfo(auditOutputTarget, (Option<String>)new Some((Object)"Information related to starlake executions"), (Option<com.google.cloud.bigquery.Schema>)new Some((Object)this.bqSchema()), TableInfo$.MODULE$.apply$default$4(), TableInfo$.MODULE$.apply$default$5());
        bqJob.getOrCreateTable((Option<String>)None$.MODULE$, tableInfo, (Option<Dataset<Row>>)None$.MODULE$, settings);
        Try<Job> res = bqJob.runBatchQuery();
        return res;
    }

    public AuditLog apply(String jobid, String paths, String domain, String schema, boolean success, long count, long countAccepted, long countRejected, Timestamp timestamp, long duration, String message, String step) {
        return new AuditLog(jobid, paths, domain, schema, success, count, countAccepted, countRejected, timestamp, duration, message, step);
    }

    public Option<Tuple12<String, String, String, String, Object, Object, Object, Object, Timestamp, Object, String, String>> unapply(AuditLog x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple12((Object)x$0.jobid(), (Object)x$0.paths(), (Object)x$0.domain(), (Object)x$0.schema(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.success()), (Object)BoxesRunTime.boxToLong((long)x$0.count()), (Object)BoxesRunTime.boxToLong((long)x$0.countAccepted()), (Object)BoxesRunTime.boxToLong((long)x$0.countRejected()), (Object)x$0.timestamp(), (Object)BoxesRunTime.boxToLong((long)x$0.duration()), (Object)x$0.message(), (Object)x$0.step()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final void sinkToFile$1(AuditLog log, Settings settings, Option sessionOpt$1) {
        SparkSession session = (SparkSession)sessionOpt$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("Spark Session required");
        });
        Path lockPath = new Path(settings.comet().audit().path(), "audit.lock");
        FileLock locker = new FileLock(lockPath, settings.storageHandler());
        locker.doExclusively(locker.doExclusively$default$1(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Path auditPath = new Path(settings.comet().audit().path(), "ingestion-log");
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Ai_starlake_job_ingest_AuditLog$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("ai.starlake.job.ingest.AuditLog").asType().toTypeConstructor();
                }

                public Ai_starlake_job_ingest_AuditLog$$typecreator6$1() {
                }
            }
            DataFrameWriter dfWriter = session.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)log, (List)Nil$.MODULE$), session.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_starlake_job_ingest_AuditLog$$typecreator6$1()))).toDF().write().mode(SaveMode.Append);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Saving audit to path {}", new Object[]{auditPath});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (settings.comet().hive()) {
                BoxedUnit boxedUnit3;
                String hiveDB = (String)settings.comet().audit().sink().name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit");
                String tableName = "audit";
                String fullTableName = new StringBuilder(1).append(hiveDB).append(".").append(tableName).toString();
                session.sql(new StringBuilder(30).append("create database if not exists ").append(hiveDB).toString());
                session.sql(new StringBuilder(4).append("use ").append(hiveDB).toString());
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Saving audit to table {}", new Object[]{fullTableName});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                dfWriter.format(settings.comet().defaultAuditWriteFormat()).saveAsTable(fullTableName);
                return;
            }
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Saving audit to file {}", new Object[]{auditPath});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dfWriter.format(settings.comet().defaultAuditWriteFormat()).option("path", auditPath.toString()).save();
        });
    }

    private AuditLog$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.auditCols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"jobid", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"paths", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"domain", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"schema", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"success", (Object)StandardSQLTypeName.BOOL, (Object)BooleanType$.MODULE$), new Tuple3((Object)"count", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"countAccepted", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"countRejected", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"timestamp", (Object)StandardSQLTypeName.TIMESTAMP, (Object)TimestampType$.MODULE$), new Tuple3((Object)"duration", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"message", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"step", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$)}));
    }
}

