/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.TableId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;

public final class BigQueryJobBase$ {
    public static BigQueryJobBase$ MODULE$;

    static {
        new BigQueryJobBase$();
    }

    public DatasetId ai$starlake$job$sink$bigquery$BigQueryJobBase$$getBqDatasetId(TableId tableId) {
        Option option = Option$.MODULE$.apply((Object)tableId.getProject());
        if (option instanceof Some) {
            return DatasetId.of((String)tableId.getProject(), (String)tableId.getDataset());
        }
        if (None$.MODULE$.equals(option)) {
            return DatasetId.of((String)tableId.getDataset());
        }
        throw new MatchError((Object)option);
    }

    public String getBqDataset(TableId tableId) {
        String projectId = this.getProjectIdPrefix(tableId.getProject(), ":");
        return new StringBuilder(0).append(projectId).append(tableId.getDataset()).toString();
    }

    public String getBqNativeDataset(TableId tableId) {
        String projectId = this.getProjectIdPrefix(tableId.getProject(), ".");
        return new StringBuilder(0).append(projectId).append(tableId.getDataset()).toString();
    }

    public String getBqTable(TableId tableId) {
        String projectId = this.getProjectIdPrefix(tableId.getProject(), ":");
        return new StringBuilder(1).append(projectId).append(tableId.getDataset()).append(".").append(tableId.getTable()).toString();
    }

    public String getBqNativeTable(TableId tableId) {
        String projectId = this.getProjectIdPrefix(tableId.getProject(), ".");
        return new StringBuilder(1).append(projectId).append(tableId.getDataset()).append(".").append(tableId.getTable()).toString();
    }

    public TableId extractProjectDatasetAndTable(String datasetId, String tableId) {
        return this.extractProjectDatasetAndTable(new StringBuilder(1).append(datasetId).append(".").append(tableId).toString());
    }

    public TableId extractProjectDatasetAndTable(String resourceId) {
        Tuple2 tuple2;
        Option project2;
        block3: {
            Tuple2 tuple22;
            block2: {
                int sepIndex = resourceId.indexOf(":");
                Tuple2 tuple23 = tuple22 = sepIndex > 0 ? new Tuple2((Object)new Some((Object)resourceId.substring(0, sepIndex)), (Object)BigQueryJobBase$.extractDatasetAndTable$1(resourceId.substring(sepIndex + 1), resourceId)) : new Tuple2((Object)None$.MODULE$, (Object)BigQueryJobBase$.extractDatasetAndTable$1(resourceId, resourceId));
                if (tuple22 == null) break block2;
                project2 = (Option)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String dataset = (String)tuple2._1();
        String table = (String)tuple2._2();
        Tuple3 tuple3 = new Tuple3((Object)project2, (Object)dataset, (Object)table);
        Option project3 = (Option)tuple3._1();
        String dataset2 = (String)tuple3._2();
        String table2 = (String)tuple3._3();
        return (TableId)project3.map((Function1 & java.io.Serializable & Serializable)project -> TableId.of((String)project, (String)dataset2, (String)table2)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> TableId.of((String)dataset2, (String)table2));
    }

    public DatasetId extractProjectDataset(String value) {
        Tuple2 tuple2;
        int sepIndex = value.indexOf(":");
        Tuple2 tuple22 = tuple2 = sepIndex > 0 ? new Tuple2((Object)new Some((Object)value.substring(0, sepIndex)), (Object)value.substring(sepIndex + 1)) : new Tuple2((Object)None$.MODULE$, (Object)value);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option project2 = (Option)tuple2._1();
        String dataset = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)project2, (Object)dataset);
        Option project3 = (Option)tuple23._1();
        String dataset2 = (String)tuple23._2();
        return (DatasetId)project3.map((Function1 & java.io.Serializable & Serializable)project -> DatasetId.of((String)project, (String)dataset2)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> DatasetId.of((String)dataset2));
    }

    private String getProjectIdPrefix(String nullableProjectId, String seperator) {
        return (String)Option$.MODULE$.apply((Object)nullableProjectId).map((Function1 & java.io.Serializable & Serializable)x$19 -> new StringBuilder(0).append((String)x$19).append(seperator).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
    }

    private static final Tuple2 extractDatasetAndTable$1(String str, String resourceId$1) {
        int sepIndex = str.indexOf(46);
        if (sepIndex > 0) {
            return new Tuple2((Object)str.substring(0, sepIndex), (Object)str.substring(sepIndex + 1));
        }
        throw new Exception(new StringBuilder(47).append("Dataset cannot be null in BigQuery view name (").append(resourceId$1).append(")").toString());
    }

    private BigQueryJobBase$() {
        MODULE$ = this;
    }
}

