/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.config.Settings;
import ai.starlake.job.ingest.AuditLog;
import ai.starlake.job.ingest.AuditLog$;
import ai.starlake.job.ingest.Step$LOAD$;
import ai.starlake.job.sink.bigquery.BigQueryJobBase;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.job.sink.bigquery.BigQueryJobResult;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.schema.model.BigQuerySink;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Format$DSV$;
import ai.starlake.schema.model.Format$JSON$;
import ai.starlake.schema.model.IamPolicyTags;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.SinkType;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.MaterializedViewDefinition;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.cloud.datacatalog.v1.PolicyTagManagerClient;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001\u0002\f\u0018\u0001\tB\u0001b\r\u0001\u0003\u0006\u0004%\t\u0005\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!I\u0005A!b\u0001\n\u0007Q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bI\u0003A\u0011A*\t\u000bi\u0003A\u0011I.\t\u000bq\u0003A\u0011A/\t\u000bQ\u0004A\u0011B;\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003_\u0001A\u0011IA\t\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!!\u0010\u0001\t\u0013\ty\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u001d9\u00111O\f\t\u0002\u0005UdA\u0002\f\u0018\u0011\u0003\t9\b\u0003\u0004S)\u0011\u0005\u0011\u0011\u0012\u0002\u0012\u0005&<\u0017+^3ss:\u000bG/\u001b<f\u0015>\u0014'B\u0001\r\u001a\u0003!\u0011\u0017nZ9vKJL(B\u0001\u000e\u001c\u0003\u0011\u0019\u0018N\\6\u000b\u0005qi\u0012a\u00016pE*\u0011adH\u0001\tgR\f'\u000f\\1lK*\t\u0001%\u0001\u0002bS\u000e\u00011\u0003\u0002\u0001$S=\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u001e\u0003\u0015)H/\u001b7t\u0013\tq3FA\u0004K_\n\u0014\u0015m]3\u0011\u0005A\nT\"A\f\n\u0005I:\"a\u0004\"jOF+XM]=K_\n\u0014\u0015m]3\u0002\u0013\rd\u0017nQ8oM&<W#A\u001b\u0011\u0005A2\u0014BA\u001c\u0018\u0005I\u0011\u0015nZ)vKJLHj\\1e\u0007>tg-[4\u0002\u0015\rd\u0017nQ8oM&<\u0007%A\u0002tc2\u0004\"a\u000f\"\u000f\u0005q\u0002\u0005CA\u001f&\u001b\u0005q$BA \"\u0003\u0019a$o\\8u}%\u0011\u0011)J\u0001\u0007!J,G-\u001a4\n\u0005\r#%AB*ue&twM\u0003\u0002BK\u0005\u0019Q\u000f\u001a4\u0011\u0007\u0011:%(\u0003\u0002IK\t1q\n\u001d;j_:\f\u0001b]3ui&twm]\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a*H\u0001\u0007G>tg-[4\n\u0005Ak%\u0001C*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003U/bKFCA+W!\t\u0001\u0004\u0001C\u0003J\u000f\u0001\u000f1\nC\u00034\u000f\u0001\u0007Q\u0007C\u0003:\u000f\u0001\u0007!\bC\u0003F\u000f\u0001\u0007a)\u0001\u0003oC6,W#\u0001\u001e\u0002\u001b1|\u0017\r\u001a)bi\"\u001cHk\u001c\"R)\tqv\rE\u0002`E\u0012l\u0011\u0001\u0019\u0006\u0003C\u0016\nA!\u001e;jY&\u00111\r\u0019\u0002\u0004)JL\bC\u0001\u0019f\u0013\t1wCA\tCS\u001e\fV/\u001a:z\u0015>\u0014'+Z:vYRDQ\u0001[\u0005A\u0002%\f\u0001BY9TG\",W.\u0019\t\u0003UJl\u0011a\u001b\u0006\u000311T!!\u001c8\u0002\u000b\rdw.\u001e3\u000b\u0005=\u0004\u0018AB4p_\u001edWMC\u0001r\u0003\r\u0019w.\\\u0005\u0003g.\u0014aaU2iK6\f\u0017\u0001\u00042r\u0019>\fGmQ8oM&<G#\u0002<~}\u0006\u001d\u0001CA<{\u001d\tQ\u00070\u0003\u0002zW\u0006!Bj\\1e\u0015>\u00147i\u001c8gS\u001e,(/\u0019;j_:L!a\u001f?\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0011\u0011p\u001b\u0005\u0006Q*\u0001\r!\u001b\u0005\u0007\u007f*\u0001\r!!\u0001\u0002\u001b\u0019|'/\\1u\u001fB$\u0018n\u001c8t!\rQ\u00171A\u0005\u0004\u0003\u000bY'!\u0004$pe6\fGo\u00149uS>t7\u000f\u0003\u0004\u0002\n)\u0001\rAO\u0001\u000bg>,(oY3V%&\u001b\u0018a\u00042r\r>\u0014X.\u0019;PaRLwN\\:\u0015\u0005\u0005\u0005\u0011a\u0005:v]&sG/\u001a:bGRLg/Z)vKJLHCAA\n!\u0011y&-!\u0006\u0011\u0007)\n9\"C\u0002\u0002\u001a-\u0012\u0011BS8c%\u0016\u001cX\u000f\u001c;\u0002'\u0005$G-\u0016#G)>\fV/\u001a:z\u0007>tg-[4\u0015\t\u0005}\u00111\u0006\t\u0005\u0003C\t9CD\u0002k\u0003GI1!!\nl\u0003U\tV/\u001a:z\u0015>\u00147i\u001c8gS\u001e,(/\u0019;j_:L1a_A\u0015\u0015\r\t)c\u001b\u0005\b\u0003[i\u0001\u0019AA\u0010\u0003-\tX/\u001a:z\u0007>tg-[4\u0002\u0007I,h.\u0001\u000fSk:\fe\u000eZ*j].\f5/T1uKJL\u0017\r\\5{K\u00124\u0016.Z<\u0015\u0005\u0005U\u0002\u0003B0c\u0003o\u00012A[A\u001d\u0013\r\tYd\u001b\u0002\u0006)\u0006\u0014G.Z\u0001\u0012%Vt\u0017I\u001c3TS:\\\u0017i\u001d+bE2,G#\u00010\u0002\u001bI,hNQ1uG\"\fV/\u001a:z)\t\t)\u0005\u0005\u0003`E\u0006\u001d\u0003c\u00016\u0002J%\u0019\u00111J6\u0003\u0007){'-A\u0006de\u0016\fG/\u001a,jK^\u001cHCBA)\u0003/\n\t\u0007E\u0002%\u0003'J1!!\u0016&\u0005\u0011)f.\u001b;\t\u000f\u0005e#\u00031\u0001\u0002\\\u0005)a/[3xgB)1(!\u0018;u%\u0019\u0011q\f#\u0003\u00075\u000b\u0007\u000fC\u0003F%\u0001\u0007a\tK\u0004\u0013\u0003K\nY'a\u001c\u0011\u0007\u0011\n9'C\u0002\u0002j\u0015\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\ti'A\u001bWS\u0016<8\u000fI1sK\u0002rwn\u001e\u0011de\u0016\fG/\u001a3!kNLgn\u001a\u0011uQ\u0016\u00043/\u001f8uCb\u0004s\u000b\u0016%!]9r\u0003%Q*!]9r\u0013EAA9\u0003\u0019\u0001d&\r\u00183k\u0005\t\")[4Rk\u0016\u0014\u0018PT1uSZ,'j\u001c2\u0011\u0005A\"2\u0003\u0002\u000b$\u0003s\u0002B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)\u0001\u0007tG\u0006d\u0017\r\\8hO&twMC\u0002\u0002\u0004B\f\u0001\u0002^=qKN\fg-Z\u0005\u0005\u0003\u000f\u000biHA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u000b\u0003\u0003k\u0002")
public class BigQueryNativeJob
implements JobBase,
BigQueryJobBase {
    private final BigQueryLoadConfig cliConfig;
    private final String sql;
    private final Option<String> udf;
    private final Settings settings;
    private PolicyTagManagerClient ai$starlake$job$sink$bigquery$BigQueryJobBase$$policyTagClient;
    private Option<BigQuery> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery;
    private TableId tableId;
    private DatasetId datasetId;
    private String bqTable;
    private String bqNativeTable;
    private final String appName;
    private final Logger logger;
    private volatile byte bitmap$0;

    @Override
    public String projectId() {
        return BigQueryJobBase.projectId$(this);
    }

    @Override
    public Try<BoxedUnit> applyRLSAndCLS(boolean forceApply, Settings settings) {
        return BigQueryJobBase.applyRLSAndCLS$(this, forceApply, settings);
    }

    @Override
    public boolean applyRLSAndCLS$default$1() {
        return BigQueryJobBase.applyRLSAndCLS$default$1$(this);
    }

    @Override
    public BigQuery bigquery(Settings settings) {
        return BigQueryJobBase.bigquery$(this, settings);
    }

    @Override
    public Try<BoxedUnit> applyIamPolicyTags(IamPolicyTags iamPolicyTags, Settings settings) {
        return BigQueryJobBase.applyIamPolicyTags$(this, iamPolicyTags, settings);
    }

    @Override
    public List<String> prepareRLS() {
        return BigQueryJobBase.prepareRLS$(this);
    }

    @Override
    public Dataset getOrCreateDataset(Option<String> domainDescription, Settings settings) {
        return BigQueryJobBase.getOrCreateDataset$(this, domainDescription, settings);
    }

    @Override
    public Try<Tuple2<Table, StandardTableDefinition>> getOrCreateTable(Option<String> domainDescription, ai.starlake.schema.model.TableInfo tableInfo, Option<org.apache.spark.sql.Dataset<Row>> dataFrame, Settings settings) {
        return BigQueryJobBase.getOrCreateTable$(this, domainDescription, tableInfo, dataFrame, settings);
    }

    @Override
    public Table updateTableDescription(TableId idTable, String description, Settings settings) {
        return BigQueryJobBase.updateTableDescription$(this, idTable, description, settings);
    }

    @Override
    public Map<String, String> getFieldsDescriptionSource(String sql, Settings settings) {
        return BigQueryJobBase.getFieldsDescriptionSource$(this, sql, settings);
    }

    @Override
    public Table updateColumnsDescription(Map<String, String> dictField, Settings settings) {
        return BigQueryJobBase.updateColumnsDescription$(this, dictField, settings);
    }

    @Override
    public TimePartitioning.Builder timePartitioning(String partitionField, Option<Object> days, boolean requirePartitionFilter) {
        return BigQueryJobBase.timePartitioning$(this, partitionField, days, requirePartitionFilter);
    }

    @Override
    public Option<Object> timePartitioning$default$2() {
        return BigQueryJobBase.timePartitioning$default$2$(this);
    }

    @Override
    public String applicationId() {
        return JobBase.applicationId$(this);
    }

    @Override
    public Tuple3<SinkType, Option<String>, String> parseViewDefinition(String valueWithEnv) {
        return JobBase.parseViewDefinition$(this, valueWithEnv);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(org.apache.spark.sql.Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    private PolicyTagManagerClient ai$starlake$job$sink$bigquery$BigQueryJobBase$$policyTagClient$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$policyTagClient = BigQueryJobBase.ai$starlake$job$sink$bigquery$BigQueryJobBase$$policyTagClient$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$policyTagClient;
    }

    @Override
    public PolicyTagManagerClient ai$starlake$job$sink$bigquery$BigQueryJobBase$$policyTagClient() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$policyTagClient$lzycompute();
        }
        return this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$policyTagClient;
    }

    @Override
    public Option<BigQuery> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery() {
        return this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery_$eq(Option<BigQuery> x$1) {
        this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery = x$1;
    }

    private TableId tableId$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tableId = BigQueryJobBase.tableId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.tableId;
    }

    @Override
    public TableId tableId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.tableId$lzycompute();
        }
        return this.tableId;
    }

    private DatasetId datasetId$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.datasetId = BigQueryJobBase.datasetId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.datasetId;
    }

    @Override
    public DatasetId datasetId() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.datasetId$lzycompute();
        }
        return this.datasetId;
    }

    private String bqTable$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.bqTable = BigQueryJobBase.bqTable$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.bqTable;
    }

    @Override
    public String bqTable() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.bqTable$lzycompute();
        }
        return this.bqTable;
    }

    private String bqNativeTable$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.bqNativeTable = BigQueryJobBase.bqNativeTable$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.bqNativeTable;
    }

    @Override
    public String bqNativeTable() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.bqNativeTable$lzycompute();
        }
        return this.bqNativeTable;
    }

    @Override
    public String appName() {
        return this.appName;
    }

    @Override
    public void ai$starlake$utils$JobBase$_setter_$appName_$eq(String x$1) {
        this.appName = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public BigQueryLoadConfig cliConfig() {
        return this.cliConfig;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return new StringBuilder(7).append("bqload-").append(this.bqNativeTable()).toString();
    }

    public Try<BigQueryJobResult> loadPathsToBQ(Schema bqSchema) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("BigQuery Schema: {}", new Object[]{bqSchema});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            FormatOptions formatOptions = this.bqFormatOptions();
            this.getOrCreateDataset(this.cliConfig().domainDescription(), this.settings());
            Either<String, org.apache.spark.sql.Dataset<Row>> either = this.cliConfig().source();
            if (either instanceof Left) {
                Left left = (Left)either;
                String sourceURIs = (String)left.value();
                LoadJobConfiguration.Builder loadConfig = this.bqLoadConfig(bqSchema, formatOptions, sourceURIs);
                Job job = this.bigquery(this.settings()).create(JobInfo.of((JobConfiguration)loadConfig.build()), new BigQuery.JobOption[0]);
                Job jobResult = job.waitFor(new RetryOption[0]);
                if (jobResult.isDone()) {
                    BoxedUnit boxedUnit2;
                    JobStatistics.LoadStatistics stats = (JobStatistics.LoadStatistics)jobResult.getStatistics();
                    this.applyRLSAndCLS(this.applyRLSAndCLS$default$1(), this.settings()).recover((PartialFunction)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ BigQueryNativeJob $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            Utils$.MODULE$.logException(this.$outer.logger(), A1);
                            throw A1;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            return true;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("bq-ingestion-summary -> files: [{}], domain: {}, schema: {}, input: {}, accepted: {}, rejected:{}", new Object[]{sourceURIs, this.tableId().getDataset(), this.tableId().getTable(), BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(stats.getOutputRows()) + Predef$.MODULE$.Long2long(stats.getBadRecords()))), stats.getOutputRows(), stats.getBadRecords()});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boolean success = !this.settings().comet().rejectAllOnError() || BoxesRunTime.equalsNumObject((Number)stats.getBadRecords(), (Object)BoxesRunTime.boxToInteger((int)0));
                    AuditLog log = new AuditLog(jobResult.getJobId().getJob(), sourceURIs, BigQueryJobBase$.MODULE$.getBqNativeDataset(this.tableId()), this.tableId().getTable(), success, Predef$.MODULE$.Long2long(stats.getOutputRows()) + Predef$.MODULE$.Long2long(stats.getBadRecords()), Predef$.MODULE$.Long2long(stats.getOutputRows()), Predef$.MODULE$.Long2long(stats.getBadRecords()), Timestamp.from(Instant.ofEpochMilli(Predef$.MODULE$.Long2long(stats.getStartTime()))), Predef$.MODULE$.Long2long(stats.getEndTime()) - Predef$.MODULE$.Long2long(stats.getStartTime()), success ? "success" : new StringBuilder(16).append(stats.getBadRecords()).append(" invalid records").toString(), Step$LOAD$.MODULE$.toString());
                    Sink sink = this.settings().comet().audit().sink();
                    if (!(sink instanceof BigQuerySink)) {
                        throw new Exception("Not Supported");
                    }
                    BigQuerySink bigQuerySink = (BigQuerySink)sink;
                    AuditLog$.MODULE$.sinToBigQuery((Map<String, String>)Predef$.MODULE$.Map().empty(), log, bigQuerySink, this.settings());
                    return new BigQueryJobResult((Option<TableResult>)None$.MODULE$, Predef$.MODULE$.Long2long(stats.getInputBytes()));
                }
                throw new Exception(new StringBuilder(59).append("BigQuery was unable to load into the table due to an error:").append(jobResult.getStatus().getError()).toString());
            }
            if (either instanceof Right) {
                throw new Exception("Should never happen");
            }
            throw new MatchError(either);
        });
    }

    private LoadJobConfiguration.Builder bqLoadConfig(Schema bqSchema, FormatOptions formatOptions, String sourceURIs) {
        Object object;
        LoadJobConfiguration.Builder loadConfig = LoadJobConfiguration.newBuilder((TableId)this.tableId(), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceURIs.split(","))).toList()).asJava()), (FormatOptions)formatOptions).setIgnoreUnknownValues(Predef$.MODULE$.boolean2Boolean(true)).setCreateDisposition(JobInfo.CreateDisposition.valueOf((String)this.cliConfig().createDisposition())).setWriteDisposition(JobInfo.WriteDisposition.valueOf((String)this.cliConfig().writeDisposition())).setSchema(bqSchema);
        String string = this.cliConfig().writeDisposition();
        String string2 = JobInfo.WriteDisposition.WRITE_APPEND.toString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            loadConfig.setSchemaUpdateOptions((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION, (List)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION, (List)Nil$.MODULE$))).asJava());
            object = !this.settings().comet().rejectAllOnError() ? loadConfig.setMaxBadRecords(Predef$.MODULE$.int2Integer(this.settings().comet().rejectMaxRecords())) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<String> option = this.cliConfig().outputPartition();
        if (option instanceof Some) {
            Some some = (Some)option;
            String partitionField = (String)some.value();
            TimePartitioning partitioning = this.timePartitioning(partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter()).build();
            loadConfig.setTimePartitioning(partitioning);
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        Seq<String> seq = this.cliConfig().outputClustering();
        if (Nil$.MODULE$.equals(seq)) {
        } else {
            Clustering clustering = Clustering.newBuilder().setFields((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava()).build();
            loadConfig.setClustering(clustering);
        }
        return loadConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FormatOptions bqFormatOptions() {
        Option option = this.cliConfig().starlakeSchema().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.metadata());
        if (option instanceof Some) {
            FormatOptions formatOptions;
            Some some = (Some)option;
            Metadata metadata = (Metadata)some.value();
            Format format = metadata.getFormat();
            if (((Object)Format$DSV$.MODULE$).equals(format)) {
                CsvOptions.Builder formatOptions2 = CsvOptions.newBuilder().setAllowQuotedNewLines(true).setAllowJaggedRows(true);
                Object object = Predef$.MODULE$.Boolean2boolean(metadata.isWithHeader()) ? formatOptions2.setSkipLeadingRows(1L).build() : BoxedUnit.UNIT;
                Option<String> option2 = metadata.encoding();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String encoding = (String)some2.value();
                    formatOptions2.setEncoding(encoding);
                } else if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                formatOptions2.setFieldDelimiter(metadata.getSeparator());
                metadata.quote().map((Function1 & Serializable & scala.Serializable)quote -> formatOptions2.setQuote(quote));
                formatOptions = formatOptions2.build();
                return formatOptions;
            } else {
                if (!((Object)Format$JSON$.MODULE$).equals(format)) throw new Exception("Should never happen");
                formatOptions = FormatOptions.json();
            }
            return formatOptions;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            throw new Exception("Should never happen");
        }
    }

    public Try<JobResult> runInteractiveQuery() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            this.getOrCreateDataset(this.cliConfig().domainDescription(), this.settings());
            QueryJobConfiguration.Builder queryConfig = QueryJobConfiguration.newBuilder((String)$this.sql).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Running interactive BQ Query {}", new Object[]{$this.sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            QueryJobConfiguration.Builder queryConfigWithUDF = this.addUDFToQueryConfig(queryConfig);
            QueryJobConfiguration finalConfiguration = queryConfigWithUDF.setPriority(QueryJobConfiguration.Priority.INTERACTIVE).build();
            Job queryJob = this.bigquery(this.settings()).create(JobInfo.of((JobConfiguration)finalConfiguration), new BigQuery.JobOption[0]);
            Long totalBytesProcessed = ((JobStatistics.QueryStatistics)queryJob.getStatistics()).getTotalBytesProcessed();
            TableResult results = queryJob.getQueryResults(new BigQuery.QueryResultsOption[0]);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Query large results performed successfully: {} rows returned.", new Object[]{BoxesRunTime.boxToLong((long)results.getTotalRows())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new BigQueryJobResult((Option<TableResult>)new Some((Object)results), Predef$.MODULE$.Long2long(totalBytesProcessed));
        });
    }

    private QueryJobConfiguration.Builder addUDFToQueryConfig(QueryJobConfiguration.Builder queryConfig) {
        QueryJobConfiguration.Builder queryConfigWithUDF = (QueryJobConfiguration.Builder)this.udf.map((Function1 & Serializable & scala.Serializable)udf -> queryConfig.setUserDefinedFunctions((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)UserDefinedFunction.fromUri((String)udf), (List)Nil$.MODULE$)).asJava())).getOrElse((Function0 & Serializable & scala.Serializable)() -> queryConfig);
        return queryConfigWithUDF;
    }

    @Override
    public Try<JobResult> run() {
        if (this.cliConfig().materializedView()) {
            return this.RunAndSinkAsMaterializedView().map((Function1 & Serializable & scala.Serializable)table -> new BigQueryJobResult((Option<TableResult>)None$.MODULE$, 0L));
        }
        return this.RunAndSinkAsTable();
    }

    private Try<Table> RunAndSinkAsMaterializedView() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.getOrCreateDataset((Option<String>)None$.MODULE$, this.settings());
            MaterializedViewDefinition.Builder materializedViewDefinitionBuilder = MaterializedViewDefinition.newBuilder((String)$this.sql);
            Option<String> option = this.cliConfig().outputPartition();
            if (option instanceof Some) {
                Some some = (Some)option;
                String partitionField = (String)some.value();
                TimePartitioning partitioning = this.timePartitioning(partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter()).build();
                materializedViewDefinitionBuilder.setTimePartitioning(partitioning);
            } else if (None$.MODULE$.equals(option)) {
            } else {
                throw new MatchError(option);
            }
            Seq<String> seq = this.cliConfig().outputClustering();
            if (Nil$.MODULE$.equals(seq)) {
            } else {
                Clustering clustering = Clustering.newBuilder().setFields((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava()).build();
                materializedViewDefinitionBuilder.setClustering(clustering);
            }
            Option option2 = this.cliConfig().options().get((Object)"enableRefresh");
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String x = (String)some.value();
                materializedViewDefinitionBuilder.setEnableRefresh(Predef$.MODULE$.boolean2Boolean(new StringOps(Predef$.MODULE$.augmentString(x)).toBoolean()));
            } else if (None$.MODULE$.equals(option2)) {
            } else {
                throw new MatchError((Object)option2);
            }
            Option option3 = this.cliConfig().options().get((Object)"refreshIntervalMs");
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                String x = (String)some.value();
                materializedViewDefinitionBuilder.setRefreshIntervalMs(Predef$.MODULE$.long2Long(new StringOps(Predef$.MODULE$.augmentString(x)).toLong()));
            } else if (None$.MODULE$.equals(option3)) {
            } else {
                throw new MatchError((Object)option3);
            }
            return this.bigquery(this.settings()).create(TableInfo.of((TableId)this.tableId(), (TableDefinition)materializedViewDefinitionBuilder.build()), new BigQuery.TableOption[0]);
        });
    }

    private Try<BigQueryJobResult> RunAndSinkAsTable() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            QueryJobConfiguration.Builder queryConfigWithClustering;
            QueryJobConfiguration.Builder builder;
            BoxedUnit boxedUnit4;
            QueryJobConfiguration.Builder builder2;
            BoxedUnit boxedUnit5;
            Dataset targetDataset = this.getOrCreateDataset((Option<String>)None$.MODULE$, this.settings());
            QueryJobConfiguration.Builder queryConfig = QueryJobConfiguration.newBuilder((String)$this.sql).setCreateDisposition(JobInfo.CreateDisposition.valueOf((String)this.cliConfig().createDisposition())).setWriteDisposition(JobInfo.WriteDisposition.valueOf((String)this.cliConfig().writeDisposition())).setDefaultDataset(targetDataset.getDatasetId()).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Computing partitionning");
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            Option<String> option = this.cliConfig().outputPartition();
            if (option instanceof Some) {
                Some some = (Some)option;
                String partitionField = (String)some.value();
                TimePartitioning partitioning = this.timePartitioning(partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter()).build();
                boolean tableExists = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.bigquery(this.settings()).getTable(this.tableId(), new BigQuery.TableOption[0]).exists()).toOption().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                String string = this.cliConfig().writeDisposition();
                String string2 = JobInfo.WriteDisposition.WRITE_APPEND.toString();
                builder2 = !(string != null ? !string.equals(string2) : string2 != null) && tableExists ? queryConfig.setTimePartitioning(partitioning).setSchemaUpdateOptions((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION, (List)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION, (List)Nil$.MODULE$))).asJava()) : queryConfig.setTimePartitioning(partitioning);
            } else if (None$.MODULE$.equals(option)) {
                builder2 = queryConfig;
            } else {
                throw new MatchError(option);
            }
            QueryJobConfiguration.Builder queryConfigWithPartition = builder2;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Computing clustering");
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            Seq<String> seq = this.cliConfig().outputClustering();
            if (Nil$.MODULE$.equals(seq)) {
                builder = queryConfigWithPartition;
            } else {
                Clustering clustering = Clustering.newBuilder().setFields((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava()).build();
                builder = queryConfigWithClustering = queryConfigWithPartition.setClustering(clustering);
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Add user defined functions");
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            QueryJobConfiguration.Builder queryConfigWithUDF = this.addUDFToQueryConfig(queryConfigWithClustering);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Executing BQ Query {}", new Object[]{$this.sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            QueryJobConfiguration finalConfiguration = queryConfigWithUDF.setDestinationTable(this.tableId()).build();
            Job jobInfo = this.bigquery(this.settings()).create(JobInfo.of((JobConfiguration)finalConfiguration), new BigQuery.JobOption[0]);
            Long totalBytesProcessed = ((JobStatistics.QueryStatistics)jobInfo.getStatistics()).getTotalBytesProcessed();
            TableResult results = jobInfo.getQueryResults(new BigQuery.QueryResultsOption[0]);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Query large results performed successfully: {} rows inserted.", new Object[]{BoxesRunTime.boxToLong((long)results.getTotalRows())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.applyRLSAndCLS(this.applyRLSAndCLS$default$1(), this.settings()).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BigQueryNativeJob $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Utils$.MODULE$.logException(this.$outer.logger(), A1);
                    throw new Exception(A1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.updateTableDescription(this.tableId(), (String)this.cliConfig().outputTableDesc().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), this.settings());
            this.updateColumnsDescription(this.getFieldsDescriptionSource($this.sql, this.settings()), this.settings());
            return new BigQueryJobResult((Option<TableResult>)new Some((Object)results), Predef$.MODULE$.Long2long(totalBytesProcessed));
        });
    }

    public Try<Job> runBatchQuery() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            this.getOrCreateDataset((Option<String>)None$.MODULE$, this.settings());
            JobId jobId = JobId.newBuilder().setJob(UUID.randomUUID().toString()).setLocation(this.cliConfig().getLocation()).build();
            QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)$this.sql).setPriority(QueryJobConfiguration.Priority.BATCH).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).build();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Executing BQ Query {}", new Object[]{$this.sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Job job = this.bigquery(this.settings()).create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(jobId).build(), new BigQuery.JobOption[0]);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Batch query wth jobId {} sent to BigQuery ", new Object[]{jobId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (job == null) {
                throw new Exception("Job not executed since it no longer exists.");
            }
            return job;
        });
    }

    public void createViews(Map<String, String> views, Option<String> udf) {
        views.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BigQueryNativeJob.$anonfun$createViews$1(this, udf, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$createViews$1(BigQueryNativeJob $this, Option udf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            ViewDefinition.Builder viewQuery = ViewDefinition.newBuilder((String)value).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false));
            ViewDefinition.Builder viewDefinition = (ViewDefinition.Builder)udf$1.map((Function1 & Serializable & scala.Serializable)udf -> viewQuery.setUserDefinedFunctions((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)UserDefinedFunction.fromUri((String)udf), (List)Nil$.MODULE$)).asJava())).getOrElse((Function0 & Serializable & scala.Serializable)() -> viewQuery);
            TableId tableId = BigQueryJobBase$.MODULE$.extractProjectDatasetAndTable(key);
            Option viewRef = Option$.MODULE$.apply((Object)$this.bigquery($this.settings()).getTable(tableId, new BigQuery.TableOption[0]));
            if (viewRef.isEmpty()) {
                BoxedUnit boxedUnit;
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info("View {} does not exist, creating it!", new Object[]{tableId});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                $this.bigquery($this.settings()).create(TableInfo.of((TableId)tableId, (TableDefinition)viewDefinition.build()), new BigQuery.TableOption[0]);
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info("View {} created", new Object[]{tableId});
                    return;
                }
                return;
            }
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("View {} already exist", new Object[]{tableId});
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public BigQueryNativeJob(BigQueryLoadConfig cliConfig, String sql, Option<String> udf, Settings settings) {
        BoxedUnit boxedUnit;
        this.cliConfig = cliConfig;
        this.sql = sql;
        this.udf = udf;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        BigQueryJobBase.$init$(this);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("BigQuery Config {}", new Object[]{cliConfig});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

