/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.config.Settings;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig$;
import ai.starlake.job.sink.bigquery.BigQuerySparkJob;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AttributeDesc;
import ai.starlake.schema.model.BigQuerySink;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.EsSink;
import ai.starlake.schema.model.FsSink;
import ai.starlake.schema.model.NoneSink;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.TableId;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Right;
import scala.util.Try;

public final class BigQuerySparkWriter$
implements StrictLogging {
    public static BigQuerySparkWriter$ MODULE$;
    private final Logger logger;

    static {
        new BigQuerySparkWriter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Object sink(Map<String, String> authInfo, Dataset<Row> df, String tableName, Option<String> maybeTableDescription, WriteMode writeMode, Settings settings) {
        Sink sink = settings.comet().tableInfo().sink();
        if (sink instanceof BigQuerySink) {
            BigQuerySink bigQuerySink = (BigQuerySink)sink;
            Right source = package$.MODULE$.Right().apply(Utils$.MODULE$.setNullableStateOfColumn(df, true));
            Tuple2<String, String> tuple2 = Utils$.MODULE$.getDBDisposition(writeMode, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String createDisposition = (String)tuple2._1();
            String writeDisposition = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)createDisposition, (Object)writeDisposition);
            String createDisposition2 = (String)tuple22._1();
            String writeDisposition2 = (String)tuple22._2();
            Option x$1 = authInfo.get((Object)"gcpProjectId");
            Option x$2 = authInfo.get((Object)"gcpSAJsonKey");
            Right x$3 = source;
            Some x$4 = new Some((Object)BigQueryJobBase$.MODULE$.extractProjectDatasetAndTable((String)bigQuerySink.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit"), tableName));
            String x$5 = settings.comet().defaultFormat();
            String x$6 = createDisposition2;
            String x$7 = writeDisposition2;
            Option<String> x$8 = bigQuerySink.location();
            Option<String> x$9 = bigQuerySink.timestamp();
            Seq x$10 = (Seq)bigQuerySink.clustering().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            Option<Object> x$11 = bigQuerySink.days();
            boolean x$12 = BoxesRunTime.unboxToBoolean((Object)bigQuerySink.requirePartitionFilter().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            Nil$ x$13 = Nil$.MODULE$;
            Map<String, String> x$14 = bigQuerySink.getOptions();
            Nil$ x$15 = Nil$.MODULE$;
            Engine x$16 = BigQueryLoadConfig$.MODULE$.apply$default$14();
            List<String> x$17 = BigQueryLoadConfig$.MODULE$.apply$default$16();
            Option<Schema> x$18 = BigQueryLoadConfig$.MODULE$.apply$default$18();
            Set<String> x$19 = BigQueryLoadConfig$.MODULE$.apply$default$19();
            Option<String> x$20 = BigQueryLoadConfig$.MODULE$.apply$default$20();
            boolean x$21 = BigQueryLoadConfig$.MODULE$.apply$default$21();
            Option<String> x$22 = BigQueryLoadConfig$.MODULE$.apply$default$22();
            Option<String> x$23 = BigQueryLoadConfig$.MODULE$.apply$default$23();
            List<AttributeDesc> x$24 = BigQueryLoadConfig$.MODULE$.apply$default$24();
            BigQueryLoadConfig bqLoadConfig = new BigQueryLoadConfig((Option<String>)x$1, (Option<String>)x$2, (Either<String, Dataset<Row>>)x$3, (Option<TableId>)x$4, x$9, (Seq<String>)x$10, x$5, x$6, x$7, x$8, x$11, (List<RowLevelSecurity>)x$13, x$12, x$16, x$14, x$17, (List<AccessControlEntry>)x$15, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
            Try<JobResult> result = new BigQuerySparkJob(bqLoadConfig, (Option<com.google.cloud.bigquery.Schema>)None$.MODULE$, maybeTableDescription, settings).run();
            Utils$.MODULE$.logFailure(result, this.logger());
            return BoxesRunTime.boxToBoolean((boolean)result.isSuccess());
        }
        if (sink instanceof EsSink) {
            throw new Exception("Sinking Audit log to Elasticsearch not yet supported");
        }
        if (sink instanceof NoneSink ? true : sink instanceof FsSink) {
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    private BigQuerySparkWriter$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

