/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.transform;

import ai.starlake.job.transform.AutoTask;
import ai.starlake.job.transform.TaskViewDependency;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Schema;
import ai.starlake.utils.SQLUtils$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TaskViewDependency$
implements StrictLogging,
scala.Serializable {
    public static TaskViewDependency$ MODULE$;
    private final String TASK_TYPE;
    private final String CTE_TYPE;
    private final String TASKVIEW_TYPE;
    private final String TABLE_TYPE;
    private final String VIEW_TYPE;
    private final String UNKNOWN_TYPE;
    private final Logger logger;

    static {
        new TaskViewDependency$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Option<String> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public String TASK_TYPE() {
        return this.TASK_TYPE;
    }

    public String CTE_TYPE() {
        return this.CTE_TYPE;
    }

    public String TASKVIEW_TYPE() {
        return this.TASKVIEW_TYPE;
    }

    public String TABLE_TYPE() {
        return this.TABLE_TYPE;
    }

    public String VIEW_TYPE() {
        return this.VIEW_TYPE;
    }

    public String UNKNOWN_TYPE() {
        return this.UNKNOWN_TYPE;
    }

    public List<TaskViewDependency> jobDependencies(String jobName, List<AutoTask> tasks, SchemaHandler schemaHandler) {
        List<TaskViewDependency> deps = this.dependencies(tasks, schemaHandler);
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        List roots = (List)deps.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$jobDependencies$1(jobName, t)));
        result.$plus$plus$eq((TraversableOnce)roots);
        this.getHierarchy((List<TaskViewDependency>)roots, deps, (ListBuffer<TaskViewDependency>)result);
        return (List)result.toList().distinct();
    }

    private void getHierarchy(List<TaskViewDependency> roots, List<TaskViewDependency> allDeps, ListBuffer<TaskViewDependency> result) {
        roots.foreach((Function1 & Serializable & scala.Serializable)root -> {
            TaskViewDependency$.$anonfun$getHierarchy$1(allDeps, roots, result, root);
            return BoxedUnit.UNIT;
        });
    }

    public List<TaskViewDependency> dependencies(List<AutoTask> tasks, SchemaHandler schemaHandler) {
        Map jobs = tasks.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name());
        List jobDependencies = (List)jobs.mapValues((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dependencies(), List$.MODULE$.canBuildFrom())).toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String jobName = (String)tuple2._1();
                List dependencies = (List)tuple2._2();
                return new TaskViewDependency.SimpleEntry(jobName, MODULE$.TASK_TYPE(), (List<String>)dependencies);
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        List viewDependencies = ((TraversableOnce)schemaHandler.views().mapValues((Function1 & Serializable & scala.Serializable)sql -> SQLUtils$.MODULE$.extractRefsFromSQL((String)sql)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String viewName = (String)tuple2._1();
                List dependencies = (List)tuple2._2();
                return new TaskViewDependency.SimpleEntry(viewName, MODULE$.VIEW_TYPE(), (List<String>)dependencies);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        List jobAndViewDeps = (List)((List)jobDependencies.$plus$plus((GenTraversableOnce)viewDependencies, List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            TaskViewDependency.SimpleEntry simpleEntry = x0$3;
            if (simpleEntry != null) {
                BoxedUnit boxedUnit;
                String jobName = simpleEntry.name();
                String typ = simpleEntry.typ();
                List<String> parentRefs = simpleEntry.parentRefs();
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Analyzing dependency of type '{}' for job '{}' with parent refs [{}]", new Object[]{typ, jobName, parentRefs.mkString(",")});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (parentRefs.isEmpty()) {
                    return new .colon.colon((Object)new TaskViewDependency(jobName, typ, "", MODULE$.UNKNOWN_TYPE(), "", MODULE$.apply$default$6()), (List)Nil$.MODULE$);
                }
                return (List)parentRefs.map((Function1 & Serializable & scala.Serializable)parentSQLRef -> {
                    Option parentJobName;
                    Option option;
                    String[] parts = new StringOps(Predef$.MODULE$.augmentString(parentSQLRef)).split('.');
                    int n = parts.length;
                    switch (n) {
                        case 1: {
                            String tablePart = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last();
                            option = tasks.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$9(tablePart, x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name());
                            break;
                        }
                        case 2: 
                        case 3: {
                            String domainPart = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).dropRight(1))).last();
                            String tablePart = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last();
                            option = tasks.find((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$11(tablePart, domainPart, task))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name());
                            break;
                        }
                        default: {
                            String errors = schemaHandler.checkJobsVars().mkString("\n");
                            if (parts.length == 0) {
                                throw new Exception(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("invalid parent ref '").append((String)parentSQLRef).append("' syntax in job '").append(jobName).append("': No part found.\n                     |Make sure variables defined in your job have a default value in the selected env profile.\n                     |").append(errors).toString())).stripMargin());
                            }
                            throw new Exception(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("invalid parent ref '").append((String)parentSQLRef).append("' syntax in job '").append(jobName).append("'. Too many parts.\n                       |Make sure variables defined in your job have a default value in the selected env profile.\n                       |").append(errors).toString())).stripMargin());
                        }
                    }
                    Option option2 = parentJobName = option;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        String parentJobName2 = (String)some.value();
                        TaskViewDependency result = new TaskViewDependency(jobName, typ, parentJobName2, MODULE$.TASK_TYPE(), (String)parentSQLRef, MODULE$.apply$default$6());
                        String string = typ;
                        String string2 = MODULE$.TASK_TYPE();
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            AutoTask task2 = (AutoTask)((IterableLike)jobs.apply((Object)jobName)).head();
                            String sink = new StringBuilder(1).append(task2.taskDesc().domain()).append(".").append(task2.taskDesc().table()).toString();
                            Some x$1 = new Some((Object)sink);
                            String x$2 = result.copy$default$1();
                            String x$3 = result.copy$default$2();
                            String x$4 = result.copy$default$3();
                            String x$52 = result.copy$default$4();
                            String x$62 = result.copy$default$5();
                            return result.copy(x$2, x$3, x$4, x$52, x$62, (Option<String>)x$1);
                        }
                        return result;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        Some some;
                        Tuple2 tuple2;
                        Option parentTable;
                        Option option3;
                        List<Domain> domains = schemaHandler.domains(schemaHandler.domains$default$1(), schemaHandler.domains$default$2());
                        int n2 = parts.length;
                        switch (n2) {
                            case 1: {
                                String tablePart = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last();
                                Option parentDomain = domains.find((Function1 & Serializable & scala.Serializable)domain -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$13(tablePart, domain)));
                                option3 = parentDomain.map((Function1 & Serializable & scala.Serializable)domain -> new Tuple2((Object)domain.name(), (Object)tablePart));
                                break;
                            }
                            case 2: 
                            case 3: {
                                String domainPart = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).dropRight(1))).last();
                                String tablePart = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last();
                                Option theDomain = domains.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$16(domainPart, x$9)));
                                boolean parentDomainFound = theDomain.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$17(tablePart, x$10)));
                                if (parentDomainFound) {
                                    option3 = new Some((Object)new Tuple2((Object)domainPart, (Object)tablePart));
                                    break;
                                }
                                option3 = None$.MODULE$;
                                break;
                            }
                            default: {
                                throw new Exception(new StringBuilder(31).append("unknown ").append((String)parentSQLRef).append(" syntax. Too many parts").toString());
                            }
                        }
                        Option option4 = parentTable = option3;
                        if (option4 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option4).value()) != null) {
                            String parentDomainName = (String)tuple2._1();
                            String parentTableName = (String)tuple2._2();
                            return new TaskViewDependency(jobName, typ, new StringBuilder(1).append(parentDomainName).append(".").append(parentTableName).toString(), MODULE$.TABLE_TYPE(), (String)parentSQLRef, MODULE$.apply$default$6());
                        }
                        if (None$.MODULE$.equals(option4)) {
                            Some some2;
                            boolean bl;
                            Some some3;
                            boolean bl2;
                            Option parentViewNameExist = jobs.get(parentSQLRef).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$20(parentSQLRef$1, x$12)))));
                            Option option5 = parentViewNameExist;
                            if (option5 instanceof Some && (bl2 = BoxesRunTime.unboxToBoolean((Object)(some3 = (Some)option5).value()))) {
                                return new TaskViewDependency(jobName, typ, (String)parentSQLRef, MODULE$.TASKVIEW_TYPE(), (String)parentSQLRef, MODULE$.apply$default$6());
                            }
                            if (None$.MODULE$.equals(option5) ? true : option5 instanceof Some && false == (bl = BoxesRunTime.unboxToBoolean((Object)(some2 = (Some)option5).value()))) {
                                boolean found = schemaHandler.views().keys().exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$22(parentSQLRef, x$14)));
                                if (found) {
                                    return new TaskViewDependency(jobName, typ, (String)parentSQLRef, MODULE$.VIEW_TYPE(), (String)parentSQLRef, MODULE$.apply$default$6());
                                }
                                return new TaskViewDependency(jobName, typ, "", MODULE$.UNKNOWN_TYPE(), (String)parentSQLRef, MODULE$.apply$default$6());
                            }
                            throw new MatchError((Object)option5);
                        }
                        throw new MatchError((Object)option4);
                    }
                    throw new MatchError((Object)option2);
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)simpleEntry);
        }, List$.MODULE$.canBuildFrom());
        Iterable tableNames = ((TraversableLike)jobAndViewDeps.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$23(x$15)))).groupBy((Function1 & Serializable & scala.Serializable)x$16 -> x$16.parent()).keys();
        Iterable tableDeps = (Iterable)tableNames.map((Function1 & Serializable & scala.Serializable)x$17 -> new TaskViewDependency((String)x$17, MODULE$.TABLE_TYPE(), "", MODULE$.UNKNOWN_TYPE(), "", MODULE$.apply$default$6()), scala.collection.Iterable$.MODULE$.canBuildFrom());
        List jobAndViewDepsWithSink = (List)jobAndViewDeps.map((Function1 & Serializable & scala.Serializable)dep -> {
            String string = dep.typ();
            String string2 = MODULE$.TASK_TYPE();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                AutoTask task = (AutoTask)((IterableLike)jobs.apply((Object)dep.name())).head();
                String sink = new StringBuilder(1).append(task.taskDesc().domain()).append(".").append(task.taskDesc().table()).toString();
                Some x$7 = new Some((Object)sink);
                String x$8 = dep.copy$default$1();
                String x$9 = dep.copy$default$2();
                String x$10 = dep.copy$default$3();
                String x$11 = dep.copy$default$4();
                String x$12 = dep.copy$default$5();
                return dep.copy(x$8, x$9, x$10, x$11, x$12, (Option<String>)x$7);
            }
            return dep;
        }, List$.MODULE$.canBuildFrom());
        return (List)jobAndViewDepsWithSink.$plus$plus((GenTraversableOnce)tableDeps, List$.MODULE$.canBuildFrom());
    }

    public TaskViewDependency apply(String name, String typ, String parent, String parentTyp, String parentRef, Option<String> sink) {
        return new TaskViewDependency(name, typ, parent, parentTyp, parentRef, sink);
    }

    public Option<String> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<Tuple6<String, String, String, String, String, Option<String>>> unapply(TaskViewDependency x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.name(), (Object)x$0.typ(), (Object)x$0.parent(), (Object)x$0.parentTyp(), (Object)x$0.parentRef(), x$0.sink()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$jobDependencies$1(String jobName$1, TaskViewDependency t) {
        String string = t.name();
        String string2 = jobName$1;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = t.typ();
        String string4 = MODULE$.TASK_TYPE();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getHierarchy$2(TaskViewDependency root$1, TaskViewDependency t) {
        String string = t.typ();
        String string2 = root$1.parentTyp();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = t.name();
        String string4 = root$1.parent();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getHierarchy$4(TaskViewDependency subRoot$1, TaskViewDependency x$1) {
        String string = x$1.name().toLowerCase();
        String string2 = subRoot$1.name().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getHierarchy$3(List roots$1, TaskViewDependency subRoot) {
        return !roots$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$getHierarchy$4(subRoot, x$1)));
    }

    public static final /* synthetic */ void $anonfun$getHierarchy$1(List allDeps$1, List roots$1, ListBuffer result$1, TaskViewDependency root) {
        List subRoots = (List)allDeps$1.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$getHierarchy$2(root, t)));
        List nocyclicRoots = (List)subRoots.filter((Function1 & Serializable & scala.Serializable)subRoot -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$getHierarchy$3(roots$1, subRoot)));
        result$1.$plus$plus$eq((TraversableOnce)nocyclicRoots);
        MODULE$.getHierarchy((List<TaskViewDependency>)nocyclicRoots, (List<TaskViewDependency>)allDeps$1, (ListBuffer<TaskViewDependency>)result$1);
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$9(String tablePart$1, AutoTask x$5) {
        String string = x$5.taskDesc().table().toLowerCase();
        String string2 = tablePart$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$dependencies$11(String tablePart$2, String domainPart$1, AutoTask task) {
        String string = task.taskDesc().table().toLowerCase();
        String string2 = tablePart$2.toLowerCase();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = task.taskDesc().domain().toLowerCase();
        String string4 = domainPart$1.toLowerCase();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$14(String tablePart$3, Schema x$8) {
        String string = x$8.name().toLowerCase();
        String string2 = tablePart$3.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$13(String tablePart$3, Domain domain) {
        return domain.tables().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$14(tablePart$3, x$8)));
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$16(String domainPart$2, Domain x$9) {
        String string = x$9.name().toLowerCase();
        String string2 = domainPart$2.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$18(String tablePart$4, Schema table) {
        String string = table.name().toLowerCase();
        String string2 = tablePart$4.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$17(String tablePart$4, Domain x$10) {
        return x$10.tables().exists((Function1 & Serializable & scala.Serializable)table -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$18(tablePart$4, table)));
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$21(String parentSQLRef$1, String x$13) {
        String string = x$13.toLowerCase();
        String string2 = parentSQLRef$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$20(String parentSQLRef$1, AutoTask x$12) {
        return x$12.views().views().keys().exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TaskViewDependency$.$anonfun$dependencies$21(parentSQLRef$1, x$13)));
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$22(String parentSQLRef$1, String x$14) {
        String string = x$14.toLowerCase();
        String string2 = parentSQLRef$1.toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$dependencies$23(TaskViewDependency x$15) {
        String string = x$15.parentTyp();
        String string2 = MODULE$.TABLE_TYPE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private TaskViewDependency$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.TASK_TYPE = "task";
        this.CTE_TYPE = "cte";
        this.TASKVIEW_TYPE = "taskview";
        this.TABLE_TYPE = "table";
        this.VIEW_TYPE = "view";
        this.UNKNOWN_TYPE = "unknown";
    }
}

