/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.generator;

import ai.starlake.config.Settings;
import ai.starlake.schema.generator.BigQuery2Yml$;
import ai.starlake.schema.generator.BigQueryTablesConfig;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Domain$;
import ai.starlake.schema.model.MergeOptions;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Schema$;
import ai.starlake.utils.repackaged.BigQuerySchemaConverters;
import com.google.api.gax.paging.Page;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001\u0002\t\u0012\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tM\u0001\u0011\t\u0011)A\u0006O!)A\u0006\u0001C\u0001[!9!\u0007\u0001b\u0001\n\u0003\u0019\u0004BB \u0001A\u0003%A\u0007C\u0003A\u0001\u0011\u0005\u0011\tC\u0003U\u0001\u0011\u0005Q\u000bC\u0003U\u0001\u0011\u0005\u0001\rC\u0003g\u0001\u0011\u0005q\rC\u0003g\u0001\u0011\u0005anB\u0003u#!\u0005QOB\u0003\u0011#!\u0005a\u000fC\u0003-\u0019\u0011\u0005q\u000fC\u0003A\u0019\u0011\u0005\u0001\u0010C\u0004\u0002\u000e1!\t!a\u0004\u0003\u0019\tKw-U;fef\u0014\u0014,\u001c7\u000b\u0005I\u0019\u0012!C4f]\u0016\u0014\u0018\r^8s\u0015\t!R#\u0001\u0004tG\",W.\u0019\u0006\u0003-]\t\u0001b\u001d;be2\f7.\u001a\u0006\u00021\u0005\u0011\u0011-[\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VMZ\u0001\u0007G>tg-[4\u0011\u0005\r\"S\"A\t\n\u0005\u0015\n\"\u0001\u0006\"jOF+XM]=UC\ndWm]\"p]\u001aLw-\u0001\u0005tKR$\u0018N\\4t!\tA#&D\u0001*\u0015\t\tS#\u0003\u0002,S\tA1+\u001a;uS:<7/\u0001\u0004=S:LGO\u0010\u000b\u0003]E\"\"a\f\u0019\u0011\u0005\r\u0002\u0001\"\u0002\u0014\u0004\u0001\b9\u0003\"B\u0011\u0004\u0001\u0004\u0011\u0013\u0001\u00032jOF,XM]=\u0016\u0003Q\u0002\"!N\u001f\u000e\u0003YR!AM\u001c\u000b\u0005aJ\u0014!B2m_V$'B\u0001\u001e<\u0003\u00199wn\\4mK*\tA(A\u0002d_6L!A\u0010\u001c\u0003\u0011\tKw-U;fef\f\u0011BY5hcV,'/\u001f\u0011\u0002\u001f\u0015DHO]1di\u0012\u000bG/Y:fiN$\u0012A\u0011\t\u0004\u0007.seB\u0001#J\u001d\t)\u0005*D\u0001G\u0015\t9\u0015$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011!*H\u0001\ba\u0006\u001c7.Y4f\u0013\taUJ\u0001\u0003MSN$(B\u0001&\u001e!\ty%+D\u0001Q\u0015\t\t6#A\u0003n_\u0012,G.\u0003\u0002T!\n1Ai\\7bS:\fa\"\u001a=ue\u0006\u001cG\u000fR1uCN,G\u000f\u0006\u0002O-\")qk\u0002a\u00011\u0006IA-\u0019;bg\u0016$\u0018\n\u001a\t\u00033vs!AW.\u0011\u0005\u0015k\u0012B\u0001/\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011al\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qkBC\u0001(b\u0011\u0015\u0011\u0007\u00021\u0001d\u0003\u001d!\u0017\r^1tKR\u0004\"!\u000e3\n\u0005\u00154$a\u0002#bi\u0006\u001cX\r^\u0001\rKb$(/Y2u)\u0006\u0014G.\u001a\u000b\u0004Q.d\u0007CA(j\u0013\tQ\u0007K\u0001\u0004TG\",W.\u0019\u0005\u0006/&\u0001\r\u0001\u0017\u0005\u0006[&\u0001\r\u0001W\u0001\bi\u0006\u0014G.Z%e)\tAw\u000eC\u0003q\u0015\u0001\u0007\u0011/A\u0003uC\ndW\r\u0005\u00026e&\u00111O\u000e\u0002\u0006)\u0006\u0014G.Z\u0001\r\u0005&<\u0017+^3ssJJV\u000e\u001c\t\u0003G1\u0019\"\u0001D\u000e\u0015\u0003U$\"!\u001f@\u0015\u0005il\b\u0003B-|1\nK!\u0001`0\u0003\u00075\u000b\u0007\u000fC\u0003'\u001d\u0001\u000fq\u0005\u0003\u0004\u0000\u001d\u0001\u0007\u0011\u0011A\u0001\u000eg\u000eDW-\\1IC:$G.\u001a:\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002\u0014\u0003!A\u0017M\u001c3mKJ\u001c\u0018\u0002BA\u0006\u0003\u000b\u0011QbU2iK6\f\u0007*\u00198eY\u0016\u0014\u0018a\u0001:v]R!\u0011\u0011CA\u000e)\u0011\t\u0019\"!\u0007\u0011\u0007q\t)\"C\u0002\u0002\u0018u\u0011A!\u00168ji\")ae\u0004a\u0002O!9\u0011QD\bA\u0002\u0005}\u0011\u0001B1sON\u0004B\u0001HA\u00111&\u0019\u00111E\u000f\u0003\u000b\u0005\u0013(/Y=")
public class BigQuery2Yml {
    private final BigQueryTablesConfig config;
    private final Settings settings;
    private final BigQuery bigquery;

    public static void run(String[] stringArray, Settings settings) {
        BigQuery2Yml$.MODULE$.run(stringArray, settings);
    }

    public BigQuery bigquery() {
        return this.bigquery;
    }

    public List<Domain> extractDatasets() {
        Page datasets = this.bigquery().listDatasets(new BigQuery.DatasetListOption[]{BigQuery.DatasetListOption.pageSize((long)10000L)});
        Iterable allDatasets = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(datasets.iterateAll()).asScala();
        List datasetsToExtract = this.config.tables().keys().toList();
        Iterable filteredDatasets = this.config.tables().isEmpty() ? allDatasets : (Iterable)allDatasets.filter((Function1 & Serializable & scala.Serializable)ds -> BoxesRunTime.boxToBoolean((boolean)datasetsToExtract.contains((Object)ds.getDatasetId().getDataset())));
        return ((TraversableOnce)filteredDatasets.map((Function1 & Serializable & scala.Serializable)dataset -> this.extractDataset((Dataset)dataset), Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public Domain extractDataset(String datasetId) {
        return this.extractDataset(this.bigquery().getDataset(datasetId, new BigQuery.DatasetOption[0]));
    }

    public Domain extractDataset(Dataset dataset) {
        Iterable iterable;
        DatasetId datasetId = dataset.getDatasetId();
        Page bqTables = this.bigquery().listTables(datasetId, new BigQuery.TableListOption[]{BigQuery.TableListOption.pageSize((long)10000L)});
        Iterable allTables = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(bqTables.iterateAll()).asScala();
        String datasetName = dataset.getDatasetId().getDataset();
        Option option = this.config.tables().get((Object)datasetName);
        if (option instanceof Some) {
            iterable = (Iterable)allTables.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)BigQuery2Yml.$anonfun$extractDataset$1(this, dataset, t)));
        } else if (None$.MODULE$.equals(option)) {
            iterable = allTables;
        } else {
            throw new MatchError((Object)option);
        }
        Iterable tables = iterable;
        Iterable schemas = (Iterable)tables.flatMap((Function1 & Serializable & scala.Serializable)bqTable -> {
            Table tableWithDefinition = this.bigquery().getTable(bqTable.getTableId(), new BigQuery.TableOption[0]);
            if (tableWithDefinition.getDefinition() instanceof StandardTableDefinition) {
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)this.extractTable(tableWithDefinition)));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Iterable$.MODULE$.canBuildFrom());
        String x$1 = dataset.getDatasetId().getDataset();
        List x$2 = schemas.toList();
        Option x$3 = Option$.MODULE$.apply((Object)dataset.getDescription());
        Option<String> x$4 = Domain$.MODULE$.apply$default$2();
        Option<Metadata> x$5 = Domain$.MODULE$.apply$default$3();
        List<String> x$6 = Domain$.MODULE$.apply$default$4();
        List<String> x$7 = Domain$.MODULE$.apply$default$7();
        Option<String> x$8 = Domain$.MODULE$.apply$default$8();
        Set<String> x$9 = Domain$.MODULE$.apply$default$9();
        Option<String> x$10 = Domain$.MODULE$.apply$default$10();
        Option<String> x$11 = Domain$.MODULE$.apply$default$11();
        return new Domain(x$1, x$4, x$5, x$6, (List<Schema>)x$2, (Option<String>)x$3, x$7, x$8, x$9, x$10, x$11);
    }

    public Schema extractTable(String datasetId, String tableId) {
        return this.extractTable(this.bigquery().getTable(datasetId, tableId, new BigQuery.TableOption[0]));
    }

    public Schema extractTable(Table table) {
        com.google.cloud.bigquery.Schema bqSchema = table.getDefinition().getSchema();
        StructType sparkSchema = BigQuerySchemaConverters.toSpark(bqSchema);
        Schema schema = Schema$.MODULE$.fromSparkSchema(table.getTableId().getTable(), new StructField("ignore", (DataType)sparkSchema, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), this.settings);
        Option x$1 = Option$.MODULE$.apply((Object)table.getDescription());
        String x$2 = schema.copy$default$1();
        Pattern x$3 = schema.copy$default$2();
        List<Attribute> x$4 = schema.copy$default$3();
        Option<Metadata> x$5 = schema.copy$default$4();
        Option<MergeOptions> x$6 = schema.copy$default$5();
        List<String> x$7 = schema.copy$default$7();
        List<String> x$8 = schema.copy$default$8();
        Set<String> x$9 = schema.copy$default$9();
        List<RowLevelSecurity> x$10 = schema.copy$default$10();
        Map<String, String> x$11 = schema.copy$default$11();
        List<String> x$12 = schema.copy$default$12();
        List<AccessControlEntry> x$13 = schema.copy$default$13();
        Option<String> x$14 = schema.copy$default$14();
        Option<String> x$15 = schema.copy$default$15();
        Option<String> x$16 = schema.copy$default$16();
        return schema.copy(x$2, x$3, x$4, x$5, x$6, (Option<String>)x$1, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
    }

    public static final /* synthetic */ boolean $anonfun$extractDataset$1(BigQuery2Yml $this, Dataset dataset$1, Table t) {
        return ((LinearSeqOptimized)$this.config.tables().apply((Object)dataset$1.getDatasetId().getDataset())).contains((Object)t.getTableId().getTable());
    }

    public BigQuery2Yml(BigQueryTablesConfig config, Settings settings) {
        this.config = config;
        this.settings = settings;
        this.bigquery = config.bigquery(settings);
    }
}

