/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.generator.yml2dag;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.schema.generator.yml2dag.DomainTemplate;
import ai.starlake.schema.generator.yml2dag.DomainTemplate$;
import ai.starlake.schema.generator.yml2dag.Yml2DagTemplate;
import better.files.Resource$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Yml2DagTemplateLoader$
implements LazyLogging {
    public static Yml2DagTemplateLoader$ MODULE$;
    private final String JINJA_EXTENSION;
    private final String TEMPLATE_FOLDER;
    private final String DOMAIN_TEMPLATE_FOLDER;
    private final String RESOURCE_DOMAIN_TEMPLATE_FOLDER;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new Yml2DagTemplateLoader$();
    }

    private Logger logger$lzycompute() {
        Yml2DagTemplateLoader$ yml2DagTemplateLoader$ = this;
        synchronized (yml2DagTemplateLoader$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String JINJA_EXTENSION() {
        return this.JINJA_EXTENSION;
    }

    private String TEMPLATE_FOLDER() {
        return this.TEMPLATE_FOLDER;
    }

    public String DOMAIN_TEMPLATE_FOLDER() {
        return this.DOMAIN_TEMPLATE_FOLDER;
    }

    private String RESOURCE_DOMAIN_TEMPLATE_FOLDER() {
        return this.RESOURCE_DOMAIN_TEMPLATE_FOLDER;
    }

    public Try<String> loadTemplate(Yml2DagTemplate template, Settings settings) {
        return this.loadTemplateFromAbsolutePath(template, settings).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.loadTemplateFromDagPath(template, settings)).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.loadTemplateFromResources(template)).orElse((Function0 & Serializable & scala.Serializable)() -> new Failure((Throwable)new RuntimeException(new StringBuilder(96).append("Template `").append(template.path()).append("` not found. Please provide an absolute path or a template returned by `list` command.").toString())));
    }

    public Try<String> loadTemplateFromAbsolutePath(Yml2DagTemplate template, Settings settings) {
        Path templatePath = new Path(template.path());
        if (settings.storageHandler().exists(templatePath)) {
            return new Success((Object)settings.storageHandler().read(templatePath, settings.storageHandler().read$default$2()));
        }
        return new Failure((Throwable)new RuntimeException(new StringBuilder(32).append("No absolute template found for ").append(templatePath).append(".").toString()));
    }

    /*
     * Unable to fully structure code
     */
    public Try<String> loadTemplateFromDagPath(Yml2DagTemplate template, Settings settings) {
        var5_3 = false;
        var6_4 = null;
        var7_5 = template;
        if (!(var7_5 instanceof DomainTemplate)) ** GOTO lbl-1000
        var5_3 = true;
        var6_4 = (DomainTemplate)var7_5;
        path = var6_4.path();
        if (!path.endsWith(this.JINJA_EXTENSION())) {
            v0 = new StringBuilder(0).append(path).append(this.JINJA_EXTENSION()).toString();
        } else if (var5_3) {
            v0 = path = var6_4.path();
        } else {
            throw new MatchError((Object)var7_5);
        }
        pathToResolve = v0;
        domainInDagPath = new Path(DatasetArea$.MODULE$.dags(settings), new StringBuilder(1).append(this.DOMAIN_TEMPLATE_FOLDER()).append("/").append(pathToResolve).toString());
        if (settings.storageHandler().exists(domainInDagPath)) {
            return new Success((Object)settings.storageHandler().read(domainInDagPath, settings.storageHandler().read$default$2()));
        }
        return new Failure((Throwable)new RuntimeException(new StringBuilder(32).append("No relative template found for ").append(domainInDagPath).append(".").toString()));
    }

    public List<DomainTemplate> listTemplateFromDagPath(Settings settings) {
        if (settings.storageHandler().exists(DatasetArea$.MODULE$.dags(settings))) {
            Path x$1 = DatasetArea$.MODULE$.dags(settings);
            String x$2 = this.JINJA_EXTENSION();
            boolean x$3 = true;
            boolean x$4 = true;
            LocalDateTime x$5 = settings.storageHandler().list$default$3();
            Option<Pattern> x$6 = settings.storageHandler().list$default$5();
            return (List)((List)settings.storageHandler().list(x$1, x$2, x$5, x$3, x$6, x$4).map((Function1 & Serializable & scala.Serializable)p -> p.toUri().getPath().substring(DatasetArea$.MODULE$.dags(settings).toUri().getPath().length() + MODULE$.DOMAIN_TEMPLATE_FOLDER().length() + 2, p.toUri().getPath().length() - MODULE$.JINJA_EXTENSION().length()), List$.MODULE$.canBuildFrom())).map((Function1)DomainTemplate$.MODULE$, List$.MODULE$.canBuildFrom());
        }
        return Nil$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public Try<String> loadTemplateFromResources(Yml2DagTemplate domainTemplate) {
        var5_2 = false;
        var6_3 = null;
        var7_4 = domainTemplate;
        if (!(var7_4 instanceof DomainTemplate)) ** GOTO lbl-1000
        var5_2 = true;
        var6_3 = (DomainTemplate)var7_4;
        path = var6_3.path();
        if (path.endsWith(this.JINJA_EXTENSION())) {
            v0 = path;
        } else if (var5_2) {
            v0 = path = var6_3.path();
        } else {
            throw new MatchError((Object)var7_4);
        }
        templateToResolve = v0;
        x$1 = new StringBuilder(1).append(this.RESOURCE_DOMAIN_TEMPLATE_FOLDER()).append("/").append(templateToResolve).toString();
        x$2 = Resource$.MODULE$.asString$default$2();
        x$3 = Resource$.MODULE$.asString$default$3(x$1, x$2);
        var10_11 = Resource$.MODULE$.asString(x$1, x$2, x$3);
        if (var10_11 instanceof Some) {
            var14_12 = (Some)var10_11;
            value = (String)var14_12.value();
            return new Success((Object)value);
        }
        if (None$.MODULE$.equals(var10_11)) {
            return new Failure((Throwable)new RuntimeException(new StringBuilder(35).append("Relative template not found in for ").append(domainTemplate).toString()));
        }
        throw new MatchError((Object)var10_11);
    }

    public List<DomainTemplate> listTemplateFromResources() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        URI domainFolderURI = Resource$.MODULE$.getUrl(String.valueOf(this.RESOURCE_DOMAIN_TEMPLATE_FOLDER())).toURI();
        if (domainFolderURI.toString().contains("!")) {
            BoxedUnit boxedUnit;
            Tuple2 tuple23 = new StringOps(Predef$.MODULE$.augmentString(domainFolderURI.toString())).splitAt(domainFolderURI.toString().indexOf("!"));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            String jarFile = (String)tuple23._1();
            String path = (String)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)jarFile, (Object)path);
            String jarFile2 = (String)tuple24._1();
            String path2 = (String)tuple24._2();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Opening jar file at {}", new Object[]{jarFile2});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            FileSystem system = FileSystems.newFileSystem(URI.create(jarFile2), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)system), new StringOps(Predef$.MODULE$.augmentString(path2)).tail());
        } else {
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FileSystems.getDefault()), (Object)domainFolderURI.getPath());
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileSystem fs = (FileSystem)tuple2._1();
        String path = (String)tuple2._2();
        Tuple2 tuple25 = new Tuple2((Object)fs, (Object)path);
        FileSystem fs2 = (FileSystem)tuple25._1();
        String path3 = (String)tuple25._2();
        java.nio.file.Path domainFolderPath = fs2.getPath(path3, new String[0]);
        Stream<java.nio.file.Path> walk = Files.walk(domainFolderPath, new FileVisitOption[0]);
        Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(walk.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> ((Object)x$3).toString()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.endsWith(Yml2DagTemplateLoader$.MODULE$.JINJA_EXTENSION()))).map((Function1 & Serializable & scala.Serializable)p -> p.substring(((Object)domainFolderPath.toAbsolutePath()).toString().length() + 1, p.length() - MODULE$.JINJA_EXTENSION().length())).map((Function1)DomainTemplate$.MODULE$).toList());
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs2.close());
        Try try_ = result;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw exception;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List value = (List)success.value();
            return value;
        }
        throw new MatchError((Object)try_);
    }

    private Yml2DagTemplateLoader$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.JINJA_EXTENSION = ".j2";
        this.TEMPLATE_FOLDER = "templates";
        this.DOMAIN_TEMPLATE_FOLDER = new StringBuilder(8).append(this.TEMPLATE_FOLDER()).append("/domains").toString();
        this.RESOURCE_DOMAIN_TEMPLATE_FOLDER = new StringBuilder(8).append("yml2dag/").append(this.DOMAIN_TEMPLATE_FOLDER()).toString();
    }
}

