/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.generator.yml2dag.command;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.config.Settings$;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.schema.generator.yml2dag.DomainTemplate;
import ai.starlake.schema.generator.yml2dag.Yml2DagTemplateLoader$;
import ai.starlake.schema.generator.yml2dag.command.Yml2DagGenerateCommand$;
import ai.starlake.schema.generator.yml2dag.command.Yml2DagGenerateCommand$DagGenerationContext$;
import ai.starlake.schema.generator.yml2dag.command.Yml2DagGenerateCommand$DomainTable$;
import ai.starlake.schema.generator.yml2dag.config.Yml2DagGenerateConfig;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.ClusterConfig;
import ai.starlake.schema.model.DagGenerationConfig;
import ai.starlake.schema.model.DagGenerationConfig$;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.MergeOptions;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.Metadata$;
import ai.starlake.schema.model.Mode;
import ai.starlake.schema.model.Partition;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.SlConfig;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.DatasetId;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001\u0002\"D\u0001AC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006u\u0002!Ia\u001f\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u00031aAa\u0003\u0001\u0001\n5\u0001\"C<\b\u0005+\u0007I\u0011\u0001B\b\u0011)\u0011\tb\u0002B\tB\u0003%!1\u0001\u0005\u000b\u0003k9!Q3A\u0005\u0002\tM\u0001B\u0003B\u000f\u000f\tE\t\u0015!\u0003\u0003\u0016!1\u0001n\u0002C\u0001\u0005?A\u0011\"!!\b\u0003\u0003%\tAa\n\t\u0013\u0005%u!%A\u0005\u0002\t5\u0002\"CAQ\u000fE\u0005I\u0011\u0001B\u0019\u0011%\t9kBA\u0001\n\u0003\nI\u000bC\u0005\u0002:\u001e\t\t\u0011\"\u0001\u0002<\"I\u00111Y\u0004\u0002\u0002\u0013\u0005!Q\u0007\u0005\n\u0003#<\u0011\u0011!C!\u0003'D\u0011\"!9\b\u0003\u0003%\tA!\u000f\t\u0013\u00055x!!A\u0005B\u0005=\b\"CAy\u000f\u0005\u0005I\u0011IAz\u0011%\t)pBA\u0001\n\u0003\u0012idB\u0005\u0003B\u0001\t\t\u0011#\u0001\u0003D\u0019I!1\u0002\u0001\u0002\u0002#\u0005!Q\t\u0005\u0007Qf!\tAa\u0015\t\u0013\u0005E\u0018$!A\u0005F\u0005M\b\"\u0003B+3\u0005\u0005I\u0011\u0011B,\u0011%\u0011i&GA\u0001\n\u0003\u0013yF\u0002\u0004\u0002N\u0001\u0001\u0015q\n\u0005\u000b\u0003;r\"Q3A\u0005\u0002\u0005}\u0003BCA7=\tE\t\u0015!\u0003\u0002b!Q\u0011q\u000e\u0010\u0003\u0016\u0004%\t!!\u001d\t\u0015\u0005edD!E!\u0002\u0013\t\u0019\b\u0003\u0004i=\u0011\u0005\u00111\u0010\u0005\n\u0003\u0003s\u0012\u0011!C\u0001\u0003\u0007C\u0011\"!#\u001f#\u0003%\t!a#\t\u0013\u0005\u0005f$%A\u0005\u0002\u0005\r\u0006\"CAT=\u0005\u0005I\u0011IAU\u0011%\tILHA\u0001\n\u0003\tY\fC\u0005\u0002Dz\t\t\u0011\"\u0001\u0002F\"I\u0011\u0011\u001b\u0010\u0002\u0002\u0013\u0005\u00131\u001b\u0005\n\u0003Ct\u0012\u0011!C\u0001\u0003GD\u0011\"!<\u001f\u0003\u0003%\t%a<\t\u0013\u0005Eh$!A\u0005B\u0005M\b\"CA{=\u0005\u0005I\u0011IA|\u000f%\u0011\t\bAA\u0001\u0012\u0003\u0011\u0019HB\u0005\u0002N\u0001\t\t\u0011#\u0001\u0003v!1\u0001\u000e\rC\u0001\u0005sB\u0011\"!=1\u0003\u0003%)%a=\t\u0013\tU\u0003'!A\u0005\u0002\nm\u0004\"\u0003B/a\u0005\u0005I\u0011\u0011BA\u0011\u001d\u0011I\t\u0001C\u0005\u0005\u0017CqAa%\u0001\t\u0013\u0011)\nC\u0004\u0003(\u0002!IA!+\t\u000f\tM\u0006\u0001\"\u0003\u00036\"9!\u0011\u0018\u0001\u0005\n\tm\u0006b\u0002Ba\u0001\u0011%!1Y\u0004\b\u0005/\u001c\u0005\u0012\u0001Bm\r\u0019\u00115\t#\u0001\u0003\\\"1\u0001\u000e\u0010C\u0001\u0005;D\u0011Ba8=\u0005\u0004%\t!!+\t\u0011\t\u0005H\b)A\u0005\u0003WC\u0011Ba9=\u0005\u0004%\t!!+\t\u0011\t\u0015H\b)A\u0005\u0003W\u0013a#W7me\u0011\u000bwmR3oKJ\fG/Z\"p[6\fg\u000e\u001a\u0006\u0003\t\u0016\u000bqaY8n[\u0006tGM\u0003\u0002G\u000f\u00069\u00110\u001c73I\u0006<'B\u0001%J\u0003%9WM\\3sCR|'O\u0003\u0002K\u0017\u000611o\u00195f[\u0006T!\u0001T'\u0002\u0011M$\u0018M\u001d7bW\u0016T\u0011AT\u0001\u0003C&\u001c\u0001aE\u0002\u0001#^\u0003\"AU+\u000e\u0003MS\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u0013a!\u00118z%\u00164\u0007C\u0001-`\u001b\u0005I&B\u0001.\\\u00031\u00198-\u00197bY><w-\u001b8h\u0015\taV,\u0001\u0005usB,7/\u00194f\u0015\u0005q\u0016aA2p[&\u0011\u0001-\u0017\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0007tG\",W.\u0019%b]\u0012dWM\u001d\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K&\u000b\u0001\u0002[1oI2,'o]\u0005\u0003O\u0012\u0014QbU2iK6\f\u0007*\u00198eY\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0002kYB\u00111\u000eA\u0007\u0002\u0007\")\u0011M\u0001a\u0001E\u0006\u0019!/\u001e8\u0015\u0005=\u0014\bC\u0001*q\u0013\t\t8K\u0001\u0003V]&$\b\"B:\u0004\u0001\u0004!\u0018!F=nYJ\"\u0015mZ$f]\u0016\u0014\u0018\r^3D_:4\u0017n\u001a\t\u0003kbl\u0011A\u001e\u0006\u0003o\u0016\u000baaY8oM&<\u0017BA=w\u0005UIV\u000e\u001c\u001aEC\u001e<UM\\3sCR,7i\u001c8gS\u001e\f!cZ3oKJ\fG/\u001a#p[\u0006Lg\u000eR1hgR\u0019A0!\u0006\u0015\u0007u\f9\u0001\u0005\u0003\u007f\u0003\u0007yW\"A@\u000b\u0007\u0005\u00051+\u0001\u0003vi&d\u0017bAA\u0003\u007f\n\u0019AK]=\t\u000f\u0005%A\u0001q\u0001\u0002\f\u0005A1/\u001a;uS:<7\u000f\u0005\u0003\u0002\u000e\u0005EQBAA\b\u0015\t98*\u0003\u0003\u0002\u0014\u0005=!\u0001C*fiRLgnZ:\t\u000f\u0005]A\u00011\u0001\u0002\u001a\u0005\u0011Bm\\7bS:$V-\u001c9mCR,\u0007+\u0019;i!\u0011\tY\"!\u000b\u000f\t\u0005u\u0011Q\u0005\t\u0004\u0003?\u0019VBAA\u0011\u0015\r\t\u0019cT\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d2+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003O\u0019\u0016!\u00067pO\u0012\u000bwmR3oKJ\fG/[8o'R\f'\u000f\u001e\u000b\u0006_\u0006M\u00121 \u0005\b\u0003k)\u0001\u0019AA\u001c\u00031!w.\\1j]R\u000b'\r\\3t!\u0019\tI$a\u0011\u0002J9!\u00111HA \u001d\u0011\ty\"!\u0010\n\u0003QK1!!\u0011T\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0012\u0002H\t!A*[:u\u0015\r\t\te\u0015\t\u0004\u0003\u0017rR\"\u0001\u0001\u0003\u0017\u0011{W.Y5o)\u0006\u0014G.Z\n\u0007=E\u000b\t&a\u0016\u0011\u0007I\u000b\u0019&C\u0002\u0002VM\u0013q\u0001\u0015:pIV\u001cG\u000fE\u0002S\u00033J1!a\u0017T\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019!w.\\1j]V\u0011\u0011\u0011\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM%\u0002\u000b5|G-\u001a7\n\t\u0005-\u0014Q\r\u0002\u0007\t>l\u0017-\u001b8\u0002\u000f\u0011|W.Y5oA\u0005)A/\u00192mKV\u0011\u00111\u000f\t\u0005\u0003G\n)(\u0003\u0003\u0002x\u0005\u0015$AB*dQ\u0016l\u0017-\u0001\u0004uC\ndW\r\t\u000b\u0007\u0003\u0013\ni(a \t\u000f\u0005u3\u00051\u0001\u0002b!9\u0011qN\u0012A\u0002\u0005M\u0014\u0001B2paf$b!!\u0013\u0002\u0006\u0006\u001d\u0005\"CA/IA\u0005\t\u0019AA1\u0011%\ty\u0007\nI\u0001\u0002\u0004\t\u0019(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055%\u0006BA1\u0003\u001f[#!!%\u0011\t\u0005M\u0015QT\u0007\u0003\u0003+SA!a&\u0002\u001a\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037\u001b\u0016AC1o]>$\u0018\r^5p]&!\u0011qTAK\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)K\u000b\u0003\u0002t\u0005=\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002,B!\u0011QVA\\\u001b\t\tyK\u0003\u0003\u00022\u0006M\u0016\u0001\u00027b]\u001eT!!!.\u0002\t)\fg/Y\u0005\u0005\u0003W\ty+\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002>B\u0019!+a0\n\u0007\u0005\u00057KA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002H\u00065\u0007c\u0001*\u0002J&\u0019\u00111Z*\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002P&\n\t\u00111\u0001\u0002>\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!6\u0011\r\u0005]\u0017Q\\Ad\u001b\t\tINC\u0002\u0002\\N\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty.!7\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003K\fY\u000fE\u0002S\u0003OL1!!;T\u0005\u001d\u0011un\u001c7fC:D\u0011\"a4,\u0003\u0003\u0005\r!a2\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!0\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a+\u0002\r\u0015\fX/\u00197t)\u0011\t)/!?\t\u0013\u0005=g&!AA\u0002\u0005\u001d\u0007bBA\u007f\u000b\u0001\u0007\u0011\u0011D\u0001\u0011K\u001a4Wm\u0019;jm\u0016$\u0015m\u001a(b[\u0016\fqC]3t_24XmR3oKJ\fG/[8o\u0007>tg-[4\u0015\t\t\r!\u0011\u0002\t\u0005\u0003G\u0012)!\u0003\u0003\u0003\b\u0005\u0015$a\u0005#bO\u001e+g.\u001a:bi&|gnQ8oM&<\u0007bBA\u001b\r\u0001\u0007\u0011q\u0007\u0002\u0015\t\u0006<w)\u001a8fe\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0014\r\u001d\t\u0016\u0011KA,+\t\u0011\u0019!A\u0004d_:4\u0017n\u001a\u0011\u0016\u0005\tU\u0001C\u0002B\f\u00057\tI%\u0004\u0002\u0003\u001a)!\u0011\u0011AAZ\u0013\u0011\t)E!\u0007\u0002\u001b\u0011|W.Y5o)\u0006\u0014G.Z:!)\u0019\u0011\tCa\t\u0003&A\u0019\u00111J\u0004\t\r]d\u0001\u0019\u0001B\u0002\u0011\u001d\t)\u0004\u0004a\u0001\u0005+!bA!\t\u0003*\t-\u0002\u0002C<\u000e!\u0003\u0005\rAa\u0001\t\u0013\u0005UR\u0002%AA\u0002\tUQC\u0001B\u0018U\u0011\u0011\u0019!a$\u0016\u0005\tM\"\u0006\u0002B\u000b\u0003\u001f#B!a2\u00038!I\u0011q\u001a\n\u0002\u0002\u0003\u0007\u0011Q\u0018\u000b\u0005\u0003K\u0014Y\u0004C\u0005\u0002PR\t\t\u00111\u0001\u0002HR!\u0011Q\u001dB \u0011%\tymFA\u0001\u0002\u0004\t9-\u0001\u000bEC\u001e<UM\\3sCRLwN\\\"p]R,\u0007\u0010\u001e\t\u0004\u0003\u0017J2#B\r\u0003H\u0005]\u0003C\u0003B%\u0005\u001f\u0012\u0019A!\u0006\u0003\"5\u0011!1\n\u0006\u0004\u0005\u001b\u001a\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005#\u0012YEA\tBEN$(/Y2u\rVt7\r^5p]J\"\"Aa\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t\u0005\"\u0011\fB.\u0011\u00199H\u00041\u0001\u0003\u0004!9\u0011Q\u0007\u000fA\u0002\tU\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0005C\u0012i\u0007E\u0003S\u0005G\u00129'C\u0002\u0003fM\u0013aa\u00149uS>t\u0007c\u0002*\u0003j\t\r!QC\u0005\u0004\u0005W\u001a&A\u0002+va2,'\u0007C\u0005\u0003pu\t\t\u00111\u0001\u0003\"\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017\u0011{W.Y5o)\u0006\u0014G.\u001a\t\u0004\u0003\u0017\u00024#\u0002\u0019\u0003x\u0005]\u0003C\u0003B%\u0005\u001f\n\t'a\u001d\u0002JQ\u0011!1\u000f\u000b\u0007\u0003\u0013\u0012iHa \t\u000f\u0005u3\u00071\u0001\u0002b!9\u0011qN\u001aA\u0002\u0005MD\u0003\u0002BB\u0005\u000f\u0003RA\u0015B2\u0005\u000b\u0003rA\u0015B5\u0003C\n\u0019\bC\u0005\u0003pQ\n\t\u00111\u0001\u0002J\u0005\t\u0002O]8qC\u001e\fG/Z'fi\u0006$\u0017\r^1\u0015\r\u0005\u0005$Q\u0012BI\u0011\u001d\u0011y)\u000ea\u0001\u0005\u0007\t!\u0004Z3gCVdG\u000fR1h\u000f\u0016tWM]1uS>t7i\u001c8gS\u001eDq!!\u00186\u0001\u0004\t\t'\u0001\bhe>,\bOQ=EC\u001et\u0015-\\3\u0015\t\t]%\u0011\u0015\u000b\u0005\u00053\u0013y\n\u0005\u0005\u0002\u001c\tm\u0015\u0011DA\u001c\u0013\u0011\u0011i*!\f\u0003\u00075\u000b\u0007\u000fC\u0004\u0002\nY\u0002\u001d!a\u0003\t\u000f\t\rf\u00071\u0001\u0003&\u00069Am\\7bS:\u001c\bCBA\u001d\u0003\u0007\n\t'A\u0006he>,\b\u000fV1cY\u0016\u001cH\u0003\u0002BV\u0005_\u0003\u0002\"a\u0007\u0003\u001c\u0006e!Q\u0016\t\u0007\u0003s\t\u0019%a\u000e\t\u000f\tEv\u00071\u0001\u0003\u001a\u0006IA-Y4He>,\bo]\u0001&CN\u001cXM\u001d;EC\u001e<UM\\3sCRLwN\\\"p]\u001aLwMU3rk&\u0014X-\\3oiN$2! B\\\u0011\u001d\u0011\u0019\u000b\u000fa\u0001\u0005K\u000bA%Y:tKJ$H)Y4HK:,'/\u0019;j_:<%o\\;q%\u0016\fX/\u001b:f[\u0016tGo\u001d\u000b\u0004{\nu\u0006b\u0002B`s\u0001\u0007!1V\u0001\rI\u0006<\u0017I\u001c3UC\ndWm]\u0001\u000eM>\u0014X.\u0019;EC\u001et\u0015-\\3\u0015\u0015\t\u0015'\u0011\u001aBg\u0005'\u0014)\u000e\u0006\u0003\u0002\u001a\t\u001d\u0007bBA\u0005u\u0001\u000f\u00111\u0002\u0005\b\u0005\u0017T\u0004\u0019AA\r\u00039!\u0017m\u001a(b[\u0016\u0004\u0016\r\u001e;fe:DqAa4;\u0001\u0004\u0011\t.A\u0006ccB\u0013xN[3di&#\u0007#\u0002*\u0003d\u0005e\u0001bBA/u\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003_R\u0004\u0019AA\r\u0003YIV\u000e\u001c\u001aEC\u001e<UM\\3sCR,7i\\7nC:$\u0007CA6='\ta\u0014\u000b\u0006\u0002\u0003Z\u0006A1k\u0011%F\tVcU)A\u0005T\u0007\"+E)\u0016'FA\u0005!a.Y7f\u0003\u0015q\u0017-\\3!\u0001")
public class Yml2DagGenerateCommand
implements LazyLogging {
    private volatile Yml2DagGenerateCommand$DagGenerationContext$ DagGenerationContext$module;
    private volatile Yml2DagGenerateCommand$DomainTable$ DomainTable$module;
    private final SchemaHandler schemaHandler;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static String name() {
        return Yml2DagGenerateCommand$.MODULE$.name();
    }

    public static String SCHEDULE() {
        return Yml2DagGenerateCommand$.MODULE$.SCHEDULE();
    }

    public Yml2DagGenerateCommand$DagGenerationContext$ DagGenerationContext() {
        if (this.DagGenerationContext$module == null) {
            this.DagGenerationContext$lzycompute$1();
        }
        return this.DagGenerationContext$module;
    }

    public Yml2DagGenerateCommand$DomainTable$ DomainTable() {
        if (this.DomainTable$module == null) {
            this.DomainTable$lzycompute$1();
        }
        return this.DomainTable$module;
    }

    private Logger logger$lzycompute() {
        Yml2DagGenerateCommand yml2DagGenerateCommand = this;
        synchronized (yml2DagGenerateCommand) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void run(Yml2DagGenerateConfig yml2DagGenerateConfig) {
        Settings settings = Settings$.MODULE$.apply(ConfigFactory.load());
        Option<String> option = yml2DagGenerateConfig.domainTemplatePath();
        if (option instanceof Some) {
            Some some = (Some)option;
            String domainTemplatePath = (String)some.value();
            Try<BoxedUnit> try_ = this.generateDomainDags(domainTemplatePath, settings);
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(exception.getMessage(), exception);
                }
            } else if (try_ instanceof Success) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Sucessfully generated dags");
                }
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private Try<BoxedUnit> generateDomainDags(String domainTemplatePath, Settings settings) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting to generate dags");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Yml2DagTemplateLoader$.MODULE$.loadTemplate(new DomainTemplate(domainTemplatePath), settings).flatMap((Function1 & Serializable & scala.Serializable)dagTemplate -> $this.schemaHandler.loadDagGenerationConfig(DatasetArea$.MODULE$.dags(settings)).map((Function1 & Serializable & scala.Serializable)defaultDagGenerationConfig -> {
            List propagatedMetadataDomains = (List)$this.schemaHandler.domains($this.schemaHandler.domains$default$1(), $this.schemaHandler.domains$default$2()).map((Function1 & Serializable & scala.Serializable)x$1 -> this.propagateMetadata((DagGenerationConfig)defaultDagGenerationConfig, (Domain)x$1), List$.MODULE$.canBuildFrom());
            return new Tuple2(defaultDagGenerationConfig, (Object)propagatedMetadataDomains);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                List propagatedMetadataDomains = (List)tuple2._2();
                return this.assertDagGenerationConfigRequirements((List<Domain>)propagatedMetadataDomains).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                    Map<String, List<DomainTable>> dagGroups = this.groupByDagName((List<Domain>)propagatedMetadataDomains, settings);
                    Map<String, List<List<DomainTable>>> domainWithGroupedTables = this.groupTables(dagGroups);
                    return new Tuple3(x$2, dagGroups, domainWithGroupedTables);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                    Tuple3 tuple3 = x$3;
                    if (tuple3 != null) {
                        Map domainWithGroupedTables = (Map)tuple3._3();
                        return this.assertDagGenerationGroupRequirements((Map<String, List<List<DomainTable>>>)domainWithGroupedTables).map((Function1 & Serializable & scala.Serializable)_ -> {
                            Yml2DagGenerateCommand.$anonfun$generateDomainDags$7(this, domainWithGroupedTables, dagTemplate, settings, _);
                            return BoxedUnit.UNIT;
                        });
                    }
                    throw new MatchError((Object)tuple3);
                });
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private void logDagGenerationStart(List<DomainTable> domainTables, String effectiveDagName) {
        BoxedUnit boxedUnit;
        String tables = ((TraversableOnce)domainTables.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DomainTable domainTable = x0$1;
            if (domainTable != null) {
                Domain domain = domainTable.domain();
                Schema table = domainTable.table();
                return new StringBuilder(1).append(domain.name()).append(".").append(table.name()).toString();
            }
            throw new MatchError((Object)domainTable);
        }, List$.MODULE$.canBuildFrom())).mkString("\n\t - ", "\n\t - ", "");
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Generating dag {} with the following tables: {}", new Object[]{effectiveDagName, tables});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private DagGenerationConfig resolveGenerationConfig(List<DomainTable> domainTables) {
        return (DagGenerationConfig)((TraversableLike)domainTables.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.table(), List$.MODULE$.canBuildFrom())).headOption().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.metadata()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.dag()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Doesn't have any dag generation config. Should never happen.");
        });
    }

    private Domain propagateMetadata(DagGenerationConfig defaultDagGenerationConfig, Domain domain) {
        List tables;
        Metadata domainMetadata = (Metadata)domain.metadata().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Metadata(Metadata$.MODULE$.apply$default$1(), Metadata$.MODULE$.apply$default$2(), Metadata$.MODULE$.apply$default$3(), Metadata$.MODULE$.apply$default$4(), Metadata$.MODULE$.apply$default$5(), Metadata$.MODULE$.apply$default$6(), Metadata$.MODULE$.apply$default$7(), Metadata$.MODULE$.apply$default$8(), Metadata$.MODULE$.apply$default$9(), Metadata$.MODULE$.apply$default$10(), Metadata$.MODULE$.apply$default$11(), Metadata$.MODULE$.apply$default$12(), Metadata$.MODULE$.apply$default$13(), Metadata$.MODULE$.apply$default$14(), Metadata$.MODULE$.apply$default$15(), Metadata$.MODULE$.apply$default$16(), Metadata$.MODULE$.apply$default$17(), Metadata$.MODULE$.apply$default$18(), Metadata$.MODULE$.apply$default$19(), Metadata$.MODULE$.apply$default$20(), Metadata$.MODULE$.apply$default$21(), Metadata$.MODULE$.apply$default$22(), Metadata$.MODULE$.apply$default$23(), Metadata$.MODULE$.apply$default$24(), Metadata$.MODULE$.apply$default$25()));
        DagGenerationConfig mergedDomainDagGenerationConfig = (DagGenerationConfig)domainMetadata.dag().map((Function1 & Serializable & scala.Serializable)x$8 -> DagGenerationConfig$.MODULE$.dagGenerationConfigMerger(defaultDagGenerationConfig, (DagGenerationConfig)x$8)).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultDagGenerationConfig);
        Some x$1 = new Some((Object)mergedDomainDagGenerationConfig);
        Option<Mode> x$2 = domainMetadata.copy$default$1();
        Option<Format> x$3 = domainMetadata.copy$default$2();
        Option<String> x$4 = domainMetadata.copy$default$3();
        Option<Object> x$5 = domainMetadata.copy$default$4();
        Option<Object> x$6 = domainMetadata.copy$default$5();
        Option<Object> x$7 = domainMetadata.copy$default$6();
        Option<String> x$82 = domainMetadata.copy$default$7();
        Option<String> x$9 = domainMetadata.copy$default$8();
        Option<String> x$10 = domainMetadata.copy$default$9();
        Option<WriteMode> x$11 = domainMetadata.copy$default$10();
        Option<Partition> x$12 = domainMetadata.copy$default$11();
        Option<Sink> x$13 = domainMetadata.copy$default$12();
        Option<String> x$14 = domainMetadata.copy$default$13();
        Option<Seq<String>> x$15 = domainMetadata.copy$default$14();
        Option<Map<String, String>> x$16 = domainMetadata.copy$default$15();
        Option<String> x$17 = domainMetadata.copy$default$16();
        List<String> x$18 = domainMetadata.copy$default$17();
        Option<String> x$19 = domainMetadata.copy$default$18();
        Option<Map<String, String>> x$20 = domainMetadata.copy$default$19();
        Option<String> x$21 = domainMetadata.copy$default$20();
        Option<Object> x$22 = domainMetadata.copy$default$21();
        Option<Freshness> x$23 = domainMetadata.copy$default$23();
        Option<String> x$24 = domainMetadata.copy$default$24();
        boolean x$25 = domainMetadata.copy$default$25();
        Metadata mergedDomainMetadata = domainMetadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$82, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, (Option<DagGenerationConfig>)x$1, x$23, x$24, x$25);
        List x$42 = tables = (List)domain.tables().map((Function1 & Serializable & scala.Serializable)t -> {
            Metadata mergedTableMetadata = mergedDomainMetadata.merge((Metadata)t.metadata().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Metadata(Metadata$.MODULE$.apply$default$1(), Metadata$.MODULE$.apply$default$2(), Metadata$.MODULE$.apply$default$3(), Metadata$.MODULE$.apply$default$4(), Metadata$.MODULE$.apply$default$5(), Metadata$.MODULE$.apply$default$6(), Metadata$.MODULE$.apply$default$7(), Metadata$.MODULE$.apply$default$8(), Metadata$.MODULE$.apply$default$9(), Metadata$.MODULE$.apply$default$10(), Metadata$.MODULE$.apply$default$11(), Metadata$.MODULE$.apply$default$12(), Metadata$.MODULE$.apply$default$13(), Metadata$.MODULE$.apply$default$14(), Metadata$.MODULE$.apply$default$15(), Metadata$.MODULE$.apply$default$16(), Metadata$.MODULE$.apply$default$17(), Metadata$.MODULE$.apply$default$18(), Metadata$.MODULE$.apply$default$19(), Metadata$.MODULE$.apply$default$20(), Metadata$.MODULE$.apply$default$21(), Metadata$.MODULE$.apply$default$22(), Metadata$.MODULE$.apply$default$23(), Metadata$.MODULE$.apply$default$24(), Metadata$.MODULE$.apply$default$25())));
            Some x$26 = new Some((Object)mergedTableMetadata);
            String x$27 = t.copy$default$1();
            Pattern x$28 = t.copy$default$2();
            List<Attribute> x$29 = t.copy$default$3();
            Option<MergeOptions> x$30 = t.copy$default$5();
            Option<String> x$31 = t.copy$default$6();
            List<String> x$32 = t.copy$default$7();
            List<String> x$33 = t.copy$default$8();
            Set<String> x$34 = t.copy$default$9();
            List<RowLevelSecurity> x$35 = t.copy$default$10();
            Map<String, String> x$36 = t.copy$default$11();
            List<String> x$37 = t.copy$default$12();
            List<AccessControlEntry> x$38 = t.copy$default$13();
            Option<String> x$39 = t.copy$default$14();
            Option<String> x$40 = t.copy$default$15();
            Option<String> x$41 = t.copy$default$16();
            return t.copy(x$27, x$28, x$29, (Option<Metadata>)x$26, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41);
        }, List$.MODULE$.canBuildFrom());
        String x$43 = domain.copy$default$1();
        Option<String> x$44 = domain.copy$default$2();
        Option<Metadata> x$45 = domain.copy$default$3();
        List<String> x$46 = domain.copy$default$4();
        Option<String> x$47 = domain.copy$default$6();
        List<String> x$48 = domain.copy$default$7();
        Option<String> x$49 = domain.copy$default$8();
        Set<String> x$50 = domain.copy$default$9();
        Option<String> x$51 = domain.copy$default$10();
        Option<String> x$52 = domain.copy$default$11();
        return domain.copy(x$43, x$44, x$45, x$46, (List<Schema>)x$42, x$47, x$48, x$49, x$50, x$51, x$52);
    }

    private Map<String, List<DomainTable>> groupByDagName(List<Domain> domains, Settings settings) {
        return ((TraversableLike)domains.flatMap((Function1 & Serializable & scala.Serializable)d -> (List)d.tables().map((Function1 & Serializable & scala.Serializable)x$9 -> new DomainTable(this, (Domain)d, (Schema)x$9), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DomainTable domainTable = x0$1;
            if (domainTable != null) {
                Domain d = domainTable.domain();
                Schema t = domainTable.table();
                String dagNamePattern = (String)t.metadata().flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.dag()).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.dagName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> DagGenerationConfig$.MODULE$.defaultDagNamePattern());
                DatasetId datasetId = BigQueryJobBase$.MODULE$.extractProjectDataset(d.name());
                return this.formatDagName(dagNamePattern, (Option<String>)Option$.MODULE$.apply((Object)datasetId.getProject()), datasetId.getDataset(), t.name(), settings);
            }
            throw new MatchError((Object)domainTable);
        });
    }

    private Map<String, List<List<DomainTable>>> groupTables(Map<String, List<DomainTable>> dagGroups) {
        return dagGroups.mapValues((Function1 & Serializable & scala.Serializable)dagElements -> (List)((SeqLike)dagElements.groupBy((Function1 & Serializable & scala.Serializable)x$12 -> x$12.table().metadata().flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.dag())).values().toList().map((Function1 & Serializable & scala.Serializable)x$14 -> (List)x$14.sortBy((Function1 & Serializable & scala.Serializable)dt -> new StringBuilder(1).append(dt.domain().name()).append(".").append(dt.table().name()).toString(), (Ordering)Ordering.String$.MODULE$), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.size()), (Ordering)Ordering.Int$.MODULE$));
    }

    private Try<BoxedUnit> assertDagGenerationConfigRequirements(List<Domain> domains) {
        List tablesMissingRequirements = (List)((TraversableLike)domains.flatMap((Function1 & Serializable & scala.Serializable)d -> (List)d.tables().map((Function1 & Serializable & scala.Serializable)x$16 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.name()), x$16), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Yml2DagGenerateCommand.$anonfun$assertDagGenerationConfigRequirements$3(x0$1)));
        if (tablesMissingRequirements.isEmpty()) {
            return new Success((Object)BoxedUnit.UNIT);
        }
        String tableList = ((TraversableOnce)tablesMissingRequirements.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String domainName = (String)tuple2._1();
                Schema table = (Schema)tuple2._2();
                return new StringBuilder(1).append(domainName).append(".").append(table.name()).toString();
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom())).mkString(", ");
        return new Failure((Throwable)new RuntimeException(new StringBuilder(239).append("Tables did not define cluster.profileVar, cluster.region, sl.envVar or sl.jarFileUrisVar. Please set this on global dag generation config in one of the following location: dags/default.comet.yml, domain/metadata/dags, table/metadata/dags.\n").append(tableList).toString()));
    }

    private Try<BoxedUnit> assertDagGenerationGroupRequirements(Map<String, List<List<DomainTable>>> dagAndTables) {
        Map outputConflict = (Map)dagAndTables.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Yml2DagGenerateCommand.$anonfun$assertDagGenerationGroupRequirements$5(x0$1)));
        ((IterableLike)((GenericTraversableTemplate)dagAndTables.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                List dagOutputs = (List)tuple2._2();
                return dagOutputs;
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Yml2DagGenerateCommand.$anonfun$assertDagGenerationGroupRequirements$8(this, x0$3);
            return BoxedUnit.UNIT;
        });
        Iterable conflictMessages = (Iterable)outputConflict.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                String dagName = (String)tuple2._1();
                List dagOutputs = (List)tuple2._2();
                String tableList = ((TraversableOnce)((List)dagOutputs.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    Tuple2 tuple2 = x0$5;
                    if (tuple2 != null) {
                        List group = (List)tuple2._1();
                        int groupIndex = tuple2._2$mcI$sp();
                        boolean suffixWithIndex = Yml2DagGenerateCommand.extractSuffixWithIndex$1(group);
                        String tables = ((TraversableOnce)group.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                            DomainTable domainTable = x0$6;
                            if (domainTable != null) {
                                Domain domain = domainTable.domain();
                                Schema schema = domainTable.table();
                                return new StringBuilder(1).append(domain.name()).append(".").append(schema.name()).toString();
                            }
                            throw new MatchError((Object)domainTable);
                        }, List$.MODULE$.canBuildFrom())).mkString(", ");
                        return new StringBuilder(35).append("dag group ").append(groupIndex).append(" (suffix with index: ").append(suffixWithIndex).append(") : ").append(tables).toString();
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom())).mkString("\n\t -", "\n\t -", "");
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append(dagName).append(" need to generate ").append(dagOutputs.length()).append(" but more than one group disabled dag name suffix with index\n        making output conflict.").append(tableList).toString())).stripMargin().strip();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        if (conflictMessages.isEmpty()) {
            return new Success((Object)BoxedUnit.UNIT);
        }
        return new Failure((Throwable)new RuntimeException(conflictMessages.mkString("\n")));
    }

    private String formatDagName(String dagNamePattern, Option<String> bqProjectId, String domain, String table, Settings settings) {
        return Utils$.MODULE$.parseJinjaTpl(dagNamePattern, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bq_project_id"), bqProjectId.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"domain"), (Object)domain), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table)}))), settings);
    }

    private final void DagGenerationContext$lzycompute$1() {
        Yml2DagGenerateCommand yml2DagGenerateCommand = this;
        synchronized (yml2DagGenerateCommand) {
            if (this.DagGenerationContext$module == null) {
                this.DagGenerationContext$module = new Yml2DagGenerateCommand$DagGenerationContext$(this);
            }
        }
    }

    private final void DomainTable$lzycompute$1() {
        Yml2DagGenerateCommand yml2DagGenerateCommand = this;
        synchronized (yml2DagGenerateCommand) {
            if (this.DomainTable$module == null) {
                this.DomainTable$module = new Yml2DagGenerateCommand$DomainTable$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$generateDomainDags$9(Yml2DagGenerateCommand $this, String dagName$1, String dagTemplate$1, Settings settings$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            Some some;
            boolean bl;
            List domainTables = (List)tuple2._1();
            int i = tuple2._2$mcI$sp();
            DagGenerationConfig dagGenerationConfig = $this.resolveGenerationConfig((List<DomainTable>)domainTables);
            Option<Object> option = dagGenerationConfig.suffixWithIndex();
            String effectiveDagName = (option instanceof Some && true == (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? true : None$.MODULE$.equals(option)) ? new StringBuilder(1).append(dagName$1).append("-").append(i).toString() : dagName$1;
            $this.logDagGenerationStart((List<DomainTable>)domainTables, effectiveDagName);
            String dag = Utils$.MODULE$.parseJinjaTpl(dagTemplate$1, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sl"), (Object)new DagGenerationContext($this, dagGenerationConfig, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)domainTables).asJava())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"env"), JavaConverters$.MODULE$.mapAsJavaMapConverter($this.schemaHandler.activeEnv($this.schemaHandler.activeEnv$default$1())).asJava())}))), settings$1);
            Path outputPath = Path.mergePaths((Path)DatasetArea$.MODULE$.dags(settings$1), (Path)new Path(new StringBuilder(22).append("/generated/domains/").append(effectiveDagName).append(".py").toString()));
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Writing dag to {}", new Object[]{outputPath});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            settings$1.storageHandler().write(dag, outputPath, StandardCharsets.UTF_8);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$generateDomainDags$7(Yml2DagGenerateCommand $this, Map domainWithGroupedTables$1, String dagTemplate$1, Settings settings$1, BoxedUnit _) {
        BoxedUnit boxedUnit;
        domainWithGroupedTables$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String dagName = (String)tuple2._1();
                List dagGroups = (List)tuple2._2();
                return (List)((List)dagGroups.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Yml2DagGenerateCommand.$anonfun$generateDomainDags$9($this, dagName, dagTemplate$1, settings$1, x0$2);
                    return BoxedUnit.UNIT;
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        });
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Successfully generated dags");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.println((Object)"Successfully generated dags");
    }

    public static final /* synthetic */ boolean $anonfun$assertDagGenerationConfigRequirements$6(ClusterConfig cluster) {
        return cluster.region().isDefined() && cluster.profileVar().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$assertDagGenerationConfigRequirements$7(SlConfig slc) {
        return slc.envVar().isDefined() && slc.jarFileUrisVar().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$assertDagGenerationConfigRequirements$5(DagGenerationConfig conf) {
        return conf.cluster().isDefined() && conf.cluster().exists((Function1 & Serializable & scala.Serializable)cluster -> BoxesRunTime.boxToBoolean((boolean)Yml2DagGenerateCommand.$anonfun$assertDagGenerationConfigRequirements$6(cluster))) && conf.sl().isDefined() && conf.sl().exists((Function1 & Serializable & scala.Serializable)slc -> BoxesRunTime.boxToBoolean((boolean)Yml2DagGenerateCommand.$anonfun$assertDagGenerationConfigRequirements$7(slc)));
    }

    public static final /* synthetic */ boolean $anonfun$assertDagGenerationConfigRequirements$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Schema table = (Schema)tuple2._2();
            return !table.metadata().flatMap((Function1 & Serializable & scala.Serializable)x$17 -> x$17.dag()).exists((Function1 & Serializable & scala.Serializable)conf -> BoxesRunTime.boxToBoolean((boolean)Yml2DagGenerateCommand.$anonfun$assertDagGenerationConfigRequirements$5(conf)));
        }
        throw new MatchError((Object)tuple2);
    }

    private static final boolean extractSuffixWithIndex$1(List group) {
        return BoxesRunTime.unboxToBoolean((Object)group.headOption().flatMap((Function1 & Serializable & scala.Serializable)x$18 -> x$18.table().metadata().flatMap((Function1 & Serializable & scala.Serializable)x$19 -> x$19.dag()).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> x$20.suffixWithIndex())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DagGenerationConfig$.MODULE$.defaultSuffixWithIndex()));
    }

    public static final /* synthetic */ boolean $anonfun$assertDagGenerationGroupRequirements$6(List x$21) {
        return !Yml2DagGenerateCommand.extractSuffixWithIndex$1(x$21);
    }

    public static final /* synthetic */ boolean $anonfun$assertDagGenerationGroupRequirements$5(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            List dagOutputs = (List)tuple2._2();
            return dagOutputs.size() > 1 && dagOutputs.count((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)Yml2DagGenerateCommand.$anonfun$assertDagGenerationGroupRequirements$6(x$21))) > 1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$assertDagGenerationGroupRequirements$8(Yml2DagGenerateCommand $this, DomainTable x0$3) {
        DomainTable domainTable = x0$3;
        if (domainTable != null) {
            Domain domain = domainTable.domain();
            Schema table = domainTable.table();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(2).append(domain.name()).append(".").append(table.name()).append(":").append(table.metadata().flatMap((Function1 & Serializable & scala.Serializable)x$22 -> x$22.dag()).flatMap((Function1 & Serializable & scala.Serializable)x$23 -> x$23.suffixWithIndex()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)).toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)domainTable);
    }

    public Yml2DagGenerateCommand(SchemaHandler schemaHandler) {
        this.schemaHandler = schemaHandler;
        LazyLogging.$init$((LazyLogging)this);
    }

    public class DagGenerationContext
    implements Product,
    scala.Serializable {
        private final DagGenerationConfig config;
        private final java.util.List<DomainTable> domainTables;
        public final /* synthetic */ Yml2DagGenerateCommand $outer;

        public DagGenerationConfig config() {
            return this.config;
        }

        public java.util.List<DomainTable> domainTables() {
            return this.domainTables;
        }

        public DagGenerationContext copy(DagGenerationConfig config, java.util.List<DomainTable> domainTables) {
            return new DagGenerationContext(this.ai$starlake$schema$generator$yml2dag$command$Yml2DagGenerateCommand$DagGenerationContext$$$outer(), config, domainTables);
        }

        public DagGenerationConfig copy$default$1() {
            return this.config();
        }

        public java.util.List<DomainTable> copy$default$2() {
            return this.domainTables();
        }

        public String productPrefix() {
            return "DagGenerationContext";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.config();
                }
                case 1: {
                    return this.domainTables();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DagGenerationContext;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DagGenerationContext)) return false;
            if (((DagGenerationContext)object).ai$starlake$schema$generator$yml2dag$command$Yml2DagGenerateCommand$DagGenerationContext$$$outer() != this.ai$starlake$schema$generator$yml2dag$command$Yml2DagGenerateCommand$DagGenerationContext$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DagGenerationContext dagGenerationContext = (DagGenerationContext)x$1;
            DagGenerationConfig dagGenerationConfig = this.config();
            DagGenerationConfig dagGenerationConfig2 = dagGenerationContext.config();
            if (dagGenerationConfig == null) {
                if (dagGenerationConfig2 != null) {
                    return false;
                }
            } else if (!((Object)dagGenerationConfig).equals(dagGenerationConfig2)) return false;
            java.util.List<DomainTable> list = this.domainTables();
            java.util.List<DomainTable> list2 = dagGenerationContext.domainTables();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!((Object)list).equals(list2)) return false;
            if (!dagGenerationContext.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Yml2DagGenerateCommand ai$starlake$schema$generator$yml2dag$command$Yml2DagGenerateCommand$DagGenerationContext$$$outer() {
            return this.$outer;
        }

        public DagGenerationContext(Yml2DagGenerateCommand $outer, DagGenerationConfig config, java.util.List<DomainTable> domainTables) {
            this.config = config;
            this.domainTables = domainTables;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class DomainTable
    implements Product,
    scala.Serializable {
        private final Domain domain;
        private final Schema table;
        public final /* synthetic */ Yml2DagGenerateCommand $outer;

        public Domain domain() {
            return this.domain;
        }

        public Schema table() {
            return this.table;
        }

        public DomainTable copy(Domain domain, Schema table) {
            return new DomainTable(this.ai$starlake$schema$generator$yml2dag$command$Yml2DagGenerateCommand$DomainTable$$$outer(), domain, table);
        }

        public Domain copy$default$1() {
            return this.domain();
        }

        public Schema copy$default$2() {
            return this.table();
        }

        public String productPrefix() {
            return "DomainTable";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.domain();
                }
                case 1: {
                    return this.table();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DomainTable;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DomainTable)) return false;
            if (((DomainTable)object).ai$starlake$schema$generator$yml2dag$command$Yml2DagGenerateCommand$DomainTable$$$outer() != this.ai$starlake$schema$generator$yml2dag$command$Yml2DagGenerateCommand$DomainTable$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DomainTable domainTable = (DomainTable)x$1;
            Domain domain = this.domain();
            Domain domain2 = domainTable.domain();
            if (domain == null) {
                if (domain2 != null) {
                    return false;
                }
            } else if (!((Object)domain).equals(domain2)) return false;
            Schema schema = this.table();
            Schema schema2 = domainTable.table();
            if (schema == null) {
                if (schema2 != null) {
                    return false;
                }
            } else if (!((Object)schema).equals(schema2)) return false;
            if (!domainTable.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Yml2DagGenerateCommand ai$starlake$schema$generator$yml2dag$command$Yml2DagGenerateCommand$DomainTable$$$outer() {
            return this.$outer;
        }

        public DomainTable(Yml2DagGenerateCommand $outer, Domain domain, Schema table) {
            this.domain = domain;
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

