/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.handlers;

import ai.starlake.config.Settings;
import ai.starlake.job.sink.bigquery.BigQueryLoadCliConfig;
import ai.starlake.job.sink.es.ESLoadConfig;
import ai.starlake.job.sink.jdbc.ConnectionLoadConfig;
import ai.starlake.schema.handlers.LaunchHandler;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Schema;
import ai.starlake.utils.AirflowJobResult;
import ai.starlake.utils.JobResult;
import ai.starlake.workflow.IngestionWorkflow;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0004\t\u0001EAQA\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005\u0012)BQA\u0012\u0001\u0005B\u001dCq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J\ty\u0011)\u001b:gY><H*Y;oG\",'O\u0003\u0002\n\u0015\u0005A\u0001.\u00198eY\u0016\u00148O\u0003\u0002\f\u0019\u000511o\u00195f[\u0006T!!\u0004\b\u0002\u0011M$\u0018M\u001d7bW\u0016T\u0011aD\u0001\u0003C&\u001c\u0001a\u0005\u0003\u0001%aa\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a55\t\u0001\"\u0003\u0002\u001c\u0011\tiA*Y;oG\"D\u0015M\u001c3mKJ\u0004\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0005\u0012\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\r\n1aY8n\u0013\t)cDA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u0007\u0001\u0002\tA|7\u000f\u001e\u000b\u0004W]\"\u0005c\u0001\u00170c5\tQF\u0003\u0002/)\u0005!Q\u000f^5m\u0013\t\u0001TFA\u0002Uef\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0007\u0002\u000bU$\u0018\u000e\\:\n\u0005Y\u001a$\u0001E!je\u001adwn\u001e&pEJ+7/\u001e7u\u0011\u0015A$\u00011\u0001:\u0003\r)(\u000f\u001c\t\u0003u\u0005s!aO \u0011\u0005q\"R\"A\u001f\u000b\u0005y\u0002\u0012A\u0002\u001fs_>$h(\u0003\u0002A)\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001E\u0003C\u0003F\u0005\u0001\u0007\u0011(A\u0004d_6l\u0017M\u001c3\u0002\r%tw-Z:u)\u0019AU\u000b\u00183i\u007fR\u0011\u0011*\u0014\t\u0004Y=R\u0005C\u0001\u001aL\u0013\ta5GA\u0005K_\n\u0014Vm];mi\")aj\u0001a\u0002\u001f\u0006A1/\u001a;uS:<7\u000f\u0005\u0002Q'6\t\u0011K\u0003\u0002S\u0019\u000511m\u001c8gS\u001eL!\u0001V)\u0003\u0011M+G\u000f^5oONDQAV\u0002A\u0002]\u000b\u0001b^8sW\u001adwn\u001e\t\u00031jk\u0011!\u0017\u0006\u0003-2I!aW-\u0003#%sw-Z:uS>twk\u001c:lM2|w\u000fC\u0003^\u0007\u0001\u0007a,\u0001\u0004e_6\f\u0017N\u001c\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C*\tQ!\\8eK2L!a\u00191\u0003\r\u0011{W.Y5o\u0011\u0015Y1\u00011\u0001f!\tyf-\u0003\u0002hA\n11k\u00195f[\u0006DQ![\u0002A\u0002)\fQ\u0001]1uQN\u00042a\u001b9t\u001d\tagN\u0004\u0002=[&\tQ#\u0003\u0002p)\u00059\u0001/Y2lC\u001e,\u0017BA9s\u0005\u0011a\u0015n\u001d;\u000b\u0005=$\u0002C\u0001;~\u001b\u0005)(B\u0001<x\u0003\t17O\u0003\u0002ys\u00061\u0001.\u00193p_BT!A_>\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0018aA8sO&\u0011a0\u001e\u0002\u0005!\u0006$\b\u000eC\u0004\u0002\u0002\r\u0001\r!a\u0001\u0002\u000f=\u0004H/[8ogB)!(!\u0002:s%\u0019\u0011qA\"\u0003\u00075\u000b\u0007/\u0001\u0004fg2{\u0017\r\u001a\u000b\u0007\u0003\u001b\t9\"!\u0007\u0015\t\u0005=\u0011Q\u0003\t\u0004'\u0005E\u0011bAA\n)\t9!i\\8mK\u0006t\u0007\"\u0002(\u0005\u0001\by\u0005\"\u0002,\u0005\u0001\u00049\u0006B\u0002*\u0005\u0001\u0004\tY\u0002\u0005\u0003\u0002\u001e\u0005-RBAA\u0010\u0015\u0011\t\t#a\t\u0002\u0005\u0015\u001c(\u0002BA\u0013\u0003O\tAa]5oW*\u0019\u0011\u0011\u0006\u0007\u0002\u0007)|'-\u0003\u0003\u0002.\u0005}!\u0001D#T\u0019>\fGmQ8oM&<\u0017A\u00022rY>\fG\r\u0006\u0004\u00024\u0005]\u0012\u0011\b\u000b\u0005\u0003\u001f\t)\u0004C\u0003O\u000b\u0001\u000fq\nC\u0003W\u000b\u0001\u0007q\u000b\u0003\u0004S\u000b\u0001\u0007\u00111\b\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)!\u0011\u0011IA\u0012\u0003!\u0011\u0017nZ9vKJL\u0018\u0002BA#\u0003\u007f\u0011QCQ5h#V,'/\u001f'pC\u0012\u001cE.[\"p]\u001aLw-\u0001\u0005kI\n\u001cGn\\1e)\u0019\tY%a\u0014\u0002RQ!\u0011qBA'\u0011\u0015qe\u0001q\u0001P\u0011\u00151f\u00011\u0001X\u0011\u0019\u0011f\u00011\u0001\u0002TA!\u0011QKA.\u001b\t\t9F\u0003\u0003\u0002Z\u0005\r\u0012\u0001\u00026eE\u000eLA!!\u0018\u0002X\t!2i\u001c8oK\u000e$\u0018n\u001c8M_\u0006$7i\u001c8gS\u001e\u0004")
public class AirflowLauncher
implements LaunchHandler,
StrictLogging {
    private final Logger logger;

    @Override
    public Try<JobResult> ingest(IngestionWorkflow workflow, Domain domain, Schema schema, Path path, Map<String, String> options, Settings settings) {
        return LaunchHandler.ingest$(this, workflow, domain, schema, path, options, settings);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Try<AirflowJobResult> post(String url, String command) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            String json = new StringBuilder(29).append("{\"conf\":\"{\\\"command\\\":\\\"").append(command).append("\\\"}\"}").toString();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("JSON to post to Airflow: {}", new Object[]{json});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            CloseableHttpClient client = HttpClients.createDefault();
            StringEntity requestEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)requestEntity);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(21).append("Posting to Airflow: ").append(httpPost.getURI().toString()).append("\n").append(EntityUtils.toString((HttpEntity)httpPost.getEntity(), (String)"UTF-8")).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(26).append("Post result from Airflow: ").append(responseBody).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            client.close();
            return new AirflowJobResult(responseBody);
        });
    }

    @Override
    public Try<JobResult> ingest(IngestionWorkflow workflow, Domain domain, Schema schema, List<Path> paths, Map<String, String> options, Settings settings) {
        String endpoint = settings.comet().airflow().endpoint();
        String ingest = settings.comet().airflow().ingest();
        String url = new StringBuilder(15).append(endpoint).append("/dags/").append(ingest).append("/dag_runs").toString();
        String command = new StringBuilder(9).append("ingest ").append(domain.name()).append(" ").append(schema.name()).append(" ").append(paths.mkString(",")).toString();
        Thread.sleep(1000L);
        return this.post(url, command);
    }

    @Override
    public boolean esLoad(IngestionWorkflow workflow, ESLoadConfig config, Settings settings) {
        String endpoint = settings.comet().airflow().endpoint();
        String url = new StringBuilder(26).append(endpoint).append("/dags/comet_index/dag_runs").toString();
        String resource = new .colon.colon((Object)new StringBuilder(12).append("--timestamp ").append(config.timestamp()).toString(), (List)new .colon.colon((Object)new StringBuilder(9).append("--domain ").append(config.domain()).toString(), (List)new .colon.colon((Object)new StringBuilder(9).append("--schema ").append(config.schema()).toString(), (List)new .colon.colon((Object)new StringBuilder(9).append("--format ").append(config.format()).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("--dataset ").append(config.getDataset(settings)).toString(), (List)Nil$.MODULE$))))).mkString(" ");
        Option id2 = config.id().map((Function1 & Serializable & scala.Serializable)id -> new StringBuilder(5).append("--id ").append((String)id).toString());
        Option mapping = config.mapping().map((Function1 & Serializable & scala.Serializable)path -> new StringBuilder(10).append("--mapping ").append(path.toString()).toString());
        String params = ((TraversableOnce)new .colon.colon((Object)new Some((Object)resource), (List)new .colon.colon((Object)id2, (List)new .colon.colon((Object)mapping, (List)Nil$.MODULE$))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).mkString(" ");
        String command = new StringBuilder(7).append("index ").append(params).append(" ").toString();
        return this.post(url, command).isSuccess();
    }

    @Override
    public boolean bqload(IngestionWorkflow workflow, BigQueryLoadCliConfig config, Settings settings) {
        String endpoint = settings.comet().airflow().endpoint();
        String url = new StringBuilder(27).append(endpoint).append("/dags/comet_bqload/dag_runs").toString();
        String params = new .colon.colon((Object)new StringBuilder(14).append("--source_file ").append(config.source()).toString(), (List)new .colon.colon((Object)new StringBuilder(17).append("--output_dataset ").append(config.outputDataset()).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("--output_table ").append(config.outputTable()).toString(), (List)new .colon.colon((Object)new StringBuilder(16).append("--source_format ").append(config.sourceFormat()).toString(), (List)new .colon.colon((Object)new StringBuilder(21).append("--create_disposition ").append(config.createDisposition()).toString(), (List)new .colon.colon((Object)new StringBuilder(20).append("--write_disposition ").append(config.writeDisposition()).toString(), (List)new .colon.colon((Object)((String)config.outputPartition().map((Function1 & Serializable & scala.Serializable)partition -> new StringBuilder(19).append("--output_partition ").append((String)partition).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)Nil$.MODULE$))))))).mkString(" ");
        String command = new StringBuilder(8).append("bqload ").append(params).append(" ").toString();
        return this.post(url, command).isSuccess();
    }

    @Override
    public boolean jdbcload(IngestionWorkflow workflow, ConnectionLoadConfig config, Settings settings) {
        String endpoint = settings.comet().airflow().endpoint();
        String url = new StringBuilder(29).append(endpoint).append("/dags/comet_jdbcload/dag_runs").toString();
        String params = new .colon.colon((Object)new StringBuilder(14).append("--source_file ").append(config.sourceFile()).toString(), (List)new .colon.colon((Object)"--options partitions=1000,user=sa,password=sa,batch_size=1,driver=org.postgresqlDriver,url=jdbc:postgresql:...", (List)new .colon.colon((Object)"--format=jdbc", (List)new .colon.colon((Object)new StringBuilder(21).append("--create_disposition ").append(config.createDisposition()).toString(), (List)new .colon.colon((Object)new StringBuilder(20).append("--write_disposition ").append(config.writeDisposition()).toString(), (List)Nil$.MODULE$))))).mkString(" ");
        String command = new StringBuilder(10).append("jdbcload ").append(params).append(" ").toString();
        return this.post(url, command).isSuccess();
    }

    public AirflowLauncher() {
        LaunchHandler.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
    }
}

