/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.handlers;

import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.utils.conversion.Conversions$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\u0015+\u0001MB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0006\u0017\")\u0011\u000b\u0001C\u0001%\"9q\u000b\u0001b\u0001\n\u0003A\u0006B\u00023\u0001A\u0003%\u0011\fC\u0004f\u0001\t\u0007I\u0011\u00014\t\r=\u0004\u0001\u0015!\u0003h\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u0015Q\b\u0001\"\u0003|\u0011!i\b\u0001#b\u0001\n\u0013q\bBB@\u0001\t\u0003\t\t\u0001C\u0004\u0002\u0014\u0001!\t!!\u0001\t\u0013\u0005U\u0001A1A\u0005\n\u0005]\u0001\u0002CA\u0013\u0001\u0001\u0006I!!\u0007\t\u000f\u0005}\u0001\u0001\"\u0001\u0002(!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\n\u0003G\u0002\u0011\u0013!C\u0001\u0003KBq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002\u0010\u0002!\t!!%\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006\"CA|\u0001E\u0005I\u0011AA}\u0011\u001d\ti\u0010\u0001C!\u0003\u007fDqA!\u0003\u0001\t\u0003\u0011Y\u0001C\u0004\u0003\u0014\u0001!\tA!\u0006\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!9!q\u0004\u0001\u0005\u0002\t\u0005\u0002b\u0002B\u0015\u0001\u0011\u0005!1\u0006\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wAqAa\u0010\u0001\t\u0003\u0011\t\u0005C\u0004\u0003L\u0001!\tA!\u0014\t\u000f\tE\u0003\u0001\"\u0001\u0003T!9!Q\u0012\u0001\u0005\u0002\t=\u0005b\u0002BN\u0001\u0011\u0005!Q\u0014\u0005\b\u0005C\u0003A\u0011\u0001BR\u000f\u001d\u0011)K\u000bE\u0001\u0005O3a!\u000b\u0016\t\u0002\t%\u0006BB)(\t\u0003\u0011YK\u0001\nII\u001a\u001c8\u000b^8sC\u001e,\u0007*\u00198eY\u0016\u0014(BA\u0016-\u0003!A\u0017M\u001c3mKJ\u001c(BA\u0017/\u0003\u0019\u00198\r[3nC*\u0011q\u0006M\u0001\tgR\f'\u000f\\1lK*\t\u0011'\u0001\u0002bS\u000e\u00011c\u0001\u00015uA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t1\u0011I\\=SK\u001a\u0004\"a\u000f\u001f\u000e\u0003)J!!\u0010\u0016\u0003\u001dM#xN]1hK\"\u000bg\u000e\u001a7fe\u0006Qa-\u001b7f'f\u001cH/Z7\u0011\u0005\u0001;eBA!F!\t\u0011e'D\u0001D\u0015\t!%'\u0001\u0004=e>|GOP\u0005\u0003\rZ\na\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011aIN\u0001\tg\u0016$H/\u001b8hgB\u0011AjT\u0007\u0002\u001b*\u0011aJL\u0001\u0007G>tg-[4\n\u0005Ak%\u0001C*fiRLgnZ:\u0002\rqJg.\u001b;?)\t\u0019f\u000b\u0006\u0002U+B\u00111\b\u0001\u0005\u0006\u0015\u000e\u0001\u001da\u0013\u0005\u0006}\r\u0001\raP\u0001\u0005G>tg-F\u0001Z!\tQ&-D\u0001\\\u0015\t9FL\u0003\u0002^=\u00061\u0001.\u00193p_BT!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111m\u0017\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000b\r|gN\u001a\u0011\u0002\u0017\u001d\u001b5+\u0016:j%\u0016<W\t_\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\t[\u0006$8\r[5oO*\u0011ANN\u0001\u0005kRLG.\u0003\u0002oS\n)!+Z4fq\u0006aqiQ*Ve&\u0014VmZ#yA\u0005\u0001S\r\u001f;sC\u000e\u001c6\r[3nK\u0006sGMQ;dW\u0016$\u0018I\u001c3GS2,\u0007+\u0019;i)\t\u0011\b\u0010E\u00036g~*x(\u0003\u0002um\t1A+\u001e9mKN\u00022!\u000e<@\u0013\t9hG\u0001\u0004PaRLwN\u001c\u0005\u0006s\"\u0001\raP\u0001\u0004kJL\u0017\u0001\u00068pe6\fG.\u001b>fI\u001aKG.Z*zgR,W\u000e\u0006\u0002@y\")a(\u0003a\u0001\u007f\u0005YB-\u001a4bk2$hj\u001c:nC2L'0\u001a3GS2,7+_:uK6,\u0012aP\u0001\u0018Y>\u001c7.Q2rk&\u001c\u0018\u000e^5p]B{G\u000e\u001c+j[\u0016,\"!a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005AA-\u001e:bi&|gNC\u0002\u0002\u000eY\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\t\"a\u0002\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\u0019Bn\\2l%\u00164'/Z:i!>dG\u000eV5nK\u0006IA-\u001a4bk2$hiU\u000b\u0003\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?a\u0016A\u00014t\u0013\u0011\t\u0019#!\b\u0003\u0015\u0019KG.Z*zgR,W.\u0001\u0006eK\u001a\fW\u000f\u001c;G'\u0002\"B!!\u0007\u0002*!9\u00111F\bA\u0002\u00055\u0012!C5oaV$\b+\u0019;i!\u0011\tY\"a\f\n\t\u0005E\u0012Q\u0004\u0002\u0005!\u0006$\b.A\bhKR|U\u000f\u001e9viN#(/Z1n)\u0011\t9$a\u0012\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005\u0011\u0011n\u001c\u0006\u0003\u0003\u0003\nAA[1wC&!\u0011QIA\u001e\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001d\tI\u0005\u0005a\u0001\u0003[\tA\u0001]1uQ\u0006!!/Z1e)\u0015y\u0014qJA)\u0011\u001d\tI%\u0005a\u0001\u0003[A\u0011\"a\u0015\u0012!\u0003\u0005\r!!\u0016\u0002\u000f\rD\u0017M]:fiB!\u0011qKA0\u001b\t\tIF\u0003\u0003\u0002T\u0005m#\u0002BA/\u0003\u007f\t1A\\5p\u0013\u0011\t\t'!\u0017\u0003\u000f\rC\u0017M]:fi\u0006q!/Z1eI\u0011,g-Y;mi\u0012\u0012TCAA4U\u0011\t)&!\u001b,\u0005\u0005-\u0004\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001e7\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\nyGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQa\u001e:ji\u0016$b!a \u0002\n\u00065E\u0003BAA\u0003\u000f\u00032!NAB\u0013\r\t)I\u000e\u0002\u0005+:LG\u000fC\u0005\u0002TM\u0001\n\u0011q\u0001\u0002V!1\u00111R\nA\u0002}\nA\u0001Z1uC\"9\u0011\u0011J\nA\u0002\u00055\u0012aC<sSR,')\u001b8bef$b!!!\u0002\u0014\u0006\u0005\u0006bBAF)\u0001\u0007\u0011Q\u0013\t\u0006k\u0005]\u00151T\u0005\u0004\u000333$!B!se\u0006L\bcA\u001b\u0002\u001e&\u0019\u0011q\u0014\u001c\u0003\t\tKH/\u001a\u0005\b\u0003\u0013\"\u0002\u0019AA\u0017\u0003=a\u0017n\u001d;ESJ,7\r^8sS\u0016\u001cH\u0003BAT\u0003s\u0003b!!+\u00024\u00065b\u0002BAV\u0003_s1AQAW\u0013\u00059\u0014bAAYm\u00059\u0001/Y2lC\u001e,\u0017\u0002BA[\u0003o\u0013A\u0001T5ti*\u0019\u0011\u0011\u0017\u001c\t\u000f\u0005%S\u00031\u0001\u0002.\u0005!A.[:u)9\t9+a0\u0002B\u0006\u0015\u0017Q[Ap\u0003gDq!!\u0013\u0017\u0001\u0004\ti\u0003\u0003\u0005\u0002DZ\u0001\n\u00111\u0001@\u0003%)\u0007\u0010^3og&|g\u000eC\u0005\u0002HZ\u0001\n\u00111\u0001\u0002J\u0006)1/\u001b8dKB!\u00111ZAi\u001b\t\tiM\u0003\u0003\u0002P\u0006}\u0012\u0001\u0002;j[\u0016LA!a5\u0002N\niAj\\2bY\u0012\u000bG/\u001a+j[\u0016Dq!a6\u0017\u0001\u0004\tI.A\u0005sK\u000e,(o]5wKB\u0019Q'a7\n\u0007\u0005ugGA\u0004C_>dW-\u00198\t\u0013\u0005\u0005h\u0003%AA\u0002\u0005\r\u0018aB3yG2,H-\u001a\t\u0005kY\f)\u000f\u0005\u0003\u0002h\u0006=XBAAu\u0015\u0011\tY/!<\u0002\u000bI,w-\u001a=\u000b\u00071\fy$\u0003\u0003\u0002r\u0006%(a\u0002)biR,'O\u001c\u0005\n\u0003k4\u0002\u0013!a\u0001\u00033\f!b]8si\nKh*Y7f\u00039a\u0017n\u001d;%I\u00164\u0017-\u001e7uIY*\"!a?+\t\u0005e\u0017\u0011N\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002Z\n\u0005!Q\u0001\u0005\b\u0005\u0007A\u0002\u0019AA\u0017\u0003\r\u0019(o\u0019\u0005\b\u0005\u000fA\u0002\u0019AA\u0017\u0003\r!7\u000f^\u0001\u0005[>4X\r\u0006\u0004\u0002Z\n5!q\u0002\u0005\b\u0005\u0007I\u0002\u0019AA\u0017\u0011\u001d\u0011\t\"\u0007a\u0001\u0003[\tA\u0001Z3ti\u00061A-\u001a7fi\u0016$B!!7\u0003\u0018!9\u0011\u0011\n\u000eA\u0002\u00055\u0012AB7lI&\u00148\u000f\u0006\u0003\u0002Z\nu\u0001bBA%7\u0001\u0007\u0011QF\u0001\u000eG>\u0004\u0018P\u0012:p[2{7-\u00197\u0015\r\u0005\u0005%1\u0005B\u0014\u0011\u001d\u0011)\u0003\ba\u0001\u0003[\taa]8ve\u000e,\u0007b\u0002B\t9\u0001\u0007\u0011QF\u0001\fG>\u0004\u0018\u0010V8M_\u000e\fG\u000e\u0006\u0004\u0002\u0002\n5\"q\u0006\u0005\b\u0005Ki\u0002\u0019AA\u0017\u0011\u001d\u0011\t\"\ba\u0001\u0003[\tQ\"\\8wK\u001a\u0013x.\u001c'pG\u0006dGCBAA\u0005k\u00119\u0004C\u0004\u0003&y\u0001\r!!\f\t\u000f\tEa\u00041\u0001\u0002.\u00051Q\r_5tiN$B!!7\u0003>!9\u0011\u0011J\u0010A\u0002\u00055\u0012!\u00032m_\u000e\\7+\u001b>f)\u0011\u0011\u0019E!\u0013\u0011\u0007U\u0012)%C\u0002\u0003HY\u0012A\u0001T8oO\"9\u0011\u0011\n\u0011A\u0002\u00055\u0012!D:qC\u000e,7i\u001c8tk6,G\r\u0006\u0003\u0003D\t=\u0003bBA%C\u0001\u0007\u0011QF\u0001\rY\u0006\u001cH/T8eS\u001aLW\r\u001a\u000b\u0005\u0005+\u0012Y\t\u0005\u0003\u0003X\t\u0015e\u0002\u0002B-\u0005\u007frAAa\u0017\u0003z9!!Q\fB:\u001d\u0011\u0011yF!\u001c\u000f\t\t\u0005$\u0011\u000e\b\u0005\u0005G\u00129GD\u0002C\u0005KJ\u0011!Y\u0005\u0003?\u0002L1Aa\u001b_\u0003\u0015\u0019\b/\u0019:l\u0013\u0011\u0011yG!\u001d\u0002\u0007M\fHNC\u0002\u0003lyKAA!\u001e\u0003x\u0005IQ\r_3dkRLwN\u001c\u0006\u0005\u0005_\u0012\t(\u0003\u0003\u0003|\tu\u0014!C:ue\u0016\fW.\u001b8h\u0015\u0011\u0011)Ha\u001e\n\t\t\u0005%1Q\u0001\u0011\r&dWm\u0015;sK\u0006l7k\\;sG\u0016TAAa\u001f\u0003~%!!q\u0011BE\u0005%!\u0016.\\3ti\u0006l\u0007O\u0003\u0003\u0003\u0002\n\r\u0005bBA%E\u0001\u0007\u0011QF\u0001\u0007i>,8\r\u001b>\u0015\t\tE%\u0011\u0014\t\u0007\u0005'\u0013)*!!\u000e\u0003-L1Aa&l\u0005\r!&/\u001f\u0005\b\u0003\u0013\u001a\u0003\u0019AA\u0017\u0003\u0015!x.^2i)\u0011\u0011\tJa(\t\u000f\u0005%C\u00051\u0001\u0002.\u0005Iq-\u001a;TG\",W.\u001a\u000b\u0002\u007f\u0005\u0011\u0002\n\u001a4t'R|'/Y4f\u0011\u0006tG\r\\3s!\tYte\u0005\u0002(iQ\u0011!q\u0015")
public class HdfsStorageHandler
implements StorageHandler {
    private String defaultNormalizedFileSystem;
    private String fileSystem;
    private final Settings settings;
    private final Configuration conf;
    private final Regex GCSUriRegEx;
    private final FileSystem defaultFS;
    private final Map<String, String> extraConf;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public Option<Path> moveSparkPartFile(Path sparkFolder, String extension) {
        return StorageHandler.moveSparkPartFile$(this, sparkFolder, extension);
    }

    @Override
    public Charset write$default$3(String data, Path path) {
        return StorageHandler.write$default$3$(this, data, path);
    }

    @Override
    public String list$default$2() {
        return StorageHandler.list$default$2$(this);
    }

    @Override
    public LocalDateTime list$default$3() {
        return StorageHandler.list$default$3$(this);
    }

    @Override
    public Option<Pattern> list$default$5() {
        return StorageHandler.list$default$5$(this);
    }

    @Override
    public Map<String, String> extraConf() {
        return this.extraConf;
    }

    @Override
    public void ai$starlake$schema$handlers$StorageHandler$_setter_$extraConf_$eq(Map<String, String> x$1) {
        this.extraConf = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Configuration conf() {
        return this.conf;
    }

    public Regex GCSUriRegEx() {
        return this.GCSUriRegEx;
    }

    private Tuple3<String, Option<String>, String> extracSchemeAndBucketAndFilePath(String uri) {
        Option option;
        String string = uri;
        Option option2 = this.GCSUriRegEx().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
            String string2 = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String filePath = (String)((LinearSeqOptimized)option2.get()).apply(2);
            if ("file".equals(string2)) {
                return new Tuple3((Object)"file", (Object)None$.MODULE$, (Object)new StringBuilder(1).append("/").append(filePath).toString());
            }
        }
        if (!(option = this.GCSUriRegEx().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            String scheme = (String)((LinearSeqOptimized)option.get()).apply(0);
            String bucketName = (String)((LinearSeqOptimized)option.get()).apply(1);
            String filePath = (String)((LinearSeqOptimized)option.get()).apply(2);
            return new Tuple3((Object)scheme, (Object)new Some((Object)bucketName), (Object)filePath);
        }
        return new Tuple3((Object)this.defaultFS().getScheme(), (Object)None$.MODULE$, (Object)uri);
    }

    private String normalizedFileSystem(String fileSystem) {
        if (fileSystem.endsWith(":")) {
            return new StringBuilder(3).append(fileSystem).append("///").toString();
        }
        if (!fileSystem.endsWith("://") && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(fileSystem)).last()) == '/') {
            return (String)new StringOps(Predef$.MODULE$.augmentString(fileSystem)).dropRight(1);
        }
        if (fileSystem.endsWith("://")) {
            return new StringBuilder(2).append(fileSystem).append("/.").toString();
        }
        return fileSystem;
    }

    private String defaultNormalizedFileSystem$lzycompute() {
        HdfsStorageHandler hdfsStorageHandler = this;
        synchronized (hdfsStorageHandler) {
            if (!this.bitmap$0) {
                this.defaultNormalizedFileSystem = this.normalizedFileSystem(this.fileSystem);
                this.bitmap$0 = true;
            }
        }
        this.fileSystem = null;
        return this.defaultNormalizedFileSystem;
    }

    private String defaultNormalizedFileSystem() {
        if (!this.bitmap$0) {
            return this.defaultNormalizedFileSystem$lzycompute();
        }
        return this.defaultNormalizedFileSystem;
    }

    @Override
    public FiniteDuration lockAcquisitionPollTime() {
        return this.settings.comet().lock().pollTime();
    }

    @Override
    public FiniteDuration lockRefreshPollTime() {
        return this.settings.comet().lock().refreshTime();
    }

    private FileSystem defaultFS() {
        return this.defaultFS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public FileSystem fs(Path inputPath) {
        FileSystem fileSystem;
        block5: {
            Path path = new StringOps(Predef$.MODULE$.augmentString(inputPath.toString())).contains((Object)BoxesRunTime.boxToCharacter((char)':')) ? inputPath : new Path(this.settings.comet().fileSystem(), inputPath.toString());
            Tuple3<String, Option<String>, String> tuple3 = this.extracSchemeAndBucketAndFilePath(path.toString());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String scheme = (String)tuple3._1();
            Option bucketOpt = (Option)tuple3._2();
            Tuple2 tuple2 = new Tuple2((Object)scheme, (Object)bucketOpt);
            String scheme2 = (String)tuple2._1();
            Option bucketOpt2 = (Option)tuple2._2();
            String string = scheme2;
            if ("gs".equals(string)) {
                Option option = bucketOpt2;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String bucket = (String)some.value();
                    this.conf().set("fs.defaultFS", this.normalizedFileSystem(new StringBuilder(3).append(scheme2).append("://").append(bucket).toString()));
                    fileSystem = FileSystem.get((Configuration)this.conf());
                    break block5;
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new RuntimeException("Using gs scheme must be with a bucket name. gs://bucketName");
                    }
                    throw new MatchError((Object)option);
                }
            }
            fileSystem = this.defaultFS();
        }
        FileSystem fs = fileSystem;
        fs.setWriteChecksum(false);
        return fs;
    }

    private OutputStream getOutputStream(Path path) {
        FileSystem currentFS = this.fs(path);
        currentFS.delete(path, false);
        FSDataOutputStream outputStream = currentFS.create(path);
        return outputStream;
    }

    @Override
    public String read(Path path, Charset charset) {
        FileSystem currentFS = this.fs(path);
        FSDataInputStream stream = currentFS.open(path);
        String content = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        stream.close();
        return content;
    }

    @Override
    public Charset read$default$2() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public void write(String data, Path path, Charset charset) {
        FSDataOutputStream os = (FSDataOutputStream)this.getOutputStream(path);
        os.write(data.getBytes(charset));
        os.close();
    }

    @Override
    public void writeBinary(byte[] data, Path path) {
        OutputStream os = this.getOutputStream(path);
        os.write(data, 0, data.length);
        os.close();
    }

    @Override
    public List<Path> listDirectories(Path path) {
        FileSystem currentFS = this.fs(path);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])currentFS.listStatus(path))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory())))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toList();
    }

    @Override
    public List<Path> list(Path path, String extension, LocalDateTime since, boolean recursive, Option<Pattern> exclude, boolean sortByName) {
        BoxedUnit boxedUnit;
        FileSystem currentFS = this.fs(path);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("list({}, {}, {})", new Object[]{path, extension, since});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (this.exists(path)) {
                RemoteIterator iterator = currentFS.listFiles(path, recursive);
                List files = Conversions$.MODULE$.convertToScalaIterator(iterator).filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$list$2(this, exclude, since, extension, status))).toList();
                List sorted = sortByName ? (List)files.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPath().getName(), (Ordering)Ordering.String$.MODULE$) : (List)files.sortBy((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)BoxesRunTime.boxToLong((long)r.getModificationTime()), (Object)r.getPath().getName()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.String$.MODULE$));
                return (List)sorted.map((Function1 & Serializable & scala.Serializable)status -> status.getPath(), List$.MODULE$.canBuildFrom());
            }
            return Nil$.MODULE$;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List list = (List)success.value();
            return list;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(16).append("Ignoring folder ").append(path).toString(), e);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return Nil$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public boolean list$default$6() {
        return false;
    }

    @Override
    public boolean copy(Path src, Path dst) {
        return FileUtil.copy((FileSystem)this.fs(src), (Path)src, (FileSystem)this.fs(dst), (Path)dst, (boolean)false, (Configuration)this.conf());
    }

    @Override
    public boolean move(Path src, Path dest) {
        FileSystem currentFS = this.fs(src);
        this.delete(dest);
        this.mkdirs(dest.getParent());
        return currentFS.rename(src, dest);
    }

    @Override
    public boolean delete(Path path) {
        FileSystem currentFS = this.fs(path);
        return currentFS.delete(path, true);
    }

    @Override
    public boolean mkdirs(Path path) {
        FileSystem currentFS = this.fs(path);
        return currentFS.mkdirs(path);
    }

    @Override
    public void copyFromLocal(Path source, Path dest) {
        FileSystem currentFS = this.fs(source);
        currentFS.copyFromLocalFile(source, dest);
    }

    @Override
    public void copyToLocal(Path source, Path dest) {
        FileSystem currentFS = this.fs(source);
        currentFS.copyToLocalFile(source, dest);
    }

    @Override
    public void moveFromLocal(Path source, Path dest) {
        FileSystem currentFS = this.fs(source);
        String string = currentFS.getScheme();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            currentFS.moveFromLocalFile(source, dest);
            return;
        }
        this.move(source, dest);
    }

    @Override
    public boolean exists(Path path) {
        FileSystem currentFS = this.fs(path);
        return currentFS.exists(path);
    }

    @Override
    public long blockSize(Path path) {
        FileSystem currentFS = this.fs(path);
        return currentFS.getDefaultBlockSize(path);
    }

    @Override
    public long spaceConsumed(Path path) {
        FileSystem currentFS = this.fs(path);
        return currentFS.getContentSummary(path).getSpaceConsumed();
    }

    @Override
    public long lastModified(Path path) {
        FileSystem currentFS = this.fs(path);
        return currentFS.getFileStatus(path).getModificationTime();
    }

    @Override
    public Try<BoxedUnit> touchz(Path path) {
        FileSystem currentFS = this.fs(path);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> currentFS.create(path, false).close());
    }

    @Override
    public Try<BoxedUnit> touch(Path path) {
        FileSystem currentFS = this.fs(path);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> currentFS.setTimes(path, System.currentTimeMillis(), -1L));
    }

    @Override
    public String getScheme() {
        return this.defaultFS().getScheme();
    }

    public static final /* synthetic */ void $anonfun$new$1(HdfsStorageHandler $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            $this.conf().set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$2(HdfsStorageHandler $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            $this.conf().set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$list$3(LocatedFileStatus status$1, Pattern x$4) {
        return x$4.matcher(status$1.getPath().getName()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$list$2(HdfsStorageHandler $this, Option exclude$1, LocalDateTime since$1, String extension$1, LocatedFileStatus status) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("found file={}", new Object[]{status});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(status.getModificationTime()), ZoneId.systemDefault());
        boolean excludeFile = exclude$1.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HdfsStorageHandler.$anonfun$list$3(status, x$4)));
        return !excludeFile && time.isAfter(since$1) && status.getPath().getName().endsWith(extension$1);
    }

    public HdfsStorageHandler(String fileSystem, Settings settings) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        this.fileSystem = fileSystem;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        StorageHandler.$init$(this);
        this.conf = new Configuration();
        this.extraConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HdfsStorageHandler.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        settings.comet().hadoop().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            HdfsStorageHandler.$anonfun$new$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
        this.GCSUriRegEx = new StringOps(Predef$.MODULE$.augmentString("(.*)://(.*?)/(.*)")).r();
        this.conf().set("fs.defaultFS", this.defaultNormalizedFileSystem());
        this.defaultFS = FileSystem.get((Configuration)this.conf());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(10).append("defaultFS=").append(this.defaultFS()).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(27).append("defaultFS.getHomeDirectory=").append(this.defaultFS().getHomeDirectory()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(17).append("defaultFS.getUri=").append(this.defaultFS().getUri()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

