/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.schema.handlers;

import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.LocalStorageHandler$;
import ai.starlake.schema.handlers.StorageHandler;
import better.files.File;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0011#\u0001-B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ya\u000e\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\u0019\u0002!\ta\u0011\u0005\u0006\u001b\u0002!IA\u0014\u0005\u0006K\u0002!\tA\u001a\u0005\by\u0002\t\n\u0011\"\u0001~\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!I\u00111\u0013\u0001\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!!,\u0001\t\u0003\ty\u000bC\u0004\u00024\u0002!\t!!.\t\u000f\u0005e\u0006\u0001\"\u0001\u0002<\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAe\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!:\u0001\t\u0003\t9\u000fC\u0004\u0002l\u0002!\t!!<\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!q\u0007\u0001\u0005\u0002\te\u0002b\u0002B\u001f\u0001\u0011\u0005!qH\u0004\b\u0005\u0003\u0012\u0003\u0012\u0001B\"\r\u0019\t#\u0005#\u0001\u0003F!1Q\b\bC\u0001\u0005\u000fB\u0011B!\u0013\u001d\u0005\u0004%IAa\u0013\t\u0011\t5C\u0004)A\u0005\u0003\u007fBqAa\u0014\u001d\t\u0003\u0011\tFA\nM_\u000e\fGn\u0015;pe\u0006<W\rS1oI2,'O\u0003\u0002$I\u0005A\u0001.\u00198eY\u0016\u00148O\u0003\u0002&M\u000511o\u00195f[\u0006T!a\n\u0015\u0002\u0011M$\u0018M\u001d7bW\u0016T\u0011!K\u0001\u0003C&\u001c\u0001aE\u0002\u0001YI\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a5\u001b\u0005\u0011\u0013BA\u001b#\u00059\u0019Fo\u001c:bO\u0016D\u0015M\u001c3mKJ\f\u0001b]3ui&twm\u001d\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0019\naaY8oM&<\u0017B\u0001\u001f:\u0005!\u0019V\r\u001e;j]\u001e\u001c\u0018A\u0002\u001fj]&$h\bF\u0001@)\t\u0001\u0015\t\u0005\u00024\u0001!)aG\u0001a\u0002o\u00059Bn\\2l\u0003\u000e\fX/[:ji&|g\u000eU8mYRKW.Z\u000b\u0002\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0011JL\u0001\u000bG>t7-\u001e:sK:$\u0018BA&G\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f1\u0003\\8dWJ+gM]3tQB{G\u000e\u001c+j[\u0016\fqbZ3u\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u000b\u0003\u001f^\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\u0005%|'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-F\u0013AbT;uaV$8\u000b\u001e:fC6DQ\u0001W\u0003A\u0002e\u000bA\u0001]1uQB\u0011!lY\u0007\u00027*\u0011A,X\u0001\u0003MNT!AX0\u0002\r!\fGm\\8q\u0015\t\u0001\u0017-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0006\u0019qN]4\n\u0005\u0011\\&\u0001\u0002)bi\"\fAA]3bIR\u0019qM]:\u0011\u0005!|gBA5n!\tQg&D\u0001l\u0015\ta'&\u0001\u0004=e>|GOP\u0005\u0003]:\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011aN\f\u0005\u00061\u001a\u0001\r!\u0017\u0005\bi\u001a\u0001\n\u00111\u0001v\u0003\u001d\u0019\u0007.\u0019:tKR\u0004\"A\u001e>\u000e\u0003]T!\u0001\u001e=\u000b\u0005e\u001c\u0016a\u00018j_&\u00111p\u001e\u0002\b\u0007\"\f'o]3u\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uII*\u0012A \u0016\u0003k~\\#!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017q\u0013AC1o]>$\u0018\r^5p]&!\u0011qBA\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0006oJLG/\u001a\u000b\u0007\u0003+\ty\"a\t\u0015\t\u0005]\u0011Q\u0004\t\u0004[\u0005e\u0011bAA\u000e]\t!QK\\5u\u0011\u001d!\b\u0002%AA\u0004UDa!!\t\t\u0001\u00049\u0017\u0001\u00023bi\u0006DQ\u0001\u0017\u0005A\u0002e\u000b1b\u001e:ji\u0016\u0014\u0015N\\1ssR1\u0011qCA\u0015\u0003oAq!!\t\n\u0001\u0004\tY\u0003E\u0003.\u0003[\t\t$C\u0002\u000209\u0012Q!\u0011:sCf\u00042!LA\u001a\u0013\r\t)D\f\u0002\u0005\u0005f$X\rC\u0003Y\u0013\u0001\u0007\u0011,A\bmSN$H)\u001b:fGR|'/[3t)\u0011\ti$a\u0014\u0011\u000b\u0005}\u0012\u0011J-\u000f\t\u0005\u0005\u0013Q\t\b\u0004U\u0006\r\u0013\"A\u0018\n\u0007\u0005\u001dc&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0013Q\n\u0002\u0005\u0019&\u001cHOC\u0002\u0002H9BQ\u0001\u0017\u0006A\u0002e\u000bA\u0001\\5tiRq\u0011QHA+\u0003/\nY&a\u001b\u0002v\u0005=\u0005\"\u0002-\f\u0001\u0004I\u0006\u0002CA-\u0017A\u0005\t\u0019A4\u0002\u0013\u0015DH/\u001a8tS>t\u0007\"CA/\u0017A\u0005\t\u0019AA0\u0003\u0015\u0019\u0018N\\2f!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3'\u0006!A/[7f\u0013\u0011\tI'a\u0019\u0003\u001b1{7-\u00197ECR,G+[7f\u0011\u001d\tig\u0003a\u0001\u0003_\n\u0011B]3dkJ\u001c\u0018N^3\u0011\u00075\n\t(C\u0002\u0002t9\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002x-\u0001\n\u00111\u0001\u0002z\u00059Q\r_2mk\u0012,\u0007#B\u0017\u0002|\u0005}\u0014bAA?]\t1q\n\u001d;j_:\u0004B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0003sK\u001e,\u0007PC\u0002\u0002\nN\u000bA!\u001e;jY&!\u0011QRAB\u0005\u001d\u0001\u0016\r\u001e;fe:D\u0011\"!%\f!\u0003\u0005\r!a\u001c\u0002\u0015M|'\u000f\u001e\"z\u001d\u0006lW-\u0001\bmSN$H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005]%fAA8\u007f\u0006!1m\u001c9z)\u0019\ty'!(\u0002\"\"1\u0011qT\u0007A\u0002e\u000b1a\u001d:d\u0011\u0019\t\u0019+\u0004a\u00013\u0006!A-Z:u\u0003\u0011iwN^3\u0015\r\u0005=\u0014\u0011VAV\u0011\u0019\tyJ\u0004a\u00013\"1\u00111\u0015\bA\u0002e\u000ba\u0001Z3mKR,G\u0003BA8\u0003cCQ\u0001W\bA\u0002e\u000ba!\\6eSJ\u001cH\u0003BA8\u0003oCQ\u0001\u0017\tA\u0002e\u000bQbY8qs\u001a\u0013x.\u001c'pG\u0006dGCBA\f\u0003{\u000by\f\u0003\u0004\u0002 F\u0001\r!\u0017\u0005\u0007\u0003G\u000b\u0002\u0019A-\u0002\u0017\r|\u0007/\u001f+p\u0019>\u001c\u0017\r\u001c\u000b\u0007\u0003/\t)-a2\t\r\u0005}%\u00031\u0001Z\u0011\u0019\t\u0019K\u0005a\u00013\u0006iQn\u001c<f\rJ|W\u000eT8dC2$b!a\u0006\u0002N\u0006E\u0007BBAh'\u0001\u0007\u0011,\u0001\u0004t_V\u00148-\u001a\u0005\u0007\u0003G\u001b\u0002\u0019A-\u0002\r\u0015D\u0018n\u001d;t)\u0011\ty'a6\t\u000ba#\u0002\u0019A-\u0002\u0013\tdwnY6TSj,G\u0003BAo\u0003G\u00042!LAp\u0013\r\t\tO\f\u0002\u0005\u0019>tw\rC\u0003Y+\u0001\u0007\u0011,A\u0007ta\u0006\u001cWmQ8ogVlW\r\u001a\u000b\u0005\u0003;\fI\u000fC\u0003Y-\u0001\u0007\u0011,\u0001\u0007mCN$Xj\u001c3jM&,G\r\u0006\u0003\u0002p\n\u0015\u0002\u0003BAy\u0005?qA!a=\u0003\u001a9!\u0011Q\u001fB\n\u001d\u0011\t9P!\u0004\u000f\t\u0005e(q\u0001\b\u0005\u0003w\u0014\u0019A\u0004\u0003\u0002~\n\u0005ab\u00016\u0002\u0000&\t!-\u0003\u0002aC&\u0019!QA0\u0002\u000bM\u0004\u0018M]6\n\t\t%!1B\u0001\u0004gFd'b\u0001B\u0003?&!!q\u0002B\t\u0003%)\u00070Z2vi&|gN\u0003\u0003\u0003\n\t-\u0011\u0002\u0002B\u000b\u0005/\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\t\t=!\u0011C\u0005\u0005\u00057\u0011i\"\u0001\tGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK*!!Q\u0003B\f\u0013\u0011\u0011\tCa\t\u0003\u0013QKW.Z:uC6\u0004(\u0002\u0002B\u000e\u0005;AQ\u0001W\fA\u0002e\u000ba\u0001^8vG\"TH\u0003\u0002B\u0016\u0005k\u0001bA!\f\u00032\u0005]QB\u0001B\u0018\u0015\r\tIIL\u0005\u0005\u0005g\u0011yCA\u0002UefDQ\u0001\u0017\rA\u0002e\u000bQ\u0001^8vG\"$BAa\u000b\u0003<!)\u0001,\u0007a\u00013\u0006Iq-\u001a;TG\",W.\u001a\u000b\u0002O\u0006\u0019Bj\\2bYN#xN]1hK\"\u000bg\u000e\u001a7feB\u00111\u0007H\n\u000391\"\"Aa\u0011\u00025!\u000b5k\u0018#S\u0013Z+u\fT#U)\u0016\u0013vl\u0015)F\u0007&3\u0015*\u0012*\u0016\u0005\u0005}\u0014a\u0007%B'~#%+\u0013,F?2+E\u000bV#S?N\u0003ViQ%G\u0013\u0016\u0013\u0006%A\u0005m_\u000e\fGNR5mKR!!1\u000bB2!\u0011\u0011)Fa\u0018\u000e\u0005\t]#\u0002\u0002B-\u00057\nQAZ5mKNT!A!\u0018\u0002\r\t,G\u000f^3s\u0013\u0011\u0011\tGa\u0016\u0003\t\u0019KG.\u001a\u0005\u00061\u0002\u0002\r!\u0017")
public class LocalStorageHandler
implements StorageHandler {
    private final Settings settings;
    private final Map<String, String> extraConf;
    private final Logger logger;

    public static File localFile(Path path) {
        return LocalStorageHandler$.MODULE$.localFile(path);
    }

    @Override
    public Option<Path> moveSparkPartFile(Path sparkFolder, String extension) {
        return StorageHandler.moveSparkPartFile$(this, sparkFolder, extension);
    }

    @Override
    public Charset write$default$3(String data, Path path) {
        return StorageHandler.write$default$3$(this, data, path);
    }

    @Override
    public String list$default$2() {
        return StorageHandler.list$default$2$(this);
    }

    @Override
    public LocalDateTime list$default$3() {
        return StorageHandler.list$default$3$(this);
    }

    @Override
    public Option<Pattern> list$default$5() {
        return StorageHandler.list$default$5$(this);
    }

    @Override
    public Map<String, String> extraConf() {
        return this.extraConf;
    }

    @Override
    public void ai$starlake$schema$handlers$StorageHandler$_setter_$extraConf_$eq(Map<String, String> x$1) {
        this.extraConf = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public FiniteDuration lockAcquisitionPollTime() {
        return this.settings.comet().lock().pollTime();
    }

    @Override
    public FiniteDuration lockRefreshPollTime() {
        return this.settings.comet().lock().refreshTime();
    }

    private OutputStream getOutputStream(Path path) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        file.delete(true, file.delete$default$2());
        return file.newOutputStream(file.newOutputStream$default$1());
    }

    @Override
    public String read(Path path, Charset charset) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        return file.contentAsString(charset);
    }

    @Override
    public Charset read$default$2() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public void write(String data, Path path, Charset charset) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        File qual$1 = file.parent();
        Seq x$1 = qual$1.createDirectories$default$1();
        Seq x$2 = qual$1.createDirectories$default$2();
        qual$1.createDirectories(x$1, x$2);
        String x$3 = data;
        Charset x$4 = charset;
        Seq x$5 = file.overwrite$default$2(x$3);
        file.overwrite(x$3, x$5, x$4);
    }

    @Override
    public void writeBinary(byte[] data, Path path) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        File qual$1 = file.parent();
        Seq x$1 = qual$1.createDirectories$default$1();
        Seq x$2 = qual$1.createDirectories$default$2();
        qual$1.createDirectories(x$1, x$2);
        byte[] x$3 = data;
        Seq x$4 = file.writeByteArray$default$2(x$3);
        file.writeByteArray(x$3, x$4);
    }

    @Override
    public List<Path> listDirectories(Path path) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        return file.list().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory(x$1.isDirectory$default$1()))).map((Function1 & Serializable & scala.Serializable)f -> new Path(f.pathAsString())).toList();
    }

    @Override
    public List<Path> list(Path path, String extension, LocalDateTime since, boolean recursive, Option<Pattern> exclude, boolean sortByName) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("list({}, {}, {})", new Object[]{path, extension, since});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (this.exists(path)) {
                File file = LocalStorageHandler$.MODULE$.localFile(path);
                Iterator fileList = recursive ? file.listRecursively(file.listRecursively$default$1()) : file.list();
                Iterator iterator = fileList.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isRegularFile(x$2.isRegularFile$default$1())));
                List files = iterator.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LocalStorageHandler.$anonfun$list$3(this, exclude, since, extension, f))).toList();
                List sorted = sortByName ? (List)files.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), (Ordering)Ordering.String$.MODULE$) : (List)files.sortBy((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.lastModifiedTime(f.lastModifiedTime$default$1()), (Object)f.name()), Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()), (Ordering)Ordering.String$.MODULE$));
                return (List)sorted.map((Function1 & Serializable & scala.Serializable)f -> new Path(f.pathAsString()), List$.MODULE$.canBuildFrom());
            }
            return Nil$.MODULE$;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List list = (List)success.value();
            return list;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(16).append("Ignoring folder ").append(path).toString(), e);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return Nil$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public boolean list$default$6() {
        return false;
    }

    @Override
    public boolean copy(Path src, Path dest) {
        File fsrc = LocalStorageHandler$.MODULE$.localFile(src);
        File fdest = LocalStorageHandler$.MODULE$.localFile(dest);
        this.mkdirs(dest.getParent());
        File x$1 = fdest;
        boolean x$2 = fsrc.copyTo$default$2();
        Seq x$3 = fsrc.copyTo$default$3(x$1, x$2);
        fsrc.copyTo(x$1, x$2, x$3);
        return true;
    }

    @Override
    public boolean move(Path src, Path dest) {
        File fsrc = LocalStorageHandler$.MODULE$.localFile(src);
        File fdest = LocalStorageHandler$.MODULE$.localFile(dest);
        fdest.delete(true, fdest.delete$default$2());
        this.mkdirs(dest.getParent());
        File x$1 = fdest;
        Seq x$2 = fsrc.moveTo$default$2(x$1);
        fsrc.moveTo(x$1, x$2);
        return true;
    }

    @Override
    public boolean delete(Path path) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        file.delete(true, file.delete$default$2());
        return true;
    }

    @Override
    public boolean mkdirs(Path path) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        file.createDirectories(file.createDirectories$default$1(), file.createDirectories$default$2());
        return true;
    }

    @Override
    public void copyFromLocal(Path src, Path dest) {
        File fsrc = LocalStorageHandler$.MODULE$.localFile(src);
        File fdest = LocalStorageHandler$.MODULE$.localFile(dest);
        fdest.delete(true, fdest.delete$default$2());
        this.mkdirs(dest.getParent());
        File x$1 = fdest;
        boolean x$2 = fsrc.copyTo$default$2();
        Seq x$3 = fsrc.copyTo$default$3(x$1, x$2);
        fsrc.copyTo(x$1, x$2, x$3);
    }

    @Override
    public void copyToLocal(Path src, Path dest) {
        this.copyFromLocal(src, dest);
    }

    @Override
    public void moveFromLocal(Path source, Path dest) {
        this.move(source, dest);
    }

    @Override
    public boolean exists(Path path) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        return file.exists(file.exists$default$1());
    }

    @Override
    public long blockSize(Path path) {
        return 0x4000000L;
    }

    @Override
    public long spaceConsumed(Path path) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        return file.size(file.size$default$1());
    }

    @Override
    public long lastModified(Path path) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        return file.lastModifiedTime(file.lastModifiedTime$default$1()).toEpochMilli();
    }

    @Override
    public Try<BoxedUnit> touchz(Path path) {
        File file = LocalStorageHandler$.MODULE$.localFile(path);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Instant x$1 = file.touch$default$1();
            Seq x$2 = file.touch$default$2(x$1);
            Seq x$3 = file.touch$default$3(x$1);
            file.touch(x$1, x$2, x$3);
        });
    }

    @Override
    public Try<BoxedUnit> touch(Path path) {
        return this.touchz(path);
    }

    @Override
    public String getScheme() {
        return "file";
    }

    public static final /* synthetic */ boolean $anonfun$list$4(File f$1, Pattern x$3) {
        return x$3.matcher(f$1.name()).matches();
    }

    public static final /* synthetic */ boolean $anonfun$list$3(LocalStorageHandler $this, Option exclude$1, LocalDateTime since$1, String extension$1, File f) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("found file={}", new Object[]{f});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LocalDateTime time = LocalDateTime.ofInstant(f.lastModifiedTime(f.lastModifiedTime$default$1()), ZoneId.systemDefault());
        boolean excludeFile = exclude$1.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LocalStorageHandler.$anonfun$list$4(f, x$3)));
        return !excludeFile && time.isAfter(since$1) && f.name().endsWith(extension$1);
    }

    public LocalStorageHandler(Settings settings) {
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        StorageHandler.$init$(this);
    }
}

