/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.schema.model.MergeOptions;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MergeUtils$
implements StrictLogging,
DatasetLogging {
    public static MergeUtils$ MODULE$;
    private final Logger logger;

    static {
        new MergeUtils$();
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public StructType computeCompatibleSchema(StructType actualSchema, StructType expectedSchema) {
        Set newColumns;
        Set newColumnsNotNullable;
        Map actualColumns = ((TraversableOnce)actualSchema.map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), field), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map expectedColumns = ((TraversableOnce)expectedSchema.map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), field), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Set missingColumns = (Set)actualColumns.keySet().diff((GenSet)expectedColumns.keySet());
        if (missingColumns.nonEmpty()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Columns omitted in the new schema: {}", new Object[]{missingColumns.mkString(",")});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Set missingColumnsNotNullable = (Set)missingColumns.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MergeUtils$.$anonfun$computeCompatibleSchema$3(actualColumns, x$1)));
            if (missingColumnsNotNullable.nonEmpty()) {
                throw new RuntimeException(new StringBuilder(123).append("Input Dataset should contain every required column from the existing HDFS dataset. The following columns were not matched: ").append(missingColumnsNotNullable.mkString(",")).toString());
            }
        }
        if ((newColumnsNotNullable = (Set)((SetLike)((TraversableLike)(newColumns = (Set)expectedColumns.keySet().diff((GenSet)actualColumns.keySet())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(expectedColumns.get(x$2)), Set$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nullable()))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Set$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new RuntimeException(new StringBuilder(87).append("The new columns from Input Dataset should be nullable. The following columns were not: ").append(newColumnsNotNullable.mkString(", ")).toString());
        }
        return StructType$.MODULE$.apply((Seq)expectedSchema.flatMap((Function1 & Serializable & scala.Serializable)expectedField -> Option$.MODULE$.option2Iterable(actualColumns.get((Object)expectedField.name()).map((Function1 & Serializable & scala.Serializable)existingField -> {
            Tuple2 tuple2 = new Tuple2((Object)existingField.dataType(), (Object)expectedField.dataType());
            if (tuple2 != null) {
                DataType existingType = (DataType)tuple2._1();
                DataType incomingType = (DataType)tuple2._2();
                if (existingType instanceof StructType) {
                    StructType structType = (StructType)existingType;
                    if (incomingType instanceof StructType) {
                        StructType structType2 = (StructType)incomingType;
                        StructType x$1 = MODULE$.computeCompatibleSchema(structType, structType2);
                        String x$2 = expectedField.copy$default$1();
                        boolean x$3 = expectedField.copy$default$3();
                        Metadata x$4 = expectedField.copy$default$4();
                        return expectedField.copy(x$2, (DataType)x$1, x$3, x$4);
                    }
                }
            }
            if (tuple2 != null) {
                ArrayType arrayType;
                DataType existingType;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType && (existingType = (arrayType = (ArrayType)dataType).elementType()) instanceof StructType) {
                    StructType structType = (StructType)existingType;
                    if (dataType2 instanceof ArrayType) {
                        ArrayType arrayType2 = (ArrayType)dataType2;
                        DataType incomingType = arrayType2.elementType();
                        boolean nullable = arrayType2.containsNull();
                        if (incomingType instanceof StructType) {
                            StructType structType3 = (StructType)incomingType;
                            ArrayType x$5 = new ArrayType((DataType)MODULE$.computeCompatibleSchema(structType, structType3), nullable);
                            String x$6 = expectedField.copy$default$1();
                            boolean x$7 = expectedField.copy$default$3();
                            Metadata x$8 = expectedField.copy$default$4();
                            return expectedField.copy(x$6, (DataType)x$5, x$7, x$8);
                        }
                    }
                }
            }
            if (tuple2 != null) {
                return expectedField;
            }
            throw new MatchError((Object)tuple2);
        })), Seq$.MODULE$.canBuildFrom()));
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, Dataset<Row>> computeToMergeAndToDeleteDF(Dataset<Row> existingDF, Dataset<Row> incomingDF, MergeOptions mergeOptions) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            BoxedUnit boxedUnit6;
            BoxedUnit boxedUnit7;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("incomingDF Schema before merge -> {}", new Object[]{incomingDF.schema()});
                boxedUnit7 = BoxedUnit.UNIT;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("existingDF Schema before merge -> {}", new Object[]{existingDF.schema()});
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("existingDF field count={}", new Object[]{BoxesRunTime.boxToInteger((int)existingDF.schema().fields().length)});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("existingDF field list={}", new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingDF.schema().fieldNames())).mkString(",")});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("incomingDF field count={}", new Object[]{BoxesRunTime.boxToInteger((int)incomingDF.schema().fields().length)});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("incomingDF field list={}", new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])incomingDF.schema().fieldNames())).mkString(",")});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Dataset finalIncomingDF = (Dataset)mergeOptions.delete().map((Function1 & Serializable & scala.Serializable)condition -> incomingDF.filter(new StringBuilder(6).append("not (").append((String)condition).append(")").toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> incomingDF);
        Option<String> option = mergeOptions.timestamp();
        if (option instanceof Some) {
            Some some = (Some)option;
            String timestamp = (String)some.value();
            WindowSpec orderingWindow = Window$.MODULE$.partitionBy((String)mergeOptions.key().head(), (Seq)mergeOptions.key().tail()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(timestamp).desc()}));
            Dataset<Row> allRowsDF = this.computeDataframeUnion(existingDF, (Dataset<Row>)finalIncomingDF);
            Dataset allRowsWithRownum = this.updateFieldComment(allRowsDF, (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingDF.schema().fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])finalIncomingDF.schema().fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).withColumn("rownum", functions$.MODULE$.row_number().over(orderingWindow));
            Dataset mergedDF = allRowsWithRownum.where(functions$.MODULE$.col("rownum").$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1))).drop("rownum");
            Dataset toDeleteDF = allRowsWithRownum.where(functions$.MODULE$.col("rownum").$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)1))).drop("rownum");
            tuple2 = new Tuple2((Object)mergedDF, (Object)toDeleteDF);
        } else if (None$.MODULE$.equals(option)) {
            Dataset<Row> patchedExistingDF = this.addMissingAttributes(existingDF, (Dataset<Row>)finalIncomingDF);
            Dataset<Row> patchedIncomingDF = this.addMissingAttributes((Dataset<Row>)finalIncomingDF, existingDF);
            Dataset commonDF = patchedExistingDF.join(patchedIncomingDF.select((Seq)mergeOptions.key().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), List$.MODULE$.canBuildFrom())), mergeOptions.key()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])patchedIncomingDF.columns())).map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
            Dataset<Row> mergeDF = this.updateFieldComment((Dataset<Row>)patchedExistingDF.except(commonDF).union(patchedIncomingDF), (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingDF.schema().fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])finalIncomingDF.schema().fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
            tuple2 = new Tuple2(mergeDF, (Object)commonDF);
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Dataset mergedDF = (Dataset)tuple22._1();
        Dataset toDeleteDF = (Dataset)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)mergedDF, (Object)toDeleteDF);
        Dataset mergedDF2 = (Dataset)tuple23._1();
        Dataset toDeleteDF2 = (Dataset)tuple23._2();
        if (this.logger().underlying().isDebugEnabled()) {
            BoxedUnit boxedUnit8;
            BoxedUnit boxedUnit9;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Merge detected {} items to update/delete", new Object[]{BoxesRunTime.boxToLong((long)toDeleteDF2.count())});
                boxedUnit9 = BoxedUnit.UNIT;
            } else {
                boxedUnit9 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Merge detected {} items to insert", new Object[]{BoxesRunTime.boxToLong((long)(mergedDF2.count() - finalIncomingDF.count()))});
                boxedUnit8 = BoxedUnit.UNIT;
            } else {
                boxedUnit8 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                DatasetLogging.DatasetHelper qual$1 = this.DatasetHelper(mergedDF2);
                int x$1 = 0;
                int x$2 = qual$1.showString$default$1();
                boolean x$3 = qual$1.showString$default$3();
                this.logger().underlying().debug(qual$1.showString(x$2, x$1, x$3));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Tuple3((Object)finalIncomingDF, (Object)mergedDF2, (Object)toDeleteDF2);
    }

    private Option<Map<List<String>, DataType>> findMissingColumnsType(StructType schema, StructType reference, List<String> stack) {
        Map fields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])reference.fields())).flatMap((Function1 & Serializable & scala.Serializable)referenceField -> Option$.MODULE$.option2Iterable((Option)fields.get((Object)referenceField.name()).fold((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(stack.$colon$plus((Object)referenceField.name(), List$.MODULE$.canBuildFrom())), (Object)referenceField.dataType())}))), (Function1 & Serializable & scala.Serializable)field -> {
            Tuple2 tuple2 = new Tuple2((Object)field.dataType(), (Object)referenceField.dataType());
            if (tuple2 != null) {
                DataType fieldType = (DataType)tuple2._1();
                DataType referenceType = (DataType)tuple2._2();
                if (fieldType instanceof StructType) {
                    StructType structType = (StructType)fieldType;
                    if (referenceType instanceof StructType) {
                        StructType structType2 = (StructType)referenceType;
                        return MODULE$.findMissingColumnsType(structType, structType2, (List<String>)((List)stack.$colon$plus((Object)referenceField.name(), List$.MODULE$.canBuildFrom())));
                    }
                }
            }
            if (tuple2 != null) {
                ArrayType arrayType;
                DataType fieldType;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType && (fieldType = (arrayType = (ArrayType)dataType).elementType()) instanceof StructType) {
                    ArrayType arrayType2;
                    DataType referenceType;
                    StructType structType = (StructType)fieldType;
                    if (dataType2 instanceof ArrayType && (referenceType = (arrayType2 = (ArrayType)dataType2).elementType()) instanceof StructType) {
                        StructType structType3 = (StructType)referenceType;
                        return MODULE$.findMissingColumnsType(structType, structType3, (List<String>)((List)stack.$colon$plus((Object)referenceField.name(), List$.MODULE$.canBuildFrom())));
                    }
                }
            }
            if (tuple2 != null) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class))))).reduceOption((Function2 & Serializable & scala.Serializable)(x$6, x$7) -> x$6.$plus$plus((GenTraversableOnce)x$7));
    }

    private List<String> findMissingColumnsType$default$3() {
        return Nil$.MODULE$;
    }

    public Dataset<Row> buildMissingType(Dataset<Row> dataframe, Tuple2<List<String>, DataType> missingType) {
        Tuple2<List<String>, DataType> tuple2 = missingType;
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                String colName = (String)colon2.head();
                List tail = colon2.tl$access$1();
                return dataframe.withColumn(colName, (Column)MergeUtils$.buildMissingColumn$1().apply((Object)new .colon.colon((Object)colName, (List)Nil$.MODULE$), (Object)tail, (Object)dataType));
            }
        }
        if (tuple2 != null) {
            return dataframe;
        }
        throw new MatchError(tuple2);
    }

    private Dataset<Row> computeDataframeUnion(Dataset<Row> existingDF, Dataset<Row> incomingDF) {
        Dataset<Row> patchedExistingDF = this.addMissingAttributes(existingDF, incomingDF);
        Dataset<Row> patchedIncomingDF = this.addMissingAttributes(incomingDF, existingDF);
        return patchedIncomingDF.unionByName(patchedExistingDF);
    }

    private Dataset<Row> updateFieldComment(Dataset<Row> df, StructField[] allfields) {
        Seq columns = (Seq)df.schema().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                StructField structField2 = structField;
                Metadata metadata = structField2.metadata();
                Metadata metadata2 = Metadata$.MODULE$.empty();
                if (!(metadata != null ? !metadata.equals(metadata2) : metadata2 != null)) {
                    Metadata newMt = (Metadata)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allfields)).collectFirst((PartialFunction)new scala.Serializable(structField2){
                        public static final long serialVersionUID = 0L;
                        private final StructField x2$1;

                        public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            String string = A1.name();
                            String string2 = this.x2$1.name();
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                Metadata metadata = A1.metadata();
                                Metadata metadata2 = Metadata$.MODULE$.empty();
                                if (metadata == null ? metadata2 != null : !metadata.equals(metadata2)) {
                                    return (B1)A1.metadata();
                                }
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(StructField x1) {
                            StructField structField = x1;
                            String string = structField.name();
                            String string2 = this.x2$1.name();
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                Metadata metadata = structField.metadata();
                                Metadata metadata2 = Metadata$.MODULE$.empty();
                                if (metadata == null ? metadata2 != null : !metadata.equals(metadata2)) {
                                    return true;
                                }
                            }
                            return false;
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Metadata$.MODULE$.empty());
                    return df.apply(structField2.name()).as(structField2.name(), newMt);
                }
            }
            return df.apply(structField.name());
        }, Seq$.MODULE$.canBuildFrom());
        return df.select(columns);
    }

    private Dataset<Row> addMissingAttributes(Dataset<Row> existingDF, Dataset<Row> incomingDF) {
        BoxedUnit boxedUnit;
        Option<Map<List<String>, DataType>> missingTypesInExisting = this.findMissingColumnsType(existingDF.schema(), incomingDF.schema(), this.findMissingColumnsType$default$3());
        Dataset patchedExistingDF = (Dataset)missingTypesInExisting.fold((Function0 & Serializable & scala.Serializable)() -> existingDF, (Function1 & Serializable & scala.Serializable)missingTypes -> (Dataset)missingTypes.foldLeft((Object)existingDF, (Function2 & Serializable & scala.Serializable)(dataframe, missingType) -> MODULE$.buildMissingType((Dataset<Row>)dataframe, (Tuple2<List<String>, DataType>)missingType)));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.DatasetHelper(patchedExistingDF).schemaString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return patchedExistingDF;
    }

    public static final /* synthetic */ boolean $anonfun$computeCompatibleSchema$3(Map actualColumns$1, String x$1) {
        return ((StructField)actualColumns$1.apply((Object)x$1)).nullable();
    }

    private static final Function3 buildMissingColumn$1() {
        return (Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> {
            Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
            if (tuple3 != null) {
                List list = (List)tuple3._1();
                List list2 = (List)tuple3._2();
                DataType missingType = (DataType)tuple3._3();
                Option option = package$.MODULE$.$colon$plus().unapply((SeqLike)list);
                if (!option.isEmpty()) {
                    String colName = (String)((Tuple2)option.get())._2();
                    if (Nil$.MODULE$.equals(list2)) {
                        return functions$.MODULE$.lit(null).cast(missingType).as(colName);
                    }
                }
            }
            if (tuple3 != null) {
                List parents = (List)tuple3._1();
                List list = (List)tuple3._2();
                DataType missingType = (DataType)tuple3._3();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    String colName = (String)colon2.head();
                    List fields = colon2.tl$access$1();
                    String parentColName = parents.mkString(".");
                    return functions$.MODULE$.when(functions$.MODULE$.col(parentColName).isNotNull(), (Object)functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append(parentColName).append(".*").toString()), (Column)MergeUtils$.buildMissingColumn$1().apply(parents.$plus$plus((GenTraversableOnce)new .colon.colon((Object)colName, (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom()), (Object)fields, (Object)missingType)})));
                }
            }
            if (tuple3 != null) {
                throw new Exception("should never happen");
            }
            throw new MatchError((Object)tuple3);
        };
    }

    private MergeUtils$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
    }
}

