/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Setup
extends ProxySelector
implements X509TrustManager {
    private static String protocol = null;
    private static String host = null;
    private static int port = 0;
    private static String username = null;
    private static String password = null;
    private static String httpsProxy = Setup.getEnv("https_proxy").orElse("");
    private static String httpProxy = Setup.getEnv("http_proxy").orElse("");
    private static String noProxy = Setup.getEnv("no_proxy").orElse("").replaceAll(",", "|");
    private static Proxy proxy = Proxy.NO_PROXY;
    private static HttpClient client = null;
    public static boolean ENABLE_ALL = Setup.envIsTrue("ENABLE_ALL");
    public static boolean ENABLE_BIGQUERY = ENABLE_ALL || Setup.envIsTrue("ENABLE_BIGQUERY");
    public static boolean ENABLE_AZURE = ENABLE_ALL || Setup.envIsTrue("ENABLE_AZURE");
    public static boolean ENABLE_SNOWFLAKE = ENABLE_ALL || Setup.envIsTrue("ENABLE_SNOWFLAKE");
    public static boolean ENABLE_REDSHIFT = ENABLE_ALL || Setup.envIsTrue("ENABLE_REDSHIFT");
    public static boolean ENABLE_POSTGRESQL = ENABLE_ALL || Setup.envIsTrue("ENABLE_POSTGRESQL");
    public static boolean ENABLE_DUCKDB = ENABLE_ALL || Setup.envIsTrue("ENABLE_DUCKDB");
    private static final boolean[] ALL_ENABLERS = new boolean[]{ENABLE_BIGQUERY, ENABLE_AZURE, ENABLE_SNOWFLAKE, ENABLE_REDSHIFT, ENABLE_POSTGRESQL, ENABLE_DUCKDB};
    private static final String SCALA_VERSION = Setup.getEnv("SCALA_VERSION").orElse("2.13");
    private static final String SL_VERSION = Setup.getEnv("SL_VERSION").orElse("1.2.0-SNAPSHOT");
    private static final String SPARK_VERSION = Setup.getEnv("SPARK_VERSION").orElse("3.5.3");
    private static final String SPARK_MAJOR_VERSION = SPARK_VERSION.split("\\.")[0];
    private static final String HADOOP_VERSION = Setup.getEnv("HADOOP_VERSION").orElse("3");
    private static final String SPARK_BQ_VERSION = Setup.getEnv("SPARK_BQ_VERSION").orElse("0.40.0");
    private static final String DELTA_SPARK = Setup.getEnv("SPARK_DELTA").orElse("3.2.0");
    private static final String HADOOP_AZURE_VERSION = Setup.getEnv("HADOOP_AZURE_VERSION").orElse("3.3.5");
    private static final String AZURE_STORAGE_VERSION = Setup.getEnv("AZURE_STORAGE_VERSION").orElse("8.6.6");
    private static final String JETTY_VERSION = Setup.getEnv("JETTY_VERSION").orElse("9.4.51.v20230217");
    private static final String[] HADOOP_LIBS = new String[]{"https://raw.githubusercontent.com/cdarlint/winutils/master/hadoop-3.3.5/bin/winutils.exe", "https://raw.githubusercontent.com/cdarlint/winutils/master/hadoop-3.3.5/bin/hadoop.dll"};
    private static final String SNOWFLAKE_JDBC_VERSION = Setup.getEnv("SNOWFLAKE_JDBC_VERSION").orElse("3.18.0");
    private static final String SPARK_SNOWFLAKE_VERSION = Setup.getEnv("SPARK_SNOWFLAKE_VERSION").orElse("3.0.0");
    private static final String POSTGRESQL_VERSION = Setup.getEnv("POSTGRESQL_VERSION").orElse("42.5.4");
    private static final String DUCKDB_VERSION = Setup.getEnv("DUCKDB_VERSION").orElse("1.1.0");
    private static final String AWS_JAVA_SDK_VERSION = Setup.getEnv("AWS_JAVA_SDK_VERSION").orElse("1.12.595");
    private static final String HADOOP_AWS_VERSION = Setup.getEnv("HADOOP_AWS_VERSION").orElse("3.3.4");
    private static final String REDSHIFT_JDBC_VERSION = Setup.getEnv("REDSHIFT_JDBC_VERSION").orElse("2.1.0.30");
    private static final JarDependency SPARK_JAR = new JarDependency("spark", "https://archive.apache.org/dist/spark/spark-" + SPARK_VERSION + "/spark-" + SPARK_VERSION + "-bin-hadoop" + HADOOP_VERSION + ".tgz");
    private static final JarDependency SPARK_JAR_213 = new JarDependency("spark", "https://archive.apache.org/dist/spark/spark-" + SPARK_VERSION + "/spark-" + SPARK_VERSION + "-bin-hadoop" + HADOOP_VERSION + "-scala2.13.tgz");
    private static final JarDependency SPARK_BQ_JAR = new JarDependency("spark-bigquery-with-dependencies", "https://repo1.maven.org/maven2/com/google/cloud/spark/spark-bigquery-with-dependencies_" + SCALA_VERSION + "/" + SPARK_BQ_VERSION + "/spark-bigquery-with-dependencies_" + SCALA_VERSION + "-" + SPARK_BQ_VERSION + ".jar");
    private static final JarDependency DELTA_SPARK_JAR = new JarDependency("delta-spark", "https://repo1.maven.org/maven2/io/delta/delta-spark_" + SCALA_VERSION + "/" + DELTA_SPARK + "/delta-spark_" + SCALA_VERSION + "-" + DELTA_SPARK + ".jar");
    private static final JarDependency DELTA_STORAGE_JAR = new JarDependency("delta-storage", "https://repo1.maven.org/maven2/io/delta/delta-storage/" + DELTA_SPARK + "/delta-storage-" + DELTA_SPARK + ".jar");
    private static final JarDependency HADOOP_AZURE_JAR = new JarDependency("hadoop-azure", "https://repo1.maven.org/maven2/org/apache/hadoop/hadoop-azure/" + HADOOP_AZURE_VERSION + "/hadoop-azure-" + HADOOP_AZURE_VERSION + ".jar");
    private static final JarDependency AZURE_STORAGE_JAR = new JarDependency("azure-storage", "https://repo1.maven.org/maven2/com/microsoft/azure/azure-storage/" + AZURE_STORAGE_VERSION + "/azure-storage-" + AZURE_STORAGE_VERSION + ".jar");
    private static final JarDependency JETTY_SERVER_JAR = new JarDependency("jetty-server", "https://repo1.maven.org/maven2/org/eclipse/jetty/jetty-server/" + JETTY_VERSION + "/jetty-server-" + JETTY_VERSION + ".jar");
    private static final JarDependency SNOWFLAKE_JDBC_JAR = new JarDependency("snowflake-jdbc", "https://repo1.maven.org/maven2/net/snowflake/snowflake-jdbc/" + SNOWFLAKE_JDBC_VERSION + "/snowflake-jdbc-" + SNOWFLAKE_JDBC_VERSION + ".jar");
    private static final JarDependency SPARK_SNOWFLAKE_JAR = new JarDependency("spark-snowflake", "https://repo1.maven.org/maven2/net/snowflake/spark-snowflake_" + SCALA_VERSION + "/" + SPARK_SNOWFLAKE_VERSION + "/spark-snowflake_" + SCALA_VERSION + "-" + SPARK_SNOWFLAKE_VERSION + ".jar");
    private static final JarDependency POSTGRESQL_JAR = new JarDependency("postgresql", "https://repo1.maven.org/maven2/org/postgresql/postgresql/" + POSTGRESQL_VERSION + "/postgresql-" + POSTGRESQL_VERSION + ".jar");
    private static final JarDependency DUCKDB_JAR = new JarDependency("duckdb_jdbc", "https://repo1.maven.org/maven2/org/duckdb/duckdb_jdbc/" + DUCKDB_VERSION + "/duckdb_jdbc-" + DUCKDB_VERSION + ".jar");
    private static final JarDependency AWS_JAVA_SDK_JAR = new JarDependency("aws-java-sdk-bundle", "https://repo1.maven.org/maven2/com/amazonaws/aws-java-sdk-bundle/" + AWS_JAVA_SDK_VERSION + "/aws-java-sdk-bundle-" + AWS_JAVA_SDK_VERSION + ".jar");
    private static final JarDependency HADOOP_AWS_JAR = new JarDependency("hadoop-aws", "https://repo1.maven.org/maven2/org/apache/hadoop/hadoop-aws/" + HADOOP_AWS_VERSION + "/hadoop-aws-" + HADOOP_AWS_VERSION + ".jar");
    private static final JarDependency REDSHIFT_JDBC_JAR = new JarDependency("redshift-jdbc42", "https://repo1.maven.org/maven2/com/amazon/redshift/redshift-jdbc42/" + REDSHIFT_JDBC_VERSION + "/redshift-jdbc42-" + REDSHIFT_JDBC_VERSION + ".jar");
    private static final JarDependency STARLAKE_SNAPSHOT_JAR = new JarDependency("starlake-spark", "https://s01.oss.sonatype.org/content/repositories/snapshots/ai/starlake/starlake-spark" + SPARK_MAJOR_VERSION + "_" + SCALA_VERSION + "/" + SL_VERSION + "/starlake-spark" + SPARK_MAJOR_VERSION + "_" + SCALA_VERSION + "-" + SL_VERSION + "-assembly.jar");
    private static final JarDependency STARLAKE_RELEASE_JAR = new JarDependency("starlake-spark", "https://s01.oss.sonatype.org/content/repositories/releases/ai/starlake/starlake-spark" + SPARK_MAJOR_VERSION + "_" + SCALA_VERSION + "/" + SL_VERSION + "/starlake-spark" + SPARK_MAJOR_VERSION + "_" + SCALA_VERSION + "-" + SL_VERSION + "-assembly.jar");
    private static final JarDependency[] snowflakeDependencies = new JarDependency[]{SNOWFLAKE_JDBC_JAR, SPARK_SNOWFLAKE_JAR};
    private static final JarDependency[] redshiftDependencies = new JarDependency[]{AWS_JAVA_SDK_JAR, HADOOP_AWS_JAR, REDSHIFT_JDBC_JAR, Setup.SPARK_REDSHIFT_JAR()};
    private static final JarDependency[] azureDependencies = new JarDependency[]{HADOOP_AZURE_JAR, AZURE_STORAGE_JAR, JETTY_SERVER_JAR};
    private static final JarDependency[] postgresqlDependencies = new JarDependency[]{POSTGRESQL_JAR};
    private static final JarDependency[] duckDbDependencies = new JarDependency[]{DUCKDB_JAR};
    private static final JarDependency[] bigqueryDependencies = new JarDependency[]{SPARK_BQ_JAR};
    private static final JarDependency[] sparkDependencies = new JarDependency[]{DELTA_SPARK_JAR, DELTA_STORAGE_JAR};
    private static final Setup instance = new Setup();
    private static final TrustManager alwaysTrustManager = instance;
    private static final ProxySelector proxySelector = instance;

    private static boolean isWindowsOs() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.startsWith("windows");
    }

    private static void parseProxy(String string) {
        if (string.isEmpty()) {
            return;
        }
        Pattern pattern = Pattern.compile("(https?|socks5?):\\/\\/([^:].+)", 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            protocol = matcher.group(1).toLowerCase();
            String string2 = matcher.group(2);
            if (string2.contains("@")) {
                String[] stringArray = string2.split("@");
                String[] stringArray2 = stringArray[0].split(":");
                assert (stringArray2.length == 2) : "Invalid credentials format, expecting 'username:password'";
                username = stringArray2[0];
                password = stringArray2[1];
                String[] stringArray3 = stringArray[1].split(":");
                host = stringArray3[0];
                if (stringArray3.length > 1) {
                    port = Integer.parseInt(stringArray3[1]);
                }
            } else {
                String[] stringArray = string2.split(":");
                host = stringArray[0];
                if (stringArray.length > 1) {
                    port = Integer.parseInt(stringArray[1]);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid proxy format: " + string);
        }
    }

    private static void setProxy() {
        if (!httpsProxy.isEmpty()) {
            Setup.parseProxy(httpsProxy);
        } else if (!httpProxy.isEmpty()) {
            Setup.parseProxy(httpProxy);
        }
        if (host != null) {
            if (port == 0) {
                port = protocol.equals("https") ? 443 : (protocol.startsWith("socks") ? 1080 : 80);
            }
            Proxy.Type type = Proxy.Type.HTTP;
            if (protocol.startsWith("socks")) {
                type = Proxy.Type.SOCKS;
            }
            proxy = new Proxy(type, new InetSocketAddress(host, port));
        }
        if (!noProxy.isEmpty()) {
            System.setProperty("http.nonProxyHosts", noProxy);
        }
    }

    private static String SPARK_REDSHIFT_VERSION() {
        if (SCALA_VERSION.equals("2.13")) {
            return Setup.getEnv("SPARK_REDSHIFT_VERSION").orElse("6.3.0-spark_3.5-SNAPSHOT");
        }
        return Setup.getEnv("SPARK_REDSHIFT_VERSION").orElse("6.3.0-spark_3.5");
    }

    private static JarDependency SPARK_REDSHIFT_JAR() {
        if (SCALA_VERSION.equals("2.13")) {
            return new JarDependency("spark-redshift", "https://s01.oss.sonatype.org/content/repositories/snapshots/ai/starlake/spark-redshift_" + SCALA_VERSION + "/" + Setup.SPARK_REDSHIFT_VERSION() + "/spark-redshift_" + SCALA_VERSION + "-" + Setup.SPARK_REDSHIFT_VERSION() + ".jar");
        }
        return new JarDependency("spark-redshift", "https://repo1.maven.org/maven2/io/github/spark-redshift-community/spark-redshift_" + SCALA_VERSION + "/" + Setup.SPARK_REDSHIFT_VERSION() + "/spark-redshift_" + SCALA_VERSION + "-" + Setup.SPARK_REDSHIFT_VERSION() + ".jar");
    }

    private static Optional<String> getEnv(String string2) {
        return Optional.ofNullable(System.getenv(string2)).filter(string -> !string.isEmpty());
    }

    private static boolean envIsTrue(String string) {
        String string2 = Setup.getEnv(string).orElse("false");
        return !string2.equals("false") && !string2.equals("0");
    }

    private static void generateUnixVersions(File file) throws IOException {
        Setup.generateVersions(file, "versions.sh", "#!/bin/bash\nset -e\n\n", bufferedWriter -> (string, string2) -> {
            try {
                bufferedWriter.write(string + "=${" + string + ":-" + string2 + "}\n");
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        });
    }

    private static void generateWindowsVersions(File file) throws IOException {
        Setup.generateVersions(file, "versions.cmd", "@ECHO OFF\n\n", bufferedWriter -> (string, string2) -> {
            try {
                bufferedWriter.write("if \"%" + string + "%\"==\"\" (\n    SET " + string + "=" + string2 + "\n)\n");
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateVersions(File file, String string, String string2, Function<BufferedWriter, BiConsumer<String, String>> function) throws IOException {
        File file2 = new File(file, string);
        Setup.deleteFile(file2);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));){
            bufferedWriter.write(string2);
            function.apply(bufferedWriter).accept("ENABLE_BIGQUERY", String.valueOf(ENABLE_BIGQUERY));
            function.apply(bufferedWriter).accept("ENABLE_AZURE", String.valueOf(ENABLE_AZURE));
            function.apply(bufferedWriter).accept("ENABLE_SNOWFLAKE", String.valueOf(ENABLE_SNOWFLAKE));
            function.apply(bufferedWriter).accept("ENABLE_POSTGRESQL", String.valueOf(ENABLE_POSTGRESQL));
            function.apply(bufferedWriter).accept("ENABLE_REDSHIFT", String.valueOf(ENABLE_REDSHIFT));
            function.apply(bufferedWriter).accept("SL_VERSION", SL_VERSION);
            function.apply(bufferedWriter).accept("SCALA_VERSION", SCALA_VERSION);
            function.apply(bufferedWriter).accept("SPARK_VERSION", SPARK_VERSION);
            function.apply(bufferedWriter).accept("HADOOP_VERSION", HADOOP_VERSION);
            function.apply(bufferedWriter).accept("DUCKDB_VERSION", DUCKDB_VERSION);
            if (ENABLE_BIGQUERY || !Setup.anyDependencyEnabled()) {
                function.apply(bufferedWriter).accept("SPARK_BQ_VERSION", SPARK_BQ_VERSION);
            }
            if (ENABLE_AZURE || !Setup.anyDependencyEnabled()) {
                function.apply(bufferedWriter).accept("HADOOP_AZURE_VERSION", HADOOP_AZURE_VERSION);
                function.apply(bufferedWriter).accept("AZURE_STORAGE_VERSION", AZURE_STORAGE_VERSION);
                function.apply(bufferedWriter).accept("JETTY_VERSION", JETTY_VERSION);
            }
            if (ENABLE_SNOWFLAKE || !Setup.anyDependencyEnabled()) {
                function.apply(bufferedWriter).accept("SPARK_SNOWFLAKE_VERSION", SPARK_SNOWFLAKE_VERSION);
                function.apply(bufferedWriter).accept("SNOWFLAKE_JDBC_VERSION", SNOWFLAKE_JDBC_VERSION);
            }
            if (ENABLE_POSTGRESQL || !Setup.anyDependencyEnabled()) {
                function.apply(bufferedWriter).accept("POSTGRESQL_VERSION", POSTGRESQL_VERSION);
            }
            if (ENABLE_REDSHIFT || !Setup.anyDependencyEnabled()) {
                function.apply(bufferedWriter).accept("AWS_JAVA_SDK_VERSION", AWS_JAVA_SDK_VERSION);
                function.apply(bufferedWriter).accept("HADOOP_AWS_VERSION", HADOOP_AWS_VERSION);
                function.apply(bufferedWriter).accept("REDSHIFT_JDBC_VERSION", REDSHIFT_JDBC_VERSION);
                function.apply(bufferedWriter).accept("SPARK_REDSHIFT_VERSION", Setup.SPARK_REDSHIFT_VERSION());
            }
        }
        System.out.println(file2.getAbsolutePath() + " created");
    }

    private static void generateVersions(File file, boolean bl) throws IOException {
        if (Setup.isWindowsOs() && !bl) {
            Setup.generateWindowsVersions(file);
        } else {
            Setup.generateUnixVersions(file);
        }
    }

    private static boolean anyDependencyEnabled() {
        for (boolean bl : ALL_ENABLERS) {
            if (!bl) continue;
            return true;
        }
        return ENABLE_ALL;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public List<Proxy> select(URI uRI) {
        return Collections.singletonList(proxy);
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        throw new RuntimeException("Failed to connect to " + uRI + " using proxy " + socketAddress);
    }

    private static void setHttpClient() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustManagerArray;
        Setup.setProxy();
        HttpClient.Builder builder = HttpClient.newBuilder();
        builder.proxy(proxySelector);
        if (username != null && password != null) {
            trustManagerArray = new UserPwdAuth();
            builder.authenticator((Authenticator)trustManagerArray);
        }
        if (host != null && Setup.envIsTrue("SL_INSECURE")) {
            System.out.println("Enabling insecure mode for SSL connections using proxy " + protocol + "://" + host + ":" + port);
            trustManagerArray = new TrustManager[]{alwaysTrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            builder.sslContext(sSLContext);
        }
        client = builder.build();
    }

    private static void updateSparkLog4j2Properties(File file) {
        File file2 = new File(new File(file, "conf"), "log4j2.properties");
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("rootLogger.level =") || string.startsWith("rootLogger.level=")) {
                    string = "rootLogger.level = ${env:SL_LOG_LEVEL:-error}";
                }
                stringBuilder.append(string).append("\n");
            }
            bufferedReader.close();
            stringBuilder.append("logger.shutdown.name=org.apache.spark.util.ShutdownHookManager").append("\n");
            stringBuilder.append("logger.shutdown.level=OFF").append("\n");
            stringBuilder.append("logger.env.name=org.apache.spark.SparkEnv").append("\n");
            stringBuilder.append("logger.env.level=error").append("\n");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            bufferedWriter.write(stringBuilder.toString());
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Failed to update log4j.properties");
            iOException.printStackTrace();
        }
    }

    private static void askUserWhichConfigToEnable() {
        if (!Setup.anyDependencyEnabled()) {
            System.out.println("Do you want to enable all datawarehouse configurations ? [y/n]");
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string = bufferedReader.readLine();
                if (string.equalsIgnoreCase("y")) {
                    ENABLE_AZURE = true;
                    ENABLE_BIGQUERY = true;
                    ENABLE_SNOWFLAKE = true;
                    ENABLE_REDSHIFT = true;
                    ENABLE_POSTGRESQL = true;
                    ENABLE_DUCKDB = true;
                } else {
                    System.out.println("Please enable the configurations you want to use by setting the corresponding environment variables below");
                    System.out.println("ENABLE_BIGQUERY, ENABLE_DATABRICKS, ENABLE_AZURE, ENABLE_SNOWFLAKE, ENABLE_REDSHIFT, ENABLE_POSTGRESQL, ENABLE_ANY_JDBC");
                    System.exit(1);
                }
            }
            catch (IOException iOException) {
                System.out.println("Failed to read user input");
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            File file;
            File file2;
            if (stringArray.length == 0) {
                System.out.println("Please specify the target directory");
                System.exit(1);
            }
            Setup.askUserWhichConfigToEnable();
            File file3 = new File(stringArray[0]);
            if (!file3.exists()) {
                file3.mkdirs();
                System.out.println("Created target directory " + file3.getAbsolutePath());
            }
            Setup.setHttpClient();
            if (!Setup.anyDependencyEnabled()) {
                ENABLE_AZURE = true;
                ENABLE_BIGQUERY = true;
                ENABLE_SNOWFLAKE = true;
                ENABLE_REDSHIFT = true;
                ENABLE_POSTGRESQL = true;
                ENABLE_DUCKDB = true;
            }
            File file4 = new File(file3, "bin");
            if (Setup.isWindowsOs()) {
                file2 = new File(file4, "hadoop");
                file = new File(file2, "bin");
                if (!file.exists()) {
                    file.mkdirs();
                }
                for (String string : HADOOP_LIBS) {
                    File file5 = new File(file, string.substring(string.lastIndexOf("/") + 1));
                    Setup.downloadAndDisplayProgress(string, file5.getAbsolutePath());
                }
            } else {
                System.out.println("Unix OS detected");
            }
            file2 = new File(file4, "sl");
            if (SL_VERSION.endsWith("SNAPSHOT")) {
                Setup.deleteFile(new File(file2, STARLAKE_SNAPSHOT_JAR.getUrlName()));
                Setup.downloadAndDisplayProgress(new JarDependency[]{STARLAKE_SNAPSHOT_JAR}, file2, false);
            } else {
                Setup.deleteFile(new File(file2, STARLAKE_RELEASE_JAR.getUrlName()));
                Setup.downloadAndDisplayProgress(new JarDependency[]{STARLAKE_RELEASE_JAR}, file2, false);
            }
            file = new File(file4, "spark");
            if (!file.exists()) {
                Setup.downloadSpark(file4);
            }
            File file6 = new File(file4, "deps");
            Setup.downloadAndDisplayProgress(sparkDependencies, file6, true);
            Setup.updateSparkLog4j2Properties(file);
            Setup.downloadAndDisplayProgress(duckDbDependencies, file6, true);
            if (ENABLE_BIGQUERY) {
                Setup.downloadAndDisplayProgress(bigqueryDependencies, file6, true);
            } else {
                Setup.deleteDependencies(bigqueryDependencies, file6);
            }
            if (ENABLE_AZURE) {
                Setup.downloadAndDisplayProgress(azureDependencies, file6, true);
            } else {
                Setup.deleteDependencies(azureDependencies, file6);
            }
            if (ENABLE_SNOWFLAKE) {
                Setup.downloadAndDisplayProgress(snowflakeDependencies, file6, true);
            } else {
                Setup.deleteDependencies(snowflakeDependencies, file6);
            }
            if (ENABLE_REDSHIFT) {
                Setup.downloadAndDisplayProgress(redshiftDependencies, file6, true);
            } else {
                Setup.deleteDependencies(redshiftDependencies, file6);
            }
            if (ENABLE_POSTGRESQL) {
                Setup.downloadAndDisplayProgress(postgresqlDependencies, file6, true);
            } else {
                Setup.deleteDependencies(postgresqlDependencies, file6);
            }
            int n = stringArray.length > 1 && stringArray[1].equalsIgnoreCase("unix") ? 1 : 0;
            Setup.generateVersions(file3, n != 0);
        }
        catch (Exception exception) {
            System.out.println("Failed to download dependency" + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void downloadSpark(File file) throws IOException, InterruptedException {
        JarDependency jarDependency = SPARK_JAR;
        if (!SCALA_VERSION.equals("2.12")) {
            jarDependency = SPARK_JAR_213;
        }
        Setup.downloadAndDisplayProgress(new JarDependency[]{jarDependency}, file, false);
        String string = jarDependency.getUrlName();
        File file2 = new File(file, string);
        ProcessBuilder processBuilder = new ProcessBuilder("tar", "-xzf", file2.getAbsolutePath(), "-C", file.getAbsolutePath()).inheritIO();
        Process process = processBuilder.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Failed to extract spark tarball");
            interruptedException.printStackTrace();
        }
        file2.delete();
        File file3 = new File(file, string.substring(0, string.lastIndexOf(".")));
        file3.renameTo(new File(file, "spark"));
        file3 = new File(file, "spark");
        File file4 = new File(file3, "conf/log4j2.properties.template");
        file4.renameTo(new File(file3, "conf/log4j2.properties"));
    }

    private static void downloadAndDisplayProgress(JarDependency[] jarDependencyArray, File file, boolean bl) throws IOException, InterruptedException {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (bl) {
            Setup.deleteDependencies(jarDependencyArray, file);
        }
        for (JarDependency jarDependency : jarDependencyArray) {
            File file2 = new File(file, jarDependency.getUrlName());
            Setup.downloadAndDisplayProgress(jarDependency.url, file2.getAbsolutePath());
        }
    }

    private static void deleteDependencies(JarDependency[] jarDependencyArray, File file2) {
        if (file2.exists()) {
            for (JarDependency jarDependency : jarDependencyArray) {
                File[] fileArray = file2.listFiles(file -> file.getName().startsWith(jarDependency.artefactName));
                if (fileArray == null) continue;
                for (File file3 : fileArray) {
                    Setup.deleteFile(file3);
                }
            }
        }
    }

    private static void deleteFile(File file) {
        if (file.exists() && file.delete()) {
            System.out.println(file.getAbsolutePath() + " deleted");
        }
    }

    private static void downloadAndDisplayProgress(String string, String string2) throws IOException, InterruptedException {
        int n;
        int n2 = string.lastIndexOf("/") + 1;
        String string3 = string.substring(n2);
        String string4 = string.substring(0, n2);
        System.out.println("Downloading to " + string2 + " from " + string4 + " ...");
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string)).build();
        HttpResponse<InputStream> httpResponse = client.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
        long l = httpResponse.headers().firstValueAsLong("Content-Length").orElse(0L);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(httpResponse.body());
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        byte[] byArray = new byte[1024];
        long l2 = 0L;
        int n3 = 0;
        int n4 = 0;
        long l3 = System.currentTimeMillis();
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            l2 += (long)n;
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
            if (++n3 % 1000 != 0) continue;
            StringBuilder stringBuilder = new StringBuilder(" " + l2 / 1024L / 1024L + "/" + l / 1024L / 1024L + " MB");
            if (l > 0L) {
                stringBuilder.append(" (");
                stringBuilder.append(l2 * 100L / l);
                stringBuilder.append("%)");
            }
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l3;
            double d = 1024000.0 / (double)l5;
            double d2 = d * 1000.0;
            double d3 = d2 / 1024.0 / 1024.0;
            stringBuilder.append(" ");
            stringBuilder.append(String.format("[%.2f MB/sec]", d3));
            l3 = l4;
            n4 = stringBuilder.length();
            for (int i = 0; i < n4; ++i) {
                System.out.print("\b");
            }
            System.out.print(stringBuilder);
        }
        for (int i = 0; i < n4; ++i) {
            System.out.print("\b");
        }
        System.out.print(string3 + " downloaded");
        System.out.println();
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
        ((InputStream)bufferedInputStream).close();
    }

    private static class JarDependency {
        private final String url;
        private final String artefactName;

        public JarDependency(String string, String string2) {
            this.url = string2;
            this.artefactName = string;
        }

        public String getUrlName() {
            return this.url.substring(this.url.lastIndexOf("/") + 1);
        }
    }

    private static class UserPwdAuth
    extends Authenticator {
        private UserPwdAuth() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(username, password.toCharArray());
        }
    }
}

