/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.config;

import ai.starlake.config.Settings;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.utils.Utils$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DatasetArea$
implements StrictLogging {
    public static DatasetArea$ MODULE$;
    private final Logger logger;

    static {
        new DatasetArea$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Path path(String domain, String area, Settings settings) {
        if (area.contains("://")) {
            return new Path(area);
        }
        if (settings.appConfig().datasets().contains("://")) {
            return new Path(new StringBuilder(2).append(settings.appConfig().datasets()).append("/").append(area).append("/").append(domain).toString());
        }
        return new Path(new StringBuilder(3).append(settings.appConfig().fileSystem()).append("/").append(settings.appConfig().datasets()).append("/").append(area).append("/").append(domain).toString());
    }

    public Path path(String domain, Settings settings) {
        if (settings.appConfig().datasets().contains("://")) {
            return new Path(new StringBuilder(1).append(settings.appConfig().datasets()).append("/").append(domain).toString());
        }
        return new Path(new StringBuilder(2).append(settings.appConfig().fileSystem()).append("/").append(settings.appConfig().datasets()).append("/").append(domain).toString());
    }

    public Path path(Path domainPath, String schema) {
        return new Path(domainPath, schema);
    }

    public Path testsResults(String domain, Settings settings) {
        return this.path("_tests_results", settings);
    }

    public Path stage(String domain, Settings settings) {
        return this.path(domain, settings.appConfig().area().stage(), settings);
    }

    public Path incoming(String domain, Settings settings) {
        return this.path(domain, settings.appConfig().area().incoming(), settings);
    }

    public Path incoming(Settings settings) {
        return this.path("dummy", settings.appConfig().area().incoming(), settings).getParent();
    }

    public Path unresolved(String domain, Settings settings) {
        return this.path(domain, settings.appConfig().area().unresolved(), settings);
    }

    public Path archive(String domain, Settings settings) {
        return this.path(domain, settings.appConfig().area().archive(), settings);
    }

    public Path ingesting(String domain, Settings settings) {
        return this.path(domain, settings.appConfig().area().ingesting(), settings);
    }

    public Path export(String domain, Settings settings) {
        return this.path(domain, "export", settings);
    }

    public Path export(String domain, String table, Settings settings) {
        return new Path(this.export(domain, settings), table);
    }

    public Path refs(Settings settings) {
        return new Path(this.metadata(settings), "refs.sl.yml");
    }

    public Path env(Settings settings) {
        return new Path(this.metadata(settings), "env.sl.yml");
    }

    public Path env(String name, Settings settings) {
        return new Path(this.metadata(settings), new StringBuilder(11).append("env.").append(name).append(".sl.yml").toString());
    }

    public Path metrics(String domain, String schema, Settings settings) {
        return this.substituteDomainAndSchemaInPath(domain, schema, settings.appConfig().metrics().path());
    }

    public Path audit(String domain, String schema, Settings settings) {
        return this.substituteDomainAndSchemaInPath(domain, schema, settings.appConfig().audit().path());
    }

    public Path expectations(String domain, String schema, Settings settings) {
        return this.substituteDomainAndSchemaInPath(domain, schema, settings.appConfig().expectations().path());
    }

    public Path replay(String domain, Settings settings) {
        return this.path(domain, settings.appConfig().area().replay(), settings);
    }

    public Path substituteDomainAndSchemaInPath(String domain, String schema, String path) {
        return new Path(this.substituteDomainAndSchema(domain, schema, path));
    }

    public String substituteDomainAndSchema(String domain, String schema, String template) {
        String normalizedDomainName = Utils$.MODULE$.keepAlphaNum(domain);
        return template.replace("{{domain}}", domain).replace("{{normalized_domain}}", normalizedDomainName).replace("{{schema}}", schema);
    }

    public Path discreteMetrics(String domain, String schema, Settings settings) {
        return this.metrics(domain, "discrete", settings);
    }

    public Path continuousMetrics(String domain, String schema, Settings settings) {
        return this.metrics(domain, "continuous", settings);
    }

    public Path frequenciesMetrics(String domain, String schema, Settings settings) {
        return this.metrics(domain, "frequencies", settings);
    }

    public Path metadata(Settings settings) {
        return new Path(String.valueOf(settings.appConfig().metadata()));
    }

    public Path types(Settings settings) {
        return new Path(this.metadata(settings), "types");
    }

    public Path dags(Settings settings) {
        return new Path(settings.appConfig().dags());
    }

    public Path writeStrategies(Settings settings) {
        return new Path(settings.appConfig().writeStrategies());
    }

    public Path expectations(Settings settings) {
        return new Path(this.metadata(settings), "expectations");
    }

    public Path mapping(Settings settings) {
        return new Path(this.metadata(settings), "mapping");
    }

    public Path tests(Settings settings) {
        return new Path(this.metadata(settings), "tests");
    }

    public Path loadTests(Settings settings) {
        return new Path(this.tests(settings), "load");
    }

    public Path transformTests(Settings settings) {
        return new Path(this.tests(settings), "transform");
    }

    public Path load(Settings settings) {
        return new Path(this.metadata(settings), "load");
    }

    public Path cache(Settings settings) {
        return new Path(this.metadata(settings), ".cache");
    }

    public Path external(Settings settings) {
        return new Path(this.metadata(settings), "external");
    }

    public Path extract(Settings settings) {
        return new Path(this.metadata(settings), "extract");
    }

    public Path transform(Settings settings) {
        return new Path(this.metadata(settings), "transform");
    }

    public Path iamPolicyTags(Settings settings) {
        return new Path(this.metadata(settings), "iam-policy-tags.sl.yml");
    }

    public List<Path> folders(Settings settings) {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{this.metadata(settings), this.types(settings), this.load(settings), this.external(settings), this.extract(settings), this.transform(settings), this.expectations(settings), this.mapping(settings), this.incoming(settings)}));
    }

    public void initMetadata(StorageHandler storage, Settings settings) {
        this.folders(settings).foreach((Function1 & java.io.Serializable & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)storage.mkdirs(path)));
    }

    public void initDomains(StorageHandler storage, Iterable<String> domains, Settings settings) {
        domains.foreach((Function1 & java.io.Serializable & Serializable)domain -> {
            DatasetArea$.$anonfun$initDomains$1(settings, storage, domain);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$initDomains$1(Settings settings$1, StorageHandler storage$2, String domain2) {
        ((List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.stage((String)domain, settings$1), (List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.unresolved((String)domain, settings$1), (List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.archive((String)domain, settings$1), (List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.replay((String)domain, settings$1), (List)Nil$.MODULE$)))).map((Function1 & java.io.Serializable & Serializable)x$1 -> (Path)x$1.apply((Object)domain2), List$.MODULE$.canBuildFrom())).foreach((Function1 & java.io.Serializable & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)storage$2.mkdirs(path)));
    }

    private DatasetArea$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

