/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.Settings;
import ai.starlake.config.Settings$;
import ai.starlake.config.SparkEnv;
import ai.starlake.extract.BigQueryDatasetInfo$;
import ai.starlake.extract.BigQueryInfo$;
import ai.starlake.extract.BigQueryTableInfo;
import ai.starlake.extract.BigQueryTableInfo$;
import ai.starlake.extract.BigQueryTableInfo$$anon$1$;
import ai.starlake.extract.BigQueryTableInfoCmd$;
import ai.starlake.extract.BigQueryTablesConfig;
import ai.starlake.job.sink.bigquery.BigQuerySparkWriter$;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.schema.model.WriteMode$APPEND$;
import ai.starlake.utils.IngestionCounters;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.SparkJob;
import ai.starlake.utils.SparkJobResult;
import ai.starlake.utils.repackaged.BigQuerySchemaConverters;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableInfo;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple13;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class BigQueryTableInfo$
implements StrictLogging,
scala.Serializable {
    public static BigQueryTableInfo$ MODULE$;
    private final Logger logger;

    static {
        new BigQueryTableInfo$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public BigQueryTableInfo apply(TableInfo info, Timestamp logTime, Settings settings) {
        return new BigQueryTableInfo(info.getTableId().getProject(), info.getTableId().getDataset(), info.getTableId().getTable(), new Timestamp(Predef$.MODULE$.Long2long(info.getCreationTime())), new Timestamp(Predef$.MODULE$.Long2long(info.getExpirationTime())), new Timestamp(Predef$.MODULE$.Long2long(info.getLastModifiedTime())), info.getDescription(), Predef$.MODULE$.Long2long(info.getNumBytes()), Predef$.MODULE$.Long2long(info.getNumLongTermBytes()), info.getNumRows().longValue(), Predef$.MODULE$.Boolean2boolean(info.getRequirePartitionFilter()), logTime, settings.appConfig().tenant());
    }

    public void sink(BigQueryTablesConfig config, Settings iSettings) {
        Timestamp logTime = Timestamp.from(Instant.now());
        List<Tuple2<Dataset, List<Table>>> selectedInfos = this.extractTableInfos(config, iSettings);
        SparkJob job = new SparkJob(iSettings, selectedInfos, logTime){
            private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv;
            private SparkSession session;
            private final String appName;
            private final Logger logger;
            private volatile byte bitmap$0;
            private final Settings iSettings$1;
            private final List selectedInfos$1;
            private final Timestamp logTime$1;

            public SparkConf withExtraSparkConf(SparkConf sourceConfig) {
                return SparkJob.withExtraSparkConf$(this, sourceConfig);
            }

            public String getTableLocation(String domain, String schema) {
                return SparkJob.getTableLocation$(this, domain, schema);
            }

            public String getTableLocation(String fullTableName) {
                return SparkJob.getTableLocation$(this, fullTableName);
            }

            public void registerUdf(String udf) {
                SparkJob.registerUdf$(this, udf);
            }

            public String applicationId() {
                return JobBase.applicationId$(this);
            }

            public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(org.apache.spark.sql.Dataset<T> ds) {
                return DatasetLogging.DatasetHelper$(this, ds);
            }

            private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.ai$starlake$utils$SparkJob$$sparkEnv = SparkJob.ai$starlake$utils$SparkJob$$sparkEnv$(this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.ai$starlake$utils$SparkJob$$sparkEnv;
            }

            public SparkEnv ai$starlake$utils$SparkJob$$sparkEnv() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.ai$starlake$utils$SparkJob$$sparkEnv$lzycompute();
                }
                return this.ai$starlake$utils$SparkJob$$sparkEnv;
            }

            private SparkSession session$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.session = SparkJob.session$(this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.session;
            }

            public SparkSession session() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.session$lzycompute();
                }
                return this.session;
            }

            public String appName() {
                return this.appName;
            }

            public void ai$starlake$utils$JobBase$_setter_$appName_$eq(String x$1) {
                this.appName = x$1;
            }

            public Logger logger() {
                return this.logger;
            }

            public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
                this.logger = x$1;
            }

            public String name() {
                return "BigQueryTablesInfo";
            }

            public Settings settings() {
                return this.iSettings$1;
            }

            public Try<JobResult> run() {
                return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    List datasetInfos = (List)((List)$this.selectedInfos$1.map((Function1 & Serializable & scala.Serializable)x$1 -> (Dataset)x$1._1(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> BigQueryDatasetInfo$.MODULE$.apply((DatasetInfo)x$2, $this.logTime$1, this.settings()), List$.MODULE$.canBuildFrom());
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(anon.1.class.getClassLoader());
                    public final class Ai_starlake_extract_BigQueryTableInfo$$anon$1$$typecreator1$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("ai.starlake.extract.BigQueryDatasetInfo").asType().toTypeConstructor();
                        }

                        public Ai_starlake_extract_BigQueryTableInfo$$anon$1$$typecreator1$1(anon.1 $outer) {
                        }
                    }
                    org.apache.spark.sql.Dataset df = this.session().createDataFrame((Seq)datasetInfos, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_starlake_extract_BigQueryTableInfo$$anon$1$$typecreator1$1(null)));
                    return new SparkJobResult((Option<org.apache.spark.sql.Dataset<Row>>)Option$.MODULE$.apply((Object)df), (Option<IngestionCounters>)None$.MODULE$);
                });
            }
            {
                this.iSettings$1 = iSettings$1;
                this.selectedInfos$1 = selectedInfos$1;
                this.logTime$1 = logTime$1;
                StrictLogging.$init$((StrictLogging)this);
                DatasetLogging.$init$(this);
                JobBase.$init$(this);
                SparkJob.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(ai.starlake.extract.BigQueryTableInfo$$anon$1 ), $anonfun$run$2(scala.Tuple2 ), $anonfun$run$3(ai.starlake.extract.BigQueryTableInfo$$anon$1 com.google.cloud.bigquery.Dataset )}, serializedLambda);
            }
        };
        Try<JobResult> jobResult = job.run();
        boolean bl = false;
        Success success = null;
        Try<JobResult> try_ = jobResult;
        if (try_ instanceof Success) {
            SparkJobResult sparkJobResult;
            Option<org.apache.spark.sql.Dataset<Row>> option;
            bl = true;
            success = (Success)try_;
            JobResult jobResult2 = (JobResult)success.value();
            if (jobResult2 instanceof SparkJobResult && (option = (sparkJobResult = (SparkJobResult)jobResult2).dataframe()) instanceof Some) {
                Some some = (Some)option;
                org.apache.spark.sql.Dataset dfDataset = (org.apache.spark.sql.Dataset)some.value();
                BigQuerySparkWriter$.MODULE$.sinkInAudit((org.apache.spark.sql.Dataset<Row>)dfDataset, "dataset_info", (Option<String>)new Some((Object)"Information related to datasets"), (Option<Schema>)new Some((Object)BigQuerySchemaConverters.toBigQuerySchema(dfDataset.schema())), (WriteMode)config.writeMode().getOrElse((Function0 & Serializable & scala.Serializable)() -> WriteMode$APPEND$.MODULE$), config.accessToken(), iSettings);
                List tableInfos = (List)((List)selectedInfos.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3._2(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.apply((TableInfo)x$4, logTime, iSettings), List$.MODULE$.canBuildFrom());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Ai_starlake_extract_BigQueryTableInfo$$typecreator1$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("ai.starlake.extract.BigQueryTableInfo").asType().toTypeConstructor();
                    }

                    public Ai_starlake_extract_BigQueryTableInfo$$typecreator1$2() {
                    }
                }
                org.apache.spark.sql.Dataset dfTable = job.session().createDataFrame((Seq)tableInfos, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_starlake_extract_BigQueryTableInfo$$typecreator1$2()));
                BigQuerySparkWriter$.MODULE$.sinkInAudit((org.apache.spark.sql.Dataset<Row>)dfTable, "table_info", (Option<String>)new Some((Object)"Information related to tables"), (Option<Schema>)new Some((Object)BigQuerySchemaConverters.toBigQuerySchema(dfTable.schema())), (WriteMode)config.writeMode().getOrElse((Function0 & Serializable & scala.Serializable)() -> WriteMode$APPEND$.MODULE$), config.accessToken(), iSettings);
                return;
            }
        }
        if (bl) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Could not extract BigQuery tables info");
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw new Exception("Could not extract BigQuery tables info", exception);
        }
        throw new MatchError(try_);
    }

    public List<Tuple2<Dataset, List<Table>>> extractTableInfos(BigQueryTablesConfig config, Settings settings) {
        List infos = BigQueryInfo$.MODULE$.extractInfo(config, settings);
        List selectedInfos = config.tables().isEmpty() ? infos : (List)infos.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Dataset dsInfo = (Dataset)tuple2._1();
                List tableInfos = (List)tuple2._2();
                Option key = config.tables().keys().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.equalsIgnoreCase(dsInfo.getDatasetId().getDataset())));
                Option option = key;
                if (None$.MODULE$.equals(option)) {
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String key2 = (String)some.value();
                    List configTables = (List)config.tables().apply((Object)key2);
                    List selectedTables = (List)tableInfos.filter((Function1 & Serializable & scala.Serializable)tableInfo -> BoxesRunTime.boxToBoolean((boolean)configTables.contains((Object)tableInfo.getTableId().getTable())));
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)dsInfo, (Object)selectedTables)));
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        return selectedInfos;
    }

    public Try<BoxedUnit> run(String[] args) {
        Settings settings = Settings$.MODULE$.apply(Settings$.MODULE$.referenceConfig(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        return BigQueryTableInfoCmd$.MODULE$.run((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), settings.schemaHandler(settings.schemaHandler$default$1(), settings.schemaHandler$default$2()), settings).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            BigQueryTableInfo$.$anonfun$run$4(x$6);
            return BoxedUnit.UNIT;
        });
    }

    public BigQueryTableInfo apply(String database, String dataset, String table, Timestamp creationTime, Timestamp expirationTime, Timestamp lastModifiedTime, String description, long numBytes, long numLongTermBytes, long numRows, boolean requirePartitionFilter, Timestamp timestamp, String tenant) {
        return new BigQueryTableInfo(database, dataset, table, creationTime, expirationTime, lastModifiedTime, description, numBytes, numLongTermBytes, numRows, requirePartitionFilter, timestamp, tenant);
    }

    public Option<Tuple13<String, String, String, Timestamp, Timestamp, Timestamp, String, Object, Object, Object, Object, Timestamp, String>> unapply(BigQueryTableInfo x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple13((Object)x$0.database(), (Object)x$0.dataset(), (Object)x$0.table(), (Object)x$0.creationTime(), (Object)x$0.expirationTime(), (Object)x$0.lastModifiedTime(), (Object)x$0.description(), (Object)BoxesRunTime.boxToLong((long)x$0.numBytes()), (Object)BoxesRunTime.boxToLong((long)x$0.numLongTermBytes()), (Object)BoxesRunTime.boxToLong((long)x$0.numRows()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.requirePartitionFilter()), (Object)x$0.timestamp(), (Object)x$0.tenant()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$run$4(JobResult x$6) {
    }

    private BigQueryTableInfo$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

