/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.exceptions.DataExtractionException;
import ai.starlake.extract.DeltaRow;
import ai.starlake.extract.Extract;
import ai.starlake.extract.ExtractDataCmd$;
import ai.starlake.extract.ExtractDataConfig;
import ai.starlake.extract.ExtractTableAttributes;
import ai.starlake.extract.ExtractUtils$;
import ai.starlake.extract.FileFormat;
import ai.starlake.extract.FileFormat$;
import ai.starlake.extract.JDBCSchema;
import ai.starlake.extract.JDBCSchema$;
import ai.starlake.extract.JDBCSchemas;
import ai.starlake.extract.JDBCTable;
import ai.starlake.extract.JDBCTable$;
import ai.starlake.extract.JdbcDbUtils$;
import ai.starlake.extract.LastExportUtils;
import ai.starlake.extract.LastExportUtils$;
import ai.starlake.extract.LastExportUtils$NoBound$;
import ai.starlake.extract.LastExportUtils$Unbounded$;
import ai.starlake.extract.ParUtils$;
import ai.starlake.extract.PartitionConfig;
import ai.starlake.extract.SLObjectRowWriterProcessor;
import ai.starlake.extract.TableColumn;
import ai.starlake.extract.TableExtractDataConfig;
import ai.starlake.extract.UserExtractDataConfig;
import ai.starlake.schema.handlers.FileInfo;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.PrimitiveType;
import ai.starlake.schema.model.PrimitiveType$date$;
import ai.starlake.schema.model.PrimitiveType$decimal$;
import ai.starlake.schema.model.PrimitiveType$int$;
import ai.starlake.schema.model.PrimitiveType$long$;
import ai.starlake.schema.model.PrimitiveType$short$;
import ai.starlake.schema.model.PrimitiveType$string$;
import ai.starlake.schema.model.PrimitiveType$timestamp$;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.Type;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import ai.starlake.utils.YamlSerde$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.processor.RowWriterProcessor;
import com.univocity.parsers.conversions.Conversion;
import com.univocity.parsers.conversions.Conversions;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvRoutines;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0001\rua\u0001B\u000e\u001d\u0001\rB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\u007f\u0001!\tA\u001a\u0005\u0006[\u0002!IA\u001c\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011!\ty\u0005\u0001C\u00019\u0005E\u0003\u0002CA-\u0001\u0011\u0005A$a\u0017\t\u0011\u0005\u001d\u0004\u0001\"\u0001\u001d\u0003SB\u0001\"!\u001d\u0001\t\u0003a\u00121\u000f\u0005\t\u0003;\u0003A\u0011\u0001\u000f\u0002 \"A\u0011q\u0015\u0001\u0005\u0002q\tI\u000bC\u0004\u00026\u0002!I!a.\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"A\u0011Q\u001d\u0001\u0005\u0002q\t9\u000fC\u0004\u0002p\u0002!I!!=\t\u0011\t5\u0001\u0001\"\u0001\u001d\u0005\u001fAqAa\u0011\u0001\t\u0003\u0011)\u0005C\u0005\u0003b\u0001\t\n\u0011\"\u0001\u0003d!9!\u0011\u0010\u0001\u0005\n\tm\u0004b\u0002BM\u0001\u0011%!1\u0014\u0005\t\u0005\u001b\u0004A\u0011\u0001\u000f\u0003P\"A!Q\u001c\u0001\u0005\u0002q\u0011y\u000e\u0003\u0005\u0003l\u0002!\t\u0001\bBw\u0011!\u00119\u0010\u0001C\u00019\te\b\u0002\u0003B\u0000\u0001\u0011\u0005Ad!\u0001\u0003\u001d\u0015CHO]1di\u0012\u000bG/\u0019&pE*\u0011QDH\u0001\bKb$(/Y2u\u0015\ty\u0002%\u0001\u0005ti\u0006\u0014H.Y6f\u0015\u0005\t\u0013AA1j\u0007\u0001\u00192\u0001\u0001\u0013)!\t)c%D\u0001\u001d\u0013\t9CDA\u0004FqR\u0014\u0018m\u0019;\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0017/\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0018\u0002\u0007\r|W.\u0003\u00022U\tYA*\u0019>z\u0019><w-\u001b8h\u00035\u00198\r[3nC\"\u000bg\u000e\u001a7feB\u0011A'O\u0007\u0002k)\u0011agN\u0001\tQ\u0006tG\r\\3sg*\u0011\u0001HH\u0001\u0007g\u000eDW-\\1\n\u0005i*$!D*dQ\u0016l\u0017\rS1oI2,'/\u0001\u0004=S:LGO\u0010\u000b\u0003{y\u0002\"!\n\u0001\t\u000bI\u0012\u0001\u0019A\u001a\u0002\u0007I,h\u000e\u0006\u0002B-R\u0011!I\u0014\t\u0004\u0007\"SU\"\u0001#\u000b\u0005\u00153\u0015\u0001B;uS2T\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u0012\u00131\u0001\u0016:z!\tYE*D\u0001G\u0013\tieI\u0001\u0003V]&$\b\"B(\u0004\u0001\b\u0001\u0016\u0001C:fiRLgnZ:\u0011\u0005E#V\"\u0001*\u000b\u0005Ms\u0012AB2p]\u001aLw-\u0003\u0002V%\nA1+\u001a;uS:<7\u000fC\u0003X\u0007\u0001\u0007\u0001,\u0001\u0003be\u001e\u001c\bcA&Z7&\u0011!L\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00039\u000et!!X1\u0011\u0005y3U\"A0\u000b\u0005\u0001\u0014\u0013A\u0002\u001fs_>$h(\u0003\u0002c\r\u00061\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011g\t\u0006\u0002hSR\u0011!\n\u001b\u0005\u0006\u001f\u0012\u0001\u001d\u0001\u0015\u0005\u0006'\u0012\u0001\rA\u001b\t\u0003K-L!\u0001\u001c\u000f\u0003+U\u001bXM]#yiJ\f7\r\u001e#bi\u0006\u001cuN\u001c4jO\u0006YQ\r\u001f;sC\u000e$H)\u0019;b)\tyw\u0010\u0006\u0003KaF\u0014\b\"B(\u0006\u0001\b\u0001\u0006\"\u0002\u001a\u0006\u0001\b\u0019\u0004\"B:\u0006\u0001\b!\u0018a\u00054pe.Tu.\u001b8UCN\\7+\u001e9q_J$\bcA&vo&\u0011aO\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005alX\"A=\u000b\u0005i\\\u0018\u0001\u00039be\u0006dG.\u001a7\u000b\u0005q4\u0015AC2pY2,7\r^5p]&\u0011a0\u001f\u0002\u0014\r>\u00148NS8j]R\u000b7o[*vaB|'\u000f\u001e\u0005\b\u0003\u0003)\u0001\u0019AA\u0002\u00035)\u0007\u0010\u001e:bGR\u001cuN\u001c4jOB\u0019Q%!\u0002\n\u0007\u0005\u001dADA\tFqR\u0014\u0018m\u0019;ECR\f7i\u001c8gS\u001e\facY8naV$X\rU1si&$\u0018n\u001c8D_:4\u0017n\u001a\u000b\r\u0003\u001b\t)\"a\u0006\u0002\u001c\u0005e\u0012Q\t\t\u0005\u0017V\fy\u0001E\u0002&\u0003#I1!a\u0005\u001d\u0005=\u0001\u0016M\u001d;ji&|gnQ8oM&<\u0007bBA\u0001\r\u0001\u0007\u00111\u0001\u0005\u0007\u000331\u0001\u0019A.\u0002\u0015\u0011|W.Y5o\u001d\u0006lW\rC\u0004\u0002\u001e\u0019\u0001\r!a\b\u0002\u0013Q\f'\r\\3OC6,\u0007\u0003BA\u0011\u0003gqA!a\t\u000209!\u0011QEA\u0017\u001d\u0011\t9#a\u000b\u000f\u0007y\u000bI#C\u0001\"\u0013\ty\u0002%\u0003\u0002\u001e=%\u0019\u0011\u0011\u0007\u000f\u0002\u0017)#'m\u0019#c+RLGn]\u0005\u0005\u0003k\t9DA\u0005UC\ndWMT1nK*\u0019\u0011\u0011\u0007\u000f\t\u000f\u0005mb\u00011\u0001\u0002>\u000512-\u001e:sK:$H+\u00192mK\u0012+g-\u001b8ji&|g\u000e\u0005\u0003Lk\u0006}\u0002cA\u0013\u0002B%\u0019\u00111\t\u000f\u0003\u0013)#%i\u0011+bE2,\u0007bBA$\r\u0001\u0007\u0011\u0011J\u0001\u000bi\u0006\u0014G.Z!uiJ\u001c\bcA\u0013\u0002L%\u0019\u0011Q\n\u000f\u0003-\u0015CHO]1diR\u000b'\r\\3BiR\u0014\u0018NY;uKN\fqD]3t_24X\rV1cY\u0016\u001cFO]5oOB\u000b'\u000f^5uS>tg)\u001e8d)\u0019\t\u0019&!\u0016\u0002XA!1*^A\u0010\u0011\u001d\t\ta\u0002a\u0001\u0003\u0007Aq!a\u000f\b\u0001\u0004\ti$\u0001\u000bsKN|GN^3Ok6\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003;\n\u0019'!\u001a\u0011\u0007-\u000by&C\u0002\u0002b\u0019\u00131!\u00138u\u0011\u001d\t\t\u0001\u0003a\u0001\u0003\u0007Aq!a\u000f\t\u0001\u0004\ti$\u0001\fsKN|GN^3QCJ$\u0018\u000e^5p]\u000e{G.^7o)\u0019\tY'!\u001c\u0002pA\u00191*^.\t\u000f\u0005\u0005\u0011\u00021\u0001\u0002\u0004!9\u00111H\u0005A\u0002\u0005u\u0012aD2mK\u0006tG+\u00192mK\u001aKG.Z:\u0015\u000f)\u000b)(a \u0002\u001c\"9\u0011q\u000f\u0006A\u0002\u0005e\u0014AD:u_J\fw-\u001a%b]\u0012dWM\u001d\t\u0004i\u0005m\u0014bAA?k\tq1\u000b^8sC\u001e,\u0007*\u00198eY\u0016\u0014\bbBAA\u0015\u0001\u0007\u00111Q\u0001\u000fi\u0006\u0014G.Z(viB,H\u000fR5s!\u0011\t))a&\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000b!AZ:\u000b\t\u00055\u0015qR\u0001\u0007Q\u0006$wn\u001c9\u000b\t\u0005E\u00151S\u0001\u0007CB\f7\r[3\u000b\u0005\u0005U\u0015aA8sO&!\u0011\u0011TAD\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005u!\u00021\u0001\u0002 \u0005)2m\\7qkR,G+\u00192mK\u001a+Go\u00195TSj,GCBAQ\u0003G\u000b)\u000b\u0005\u0003Lk\u0006u\u0003bBA\u0001\u0017\u0001\u0007\u00111\u0001\u0005\b\u0003wY\u0001\u0019AA\u001f\u0003EI7\u000fV1cY\u00164U\u000f\u001c7FqB|'\u000f\u001e\u000b\u0007\u0003W\u000b\t,a-\u0011\u0007-\u000bi+C\u0002\u00020\u001a\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\u00021\u0001\r!a\u0001\t\u000f\u0005mB\u00021\u0001\u0002>\u0005I\u0012n\u001d)s_\u000e,7o\u001d+bE2,7/\u0012=ue\u0006\u001cG/[8o)\u0019\tY+!/\u0002<\"9\u0011\u0011A\u0007A\u0002\u0005\r\u0001bBA_\u001b\u0001\u0007\u0011qX\u0001\u0013M&dG/\u001a:fI*#'mY*dQ\u0016l\u0017\rE\u0002&\u0003\u0003L1!a1\u001d\u0005)QEIQ\"TG\",W.Y\u0001\u0013SN,\u0005\u0010\u001e:bGRLwN\u001c(fK\u0012,G\r\u0006\u0005\u0002J\u00065\u0017\u0011[An)\u0011\tY+a3\t\u000b=s\u00019\u0001)\t\u000f\u0005=g\u00021\u0001\u0002\u0004\u0005\tR\r\u001f;sC\u000e$H)\u0019;b\u0007>tg-[4\t\u000f\u0005Mg\u00021\u0001\u0002V\u00061B/\u00192mK\u0016CHO]1di\u0012\u000bG/Y\"p]\u001aLw\rE\u0002&\u0003/L1!!7\u001d\u0005Y!\u0016M\u00197f\u000bb$(/Y2u\t\u0006$\u0018mQ8oM&<\u0007bBAo\u001d\u0001\u0007\u0011q\\\u0001\rCV$\u0017\u000e^\"pYVlgn\u001d\t\u0005\u0003C\t\t/\u0003\u0003\u0002d\u0006]\"aB\"pYVlgn]\u0001\u0017e\u0016\u001cx\u000e\u001c<f)\u0006\u0014G.\u001a#fM&t\u0017\u000e^5p]R1\u0011QHAu\u0003[Dq!a;\u0010\u0001\u0004\ty,\u0001\u0006kI\n\u001c7k\u00195f[\u0006Dq!!\b\u0010\u0001\u0004\ty\"\u0001\rhKR\fVo\u001c;fIB\u000b'\u000f^5uS>t7i\u001c7v[:$RaWAz\u0005\u0013Aq!!>\u0011\u0001\u0004\t90\u0001\u0006d_:tWm\u0019;j_:\u0004B!!?\u0003\u00049!\u00111`A\u0000\u001d\u0011\t)#!@\n\u0005Ms\u0012b\u0001B\u0001%\u0006A1+\u001a;uS:<7/\u0003\u0003\u0003\u0006\t\u001d!AC\"p]:,7\r^5p]*\u0019!\u0011\u0001*\t\r\t-\u0001\u00031\u0001\\\u0003=\u0001\u0018M\u001d;ji&|gnQ8mk6t\u0017\u0001E3yiJ\f7\r\u001e+bE2,G)\u0019;b)1\u0011\tBa\u0006\u0003\u001a\tm!q\u0004B\u0011)\u0015\u0011%1\u0003B\u000b\u0011\u0015y\u0015\u0003q\u0001Q\u0011\u0015\u0019\u0018\u0003q\u0001u\u0011\u001d\t\t!\u0005a\u0001\u0003\u0007Aq!a5\u0012\u0001\u0004\t)\u000e\u0003\u0004\u0003\u001eE\u0001\raW\u0001\bG>tG/\u001a=u\u0011\u001d\ti.\u0005a\u0001\u0003?DqAa\t\u0012\u0001\u0004\u0011)#A\u000bfqR\u0014\u0018m\u0019;fI\u0012\u000bG/Y\"p]N,X.\u001a:\u0011\u0015-\u00139c\u0017B\u0016\u0003C\u0013Y$C\u0002\u0003*\u0019\u0013\u0011BR;oGRLwN\\\u001a\u0011\t\t5\"qG\u0007\u0003\u0005_QAA!\r\u00034\u0005\u00191/\u001d7\u000b\u0005\tU\u0012\u0001\u00026bm\u0006LAA!\u000f\u00030\tI!+Z:vYR\u001cV\r\u001e\t\u0005\u0007\"\u0013i\u0004E\u0002L\u0005\u007fI1A!\u0011G\u0005\u0011auN\\4\u0002\u001bM\fHNR3uG\"\fV/\u001a:z)%Y&q\tB%\u0005\u0017\u0012i\u0006C\u0004\u0002\u0002I\u0001\r!a\u0001\t\u000f\u0005M'\u00031\u0001\u0002V\"9!Q\n\nA\u0002\t=\u0013\u0001\u00032pk:$\u0017M]=\u0011\t\tE#q\u000b\b\u0005\u0003G\u0011\u0019&C\u0002\u0003Vq\tq\u0002T1ti\u0016C\bo\u001c:u+RLGn]\u0005\u0005\u00053\u0012YFA\u0006C_VtG-\u0019:z\t\u00164'b\u0001B+9!I!q\f\n\u0011\u0002\u0003\u0007\u00111N\u0001\u0013G>dW/\u001c8U_\u0012K7\u000f\u001e:jEV$X-A\ftc24U\r^2i#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\r\u0016\u0005\u0003W\u00129g\u000b\u0002\u0003jA!!1\u000eB;\u001b\t\u0011iG\u0003\u0003\u0003p\tE\u0014!C;oG\",7m[3e\u0015\r\u0011\u0019HR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B<\u0005[\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\u0019w.\u001c9vi\u0016\u0004&/\u001a9be\u0016\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0007\u0003~\t\u001d%\u0011\u0012BF\u0005\u001f\u0013\u0019\n\u0006\u0003\u0003\u0000\t\u0015\u0005\u0003\u0002B\u0017\u0005\u0003KAAa!\u00030\t\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\t\u000b=#\u00029\u0001)\t\u000f\u0005\u0005A\u00031\u0001\u0002\u0004!9\u00111\u001b\u000bA\u0002\u0005U\u0007b\u0002BG)\u0001\u0007!qJ\u0001\u0007E>,h\u000eZ:\t\r\tEE\u00031\u0001\\\u0003=\u0011w.\u001e8eCJL8i\u001c8uKb$\bbBA{)\u0001\u0007!Q\u0013\t\u0005\u0005[\u00119*\u0003\u0003\u0003\u0006\t=\u0012!D4fi\n{WO\u001c3be&,7\u000f\u0006\u0006\u0003\u001e\n\u0015'q\u0019Be\u0005\u0017$bAa(\u0003@\n\u0005\u0007cB&\u0003\"\n\u0015&\u0011X\u0005\u0004\u0005G3%A\u0002+va2,'\u0007\u0005\u0004\u0003(\nE&q\u0017\b\u0005\u0005S\u0013iKD\u0002_\u0005WK\u0011aR\u0005\u0004\u0005_3\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005g\u0013)L\u0001\u0003MSN$(b\u0001BX\rB91J!)\u0003P\u0005u\u0003\u0003\u0002B)\u0005wKAA!0\u0003\\\ti!i\\;oI\u0006\u0014\u0018.Z:EK\u001aDQaT\u000bA\u0004ACaAa1\u0016\u0001\b!\u0018a\u00014ka\"9\u0011\u0011A\u000bA\u0002\u0005\r\u0001bBAj+\u0001\u0007\u0011Q\u001b\u0005\b\u0005;)\u0002\u0019AA\u0010\u0011\u001d\ti.\u0006a\u0001\u0003?\f!eY8naV$X-\u00127jO&\u0014G.\u001a+bE2,7OR8s\u000bb$(/Y2uS>tGCBA`\u0005#\u0014\u0019\u000eC\u0004\u0002lZ\u0001\r!a0\t\u000f\tUg\u00031\u0001\u0003X\u0006i\u0011N\\2mk\u0012,G+\u00192mKN\u0004bAa*\u0003Z\u0006}\u0011\u0002\u0002Bn\u0005k\u00131aU3r\u0003U\u0019'/Z1uK\u0012{W.Y5o\u001fV$\b/\u001e;ESJ$bA!9\u0003f\n%H\u0003BAB\u0005GDq!a\u001e\u0018\u0001\b\tI\bC\u0004\u0003h^\u0001\r!a!\u0002\u001b\t\f7/Z(viB,H\u000fR5s\u0011\u001d\tIb\u0006a\u0001\u0003?\tA#\u001b8ji\u0016C\bo\u001c:u\u0003V$\u0017\u000e\u001e+bE2,G\u0003\u0002Bx\u0005g$B!a8\u0003r\")q\n\u0007a\u0002!\"9!Q\u001f\rA\u0002\u0005]\u0018AE2p]:,7\r^5p]N+G\u000f^5oON\facZ3u'R\u0014\u0018N\\4QCJ$\u0018\u000e^5p]\u001a+hn\u0019\u000b\u0005\u0003W\u0012Y\u0010\u0003\u0004\u0003~f\u0001\raW\u0001\u0007I\n$\u0016\u0010]3\u0002'MLgn\u001b)beRLG/[8o)>4\u0015\u000e\\3\u0015\u0019\r\r1qAB\t\u0007'\u0019)b!\u0007\u0015\t\tm2Q\u0001\u0005\b\u0003oR\u00029AA=\u0011\u001d\u0019IA\u0007a\u0001\u0007\u0017\tAb\\;uaV$hi\u001c:nCR\u00042!JB\u0007\u0013\r\u0019y\u0001\b\u0002\u000b\r&dWMR8s[\u0006$\bbBAj5\u0001\u0007\u0011Q\u001b\u0005\u0007\u0005;Q\u0002\u0019A.\t\u000f\r]!\u00041\u0001\u0003,\u0005\u0011!o\u001d\u0005\b\u00077Q\u0002\u0019AAQ\u0003\u0015Ig\u000eZ3y\u0001")
public class ExtractDataJob
extends Extract
implements LazyLogging {
    private final SchemaHandler schemaHandler;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ExtractDataJob extractDataJob = this;
        synchronized (extractDataJob) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Try<BoxedUnit> run(String[] args, Settings settings) {
        return ExtractDataCmd$.MODULE$.run((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), this.schemaHandler, settings).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            ExtractDataJob.$anonfun$run$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void run(UserExtractDataConfig config, Settings settings) {
        BoxedUnit boxedUnit;
        Charset x$2;
        Path x$1;
        Success success;
        boolean bl;
        Path extractConfigPath = this.mappingPath(DatasetArea$.MODULE$.extract(settings), config.extractConfig(), settings);
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> settings.storageHandler(settings.storageHandler$default$1()).exists(extractConfigPath));
        if (try_ instanceof Failure ? true : try_ instanceof Success && false == (bl = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
            throw new FileNotFoundException(new StringBuilder(60).append("Could not found extract config ").append(config.extractConfig()).append(". Please check its existence.").toString());
        }
        StorageHandler qual$1 = settings.storageHandler(settings.storageHandler$default$1());
        String content = Formatter$.MODULE$.RichFormatter(qual$1.read(x$1 = extractConfigPath, x$2 = qual$1.read$default$2())).richFormat(this.schemaHandler.activeEnvVars(this.schemaHandler.activeEnvVars$default$1(), this.schemaHandler.activeEnvVars$default$2(), this.schemaHandler.activeEnvVars$default$3()), (Map<String, Object>)Predef$.MODULE$.Map().empty(), settings);
        JDBCSchemas jdbcSchemas = YamlSerde$.MODULE$.deserializeYamlExtractConfig(content, config.extractConfig(), YamlSerde$.MODULE$.deserializeYamlExtractConfig$default$3());
        Option<String> option = jdbcSchemas.connectionRef();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception("No connectionRef defined for jdbc schemas.");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        String connectionRef = (String)some.value();
        Settings.Connection dataConnectionSettings = settings.appConfig().getConnection(connectionRef);
        String auditConnectionRef = (String)jdbcSchemas.auditConnectionRef().getOrElse((Function0 & Serializable & scala.Serializable)() -> settings.appConfig().audit().getConnectionRef(settings));
        Settings.Connection auditConnectionSettings = settings.appConfig().getConnection(auditConnectionRef);
        FileFormat fileFormat = ((FileFormat)jdbcSchemas.output().getOrElse((Function0 & Serializable & scala.Serializable)() -> new FileFormat(FileFormat$.MODULE$.apply$default$1(), FileFormat$.MODULE$.apply$default$2(), FileFormat$.MODULE$.apply$default$3(), FileFormat$.MODULE$.apply$default$4(), FileFormat$.MODULE$.apply$default$5(), FileFormat$.MODULE$.apply$default$6(), FileFormat$.MODULE$.apply$default$7(), FileFormat$.MODULE$.apply$default$8()))).fillWithDefault();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Extraction will be formatted following {}", new Object[]{fileFormat});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SchemaHandler implicitSchemaHandler = this.schemaHandler;
        Option<ForkJoinTaskSupport> forkJoinTaskSupport = ParUtils$.MODULE$.createForkSupport(config.parallelism(), ParUtils$.MODULE$.createForkSupport$default$2());
        ((GenericTraversableTemplate)ParUtils$.MODULE$.makeParallel(jdbcSchemas.jdbcSchemas(), forkJoinTaskSupport).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ExtractDataJob.$anonfun$run$5(config, s)))).foreach((Function1 & Serializable & scala.Serializable)jdbcSchema -> {
            ExtractDataJob.$anonfun$run$8(this, config, settings, fileFormat, dataConnectionSettings, auditConnectionSettings, implicitSchemaHandler, forkJoinTaskSupport, jdbcSchema);
            return BoxedUnit.UNIT;
        });
        forkJoinTaskSupport.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            ExtractDataJob.$anonfun$run$11(x$4);
            return BoxedUnit.UNIT;
        });
    }

    private void extractData(ExtractDataConfig extractConfig, Settings settings, SchemaHandler schemaHandler, Option<ForkJoinTaskSupport> forkJoinTaskSupport) {
        BoxedUnit boxedUnit;
        Some some;
        boolean bl;
        StorageHandler storageHandler = settings.storageHandler(settings.storageHandler$default$1());
        List<Attribute> auditColumns = this.initExportAuditTable(extractConfig.audit(), settings);
        Option<Object> option = extractConfig.jdbcSchema().sanitizeName();
        String domainName = option instanceof Some && true == (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? Utils$.MODULE$.keepAlphaNum(extractConfig.jdbcSchema().schema()) : extractConfig.jdbcSchema().schema();
        Path tableOutputDir = this.createDomainOutputDir(extractConfig.baseOutputDir(), domainName, storageHandler);
        JDBCSchema filteredJdbcSchema = this.computeEligibleTablesForExtraction(extractConfig.jdbcSchema(), extractConfig.includeTables());
        boolean doTablesExtraction = this.isProcessTablesExtraction(extractConfig, filteredJdbcSchema);
        if (doTablesExtraction) {
            List x$1 = extractConfig.excludeTables().toList();
            Option<String> x$2 = filteredJdbcSchema.copy$default$1();
            String x$3 = filteredJdbcSchema.copy$default$2();
            Option<String> x$4 = filteredJdbcSchema.copy$default$3();
            Option<String> x$5 = filteredJdbcSchema.copy$default$4();
            List<JDBCTable> x$6 = filteredJdbcSchema.copy$default$5();
            List<String> x$7 = filteredJdbcSchema.copy$default$7();
            Option<String> x$8 = filteredJdbcSchema.copy$default$8();
            Option<String> x$9 = filteredJdbcSchema.copy$default$9();
            Option<Trim> x$102 = filteredJdbcSchema.copy$default$10();
            Option<String> x$11 = filteredJdbcSchema.copy$default$11();
            Option<Object> x$12 = filteredJdbcSchema.copy$default$12();
            Map<String, String> x$13 = filteredJdbcSchema.copy$default$13();
            Option<Object> x$14 = filteredJdbcSchema.copy$default$14();
            Option<String> x$15 = filteredJdbcSchema.copy$default$15();
            Option<Object> x$16 = filteredJdbcSchema.copy$default$16();
            Option<Object> x$17 = filteredJdbcSchema.copy$default$17();
            Map<String, ExtractTableAttributes> selectedTablesAndColumns = JdbcDbUtils$.MODULE$.extractJDBCTables(filteredJdbcSchema.copy(x$2, x$3, x$4, x$5, x$6, (List<String>)x$1, x$7, x$8, x$9, x$102, x$11, x$12, x$13, x$14, x$15, x$16, x$17), extractConfig.data(), true, true, settings, forkJoinTaskSupport);
            long globalStart = System.currentTimeMillis();
            List extractionResults = ((GenTraversableOnce)ParUtils$.MODULE$.makeParallel(selectedTablesAndColumns.toList(), forkJoinTaskSupport).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String tableName = (String)tuple2._1();
                    ExtractTableAttributes tableAttrs = (ExtractTableAttributes)tuple2._2();
                    return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                        BoxedUnit boxedUnit;
                        String context = new StringBuilder(3).append("[").append(extractConfig.jdbcSchema().schema()).append(".").append(tableName).append("]").toString();
                        Option<JDBCTable> currentTableDefinition = this.resolveTableDefinition(extractConfig.jdbcSchema(), tableName);
                        Map currentTableConnectionOptions = (Map)currentTableDefinition.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.connectionOptions()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
                        boolean fullExport = this.isTableFullExport(extractConfig, currentTableDefinition);
                        Option<Object> fetchSize = this.computeTableFetchSize(extractConfig, currentTableDefinition);
                        Option<PartitionConfig> partitionConfig = this.computePartitionConfig(extractConfig, domainName, tableName, currentTableDefinition, tableAttrs);
                        TableExtractDataConfig tableExtractDataConfig = new TableExtractDataConfig(domainName, tableName, (Option<String>)currentTableDefinition.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.sql()), tableAttrs.columNames(), fullExport, fetchSize, tableOutputDir, tableAttrs.filterOpt(), partitionConfig);
                        if (this.isExtractionNeeded(extractConfig, tableExtractDataConfig, auditColumns, settings)) {
                            if (extractConfig.cleanOnExtract()) {
                                this.cleanTableFiles(storageHandler, tableOutputDir, tableName);
                            }
                            Settings.Connection x$18 = extractConfig.data().mergeOptionsWith((Map<String, String>)currentTableConnectionOptions);
                            JDBCSchema x$19 = extractConfig.copy$default$1();
                            Path x$20 = extractConfig.copy$default$2();
                            int x$21 = extractConfig.copy$default$3();
                            int x$22 = extractConfig.copy$default$4();
                            Option<Object> x$23 = extractConfig.copy$default$5();
                            Option<Object> x$24 = extractConfig.copy$default$6();
                            Option<Function1<Object, Object>> x$25 = extractConfig.copy$default$7();
                            boolean x$26 = extractConfig.copy$default$8();
                            boolean x$27 = extractConfig.copy$default$9();
                            Seq<String> x$28 = extractConfig.copy$default$10();
                            Seq<String> x$29 = extractConfig.copy$default$11();
                            FileFormat x$30 = extractConfig.copy$default$12();
                            Settings.Connection x$31 = extractConfig.copy$default$14();
                            return this.extractTableData(extractConfig.copy(x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$18, x$31), tableExtractDataConfig, context, auditColumns, (Function3<String, ResultSet, Option<Object>, Try<Object>>)(Function3 & Serializable & scala.Serializable)(x$7, x$8, x$9) -> this.sinkPartitionToFile(extractConfig.outputFormat(), tableExtractDataConfig, (String)x$7, (ResultSet)x$8, (Option<Object>)x$9, storageHandler), settings, forkJoinTaskSupport);
                        }
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Extraction skipped. {}.{} data is fresh enough.", new Object[]{domainName, tableName});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return new Success((Object)BoxedUnit.UNIT);
                    }).flatten(Predef$.MODULE$.$conforms());
                }
                throw new MatchError((Object)tuple2);
            }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toList();
            String elapsedTime = ExtractUtils$.MODULE$.toHumanElapsedTimeFrom(globalStart);
            int nbFailures = extractionResults.count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isFailure()));
            String dataExtractionFailures = ((TraversableOnce)extractionResults.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Failure failure;
                Throwable e;
                Try try_ = x0$2;
                if (try_ instanceof Failure && (e = (failure = (Failure)try_).exception()) instanceof DataExtractionException) {
                    DataExtractionException dataExtractionException = (DataExtractionException)e;
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new StringBuilder(1).append(dataExtractionException.domain()).append(".").append(dataExtractionException.table()).toString()));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }, List$.MODULE$.canBuildFrom())).mkString(", ");
            int n = nbFailures;
            switch (n) {
                case 0: {
                    BoxedUnit boxedUnit2;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Extracted successfully all tables in {}", new Object[]{elapsedTime});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    return;
                }
            }
            if (extractConfig.ignoreExtractionFailure() && new StringOps(Predef$.MODULE$.augmentString(dataExtractionFailures)).nonEmpty()) {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Failed to extract {} tables: {}", new Object[]{BoxesRunTime.boxToInteger((int)n), dataExtractionFailures});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                return;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(dataExtractionFailures)).nonEmpty()) {
                throw new RuntimeException(new StringBuilder(27).append("Failed to extract ").append(n).append(" tables: ").append(dataExtractionFailures).toString());
            }
            throw new RuntimeException(new StringBuilder(39).append("Encountered ").append(n).append(" failures during extraction").toString());
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Tables extraction skipped");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Option<PartitionConfig> computePartitionConfig(ExtractDataConfig extractConfig, String domainName, String tableName, Option<JDBCTable> currentTableDefinition, ExtractTableAttributes tableAttrs) {
        return this.resolvePartitionColumn(extractConfig, currentTableDefinition).map((Function1 & Serializable & scala.Serializable)partitionColumn -> {
            int numPartitions = this.resolveNumPartitions(extractConfig, currentTableDefinition);
            PrimitiveType partitionColumnType = (PrimitiveType)tableAttrs.columNames().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ExtractDataJob.$anonfun$computePartitionConfig$2(partitionColumn, x$11))).flatMap((Function1 & Serializable & scala.Serializable)attr -> $this.schemaHandler.types($this.schemaHandler.types$default$1()).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ExtractDataJob.$anonfun$computePartitionConfig$4(attr, x$12)))).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.primitiveType()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception(new StringBuilder(59).append("Could not find column type for partition column ").append((String)partitionColumn).append(" in table ").append(domainName).append(".").append(tableName).toString());
            });
            Option<String> stringPartitionFuncTpl = this.resolveTableStringPartitionFunc(extractConfig, currentTableDefinition);
            return new PartitionConfig((String)partitionColumn, partitionColumnType, stringPartitionFuncTpl, numPartitions);
        });
    }

    public Option<String> resolveTableStringPartitionFunc(ExtractDataConfig extractConfig, Option<JDBCTable> currentTableDefinition) {
        return currentTableDefinition.flatMap((Function1 & Serializable & scala.Serializable)x$14 -> x$14.stringPartitionFunc()).orElse((Function0 & Serializable & scala.Serializable)() -> extractConfig.jdbcSchema().stringPartitionFunc()).orElse((Function0 & Serializable & scala.Serializable)() -> this.getStringPartitionFunc(extractConfig.data().getJdbcEngineName().toString()));
    }

    public int resolveNumPartitions(ExtractDataConfig extractConfig, Option<JDBCTable> currentTableDefinition) {
        return BoxesRunTime.unboxToInt((Object)currentTableDefinition.flatMap((Function1 & Serializable & scala.Serializable)tbl -> tbl.numPartitions()).orElse((Function0 & Serializable & scala.Serializable)() -> extractConfig.jdbcSchema().numPartitions()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> extractConfig.numPartitions()));
    }

    public Option<String> resolvePartitionColumn(ExtractDataConfig extractConfig, Option<JDBCTable> currentTableDefinition) {
        return currentTableDefinition.flatMap((Function1 & Serializable & scala.Serializable)x$15 -> x$15.partitionColumn()).orElse((Function0 & Serializable & scala.Serializable)() -> extractConfig.jdbcSchema().partitionColumn());
    }

    public void cleanTableFiles(StorageHandler storageHandler, Path tableOutputDir, String tableName) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Deleting all files of {}", new Object[]{tableName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Path x$1 = tableOutputDir;
        boolean x$2 = false;
        String x$3 = storageHandler.list$default$2();
        LocalDateTime x$4 = storageHandler.list$default$3();
        Option<Pattern> x$5 = storageHandler.list$default$5();
        boolean x$6 = storageHandler.list$default$6();
        ((List)storageHandler.list(x$1, x$3, x$4, x$2, x$5, x$6).filter((Function1 & Serializable & scala.Serializable)fileInfo -> BoxesRunTime.boxToBoolean((boolean)ExtractDataJob.$anonfun$cleanTableFiles$1(tableName, fileInfo)))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            ExtractDataJob.$anonfun$cleanTableFiles$2(this, storageHandler, f);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> computeTableFetchSize(ExtractDataConfig extractConfig, Option<JDBCTable> currentTableDefinition) {
        return currentTableDefinition.flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.fetchSize()).orElse((Function0 & Serializable & scala.Serializable)() -> extractConfig.jdbcSchema().fetchSize());
    }

    public boolean isTableFullExport(ExtractDataConfig extractConfig, Option<JDBCTable> currentTableDefinition) {
        return BoxesRunTime.unboxToBoolean((Object)extractConfig.cliFullExport().orElse((Function0 & Serializable & scala.Serializable)() -> currentTableDefinition.flatMap((Function1 & Serializable & scala.Serializable)x$17 -> x$17.fullExport())).orElse((Function0 & Serializable & scala.Serializable)() -> extractConfig.jdbcSchema().fullExport()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    private boolean isProcessTablesExtraction(ExtractDataConfig extractConfig, JDBCSchema filteredJdbcSchema) {
        return extractConfig.jdbcSchema().tables().isEmpty() || filteredJdbcSchema.tables().nonEmpty();
    }

    public boolean isExtractionNeeded(ExtractDataConfig extractDataConfig, TableExtractDataConfig tableExtractDataConfig, List<Attribute> auditColumns, Settings settings) {
        return BoxesRunTime.unboxToBoolean((Object)extractDataConfig.extractionPredicate().flatMap((Function1 & Serializable & scala.Serializable)predicate -> ((Option)JdbcDbUtils$.MODULE$.withJDBCConnection(extractDataConfig.audit().options(), (Function1 & Serializable & scala.Serializable)connection -> LastExportUtils$.MODULE$.getMaxTimestampFromSuccessfulExport((Connection)connection, extractDataConfig, tableExtractDataConfig, "start_ts", auditColumns, settings), settings)).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)predicate.apply$mcZJ$sp(t.getTime())))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    public Option<JDBCTable> resolveTableDefinition(JDBCSchema jdbcSchema, String tableName) {
        return ((TraversableLike)((SeqLike)jdbcSchema.tables().flatMap((Function1 & Serializable & scala.Serializable)table -> {
            String string = table.name();
            String string2 = "*";
            if (!(string == null ? string2 != null : !string.equals(string2)) || table.name().equalsIgnoreCase(tableName)) {
                return Option$.MODULE$.option2Iterable((Option)new Some(table));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)ExtractDataJob.$anonfun$resolveTableDefinition$2(tableName, x$18)), Ordering.Boolean$.MODULE$.reverse())).headOption();
    }

    private String getQuotedPartitionColumn(Settings.Connection connection, String partitionColumn) {
        return connection.quoteIdentifier(partitionColumn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<BoxedUnit> extractTableData(ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, String context, List<Attribute> auditColumns, Function3<String, ResultSet, Option<Object>, Try<Object>> extractedDataConsumer, Settings settings, Option<ForkJoinTaskSupport> forkJoinTaskSupport) {
        BoxedUnit boxedUnit;
        boolean bl;
        Tuple2<List<Tuple2<LastExportUtils.BoundaryDef, Object>>, LastExportUtils.BoundariesDef> tuple2 = this.getBoundaries(extractConfig, tableExtractDataConfig, context, auditColumns, settings, forkJoinTaskSupport);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List boundaries = (List)tuple2._1();
        LastExportUtils.BoundariesDef boundDef = (LastExportUtils.BoundariesDef)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)boundaries, (Object)boundDef);
        List boundaries2 = (List)tuple22._1();
        LastExportUtils.BoundariesDef boundDef2 = (LastExportUtils.BoundariesDef)tuple22._2();
        long tableStart = System.currentTimeMillis();
        AtomicLong tableCount = new AtomicLong();
        List extractionResults = (List)boundaries2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LastExportUtils.BoundaryDef bounds = (LastExportUtils.BoundaryDef)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    String string;
                    LastExportUtils.BoundaryDef boundaryDef = bounds;
                    if (boundaryDef instanceof LastExportUtils.Boundary) {
                        string = new StringBuilder(2).append(context).append("[").append(index).append("]").toString();
                    } else if (LastExportUtils$Unbounded$.MODULE$.equals(boundaryDef)) {
                        string = context;
                    } else {
                        throw new MatchError((Object)boundaryDef);
                    }
                    String boundaryContext = string;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("{} bounds = {}", new Object[]{boundaryContext, bounds});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return JdbcDbUtils$.MODULE$.withJDBCConnection(extractConfig.data().options(), (Function1 & Serializable & scala.Serializable)connection -> Using$.MODULE$.resource((Object)this.computePrepareStatement(extractConfig, tableExtractDataConfig, bounds, boundaryContext, (Connection)connection, settings), (Function1 & Serializable & scala.Serializable)statement -> {
                        long partitionStart = System.currentTimeMillis();
                        Try try_ = (Try)Using$.MODULE$.resource((Object)statement.executeQuery(), (Function1 & Serializable & scala.Serializable)rs -> {
                            Some some;
                            LastExportUtils.BoundaryDef boundaryDef = bounds;
                            if (boundaryDef instanceof LastExportUtils.Boundary) {
                                some = new Some((Object)BoxesRunTime.boxToInteger((int)index));
                            } else if (LastExportUtils$Unbounded$.MODULE$.equals(boundaryDef)) {
                                some = None$.MODULE$;
                            } else {
                                throw new MatchError((Object)boundaryDef);
                            }
                            return (Try)extractedDataConsumer.apply((Object)boundaryContext, rs, (Object)some);
                        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                        if (try_ instanceof Failure) {
                            BoxedUnit boxedUnit;
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            if (this.logger().underlying().isErrorEnabled()) {
                                String arg$macro$1 = boundaryContext;
                                this.logger().underlying().error(new StringOps("%s Encountered an error during extraction.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Utils$.MODULE$.logException(this.logger(), exception);
                            throw exception;
                        }
                        if (!(try_ instanceof Success)) {
                            throw new MatchError((Object)try_);
                        }
                        Success success = (Success)try_;
                        long value = BoxesRunTime.unboxToLong((Object)success.value());
                        long count = value;
                        long currentTableCount = tableCount.addAndGet(count);
                        LastExportUtils.BoundariesDef boundariesDef = boundDef2;
                        if (boundariesDef instanceof LastExportUtils.Bounds) {
                            Some some;
                            PartitionConfig p;
                            BoxedUnit boxedUnit;
                            LastExportUtils.Bounds bounds = (LastExportUtils.Bounds)boundariesDef;
                            int lineLength = 100;
                            int progressPercent = bounds.count() == 0L ? lineLength : (int)(currentTableCount * (long)lineLength / bounds.count());
                            String progressPercentFilled = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), progressPercent).map((Function1 & Serializable & scala.Serializable)x$20 -> ExtractDataJob.$anonfun$extractTableData$6(BoxesRunTime.unboxToInt((Object)x$20)), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
                            String progressPercentUnfilled = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(progressPercent), lineLength).map((Function1 & Serializable & scala.Serializable)x$21 -> ExtractDataJob.$anonfun$extractTableData$7(BoxesRunTime.unboxToInt((Object)x$21)), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
                            String progressBar = new StringBuilder(5).append("[").append(progressPercentFilled).append(progressPercentUnfilled).append("] ").append(progressPercent).append(" %").toString();
                            long partitionEnd = System.currentTimeMillis();
                            String elapsedTime = ExtractUtils$.MODULE$.toHumanElapsedTimeFrom(tableStart);
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("{} {}. Elapsed time: {}", new Object[]{context, progressBar, elapsedTime});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Option<PartitionConfig> option = tableExtractDataConfig.partitionConfig();
                            if (!(option instanceof Some) || (p = (PartitionConfig)(some = (Some)option).value()) == null) {
                                if (None$.MODULE$.equals(option)) {
                                    throw new RuntimeException("Should never happen since we are fetching an interval");
                                }
                                throw new MatchError(option);
                            }
                            PartitionConfig partitionConfig = p;
                            DeltaRow deltaRow = new DeltaRow(extractConfig.jdbcSchema().schema(), tableExtractDataConfig.table(), bounds.max(), new Timestamp(partitionStart), new Timestamp(partitionEnd), (int)(partitionEnd - partitionStart), count, true, partitionConfig.partitionColumn(), Integer.toString(index));
                            return BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt(JdbcDbUtils$.MODULE$.withJDBCConnection(extractConfig.audit().options(), (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)LastExportUtils$.MODULE$.insertNewLastExport(connection, deltaRow, (Option<PrimitiveType>)new Some((Object)partitionConfig.partitionColumnType()), extractConfig.audit(), (List<Attribute>)auditColumns, settings)), settings)));
                        }
                        if (LastExportUtils$NoBound$.MODULE$.equals(boundariesDef)) {
                            return BoxedUnit.UNIT;
                        }
                        throw new MatchError((Object)boundariesDef);
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$), settings);
                }).recoverWith((PartialFunction)new scala.Serializable(null, extractConfig, tableExtractDataConfig){
                    public static final long serialVersionUID = 0L;
                    private final ExtractDataConfig extractConfig$8;
                    private final TableExtractDataConfig tableExtractDataConfig$3;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof Exception) {
                            return (B1)new Failure((Throwable)new DataExtractionException(this.extractConfig$8.jdbcSchema().schema(), this.tableExtractDataConfig$3.table()));
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return throwable instanceof Exception;
                    }
                    {
                        this.extractConfig$8 = extractConfig$8;
                        this.tableExtractDataConfig$3 = tableExtractDataConfig$3;
                    }
                });
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        if (extractionResults.exists((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)x$22.isFailure()))) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("{} An error occured during extraction.", new Object[]{context});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            extractionResults.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExtractDataJob.$anonfun$extractTableData$10(this, x0$2);
                return BoxedUnit.UNIT;
            });
            bl = false;
        } else {
            bl = true;
        }
        boolean success = bl;
        long tableEnd = System.currentTimeMillis();
        int duration = (int)(tableEnd - tableStart);
        String elapsedTime = ExtractUtils$.MODULE$.toHumanElapsedTime(duration);
        if (success) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("{} Extracted all lines in {}", new Object[]{context, elapsedTime});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{} Extraction took {}", new Object[]{context, elapsedTime});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LastExportUtils.BoundariesDef boundariesDef = boundDef2;
        if (boundariesDef instanceof LastExportUtils.Bounds) {
            Some some;
            PartitionConfig p;
            LastExportUtils.Bounds bounds = (LastExportUtils.Bounds)boundariesDef;
            Option<PartitionConfig> option = tableExtractDataConfig.partitionConfig();
            if (!(option instanceof Some) || (p = (PartitionConfig)(some = (Some)option).value()) == null) throw new RuntimeException("Should never happen since we are fetching an interval");
            PartitionConfig partitionConfig = p;
            DeltaRow deltaRow = new DeltaRow(extractConfig.jdbcSchema().schema(), tableExtractDataConfig.table(), bounds.max(), new Timestamp(tableStart), new Timestamp(tableEnd), duration, bounds.count(), success, partitionConfig.partitionColumn(), "ALL");
            BoxesRunTime.unboxToInt(JdbcDbUtils$.MODULE$.withJDBCConnection(extractConfig.audit().options(), (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)LastExportUtils$.MODULE$.insertNewLastExport(connection, deltaRow, (Option<PrimitiveType>)new Some((Object)partitionConfig.partitionColumnType()), extractConfig.audit(), (List<Attribute>)auditColumns, settings)), settings));
        } else {
            if (!LastExportUtils$NoBound$.MODULE$.equals(boundariesDef)) throw new MatchError((Object)boundariesDef);
            DeltaRow deltaRow = new DeltaRow(extractConfig.jdbcSchema().schema(), tableExtractDataConfig.table(), BoxesRunTime.boxToLong((long)tableStart), new Timestamp(tableStart), new Timestamp(tableEnd), (int)(tableEnd - tableStart), tableCount.get(), tableCount.get() >= 0L, "FULL", "ALL");
            BoxesRunTime.unboxToInt(JdbcDbUtils$.MODULE$.withJDBCConnection(extractConfig.audit().options(), (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)LastExportUtils$.MODULE$.insertNewLastExport(connection, deltaRow, (Option<PrimitiveType>)None$.MODULE$, extractConfig.audit(), (List<Attribute>)auditColumns, settings)), settings));
        }
        if (!success) return new Failure((Throwable)new RuntimeException(new StringBuilder(36).append(context).append(" An error occured during extraction.").toString()));
        return new Success((Object)BoxedUnit.UNIT);
    }

    public String sqlFetchQuery(ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, LastExportUtils.BoundaryDef boundary, Option<String> columnToDistribute) {
        String string;
        String dataColumnsProjection = tableExtractDataConfig.columnsProjectionQuery(extractConfig.data());
        String extraCondition = (String)tableExtractDataConfig.filterOpt().map((Function1 & Serializable & scala.Serializable)w -> new StringBuilder(4).append("and ").append((String)w).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        LastExportUtils.BoundaryDef boundaryDef = boundary;
        if (boundaryDef instanceof LastExportUtils.Boundary) {
            Tuple2 tuple2;
            LastExportUtils.Boundary boundary2 = (LastExportUtils.Boundary)boundaryDef;
            String columnExprToDistribute = (String)columnToDistribute.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getQuotedPartitionColumn(extractConfig.data(), tableExtractDataConfig.partitionColumn()));
            LastExportUtils.Boundary boundary3 = boundary2;
            if (boundary3 != null && boundary3.lower() instanceof LastExportUtils.InclusiveBound && boundary3.upper() instanceof LastExportUtils.InclusiveBound) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)">="), (Object)"<=");
            } else if (boundary3 != null && boundary3.lower() instanceof LastExportUtils.InclusiveBound && boundary3.upper() instanceof LastExportUtils.ExclusiveBound) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)">="), (Object)"<");
            } else if (boundary3 != null && boundary3.lower() instanceof LastExportUtils.ExclusiveBound && boundary3.upper() instanceof LastExportUtils.InclusiveBound) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)">"), (Object)"<=");
            } else if (boundary3 != null && boundary3.lower() instanceof LastExportUtils.ExclusiveBound && boundary3.upper() instanceof LastExportUtils.ExclusiveBound) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)">"), (Object)"<");
            } else {
                throw new MatchError((Object)boundary3);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String lowerOperator = (String)tuple22._1();
            String upperOperator = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)lowerOperator, (Object)upperOperator);
            String lowerOperator2 = (String)tuple23._1();
            String upperOperator2 = (String)tuple23._2();
            string = new StringBuilder(11).append(columnExprToDistribute).append(" ").append(upperOperator2).append(" ? AND ").append(columnExprToDistribute).append(" ").append(lowerOperator2).append(" ?").toString();
        } else if (LastExportUtils$Unbounded$.MODULE$.equals(boundaryDef)) {
            string = "1=1";
        } else {
            throw new MatchError((Object)boundaryDef);
        }
        String boundCondition = string;
        String dataSource = (String)tableExtractDataConfig.sql().map((Function1 & Serializable & scala.Serializable)x$24 -> new StringBuilder(17).append("(").append((String)x$24).append(") sl_data_source").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(extractConfig.data().quoteIdentifier(tableExtractDataConfig.domain())).append(".").append(extractConfig.data().quoteIdentifier(tableExtractDataConfig.table())).toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(37).append("select ").append(dataColumnsProjection).append("\n       |from ").append(dataSource).append("\n       |where ").append(boundCondition).append(" ").append(extraCondition).toString())).stripMargin();
    }

    public Option<String> sqlFetchQuery$default$4() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PreparedStatement computePrepareStatement(ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, LastExportUtils.BoundaryDef bounds, String boundaryContext, Connection connection, Settings settings) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2;
        LastExportUtils.BoundaryDef boundaryDef = bounds;
        if (LastExportUtils$Unbounded$.MODULE$.equals(boundaryDef)) {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.sqlFetchQuery(extractConfig, tableExtractDataConfig, bounds, this.sqlFetchQuery$default$4())), (Function1 & Serializable & scala.Serializable)x$25 -> {
                ExtractDataJob.$anonfun$computePrepareStatement$1(x$25);
                return BoxedUnit.UNIT;
            });
        } else {
            if (!(boundaryDef instanceof LastExportUtils.Boundary)) throw new MatchError((Object)boundaryDef);
            LastExportUtils.Boundary boundary = (LastExportUtils.Boundary)boundaryDef;
            PrimitiveType primitiveType = tableExtractDataConfig.partitionColumnType();
            if (((Object)PrimitiveType$int$.MODULE$).equals(primitiveType) ? true : (((Object)PrimitiveType$long$.MODULE$).equals(primitiveType) ? true : ((Object)PrimitiveType$short$.MODULE$).equals(primitiveType))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.sqlFetchQuery(extractConfig, tableExtractDataConfig, boundary, this.sqlFetchQuery$default$4())), (Function1 & Serializable & scala.Serializable)st -> {
                    ExtractDataJob.$anonfun$computePrepareStatement$2(boundary, st);
                    return BoxedUnit.UNIT;
                });
            } else if (((Object)PrimitiveType$decimal$.MODULE$).equals(primitiveType)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.sqlFetchQuery(extractConfig, tableExtractDataConfig, boundary, this.sqlFetchQuery$default$4())), (Function1 & Serializable & scala.Serializable)st -> {
                    ExtractDataJob.$anonfun$computePrepareStatement$3(boundary, st);
                    return BoxedUnit.UNIT;
                });
            } else if (((Object)PrimitiveType$date$.MODULE$).equals(primitiveType)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.sqlFetchQuery(extractConfig, tableExtractDataConfig, boundary, this.sqlFetchQuery$default$4())), (Function1 & Serializable & scala.Serializable)st -> {
                    ExtractDataJob.$anonfun$computePrepareStatement$4(boundary, st);
                    return BoxedUnit.UNIT;
                });
            } else if (((Object)PrimitiveType$timestamp$.MODULE$).equals(primitiveType)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.sqlFetchQuery(extractConfig, tableExtractDataConfig, boundary, this.sqlFetchQuery$default$4())), (Function1 & Serializable & scala.Serializable)st -> {
                    ExtractDataJob.$anonfun$computePrepareStatement$5(boundary, st);
                    return BoxedUnit.UNIT;
                });
            } else {
                if (!((Object)PrimitiveType$string$.MODULE$).equals(primitiveType) || !tableExtractDataConfig.hashFunc().isDefined()) throw new Exception(new StringBuilder(52).append("type ").append(tableExtractDataConfig.partitionColumnType()).append(" not supported for partition columnToDistribute").toString());
                Option<String> option = tableExtractDataConfig.hashFunc();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String tpl = (String)some.value();
                    String stringPartitionFunc = Utils$.MODULE$.parseJinjaTpl(tpl, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col"), (Object)this.getQuotedPartitionColumn(extractConfig.data(), tableExtractDataConfig.partitionColumn())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nb_partitions"), (Object)Integer.toString(tableExtractDataConfig.nbPartitions()))}))), settings);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.sqlFetchQuery(extractConfig, tableExtractDataConfig, boundary, (Option<String>)new Some((Object)stringPartitionFunc))), (Function1 & Serializable & scala.Serializable)st -> {
                        ExtractDataJob.$anonfun$computePrepareStatement$6(boundary, st);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw new RuntimeException("Should never happen since stringPartitionFuncTpl is always defined here");
                }
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String effectiveSql = (String)tuple22._1();
        Function1 statementFiller = (Function1)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)effectiveSql, (Object)statementFiller);
        String effectiveSql2 = (String)tuple23._1();
        Function1 statementFiller2 = (Function1)tuple23._2();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("{} SQL: {}", new Object[]{boundaryContext, effectiveSql2});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(effectiveSql2);
        statementFiller2.apply((Object)statement);
        tableExtractDataConfig.fetchSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fetchSize -> statement.setFetchSize(fetchSize));
        statement.setMaxRows(extractConfig.limit());
        return statement;
    }

    private Tuple2<List<Tuple2<LastExportUtils.BoundaryDef, Object>>, LastExportUtils.BoundariesDef> getBoundaries(ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, String context, List<Attribute> auditColumns, Settings settings, Option<ForkJoinTaskSupport> fjp) {
        Some some;
        Option<PartitionConfig> option = tableExtractDataConfig.partitionConfig();
        if (None$.MODULE$.equals(option)) {
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LastExportUtils$Unbounded$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$)), (Object)LastExportUtils$NoBound$.MODULE$);
        }
        if (option instanceof Some && (some = (Some)option).value() != null) {
            return (Tuple2)JdbcDbUtils$.MODULE$.withJDBCConnection(extractConfig.data().options(), (Function1 & Serializable & scala.Serializable)connection -> {
                BoxedUnit boxedUnit;
                LastExportUtils.Bounds boundaries;
                Map<String, String> map = extractConfig.data().options();
                Map<String, String> map2 = extractConfig.audit().options();
                LastExportUtils.Bounds bounds = !(map != null ? !map.equals(map2) : map2 != null) ? ExtractDataJob.getBoundariesWith$1(connection, connection, extractConfig, tableExtractDataConfig, auditColumns, settings) : (boundaries = (LastExportUtils.Bounds)JdbcDbUtils$.MODULE$.withJDBCConnection(extractConfig.audit().options(), (Function1 & Serializable & scala.Serializable)auditConnection -> ExtractDataJob.getBoundariesWith$1(auditConnection, connection, extractConfig, tableExtractDataConfig, auditColumns, settings), settings));
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("{} Boundaries : {}", new Object[]{context, boundaries});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParUtils$.MODULE$.makeParallel((List)boundaries.partitions().zipWithIndex(List$.MODULE$.canBuildFrom()), fjp).toList()), (Object)boundaries);
            }, settings);
        }
        throw new MatchError(option);
    }

    public JDBCSchema computeEligibleTablesForExtraction(JDBCSchema jdbcSchema, Seq<String> includeTables) {
        JDBCSchema jDBCSchema;
        if (includeTables.nonEmpty()) {
            List tablesToFetch;
            Object object;
            Option option = jdbcSchema.tables().find((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ExtractDataJob.$anonfun$computeEligibleTablesForExtraction$1(x$27)));
            if (option instanceof Some) {
                Some some = (Some)option;
                JDBCTable allTableDef = (JDBCTable)some.value();
                object = (Seq)((TraversableLike)includeTables.filterNot((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ExtractDataJob.$anonfun$computeEligibleTablesForExtraction$2(jdbcSchema, t)))).map((Function1 & Serializable & scala.Serializable)n -> allTableDef.copy((String)n, allTableDef.copy$default$2(), allTableDef.copy$default$3(), allTableDef.copy$default$4(), allTableDef.copy$default$5(), allTableDef.copy$default$6(), allTableDef.copy$default$7(), allTableDef.copy$default$8(), allTableDef.copy$default$9(), allTableDef.copy$default$10()), Seq$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                object = jdbcSchema.tables().isEmpty() ? (Seq)includeTables.map((Function1 & Serializable & scala.Serializable)x$29 -> new JDBCTable((String)x$29, (Option<String>)None$.MODULE$, (List<TableColumn>)Nil$.MODULE$, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, JDBCTable$.MODULE$.apply$default$9(), JDBCTable$.MODULE$.apply$default$10()), Seq$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Nil$ additionalTables = object;
            List x$1 = tablesToFetch = (List)((List)jdbcSchema.tables().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)includeTables.exists((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.equalsIgnoreCase(t.name())))))).$plus$plus((GenTraversableOnce)additionalTables, List$.MODULE$.canBuildFrom());
            Option<String> x$2 = jdbcSchema.copy$default$1();
            String x$3 = jdbcSchema.copy$default$2();
            Option<String> x$4 = jdbcSchema.copy$default$3();
            Option<String> x$5 = jdbcSchema.copy$default$4();
            List<String> x$6 = jdbcSchema.copy$default$6();
            List<String> x$7 = jdbcSchema.copy$default$7();
            Option<String> x$8 = jdbcSchema.copy$default$8();
            Option<String> x$9 = jdbcSchema.copy$default$9();
            Option<Trim> x$10 = jdbcSchema.copy$default$10();
            Option<String> x$11 = jdbcSchema.copy$default$11();
            Option<Object> x$12 = jdbcSchema.copy$default$12();
            Map<String, String> x$13 = jdbcSchema.copy$default$13();
            Option<Object> x$14 = jdbcSchema.copy$default$14();
            Option<String> x$15 = jdbcSchema.copy$default$15();
            Option<Object> x$16 = jdbcSchema.copy$default$16();
            Option<Object> x$17 = jdbcSchema.copy$default$17();
            jDBCSchema = jdbcSchema.copy(x$2, x$3, x$4, x$5, (List<JDBCTable>)x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        } else {
            jDBCSchema = jdbcSchema;
        }
        JDBCSchema updatedJdbcSchema = jDBCSchema;
        return updatedJdbcSchema;
    }

    public Path createDomainOutputDir(Path baseOutputDir, String domainName, StorageHandler storageHandler) {
        Path outputDir = new Path(baseOutputDir, domainName);
        storageHandler.mkdirs(outputDir);
        return outputDir;
    }

    public List<Attribute> initExportAuditTable(Settings.Connection connectionSettings, Settings settings) {
        return (List)JdbcDbUtils$.MODULE$.withJDBCConnection(connectionSettings.options(), (Function1 & Serializable & scala.Serializable)connection -> {
            String auditSchema = (String)settings.appConfig().audit().domain().getOrElse((Function0 & Serializable & scala.Serializable)() -> "audit");
            boolean existLastExportTable = JdbcDbUtils$.MODULE$.tableExists((Connection)connection, connectionSettings.jdbcUrl(), new StringBuilder(1).append(auditSchema).append(".").append(JdbcDbUtils$.MODULE$.lastExportTableName()).toString());
            if (!existLastExportTable && settings.appConfig().createSchemaIfNotExists()) {
                JdbcDbUtils$.MODULE$.createSchema((Connection)connection, auditSchema);
                Engine jdbcEngineName = connectionSettings.getJdbcEngineName();
                settings.appConfig().jdbcEngines().get((Object)jdbcEngineName.toString()).foreach((Function1 & Serializable & scala.Serializable)jdbcEngine -> {
                    String createTableSql = Formatter$.MODULE$.RichFormatter(((Settings.JdbcEngine.TableDdl)jdbcEngine.tables().apply((Object)"extract")).createSql()).richFormat((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)new StringBuilder(1).append(auditSchema).append(".").append(JdbcDbUtils$.MODULE$.lastExportTableName()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writeFormat"), (Object)settings.appConfig().defaultWriteFormat())}))), (Map<String, Object>)Predef$.MODULE$.Map().empty(), settings);
                    return JdbcDbUtils$.MODULE$.execute(createTableSql, (Connection)connection);
                });
            }
            String x$1 = auditSchema;
            .colon.colon x$2 = new .colon.colon((Object)new JDBCTable(JdbcDbUtils$.MODULE$.lastExportTableName(), (Option<String>)None$.MODULE$, (List<TableColumn>)Nil$.MODULE$, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, JDBCTable$.MODULE$.apply$default$9(), JDBCTable$.MODULE$.apply$default$10()), (List)Nil$.MODULE$);
            .colon.colon x$3 = new .colon.colon((Object)"TABLE", (List)Nil$.MODULE$);
            Option<String> x$4 = JDBCSchema$.MODULE$.apply$default$1();
            Option<String> x$5 = JDBCSchema$.MODULE$.apply$default$3();
            Option<String> x$6 = JDBCSchema$.MODULE$.apply$default$4();
            List<String> x$7 = JDBCSchema$.MODULE$.apply$default$6();
            Option<String> x$8 = JDBCSchema$.MODULE$.apply$default$8();
            Option<String> x$9 = JDBCSchema$.MODULE$.apply$default$9();
            Option<Trim> x$10 = JDBCSchema$.MODULE$.apply$default$10();
            Option<String> x$11 = JDBCSchema$.MODULE$.apply$default$11();
            Option<Object> x$12 = JDBCSchema$.MODULE$.apply$default$12();
            Map<String, String> x$13 = JDBCSchema$.MODULE$.apply$default$13();
            Option<Object> x$14 = JDBCSchema$.MODULE$.apply$default$14();
            Option<String> x$15 = JDBCSchema$.MODULE$.apply$default$15();
            Option<Object> x$16 = JDBCSchema$.MODULE$.apply$default$16();
            Option<Object> x$17 = JDBCSchema$.MODULE$.apply$default$17();
            return (List)JdbcDbUtils$.MODULE$.extractJDBCTables(new JDBCSchema(x$4, x$1, x$5, x$6, (List<JDBCTable>)x$2, x$7, (List<String>)x$3, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17), connectionSettings, true, true, settings, (Option<ForkJoinTaskSupport>)None$.MODULE$).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExtractDataJob.$anonfun$initExportAuditTable$4(x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    ExtractTableAttributes tableAttrs = (ExtractTableAttributes)tuple2._2();
                    return tableAttrs.columNames();
                }
                throw new MatchError((Object)tuple2);
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new RuntimeException(new StringBuilder(35).append(JdbcDbUtils$.MODULE$.lastExportTableName()).append(" table not found. Please create it.").toString());
            });
        }, settings);
    }

    public Option<String> getStringPartitionFunc(String dbType) {
        Map hashFunctions = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlserver"), (Object)"abs( binary_checksum({{col}}) % {{nb_partitions}} )"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"postgresql"), (Object)"abs( hashtext({{col}}) % {{nb_partitions}} )"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h2"), (Object)"ora_hash({{col}}, {{nb_partitions}} - 1)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mysql"), (Object)"crc32({{col}}) % {{nb_partitions}}"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oracle"), (Object)"ora_hash({{col}}, {{nb_partitions}} - 1)")}));
        return hashFunctions.get((Object)dbType);
    }

    public Try<Object> sinkPartitionToFile(FileFormat outputFormat, TableExtractDataConfig tableExtractDataConfig, String context, ResultSet rs, Option<Object> index2, StorageHandler storageHandler) {
        String filename = (String)index2.map((Function1 & Serializable & scala.Serializable)index -> ExtractDataJob.$anonfun$sinkPartitionToFile$1(tableExtractDataConfig, BoxesRunTime.unboxToInt((Object)index))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(5).append(tableExtractDataConfig.table()).append("-").append(tableExtractDataConfig.extractionDateTime()).append(".csv").toString());
        Path outFile = new Path(tableExtractDataConfig.tableOutputDir(), filename);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("{} Starting extraction into {}", new Object[]{context, filename});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return BoxesRunTime.unboxToLong((Object)Using$.MODULE$.resource((Object)storageHandler.output(outFile), (Function1 & Serializable & scala.Serializable)outFileWriter -> BoxesRunTime.boxToLong((long)ExtractDataJob.$anonfun$sinkPartitionToFile$4(this, outputFormat, context, rs, outFile, outFileWriter)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
        }).recoverWith((PartialFunction)new scala.Serializable(null, storageHandler, outFile){
            public static final long serialVersionUID = 0L;
            private final StorageHandler storageHandler$3;
            private final Path outFile$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.storageHandler$3.delete(this.outFile$1);
                return (B1)new Failure(A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.storageHandler$3 = storageHandler$3;
                this.outFile$1 = outFile$1;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$run$1(JobResult x$1) {
    }

    public static final /* synthetic */ boolean $anonfun$run$5(UserExtractDataConfig config$1, JDBCSchema s) {
        Tuple2 tuple2 = new Tuple2(config$1.includeSchemas(), config$1.excludeSchemas());
        if (tuple2 != null) {
            Seq seq = (Seq)tuple2._1();
            Seq seq2 = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq) && Nil$.MODULE$.equals(seq2)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Seq inc = (Seq)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq)) {
                return ((SeqLike)inc.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(), Seq$.MODULE$.canBuildFrom())).contains((Object)s.schema().toLowerCase());
            }
        }
        if (tuple2 != null) {
            Seq seq = (Seq)tuple2._1();
            Seq exc = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq)) {
                return !((SeqLike)exc.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toLowerCase(), Seq$.MODULE$.canBuildFrom())).contains((Object)s.schema().toLowerCase());
            }
        }
        if (tuple2 != null) {
            throw new RuntimeException("You can't specify includeShemas and excludeSchemas at the same time");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Function1 $anonfun$run$9(long userTimestamp) {
        return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)lastTimestamp -> lastTimestamp < userTimestamp;
    }

    public static final /* synthetic */ void $anonfun$run$8(ExtractDataJob $this, UserExtractDataConfig config$1, Settings settings$1, FileFormat fileFormat$1, Settings.Connection dataConnectionSettings$1, Settings.Connection auditConnectionSettings$1, SchemaHandler implicitSchemaHandler$1, Option forkJoinTaskSupport$1, JDBCSchema jdbcSchema) {
        Predef$.MODULE$.assert(config$1.numPartitions() > 0);
        $this.extractData(new ExtractDataConfig(jdbcSchema, $this.dataOutputDir(config$1.outputDir(), settings$1), config$1.limit(), config$1.numPartitions(), config$1.parallelism(), config$1.fullExport(), (Option<Function1<Object, Object>>)config$1.ifExtractedBefore().map((Function1 & Serializable & scala.Serializable)userTimestamp -> ExtractDataJob.$anonfun$run$9(BoxesRunTime.unboxToLong((Object)userTimestamp))), config$1.ignoreExtractionFailure(), config$1.cleanOnExtract(), config$1.includeTables(), config$1.excludeTables(), fileFormat$1, dataConnectionSettings$1.mergeOptionsWith(jdbcSchema.connectionOptions()), auditConnectionSettings$1), settings$1, implicitSchemaHandler$1, (Option<ForkJoinTaskSupport>)forkJoinTaskSupport$1);
    }

    public static final /* synthetic */ void $anonfun$run$11(ForkJoinTaskSupport x$4) {
        x$4.forkJoinPool().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$computePartitionConfig$2(String partitionColumn$1, Attribute x$11) {
        return x$11.name().equalsIgnoreCase(partitionColumn$1);
    }

    public static final /* synthetic */ boolean $anonfun$computePartitionConfig$4(Attribute attr$1, Type x$12) {
        String string = x$12.name();
        String string2 = attr$1.type();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$cleanTableFiles$1(String tableName$3, FileInfo fileInfo) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(16).append("^").append(tableName$3).append("-\\d{14}[\\.\\-].*").toString())).r().pattern().matcher(fileInfo.path().getName()).matches();
    }

    public static final /* synthetic */ void $anonfun$cleanTableFiles$2(ExtractDataJob $this, StorageHandler storageHandler$2, FileInfo f) {
        BoxedUnit boxedUnit;
        storageHandler$2.delete(f.path());
        if ($this.logger().underlying().isDebugEnabled()) {
            Path arg$macro$1 = f.path();
            $this.logger().underlying().debug(new StringOps("%s deleted").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$resolveTableDefinition$2(String tableName$4, JDBCTable x$18) {
        return x$18.name().equalsIgnoreCase(tableName$4);
    }

    public static final /* synthetic */ String $anonfun$extractTableData$6(int x$20) {
        return "#";
    }

    public static final /* synthetic */ String $anonfun$extractTableData$7(int x$21) {
        return " ";
    }

    public static final /* synthetic */ void $anonfun$extractTableData$10(ExtractDataJob $this, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            Utils$.MODULE$.logException($this.logger(), exception);
            return;
        }
        if (try_ instanceof Success) {
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$computePrepareStatement$1(PreparedStatement x$25) {
    }

    public static final /* synthetic */ void $anonfun$computePrepareStatement$2(LastExportUtils.Boundary x3$3, PreparedStatement st) {
        st.setLong(1, BoxesRunTime.unboxToLong((Object)x3$3.upper().value()));
        st.setLong(2, BoxesRunTime.unboxToLong((Object)x3$3.lower().value()));
    }

    public static final /* synthetic */ void $anonfun$computePrepareStatement$3(LastExportUtils.Boundary x3$3, PreparedStatement st) {
        st.setBigDecimal(1, (BigDecimal)x3$3.upper().value());
        st.setBigDecimal(2, (BigDecimal)x3$3.lower().value());
    }

    public static final /* synthetic */ void $anonfun$computePrepareStatement$4(LastExportUtils.Boundary x3$3, PreparedStatement st) {
        st.setDate(1, (Date)x3$3.upper().value());
        st.setDate(2, (Date)x3$3.lower().value());
    }

    public static final /* synthetic */ void $anonfun$computePrepareStatement$5(LastExportUtils.Boundary x3$3, PreparedStatement st) {
        st.setTimestamp(1, (Timestamp)x3$3.upper().value());
        st.setTimestamp(2, (Timestamp)x3$3.lower().value());
    }

    public static final /* synthetic */ void $anonfun$computePrepareStatement$6(LastExportUtils.Boundary x3$3, PreparedStatement st) {
        st.setLong(1, BoxesRunTime.unboxToLong((Object)x3$3.upper().value()));
        st.setLong(2, BoxesRunTime.unboxToLong((Object)x3$3.lower().value()));
    }

    private static final LastExportUtils.Bounds getBoundariesWith$1(Connection auditConnection, Connection connection$1, ExtractDataConfig extractConfig$10, TableExtractDataConfig tableExtractDataConfig$5, List auditColumns$4, Settings settings$5) {
        auditConnection.setAutoCommit(false);
        return LastExportUtils$.MODULE$.getBoundaries(connection$1, auditConnection, extractConfig$10, tableExtractDataConfig$5, (List<Attribute>)auditColumns$4, settings$5);
    }

    public static final /* synthetic */ boolean $anonfun$computeEligibleTablesForExtraction$1(JDBCTable x$27) {
        String string = x$27.name().trim();
        String string2 = "*";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$computeEligibleTablesForExtraction$3(String t$1, JDBCTable x$28) {
        return x$28.name().equalsIgnoreCase(t$1);
    }

    public static final /* synthetic */ boolean $anonfun$computeEligibleTablesForExtraction$2(JDBCSchema jdbcSchema$1, String t) {
        return jdbcSchema$1.tables().exists((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)ExtractDataJob.$anonfun$computeEligibleTablesForExtraction$3(t, x$28)));
    }

    public static final /* synthetic */ boolean $anonfun$initExportAuditTable$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String tableName = (String)tuple2._1();
            return tableName.equalsIgnoreCase(JdbcDbUtils$.MODULE$.lastExportTableName());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$sinkPartitionToFile$1(TableExtractDataConfig tableExtractDataConfig$6, int index) {
        return new StringBuilder(6).append(tableExtractDataConfig$6.table()).append("-").append(tableExtractDataConfig$6.extractionDateTime()).append("-").append(index).append(".csv").toString();
    }

    public static final /* synthetic */ long $anonfun$sinkPartitionToFile$4(ExtractDataJob $this, FileFormat outputFormat$1, String context$3, ResultSet rs$1, Path outFile$1, OutputStream outFileWriter) {
        BoxedUnit boxedUnit;
        CsvWriterSettings writerSettings = new CsvWriterSettings();
        CsvFormat format = new CsvFormat();
        outputFormat$1.quote().flatMap((Function1 & Serializable & scala.Serializable)x$31 -> new StringOps(Predef$.MODULE$.augmentString(x$31)).headOption()).foreach((Function1 & Serializable & scala.Serializable)q -> {
            format.setQuote(BoxesRunTime.unboxToChar((Object)q));
            return BoxedUnit.UNIT;
        });
        outputFormat$1.escape().flatMap((Function1 & Serializable & scala.Serializable)x$32 -> new StringOps(Predef$.MODULE$.augmentString(x$32)).headOption()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            format.setQuoteEscape(BoxesRunTime.unboxToChar((Object)x$1));
            return BoxedUnit.UNIT;
        });
        outputFormat$1.separator().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            format.setDelimiter(x$1);
            return BoxedUnit.UNIT;
        });
        writerSettings.setFormat((Format)format);
        outputFormat$1.nullValue().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            writerSettings.setNullValue(x$1);
            return BoxedUnit.UNIT;
        });
        outputFormat$1.withHeader().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            writerSettings.setHeaderWritingEnabled(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        CsvRoutines csvRoutines = new CsvRoutines(writerSettings);
        long extractionStartMs = System.currentTimeMillis();
        SLObjectRowWriterProcessor objectRowWriterProcessor = new SLObjectRowWriterProcessor(context$3);
        outputFormat$1.datePattern().foreach((Function1 & Serializable & scala.Serializable)dtp -> {
            objectRowWriterProcessor.convertType(Date.class, new Conversion[]{Conversions.toDate((String[])new String[]{dtp})});
            return BoxedUnit.UNIT;
        });
        outputFormat$1.timestampPattern().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            objectRowWriterProcessor.convertType(Timestamp.class, new Conversion[]{Conversions.toDate((String[])new String[]{tp})});
            return BoxedUnit.UNIT;
        });
        writerSettings.setQuoteAllFields(true);
        writerSettings.setRowWriterProcessor((RowWriterProcessor)objectRowWriterProcessor);
        csvRoutines.write(rs$1, outFileWriter, (String)outputFormat$1.encoding().getOrElse((Function0 & Serializable & scala.Serializable)() -> StandardCharsets.UTF_8.name()));
        String elapsedTime = ExtractUtils$.MODULE$.toHumanElapsedTimeFrom(extractionStartMs);
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("{} Extracted {} rows and saved into {} in {}", new Object[]{context$3, BoxesRunTime.boxToLong((long)objectRowWriterProcessor.getRecordsCount()), outFile$1, elapsedTime});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return objectRowWriterProcessor.getRecordsCount();
    }

    public ExtractDataJob(SchemaHandler schemaHandler) {
        this.schemaHandler = schemaHandler;
        LazyLogging.$init$((LazyLogging)this);
    }
}

