/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.extract.BigQueryTablesConfig;
import ai.starlake.extract.Extract;
import ai.starlake.extract.ExtractBigQuerySchemaCmd$;
import ai.starlake.extract.ExtractJDBCSchemaCmd$;
import ai.starlake.extract.ExtractSchemaConfig;
import ai.starlake.extract.ExtractTableAttributes;
import ai.starlake.extract.ExtractUtils$;
import ai.starlake.extract.FileFormat;
import ai.starlake.extract.JDBCSchema;
import ai.starlake.extract.JDBCSchema$;
import ai.starlake.extract.JDBCSchemas;
import ai.starlake.extract.JDBCSchemas$;
import ai.starlake.extract.JDBCTable;
import ai.starlake.extract.JdbcDbUtils$;
import ai.starlake.extract.ParUtils$;
import ai.starlake.extract.TableColumn;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AllSinks;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.AttributeMergeStrategy;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.ExpectationItem;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.KeepOnlyScriptDiff$;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.Metadata$;
import ai.starlake.schema.model.RefFirst$;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.TableDesc;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import ai.starlake.utils.YamlSerde$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001\u0002\u0007\u000e\u0001QA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006Y\u0001!\t!\f\u0005\ba\u0001\u0011\r\u0011b\u00012\u0011\u0019\u0011\u0004\u0001)A\u0005I!)1\u0007\u0001C\u0001i!)1\u0007\u0001C\u00015\")1\u0007\u0001C\u0001M\")!\u000e\u0001C\u0005W\")q\u000e\u0001C\u0001a\"9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004bBA;\u0001\u0011%\u0011q\u000f\u0002\u0012\u000bb$(/Y2u\u0015\u0012\u00135iU2iK6\f'B\u0001\b\u0010\u0003\u001d)\u0007\u0010\u001e:bGRT!\u0001E\t\u0002\u0011M$\u0018M\u001d7bW\u0016T\u0011AE\u0001\u0003C&\u001c\u0001aE\u0002\u0001+e\u0001\"AF\f\u000e\u00035I!\u0001G\u0007\u0003\u000f\u0015CHO]1diB\u0011!$I\u0007\u00027)\u0011A$H\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003=}\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002A\u0005\u00191m\\7\n\u0005\tZ\"a\u0003'bufdunZ4j]\u001e\fQb]2iK6\f\u0007*\u00198eY\u0016\u0014\bCA\u0013+\u001b\u00051#BA\u0014)\u0003!A\u0017M\u001c3mKJ\u001c(BA\u0015\u0010\u0003\u0019\u00198\r[3nC&\u00111F\n\u0002\u000e'\u000eDW-\\1IC:$G.\u001a:\u0002\rqJg.\u001b;?)\tqs\u0006\u0005\u0002\u0017\u0001!)1E\u0001a\u0001I\u0005)2o\u00195f[\u0006D\u0015M\u001c3mKJLU\u000e\u001d7jG&$X#\u0001\u0013\u0002-M\u001c\u0007.Z7b\u0011\u0006tG\r\\3s\u00136\u0004H.[2ji\u0002\n1A];o)\t)$\n\u0006\u00027\u0005B\u0019q\u0007\u0010 \u000e\u0003aR!!\u000f\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0002w\u0005)1oY1mC&\u0011Q\b\u000f\u0002\u0004)JL\bCA A\u001b\u0005Q\u0014BA!;\u0005\u0011)f.\u001b;\t\u000b\r+\u00019\u0001#\u0002\u0011M,G\u000f^5oON\u0004\"!\u0012%\u000e\u0003\u0019S!aR\b\u0002\r\r|gNZ5h\u0013\tIeI\u0001\u0005TKR$\u0018N\\4t\u0011\u0015YU\u00011\u0001M\u0003\u0011\t'oZ:\u0011\u0007}ju*\u0003\u0002Ou\t)\u0011I\u001d:bsB\u0011\u0001k\u0016\b\u0003#V\u0003\"A\u0015\u001e\u000e\u0003MS!\u0001V\n\u0002\rq\u0012xn\u001c;?\u0013\t1&(\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,;)\rYV,\u0019\u000b\u0003}qCQa\u0011\u0004A\u0004\u0011CQa\u0012\u0004A\u0002y\u0003\"AF0\n\u0005\u0001l!aE#yiJ\f7\r^*dQ\u0016l\u0017mQ8oM&<\u0007\"\u00022\u0007\u0001\u0004\u0019\u0017a\u00036eE\u000e\u001c6\r[3nCN\u0004\"A\u00063\n\u0005\u0015l!a\u0003&E\u0005\u000e\u001b6\r[3nCN$\"aZ5\u0015\u0005yB\u0007\"B\"\b\u0001\b!\u0005\"B$\b\u0001\u0004q\u0016A\u00034s_6\u001cuN\u001c4jOR\u0011AN\u001c\u000b\u0003G6DQa\u0011\u0005A\u0004\u0011CQa\u0012\u0005A\u0002y\u000bQ\"\u001a=ue\u0006\u001cGoU2iK6\fG#D9\u0002\u0002\u0005-\u0011\u0011FA#\u0003/\nY\u0006F\u0002?eNDQaQ\u0005A\u0004\u0011CQ\u0001^\u0005A\u0004U\f1A\u001a6q!\ryd\u000f_\u0005\u0003oj\u0012aa\u00149uS>t\u0007CA=\u007f\u001b\u0005Q(BA>}\u0003!\u0001\u0018M]1mY\u0016d'BA?;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fj\u00141CR8sW*{\u0017N\u001c+bg.\u001cV\u000f\u001d9peRDq!a\u0001\n\u0001\u0004\t)!\u0001\u0006kI\n\u001c7k\u00195f[\u0006\u00042AFA\u0004\u0013\r\tI!\u0004\u0002\u000b\u0015\u0012\u00135iU2iK6\f\u0007bBA\u0007\u0013\u0001\u0007\u0011qB\u0001\u0013G>tg.Z2uS>t7+\u001a;uS:<7\u000f\u0005\u0003\u0002\u0012\u0005\rb\u0002BA\n\u0003?qA!!\u0006\u0002\u001e9!\u0011qCA\u000e\u001d\r\u0011\u0016\u0011D\u0005\u0002%%\u0011\u0001#E\u0005\u0003\u000f>I1!!\tG\u0003!\u0019V\r\u001e;j]\u001e\u001c\u0018\u0002BA\u0013\u0003O\u0011!bQ8o]\u0016\u001cG/[8o\u0015\r\t\tC\u0012\u0005\b\u0003WI\u0001\u0019AA\u0017\u00035\u0011\u0017m]3PkR\u0004X\u000f\u001e#jeB!\u0011qFA!\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012A\u00014t\u0015\u0011\t9$!\u000f\u0002\r!\fGm\\8q\u0015\u0011\tY$!\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ty$A\u0002pe\u001eLA!a\u0011\u00022\t!\u0001+\u0019;i\u0011\u001d\t9%\u0003a\u0001\u0003\u0013\na\u0002Z8nC&tG+Z7qY\u0006$X\r\u0005\u0003@m\u0006-\u0003\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005E\u0003&A\u0003n_\u0012,G.\u0003\u0003\u0002V\u0005=#A\u0002#p[\u0006Lg\u000eC\u0004\u0002Z%\u0001\r!!\u0013\u0002\u001b\r,(O]3oi\u0012{W.Y5o\u0011\u001d\ti&\u0003a\u0001\u0003?\n\u0001\"\u001a=uKJt\u0017\r\u001c\t\u0004\u007f\u0005\u0005\u0014bAA2u\t9!i\\8mK\u0006t\u0017!D3yiJ\f7\r\u001e#p[\u0006Lg\u000e\u0006\u0005\u0002j\u0005=\u0014\u0011OA:)\u0019\tY%a\u001b\u0002n!)1I\u0003a\u0002\t\")AO\u0003a\u0002k\"9\u00111\u0001\u0006A\u0002\u0005\u0015\u0001bBA\u0007\u0015\u0001\u0007\u0011q\u0002\u0005\b\u0003\u000fR\u0001\u0019AA%\u0003Q1wN]7bi\u0016CHO]1diB\u000bG\u000f^3s]RA\u0011\u0011PA?\u0003\u007f\n\u0019\tF\u0002P\u0003wBQaQ\u0006A\u0004\u0011Cq!a\u0001\f\u0001\u0004\t)\u0001\u0003\u0004\u0002\u0002.\u0001\raT\u0001\u0006i\u0006\u0014G.\u001a\u0005\u0007\u0003\u000b[\u0001\u0019A(\u0002\u000fA\fG\u000f^3s]\u0002")
public class ExtractJDBCSchema
extends Extract
implements LazyLogging {
    private final SchemaHandler schemaHandler;
    private final SchemaHandler schemaHandlerImplicit;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ExtractJDBCSchema extractJDBCSchema = this;
        synchronized (extractJDBCSchema) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public SchemaHandler schemaHandlerImplicit() {
        return this.schemaHandlerImplicit;
    }

    public Try<BoxedUnit> run(String[] args, Settings settings) {
        return ExtractJDBCSchemaCmd$.MODULE$.run((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), this.schemaHandler, settings).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            ExtractJDBCSchema.$anonfun$run$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void run(ExtractSchemaConfig config, JDBCSchemas jdbcSchemas, Settings settings) {
        Path extractArea;
        Settings.Connection connection;
        Option<String> option = jdbcSchemas.connectionRef();
        if (option instanceof Some) {
            Some some = (Some)option;
            String connectionRef2 = (String)some.value();
            connection = settings.appConfig().getConnection(connectionRef2);
        } else if (None$.MODULE$.equals(option)) {
            connection = (Settings.Connection)config.connectionRef().map((Function1 & Serializable & scala.Serializable)connectionRef -> settings.appConfig().getConnection((String)connectionRef)).getOrElse((Function0 & Serializable & scala.Serializable)() -> settings.appConfig().getDefaultConnection());
        } else {
            throw new MatchError(option);
        }
        Settings.Connection connectionSettings = connection;
        Path path = extractArea = config.external() ? DatasetArea$.MODULE$.external(settings) : DatasetArea$.MODULE$.extract(settings);
        if (connectionSettings.isBigQuery()) {
            jdbcSchemas.jdbcSchemas().foreach((Function1 & Serializable & scala.Serializable)jdbcSchema -> {
                BigQueryTablesConfig bigQueryConfig = ExtractBigQuerySchemaCmd$.MODULE$.fromExtractSchemaConfig(config, (JDBCSchema)jdbcSchema);
                return ExtractBigQuerySchemaCmd$.MODULE$.run(bigQueryConfig, $this.schemaHandler, settings);
            });
            return;
        }
        Option<ForkJoinTaskSupport> forkJoinTaskSupport = ParUtils$.MODULE$.createForkSupport(config.parallelism(), ParUtils$.MODULE$.createForkSupport$default$2());
        ParUtils$.MODULE$.makeParallel(jdbcSchemas.jdbcSchemas(), forkJoinTaskSupport).foreach((Function1 & Serializable & scala.Serializable)jdbcSchema -> {
            ExtractJDBCSchema.$anonfun$run$5(this, config, settings, extractArea, connectionSettings, forkJoinTaskSupport, jdbcSchema);
            return BoxedUnit.UNIT;
        });
        forkJoinTaskSupport.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ExtractJDBCSchema.$anonfun$run$12(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void run(ExtractSchemaConfig config, Settings settings) {
        ExtractUtils$.MODULE$.timeIt("Schema extraction", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JDBCSchemas jdbcSchemas = this.fromConfig(config, settings);
            this.run(config, jdbcSchemas, settings);
        });
    }

    private JDBCSchemas fromConfig(ExtractSchemaConfig config, Settings settings) {
        Success success;
        boolean bl;
        if (config.tables().isEmpty() && config.extractConfig().isEmpty()) {
            throw new Exception("Either tables or extractConfig must be defined");
        }
        if (config.tables().nonEmpty()) {
            List jdbcSchemas;
            List jdbcTablesDesc = ((TraversableLike)config.tables().map((Function1 & Serializable & scala.Serializable)table -> {
                String[] parts = table.split("\\.");
                if (parts.length != 2) {
                    throw new Exception(new StringBuilder(22).append("Invalid table format: ").append((String)table).toString());
                }
                String schema = parts[0];
                String t = parts[1];
                return new Tuple2((Object)schema, (Object)t);
            }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._1()).toList();
            List x$28 = jdbcSchemas = (List)jdbcTablesDesc.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String schema = (String)tuple2._1();
                    Seq tables = (Seq)tuple2._2();
                    String x$11 = schema;
                    List x$12 = ((TraversableOnce)tables.map((Function1 & Serializable & scala.Serializable)t -> {
                        JDBCTable qual$1 = new JDBCTable();
                        String x$1 = (String)t._2();
                        Option<String> x$2 = qual$1.copy$default$2();
                        List<TableColumn> x$3 = qual$1.copy$default$3();
                        Option<String> x$4 = qual$1.copy$default$4();
                        Option<Object> x$5 = qual$1.copy$default$5();
                        Map<String, String> x$6 = qual$1.copy$default$6();
                        Option<Object> x$7 = qual$1.copy$default$7();
                        Option<Object> x$8 = qual$1.copy$default$8();
                        Option<String> x$9 = qual$1.copy$default$9();
                        Option<String> x$10 = qual$1.copy$default$10();
                        return qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
                    }, Seq$.MODULE$.canBuildFrom())).toList();
                    None$ x$13 = None$.MODULE$;
                    None$ x$14 = None$.MODULE$;
                    Option<String> x$15 = JDBCSchema$.MODULE$.apply$default$1();
                    Option<String> x$16 = JDBCSchema$.MODULE$.apply$default$3();
                    Option<String> x$17 = JDBCSchema$.MODULE$.apply$default$4();
                    List<String> x$18 = JDBCSchema$.MODULE$.apply$default$6();
                    List<String> x$19 = JDBCSchema$.MODULE$.apply$default$7();
                    Option<Trim> x$20 = JDBCSchema$.MODULE$.apply$default$10();
                    Option<String> x$21 = JDBCSchema$.MODULE$.apply$default$11();
                    Option<Object> x$22 = JDBCSchema$.MODULE$.apply$default$12();
                    Map<String, String> x$23 = JDBCSchema$.MODULE$.apply$default$13();
                    Option<Object> x$24 = JDBCSchema$.MODULE$.apply$default$14();
                    Option<String> x$25 = JDBCSchema$.MODULE$.apply$default$15();
                    Option<Object> x$26 = JDBCSchema$.MODULE$.apply$default$16();
                    Option<Object> x$27 = JDBCSchema$.MODULE$.apply$default$17();
                    JDBCSchema jdbcSchema = new JDBCSchema(x$15, x$11, x$16, x$17, (List<JDBCTable>)x$12, x$18, x$19, (Option<String>)x$14, (Option<String>)x$13, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27);
                    return jdbcSchema;
                }
                throw new MatchError((Object)tuple2);
            }, List$.MODULE$.canBuildFrom());
            Option<String> x$29 = config.connectionRef();
            Option<JDBCSchema> x$30 = JDBCSchemas$.MODULE$.apply$default$2();
            Option<FileFormat> x$31 = JDBCSchemas$.MODULE$.apply$default$3();
            Option<String> x$32 = JDBCSchemas$.MODULE$.apply$default$5();
            return new JDBCSchemas((List<JDBCSchema>)x$28, x$30, x$31, x$29, x$32);
        }
        Path extractArea = config.external() ? DatasetArea$.MODULE$.external(settings) : DatasetArea$.MODULE$.extract(settings);
        Path extractConfigPath = this.mappingPath(extractArea, config.extractConfig(), settings);
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> settings.storageHandler(settings.storageHandler$default$1()).exists(extractConfigPath));
        if (try_ instanceof Failure ? true : try_ instanceof Success && false == (bl = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
            throw new FileNotFoundException(new StringBuilder(60).append("Could not found extract config ").append(config.extractConfig()).append(". Please check its existence.").toString());
        }
        StorageHandler qual$2 = settings.storageHandler(settings.storageHandler$default$1());
        Path x$33 = extractConfigPath;
        Charset x$34 = qual$2.read$default$2();
        String content = Formatter$.MODULE$.RichFormatter(qual$2.read(x$33, x$34)).richFormat(this.schemaHandler.activeEnvVars(this.schemaHandler.activeEnvVars$default$1(), this.schemaHandler.activeEnvVars$default$2(), this.schemaHandler.activeEnvVars$default$3()), (Map<String, Object>)Predef$.MODULE$.Map().empty(), settings);
        JDBCSchemas jdbcSchemas = YamlSerde$.MODULE$.deserializeYamlExtractConfig(content, config.extractConfig(), YamlSerde$.MODULE$.deserializeYamlExtractConfig$default$3());
        return jdbcSchemas;
    }

    public void extractSchema(JDBCSchema jdbcSchema, Settings.Connection connectionSettings, Path baseOutputDir, Option<Domain> domainTemplate, Option<Domain> currentDomain, boolean external, Settings settings, Option<ForkJoinTaskSupport> fjp) {
        List tables;
        Some some;
        boolean bl;
        StorageHandler storageHandler = settings.storageHandler(settings.storageHandler$default$1());
        Option<Object> option = jdbcSchema.sanitizeName();
        String domainName = option instanceof Some && true == (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? Utils$.MODULE$.keepAlphaNum(jdbcSchema.schema()) : jdbcSchema.schema();
        storageHandler.mkdirs(new Path(baseOutputDir, domainName));
        Domain extractedDomain = this.extractDomain(jdbcSchema, connectionSettings, domainTemplate, settings, fjp);
        Option x$22 = extractedDomain.comment().orElse((Function0 & Serializable & scala.Serializable)() -> currentDomain.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.comment()));
        Set x$23 = extractedDomain.tags().nonEmpty() ? extractedDomain.tags() : (Set)currentDomain.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.tags()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        Option x$24 = extractedDomain.rename().orElse((Function0 & Serializable & scala.Serializable)() -> currentDomain.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.rename()));
        Option x$25 = extractedDomain.database().orElse((Function0 & Serializable & scala.Serializable)() -> currentDomain.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.database()));
        Metadata qual$1 = Metadata$.MODULE$.mergeAll((List<Metadata>)((List)((List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(currentDomain.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.metadata())), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(extractedDomain.metadata()), List$.MODULE$.canBuildFrom())));
        boolean x$1 = false;
        Option<Format> x$2 = qual$1.copy$default$1();
        Option<String> x$3 = qual$1.copy$default$2();
        Option<Object> x$4 = qual$1.copy$default$3();
        Option<Object> x$5 = qual$1.copy$default$4();
        Option<Object> x$62 = qual$1.copy$default$5();
        Option<String> x$7 = qual$1.copy$default$6();
        Option<String> x$8 = qual$1.copy$default$7();
        Option<String> x$92 = qual$1.copy$default$8();
        Option<AllSinks> x$10 = qual$1.copy$default$9();
        Option<String> x$11 = qual$1.copy$default$10();
        Option<String> x$12 = qual$1.copy$default$11();
        Option<String> x$13 = qual$1.copy$default$12();
        Option<Map<String, String>> x$14 = qual$1.copy$default$13();
        Option<String> x$15 = qual$1.copy$default$14();
        Option<Object> x$16 = qual$1.copy$default$15();
        Option<String> x$17 = qual$1.copy$default$16();
        Option<Freshness> x$18 = qual$1.copy$default$17();
        Option<String> x$19 = qual$1.copy$default$18();
        Option<String> x$20 = qual$1.copy$default$20();
        Option<WriteStrategy> x$21 = qual$1.copy$default$21();
        Option<Metadata> x$26 = qual$1.copy(x$2, x$3, x$4, x$5, x$62, x$7, x$8, x$92, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$1, x$20, x$21).asOption();
        String x$27 = extractedDomain.copy$default$1();
        List<Schema> x$28 = extractedDomain.copy$default$3();
        Domain domain = extractedDomain.copy(x$27, x$26, x$28, (Option<String>)x$22, (Set<String>)x$23, (Option<String>)x$24, (Option<String>)x$25);
        List x$119 = tables = (List)domain.tables().map((Function1 & Serializable & scala.Serializable)table -> {
            Schema schema;
            Schema schema2;
            Option option = currentDomain.flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.tables().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ExtractJDBCSchema.$anonfun$extractSchema$12(table, x$11))));
            if (option instanceof Some) {
                Some some = (Some)option;
                Schema currentTable = (Schema)some.value();
                Schema mergedTable = table.mergeWith(currentTable, domain.metadata(), new AttributeMergeStrategy(false, false, KeepOnlyScriptDiff$.MODULE$, RefFirst$.MODULE$), this.schemaHandlerImplicit());
                Option x$50 = mergedTable.metadata().map((Function1 & Serializable & scala.Serializable)x$12 -> {
                    boolean x$29 = false;
                    Option<Format> x$30 = x$12.copy$default$1();
                    Option<String> x$31 = x$12.copy$default$2();
                    Option<Object> x$32 = x$12.copy$default$3();
                    Option<Object> x$33 = x$12.copy$default$4();
                    Option<Object> x$34 = x$12.copy$default$5();
                    Option<String> x$35 = x$12.copy$default$6();
                    Option<String> x$36 = x$12.copy$default$7();
                    Option<String> x$37 = x$12.copy$default$8();
                    Option<AllSinks> x$38 = x$12.copy$default$9();
                    Option<String> x$39 = x$12.copy$default$10();
                    Option<String> x$40 = x$12.copy$default$11();
                    Option<String> x$41 = x$12.copy$default$12();
                    Option<Map<String, String>> x$42 = x$12.copy$default$13();
                    Option<String> x$43 = x$12.copy$default$14();
                    Option<Object> x$44 = x$12.copy$default$15();
                    Option<String> x$45 = x$12.copy$default$16();
                    Option<Freshness> x$46 = x$12.copy$default$17();
                    Option<String> x$47 = x$12.copy$default$18();
                    Option<String> x$48 = x$12.copy$default$20();
                    Option<WriteStrategy> x$49 = x$12.copy$default$21();
                    return x$12.copy(x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$29, x$48, x$49);
                });
                String x$51 = mergedTable.copy$default$1();
                Pattern x$52 = mergedTable.copy$default$2();
                List<Attribute> x$53 = mergedTable.copy$default$3();
                Option<String> x$54 = mergedTable.copy$default$5();
                List<String> x$55 = mergedTable.copy$default$6();
                List<String> x$56 = mergedTable.copy$default$7();
                Set<String> x$57 = mergedTable.copy$default$8();
                List<RowLevelSecurity> x$58 = mergedTable.copy$default$9();
                List<ExpectationItem> x$59 = mergedTable.copy$default$10();
                List<String> x$60 = mergedTable.copy$default$11();
                List<AccessControlEntry> x$61 = mergedTable.copy$default$12();
                Option<String> x$62 = mergedTable.copy$default$13();
                Option<String> x$63 = mergedTable.copy$default$14();
                Option<String> x$64 = mergedTable.copy$default$15();
                Option<String> x$65 = mergedTable.copy$default$16();
                schema2 = mergedTable.copy(x$51, x$52, x$53, (Option<Metadata>)x$50, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65);
            } else if (None$.MODULE$.equals(option)) {
                Metadata qual$2 = Metadata$.MODULE$.mergeAll((List<Metadata>)((List)((List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(domain.metadata()), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(table.metadata()), List$.MODULE$.canBuildFrom()))).keepIfDifferent((Metadata)domain.metadata().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Metadata(Metadata$.MODULE$.apply$default$1(), Metadata$.MODULE$.apply$default$2(), Metadata$.MODULE$.apply$default$3(), Metadata$.MODULE$.apply$default$4(), Metadata$.MODULE$.apply$default$5(), Metadata$.MODULE$.apply$default$6(), Metadata$.MODULE$.apply$default$7(), Metadata$.MODULE$.apply$default$8(), Metadata$.MODULE$.apply$default$9(), Metadata$.MODULE$.apply$default$10(), Metadata$.MODULE$.apply$default$11(), Metadata$.MODULE$.apply$default$12(), Metadata$.MODULE$.apply$default$13(), Metadata$.MODULE$.apply$default$14(), Metadata$.MODULE$.apply$default$15(), Metadata$.MODULE$.apply$default$16(), Metadata$.MODULE$.apply$default$17(), Metadata$.MODULE$.apply$default$18(), Metadata$.MODULE$.apply$default$19(), Metadata$.MODULE$.apply$default$20(), Metadata$.MODULE$.apply$default$21())));
                boolean x$66 = false;
                Option<Format> x$67 = qual$2.copy$default$1();
                Option<String> x$68 = qual$2.copy$default$2();
                Option<Object> x$69 = qual$2.copy$default$3();
                Option<Object> x$70 = qual$2.copy$default$4();
                Option<Object> x$71 = qual$2.copy$default$5();
                Option<String> x$72 = qual$2.copy$default$6();
                Option<String> x$73 = qual$2.copy$default$7();
                Option<String> x$74 = qual$2.copy$default$8();
                Option<AllSinks> x$75 = qual$2.copy$default$9();
                Option<String> x$76 = qual$2.copy$default$10();
                Option<String> x$77 = qual$2.copy$default$11();
                Option<String> x$78 = qual$2.copy$default$12();
                Option<Map<String, String>> x$79 = qual$2.copy$default$13();
                Option<String> x$80 = qual$2.copy$default$14();
                Option<Object> x$81 = qual$2.copy$default$15();
                Option<String> x$82 = qual$2.copy$default$16();
                Option<Freshness> x$83 = qual$2.copy$default$17();
                Option<String> x$84 = qual$2.copy$default$18();
                Option<String> x$85 = qual$2.copy$default$20();
                Option<WriteStrategy> x$86 = qual$2.copy$default$21();
                Option<Metadata> x$87 = qual$2.copy(x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$66, x$85, x$86).asOption();
                String x$88 = table.copy$default$1();
                Pattern x$89 = table.copy$default$2();
                List<Attribute> x$90 = table.copy$default$3();
                Option<String> x$91 = table.copy$default$5();
                List<String> x$92 = table.copy$default$6();
                List<String> x$93 = table.copy$default$7();
                Set<String> x$94 = table.copy$default$8();
                List<RowLevelSecurity> x$95 = table.copy$default$9();
                List<ExpectationItem> x$96 = table.copy$default$10();
                List<String> x$97 = table.copy$default$11();
                List<AccessControlEntry> x$98 = table.copy$default$12();
                Option<String> x$99 = table.copy$default$13();
                Option<String> x$100 = table.copy$default$14();
                Option<String> x$101 = table.copy$default$15();
                Option<String> x$102 = table.copy$default$16();
                schema2 = table.copy(x$88, x$89, x$90, x$87, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102);
            } else {
                throw new MatchError((Object)option);
            }
            Schema restoredTable = schema2;
            Option<String> option2 = jdbcSchema.pattern();
            if (None$.MODULE$.equals(option2)) {
                schema = restoredTable;
            } else if (option2 instanceof Some) {
                Pattern pat;
                Some some = (Some)option2;
                String pattern = (String)some.value();
                String interpolatePattern = this.formatExtractPattern(jdbcSchema, table.name(), pattern, settings);
                Pattern x$103 = pat = Pattern.compile(interpolatePattern);
                String x$104 = restoredTable.copy$default$1();
                List<Attribute> x$105 = restoredTable.copy$default$3();
                Option<Metadata> x$106 = restoredTable.copy$default$4();
                Option<String> x$107 = restoredTable.copy$default$5();
                List<String> x$108 = restoredTable.copy$default$6();
                List<String> x$109 = restoredTable.copy$default$7();
                Set<String> x$110 = restoredTable.copy$default$8();
                List<RowLevelSecurity> x$111 = restoredTable.copy$default$9();
                List<ExpectationItem> x$112 = restoredTable.copy$default$10();
                List<String> x$113 = restoredTable.copy$default$11();
                List<AccessControlEntry> x$114 = restoredTable.copy$default$12();
                Option<String> x$115 = restoredTable.copy$default$13();
                Option<String> x$116 = restoredTable.copy$default$14();
                Option<String> x$117 = restoredTable.copy$default$15();
                Option<String> x$118 = restoredTable.copy$default$16();
                schema = restoredTable.copy(x$104, x$103, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118);
            } else {
                throw new MatchError(option2);
            }
            Schema tableWithPatternAndWrite = schema;
            return tableWithPatternAndWrite;
        }, List$.MODULE$.canBuildFrom());
        String x$120 = domain.copy$default$1();
        Option<Metadata> x$121 = domain.copy$default$2();
        Option<String> x$122 = domain.copy$default$4();
        Set<String> x$123 = domain.copy$default$5();
        Option<String> x$124 = domain.copy$default$6();
        Option<String> x$125 = domain.copy$default$7();
        Domain finalDomain = domain.copy(x$120, x$121, (List<Schema>)x$119, x$122, x$123, x$124, x$125);
        if (external) {
            this.schemaHandler.saveToExternals((List<Domain>)new .colon.colon((Object)finalDomain, (List)Nil$.MODULE$));
            return;
        }
        this.schemaHandler.saveTo((List<Domain>)new .colon.colon((Object)finalDomain, (List)Nil$.MODULE$), baseOutputDir);
    }

    private Domain extractDomain(JDBCSchema jdbcSchema, Settings.Connection connectionSettings, Option<Domain> domainTemplate, Settings settings, Option<ForkJoinTaskSupport> fjp) {
        Map<String, ExtractTableAttributes> selectedTablesAndColumns = JdbcDbUtils$.MODULE$.extractJDBCTables(jdbcSchema, connectionSettings, false, false, settings, fjp);
        return JdbcDbUtils$.MODULE$.extractDomain(jdbcSchema, domainTemplate, selectedTablesAndColumns);
    }

    private String formatExtractPattern(JDBCSchema jdbcSchema, String table, String pattern, Settings settings) {
        return Formatter$.MODULE$.RichFormatter(pattern).richFormat((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalog"), jdbcSchema.catalog().map((Function1 & Serializable & scala.Serializable)text -> Regex$.MODULE$.quote(text)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)Regex$.MODULE$.quote(jdbcSchema.schema())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)Regex$.MODULE$.quote(table))}))), (Map<String, Object>)Predef$.MODULE$.Map().empty(), settings);
    }

    public static final /* synthetic */ void $anonfun$run$1(JobResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$run$5(ExtractJDBCSchema $this, ExtractSchemaConfig config$1, Settings settings$1, Path extractArea$1, Settings.Connection connectionSettings$1, Option forkJoinTaskSupport$1, JDBCSchema jdbcSchema) {
        Option domainTemplate = jdbcSchema.template().orElse((Function0 & Serializable & scala.Serializable)() -> {
            String defaultDomainFile = new StringBuilder(8).append("_domain_").append(config$1.extractConfig()).toString();
            if (settings$1.storageHandler(settings$1.storageHandler$default$1()).exists($this.mappingPath(extractArea$1, defaultDomainFile, settings$1))) {
                return new Some((Object)defaultDomainFile);
            }
            return None$.MODULE$;
        }).map((Function1 & Serializable & scala.Serializable)ymlTemplate -> {
            BoxedUnit boxedUnit;
            Path domainTemplatePath = $this.mappingPath(extractArea$1, (String)ymlTemplate, settings$1);
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Loading domain template from {}", new Object[]{domainTemplatePath});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            StorageHandler qual$1 = settings$1.storageHandler(settings$1.storageHandler$default$1());
            Path x$1 = domainTemplatePath;
            Charset x$22 = qual$1.read$default$2();
            String content = qual$1.read(x$1, x$22);
            Try<Domain> try_ = YamlSerde$.MODULE$.deserializeYamlLoadConfig(content, (String)ymlTemplate, true);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Domain domain = (Domain)success.value();
                Path tableTemplatePath = $this.mappingPath(extractArea$1, (String)jdbcSchema.template().map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(7).append("_table_").append((String)t).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("_table_").append(config$1.extractConfig()).toString()), settings$1);
                if (settings$1.storageHandler(settings$1.storageHandler$default$1()).exists(tableTemplatePath)) {
                    BoxedUnit boxedUnit2;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info("Loading table template from {}", new Object[]{tableTemplatePath});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    StorageHandler qual$2 = settings$1.storageHandler(settings$1.storageHandler$default$1());
                    Path x$3 = tableTemplatePath;
                    Charset x$4 = qual$2.read$default$2();
                    String tableContent = qual$2.read(x$3, x$4);
                    List<TableDesc> tableDesc = YamlSerde$.MODULE$.deserializeYamlTables(tableContent, tableTemplatePath.toString());
                    List x$5 = (List)tableDesc.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.table(), List$.MODULE$.canBuildFrom());
                    String x$6 = domain.copy$default$1();
                    Option<Metadata> x$7 = domain.copy$default$2();
                    Option<String> x$8 = domain.copy$default$4();
                    Set<String> x$9 = domain.copy$default$5();
                    Option<String> x$10 = domain.copy$default$6();
                    Option<String> x$11 = domain.copy$default$7();
                    return domain.copy(x$6, x$7, (List<Schema>)x$5, x$8, x$9, x$10, x$11);
                }
                return domain;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        });
        Option<Domain> currentDomain = $this.schemaHandler.getDomain(jdbcSchema.schema(), true);
        ExtractUtils$.MODULE$.timeIt(new StringBuilder(21).append("Schema extraction of ").append(jdbcSchema.schema()).toString(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.extractSchema(jdbcSchema, connectionSettings$1, $this.schemaOutputDir(config$1.outputDir(), settings$1), (Option<Domain>)domainTemplate, currentDomain, config$1.external(), settings$1, (Option<ForkJoinTaskSupport>)forkJoinTaskSupport$1));
    }

    public static final /* synthetic */ void $anonfun$run$12(ForkJoinTaskSupport x$3) {
        x$3.forkJoinPool().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$extractSchema$12(Schema table$1, Schema x$11) {
        String string = x$11.name();
        String string2 = table$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ExtractJDBCSchema(SchemaHandler schemaHandler) {
        this.schemaHandler = schemaHandler;
        LazyLogging.$init$((LazyLogging)this);
        this.schemaHandlerImplicit = schemaHandler;
    }
}

