/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.extract.ExtractScriptConfig;
import ai.starlake.extract.ExtractScriptConfig$;
import ai.starlake.extract.ExtractScriptSettings$;
import ai.starlake.extract.TemplateParams;
import ai.starlake.extract.TemplateParams$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.Domain;
import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.hadoop.fs.Path;
import org.fusesource.scalate.TemplateEngine;
import org.fusesource.scalate.TemplateEngine$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001\u0002\b\u0010\u0001YA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0006c!)q\u0007\u0001C\u0001q!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0003L\u0001\u0011%A\nC\u0003`\u0001\u0011%\u0001\rC\u0003v\u0001\u0011\u0005a\u000fC\u0003{\u0001\u0011\u00051\u0010\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003'Bq!a\u001a\u0001\t\u0013\tIGA\u0007FqR\u0014\u0018m\u0019;TGJL\u0007\u000f\u001e\u0006\u0003!E\tq!\u001a=ue\u0006\u001cGO\u0003\u0002\u0013'\u0005A1\u000f^1sY\u0006\\WMC\u0001\u0015\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=\u0015j\u0011a\b\u0006\u0003A\u0005\nAb]2bY\u0006dwnZ4j]\u001eT!AI\u0012\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001J\u0001\u0004G>l\u0017B\u0001\u0014 \u00055\u0019FO]5di2{wmZ5oO\u0006i1o\u00195f[\u0006D\u0015M\u001c3mKJ\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u0011!\fg\u000e\u001a7feNT!!L\t\u0002\rM\u001c\u0007.Z7b\u0013\ty#FA\u0007TG\",W.\u0019%b]\u0012dWM]\u0001\tg\u0016$H/\u001b8hgB\u0011!'N\u0007\u0002g)\u0011A'E\u0001\u0007G>tg-[4\n\u0005Y\u001a$\u0001C*fiRLgnZ:\u0002\rqJg.\u001b;?)\tIT\b\u0006\u0002;yA\u00111\bA\u0007\u0002\u001f!)\u0001g\u0001a\u0002c!)qe\u0001a\u0001Q\u00051QM\\4j]\u0016,\u0012\u0001\u0011\t\u0003\u0003\"k\u0011A\u0011\u0006\u0003\u0007\u0012\u000bqa]2bY\u0006$XM\u0003\u0002F\r\u0006Qa-^:fg>,(oY3\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tI%I\u0001\bUK6\u0004H.\u0019;f\u000b:<\u0017N\\3\u0002\u000f\u0015tw-\u001b8fA\u00051bm\u001c:nCR|U\u000f\u001e9viN\u001b'/\u001b9u\u001d\u0006lW\rF\u0002N1j\u0003\"AT+\u000f\u0005=\u001b\u0006C\u0001)\u001a\u001b\u0005\t&B\u0001*\u0016\u0003\u0019a$o\\8u}%\u0011A+G\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U3!)\u0011L\u0002a\u0001\u001b\u0006!a.Y7f\u0011\u0015Yf\u00011\u0001]\u00039!X-\u001c9mCR,\u0007+\u0019:b[N\u0004\"aO/\n\u0005y{!A\u0004+f[Bd\u0017\r^3QCJ\fWn]\u0001\u000bi\u0016l\u0007\u000f\\1uSj,GcA1siB\u0019!m\u001a6\u000f\u0005\r,gB\u0001)e\u0013\u0005Q\u0012B\u00014\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001[5\u0003\t1K7\u000f\u001e\u0006\u0003Mf\u0001\"a\u001b9\u000e\u00031T!!\u001c8\u0002\u000b\u0019LG.Z:\u000b\u0003=\faAY3ui\u0016\u0014\u0018BA9m\u0005\u00111\u0015\u000e\\3\t\u000bM<\u0001\u0019A'\u0002\u0019Q,W\u000e\u001d7bi\u0016t\u0015-\\3\t\u000bm;\u0001\u0019\u0001/\u0002!Q,W\u000e\u001d7bi&TXMR8mI\u0016\u0014HcA1xs\")\u0001\u0010\u0003a\u0001U\u0006qA/Z7qY\u0006$XMR8mI\u0016\u0014\b\"B.\t\u0001\u0004a\u0016A\u0004;f[Bd\u0017\r^5{K\u001aKG.\u001a\u000b\u0004Urt\b\"B?\n\u0001\u0004i\u0015!C5oaV$\b+\u0019;i\u0011\u0015Y\u0016\u00021\u0001]\u000399WM\\3sCR,Gi\\7bS:$R\"YA\u0002\u0003'\t9\"!\t\u0002,\u0005=\u0002bBA\u0003\u0015\u0001\u0007\u0011qA\u0001\u0007I>l\u0017-\u001b8\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004-\u0003\u0015iw\u000eZ3m\u0013\u0011\t\t\"a\u0003\u0003\r\u0011{W.Y5o\u0011\u0019\t)B\u0003a\u0001\u001b\u0006\u00112o\u0019:jaR$V-\u001c9mCR,g*Y7f\u0011\u001d\tIB\u0003a\u0001\u00037\t!\u0003Z3gCVdG\u000fR3mi\u0006\u001cu\u000e\\;n]B!\u0001$!\bN\u0013\r\ty\"\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\r\"\u00021\u0001\u0002&\u0005aA-\u001a7uC\u000e{G.^7ogB)a*a\nN\u001b&\u0019\u0011\u0011F,\u0003\u00075\u000b\u0007\u000fC\u0004\u0002.)\u0001\r!a\u0007\u0002\u000f\u0005,H-\u001b;E\u0005\"9\u0011\u0011\u0007\u0006A\u0002\u0005\u0015\u0012!C1di&4X-\u00128w\u0003\r\u0011XO\u001c\u000b\u0005\u0003o\tI\u0005\u0005\u0004\u0002:\u0005}\u00121I\u0007\u0003\u0003wQ1!!\u0010\u001a\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00131\b\u0002\u0004)JL\bc\u0001\r\u0002F%\u0019\u0011qI\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0017Z\u0001\u0019AA'\u0003\u0011\t'oZ:\u0011\ta\ty%T\u0005\u0004\u0003#J\"!B!se\u0006LH\u0003BA+\u0003?\"B!a\u0016\u0002^A\u0019\u0001$!\u0017\n\u0007\u0005m\u0013DA\u0004C_>dW-\u00198\t\u000bAb\u00019A\u0019\t\rQb\u0001\u0019AA1!\rY\u00141M\u0005\u0004\u0003Kz!aE#yiJ\f7\r^*de&\u0004HoQ8oM&<\u0017\u0001\u0004:v]>sGi\\7bS:\u001cH\u0003CA,\u0003W\ni'a\u001c\t\rQj\u0001\u0019AA1\u0011\u00159S\u00021\u0001)\u0011\u001d\t\t(\u0004a\u0001\u0003g\n1\u0002Z8nC&tg*Y7fgB!!-!\u001eN\u0013\r\t9(\u001b\u0002\u0004'\u0016\f\b")
public class ExtractScript
implements StrictLogging {
    private final SchemaHandler schemaHandler;
    private final Settings settings;
    private final TemplateEngine engine;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public TemplateEngine engine() {
        return this.engine;
    }

    private String formatOutputScriptName(String name, TemplateParams templateParams) {
        Map vars = this.schemaHandler.slDateVars().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"domain"), (Object)templateParams.domainToExport()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)templateParams.tableToExport())})));
        return (String)vars.foldLeft((Object)name.substring(0, name.lastIndexOf(".")), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String a = (String)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String cometVar = (String)tuple22._1();
                    String cometVal = (String)tuple22._2();
                    return a.replace(cometVar, cometVal);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private List<File> templatize(String templateName, TemplateParams templateParams) {
        File templateFolder = File$.MODULE$.apply(new Path(DatasetArea$.MODULE$.extract(this.settings), templateName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        return this.templatizeFolder(templateFolder, templateParams);
    }

    public List<File> templatizeFolder(File templateFolder, TemplateParams templateParams) {
        if (!templateFolder.isDirectory(templateFolder.isDirectory$default$1())) {
            throw new Exception(new StringBuilder(24).append("Invalid template folder ").append(templateFolder.pathAsString()).toString());
        }
        Iterator filesPath = templateFolder.list().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.pathAsString()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ExtractScript.$anonfun$templatizeFolder$2(name)));
        return filesPath.map((Function1 & Serializable & scala.Serializable)inputPath -> this.templatizeFile((String)inputPath, templateParams)).toList();
    }

    public File templatizeFile(String inputPath, TemplateParams templateParams) {
        BoxedUnit boxedUnit;
        boolean x$1;
        String scriptPayload = this.engine().layout(inputPath, templateParams.paramMap(), this.engine().layout$default$3());
        String outputPath = this.formatOutputScriptName(inputPath, templateParams);
        File outputFile = File$.MODULE$.apply(outputPath, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        File generatedOutputFile = File$.MODULE$.apply(outputFile.parent(), "generated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{outputFile.name()}));
        File qual$1 = generatedOutputFile.parent();
        boolean x$2 = x$1 = qual$1.createDirectoryIfNotExists$default$1();
        Seq x$3 = qual$1.createDirectoryIfNotExists$default$2(x$2);
        Seq x$4 = qual$1.createDirectoryIfNotExists$default$3(x$2);
        qual$1.createDirectoryIfNotExists(x$2, x$3, x$4);
        boolean x$5 = generatedOutputFile.createFileIfNotExists$default$1();
        Seq x$6 = generatedOutputFile.createFileIfNotExists$default$2(x$5);
        Seq x$7 = generatedOutputFile.createFileIfNotExists$default$3(x$5);
        File qual$2 = generatedOutputFile.createFileIfNotExists(x$5, x$6, x$7);
        String x$8 = scriptPayload;
        Seq x$9 = qual$2.overwrite$default$2(x$8);
        Charset x$10 = qual$2.overwrite$default$3(x$8);
        qual$2.overwrite(x$8, x$9, x$10);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Successfully generated script {}", new Object[]{generatedOutputFile});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return generatedOutputFile;
    }

    private List<File> generateDomain(Domain domain, String scriptTemplateName, Option<String> defaultDeltaColumn, Map<String, String> deltaColumns, Option<String> auditDB, Map<String, String> activeEnv) {
        List<TemplateParams> templateSettings = TemplateParams$.MODULE$.fromDomain(domain, defaultDeltaColumn, deltaColumns, auditDB, activeEnv, this.settings);
        return (List)templateSettings.flatMap((Function1 & Serializable & scala.Serializable)ts -> this.templatize(scriptTemplateName, (TemplateParams)ts), List$.MODULE$.canBuildFrom());
    }

    public Try<BoxedUnit> run(String[] args) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option<ExtractScriptConfig> option = ExtractScriptConfig$.MODULE$.parse((Seq<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toIndexedSeq());
            if (option instanceof Some) {
                Some some = (Some)option;
                ExtractScriptConfig config = (ExtractScriptConfig)some.value();
                this.run(config, $this.settings);
                return;
            }
            throw new IllegalArgumentException(ExtractScriptConfig$.MODULE$.usage());
        });
    }

    public boolean run(ExtractScriptConfig config, Settings settings) {
        DatasetArea$.MODULE$.initMetadata(settings.storageHandler(settings.storageHandler$default$1()), settings);
        Seq<String> seq = config.domain();
        if (Nil$.MODULE$.equals(seq)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No domain or jobs provided. Extracting all domains");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            List domainNames = (List)this.schemaHandler.domains(this.schemaHandler.domains$default$1(), this.schemaHandler.domains$default$2(), this.schemaHandler.domains$default$3(), this.schemaHandler.domains$default$4()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), List$.MODULE$.canBuildFrom());
            return this.runOnDomains(config, this.schemaHandler, (Seq<String>)domainNames);
        }
        return this.runOnDomains(config, this.schemaHandler, seq);
    }

    private boolean runOnDomains(ExtractScriptConfig config, SchemaHandler schemaHandler, Seq<String> domainNames) {
        List<Domain> domains = schemaHandler.domains(schemaHandler.domains$default$1(), schemaHandler.domains$default$2(), schemaHandler.domains$default$3(), schemaHandler.domains$default$4());
        return ((IterableLike)domainNames.map((Function1 & Serializable & scala.Serializable)domainName -> BoxesRunTime.boxToBoolean((boolean)ExtractScript.$anonfun$runOnDomains$1(this, domains, config, schemaHandler, domainName)), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ExtractScript.$anonfun$runOnDomains$4(BoxesRunTime.unboxToBoolean((Object)x$4))));
    }

    public static final /* synthetic */ boolean $anonfun$templatizeFolder$2(String name) {
        return name.endsWith(".ssp") || name.endsWith(".mustache");
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$2(String domainName$1, Domain x$3) {
        String string = x$3.name();
        String string2 = domainName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$1(ExtractScript $this, List domains$1, ExtractScriptConfig config$1, SchemaHandler schemaHandler$1, String domainName) {
        Option option = domains$1.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExtractScript.$anonfun$runOnDomains$2(domainName, x$3)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Domain domain = (Domain)some.value();
            $this.generateDomain(domain, config$1.scriptTemplateName(), (Option<String>)config$1.deltaColumn().orElse((Function0 & Serializable & scala.Serializable)() -> ExtractScriptSettings$.MODULE$.deltaColumns().defaultColumn()), ExtractScriptSettings$.MODULE$.deltaColumns().deltaColumns(), (Option<String>)new Some((Object)config$1.auditDB()), schemaHandler$1.activeEnvVars(schemaHandler$1.activeEnvVars$default$1(), schemaHandler$1.activeEnvVars$default$2(), schemaHandler$1.activeEnvVars$default$3()));
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("No domain found for domain name {}", new Object[]{config$1.domain()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$4(boolean x$4) {
        return x$4;
    }

    public ExtractScript(SchemaHandler schemaHandler, Settings settings) {
        this.schemaHandler = schemaHandler;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.engine = new TemplateEngine(TemplateEngine$.MODULE$.$lessinit$greater$default$1(), TemplateEngine$.MODULE$.$lessinit$greater$default$2());
    }
}

