/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ExtractUtils$
implements StrictLogging {
    public static ExtractUtils$ MODULE$;
    private final Logger logger;

    static {
        new ExtractUtils$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public <T> T timeIt(String blockLabel, Function0<T> code) {
        BoxedUnit boxedUnit;
        long startTime = System.currentTimeMillis();
        Object result = code.apply();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(6).append(blockLabel).append(" took ").append(this.toHumanElapsedTimeFrom(startTime)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (T)result;
    }

    public String toHumanElapsedTimeFrom(long startTimeMs) {
        long elapsedTimeMs = System.currentTimeMillis() - startTimeMs;
        return this.toHumanElapsedTime(elapsedTimeMs);
    }

    public String toHumanElapsedTime(long elapsedTimeMs) {
        if (elapsedTimeMs == 0L) {
            return "0 ms";
        }
        Tuple2 tuple2 = (Tuple2)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)86400000)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)BoxesRunTime.boxToInteger((int)3600000)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"m"), (Object)BoxesRunTime.boxToInteger((int)60000)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"s"), (Object)BoxesRunTime.boxToInteger((int)1000)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ms"), (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))).foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)BoxesRunTime.boxToLong((long)elapsedTimeMs)), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String output = (String)tuple22._1();
                    long timeMs = tuple22._2$mcJ$sp();
                    if (tuple23 != null) {
                        Tuple2 tuple24;
                        Tuple2 tuple25;
                        String unitSuffix = (String)tuple23._1();
                        int unitInMs = tuple23._2$mcI$sp();
                        if (elapsedTimeMs < (long)unitInMs) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)output), (Object)BoxesRunTime.boxToLong((long)timeMs));
                        }
                        if (unitInMs > 0) {
                            long timeAsUnit = timeMs / (long)unitInMs;
                            long restOfTimeMs = timeMs % (long)unitInMs;
                            tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)timeAsUnit)), (Object)BoxesRunTime.boxToLong((long)restOfTimeMs));
                        } else {
                            tuple25 = tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)timeMs)), (Object)BoxesRunTime.boxToLong((long)0L));
                        }
                        if (tuple24 == null) {
                            throw new MatchError((Object)tuple24);
                        }
                        long elapsedTimeInUnit = tuple24._1$mcJ$sp();
                        long restOfTimeMs = tuple24._2$mcJ$sp();
                        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(elapsedTimeInUnit, restOfTimeMs);
                        long elapsedTimeInUnit2 = sp2._1$mcJ$sp();
                        long restOfTimeMs2 = sp2._2$mcJ$sp();
                        if (elapsedTimeInUnit2 > 0L) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(output).append(" ").append(elapsedTimeInUnit2).append(unitSuffix).toString()), (Object)BoxesRunTime.boxToLong((long)restOfTimeMs2));
                        }
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)output), (Object)BoxesRunTime.boxToLong((long)restOfTimeMs2));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String output = (String)tuple2._1();
        String output2 = output;
        return (String)new StringOps(Predef$.MODULE$.augmentString(output2)).tail();
    }

    private ExtractUtils$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

