/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.extract.ExtractTableAttributes;
import ai.starlake.extract.ExtractUtils$;
import ai.starlake.extract.JDBCSchema;
import ai.starlake.extract.JDBCSchema$;
import ai.starlake.extract.JDBCTable;
import ai.starlake.extract.JdbcColumnDatabaseMetadata;
import ai.starlake.extract.JdbcColumnMetadata;
import ai.starlake.extract.JdbcDbUtils$StarlakeConnectionPool$;
import ai.starlake.extract.ParUtils$;
import ai.starlake.extract.ResultSetColumnMetadata;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AllSinks;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.ConnectionType;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Domain$;
import ai.starlake.schema.model.ExpectationItem;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Schema$;
import ai.starlake.schema.model.TransformInput;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.sql.SQLUtils$;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.SparkUtils$;
import ai.starlake.utils.Utils$;
import com.manticore.jsqlformatter.JSQLFormatter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenSeq;
import scala.collection.GenSeq$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class JdbcDbUtils$
implements LazyLogging {
    public static JdbcDbUtils$ MODULE$;
    private final String lastExportTableName;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new JdbcDbUtils$();
    }

    private Logger logger$lzycompute() {
        JdbcDbUtils$ jdbcDbUtils$ = this;
        synchronized (jdbcDbUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String lastExportTableName() {
        return this.lastExportTableName;
    }

    public <T> T withJDBCConnection(Map<String, String> connectionOptions, Function1<Connection, T> f, Settings settings) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JdbcDbUtils$StarlakeConnectionPool$.MODULE$.getConnection(connectionOptions));
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error creating connection", exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw exception;
        }
        if (try_ instanceof Success) {
            Success success;
            Success success2 = (Success)try_;
            Connection connection = (Connection)success2.value();
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> f.apply((Object)connection));
            if (try_2 instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_2;
                Throwable exception = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error running sql", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                success = new Failure(exception);
            } else if (try_2 instanceof Success) {
                Success success3 = (Success)try_2;
                Object value = success3.value();
                success = new Success(value);
            } else {
                throw new MatchError((Object)try_2);
            }
            Success result = success;
            String url = (String)connectionOptions.apply((Object)"url");
            Try try_3 = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connection.close());
            if (try_3 instanceof Success) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Closed connection {}", new Object[]{url});
                }
            } else if (try_3 instanceof Failure) {
                Failure failure = (Failure)try_3;
                Throwable exception = failure.exception();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new java.lang.StringBuilder(30).append("Could not close connection to ").append(url).toString(), exception);
                }
            } else {
                throw new MatchError((Object)try_3);
            }
            Success success4 = result;
            if (success4 instanceof Failure) {
                Failure failure = (Failure)success4;
                Throwable exception = failure.exception();
                throw exception;
            }
            if (success4 instanceof Success) {
                Success success5 = success4;
                Object value = success5.value();
                return (T)value;
            }
            throw new MatchError((Object)success4);
        }
        throw new MatchError((Object)try_);
    }

    public Settings.Connection readOnlyConnection(Settings.Connection connection) {
        Map options;
        Map x$1 = options = connection.isDuckDb() ? connection.options().updated((Object)"duckdb.read_only", (Object)"true").updated((Object)"access_mode", (Object)"READ_ONLY").updated((Object)"enable_external_access", (Object)"false") : connection.options();
        ConnectionType x$2 = connection.copy$default$1();
        Option<String> x$3 = connection.copy$default$2();
        Option<String> x$4 = connection.copy$default$3();
        Option<String> x$5 = connection.copy$default$4();
        Option<String> x$6 = connection.copy$default$6();
        return connection.copy(x$2, x$3, x$4, x$5, (Map<String, String>)x$1, x$6);
    }

    public void truncateTable(Connection conn, String tableName) {
        try (Statement statement = conn.createStatement();){
            statement.executeUpdate(new java.lang.StringBuilder(15).append("TRUNCATE TABLE ").append(tableName).toString());
        }
    }

    public void createSchema(Connection conn, String domainName) throws Exception {
        Try<Object> try_ = this.executeUpdate(new java.lang.StringBuilder(28).append("CREATE SCHEMA IF NOT EXISTS ").append(domainName).toString(), conn);
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new java.lang.StringBuilder(22).append("Error creating schema ").append(domainName).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw e;
        }
        throw new MatchError(try_);
    }

    public void dropTable(Connection conn, String tableName) throws Exception {
        Try<Object> try_ = this.executeUpdate(new java.lang.StringBuilder(21).append("DROP TABLE IF EXISTS ").append(tableName).toString(), conn);
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new java.lang.StringBuilder(22).append("Error creating schema ").append(tableName).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw e;
        }
        throw new MatchError(try_);
    }

    public boolean tableExists(Connection conn, String url, String domainAndTablename) {
        JdbcDialect dialect = SparkUtils$.MODULE$.dialect(url);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ResultSet resultSet;
            try (PreparedStatement statement = conn.prepareStatement(dialect.getTableExistsQuery(domainAndTablename));){
                resultSet = statement.executeQuery();
            }
            return resultSet;
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Table {} does not exist", new Object[]{domainAndTablename});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return false;
        }
        if (try_ instanceof Success) {
            return true;
        }
        throw new MatchError((Object)try_);
    }

    public boolean executeAlterTable(String script, Connection connection) throws Exception {
        boolean bl;
        DatabaseMetaData metadata = connection.getMetaData();
        boolean isAutoCommit = connection.getAutoCommit();
        if (!metadata.supportsTransactions()) {
            throw new Exception("Database does not support alter table feature");
        }
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        try {
            int res = statement.executeUpdate(script);
            connection.commit();
            bl = true;
        }
        finally {
            statement.close();
            connection.setAutoCommit(isAutoCommit);
        }
        return bl;
    }

    public <T> T executeQuery(PreparedStatement stmt, Function1<ResultSet, T> apply) {
        ResultSet rs = stmt.executeQuery();
        Object result = apply.apply((Object)rs);
        rs.close();
        stmt.close();
        return (T)result;
    }

    public Try<Object> execute(String script, Connection connection) {
        Statement statement = connection.createStatement();
        Try result = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> statement.execute(script));
        Try try_ = result;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new java.lang.StringBuilder(18).append("Error running sql ").append(script).toString(), exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw exception;
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        boolean value = BoxesRunTime.unboxToBoolean((Object)success.value());
        statement.close();
        return result;
    }

    public Try<Object> executeUpdate(String script, Connection connection) {
        Try result;
        BoxedUnit boxedUnit;
        String sqlId = UUID.randomUUID().toString();
        String formattedSQL = SQLUtils$.MODULE$.format(script, JSQLFormatter.OutputFormat.PLAIN);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Running JDBC SQL with id {}: {}", new Object[]{sqlId, formattedSQL});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Statement statement = connection.createStatement();
        Try try_ = result = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            int count = statement.executeUpdate(script);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("{} records affected", new Object[]{BoxesRunTime.boxToInteger((int)count)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return true;
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error running JDBC SQL with id {}: {}", new Object[]{sqlId, exception.getMessage()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw exception;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            boolean value = BoxesRunTime.unboxToBoolean((Object)success.value());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("end running JDBC SQL with id {} with return value {}", new Object[]{sqlId, BoxesRunTime.boxToBoolean((boolean)value)});
            }
        } else {
            throw new MatchError((Object)try_);
        }
        statement.close();
        return result;
    }

    public boolean execute(String script, Map<String, String> connectionOptions, Settings settings) {
        return BoxesRunTime.unboxToBoolean(this.withJDBCConnection(connectionOptions, (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.$anonfun$execute$2(script, conn)), settings));
    }

    private Option<String> extractTableRemarks(JDBCSchema jdbcSchema, Connection connection, String table, Option<Settings.JdbcEngine> jdbcEngine, Settings settings) {
        Option tableRemarks = jdbcSchema.tableRemarks().orElse((Function0 & Serializable & scala.Serializable)() -> jdbcEngine.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.tableRemarks()));
        return tableRemarks.map((Function1 & Serializable & scala.Serializable)remarks -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            String sql = MODULE$.formatRemarksSQL(jdbcSchema, table, (String)remarks, settings);
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("Extracting table remarks using {}", new Object[]{sql});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next()) {
                return rs.getString(1);
            }
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Not table remark found for table {}", new Object[]{table});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return "";
        });
    }

    private Try<String> extractCaseInsensitiveSchemaName(Settings.Connection connectionSettings, DatabaseMetaData databaseMetaData, String schemaName) {
        Settings.Connection connection = connectionSettings;
        if (connection.isMySQLOrMariaDb()) {
            return Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> databaseMetaData.getCatalogs(), (Function1 & Serializable & scala.Serializable)resultSet -> {
                None$ result = None$.MODULE$;
                while (result.isEmpty() && resultSet.next()) {
                    String tableSchema = resultSet.getString("TABLE_CAT");
                    if (!schemaName.equalsIgnoreCase(tableSchema)) continue;
                    result = new Some((Object)tableSchema);
                }
                return (String)result.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new Exception(new java.lang.StringBuilder(17).append("Schema ").append(schemaName).append(" not found").toString());
                });
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        return Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> databaseMetaData.getSchemas(), (Function1 & Serializable & scala.Serializable)resultSet -> {
            None$ result = None$.MODULE$;
            while (result.isEmpty() && resultSet.next()) {
                String tableSchema = resultSet.getString("TABLE_SCHEM");
                if (!schemaName.equalsIgnoreCase(tableSchema)) continue;
                result = new Some((Object)tableSchema);
            }
            return (String)result.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception(new java.lang.StringBuilder(17).append("Schema ").append(schemaName).append(" not found").toString());
            });
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public Try<List<Tuple2<String, List<String>>>> extractSchemasAndTableNames(Settings.Connection connectionSettings, Settings settings) {
        Try<List<String>> schemas2 = this.extractJDBCSchemas(connectionSettings, settings);
        Try result = schemas2.map((Function1 & Serializable & scala.Serializable)schemas -> {
            List result = (List)schemas.map((Function1 & Serializable & scala.Serializable)schema -> {
                String x$1 = schema;
                Option<String> x$2 = JDBCSchema$.MODULE$.apply$default$1();
                Option<String> x$3 = JDBCSchema$.MODULE$.apply$default$3();
                Option<String> x$4 = JDBCSchema$.MODULE$.apply$default$4();
                List<JDBCTable> x$5 = JDBCSchema$.MODULE$.apply$default$5();
                List<String> x$6 = JDBCSchema$.MODULE$.apply$default$6();
                List<String> x$7 = JDBCSchema$.MODULE$.apply$default$7();
                Option<String> x$8 = JDBCSchema$.MODULE$.apply$default$8();
                Option<String> x$9 = JDBCSchema$.MODULE$.apply$default$9();
                Option<Trim> x$10 = JDBCSchema$.MODULE$.apply$default$10();
                Option<String> x$11 = JDBCSchema$.MODULE$.apply$default$11();
                Option<Object> x$12 = JDBCSchema$.MODULE$.apply$default$12();
                Map<String, String> x$13 = JDBCSchema$.MODULE$.apply$default$13();
                Option<Object> x$14 = JDBCSchema$.MODULE$.apply$default$14();
                Option<String> x$15 = JDBCSchema$.MODULE$.apply$default$15();
                Option<Object> x$16 = JDBCSchema$.MODULE$.apply$default$16();
                Option<Object> x$17 = JDBCSchema$.MODULE$.apply$default$17();
                JDBCSchema jdbcSchema = new JDBCSchema(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
                Option<ForkJoinTaskSupport> forkJoinTaskSupport = ParUtils$.MODULE$.createForkSupport((Option<Object>)None$.MODULE$, ParUtils$.MODULE$.createForkSupport$default$2());
                Map<String, ExtractTableAttributes> tables = MODULE$.extractJDBCTables(jdbcSchema, connectionSettings, true, true, settings, forkJoinTaskSupport);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(schema), tables.keys().toList().sorted((Ordering)Ordering.String$.MODULE$));
            }, List$.MODULE$.canBuildFrom());
            return (List)result.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$);
        });
        return result;
    }

    public Try<List<String>> extractJDBCSchemas(Settings.Connection connectionSettings, Settings settings) {
        return (Try)this.withJDBCConnection(this.readOnlyConnection(connectionSettings).options(), (Function1 & Serializable & scala.Serializable)connection -> {
            String url = (String)connectionSettings.options().apply((Object)"url");
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> databaseMetaData.getSchemas(), (Function1 & Serializable & scala.Serializable)resultSet -> (List)((SeqLike)new Iterator<String>(resultSet){
                private final ResultSet resultSet$1;

                public Iterator<String> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<String> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<String> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<String> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<String> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<String, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.$plus$plus$((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public Iterator<String> filter(Function1<String, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<String> withFilter(Function1<String, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public Iterator<String> filterNot(Function1<String, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Iterator<String> takeWhile(Function1<String, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<String> dropWhile(Function1<String, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<String, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<String, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<String, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<String, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<String> find(Function1<String, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<String, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<String, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<String> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<String> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<String> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<String> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<String> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<String, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, String, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, String, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<String, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, String, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<String, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<String> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<String> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<String> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<String> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<String> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> Map<T, U> toMap(Predef.$less$colon$less<String, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    return this.resultSet$1.next();
                }

                public String next() {
                    return this.resultSet$1.getString("TABLE_SCHEM");
                }
                {
                    this.resultSet$1 = resultSet$1;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                }
            }.toList().distinct()).sorted((Ordering)Ordering.String$.MODULE$), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }, settings);
    }

    public Map<String, ExtractTableAttributes> extractJDBCTables(JDBCSchema jdbcSchema, Settings.Connection connectionSettings, boolean skipRemarks, boolean keepOriginalName, Settings settings, Option<ForkJoinTaskSupport> fjp) {
        return (Map)this.withJDBCConnection(this.readOnlyConnection(connectionSettings).options(), (Function1 & Serializable & scala.Serializable)connection -> {
            String url = (String)connectionSettings.options().apply((Object)"url");
            String jdbcServer = url.split(":")[1];
            Option jdbcEngine = settings.appConfig().jdbcEngines().get((Object)jdbcServer);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Map jdbcTableMap = ((TraversableOnce)jdbcSchema.tables().map((Function1 & Serializable & scala.Serializable)tblSchema -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tblSchema.name().toUpperCase()), tblSchema), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List uppercaseTableNames = jdbcTableMap.keys().toList();
            Try try_ = MODULE$.extractCaseInsensitiveSchemaName(connectionSettings, databaseMetaData, jdbcSchema.schema()).flatMap((Function1 & Serializable & scala.Serializable)schemaName -> {
                BoxedUnit boxedUnit;
                Map selectedTables;
                Map map;
                List lowerCasedExcludeTables = (List)jdbcSchema.exclude().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toLowerCase(), List$.MODULE$.canBuildFrom());
                List sqlDefinedTables = (List)((List)jdbcSchema.tables().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.$anonfun$extractJDBCTables$16(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), List$.MODULE$.canBuildFrom());
                List list = uppercaseTableNames;
                if (Nil$.MODULE$.equals(list)) {
                    map = JdbcDbUtils$.extractTables$1(schemaName, sqlDefinedTables, JdbcDbUtils$.tablesInScopePredicate$1(JdbcDbUtils$.tablesInScopePredicate$default$1$1(), lowerCasedExcludeTables), jdbcSchema, connectionSettings, databaseMetaData, skipRemarks, connection, jdbcEngine, settings);
                } else if (list.contains((Object)"*")) {
                    map = JdbcDbUtils$.extractTables$1(schemaName, sqlDefinedTables, JdbcDbUtils$.tablesInScopePredicate$1(JdbcDbUtils$.tablesInScopePredicate$default$1$1(), lowerCasedExcludeTables), jdbcSchema, connectionSettings, databaseMetaData, skipRemarks, connection, jdbcEngine, settings);
                } else {
                    BoxedUnit boxedUnit2;
                    Map extractedTableNames = JdbcDbUtils$.extractTables$1(schemaName, sqlDefinedTables, JdbcDbUtils$.tablesInScopePredicate$1(list, lowerCasedExcludeTables), jdbcSchema, connectionSettings, databaseMetaData, skipRemarks, connection, jdbcEngine, settings);
                    List notExtractedTable = (List)list.diff((GenSeq)((TraversableOnce)((TraversableLike)extractedTableNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            String tableName = (String)tuple2._1();
                            return tableName;
                        }
                        throw new MatchError((Object)tuple2);
                    }, Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toUpperCase(), Iterable$.MODULE$.canBuildFrom())).toList());
                    if (notExtractedTable.nonEmpty()) {
                        String tablesNotExtractedStr = notExtractedTable.mkString(", ");
                        if (MODULE$.logger().underlying().isWarnEnabled()) {
                            MODULE$.logger().underlying().warn("The following tables where not extracted for {} : {}", new Object[]{jdbcSchema.schema(), tablesNotExtractedStr});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    map = selectedTables = extractedTableNames;
                }
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    selectedTables.keys().foreach((Function1 & Serializable & scala.Serializable)table -> {
                        JdbcDbUtils$.$anonfun$extractJDBCTables$20(table);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Using.Manager$.MODULE$.apply((Function1 & Serializable & scala.Serializable)use -> ((GenTraversableOnce)ParUtils$.MODULE$.makeParallel(selectedTables.toList(), fjp).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String tableName = (String)tuple2._1();
                        Option tableRemarks = (Option)tuple2._2();
                        return (Tuple2)ExtractUtils$.MODULE$.timeIt(new java.lang.StringBuilder(29).append("Table's schema extraction of ").append(tableName).toString(), (Function0 & Serializable & scala.Serializable)() -> {
                            BoxedUnit boxedUnit;
                            if (MODULE$.logger().underlying().isInfoEnabled()) {
                                MODULE$.logger().underlying().info("Extracting table's schema '{}' with remarks '{}'", new Object[]{tableName, tableRemarks});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return (Tuple2)MODULE$.withJDBCConnection(MODULE$.readOnlyConnection(connectionSettings).options(), (Function1 & Serializable & scala.Serializable)tableExtractConnection -> {
                                BoxedUnit boxedUnit;
                                BoxedUnit boxedUnit2;
                                JdbcColumnMetadata jdbcColumnMetadata = (JdbcColumnMetadata)jdbcSchema.tables().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.$anonfun$extractJDBCTables$25(tableName, x$8))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.sql()).map((Function1 & Serializable & scala.Serializable)sql -> {
                                    Statement statement = tableExtractConnection.createStatement();
                                    statement.setMaxRows(1);
                                    ResultSet resultSet = (ResultSet)use.apply((Object)statement.executeQuery((String)sql), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                                    return new ResultSetColumnMetadata(resultSet.getMetaData(), jdbcSchema, tableName, keepOriginalName, skipRemarks, (Option<Settings.JdbcEngine>)jdbcEngine);
                                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new JdbcColumnDatabaseMetadata(connectionSettings, tableExtractConnection.getMetaData(), jdbcSchema, (String)schemaName, tableName, keepOriginalName, skipRemarks, (Option<Settings.JdbcEngine>)jdbcEngine, settings));
                                List<String> primaryKeys = jdbcColumnMetadata.primaryKeys();
                                Map<String, String> foreignKeys = jdbcColumnMetadata.foreignKeys();
                                List<Attribute> columns = jdbcColumnMetadata.columns();
                                if (MODULE$.logger().underlying().isDebugEnabled()) {
                                    columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                                        JdbcDbUtils$.$anonfun$extractJDBCTables$29(tableName, column);
                                        return BoxedUnit.UNIT;
                                    });
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                Option jdbcCurrentTable = jdbcTableMap.get((Object)tableName.toUpperCase());
                                Map currentTableRequestedColumns = ((TraversableOnce)jdbcCurrentTable.map((Function1 & Serializable & scala.Serializable)x$10 -> (List)x$10.columns().map((Function1 & Serializable & scala.Serializable)c -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)(keepOriginalName ? c.name().toUpperCase().trim() : ((String)c.rename().getOrElse((Function0 & Serializable & scala.Serializable)() -> c.name())).toUpperCase().trim())), c.rename()), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).toMap(Predef$.MODULE$.$conforms());
                                Option currentFilter = jdbcCurrentTable.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.filter());
                                List selectedColumns = (List)((List)columns.filter((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.$anonfun$extractJDBCTables$35(currentTableRequestedColumns, col)))).map((Function1 & Serializable & scala.Serializable)c -> {
                                    Option x$1 = foreignKeys.get((Object)c.name().toUpperCase());
                                    String x$2 = c.copy$default$1();
                                    String x$3 = c.copy$default$2();
                                    Option<Object> x$4 = c.copy$default$3();
                                    Option<Object> x$5 = c.copy$default$4();
                                    Option<TransformInput> x$6 = c.copy$default$5();
                                    Option<String> x$7 = c.copy$default$6();
                                    Option<String> x$8 = c.copy$default$7();
                                    Option<MetricType> x$9 = c.copy$default$8();
                                    List<Attribute> x$10 = c.copy$default$9();
                                    Option<Position> x$11 = c.copy$default$10();
                                    Option<String> x$12 = c.copy$default$11();
                                    Set<String> x$13 = c.copy$default$12();
                                    Option<Trim> x$14 = c.copy$default$13();
                                    Option<String> x$15 = c.copy$default$14();
                                    Option<Object> x$16 = c.copy$default$16();
                                    Option<String> x$17 = c.copy$default$17();
                                    Option<String> x$18 = c.copy$default$18();
                                    return c.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$1, x$16, x$17, x$18);
                                }, List$.MODULE$.canBuildFrom());
                                if (MODULE$.logger().underlying().isDebugEnabled()) {
                                    String schemaMessage = ((TraversableOnce)selectedColumns.map((Function1 & Serializable & scala.Serializable)c -> {
                                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c.name()), c.rename());
                                        if (tuple2 != null) {
                                            String name = (String)tuple2._1();
                                            Option option = (Option)tuple2._2();
                                            if (option instanceof Some) {
                                                Some some = (Some)option;
                                                String newName = (String)some.value();
                                                return new java.lang.StringBuilder(4).append(name).append(" as ").append(newName).toString();
                                            }
                                        }
                                        if (tuple2 != null) {
                                            String name = (String)tuple2._1();
                                            return name;
                                        }
                                        throw new MatchError((Object)tuple2);
                                    }, List$.MODULE$.canBuildFrom())).mkString("Final schema column:\n - ", "\n - ", "");
                                    if (MODULE$.logger().underlying().isDebugEnabled()) {
                                        MODULE$.logger().underlying().debug(schemaMessage);
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)new ExtractTableAttributes((Option<String>)tableRemarks, (List<Attribute>)selectedColumns, primaryKeys, (Option<String>)currentFilter));
                            }, settings);
                        });
                    }
                    throw new MatchError((Object)tuple2);
                }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toList().toMap(Predef$.MODULE$.$conforms()));
            });
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                Utils$.MODULE$.logException(MODULE$.logger(), exception);
                return Predef$.MODULE$.Map().empty();
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Map value = (Map)success.value();
                return value;
            }
            throw new MatchError((Object)try_);
        }, settings);
    }

    public String formatRemarksSQL(JDBCSchema jdbcSchema, String table, String remarks, Settings settings) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Map parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalog"), jdbcSchema.catalog().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)jdbcSchema.schema()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table)}));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Interpolating remark {} with parameters {}", new Object[]{remarks, parameters});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String sql = Formatter$.MODULE$.RichFormatter(remarks).richFormat((Map<String, Object>)parameters, (Map<String, Object>)Predef$.MODULE$.Map().empty(), settings);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Remark interpolated as {}", new Object[]{sql});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sql;
    }

    public Domain extractDomain(JDBCSchema jdbcSchema, Option<Domain> domainTemplate, Map<String, ExtractTableAttributes> selectedTablesAndColumns) {
        Some some;
        boolean bl;
        Option trimTemplate = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.tables().headOption().flatMap((Function1 & Serializable & scala.Serializable)x$13 -> ((Attribute)x$13.attributes().head()).trim()));
        scala.collection.immutable.Iterable cometSchema = (scala.collection.immutable.Iterable)selectedTablesAndColumns.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String tableName = (String)tuple2._1();
                ExtractTableAttributes tableAttrs = (ExtractTableAttributes)tuple2._2();
                String sanitizedTableName = Utils$.MODULE$.keepAlphaNum(tableName);
                String x$19 = tableName;
                String string = sanitizedTableName;
                String string2 = tableName;
                None$ x$20 = (string == null ? string2 != null : !string.equals(string2)) ? new Some((Object)sanitizedTableName) : None$.MODULE$;
                Pattern x$21 = Pattern.compile(new java.lang.StringBuilder(2).append(tableName).append(".*").toString());
                List x$22 = (List)tableAttrs.columNames().map((Function1 & Serializable & scala.Serializable)attr -> {
                    Option x$1 = JdbcDbUtils$.isNumeric$1(attr.type()) ? jdbcSchema.numericTrim().orElse((Function0 & Serializable & scala.Serializable)() -> trimTemplate) : trimTemplate;
                    String x$2 = attr.copy$default$1();
                    String x$3 = attr.copy$default$2();
                    Option<Object> x$4 = attr.copy$default$3();
                    Option<Object> x$5 = attr.copy$default$4();
                    Option<TransformInput> x$6 = attr.copy$default$5();
                    Option<String> x$7 = attr.copy$default$6();
                    Option<String> x$8 = attr.copy$default$7();
                    Option<MetricType> x$9 = attr.copy$default$8();
                    List<Attribute> x$10 = attr.copy$default$9();
                    Option<Position> x$11 = attr.copy$default$10();
                    Option<String> x$12 = attr.copy$default$11();
                    Set<String> x$13 = attr.copy$default$12();
                    Option<String> x$14 = attr.copy$default$14();
                    Option<String> x$15 = attr.copy$default$15();
                    Option<Object> x$16 = attr.copy$default$16();
                    Option<String> x$17 = attr.copy$default$17();
                    Option<String> x$18 = attr.copy$default$18();
                    return attr.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Trim>)x$1, x$14, x$15, x$16, x$17, x$18);
                }, List$.MODULE$.canBuildFrom());
                None$ x$23 = None$.MODULE$;
                Option<String> x$24 = tableAttrs.tableRemarks();
                Nil$ x$25 = Nil$.MODULE$;
                Nil$ x$26 = Nil$.MODULE$;
                List<String> x$27 = tableAttrs.primaryKeys();
                Set<String> x$28 = Schema$.MODULE$.apply$default$8();
                List<RowLevelSecurity> x$29 = Schema$.MODULE$.apply$default$9();
                List<ExpectationItem> x$30 = Schema$.MODULE$.apply$default$10();
                List<AccessControlEntry> x$31 = Schema$.MODULE$.apply$default$12();
                Option<String> x$32 = Schema$.MODULE$.apply$default$14();
                Option<String> x$33 = Schema$.MODULE$.apply$default$15();
                Option<String> x$34 = Schema$.MODULE$.apply$default$16();
                return new Schema(x$19, x$21, (List<Attribute>)x$22, (Option<Metadata>)x$23, x$24, (List<String>)x$25, (List<String>)x$26, x$28, x$29, x$30, x$27, x$31, (Option<String>)x$20, x$32, x$33, x$34);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        Option database = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$14 -> x$14.database());
        Option incomingDir = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)dom -> dom.resolveDirectoryOpt().map((Function1 & Serializable & scala.Serializable)dir -> DatasetArea$.MODULE$.substituteDomainAndSchemaInPath(jdbcSchema.schema(), "", (String)dir).toString()));
        String normalizedDomainName = Utils$.MODULE$.keepAlphaNum(jdbcSchema.schema());
        Option rename = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$15 -> x$15.rename()).map((Function1 & Serializable & scala.Serializable)name -> DatasetArea$.MODULE$.substituteDomainAndSchema(jdbcSchema.schema(), "", (String)name)).orElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = normalizedDomainName;
            String string2 = jdbcSchema.schema();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return new Some((Object)normalizedDomainName);
            }
            return None$.MODULE$;
        });
        Option ack = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.resolveAck());
        Option x$56 = database;
        Option<Object> option = jdbcSchema.sanitizeName();
        String x$57 = option instanceof Some && true == (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? Utils$.MODULE$.keepAlphaNum(jdbcSchema.schema()) : jdbcSchema.schema();
        Option x$58 = rename;
        Option x$59 = domainTemplate.flatMap((Function1 & Serializable & scala.Serializable)x$17 -> x$17.metadata()).map((Function1 & Serializable & scala.Serializable)x$18 -> {
            Option x$35 = incomingDir;
            Option x$36 = ack;
            Option<Format> x$37 = x$18.copy$default$1();
            Option<String> x$38 = x$18.copy$default$2();
            Option<Object> x$39 = x$18.copy$default$3();
            Option<Object> x$40 = x$18.copy$default$4();
            Option<Object> x$41 = x$18.copy$default$5();
            Option<String> x$42 = x$18.copy$default$6();
            Option<String> x$43 = x$18.copy$default$7();
            Option<String> x$44 = x$18.copy$default$8();
            Option<AllSinks> x$45 = x$18.copy$default$9();
            Option<String> x$46 = x$18.copy$default$10();
            Option<Map<String, String>> x$47 = x$18.copy$default$13();
            Option<String> x$48 = x$18.copy$default$14();
            Option<Object> x$49 = x$18.copy$default$15();
            Option<String> x$50 = x$18.copy$default$16();
            Option<Freshness> x$51 = x$18.copy$default$17();
            Option<String> x$52 = x$18.copy$default$18();
            boolean x$53 = x$18.copy$default$19();
            Option<String> x$54 = x$18.copy$default$20();
            Option<WriteStrategy> x$55 = x$18.copy$default$21();
            return x$18.copy(x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, (Option<String>)x$35, (Option<String>)x$36, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55);
        });
        List x$60 = cometSchema.toList();
        None$ x$61 = None$.MODULE$;
        Set<String> x$62 = Domain$.MODULE$.apply$default$5();
        return new Domain(x$57, (Option<Metadata>)x$59, (List<Schema>)x$60, (Option<String>)x$61, x$62, (Option<String>)x$58, (Option<String>)x$56);
    }

    public CaseInsensitiveMap<String> jdbcOptions(Map<String, String> jdbcOptions, String sparkFormat) {
        String string = sparkFormat;
        String string2 = "snowflake";
        Map options = !(string != null ? !string.equals(string2) : string2 != null) ? (Map)jdbcOptions.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (k.startsWith("sf")) {
                    String jdbcK;
                    String string = jdbcK = k.replace("sf", "").toLowerCase().replace("database", "db");
                    String string2 = "url";
                    String finalv = !(string != null ? !string.equals(string2) : string2 != null) ? new java.lang.StringBuilder(17).append("jdbc:snowflake://").append(v).toString() : v;
                    return new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jdbcK), (Object)finalv), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v), (List)Nil$.MODULE$));
                }
                return new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v), (List)Nil$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom()) : jdbcOptions;
        return CaseInsensitiveMap$.MODULE$.apply(options);
    }

    public Option<JdbcType> getCommonJDBCType(DataType dt) {
        DataType dataType = dt;
        if (IntegerType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 4));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("BIGINT", -5));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("DOUBLE PRECISION", 8));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("REAL", 6));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 5));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("BYTE", -6));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("BIT(1)", -7));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("TEXT", 2005));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("BLOB", 2004));
        }
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int n = charType.length();
            return Option$.MODULE$.apply((Object)new JdbcType(new java.lang.StringBuilder(6).append("CHAR(").append(n).append(")").toString(), 1));
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int n = varcharType.length();
            return Option$.MODULE$.apply((Object)new JdbcType(new java.lang.StringBuilder(9).append("VARCHAR(").append(n).append(")").toString(), 12));
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("TIMESTAMP", 93));
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("TIMESTAMP", 93));
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("DATE", 91));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return Option$.MODULE$.apply((Object)new JdbcType(new java.lang.StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 3));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(String script$3, Connection conn) {
        return conn.createStatement().execute(script$3);
    }

    public static final /* synthetic */ boolean $anonfun$extractJDBCTables$9(Function1 tablePredicate$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String tableName = (String)tuple2._1();
            return BoxesRunTime.unboxToBoolean((Object)tablePredicate$1.apply((Object)tableName));
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Map extractTables$1(String schemaName, List sqlDefinedTables, Function1 tablePredicate, JDBCSchema jdbcSchema$2, Settings.Connection connectionSettings$3, DatabaseMetaData databaseMetaData$3, boolean skipRemarks$1, Connection connection$3, Option jdbcEngine$2, Settings settings$3) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String[] tableTypes = jdbcSchema$2.tableTypes().nonEmpty() ? (String[])jdbcSchema$2.tableTypes().toArray(ClassTag$.MODULE$.apply(String.class)) : null;
            Settings.Connection connection = connectionSettings$3;
            if (connection.isMySQLOrMariaDb()) {
                return databaseMetaData$3.getTables(schemaName, "%", "%", tableTypes);
            }
            if (connection.isDuckDb()) {
                String[] tableTypesWithBaseTable = (String[])((TraversableOnce)jdbcSchema$2.tableTypes().map((Function1 & Serializable & scala.Serializable)tt -> {
                    String string = tt;
                    String string2 = "TABLE";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return "BASE TABLE";
                    }
                    return tt;
                }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                String[] tableTypes2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableTypesWithBaseTable)).nonEmpty() ? tableTypesWithBaseTable : null;
                ResultSet resultset = databaseMetaData$3.getTables((String)jdbcSchema$2.catalog().orNull(Predef$.MODULE$.$conforms()), schemaName, "%", tableTypes2);
                return resultset;
            }
            ResultSet resultset = databaseMetaData$3.getTables((String)jdbcSchema$2.catalog().orNull(Predef$.MODULE$.$conforms()), schemaName, "%", tableTypes);
            return resultset;
        }).flatMap((Function1 & Serializable & scala.Serializable)resultSet2 -> Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> resultSet2, (Function1 & Serializable & scala.Serializable)resultSet -> {
            Set tableNamesWithRemarks = (Set)new Iterator<Tuple2<String, Option<String>>>(resultSet){
                private final ResultSet resultSet$3;

                public Iterator<Tuple2<String, Option<String>>> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.isTraversableAgain$((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public Iterator<Tuple2<String, Option<String>>> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<String, Option<String>>> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<String, Option<String>>> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Tuple2<String, Option<String>>> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<Tuple2<String, Option<String>>, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.$plus$plus$((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<Tuple2<String, Option<String>>, GenTraversableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public Iterator<Tuple2<String, Option<String>>> filter(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<String, Option<String>>, B, Object> p) {
                    return Iterator.corresponds$((Iterator)this, that, p);
                }

                public Iterator<Tuple2<String, Option<String>>> withFilter(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public Iterator<Tuple2<String, Option<String>>> filterNot(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Tuple2<String, Option<String>>, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<String, Option<String>>, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Tuple2<String, Option<String>>, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public Iterator<Tuple2<String, Option<String>>> takeWhile(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Tuple2<String, Option<String>>>, Iterator<Tuple2<String, Option<String>>>> partition(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public Tuple2<Iterator<Tuple2<String, Option<String>>>, Iterator<Tuple2<String, Option<String>>>> span(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Tuple2<String, Option<String>>> dropWhile(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<Tuple2<String, Option<String>>, B>> zip(Iterator<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<Tuple2<String, Option<String>>, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<Tuple2<String, Option<String>>, U> f) {
                    Iterator.foreach$((Iterator)this, f);
                }

                public boolean forall(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.forall$((Iterator)this, p);
                }

                public boolean exists(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.exists$((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public Option<Tuple2<String, Option<String>>> find(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.find$((Iterator)this, p);
                }

                public int indexWhere(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return Iterator.indexWhere$((Iterator)this, p);
                }

                public int indexWhere(Function1<Tuple2<String, Option<String>>, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public BufferedIterator<Tuple2<String, Option<String>>> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public int length() {
                    return Iterator.length$((Iterator)this);
                }

                public Tuple2<Iterator<Tuple2<String, Option<String>>>, Iterator<Tuple2<String, Option<String>>>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Traversable<Tuple2<String, Option<String>>> toTraversable() {
                    return Iterator.toTraversable$((Iterator)this);
                }

                public Iterator<Tuple2<String, Option<String>>> toIterator() {
                    return Iterator.toIterator$((Iterator)this);
                }

                public Stream<Tuple2<String, Option<String>>> toStream() {
                    return Iterator.toStream$((Iterator)this);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public List<Tuple2<String, Option<String>>> reversed() {
                    return TraversableOnce.reversed$((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.size$((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.nonEmpty$((TraversableOnce)this);
                }

                public int count(Function1<Tuple2<String, Option<String>>, Object> p) {
                    return TraversableOnce.count$((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<Tuple2<String, Option<String>>, B> pf) {
                    return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, Tuple2<String, Option<String>>, B> op) {
                    return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<Tuple2<String, Option<String>>, B, B> op) {
                    return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, Tuple2<String, Option<String>>, B> op) {
                    return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Tuple2<String, Option<String>>, B, B> op) {
                    return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, Tuple2<String, Option<String>>, B> op) {
                    return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<Tuple2<String, Option<String>>, B, B> op) {
                    return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<String, Option<String>>, B> op) {
                    return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Tuple2<String, Option<String>>, B, B> op) {
                    return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<String, Option<String>>, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.product$((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                }

                public List<Tuple2<String, Option<String>>> toList() {
                    return TraversableOnce.toList$((TraversableOnce)this);
                }

                public Iterable<Tuple2<String, Option<String>>> toIterable() {
                    return TraversableOnce.toIterable$((TraversableOnce)this);
                }

                public Seq<Tuple2<String, Option<String>>> toSeq() {
                    return TraversableOnce.toSeq$((TraversableOnce)this);
                }

                public IndexedSeq<Tuple2<String, Option<String>>> toIndexedSeq() {
                    return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.toBuffer$((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.toSet$((TraversableOnce)this);
                }

                public Vector<Tuple2<String, Option<String>>> toVector() {
                    return TraversableOnce.toVector$((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<String, Option<String>>, Col> cbf) {
                    return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                }

                public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Tuple2<String, Option<String>>, Tuple2<T, U>> ev) {
                    return TraversableOnce.toMap$((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.mkString$((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                }

                public int sizeHintIfCheap() {
                    return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                }

                public boolean hasNext() {
                    return this.resultSet$3.next();
                }

                public Tuple2<String, Option<String>> next() {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resultSet$3.getString("TABLE_NAME")), (Object)Option$.MODULE$.apply((Object)this.resultSet$3.getString("REMARKS")));
                }
                {
                    this.resultSet$3 = resultSet$3;
                    GenTraversableOnce.$init$((GenTraversableOnce)this);
                    TraversableOnce.$init$((TraversableOnce)this);
                    Iterator.$init$((Iterator)this);
                }
            }.toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)sqlDefinedTables.map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), (Object)None$.MODULE$), List$.MODULE$.canBuildFrom())).toSet());
            return ((TraversableOnce)((SetLike)tableNamesWithRemarks.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.$anonfun$extractJDBCTables$9(tablePredicate, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    None$ none$;
                    String tableName = (String)tuple2._1();
                    Option metadataRemarks = (Option)tuple2._2();
                    if (skipRemarks$1) {
                        none$ = None$.MODULE$;
                    } else {
                        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.extractTableRemarks(jdbcSchema$2, connection$3, tableName, (Option<Settings.JdbcEngine>)jdbcEngine$2, settings$3));
                        if (try_ instanceof Failure) {
                            BoxedUnit boxedUnit;
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            if (MODULE$.logger().underlying().isWarnEnabled()) {
                                MODULE$.logger().underlying().warn(exception.getMessage(), exception);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            none$ = None$.MODULE$;
                        } else if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Option value = (Option)success.value();
                            none$ = value;
                        } else {
                            throw new MatchError((Object)try_);
                        }
                    }
                    None$ localRemarks = none$;
                    Option remarks = localRemarks.orElse((Function0 & Serializable & scala.Serializable)() -> metadataRemarks);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)remarks);
                }
                throw new MatchError((Object)tuple2);
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Map results = (Map)success.value();
            return results;
        }
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn(Utils$.MODULE$.exceptionAsString(exception));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("The following schema could not be found {}. All tables within this schema are not ignored.", new Object[]{schemaName});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Predef$.MODULE$.Map().empty();
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$extractJDBCTables$15(List lowerCasedExcludeTables$1, List tablesToExtract$1, String tableName) {
        return !lowerCasedExcludeTables$1.contains((Object)tableName.toLowerCase()) && (tablesToExtract$1.isEmpty() || tablesToExtract$1.contains((Object)tableName.toUpperCase()));
    }

    private static final Function1 tablesInScopePredicate$1(List tablesToExtract, List lowerCasedExcludeTables$1) {
        return (Function1 & Serializable & scala.Serializable)tableName -> BoxesRunTime.boxToBoolean((boolean)JdbcDbUtils$.$anonfun$extractJDBCTables$15(lowerCasedExcludeTables$1, tablesToExtract, tableName));
    }

    private static final List tablesInScopePredicate$default$1$1() {
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$extractJDBCTables$16(JDBCTable x$5) {
        return x$5.sql().isDefined();
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$20(String table) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("Selected: {}", new Object[]{table});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$extractJDBCTables$25(String tableName$2, JDBCTable x$8) {
        return x$8.name().equalsIgnoreCase(tableName$2);
    }

    public static final /* synthetic */ void $anonfun$extractJDBCTables$29(String tableName$2, Attribute column) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("column: {}.{}", new Object[]{tableName$2, column.name()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$extractJDBCTables$35(Map currentTableRequestedColumns$1, Attribute col) {
        return currentTableRequestedColumns$1.isEmpty() || currentTableRequestedColumns$1.contains((Object)"*") || currentTableRequestedColumns$1.contains((Object)col.name().toUpperCase());
    }

    private static final boolean isNumeric$1(String sparkType) {
        String string = sparkType;
        return "double".equals(string) ? true : ("decimal".equals(string) ? true : "long".equals(string));
    }

    private JdbcDbUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.lastExportTableName = "SL_LAST_EXPORT";
    }
}

