/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.Settings;
import ai.starlake.extract.DeltaRow;
import ai.starlake.extract.ExtractDataConfig;
import ai.starlake.extract.JdbcDbUtils$;
import ai.starlake.extract.LastExportUtils;
import ai.starlake.extract.TableExtractDataConfig;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.PrimitiveType;
import ai.starlake.schema.model.PrimitiveType$date$;
import ai.starlake.schema.model.PrimitiveType$decimal$;
import ai.starlake.schema.model.PrimitiveType$int$;
import ai.starlake.schema.model.PrimitiveType$long$;
import ai.starlake.schema.model.PrimitiveType$short$;
import ai.starlake.schema.model.PrimitiveType$string$;
import ai.starlake.schema.model.PrimitiveType$timestamp$;
import ai.starlake.schema.model.WriteMode$OVERWRITE$;
import ai.starlake.utils.Utils$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

public final class LastExportUtils$
implements LazyLogging {
    public static LastExportUtils$ MODULE$;
    private final Timestamp MIN_TS;
    private final Date MIN_DATE;
    private final BigDecimal MIN_DECIMAL;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new LastExportUtils$();
    }

    private Logger logger$lzycompute() {
        LastExportUtils$ lastExportUtils$ = this;
        synchronized (lastExportUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Timestamp MIN_TS() {
        return this.MIN_TS;
    }

    private Date MIN_DATE() {
        return this.MIN_DATE;
    }

    private BigDecimal MIN_DECIMAL() {
        return this.MIN_DECIMAL;
    }

    public LastExportUtils.Bounds getBoundaries(Connection conn, Connection auditConnection, ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, List<Attribute> auditColumns, Settings settings) {
        Range partitionRange = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tableExtractDataConfig.nbPartitions());
        boolean bl = false;
        PrimitiveType primitiveType = null;
        PrimitiveType primitiveType2 = tableExtractDataConfig.partitionColumnType();
        if (((Object)PrimitiveType$long$.MODULE$).equals(primitiveType2) ? true : (((Object)PrimitiveType$short$.MODULE$).equals(primitiveType2) ? true : ((Object)PrimitiveType$int$.MODULE$).equals(primitiveType2))) {
            Option<Object> lastExport = tableExtractDataConfig.fullExport() ? None$.MODULE$ : this.getMaxLongFromSuccessfulExport(auditConnection, extractConfig, tableExtractDataConfig, "last_long", auditColumns, settings);
            return (LastExportUtils.Bounds)this.internalBoundaries(conn, extractConfig, tableExtractDataConfig, (Option<String>)None$.MODULE$, (Function1 & Serializable & scala.Serializable)statement -> {
                statement.setLong(1, BoxesRunTime.unboxToLong((Object)lastExport.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MIN_VALUE)));
                return (LastExportUtils.Bounds)JdbcDbUtils$.MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                    Tuple2.mcJJ.sp sp2;
                    rs.next();
                    long count = rs.getLong(1);
                    PrimitiveType primitiveType = tableExtractDataConfig.partitionColumnType();
                    Tuple2.mcJJ.sp sp3 = ((Object)PrimitiveType$long$.MODULE$).equals(primitiveType) ? new Tuple2.mcJJ.sp(rs.getLong(2), rs.getLong(3)) : (sp2 = ((Object)PrimitiveType$int$.MODULE$).equals(primitiveType) ? new Tuple2.mcJJ.sp((long)rs.getInt(2), (long)rs.getInt(3)) : new Tuple2.mcJJ.sp((long)rs.getShort(2), (long)rs.getShort(3)));
                    if (sp2 == null) {
                        throw new MatchError((Object)sp2);
                    }
                    long min = sp2._1$mcJ$sp();
                    long max = sp2._2$mcJ$sp();
                    Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(min, max);
                    long min2 = sp4._1$mcJ$sp();
                    long max2 = sp4._2$mcJ$sp();
                    long interval = (max2 - min2) / (long)tableExtractDataConfig.nbPartitions();
                    List intervals = ((TraversableOnce)partitionRange.map((Function1 & Serializable & scala.Serializable)index -> LastExportUtils$.$anonfun$getBoundaries$4(min2, interval, tableExtractDataConfig, max2, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    return new LastExportUtils.Bounds(PrimitiveType$long$.MODULE$, count, BoxesRunTime.boxToLong((long)max2), (List<LastExportUtils.Boundary>)intervals);
                });
            });
        }
        if (((Object)PrimitiveType$decimal$.MODULE$).equals(primitiveType2)) {
            Option<BigDecimal> lastExport = tableExtractDataConfig.fullExport() ? None$.MODULE$ : this.getMaxDecimalFromSuccessfulExport(auditConnection, extractConfig, tableExtractDataConfig, "last_decimal", auditColumns, settings);
            return (LastExportUtils.Bounds)this.internalBoundaries(conn, extractConfig, tableExtractDataConfig, (Option<String>)None$.MODULE$, (Function1 & Serializable & scala.Serializable)statement -> {
                statement.setBigDecimal(1, (BigDecimal)lastExport.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DECIMAL()));
                return (LastExportUtils.Bounds)JdbcDbUtils$.MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                    rs.next();
                    long count = rs.getLong(1);
                    BigDecimal min = (BigDecimal)Option$.MODULE$.apply((Object)rs.getBigDecimal(2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DECIMAL());
                    BigDecimal max = (BigDecimal)Option$.MODULE$.apply((Object)rs.getBigDecimal(3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DECIMAL());
                    BigDecimal interval = max.subtract(min).divide(new BigDecimal(tableExtractDataConfig.nbPartitions()));
                    List intervals = ((TraversableOnce)partitionRange.map((Function1 & Serializable & scala.Serializable)index -> LastExportUtils$.$anonfun$getBoundaries$10(min, interval, tableExtractDataConfig, max, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    return new LastExportUtils.Bounds(PrimitiveType$decimal$.MODULE$, count, max, (List<LastExportUtils.Boundary>)intervals);
                });
            });
        }
        if (((Object)PrimitiveType$date$.MODULE$).equals(primitiveType2)) {
            Option<Date> lastExport = tableExtractDataConfig.fullExport() ? None$.MODULE$ : this.getMaxDateFromSuccessfulExport(auditConnection, extractConfig, tableExtractDataConfig, "last_date", auditColumns, settings);
            return (LastExportUtils.Bounds)this.internalBoundaries(conn, extractConfig, tableExtractDataConfig, (Option<String>)None$.MODULE$, (Function1 & Serializable & scala.Serializable)statement -> {
                statement.setDate(1, (Date)lastExport.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DATE()));
                return (LastExportUtils.Bounds)JdbcDbUtils$.MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                    rs.next();
                    long count = rs.getLong(1);
                    Date min = (Date)Option$.MODULE$.apply((Object)rs.getDate(2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DATE());
                    Date max = (Date)Option$.MODULE$.apply((Object)rs.getDate(3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_DATE());
                    long interval = (max.getTime() - min.getTime()) / (long)tableExtractDataConfig.nbPartitions();
                    List intervals = ((TraversableOnce)partitionRange.map((Function1 & Serializable & scala.Serializable)index -> LastExportUtils$.$anonfun$getBoundaries$16(min, interval, tableExtractDataConfig, max, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    return new LastExportUtils.Bounds(PrimitiveType$date$.MODULE$, count, max, (List<LastExportUtils.Boundary>)intervals);
                });
            });
        }
        if (((Object)PrimitiveType$timestamp$.MODULE$).equals(primitiveType2)) {
            Option<Timestamp> lastExport = tableExtractDataConfig.fullExport() ? None$.MODULE$ : this.getMaxTimestampFromSuccessfulExport(auditConnection, extractConfig, tableExtractDataConfig, "last_ts", auditColumns, settings);
            return (LastExportUtils.Bounds)this.internalBoundaries(conn, extractConfig, tableExtractDataConfig, (Option<String>)None$.MODULE$, (Function1 & Serializable & scala.Serializable)statement -> {
                statement.setTimestamp(1, (Timestamp)lastExport.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_TS()));
                return (LastExportUtils.Bounds)JdbcDbUtils$.MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                    rs.next();
                    long count = rs.getLong(1);
                    Timestamp min = (Timestamp)Option$.MODULE$.apply((Object)rs.getTimestamp(2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_TS());
                    Timestamp max = (Timestamp)Option$.MODULE$.apply((Object)rs.getTimestamp(3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.MIN_TS());
                    long interval = (max.getTime() - min.getTime()) / (long)tableExtractDataConfig.nbPartitions();
                    List intervals = ((TraversableOnce)partitionRange.map((Function1 & Serializable & scala.Serializable)index -> LastExportUtils$.$anonfun$getBoundaries$22(min, interval, tableExtractDataConfig, max, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    return new LastExportUtils.Bounds(PrimitiveType$timestamp$.MODULE$, count, max, (List<LastExportUtils.Boundary>)intervals);
                });
            });
        }
        if (((Object)PrimitiveType$string$.MODULE$).equals(primitiveType2)) {
            bl = true;
            primitiveType = primitiveType2;
            if (tableExtractDataConfig.hashFunc().isDefined()) {
                BoxedUnit boxedUnit;
                if (!tableExtractDataConfig.fullExport()) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Delta fetching is not compatible with partition on string. Going to extract fully in parallel. To disable this warning please set fullExport in the table definition.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option stringPartitionFunc = tableExtractDataConfig.hashFunc().map((Function1 & Serializable & scala.Serializable)x$20 -> Utils$.MODULE$.parseJinjaTpl((String)x$20, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col"), (Object)String.valueOf(extractConfig.data().quoteIdentifier(tableExtractDataConfig.partitionColumn()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nb_partitions"), (Object)Integer.toString(tableExtractDataConfig.nbPartitions()))}))), settings));
                return (LastExportUtils.Bounds)this.internalBoundaries(conn, extractConfig, tableExtractDataConfig, (Option<String>)stringPartitionFunc, (Function1 & Serializable & scala.Serializable)statement -> {
                    Tuple3 tuple3;
                    int n = statement.getParameterMetaData().getParameterType(1);
                    switch (n) {
                        case -5: {
                            statement.setLong(1, Long.MIN_VALUE);
                            tuple3 = (Tuple3)JdbcDbUtils$.MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                                rs.next();
                                long count = rs.getLong(1);
                                long min = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)rs.getLong(2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                                long max = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)rs.getLong(3))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                                return new Tuple3((Object)BoxesRunTime.boxToLong((long)count), (Object)BoxesRunTime.boxToLong((long)min), (Object)BoxesRunTime.boxToLong((long)max));
                            });
                            break;
                        }
                        case 4: {
                            statement.setInt(1, Integer.MIN_VALUE);
                            tuple3 = (Tuple3)JdbcDbUtils$.MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                                rs.next();
                                long count = rs.getLong(1);
                                long min = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)rs.getInt(2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                                long max = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)rs.getInt(3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                                return new Tuple3((Object)BoxesRunTime.boxToLong((long)count), (Object)BoxesRunTime.boxToLong((long)min), (Object)BoxesRunTime.boxToLong((long)max));
                            });
                            break;
                        }
                        case 5: {
                            statement.setShort(1, (short)Short.MIN_VALUE);
                            tuple3 = (Tuple3)JdbcDbUtils$.MODULE$.executeQuery((PreparedStatement)statement, (Function1 & Serializable & scala.Serializable)rs -> {
                                rs.next();
                                long count = rs.getLong(1);
                                long min = BoxesRunTime.unboxToShort((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)rs.getShort(2))).getOrElse((Function0)(JFunction0.mcS.sp & Serializable & scala.Serializable)() -> (short)0));
                                long max = BoxesRunTime.unboxToShort((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)rs.getShort(3))).getOrElse((Function0)(JFunction0.mcS.sp & Serializable & scala.Serializable)() -> (short)0));
                                return new Tuple3((Object)BoxesRunTime.boxToLong((long)count), (Object)BoxesRunTime.boxToLong((long)min), (Object)BoxesRunTime.boxToLong((long)max));
                            });
                            break;
                        }
                        default: {
                            String typeName = statement.getParameterMetaData().getParameterTypeName(1);
                            throw new RuntimeException(new StringBuilder(33).append("Type ").append(typeName).append(" not supported for partition").toString());
                        }
                    }
                    Tuple3 tuple32 = tuple3;
                    if (tuple32 == null) {
                        throw new MatchError((Object)tuple32);
                    }
                    long count = BoxesRunTime.unboxToLong((Object)tuple32._1());
                    long min = BoxesRunTime.unboxToLong((Object)tuple32._2());
                    long max = BoxesRunTime.unboxToLong((Object)tuple32._3());
                    Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToLong((long)count), (Object)BoxesRunTime.boxToLong((long)min), (Object)BoxesRunTime.boxToLong((long)max));
                    long count2 = BoxesRunTime.unboxToLong((Object)tuple33._1());
                    long min2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
                    long max2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
                    long l = count2;
                    if (0L == l) {
                        return new LastExportUtils.Bounds(PrimitiveType$long$.MODULE$, count2, BoxesRunTime.boxToInteger((int)0), (List<LastExportUtils.Boundary>)List$.MODULE$.empty());
                    }
                    List partitions = ((TraversableOnce)new RichLong(Predef$.MODULE$.longWrapper(min2)).to((Object)BoxesRunTime.boxToLong((long)max2)).map((Function1 & Serializable & scala.Serializable)p -> LastExportUtils$.$anonfun$getBoundaries$34(BoxesRunTime.unboxToLong((Object)p)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    return new LastExportUtils.Bounds(PrimitiveType$long$.MODULE$, count2, BoxesRunTime.boxToLong((long)max2), (List<LastExportUtils.Boundary>)partitions);
                });
            }
        }
        if (bl && tableExtractDataConfig.hashFunc().isEmpty()) {
            throw new Exception(new StringBuilder(226).append("Unsupported type ").append(tableExtractDataConfig.partitionColumnType()).append(" for column partition column ").append(tableExtractDataConfig.partitionColumn()).append(" in table ").append(tableExtractDataConfig.domain()).append(".").append(tableExtractDataConfig.table()).append(". You may define your own hash to int function via stringPartitionFunc in jdbcSchema in order to support parallel fetch. Eg: abs( hashtext({{col}}) % {{nb_partitions}} )").toString());
        }
        throw new Exception(new StringBuilder(57).append("Unsupported type ").append(tableExtractDataConfig.partitionColumnType()).append(" for column partition column ").append(tableExtractDataConfig.partitionColumn()).append(" in table ").append(tableExtractDataConfig.domain()).append(".").append(tableExtractDataConfig.table()).toString());
    }

    private <T> T internalBoundaries(Connection conn, ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, Option<String> hashFunc, Function1<PreparedStatement, T> apply) {
        String extraCondition = (String)tableExtractDataConfig.filterOpt().map((Function1 & Serializable & scala.Serializable)w -> new StringBuilder(4).append("and ").append((String)w).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String quotedColumn = extractConfig.data().quoteIdentifier(tableExtractDataConfig.partitionColumn());
        String columnToDistribute = (String)hashFunc.getOrElse((Function0 & Serializable & scala.Serializable)() -> quotedColumn);
        String dataSource = (String)tableExtractDataConfig.sql().map((Function1 & Serializable & scala.Serializable)x$22 -> new StringBuilder(17).append("(").append((String)x$22).append(") sl_data_source").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(extractConfig.data().quoteIdentifier(tableExtractDataConfig.domain())).append(".").append(extractConfig.data().quoteIdentifier(tableExtractDataConfig.table())).toString());
        String SQL_BOUNDARIES_VALUES = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("select count(").append(quotedColumn).append(") as count_value, min(").append(columnToDistribute).append(") as min_value, max(").append(columnToDistribute).append(") as max_value\n         |from ").append(dataSource).append("\n         |where ").append(columnToDistribute).append(" > ? ").append(extraCondition).toString())).stripMargin();
        PreparedStatement preparedStatement = conn.prepareStatement(SQL_BOUNDARIES_VALUES);
        return (T)apply.apply((Object)preparedStatement);
    }

    public Option<Object> getMaxLongFromSuccessfulExport(Connection conn, ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, String columnName, List<Attribute> auditColumns, Settings settings) {
        return this.getMaxValueFromSuccessfulExport(conn, extractConfig, tableExtractDataConfig, columnName, auditColumns, (Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)x$23.getLong(1)), settings);
    }

    public Option<BigDecimal> getMaxDecimalFromSuccessfulExport(Connection conn, ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, String columnName, List<Attribute> auditColumns, Settings settings) {
        return this.getMaxValueFromSuccessfulExport(conn, extractConfig, tableExtractDataConfig, columnName, auditColumns, (Function1 & Serializable & scala.Serializable)x$24 -> x$24.getBigDecimal(1), settings);
    }

    public Option<Timestamp> getMaxTimestampFromSuccessfulExport(Connection conn, ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, String columnName, List<Attribute> auditColumns, Settings settings) {
        return this.getMaxValueFromSuccessfulExport(conn, extractConfig, tableExtractDataConfig, columnName, auditColumns, (Function1 & Serializable & scala.Serializable)x$25 -> x$25.getTimestamp(1), settings);
    }

    public Option<Date> getMaxDateFromSuccessfulExport(Connection conn, ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, String columnName, List<Attribute> auditColumns, Settings settings) {
        return this.getMaxValueFromSuccessfulExport(conn, extractConfig, tableExtractDataConfig, columnName, auditColumns, (Function1 & Serializable & scala.Serializable)x$26 -> x$26.getDate(1), settings);
    }

    private <T> Option<T> getMaxValueFromSuccessfulExport(Connection conn, ExtractDataConfig extractConfig, TableExtractDataConfig tableExtractDataConfig, String columnName, List<Attribute> auditColumns, Function1<ResultSet, T> extractColumn, Settings settings) {
        BoxedUnit boxedUnit;
        String auditSchema = settings.appConfig().audit().getDomain(settings);
        String normalizedColumnName = this.getColName$1(columnName, extractConfig, auditSchema, auditColumns);
        String domainColumn = this.getColName$1("domain", extractConfig, auditSchema, auditColumns);
        String schemaColumn = this.getColName$1("schema", extractConfig, auditSchema, auditColumns);
        String stepColumn = this.getColName$1("step", extractConfig, auditSchema, auditColumns);
        String successColumn = this.getColName$1("success", extractConfig, auditSchema, auditColumns);
        String lastExtractionSQL = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n         |select max(").append(normalizedColumnName).append(")\n         |  from ").append(auditSchema).append(".").append(JdbcDbUtils$.MODULE$.lastExportTableName()).append("\n         |where\n         |  ").append(domainColumn).append(" = ?\n         |  and ").append(schemaColumn).append(" = ?\n         |  and ").append(stepColumn).append(" = ?\n         |  and ").append(successColumn).toString())).stripMargin();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(lastExtractionSQL);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        PreparedStatement preparedStatement = conn.prepareStatement(lastExtractionSQL);
        preparedStatement.setString(1, tableExtractDataConfig.domain());
        preparedStatement.setString(2, tableExtractDataConfig.table());
        preparedStatement.setString(3, "ALL");
        ResultSet rs = preparedStatement.executeQuery();
        if (rs.next()) {
            Object output = extractColumn.apply((Object)rs);
            if (rs.wasNull()) {
                return None$.MODULE$;
            }
            return Option$.MODULE$.apply(output);
        }
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertNewLastExport(Connection conn, DeltaRow row, Option<PrimitiveType> partitionColumnType, Settings.Connection connectionSettings, List<Attribute> auditColumns, Settings settings) {
        String string;
        Some some;
        PrimitiveType primitiveType;
        conn.setAutoCommit(true);
        String auditSchema = settings.appConfig().audit().getDomain(settings);
        String cols = ((TraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"domain", "schema", "start_ts", "end_ts", "duration", "mode", "count", "success", "message", "step"})).map((Function1 & Serializable & scala.Serializable)colName -> this.getColName$2((String)colName, connectionSettings, auditSchema, (List)auditColumns), List$.MODULE$.canBuildFrom())).mkString(",");
        String fullReport = new StringBuilder(52).append("insert into ").append(auditSchema).append(".").append(JdbcDbUtils$.MODULE$.lastExportTableName()).append("(").append(cols).append(") values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)").toString();
        Option<PrimitiveType> option = partitionColumnType;
        if (None$.MODULE$.equals(option) ? true : option instanceof Some && ((Object)PrimitiveType$string$.MODULE$).equals(primitiveType = (PrimitiveType)(some = (Some)option).value())) {
            string = fullReport;
        } else {
            String string2;
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some2 = (Some)option;
            PrimitiveType partitionColumnType2 = (PrimitiveType)some2.value();
            PrimitiveType primitiveType2 = partitionColumnType2;
            if (((Object)PrimitiveType$int$.MODULE$).equals(primitiveType2) ? true : (((Object)PrimitiveType$long$.MODULE$).equals(primitiveType2) ? true : ((Object)PrimitiveType$short$.MODULE$).equals(primitiveType2))) {
                string2 = this.getColName$2("last_long", connectionSettings, auditSchema, auditColumns);
            } else if (((Object)PrimitiveType$decimal$.MODULE$).equals(primitiveType2)) {
                string2 = this.getColName$2("last_decimal", connectionSettings, auditSchema, auditColumns);
            } else if (((Object)PrimitiveType$date$.MODULE$).equals(primitiveType2)) {
                string2 = this.getColName$2("last_date", connectionSettings, auditSchema, auditColumns);
            } else {
                if (!((Object)PrimitiveType$timestamp$.MODULE$).equals(primitiveType2)) throw new Exception(new StringBuilder(52).append("type ").append(partitionColumnType2).append(" not supported for partition columnToDistribute").toString());
                string2 = this.getColName$2("last_ts", connectionSettings, auditSchema, auditColumns);
            }
            String lastExportColumn = string2;
            String auditSchema2 = settings.appConfig().audit().getDomain(settings);
            string = new StringBuilder(57).append("insert into ").append(auditSchema2).append(".").append(JdbcDbUtils$.MODULE$.lastExportTableName()).append("(").append(cols).append(", ").append(lastExportColumn).append(") values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)").toString();
        }
        String sqlInsert = string;
        PreparedStatement preparedStatement = conn.prepareStatement(sqlInsert);
        preparedStatement.setString(1, row.domain());
        preparedStatement.setString(2, row.schema());
        preparedStatement.setTimestamp(3, row.start());
        preparedStatement.setTimestamp(4, row.end());
        preparedStatement.setInt(5, row.duration());
        preparedStatement.setString(6, WriteMode$OVERWRITE$.MODULE$.toString());
        preparedStatement.setLong(7, row.count());
        preparedStatement.setBoolean(8, row.success());
        preparedStatement.setString(9, row.message());
        preparedStatement.setString(10, row.step());
        Option<PrimitiveType> option2 = partitionColumnType;
        if (None$.MODULE$.equals(option2)) {
            return preparedStatement.executeUpdate();
        } else {
            if (!(option2 instanceof Some)) throw new MatchError(option2);
            Some some3 = (Some)option2;
            PrimitiveType partitionColumnType3 = (PrimitiveType)some3.value();
            PrimitiveType primitiveType3 = partitionColumnType3;
            if (((Object)PrimitiveType$int$.MODULE$).equals(primitiveType3) ? true : (((Object)PrimitiveType$long$.MODULE$).equals(primitiveType3) ? true : ((Object)PrimitiveType$short$.MODULE$).equals(primitiveType3))) {
                preparedStatement.setLong(11, BoxesRunTime.unboxToLong((Object)row.lastExport()));
                return preparedStatement.executeUpdate();
            } else if (((Object)PrimitiveType$decimal$.MODULE$).equals(primitiveType3)) {
                preparedStatement.setBigDecimal(11, (BigDecimal)row.lastExport());
                return preparedStatement.executeUpdate();
            } else if (((Object)PrimitiveType$date$.MODULE$).equals(primitiveType3)) {
                preparedStatement.setDate(11, (Date)row.lastExport());
                return preparedStatement.executeUpdate();
            } else if (((Object)PrimitiveType$timestamp$.MODULE$).equals(primitiveType3)) {
                preparedStatement.setTimestamp(11, (Timestamp)row.lastExport());
                return preparedStatement.executeUpdate();
            } else if (!((Object)PrimitiveType$string$.MODULE$).equals(primitiveType3)) throw new Exception(new StringBuilder(52).append("type ").append(partitionColumnType3).append(" not supported for partition columnToDistribute").toString());
        }
        return preparedStatement.executeUpdate();
    }

    private String getCaseInsensitiveColumnName(String domain, String table, List<Attribute> columns, String columnName) {
        return (String)columns.find((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)LastExportUtils$.$anonfun$getCaseInsensitiveColumnName$1(columnName, x$27))).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(22).append("Column ").append(columnName).append(" not found in ").append(domain).append(".").append(table).toString());
        });
    }

    public static final /* synthetic */ LastExportUtils.Boundary $anonfun$getBoundaries$4(long min$1, long interval$1, TableExtractDataConfig tableExtractDataConfig$1, long max$1, int index) {
        LastExportUtils.BoundType lower = index == 0 ? new LastExportUtils.InclusiveBound(BoxesRunTime.boxToLong((long)min$1)) : new LastExportUtils.ExclusiveBound(BoxesRunTime.boxToLong((long)(min$1 + interval$1 * (long)index)));
        long upper = index == tableExtractDataConfig$1.nbPartitions() - 1 ? max$1 : min$1 + interval$1 * (long)(index + 1);
        return new LastExportUtils.Boundary(lower, new LastExportUtils.InclusiveBound(BoxesRunTime.boxToLong((long)upper)));
    }

    public static final /* synthetic */ LastExportUtils.Boundary $anonfun$getBoundaries$10(BigDecimal min$2, BigDecimal interval$2, TableExtractDataConfig tableExtractDataConfig$1, BigDecimal max$2, int index) {
        LastExportUtils.BoundType lower = index == 0 ? new LastExportUtils.InclusiveBound(min$2) : new LastExportUtils.ExclusiveBound(min$2.add(interval$2.multiply(new BigDecimal(index))));
        BigDecimal upper = index == tableExtractDataConfig$1.nbPartitions() - 1 ? max$2 : min$2.add(interval$2.multiply(new BigDecimal(index + 1)));
        return new LastExportUtils.Boundary(lower, new LastExportUtils.InclusiveBound(upper));
    }

    public static final /* synthetic */ LastExportUtils.Boundary $anonfun$getBoundaries$16(Date min$3, long interval$3, TableExtractDataConfig tableExtractDataConfig$1, Date max$3, int index) {
        LastExportUtils.BoundType lower = index == 0 ? new LastExportUtils.InclusiveBound(min$3) : new LastExportUtils.ExclusiveBound(new Date(min$3.getTime() + interval$3 * (long)index));
        Date upper = index == tableExtractDataConfig$1.nbPartitions() - 1 ? max$3 : new Date(min$3.getTime() + interval$3 * (long)(index + 1));
        return new LastExportUtils.Boundary(lower, new LastExportUtils.InclusiveBound(upper));
    }

    public static final /* synthetic */ LastExportUtils.Boundary $anonfun$getBoundaries$22(Timestamp min$4, long interval$4, TableExtractDataConfig tableExtractDataConfig$1, Timestamp max$4, int index) {
        LastExportUtils.BoundType lower = index == 0 ? new LastExportUtils.InclusiveBound(min$4) : new LastExportUtils.ExclusiveBound(new Timestamp(min$4.getTime() + interval$4 * (long)index));
        Timestamp upper = index == tableExtractDataConfig$1.nbPartitions() - 1 ? max$4 : new Timestamp(min$4.getTime() + interval$4 * (long)(index + 1));
        return new LastExportUtils.Boundary(lower, new LastExportUtils.InclusiveBound(upper));
    }

    public static final /* synthetic */ LastExportUtils.Boundary $anonfun$getBoundaries$34(long p) {
        return new LastExportUtils.Boundary(new LastExportUtils.InclusiveBound(BoxesRunTime.boxToLong((long)p)), new LastExportUtils.ExclusiveBound(BoxesRunTime.boxToLong((long)(p + 1L))));
    }

    private final String getColName$1(String colName, ExtractDataConfig extractConfig$3, String auditSchema$1, List auditColumns$1) {
        return extractConfig$3.audit().quoteIdentifier(this.getCaseInsensitiveColumnName(auditSchema$1, JdbcDbUtils$.MODULE$.lastExportTableName(), (List<Attribute>)auditColumns$1, colName));
    }

    private final String getColName$2(String colName, Settings.Connection connectionSettings$4, String auditSchema$2, List auditColumns$2) {
        return connectionSettings$4.quoteIdentifier(this.getCaseInsensitiveColumnName(auditSchema$2, JdbcDbUtils$.MODULE$.lastExportTableName(), (List<Attribute>)auditColumns$2, colName));
    }

    public static final /* synthetic */ boolean $anonfun$getCaseInsensitiveColumnName$1(String columnName$1, Attribute x$27) {
        return x$27.name().equalsIgnoreCase(columnName$1);
    }

    private LastExportUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.MIN_TS = Timestamp.valueOf("1970-01-01 00:00:00");
        this.MIN_DATE = Date.valueOf("1970-01-01");
        this.MIN_DECIMAL = BigDecimal.ZERO;
    }
}

