/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.extract;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.extract.BigQueryTablesConfig;
import ai.starlake.extract.BigQueryTablesConfig$;
import ai.starlake.extract.ExtractBigQuerySchema;
import ai.starlake.extract.ExtractJDBCSchemaCmd$;
import ai.starlake.extract.ExtractSchemaConfig;
import ai.starlake.extract.ExtractSchemaConfig$;
import ai.starlake.extract.JdbcDbUtils$;
import ai.starlake.extract.SparkExtractorJob;
import ai.starlake.extract.SparkExtractorJob$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.ConnectionType;
import ai.starlake.schema.model.ConnectionType$BQ$;
import ai.starlake.schema.model.ConnectionType$FS$;
import ai.starlake.schema.model.ConnectionType$JDBC$;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.JobResult;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class SchemaExtractor$ {
    public static SchemaExtractor$ MODULE$;

    static {
        new SchemaExtractor$();
    }

    public Object extractSchemas(String connectionName, Option<String> accessToken, Map<String, List<String>> domainAndTablesNames, Settings settings) {
        Object object;
        Settings.Connection connection = (Settings.Connection)settings.appConfig().connections().apply((Object)connectionName);
        ConnectionType connType = connection.type();
        SchemaHandler schemaHandler = settings.schemaHandler(settings.schemaHandler$default$1(), settings.schemaHandler$default$2());
        if (settings.appConfig().autoExportSchema()) {
            settings.storageHandler(settings.storageHandler$default$1()).delete(DatasetArea$.MODULE$.external(settings));
            object = BoxesRunTime.boxToBoolean((boolean)settings.storageHandler(settings.storageHandler$default$1()).mkdirs(DatasetArea$.MODULE$.external(settings)));
        } else {
            object = BoxedUnit.UNIT;
        }
        ConnectionType connectionType = connType;
        if (((Object)ConnectionType$JDBC$.MODULE$).equals(connectionType) ? true : ((Object)ConnectionType$BQ$.MODULE$).equals(connectionType)) {
            Iterable tables = (Iterable)domainAndTablesNames.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    List value = (List)tuple2._2();
                    return (List)value.map((Function1 & Serializable & scala.Serializable)table -> new StringBuilder(1).append(key).append(".").append((String)table).toString(), List$.MODULE$.canBuildFrom());
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom());
            boolean x$1 = settings.appConfig().autoExportSchema();
            Some x$2 = new Some((Object)DatasetArea$.MODULE$.external(settings).toString());
            List x$3 = tables.toList();
            Some x$4 = new Some((Object)connectionName);
            Option<String> x$5 = accessToken;
            String x$6 = ExtractSchemaConfig$.MODULE$.apply$default$1();
            Option<Object> x$7 = ExtractSchemaConfig$.MODULE$.apply$default$4();
            ExtractSchemaConfig config = new ExtractSchemaConfig(x$6, (Seq<String>)x$3, (Option<String>)x$2, x$7, x$1, (Option<String>)x$4, x$5);
            Try<JobResult> result = ExtractJDBCSchemaCmd$.MODULE$.run(config, schemaHandler, settings);
            return result;
        }
        if (((Object)ConnectionType$FS$.MODULE$).equals(connectionType)) {
            List domains;
            SparkExtractorJob job = new SparkExtractorJob(domainAndTablesNames, settings);
            Try<List<Domain>> try_ = job.schemasAndTables();
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                domains = (List)success.value();
            } else {
                throw new Exception("Failed to extract schemas and tables");
            }
            List<Domain> result = settings.appConfig().autoExportSchema() ? schemaHandler.saveToExternals((List<Domain>)domains) : BoxedUnit.UNIT;
            return result;
        }
        throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported connection type: ").append(connType).toString());
    }

    public Map<String, List<String>> extractSchemas$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Try<List<Tuple2<String, List<String>>>> extractSchemaNames(String connectionName, Option<String> accessToken, Map<String, List<String>> tables, Settings settings) {
        Settings.Connection connection = (Settings.Connection)settings.appConfig().connections().apply((Object)connectionName);
        ConnectionType connType = connection.type();
        ConnectionType connectionType = connType;
        if (((Object)ConnectionType$JDBC$.MODULE$).equals(connectionType)) {
            Try<List<Tuple2<String, List<String>>>> result = JdbcDbUtils$.MODULE$.extractSchemasAndTableNames(connection, settings);
            return result;
        }
        if (((Object)ConnectionType$BQ$.MODULE$).equals(connectionType)) {
            Some x$1 = new Some((Object)connectionName);
            Option<String> x$2 = accessToken;
            Map<String, List<String>> x$3 = tables;
            Option<WriteMode> x$4 = BigQueryTablesConfig$.MODULE$.apply$default$1();
            Option<String> x$5 = BigQueryTablesConfig$.MODULE$.apply$default$4();
            boolean x$6 = BigQueryTablesConfig$.MODULE$.apply$default$5();
            boolean x$7 = BigQueryTablesConfig$.MODULE$.apply$default$6();
            ExtractBigQuerySchema extractor = new ExtractBigQuerySchema(new BigQueryTablesConfig(x$4, (Option<String>)x$1, x$3, x$5, x$6, x$7, x$2), settings);
            SchemaHandler schemaHandler = settings.schemaHandler(settings.schemaHandler$default$1(), settings.schemaHandler$default$2());
            Try<List<Tuple2<String, List<String>>>> result = extractor.extractSchemasAndTableNames(schemaHandler);
            return result;
        }
        if (((Object)ConnectionType$FS$.MODULE$).equals(connectionType)) {
            SparkExtractorJob job = new SparkExtractorJob(SparkExtractorJob$.MODULE$.$lessinit$greater$default$1(), settings);
            return job.schemasAndTableNames();
        }
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported connection type: ").append(connType).toString());
        });
    }

    public Map<String, List<String>> extractSchemaNames$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private SchemaExtractor$() {
        MODULE$ = this;
    }
}

