/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.bootstrap;

import ai.starlake.config.DatasetArea$;
import ai.starlake.config.Settings;
import ai.starlake.utils.JarUtil$;
import ai.starlake.utils.YamlSerde$;
import better.files.File;
import better.files.File$;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.io.StdIn$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class Bootstrap$
implements StrictLogging {
    public static Bootstrap$ MODULE$;
    private final String TEMPLATES_DIR;
    private final Logger logger;

    static {
        new Bootstrap$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String TEMPLATES_DIR() {
        return this.TEMPLATES_DIR;
    }

    private List<File> copyToFolder(List<String> resources, String templateFolder, File targetFolder) {
        return (List)resources.map((Function1 & Serializable & scala.Serializable)resource -> {
            String contents;
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("copying {}", new Object[]{resource});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BufferedSource source = Source$.MODULE$.fromResource(resource, Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec());
            if (source == null) {
                throw new Exception(new StringBuilder(31).append("Resource ").append((String)resource).append(" not found in assembly").toString());
            }
            Iterator lines = source.getLines();
            File targetFile = File$.MODULE$.apply(targetFolder.pathAsString(), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(resource.substring(templateFolder.length()))).split('/'))).toIndexedSeq());
            File qual$1 = targetFile.parent();
            Seq x$1 = qual$1.createDirectories$default$1();
            Seq x$2 = qual$1.createDirectories$default$2();
            qual$1.createDirectories(x$1, x$2);
            String x$3 = contents = lines.mkString("\n");
            Seq x$4 = targetFile.overwrite$default$2(x$3);
            Charset x$5 = targetFile.overwrite$default$3(x$3);
            return targetFile.overwrite(x$3, x$4, x$5);
        }, List$.MODULE$.canBuildFrom());
    }

    private Option<String> askTemplate(Option<String> maybeString) {
        Option<String> option = maybeString;
        if (option instanceof Some) {
            Some some = (Some)option;
            String template = (String)some.value();
            return new Some((Object)template);
        }
        if (None$.MODULE$.equals(option)) {
            List<String> templates = JarUtil$.MODULE$.getResourceFolders("templates/bootstrap/samples/");
            if (templates.length() == 1) {
                return new Some(templates.head());
            }
            Predef$.MODULE$.println((Object)"Please choose a template:");
            ((List)templates.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Bootstrap$.$anonfun$askTemplate$1(x0$1);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.println((Object)"  q. quit");
            return this.requestAnswer(templates);
        }
        throw new MatchError(option);
    }

    private Option<String> requestAnswer(List<String> choices) {
        boolean ok = false;
        None$ template = None$.MODULE$;
        do {
            Predef$.MODULE$.print((Object)"=> ");
            String input = StdIn$.MODULE$.readLine();
            String string = input.toLowerCase();
            String string2 = "q";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                template = None$.MODULE$;
                ok = true;
                continue;
            }
            int index = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(input)).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
            if (index < 0 || index >= choices.length()) {
                Predef$.MODULE$.println((Object)new StringBuilder(15).append("Invalid input: ").append(input).toString());
                ok = false;
                continue;
            }
            template = new Some(choices.apply(index));
            ok = true;
        } while (!ok);
        return template;
    }

    public void bootstrap(Option<String> inputTemplate, Settings settings) {
        Option<String> template2 = this.askTemplate(inputTemplate);
        File metadataFolder = File$.MODULE$.apply(DatasetArea$.MODULE$.metadata(settings).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        metadataFolder.createDirectories(metadataFolder.createDirectories$default$1(), metadataFolder.createDirectories$default$2());
        File qual$1 = File$.MODULE$.apply(metadataFolder.parent(), "datasets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Seq x$12 = qual$1.createDirectories$default$1();
        Seq x$2 = qual$1.createDirectories$default$2();
        qual$1.createDirectories(x$12, x$2);
        Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Bootstrap$.$anonfun$bootstrap$1(x$1));
        int x$4 = metadataFolder.collectChildren$default$2();
        Seq x$5 = metadataFolder.collectChildren$default$3((Function1)x$3, x$4);
        if (metadataFolder.collectChildren((Function1)x$3, x$4, x$5).nonEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(50).append("Folder ").append(metadataFolder.pathAsString()).append(" already exists and is not empty. Aborting.").toString());
            System.exit(1);
        }
        DatasetArea$.MODULE$.folders(settings).foreach((Function1 & Serializable & scala.Serializable)p -> {
            File qual$2 = File$.MODULE$.apply(p.toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            Seq x$6 = qual$2.createDirectories$default$1();
            Seq x$7 = qual$2.createDirectories$default$2();
            return qual$2.createDirectories(x$6, x$7);
        });
        File dagLibDir = File$.MODULE$.apply(metadataFolder, "dags", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"generated"}));
        dagLibDir.createDirectories(dagLibDir.createDirectories$default$1(), dagLibDir.createDirectories$default$2());
        template2.foreach((Function1 & Serializable & scala.Serializable)template -> {
            Bootstrap$.$anonfun$bootstrap$3(metadataFolder, template);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        String template = "bigquery";
        String templatePath = new StringBuilder(10).append("bootstrap/").append(template).toString();
        List<String> bootstrapFiles = JarUtil$.MODULE$.getResourceFiles(templatePath);
        bootstrapFiles.foreach((Function1 & Serializable & scala.Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$askTemplate$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String template = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Predef$.MODULE$.println((Object)new StringBuilder(4).append("  ").append(index).append(". ").append(template).toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$bootstrap$1(File x$1) {
        return !x$1.isDirectory(x$1.isDirectory$default$1());
    }

    public static final /* synthetic */ void $anonfun$bootstrap$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String template = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Predef$.MODULE$.println((Object)new StringBuilder(4).append("  ").append(index).append(". ").append(template).toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$bootstrap$7(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String template = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Predef$.MODULE$.println((Object)new StringBuilder(4).append("  ").append(index).append(". ").append(template).toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$bootstrap$3(File metadataFolder$1, String template) {
        File dotDitIgnoreFile;
        File rootFolder = metadataFolder$1.parent();
        String templatePath = new StringBuilder(2).append(MODULE$.TEMPLATES_DIR()).append("/").append(template).append("/").toString();
        List<String> bootstrapFiles = JarUtil$.MODULE$.getResourceFiles(templatePath);
        MODULE$.copyToFolder(bootstrapFiles, templatePath, rootFolder);
        .colon.colon vscodeExtensionFiles = new .colon.colon((Object)new StringBuilder(16).append(MODULE$.TEMPLATES_DIR()).append("/extensions.json").toString(), (List)Nil$.MODULE$);
        File targetDir = rootFolder.$div(".vscode");
        targetDir.createDirectories(targetDir.createDirectories$default$1(), targetDir.createDirectories$default$2());
        MODULE$.copyToFolder((List<String>)vscodeExtensionFiles, MODULE$.TEMPLATES_DIR(), targetDir);
        .colon.colon gitIgnoreFilename = new .colon.colon((Object)new StringBuilder(10).append(MODULE$.TEMPLATES_DIR()).append("/gitignore").toString(), (List)Nil$.MODULE$);
        File gitIgnoreFile = (File)MODULE$.copyToFolder((List<String>)gitIgnoreFilename, MODULE$.TEMPLATES_DIR(), targetDir).head();
        File x$8 = dotDitIgnoreFile = gitIgnoreFile.parent().$div(".gitignore");
        Seq x$9 = gitIgnoreFile.moveTo$default$2(x$8);
        gitIgnoreFile.moveTo(x$8, x$9);
        String string = template;
        String string2 = "initializer";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            File appFile = metadataFolder$1.$div("application.sl.yml");
            String contents = appFile.contentAsString(appFile.contentAsString$default$1());
            JsonNode rootNode = YamlSerde$.MODULE$.mapper().readTree(contents);
            ObjectNode appNode = (ObjectNode)rootNode.path("application");
            ObjectNode connectionsNode = (ObjectNode)appNode.path("connections");
            List connectionKeys = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(connectionsNode.fieldNames()).asScala()).toList();
            Predef$.MODULE$.println((Object)"Please choose a connection type:");
            ((List)connectionKeys.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Bootstrap$.$anonfun$bootstrap$4(x0$1);
                return BoxedUnit.UNIT;
            });
            MODULE$.requestAnswer((List<String>)connectionKeys).foreach((Function1 & Serializable & scala.Serializable)connectionName -> {
                connectionKeys.foreach((Function1 & Serializable & scala.Serializable)key -> {
                    String string = key;
                    String string2 = connectionName;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        return connectionsNode.remove(key);
                    }
                    return BoxedUnit.UNIT;
                });
                String string = connectionName;
                String string2 = "bigquery";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    .colon.colon loaders = new .colon.colon((Object)"spark (full features)", (List)new .colon.colon((Object)"native (limited to validation features provided by the datawarehouse)", (List)Nil$.MODULE$));
                    Predef$.MODULE$.println((Object)"Select loader:");
                    ((List)loaders.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Bootstrap$.$anonfun$bootstrap$7(x0$2);
                        return BoxedUnit.UNIT;
                    });
                    MODULE$.requestAnswer((List<String>)loaders).foreach((Function1 & Serializable & scala.Serializable)loader -> {
                        block3: {
                            block2: {
                                appNode.put("loader", (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(loader)).split(' '))).head());
                                if (loader.startsWith("native")) break block2;
                                String string = connectionName;
                                String string2 = "bigquery";
                                if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                            }
                            return appNode.remove("spark");
                        }
                        return BoxedUnit.UNIT;
                    });
                }
                String x$10 = YamlSerde$.MODULE$.mapper().writeValueAsString((Object)rootNode);
                Seq x$11 = appFile.overwrite$default$2(x$10);
                Charset x$12 = appFile.overwrite$default$3(x$10);
                return appFile.overwrite(x$10, x$11, x$12);
            });
            return;
        }
    }

    private Bootstrap$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.TEMPLATES_DIR = "templates/bootstrap/samples";
    }
}

