/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.infer;

import ai.starlake.config.Settings;
import ai.starlake.job.Cmd;
import ai.starlake.job.infer.InferSchemaConfig;
import ai.starlake.job.infer.InferSchemaConfig$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Format$;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.schema.model.WriteMode$;
import ai.starlake.utils.CliConfig;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.JobResult$;
import ai.starlake.workflow.IngestionWorkflow;
import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.fusesource.scalate.TemplateEngine;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.OParserSetup;
import scopt.Read$;

public final class InferSchemaCmd$
implements Cmd<InferSchemaConfig>,
StrictLogging {
    public static InferSchemaCmd$ MODULE$;
    private final String command;
    private final OParser<BoxedUnit, InferSchemaConfig> parser;
    private final Logger logger;
    private final String shell;
    private final TemplateEngine engine;
    private final OParserSetup setup;

    static {
        new InferSchemaCmd$();
    }

    @Override
    public final Try<JobResult> run(Seq<String> args, SchemaHandler schemaHandler, Settings settings) {
        return Cmd.run$(this, args, schemaHandler, settings);
    }

    @Override
    public IngestionWorkflow workflow(SchemaHandler schemaHandler, Settings settings) {
        return Cmd.workflow$(this, schemaHandler, settings);
    }

    @Override
    public String usage() {
        return CliConfig.usage$(this);
    }

    @Override
    public String markdown(int pageIndex) {
        return CliConfig.markdown$(this, pageIndex);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public String shell() {
        return this.shell;
    }

    @Override
    public void ai$starlake$job$Cmd$_setter_$shell_$eq(String x$1) {
        this.shell = x$1;
    }

    @Override
    public TemplateEngine engine() {
        return this.engine;
    }

    @Override
    public OParserSetup setup() {
        return this.setup;
    }

    @Override
    public void ai$starlake$utils$CliConfig$_setter_$engine_$eq(TemplateEngine x$1) {
        this.engine = x$1;
    }

    @Override
    public void ai$starlake$utils$CliConfig$_setter_$setup_$eq(OParserSetup x$1) {
        this.setup = x$1;
    }

    @Override
    public String command() {
        return this.command;
    }

    @Override
    public OParser<BoxedUnit, InferSchemaConfig> parser() {
        return this.parser;
    }

    @Override
    public Option<InferSchemaConfig> parse(Seq<String> args) {
        return OParser$.MODULE$.parse(this.parser(), args, (Object)new InferSchemaConfig(InferSchemaConfig$.MODULE$.apply$default$1(), InferSchemaConfig$.MODULE$.apply$default$2(), InferSchemaConfig$.MODULE$.apply$default$3(), InferSchemaConfig$.MODULE$.apply$default$4(), InferSchemaConfig$.MODULE$.apply$default$5(), InferSchemaConfig$.MODULE$.apply$default$6(), InferSchemaConfig$.MODULE$.apply$default$7(), InferSchemaConfig$.MODULE$.apply$default$8()), this.setup());
    }

    @Override
    public Try<JobResult> run(InferSchemaConfig config, SchemaHandler schemaHandler, Settings settings) {
        File inputFile = File$.MODULE$.apply(config.inputPath(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Object inputPaths = inputFile.isDirectory(inputFile.isDirectory$default$1()) ? (List)inputFile.list().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.pathAsString()).toList().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)InferSchemaCmd$.$anonfun$run$2(x$3))) : new .colon.colon((Object)config.inputPath(), (List)Nil$.MODULE$);
        List results = (List)inputPaths.map((Function1 & Serializable & scala.Serializable)inputPath -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Inferring schema for {}", new Object[]{inputPath});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String x$1 = inputPath;
            String x$2 = config.copy$default$1();
            String x$3 = config.copy$default$2();
            Option<String> x$4 = config.copy$default$4();
            Option<Format> x$5 = config.copy$default$5();
            Option<WriteMode> x$6 = config.copy$default$6();
            Option<String> x$7 = config.copy$default$7();
            boolean x$8 = config.copy$default$8();
            Try<Path> try_ = MODULE$.workflow(schemaHandler, settings).inferSchema(config.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8));
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit2;
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Successfully inferred schema for {}", new Object[]{inputPath});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return new Success((Object)JobResult$.MODULE$.empty());
            }
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit3;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error(new StringBuilder(27).append("Failed to infer schema for ").append((String)inputPath).toString(), exception);
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                return new Failure(exception);
            }
            throw new MatchError(try_);
        }, List$.MODULE$.canBuildFrom());
        List failures = (List)((List)results.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isFailure()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                return exception.getMessage();
            }
            throw new IllegalStateException("This should never happen");
        }, List$.MODULE$.canBuildFrom());
        if (failures.isEmpty()) {
            return new Success((Object)JobResult$.MODULE$.empty());
        }
        return new Failure((Throwable)new Exception(failures.mkString("\n")));
    }

    public static final /* synthetic */ boolean $anonfun$run$2(String x$3) {
        return !x$3.startsWith(".");
    }

    private InferSchemaCmd$() {
        MODULE$ = this;
        CliConfig.$init$(this);
        Cmd.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        this.command = "infer-schema";
        OParserBuilder builder = OParser$.MODULE$.builder();
        this.parser = OParser$.MODULE$.sequence(builder.programName(new StringBuilder(1).append(this.shell()).append(" ").append(this.command()).toString()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.shell(), this.command(), "[options]"})), builder.note(""), builder.opt("domain", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8())).text("Domain Name"), builder.opt("table", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            String x$1 = x;
            String x$2 = c.copy$default$1();
            String x$3 = c.copy$default$3();
            Option<String> x$4 = c.copy$default$4();
            Option<Format> x$5 = c.copy$default$5();
            Option<WriteMode> x$6 = c.copy$default$6();
            Option<String> x$7 = c.copy$default$7();
            boolean x$8 = c.copy$default$8();
            return c.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
        }).text("Table Name"), builder.opt("input", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            String x$9 = x;
            String x$10 = c.copy$default$1();
            String x$11 = c.copy$default$2();
            Option<String> x$12 = c.copy$default$4();
            Option<Format> x$13 = c.copy$default$5();
            Option<WriteMode> x$14 = c.copy$default$6();
            Option<String> x$15 = c.copy$default$7();
            boolean x$16 = c.copy$default$8();
            return c.copy(x$10, x$11, x$9, x$12, x$13, x$14, x$15, x$16);
        }).required().text("Dataset Input Path"), builder.opt("outputDir", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            Some x$17 = new Some(x);
            String x$18 = c.copy$default$1();
            String x$19 = c.copy$default$2();
            String x$20 = c.copy$default$3();
            Option<Format> x$21 = c.copy$default$5();
            Option<WriteMode> x$22 = c.copy$default$6();
            Option<String> x$23 = c.copy$default$7();
            boolean x$24 = c.copy$default$8();
            return c.copy(x$18, x$19, x$20, (Option<String>)x$17, x$21, x$22, x$23, x$24);
        }).optional().text("Domain YAML Output Path"), builder.opt("write", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            Some x$25 = new Some((Object)WriteMode$.MODULE$.fromString((String)x));
            String x$26 = c.copy$default$1();
            String x$27 = c.copy$default$2();
            String x$28 = c.copy$default$3();
            Option<String> x$29 = c.copy$default$4();
            Option<Format> x$30 = c.copy$default$5();
            Option<String> x$31 = c.copy$default$7();
            boolean x$32 = c.copy$default$8();
            return c.copy(x$26, x$27, x$28, x$29, x$30, (Option<WriteMode>)x$25, x$31, x$32);
        }).text(new StringBuilder(7).append("One of ").append(WriteMode$.MODULE$.writes()).toString()).optional(), builder.opt("format", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            Some x$33 = new Some((Object)Format$.MODULE$.fromString((String)x));
            String x$34 = c.copy$default$1();
            String x$35 = c.copy$default$2();
            String x$36 = c.copy$default$3();
            Option<String> x$37 = c.copy$default$4();
            Option<WriteMode> x$38 = c.copy$default$6();
            Option<String> x$39 = c.copy$default$7();
            boolean x$40 = c.copy$default$8();
            return c.copy(x$34, x$35, x$36, x$37, (Option<Format>)x$33, x$38, x$39, x$40);
        }).optional().text("Force input file format"), builder.opt("rowTag", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            Some x$41 = new Some(x);
            String x$42 = c.copy$default$1();
            String x$43 = c.copy$default$2();
            String x$44 = c.copy$default$3();
            Option<String> x$45 = c.copy$default$4();
            Option<Format> x$46 = c.copy$default$5();
            Option<WriteMode> x$47 = c.copy$default$6();
            boolean x$48 = c.copy$default$8();
            return c.copy(x$42, x$43, x$44, x$45, x$46, x$47, (Option<String>)x$41, x$48);
        }).optional().text("row tag to use if detected format is XML"), builder.opt("clean", Read$.MODULE$.unitRead()).action((Function2 & Serializable & scala.Serializable)(x$1, c) -> {
            boolean x$49 = true;
            String x$50 = c.copy$default$1();
            String x$51 = c.copy$default$2();
            String x$52 = c.copy$default$3();
            Option<String> x$53 = c.copy$default$4();
            Option<Format> x$54 = c.copy$default$5();
            Option<WriteMode> x$55 = c.copy$default$6();
            Option<String> x$56 = c.copy$default$7();
            return c.copy(x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$49);
        }).optional().text("Delete previous YML before writing")}));
    }
}

