/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.infer;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.config.SparkEnv$;
import ai.starlake.job.infer.InferSchemaJob$;
import ai.starlake.schema.handlers.InferSchemaHandler$;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AllSinks;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Format$;
import ai.starlake.schema.model.Format$DSV$;
import ai.starlake.schema.model.Format$JSON$;
import ai.starlake.schema.model.Format$JSON_FLAT$;
import ai.starlake.schema.model.Format$POSITION$;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.Metadata$;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.TransformInput;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.schema.model.WriteStrategy$;
import ai.starlake.schema.model.WriteStrategyType;
import ai.starlake.schema.model.WriteStrategyType$;
import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.json.JSONArray;
import org.json.JSONObject;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u000b\u0017\u0001}A\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006Y!\r\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006{\u0001!\tA\u0010\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019y\u0005\u0001)A\u0005\u0019\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006B\u00020\u0001A\u0003%!\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0003o\u0001\u0011\u0005q\u000eC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\u0002\u0001!I!a\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!I\u0011Q\r\u0001\u0012\u0002\u0013%\u0011q\r\u0005\n\u0003{\u0002\u0011\u0013!C\u0005\u0003\u007fBaa\u0006\u0001\u0005\u0002\u0005\r\u0005\"CAg\u0001E\u0005I\u0011AA4\u000f\u001d\tyM\u0006E\u0001\u0003#4a!\u0006\f\t\u0002\u0005M\u0007BB\u001c\u0013\t\u0003\t)\u000eC\u0004\u0002XJ!\t!!7\u0003\u001d%sg-\u001a:TG\",W.\u0019&pE*\u0011q\u0003G\u0001\u0006S:4WM\u001d\u0006\u00033i\t1A[8c\u0015\tYB$\u0001\u0005ti\u0006\u0014H.Y6f\u0015\u0005i\u0012AA1j\u0007\u0001\u00192\u0001\u0001\u0011'!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011qEL\u0007\u0002Q)\u0011\u0011FK\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003W1\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002[\u0005\u00191m\\7\n\u0005=B#!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0005tKR$\u0018N\\4t!\t\u0011T'D\u00014\u0015\t!$$\u0001\u0004d_:4\u0017nZ\u0005\u0003mM\u0012\u0001bU3ui&twm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\"\"A\u000f\u001f\u0011\u0005m\u0002Q\"\u0001\f\t\u000bA\u0012\u00019A\u0019\u0002\t9\fW.Z\u000b\u0002\u007fA\u0011\u0001i\u0012\b\u0003\u0003\u0016\u0003\"A\u0011\u0012\u000e\u0003\rS!\u0001\u0012\u0010\u0002\rq\u0012xn\u001c;?\u0013\t1%%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$#\u0003!\u0019\b/\u0019:l\u000b:4X#\u0001'\u0011\u0005Ij\u0015B\u0001(4\u0005!\u0019\u0006/\u0019:l\u000b:4\u0018!C:qCJ\\WI\u001c<!\u0003\u001d\u0019Xm]:j_:,\u0012A\u0015\t\u0003'rk\u0011\u0001\u0016\u0006\u0003+Z\u000b1a]9m\u0015\t9\u0006,A\u0003ta\u0006\u00148N\u0003\u0002Z5\u00061\u0011\r]1dQ\u0016T\u0011aW\u0001\u0004_J<\u0017BA/U\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003!\u0019Xm]:j_:\u0004\u0013\u0001\u0003:fC\u00124\u0015\u000e\\3\u0015\u0005\u0005$\u0007cA*c\u007f%\u00111\r\u0016\u0002\b\t\u0006$\u0018m]3u\u0011\u0015)\u0007\u00021\u0001g\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017A\u00014t\u0015\tY\u0007,\u0001\u0004iC\u0012|w\u000e]\u0005\u0003[\"\u0014A\u0001U1uQ\u0006iq-\u001a;G_Jl\u0017\r\u001e$jY\u0016$2a\u00109s\u0011\u0015\t\u0018\u00021\u0001@\u0003%Ig\u000e];u!\u0006$\b\u000eC\u0003t\u0013\u0001\u0007A/A\u0003mS:,7\u000fE\u0002vu~r!A\u001e=\u000f\u0005\t;\u0018\"A\u0012\n\u0005e\u0014\u0013a\u00029bG.\fw-Z\u0005\u0003wr\u0014A\u0001T5ti*\u0011\u0011PI\u0001\rO\u0016$8+\u001a9be\u0006$xN\u001d\u000b\u0003\u007f}DQa\u001d\u0006A\u0002Q\f\u0001cZ3u'\u000eDW-\\1QCR$XM\u001d8\u0015\u0007}\n)\u0001C\u0003f\u0017\u0001\u0007a-A\rde\u0016\fG/\u001a#bi\u00064%/Y7f/&$\bNR8s[\u0006$H\u0003EA\u0006\u0003g\t)$!\u000f\u0002>\u0005\u0005\u0013QIA(!\u001d\t\u0013QBA\t\u0003[I1!a\u0004#\u0005\u0019!V\u000f\u001d7feA!\u00111CA\u0014\u001d\u0011\t)\"!\n\u000f\t\u0005]\u00111\u0005\b\u0005\u00033\t\tC\u0004\u0003\u0002\u001c\u0005}ab\u0001\"\u0002\u001e%\t1,\u0003\u0002Z5&\u0011q\u000bW\u0005\u0003+ZK!!\u001f+\n\t\u0005%\u00121\u0006\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!!\u001f+\u0011\t\u0005\nycP\u0005\u0004\u0003c\u0011#AB(qi&|g\u000eC\u0003t\u0019\u0001\u0007A\u000f\u0003\u0004\u000281\u0001\raP\u0001\tI\u0006$\u0018\rU1uQ\"1\u00111\b\u0007A\u0002}\nqaY8oi\u0016tG\u000f\u0003\u0004\u0002@1\u0001\raP\u0001\ni\u0006\u0014G.\u001a(b[\u0016Dq!a\u0011\r\u0001\u0004\ti#\u0001\u0004s_^$\u0016m\u001a\u0005\n\u0003\u000fb\u0001\u0013!a\u0001\u0003\u0013\n1\"\u001b8gKJ\u001c6\r[3nCB\u0019\u0011%a\u0013\n\u0007\u00055#EA\u0004C_>dW-\u00198\t\u0013\u0005EC\u0002%AA\u0002\u0005M\u0013a\u00034pe\u000e,gi\u001c:nCR\u0004R!IA\u0018\u0003+\u0002B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&A\u0003n_\u0012,GNC\u0002\u0002`i\taa]2iK6\f\u0017\u0002BA2\u00033\u0012aAR8s[\u0006$\u0018aI2sK\u0006$X\rR1uC\u001a\u0013\u0018-\\3XSRDgi\u001c:nCR$C-\u001a4bk2$HEN\u000b\u0003\u0003SRC!!\u0013\u0002l-\u0012\u0011Q\u000e\t\u0005\u0003_\nI(\u0004\u0002\u0002r)!\u00111OA;\u0003%)hn\u00195fG.,GMC\u0002\u0002x\t\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY(!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0012de\u0016\fG/\u001a#bi\u00064%/Y7f/&$\bNR8s[\u0006$H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\u0005\u0005%\u0006BA*\u0003W\"\u0002$!\"\u0002$\u0006\u001d\u0016\u0011VAW\u0003c\u000b\u0019,a.\u0002:\u0006\r\u0017QYAe)\u0011\t9)a%\u0011\u000b\u0005%\u0015q\u00124\u000e\u0005\u0005-%bAAGE\u0005!Q\u000f^5m\u0013\u0011\t\t*a#\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002\u0016>\u0001\u001d!a&\u0002\u001dM$xN]1hK\"\u000bg\u000e\u001a7feB!\u0011\u0011TAP\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006u\u0013\u0001\u00035b]\u0012dWM]:\n\t\u0005\u0005\u00161\u0014\u0002\u000f'R|'/Y4f\u0011\u0006tG\r\\3s\u0011\u0019\t)k\u0004a\u0001\u007f\u0005QAm\\7bS:t\u0015-\\3\t\r\u0005}r\u00021\u0001@\u0011\u001d\tYk\u0004a\u0001\u0003[\tq\u0001]1ui\u0016\u0014h\u000eC\u0004\u00020>\u0001\r!!\f\u0002\u000f\r|W.\\3oi\")\u0011o\u0004a\u0001\u007f!1\u0011QW\bA\u0002}\nqa]1wK\u0012K'\u000fC\u0004\u0002R=\u0001\r!a\u0015\t\u000f\u0005mv\u00021\u0001\u0002>\u0006IqO]5uK6{G-\u001a\t\u0005\u0003/\ny,\u0003\u0003\u0002B\u0006e#!C,sSR,Wj\u001c3f\u0011\u001d\t\u0019e\u0004a\u0001\u0003[Aq!a2\u0010\u0001\u0004\tI%A\u0003dY\u0016\fg\u000eC\u0005\u0002L>\u0001\n\u00111\u0001\u0002J\u00059a/\u0019:jC:$\u0018\u0001E5oM\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00192\u00039IeNZ3s'\u000eDW-\\1K_\n\u0004\"a\u000f\n\u0014\u0005I\u0001CCAAi\u0003\u0011i\u0017-\u001b8\u0015\t\u0005m\u0017\u0011\u001d\t\u0004C\u0005u\u0017bAApE\t!QK\\5u\u0011\u001d\t\u0019\u000f\u0006a\u0001\u0003K\fA!\u0019:hgB!\u0011%a:@\u0013\r\tIO\t\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class InferSchemaJob
implements StrictLogging {
    private final Settings settings;
    private final SparkEnv sparkEnv;
    private final SparkSession session;
    private final Logger logger;

    public static void main(String[] stringArray) {
        InferSchemaJob$.MODULE$.main(stringArray);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String name() {
        return "InferSchema";
    }

    private SparkEnv sparkEnv() {
        return this.sparkEnv;
    }

    private SparkSession session() {
        return this.session;
    }

    public Dataset<String> readFile(Path path) {
        return this.session().read().textFile(path.toString());
    }

    public String getFormatFile(String inputPath, List<String> lines) {
        File file = File$.MODULE$.apply(inputPath, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        String firstLine = (String)lines.head();
        String lastLine = (String)lines.last();
        boolean bl = false;
        String string = null;
        String string2 = ((String)file.extension(false, file.extension$default$2(), file.extension$default$3()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toLowerCase();
        if ("parquet".equals(string2)) {
            return "PARQUET";
        }
        if ("xml".equals(string2)) {
            return "XML";
        }
        if ("json".equals(string2)) {
            bl = true;
            string = string2;
            if (firstLine.startsWith("[")) {
                return "JSON_ARRAY";
            }
        }
        if (bl && firstLine.startsWith("{")) {
            return "JSON";
        }
        if ("csv".equals(string2) ? true : ("dsv".equals(string2) ? true : ("tsv".equals(string2) ? true : "psv".equals(string2)))) {
            return "DSV";
        }
        Regex jsonRegexStart = new StringOps(Predef$.MODULE$.augmentString("\\{.*")).r();
        Regex jsonArrayRegexStart = new StringOps(Predef$.MODULE$.augmentString("\\[.*")).r();
        Regex jsonRegexEnd = new StringOps(Predef$.MODULE$.augmentString(".*\\}")).r();
        Regex jsonArrayRegexEnd = new StringOps(Predef$.MODULE$.augmentString(".*\\]")).r();
        Regex xmlRegexStart = new StringOps(Predef$.MODULE$.augmentString("<.*")).r();
        Regex xmlRegexEnd = new StringOps(Predef$.MODULE$.augmentString(".*>")).r();
        Tuple2 tuple2 = new Tuple2((Object)firstLine, (Object)lastLine);
        if (tuple2 != null) {
            Option option;
            String string3 = (String)tuple2._1();
            String string4 = (String)tuple2._2();
            Option option2 = jsonRegexStart.unapplySeq((CharSequence)string3);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0 && !(option = jsonRegexEnd.unapplySeq((CharSequence)string4)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                return "JSON";
            }
        }
        if (tuple2 != null) {
            Option option;
            String string5 = (String)tuple2._1();
            String string6 = (String)tuple2._2();
            Option option3 = jsonArrayRegexStart.unapplySeq((CharSequence)string5);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0 && !(option = jsonArrayRegexEnd.unapplySeq((CharSequence)string6)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                return "JSON_ARRAY";
            }
        }
        if (tuple2 != null) {
            Option option;
            String string7 = (String)tuple2._1();
            String string8 = (String)tuple2._2();
            Option option4 = xmlRegexStart.unapplySeq((CharSequence)string7);
            if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(0) == 0 && !(option = xmlRegexEnd.unapplySeq((CharSequence)string8)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                return "XML";
            }
        }
        return "DSV";
    }

    public String getSeparator(List<String> lines) {
        List linesWithoutHeader = lines.drop(1);
        String firstLine = (String)linesWithoutHeader.head();
        Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(firstLine.replaceAll("[A-Za-z0-9 \"'()@?!\u00e9\u00e8\u00ee\u00e0\u00c0\u00c9\u00c8\u00e7+\\-_]", "").toCharArray())).map((Function1 & Serializable & scala.Serializable)x$1 -> InferSchemaJob.$anonfun$getSeparator$1(BoxesRunTime.unboxToChar((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToCharacter((char)x$2._1$mcC$sp())).mapValues((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)InferSchemaJob.$anonfun$getSeparator$3(x$3))).toList().maxBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)InferSchemaJob.$anonfun$getSeparator$4(x0$1)), (Ordering)Ordering.Int$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        char separator = tuple2._1$mcC$sp();
        int count = tuple2._2$mcI$sp();
        Tuple2.mcCI.sp sp2 = new Tuple2.mcCI.sp(separator, count);
        char separator2 = sp2._1$mcC$sp();
        int count2 = sp2._2$mcI$sp();
        return Character.toString(separator2);
    }

    private String getSchemaPattern(Path path) {
        String prefixWithoutNonAlpha;
        String filename = path.getName();
        String[] parts = filename.split("\\.");
        if (parts.length < 2) {
            return filename;
        }
        String extension = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last();
        String prefix = filename.replace(new StringBuilder(1).append(".").append(extension).toString(), "");
        int indexOfNonAlpha = new StringOps(Predef$.MODULE$.augmentString(prefix)).lastIndexWhere((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)InferSchemaJob.$anonfun$getSchemaPattern$1(BoxesRunTime.unboxToChar((Object)x$5))));
        String string = prefixWithoutNonAlpha = indexOfNonAlpha != -1 && indexOfNonAlpha < prefix.length() && RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(prefix), indexOfNonAlpha + 1))) ? prefix.substring(0, indexOfNonAlpha) : prefix;
        if (prefixWithoutNonAlpha.isEmpty()) {
            return filename;
        }
        return new StringBuilder(3).append(prefixWithoutNonAlpha).append(".*.").append(extension).toString();
    }

    private Tuple2<Dataset<Row>, Option<String>> createDataFrameWithFormat(List<String> lines, String dataPath, String content, String tableName, Option<String> rowTag, boolean inferSchema, Option<Format> forceFormat) {
        String formatFile = (String)forceFormat.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getFormatFile(dataPath, lines));
        String string = formatFile;
        if ("PARQUET".equals(string)) {
            Dataset df = this.session().read().parquet(dataPath);
            return new Tuple2((Object)df, (Object)None$.MODULE$);
        }
        if ("JSON_ARRAY".equals(string)) {
            String content2 = lines.mkString("\n");
            ListBuffer jsons = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            JSONArray jsonarray = new JSONArray(content2);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), jsonarray.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                JSONObject jsonobject = jsonarray.getJSONObject(i);
                jsons.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{jsonobject.toString()}));
            });
            String x$1 = File$.MODULE$.newTemporaryFile$default$1();
            String x$2 = File$.MODULE$.newTemporaryFile$default$2();
            Option x$3 = File$.MODULE$.newTemporaryFile$default$3();
            Seq x$4 = File$.MODULE$.newTemporaryFile$default$4(x$1, x$2, x$3);
            File tmpFile = File$.MODULE$.newTemporaryFile(x$1, x$2, x$3, x$4);
            String x$5 = jsons.mkString("\n");
            Seq x$62 = tmpFile.write$default$2(x$5);
            Charset x$72 = tmpFile.write$default$3(x$5);
            tmpFile.write(x$5, x$62, x$72);
            tmpFile.deleteOnExit(tmpFile.deleteOnExit$default$1(), tmpFile.deleteOnExit$default$2());
            Dataset df = this.session().read().json(tmpFile.pathAsString());
            return new Tuple2((Object)df, (Object)None$.MODULE$);
        }
        if ("JSON".equals(string)) {
            boolean isJsonL = ((LinearSeqOptimized)((TraversableLike)lines.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.trim(), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)InferSchemaJob.$anonfun$createDataFrameWithFormat$5(x$8)))).forall((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)InferSchemaJob.$anonfun$createDataFrameWithFormat$6(line)));
            Dataset df = this.session().read().option("multiLine", !isJsonL).json(dataPath);
            return new Tuple2((Object)df, (Object)None$.MODULE$);
        }
        if ("XML".equals(string)) {
            String tag = (String)rowTag.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                String rowTag;
                String result;
                String contentWithoutXmlHeaderTag = content.replace("<?", "");
                int secondXmlTagStart = contentWithoutXmlHeaderTag.indexOf("<", contentWithoutXmlHeaderTag.indexOf("<") + 1) + 1;
                int closingTag = contentWithoutXmlHeaderTag.indexOf(">", secondXmlTagStart);
                String string = result = secondXmlTagStart == -1 || closingTag == -1 ? tableName : (rowTag = contentWithoutXmlHeaderTag.substring(secondXmlTagStart, closingTag));
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Using rowTag: {}", new Object[]{result});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return result;
            });
            Dataset df = this.session().read().format("com.databricks.spark.xml").option("rowTag", tag).option("inferSchema", inferSchema).load(dataPath);
            return new Tuple2((Object)df, (Object)new Some((Object)tag));
        }
        if ("DSV".equals(string)) {
            Dataset df = this.session().read().format("com.databricks.spark.csv").option("header", true).option("inferSchema", inferSchema).option("delimiter", this.getSeparator(lines)).option("parserLib", "UNIVOCITY").load(dataPath);
            return new Tuple2((Object)df, (Object)None$.MODULE$);
        }
        throw new MatchError((Object)string);
    }

    private boolean createDataFrameWithFormat$default$6() {
        return true;
    }

    private Option<Format> createDataFrameWithFormat$default$7() {
        return None$.MODULE$;
    }

    public Try<Path> infer(String domainName, String tableName, Option<String> pattern, Option<String> comment, String inputPath, String saveDir, Option<Format> forceFormat, WriteMode writeMode, Option<String> rowTag, boolean clean, boolean variant, StorageHandler storageHandler) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Schema schema;
            Some some;
            Format format2;
            Path path = new Path(inputPath);
            .colon.colon content = forceFormat.exists((Function1 & Serializable & scala.Serializable)format -> BoxesRunTime.boxToBoolean((boolean)Format$.MODULE$.isBinary(format))) ? new .colon.colon((Object)"", (List)Nil$.MODULE$) : (List)storageHandler.readAndExecute(path, storageHandler.readAndExecute$default$2(), (Function1 & Serializable & scala.Serializable)isr -> {
                BufferedReader bufferedReader = new BufferedReader((Reader)isr);
                return package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> bufferedReader.readLine()).takeWhile((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)InferSchemaJob.$anonfun$infer$5(x$9))).toList();
            });
            List lines = (List)((TraversableLike)content.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.trim(), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)InferSchemaJob.$anonfun$infer$7(x$11)));
            Option option = forceFormat;
            if (option instanceof Some && ((Object)Format$POSITION$.MODULE$).equals(format2 = (Format)(some = (Some)option).value())) {
                IntRef lastIndex = IntRef.create((int)-1);
                List attributes = (List)((List)lines.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        int endPosition;
                        String line = (String)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        int fieldIndex = line.indexOf(":");
                        if (fieldIndex == -1) {
                            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(258).append("Positional format schema inference requires a colon (:) to separate the field name from its value in line ").append(index).append(".\n                   |Example\n                   |-------\n                   |order_id:00001\n                   |customer_id:010203\n                   |").toString())).stripMargin());
                        }
                        String fieldName = line.substring(0, fieldIndex).trim();
                        String field = line.substring(fieldIndex + 1);
                        int startPosition = lastIndex$1.elem + 1;
                        lastIndex$1.elem = endPosition = startPosition + field.length();
                        String x$1 = fieldName;
                        Some x$2 = new Some((Object)new Position(startPosition, endPosition));
                        Option x$3 = Option$.MODULE$.apply((Object)field);
                        String x$4 = Attribute$.MODULE$.apply$default$2();
                        Option<Object> x$5 = Attribute$.MODULE$.apply$default$3();
                        Option<Object> x$6 = Attribute$.MODULE$.apply$default$4();
                        Option<TransformInput> x$7 = Attribute$.MODULE$.apply$default$5();
                        Option<String> x$8 = Attribute$.MODULE$.apply$default$6();
                        Option<String> x$9 = Attribute$.MODULE$.apply$default$7();
                        Option<MetricType> x$10 = Attribute$.MODULE$.apply$default$8();
                        List<Attribute> x$11 = Attribute$.MODULE$.apply$default$9();
                        Option<String> x$12 = Attribute$.MODULE$.apply$default$11();
                        Set<String> x$13 = Attribute$.MODULE$.apply$default$12();
                        Option<Trim> x$14 = Attribute$.MODULE$.apply$default$13();
                        Option<String> x$15 = Attribute$.MODULE$.apply$default$14();
                        Option<String> x$16 = Attribute$.MODULE$.apply$default$15();
                        Option<Object> x$17 = Attribute$.MODULE$.apply$default$16();
                        Option<String> x$18 = Attribute$.MODULE$.apply$default$17();
                        return new Attribute(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option<Position>)x$2, x$12, x$13, x$14, x$15, x$16, x$17, x$18, (Option<String>)x$3);
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
                Metadata metadata = InferSchemaHandler$.MODULE$.createMetaData(Format$POSITION$.MODULE$, InferSchemaHandler$.MODULE$.createMetaData$default$2(), InferSchemaHandler$.MODULE$.createMetaData$default$3(), InferSchemaHandler$.MODULE$.createMetaData$default$4(), InferSchemaHandler$.MODULE$.createMetaData$default$5());
                schema = InferSchemaHandler$.MODULE$.createSchema(tableName, Pattern.compile((String)pattern.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getSchemaPattern(path))), comment, (List<Attribute>)attributes, (Option<Metadata>)new Some((Object)metadata), (Option<String>)None$.MODULE$);
            } else {
                List list;
                Tuple2 tuple2;
                List x$19 = lines;
                String x$20 = inputPath;
                String x$21 = ((TraversableOnce)content.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.trim(), List$.MODULE$.canBuildFrom())).mkString("\n");
                String x$22 = tableName;
                Option x$23 = rowTag;
                Option x$24 = option;
                boolean x$25 = this.createDataFrameWithFormat$default$6();
                Tuple2<Dataset<Row>, Option<String>> tuple22 = this.createDataFrameWithFormat((List<String>)x$19, x$20, x$21, x$22, (Option<String>)x$23, x$25, (Option<Format>)x$24);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Dataset dataframeWithFormat = (Dataset)tuple22._1();
                Option xmlTag = (Option)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)dataframeWithFormat, (Object)xmlTag);
                Dataset dataframeWithFormat2 = (Dataset)tuple23._1();
                Option xmlTag2 = (Option)tuple23._2();
                Option option2 = option;
                if (None$.MODULE$.equals(option2)) {
                    String formatAsStr = this.getFormatFile(inputPath, (List<String>)lines);
                    String string = formatAsStr;
                    String string2 = "JSON_ARRAY";
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    tuple2 = new Tuple2((Object)Format$.MODULE$.fromString(formatAsStr), (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                } else if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Format f = (Format)some2.value();
                    tuple2 = new Tuple2((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    throw new MatchError((Object)option2);
                }
                Tuple2 tuple24 = tuple2;
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                Format format3 = (Format)tuple24._1();
                boolean array = tuple24._2$mcZ$sp();
                Tuple2 tuple25 = new Tuple2((Object)format3, (Object)BoxesRunTime.boxToBoolean((boolean)array));
                Format format4 = (Format)tuple25._1();
                boolean array2 = tuple25._2$mcZ$sp();
                Format format5 = format4;
                if (((Object)Format$DSV$.MODULE$).equals(format5)) {
                    Tuple2<Dataset<Row>, Option<String>> tuple26 = this.createDataFrameWithFormat((List<String>)lines, inputPath, content.mkString("\n"), tableName, rowTag, false, (Option<Format>)new Some((Object)format4));
                    if (tuple26 == null) {
                        throw new MatchError(tuple26);
                    }
                    Dataset rawDataframeWithFormat = (Dataset)tuple26._1();
                    Dataset rawDataframeWithFormat2 = rawDataframeWithFormat;
                    list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rawDataframeWithFormat2.collect())).toList();
                } else {
                    list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataframeWithFormat2.collect())).toList();
                }
                List dataLines = list;
                List<Attribute> attributes = InferSchemaHandler$.MODULE$.createAttributes((List<Row>)dataLines, dataframeWithFormat2.schema(), format4, InferSchemaHandler$.MODULE$.createAttributes$default$4());
                Format format6 = format4;
                Format preciseFormat = ((Object)Format$JSON$.MODULE$).equals(format6) ? (attributes.exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)InferSchemaJob.$anonfun$infer$11(x$15))) ? Format$JSON$.MODULE$ : Format$JSON_FLAT$.MODULE$) : format4;
                Option xmlOptions = xmlTag2.map((Function1 & Serializable & scala.Serializable)tag -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowTag"), tag)})));
                Format format7 = format4;
                Metadata metadata = InferSchemaHandler$.MODULE$.createMetaData(preciseFormat, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)array2)), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Option<String>)(((Object)Format$DSV$.MODULE$).equals(format7) ? new Some((Object)this.getSeparator((List<String>)lines)) : None$.MODULE$), (Option<Map<String, String>>)xmlOptions);
                WriteStrategy strategy = new WriteStrategy((Option<WriteStrategyType>)new Some((Object)WriteStrategyType$.MODULE$.fromWriteMode(writeMode)), WriteStrategy$.MODULE$.apply$default$2(), WriteStrategy$.MODULE$.apply$default$3(), WriteStrategy$.MODULE$.apply$default$4(), WriteStrategy$.MODULE$.apply$default$5(), WriteStrategy$.MODULE$.apply$default$6(), WriteStrategy$.MODULE$.apply$default$7(), WriteStrategy$.MODULE$.apply$default$8());
                Format format8 = metadata.resolveFormat();
                String sample = (((Object)Format$JSON$.MODULE$).equals(format8) ? true : ((Object)Format$JSON_FLAT$.MODULE$).equals(format8)) ? (Predef$.MODULE$.Boolean2boolean(metadata.resolveArray()) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataframeWithFormat2.toJSON().collect())).take(20))).mkString("[", metadata.resolveSeparator(), "]") : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataframeWithFormat2.toJSON().collect())).take(20))).mkString("\n")) : (((Object)Format$DSV$.MODULE$).equals(format8) ? dataLines.take(20).mkString("\n") : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataframeWithFormat2.toJSON().collect())).take(20))).mkString("\n"));
                Some x$26 = new Some((Object)strategy);
                Option<Format> x$27 = metadata.copy$default$1();
                Option<String> x$28 = metadata.copy$default$2();
                Option<Object> x$29 = metadata.copy$default$3();
                Option<Object> x$30 = metadata.copy$default$4();
                Option<Object> x$31 = metadata.copy$default$5();
                Option<String> x$32 = metadata.copy$default$6();
                Option<String> x$33 = metadata.copy$default$7();
                Option<String> x$34 = metadata.copy$default$8();
                Option<AllSinks> x$35 = metadata.copy$default$9();
                Option<String> x$36 = metadata.copy$default$10();
                Option<String> x$37 = metadata.copy$default$11();
                Option<String> x$38 = metadata.copy$default$12();
                Option<Map<String, String>> x$39 = metadata.copy$default$13();
                Option<String> x$40 = metadata.copy$default$14();
                Option<Object> x$41 = metadata.copy$default$15();
                Option<String> x$42 = metadata.copy$default$16();
                Option<Freshness> x$43 = metadata.copy$default$17();
                Option<String> x$44 = metadata.copy$default$18();
                boolean x$45 = metadata.copy$default$19();
                Option<String> x$46 = metadata.copy$default$20();
                schema = InferSchemaHandler$.MODULE$.createSchema(tableName, Pattern.compile((String)pattern.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getSchemaPattern(path))), comment, attributes, (Option<Metadata>)new Some((Object)metadata.copy(x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, (Option<WriteStrategy>)x$26)), (Option<String>)new Some((Object)sample));
            }
            Schema schema2 = schema;
            Some x$47 = new Some((Object)new StringBuilder(18).append("{{incoming_path}}/").append(domainName).toString());
            Option<Format> x$48 = Metadata$.MODULE$.apply$default$1();
            Option<String> x$49 = Metadata$.MODULE$.apply$default$2();
            Option<Object> x$50 = Metadata$.MODULE$.apply$default$3();
            Option<Object> x$51 = Metadata$.MODULE$.apply$default$4();
            Option<Object> x$52 = Metadata$.MODULE$.apply$default$5();
            Option<String> x$53 = Metadata$.MODULE$.apply$default$6();
            Option<String> x$54 = Metadata$.MODULE$.apply$default$7();
            Option<String> x$55 = Metadata$.MODULE$.apply$default$8();
            Option<AllSinks> x$56 = Metadata$.MODULE$.apply$default$9();
            Option<String> x$57 = Metadata$.MODULE$.apply$default$10();
            Option<String> x$58 = Metadata$.MODULE$.apply$default$12();
            Option<Map<String, String>> x$59 = Metadata$.MODULE$.apply$default$13();
            Option<String> x$60 = Metadata$.MODULE$.apply$default$14();
            Option<Object> x$61 = Metadata$.MODULE$.apply$default$15();
            Option<String> x$62 = Metadata$.MODULE$.apply$default$16();
            Option<Freshness> x$63 = Metadata$.MODULE$.apply$default$17();
            Option<String> x$64 = Metadata$.MODULE$.apply$default$18();
            boolean x$65 = Metadata$.MODULE$.apply$default$19();
            Option<String> x$66 = Metadata$.MODULE$.apply$default$20();
            Option<WriteStrategy> x$67 = Metadata$.MODULE$.apply$default$21();
            Domain domain = InferSchemaHandler$.MODULE$.createDomain(domainName, (Option<Metadata>)new Some((Object)new Metadata(x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, (Option<String>)x$47, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67)), (List<Schema>)new .colon.colon((Object)schema2, (List)Nil$.MODULE$));
            return InferSchemaHandler$.MODULE$.generateYaml(domain, saveDir, clean, $this.settings);
        }).flatten(Predef$.MODULE$.$conforms());
    }

    public boolean infer$default$11() {
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getSeparator$1(char x$1) {
        return new Tuple2.mcCI.sp(x$1, 1);
    }

    public static final /* synthetic */ int $anonfun$getSeparator$3(Tuple2[] x$3) {
        return x$3.length;
    }

    public static final /* synthetic */ int $anonfun$getSeparator$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int count = tuple2._2$mcI$sp();
            return count;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getSchemaPattern$1(char x$5) {
        return !RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(x$5));
    }

    public static final /* synthetic */ boolean $anonfun$createDataFrameWithFormat$5(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$createDataFrameWithFormat$6(String line) {
        return line.length() >= 2 && line.startsWith("{") && line.endsWith("}");
    }

    public static final /* synthetic */ boolean $anonfun$infer$5(String x$9) {
        return x$9 != null;
    }

    public static final /* synthetic */ boolean $anonfun$infer$7(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$infer$11(Attribute x$15) {
        return x$15.attributes().nonEmpty();
    }

    public InferSchemaJob(Settings settings) {
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.sparkEnv = new SparkEnv(this.name(), SparkEnv$.MODULE$.$lessinit$greater$default$2(), settings);
        this.session = this.sparkEnv().session();
    }
}

