/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.ingest;

import ai.starlake.config.Settings;
import ai.starlake.job.ingest.AuditLog;
import ai.starlake.job.transform.AutoTask;
import ai.starlake.job.transform.AutoTask$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AllSinks;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.AttributeDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.AutoTaskDesc$;
import ai.starlake.schema.model.ConnectionType;
import ai.starlake.schema.model.ConnectionType$GCPLOG$;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.Engine$JDBC$;
import ai.starlake.schema.model.ExpectationItem;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Schema$;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.utils.GcpUtils$;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple15;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

public final class AuditLog$
implements StrictLogging,
scala.Serializable {
    public static AuditLog$ MODULE$;
    private final List<Tuple3<String, StandardSQLTypeName, AtomicType>> auditCols;
    private final Schema starlakeSchema;
    private final Logger logger;

    static {
        new AuditLog$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<Tuple3<String, StandardSQLTypeName, AtomicType>> auditCols() {
        return this.auditCols;
    }

    public Schema starlakeSchema() {
        return this.starlakeSchema;
    }

    public Try<JobResult> sink(AuditLog log, Settings settings, StorageHandler storageHandler, SchemaHandler schemaHandler) {
        if (settings.appConfig().audit().isActive() && !log.test()) {
            Engine engine;
            Option<String> x$25;
            String x$24;
            Option<String> x$23;
            Option<String> x$22;
            Option<WriteStrategy> x$21;
            Set<String> x$20;
            Option<Path> x$19;
            List<AttributeDesc> x$18;
            Option<Freshness> x$17;
            Option<String> x$16;
            List<AccessControlEntry> x$15;
            List<ExpectationItem> x$14;
            Sink auditSink = settings.appConfig().audit().getSink(settings);
            ConnectionType connectionType = auditSink.getConnectionType(settings);
            if (((Object)ConnectionType$GCPLOG$.MODULE$).equals(connectionType)) {
                String logName = settings.appConfig().audit().getDomain(settings);
                GcpUtils$.MODULE$.sinkToGcpCloudLogging(log.asMap(), "audit", logName, settings);
                return new Success((Object)new JobResult(){

                    public List<Map<String, Object>> asMap() {
                        return JobResult.asMap$(this);
                    }

                    public String prettyPrint(String format, boolean dryRun) {
                        return JobResult.prettyPrint$(this, format, dryRun);
                    }

                    public boolean prettyPrint$default$2() {
                        return JobResult.prettyPrint$default$2$(this);
                    }

                    public String prettyPrint(String format, List<String> headers, List<List<String>> values) {
                        return JobResult.prettyPrint$(this, format, headers, values);
                    }
                    {
                        JobResult.$init$(this);
                    }
                });
            }
            String selectSql = log.asSelect(auditSink.getConnection(settings).getJdbcEngineName(), settings);
            String x$1 = new StringBuilder(6).append("audit-").append(log.jobid()).toString();
            Some x$2 = new Some((Object)selectSql);
            Option<String> x$3 = settings.appConfig().audit().getDatabase(settings);
            String x$4 = settings.appConfig().audit().getDomain(settings);
            String x$5 = "audit";
            Nil$ x$6 = Nil$.MODULE$;
            Nil$ x$7 = Nil$.MODULE$;
            Option<String> x$8 = settings.appConfig().audit().sink().connectionRef();
            Some x$9 = new Some((Object)settings.appConfig().audit().sink());
            Some x$10 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Some x$11 = new Some((Object)"audit");
            Some x$12 = new Some((Object)BoxesRunTime.boxToLong((long)settings.appConfig().shortJobTimeoutMs()));
            List<RowLevelSecurity> x$13 = AutoTaskDesc$.MODULE$.apply$default$9();
            AutoTaskDesc auditTaskDesc = new AutoTaskDesc(x$1, (Option<String>)x$2, x$3, x$4, x$5, (List<String>)x$6, (List<String>)x$7, (Option<AllSinks>)x$9, x$13, x$14 = AutoTaskDesc$.MODULE$.apply$default$10(), x$15 = AutoTaskDesc$.MODULE$.apply$default$11(), x$16 = AutoTaskDesc$.MODULE$.apply$default$12(), x$17 = AutoTaskDesc$.MODULE$.apply$default$13(), x$18 = AutoTaskDesc$.MODULE$.apply$default$14(), x$19 = AutoTaskDesc$.MODULE$.apply$default$15(), x$20 = AutoTaskDesc$.MODULE$.apply$default$16(), x$21 = AutoTaskDesc$.MODULE$.apply$default$17(), x$22 = AutoTaskDesc$.MODULE$.apply$default$18(), x$23 = AutoTaskDesc$.MODULE$.apply$default$19(), x$24 = AutoTaskDesc$.MODULE$.apply$default$20(), (Option<Object>)x$10, (Option<String>)x$11, (Option<Object>)x$12, x$25 = AutoTaskDesc$.MODULE$.apply$default$24(), x$8);
            boolean bl = auditTaskDesc.getSinkConnection(settings).isJdbcUrl();
            if (bl) {
                engine = Engine$JDBC$.MODULE$;
            } else if (!bl) {
                engine = auditTaskDesc.getSinkConnection(settings).getEngine();
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            Engine$JDBC$ engine2 = engine;
            AutoTask task = AutoTask$.MODULE$.task((Option<String>)Option$.MODULE$.apply((Object)log.jobid()), auditTaskDesc, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<String>)None$.MODULE$, false, log.test(), engine2, false, AutoTask$.MODULE$.task$default$9(), AutoTask$.MODULE$.task$default$10(), AutoTask$.MODULE$.task$default$11(), settings, storageHandler, schemaHandler);
            Try<JobResult> res = task.run();
            return Utils$.MODULE$.logFailure(res, this.logger());
        }
        return new Success((Object)new JobResult(){

            public List<Map<String, Object>> asMap() {
                return JobResult.asMap$(this);
            }

            public String prettyPrint(String format, boolean dryRun) {
                return JobResult.prettyPrint$(this, format, dryRun);
            }

            public boolean prettyPrint$default$2() {
                return JobResult.prettyPrint$default$2$(this);
            }

            public String prettyPrint(String format, List<String> headers, List<List<String>> values) {
                return JobResult.prettyPrint$(this, format, headers, values);
            }
            {
                JobResult.$init$(this);
            }
        });
    }

    public AuditLog apply(String jobid, Option<String> paths, String domain, String schema, boolean success, long count, long countAccepted, long countRejected, Timestamp timestamp, long duration, String message, String step, Option<String> database, String tenant, boolean test) {
        return new AuditLog(jobid, paths, domain, schema, success, count, countAccepted, countRejected, timestamp, duration, message, step, database, tenant, test);
    }

    public Option<Tuple15<String, Option<String>, String, String, Object, Object, Object, Object, Timestamp, Object, String, String, Option<String>, String, Object>> unapply(AuditLog x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple15((Object)x$0.jobid(), x$0.paths(), (Object)x$0.domain(), (Object)x$0.schema(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.success()), (Object)BoxesRunTime.boxToLong((long)x$0.count()), (Object)BoxesRunTime.boxToLong((long)x$0.countAccepted()), (Object)BoxesRunTime.boxToLong((long)x$0.countRejected()), (Object)x$0.timestamp(), (Object)BoxesRunTime.boxToLong((long)x$0.duration()), (Object)x$0.message(), (Object)x$0.step(), x$0.database(), (Object)x$0.tenant(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.test())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AuditLog$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.auditCols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"jobid", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"paths", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"domain", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"schema", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"success", (Object)StandardSQLTypeName.BOOL, (Object)BooleanType$.MODULE$), new Tuple3((Object)"count", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"countAccepted", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"countRejected", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"timestamp", (Object)StandardSQLTypeName.TIMESTAMP, (Object)TimestampType$.MODULE$), new Tuple3((Object)"duration", (Object)StandardSQLTypeName.INT64, (Object)LongType$.MODULE$), new Tuple3((Object)"message", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"step", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"database", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$), new Tuple3((Object)"tenant", (Object)StandardSQLTypeName.STRING, (Object)StringType$.MODULE$)}));
        this.starlakeSchema = new Schema("audit", Pattern.compile("ignore"), (List<Attribute>)((List)this.auditCols().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                String string;
                String name = (String)tuple3._1();
                AtomicType dataType = (AtomicType)tuple3._3();
                AtomicType atomicType = dataType;
                if (StringType$.MODULE$.equals(atomicType)) {
                    string = "string";
                } else if (BooleanType$.MODULE$.equals(atomicType)) {
                    string = "boolean";
                } else if (LongType$.MODULE$.equals(atomicType)) {
                    string = "long";
                } else if (TimestampType$.MODULE$.equals(atomicType)) {
                    string = "timestamp";
                } else {
                    throw new RuntimeException(new StringBuilder(17).append("Unsupported type ").append(dataType).toString());
                }
                String tpe = string;
                return new Attribute(name, tpe, Attribute$.MODULE$.apply$default$3(), Attribute$.MODULE$.apply$default$4(), Attribute$.MODULE$.apply$default$5(), Attribute$.MODULE$.apply$default$6(), Attribute$.MODULE$.apply$default$7(), Attribute$.MODULE$.apply$default$8(), Attribute$.MODULE$.apply$default$9(), Attribute$.MODULE$.apply$default$10(), Attribute$.MODULE$.apply$default$11(), Attribute$.MODULE$.apply$default$12(), Attribute$.MODULE$.apply$default$13(), Attribute$.MODULE$.apply$default$14(), Attribute$.MODULE$.apply$default$15(), Attribute$.MODULE$.apply$default$16(), Attribute$.MODULE$.apply$default$17(), Attribute$.MODULE$.apply$default$18());
            }
            throw new MatchError((Object)tuple3);
        }, List$.MODULE$.canBuildFrom())), (Option<Metadata>)None$.MODULE$, (Option<String>)None$.MODULE$, Schema$.MODULE$.apply$default$6(), Schema$.MODULE$.apply$default$7(), Schema$.MODULE$.apply$default$8(), Schema$.MODULE$.apply$default$9(), Schema$.MODULE$.apply$default$10(), Schema$.MODULE$.apply$default$11(), Schema$.MODULE$.apply$default$12(), Schema$.MODULE$.apply$default$13(), Schema$.MODULE$.apply$default$14(), Schema$.MODULE$.apply$default$15(), Schema$.MODULE$.apply$default$16());
    }
}

