/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.ingest.loaders;

import ai.starlake.config.CometColumns$;
import ai.starlake.config.Settings;
import ai.starlake.exceptions.NullValueFoundException;
import ai.starlake.job.ingest.BqLoadInfo;
import ai.starlake.job.ingest.IngestionJob;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.job.sink.bigquery.BigQueryJobResult;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig$;
import ai.starlake.job.sink.bigquery.BigQueryNativeJob;
import ai.starlake.job.sink.bigquery.BigQueryNativeJob$;
import ai.starlake.job.transform.AutoTask;
import ai.starlake.job.transform.AutoTask$;
import ai.starlake.job.transform.BigQueryAutoTask;
import ai.starlake.job.transform.BigQueryAutoTask$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AllSinks;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.AttributeDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.AutoTaskDesc$;
import ai.starlake.schema.model.BigQuerySink;
import ai.starlake.schema.model.ClusteringInfo;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.Engine$BQ$;
import ai.starlake.schema.model.ExpectationItem;
import ai.starlake.schema.model.FieldPartitionInfo;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Format$DSV$;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.Materialization;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.OutputRef;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.TableInfo;
import ai.starlake.schema.model.TransformInput;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.sql.SQLUtils$;
import ai.starlake.utils.IngestionCounters;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import ai.starlake.utils.conversion.BigQueryUtils$;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001\u0002\u000f\u001e\u0001!B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!AQ\n\u0001BC\u0002\u0013\ra\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003P\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001dq\u0006A1A\u0005\u0002}Ca\u0001\u001b\u0001!\u0002\u0013\u0001\u0007bB3\u0001\u0005\u0004%\t!\u001b\u0005\u0007[\u0002\u0001\u000b\u0011\u00026\t\u000f9\u0004!\u0019!C\u0001_\"1a\u000f\u0001Q\u0001\nADqa\u001e\u0001C\u0002\u0013\u0005\u0001\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0001\u007f\u0011\u001d\tI\u0003\u0001Q\u0001\n}D\u0011\"a\u000b\u0001\u0005\u0004%\t!!\f\t\u0011\u0005U\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000e\u0001\u0005\u0004%\t!!\u000f\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003wA!\"a\u0011\u0001\u0011\u000b\u0007I\u0011AA#\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001fBq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\b\u0003+\u0004A\u0011AAl\u0005Q\u0011\u0015nZ)vKJLh*\u0019;jm\u0016du.\u00193fe*\u0011adH\u0001\bY>\fG-\u001a:t\u0015\t\u0001\u0013%\u0001\u0004j]\u001e,7\u000f\u001e\u0006\u0003E\r\n1A[8c\u0015\t!S%\u0001\u0005ti\u0006\u0014H.Y6f\u0015\u00051\u0013AA1j\u0007\u0001\u00192\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001gN\u0007\u0002c)\u0011!gM\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003iU\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002m\u0005\u00191m\\7\n\u0005a\n$!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0007j]\u001e,7\u000f^5p]*{'\r\u0005\u0002<y5\tq$\u0003\u0002>?\ta\u0011J\\4fgRLwN\u001c&pE\u0006Y\u0011mY2fgN$vn[3o!\rQ\u0003IQ\u0005\u0003\u0003.\u0012aa\u00149uS>t\u0007CA\"K\u001d\t!\u0005\n\u0005\u0002FW5\taI\u0003\u0002HO\u00051AH]8pizJ!!S\u0016\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013.\n\u0001b]3ui&twm]\u000b\u0002\u001fB\u0011\u0001kU\u0007\u0002#*\u0011!kI\u0001\u0007G>tg-[4\n\u0005Q\u000b&\u0001C*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013A\u0002\u001fj]&$h\bF\u0002Y9v#\"!W.\u0011\u0005i\u0003Q\"A\u000f\t\u000b5+\u00019A(\t\u000be*\u0001\u0019\u0001\u001e\t\u000by*\u0001\u0019A \u0002\r\u0011|W.Y5o+\u0005\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003\u0015iw\u000eZ3m\u0015\t)7%\u0001\u0004tG\",W.Y\u0005\u0003O\n\u0014a\u0001R8nC&t\u0017a\u00023p[\u0006Lg\u000eI\u000b\u0002UB\u0011\u0011m[\u0005\u0003Y\n\u0014aaU2iK6\f\u0017aB:dQ\u0016l\u0017\rI\u0001\u000fgR|'/Y4f\u0011\u0006tG\r\\3s+\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:e\u0003!A\u0017M\u001c3mKJ\u001c\u0018BA;s\u00059\u0019Fo\u001c:bO\u0016D\u0015M\u001c3mKJ\fqb\u001d;pe\u0006<W\rS1oI2,'\u000fI\u0001\u000eg\u000eDW-\\1IC:$G.\u001a:\u0016\u0003e\u0004\"!\u001d>\n\u0005m\u0014(!D*dQ\u0016l\u0017\rS1oI2,'/\u0001\btG\",W.\u0019%b]\u0012dWM\u001d\u0011\u0002\tA\fG\u000f[\u000b\u0002\u007fB1\u0011\u0011AA\u0006\u0003#qA!a\u0001\u0002\b9\u0019Q)!\u0002\n\u00031J1!!\u0003,\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0004\u0002\u0010\t!A*[:u\u0015\r\tIa\u000b\t\u0005\u0003'\t)#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\t17O\u0003\u0003\u0002\u001c\u0005u\u0011A\u00025bI>|\u0007O\u0003\u0003\u0002 \u0005\u0005\u0012AB1qC\u000eDWM\u0003\u0002\u0002$\u0005\u0019qN]4\n\t\u0005\u001d\u0012Q\u0003\u0002\u0005!\u0006$\b.A\u0003qCRD\u0007%A\u0004paRLwN\\:\u0016\u0005\u0005=\u0002#B\"\u00022\t\u0013\u0015bAA\u001a\u0019\n\u0019Q*\u00199\u0002\u0011=\u0004H/[8og\u0002\n\u0001b\u001d;sCR,w-_\u000b\u0003\u0003w\u00012!YA\u001f\u0013\r\tyD\u0019\u0002\u000e/JLG/Z*ue\u0006$XmZ=\u0002\u0013M$(/\u0019;fOf\u0004\u0013AD7fe\u001e,G-T3uC\u0012\fG/Y\u000b\u0003\u0003\u000f\u00022!YA%\u0013\r\tYE\u0019\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006y!/Z9vSJ,Gk^8Ti\u0016\u00048\u000f\u0006\u0003\u0002R\u0005]\u0003c\u0001\u0016\u0002T%\u0019\u0011QK\u0016\u0003\u000f\t{w\u000e\\3b]\")Q-\u0006a\u0001U\u0006\u0019!/\u001e8\u0015\u0005\u0005u\u0003CBA0\u0003K\nI'\u0004\u0002\u0002b)\u0019\u00111M\u0016\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003O\n\tGA\u0002Uef\u0004B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_\u001a\u0013!B;uS2\u001c\u0018\u0002BA:\u0003[\u0012\u0011#\u00138hKN$\u0018n\u001c8D_VtG/\u001a:t\u00031\t'o\u00195jm\u0016$\u0016M\u00197f)\u0019\tI(a \u0002\u0018B\u0019!&a\u001f\n\u0007\u0005u4FA\u0002B]fDq!!!\u0018\u0001\u0004\t\u0019)\u0001\ngSJ\u001cHo\u0015;faR+W\u000e\u001d+bE2,\u0007\u0003BAC\u0003'k!!a\"\u000b\t\u0005%\u00151R\u0001\tE&<\u0017/^3ss*!\u0011QRAH\u0003\u0015\u0019Gn\\;e\u0015\r\t\t*N\u0001\u0007O>|w\r\\3\n\t\u0005U\u0015q\u0011\u0002\b)\u0006\u0014G.Z%e\u0011\u001d\tIj\u0006a\u0001\u00037\u000b!CZ5sgR\u001cF/\u001a9UC\ndW-\u00138g_B\u0019\u0011-!(\n\u0007\u0005}%MA\u0005UC\ndW-\u00138g_\u00069\u0012\r\u001d9ms\nKw-U;fef\u001cVmY8oIN#X\r\u001d\u000b\t\u0003K\u000bi+a0\u0002DB1\u0011qLA3\u0003O\u00032aOAU\u0013\r\tYk\b\u0002\u000b\u0005Fdu.\u00193J]\u001a|\u0007bBAX1\u0001\u0007\u0011\u0011W\u0001\ri\u0006\u0014x-\u001a;D_:4\u0017n\u001a\t\u0005\u0003g\u000bY,\u0004\u0002\u00026*!\u0011\u0011RA\\\u0015\r\tI,I\u0001\u0005g&t7.\u0003\u0003\u0002>\u0006U&A\u0005\"jOF+XM]=M_\u0006$7i\u001c8gS\u001eDq!!!\u0019\u0001\u0004\t\t\r\u0005\u0004\u0002\u0002\u0005-\u00111\u0011\u0005\b\u0003\u000bD\u0002\u0019AAS\u0003=1\u0017N]:u'R,\u0007OU3tk2$\u0018!G4fi\u0006\u00138\r[5wKR\u000b'\r\\3D_6\u0004xN\\3oiN$\"!a3\u0011\r)\nim\u0010\"C\u0013\r\tym\u000b\u0002\u0007)V\u0004H.Z\u001a\u00027\r|W\u000e];uK\u00163g-Z2uSZ,\u0017J\u001c9viN\u001b\u0007.Z7b)\u0005Q\u0017AG1qa2L()[4Rk\u0016\u0014\u0018pU3d_:$7\u000b^3q'FcECBAm\u0003C\f)\u000f\u0005\u0004\u0002`\u0005\u0015\u00141\u001c\t\u0005\u0003W\ni.\u0003\u0003\u0002`\u00065$!\u0003&pEJ+7/\u001e7u\u0011\u001d\t\u0019o\u0007a\u0001\u0003\u0003\fACZ5sgR\u001cF/\u001a9UK6\u0004H+\u00192mK&#\u0007BBAt7\u0001\u0007!.\u0001\bti\u0006\u0014H.Y6f'\u000eDW-\\1")
public class BigQueryNativeLoader
implements StrictLogging {
    private Metadata mergedMetadata;
    private final IngestionJob ingestionJob;
    private final Option<String> accessToken;
    private final Settings settings;
    private final Domain domain;
    private final ai.starlake.schema.model.Schema schema;
    private final StorageHandler storageHandler;
    private final SchemaHandler schemaHandler;
    private final List<Path> path;
    private final Map<String, String> options;
    private final WriteStrategy strategy;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Settings settings() {
        return this.settings;
    }

    public Domain domain() {
        return this.domain;
    }

    public ai.starlake.schema.model.Schema schema() {
        return this.schema;
    }

    public StorageHandler storageHandler() {
        return this.storageHandler;
    }

    public SchemaHandler schemaHandler() {
        return this.schemaHandler;
    }

    public List<Path> path() {
        return this.path;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public WriteStrategy strategy() {
        return this.strategy;
    }

    private Metadata mergedMetadata$lzycompute() {
        BigQueryNativeLoader bigQueryNativeLoader = this;
        synchronized (bigQueryNativeLoader) {
            if (!this.bitmap$0) {
                this.mergedMetadata = this.ingestionJob.mergedMetadata();
                this.bitmap$0 = true;
            }
        }
        return this.mergedMetadata;
    }

    public Metadata mergedMetadata() {
        if (!this.bitmap$0) {
            return this.mergedMetadata$lzycompute();
        }
        return this.mergedMetadata;
    }

    private boolean requireTwoSteps(ai.starlake.schema.model.Schema schema) {
        return schema.hasTransformOrIgnoreOrScriptColumns() || this.strategy().isMerge() || schema.filter().nonEmpty() || this.settings().appConfig().archiveTable();
    }

    public Try<IngestionCounters> run() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            String writeDisposition;
            ai.starlake.schema.model.Schema effectiveSchema;
            block6: {
                Tuple2<String, String> tuple2;
                block5: {
                    effectiveSchema = this.computeEffectiveInputSchema();
                    tuple2 = Utils$.MODULE$.getDBDisposition(this.strategy().toWriteMode());
                    if (tuple2 == null) break block5;
                    String createDisposition = (String)tuple2._1();
                    writeDisposition = (String)tuple2._2();
                    if (createDisposition == null) break block5;
                    string = createDisposition;
                    if (writeDisposition != null) break block6;
                }
                throw new MatchError(tuple2);
            }
            String string2 = writeDisposition;
            Tuple2 tuple2 = new Tuple2((Object)string, (Object)string2);
            String createDisposition = (String)tuple2._1();
            String writeDisposition2 = (String)tuple2._2();
            BigQuerySink bqSink = (BigQuerySink)this.mergedMetadata().getSink(this.settings());
            Some x$1 = new Some((Object)this.mergedMetadata());
            String x$22 = effectiveSchema.copy$default$1();
            Pattern x$32 = effectiveSchema.copy$default$2();
            List<Attribute> x$4 = effectiveSchema.copy$default$3();
            Option<String> x$5 = effectiveSchema.copy$default$5();
            List<String> x$6 = effectiveSchema.copy$default$6();
            List<String> x$72 = effectiveSchema.copy$default$7();
            Set<String> x$82 = effectiveSchema.copy$default$8();
            List<RowLevelSecurity> x$9 = effectiveSchema.copy$default$9();
            List<ExpectationItem> x$10 = effectiveSchema.copy$default$10();
            List<String> x$11 = effectiveSchema.copy$default$11();
            List<AccessControlEntry> x$12 = effectiveSchema.copy$default$12();
            Option<String> x$13 = effectiveSchema.copy$default$13();
            Option<String> x$14 = effectiveSchema.copy$default$14();
            Option<String> x$15 = effectiveSchema.copy$default$15();
            Option<String> x$16 = effectiveSchema.copy$default$16();
            ai.starlake.schema.model.Schema schemaWithMergedMetadata = effectiveSchema.copy(x$22, x$32, x$4, (Option<Metadata>)x$1, x$5, x$6, x$72, x$82, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
            TableId targetTableId = BigQueryJobBase$.MODULE$.extractProjectDatasetAndTable(this.schemaHandler().getDatabase(this.domain(), this.settings()), this.domain().finalName(), effectiveSchema.finalName());
            Some x$17 = new Some((Object)this.mergedMetadata().getSinkConnectionRef(this.settings()));
            Left x$18 = package$.MODULE$.Left().apply((Object)((TraversableOnce)this.path().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), List$.MODULE$.canBuildFrom())).mkString(","));
            Some x$19 = new Some((Object)targetTableId);
            String x$20 = this.settings().appConfig().defaultWriteFormat();
            String x$21 = createDisposition;
            String x$222 = writeDisposition2;
            Option<String> x$23 = bqSink.getPartitionColumn();
            scala.collection.immutable.Seq x$24 = (scala.collection.immutable.Seq)bqSink.clustering().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            Option<Object> x$25 = bqSink.days();
            boolean x$26 = BoxesRunTime.unboxToBoolean((Object)bqSink.requirePartitionFilter().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            List<RowLevelSecurity> x$27 = effectiveSchema.rls();
            Nil$ x$28 = Nil$.MODULE$;
            Some x$29 = new Some((Object)schemaWithMergedMetadata);
            Set<String> x$30 = this.domain().tags();
            Option<String> x$31 = this.domain().comment();
            Option<String> x$322 = this.schemaHandler().getDatabase(this.domain(), this.settings());
            Option<String> x$33 = $this.accessToken;
            Engine x$34 = BigQueryLoadConfig$.MODULE$.apply$default$12();
            List<AccessControlEntry> x$35 = BigQueryLoadConfig$.MODULE$.apply$default$14();
            Materialization x$36 = BigQueryLoadConfig$.MODULE$.apply$default$18();
            Option<String> x$37 = BigQueryLoadConfig$.MODULE$.apply$default$19();
            List<AttributeDesc> x$38 = BigQueryLoadConfig$.MODULE$.apply$default$20();
            Option<Object> x$39 = BigQueryLoadConfig$.MODULE$.apply$default$22();
            Option<Object> x$40 = BigQueryLoadConfig$.MODULE$.apply$default$23();
            BigQueryLoadConfig targetConfig = new BigQueryLoadConfig((Option<String>)x$17, (Either<String, Dataset<Row>>)x$18, (Option<TableId>)x$19, x$23, (Seq<String>)x$24, x$20, x$21, x$222, x$25, x$27, x$26, x$34, (List<String>)x$28, x$35, (Option<ai.starlake.schema.model.Schema>)x$29, x$30, x$31, x$36, x$37, x$38, x$322, x$39, x$40, x$33);
            boolean twoSteps = this.requireTwoSteps(effectiveSchema);
            if (twoSteps) {
                Tuple3 tuple3 = (Tuple3)((LinearSeqOptimized)this.path().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), List$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple3((Object)Nil$.MODULE$, (Object)Nil$.MODULE$, (Object)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null) {
                        Tuple3 tuple3 = (Tuple3)tuple2._1();
                        String sourceUri = (String)tuple2._2();
                        if (tuple3 != null) {
                            List loadResultList = (List)tuple3._1();
                            List tempTableIdList = (List)tuple3._2();
                            List tableInfoList = (List)tuple3._3();
                            TableId firstStepTempTable = BigQueryJobBase$.MODULE$.extractProjectDatasetAndTable(this.schemaHandler().getDatabase(this.domain(), this.settings()), this.domain().finalName(), SQLUtils$.MODULE$.temporaryTableName(effectiveSchema.finalName()));
                            Left x$41 = package$.MODULE$.Left().apply((Object)sourceUri);
                            Some x$42 = new Some((Object)firstStepTempTable);
                            Some x$43 = new Some((Object)"Temporary table created during data ingestion.");
                            Some x$44 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
                            String x$45 = JobInfo.WriteDisposition.WRITE_APPEND.name();
                            Option<String> x$46 = targetConfig.copy$default$1();
                            Option<String> x$47 = targetConfig.copy$default$4();
                            Seq<String> x$48 = targetConfig.copy$default$5();
                            String x$49 = targetConfig.copy$default$6();
                            String x$50 = targetConfig.copy$default$7();
                            List<RowLevelSecurity> x$51 = targetConfig.copy$default$10();
                            boolean x$52 = targetConfig.copy$default$11();
                            Engine x$53 = targetConfig.copy$default$12();
                            List<String> x$54 = targetConfig.copy$default$13();
                            List<AccessControlEntry> x$55 = targetConfig.copy$default$14();
                            Option<ai.starlake.schema.model.Schema> x$56 = targetConfig.copy$default$15();
                            Set<String> x$57 = targetConfig.copy$default$16();
                            Option<String> x$58 = targetConfig.copy$default$17();
                            Materialization x$59 = targetConfig.copy$default$18();
                            List<AttributeDesc> x$60 = targetConfig.copy$default$20();
                            Option<String> x$61 = targetConfig.copy$default$21();
                            Option<Object> x$62 = targetConfig.copy$default$22();
                            Option<Object> x$63 = targetConfig.copy$default$23();
                            Option<String> x$64 = targetConfig.copy$default$24();
                            BigQueryLoadConfig firstStepConfig = targetConfig.copy(x$46, (Either<String, Dataset<Row>>)x$41, (Option<TableId>)x$42, x$47, x$48, x$49, x$50, x$45, (Option<Object>)x$44, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, (Option<String>)x$43, x$60, x$61, x$62, x$63, x$64);
                            BigQueryNativeJob firstStepBigqueryJob = new BigQueryNativeJob(firstStepConfig, "", BigQueryNativeJob$.MODULE$.$lessinit$greater$default$3(), BigQueryNativeJob$.MODULE$.$lessinit$greater$default$4(), this.settings());
                            TableInfo firstStepTableInfo = firstStepBigqueryJob.getTableInfo(firstStepTempTable, (Function1<ai.starlake.schema.model.Schema, Schema>)(Function1 & Serializable & scala.Serializable)x$4 -> x$4.targetBqSchemaWithIgnoreAndScript(this.schemaHandler()));
                            Option x$65 = firstStepTableInfo.maybeSchema().map((Function1 & Serializable & scala.Serializable)schema -> Schema.of((Iterable)((Iterable)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)schema.getFields()).asScala()).$colon$plus((Object)Field.newBuilder((String)CometColumns$.MODULE$.cometInputFileNameColumn(), (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setDefaultValueExpression(new StringBuilder(2).append("'").append(sourceUri).append("'").toString()).build(), Buffer$.MODULE$.canBuildFrom())).asJava())));
                            TableId x$66 = firstStepTableInfo.copy$default$1();
                            Option<String> x$67 = firstStepTableInfo.copy$default$2();
                            Option<FieldPartitionInfo> x$68 = firstStepTableInfo.copy$default$4();
                            Option<ClusteringInfo> x$69 = firstStepTableInfo.copy$default$5();
                            List<AttributeDesc> x$70 = firstStepTableInfo.copy$default$6();
                            TableInfo enrichedTableInfo = firstStepTableInfo.copy(x$66, x$67, (Option<Schema>)x$65, x$68, x$69, x$70);
                            Try<BqLoadInfo> firstStepResult = firstStepBigqueryJob.loadPathsToBQ(firstStepTableInfo, (Option<TableInfo>)new Some((Object)enrichedTableInfo));
                            return new Tuple3(loadResultList.$colon$plus(firstStepResult, List$.MODULE$.canBuildFrom()), tempTableIdList.$colon$plus((Object)firstStepTempTable, List$.MODULE$.canBuildFrom()), tableInfoList.$colon$plus((Object)enrichedTableInfo, List$.MODULE$.canBuildFrom()));
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                List loadResults = (List)tuple3._1();
                List tempTableIds = (List)tuple3._2();
                List tableInfos = (List)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)loadResults, (Object)tempTableIds, (Object)tableInfos);
                List loadResults2 = (List)tuple32._1();
                List tempTableIds2 = (List)tuple32._2();
                List tableInfos2 = (List)tuple32._3();
                Try globalLoadResult = (Try)loadResults2.reduce((Function2 & Serializable & scala.Serializable)(result1, result2) -> result1.flatMap((Function1 & Serializable & scala.Serializable)r -> result2.map((Function1 & Serializable & scala.Serializable)x$6 -> BigQueryNativeLoader.combineStats$1(x$6, r))));
                Try<BqLoadInfo> output = this.applyBigQuerySecondStep(targetConfig, (List<TableId>)tempTableIds2, (Try<BqLoadInfo>)globalLoadResult);
                ((List)tempTableIds2.zip((GenIterable)tableInfos2, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        TableId id = (TableId)tuple2._1();
                        TableInfo info = (TableInfo)tuple2._2();
                        return this.archiveTable(id, info);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    BigQueryNativeJob bigQueryNativeJob = new BigQueryNativeJob(targetConfig, "", BigQueryNativeJob$.MODULE$.$lessinit$greater$default$3(), BigQueryNativeJob$.MODULE$.$lessinit$greater$default$4(), this.settings());
                    tempTableIds2.foreach((Function1 & Serializable & scala.Serializable)tableId -> BoxesRunTime.boxToBoolean((boolean)bigQueryNativeJob.dropTable(tableId, this.settings())));
                }).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> output).recoverWith((PartialFunction)new scala.Serializable(this, output){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BigQueryNativeLoader $outer;
                    private final Try output$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Utils$.MODULE$.logException(this.$outer.logger(), A1);
                        return (B1)this.output$1;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.output$1 = output$1;
                    }
                });
            }
            BigQueryNativeJob bigqueryJob = new BigQueryNativeJob(targetConfig, "", BigQueryNativeJob$.MODULE$.$lessinit$greater$default$3(), BigQueryNativeJob$.MODULE$.$lessinit$greater$default$4(), this.settings());
            return bigqueryJob.loadPathsToBQ(bigqueryJob.getTableInfo(targetTableId, (Function1<ai.starlake.schema.model.Schema, Schema>)(Function1 & Serializable & scala.Serializable)x$8 -> x$8.targetBqSchemaWithoutIgnore(this.schemaHandler())), bigqueryJob.loadPathsToBQ$default$2());
        }).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Try try_ = x0$3;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                BqLoadInfo result = (BqLoadInfo)success.value();
                result.jobResult().job().flatMap((Function1 & Serializable & scala.Serializable)j -> Option$.MODULE$.apply((Object)j.getStatus().getExecutionErrors())).foreach((Function1 & Serializable & scala.Serializable)errors -> {
                    errors.forEach(err -> {
                        BoxedUnit boxedUnit;
                        if ($this.logger().underlying().isErrorEnabled()) {
                            String arg$macro$1 = err.getReason();
                            String arg$macro$2 = err.getMessage();
                            $this.logger().underlying().error(new StringOps("%s - %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    });
                    return BoxedUnit.UNIT;
                });
                return new IngestionCounters(result.totalRows(), result.totalAcceptedRows(), result.totalRejectedRows());
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                Utils$.MODULE$.logException(this.logger(), exception);
                throw exception;
            }
            throw new MatchError((Object)try_);
        });
    }

    private Object archiveTable(TableId firstStepTempTable, TableInfo firstStepTableInfo) {
        block2: {
            String string;
            Option option;
            String archiveTableName;
            block4: {
                Tuple3<Option<String>, String, String> tuple3;
                block3: {
                    if (!this.settings().appConfig().archiveTable()) break block2;
                    tuple3 = this.getArchiveTableComponents();
                    if (tuple3 == null) break block3;
                    Option archiveDatabaseName = (Option)tuple3._1();
                    String archiveDomainName = (String)tuple3._2();
                    archiveTableName = (String)tuple3._3();
                    if (archiveDatabaseName == null) break block3;
                    option = archiveDatabaseName;
                    if (archiveDomainName == null) break block3;
                    string = archiveDomainName;
                    if (archiveTableName != null) break block4;
                }
                throw new MatchError(tuple3);
            }
            String string2 = archiveTableName;
            Tuple3 tuple3 = new Tuple3((Object)option, (Object)string, (Object)string2);
            Option archiveDatabaseName = (Option)tuple3._1();
            String archiveDomainName = (String)tuple3._2();
            String archiveTableName2 = (String)tuple3._3();
            String targetTable = new OutputRef(firstStepTempTable.getProject(), firstStepTempTable.getDataset(), firstStepTempTable.getTable()).toSQLString(this.mergedMetadata().getSink(this.settings()).getConnection(this.settings()));
            Buffer firstStepFields = (Buffer)firstStepTableInfo.maybeSchema().map((Function1 & Serializable & scala.Serializable)schema -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getName(), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception("Should never happen in Ingestion mode. We know the fields we are loading using the yml files");
            });
            String req = new StringBuilder(26).append("SELECT ").append(firstStepFields.mkString(",")).append(", '").append(this.ingestionJob.applicationId()).append("' as JOBID FROM ").append(targetTable).toString();
            String x$1 = new StringBuilder(8).append("archive-").append(this.ingestionJob.applicationId()).toString();
            Some x$2 = new Some((Object)req);
            Option x$3 = archiveDatabaseName;
            String x$4 = archiveDomainName;
            String x$5 = archiveTableName2;
            Some x$6 = new Some((Object)this.mergedMetadata().getSink(this.settings()).toAllSinks());
            List<String> x$7 = AutoTaskDesc$.MODULE$.apply$default$6();
            List<String> x$8 = AutoTaskDesc$.MODULE$.apply$default$7();
            List<RowLevelSecurity> x$9 = AutoTaskDesc$.MODULE$.apply$default$9();
            List<ExpectationItem> x$10 = AutoTaskDesc$.MODULE$.apply$default$10();
            List<AccessControlEntry> x$11 = AutoTaskDesc$.MODULE$.apply$default$11();
            Option<String> x$12 = AutoTaskDesc$.MODULE$.apply$default$12();
            Option<Freshness> x$13 = AutoTaskDesc$.MODULE$.apply$default$13();
            List<AttributeDesc> x$14 = AutoTaskDesc$.MODULE$.apply$default$14();
            Option<Path> x$15 = AutoTaskDesc$.MODULE$.apply$default$15();
            Set<String> x$16 = AutoTaskDesc$.MODULE$.apply$default$16();
            Option<WriteStrategy> x$17 = AutoTaskDesc$.MODULE$.apply$default$17();
            Option<String> x$18 = AutoTaskDesc$.MODULE$.apply$default$18();
            Option<String> x$19 = AutoTaskDesc$.MODULE$.apply$default$19();
            String x$20 = AutoTaskDesc$.MODULE$.apply$default$20();
            Option<Object> x$21 = AutoTaskDesc$.MODULE$.apply$default$21();
            Option<String> x$22 = AutoTaskDesc$.MODULE$.apply$default$22();
            Option<Object> x$23 = AutoTaskDesc$.MODULE$.apply$default$23();
            Option<String> x$24 = AutoTaskDesc$.MODULE$.apply$default$24();
            Option<String> x$25 = AutoTaskDesc$.MODULE$.apply$default$25();
            AutoTaskDesc taskDesc = new AutoTaskDesc(x$1, (Option<String>)x$2, (Option<String>)x$3, x$4, x$5, x$7, x$8, (Option<AllSinks>)x$6, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25);
            AutoTask autoTask = AutoTask$.MODULE$.task((Option<String>)Option$.MODULE$.apply((Object)this.ingestionJob.applicationId()), taskDesc, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<String>)None$.MODULE$, false, false, Engine$BQ$.MODULE$, true, AutoTask$.MODULE$.task$default$9(), AutoTask$.MODULE$.task$default$10(), AutoTask$.MODULE$.task$default$11(), this.settings(), this.storageHandler(), this.schemaHandler());
            return autoTask.run();
        }
        return BoxedUnit.UNIT;
    }

    private Try<BqLoadInfo> applyBigQuerySecondStep(BigQueryLoadConfig targetConfig, List<TableId> firstStepTempTable, Try<BqLoadInfo> firstStepResult) {
        Try<BqLoadInfo> try_ = firstStepResult;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Success success = (Success)try_;
            BqLoadInfo loadFileResult = (BqLoadInfo)success.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("First step result: {}", new Object[]{loadFileResult});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BigQueryNativeJob targetBigqueryJob = new BigQueryNativeJob(targetConfig, "", BigQueryNativeJob$.MODULE$.$lessinit$greater$default$3(), BigQueryNativeJob$.MODULE$.$lessinit$greater$default$4(), this.settings());
            Try secondStepResult = (Try)targetBigqueryJob.cliConfig().outputTableId().map((Function1 & Serializable & scala.Serializable)x$11 -> this.applyBigQuerySecondStepSQL(firstStepTempTable, this.schema())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception("Should never happen");
            });
            return secondStepResult.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> BigQueryNativeLoader.ai$starlake$job$ingest$loaders$BigQueryNativeLoader$$updateRejectedCount$1(0L, firstStepResult)).recoverWith((PartialFunction)new scala.Serializable(this, firstStepResult){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BigQueryNativeLoader $outer;
                private final Try firstStepResult$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof NullValueFoundException) {
                        NullValueFoundException nullValueFoundException = (NullValueFoundException)A1;
                        return (B1)BigQueryNativeLoader.ai$starlake$job$ingest$loaders$BigQueryNativeLoader$$updateRejectedCount$1(nullValueFoundException.nbRecord(), this.firstStepResult$1);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable instanceof NullValueFoundException;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.firstStepResult$1 = firstStepResult$1;
                }
            });
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            return failure;
        }
        throw new MatchError(try_);
    }

    private Tuple3<Option<String>, String, String> getArchiveTableComponents() {
        Tuple3 tuple3;
        String fullArchiveTableName = Utils$.MODULE$.parseJinja(this.settings().appConfig().archiveTablePattern(), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"domain"), (Object)this.domain().finalName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)this.schema().finalName())}))), this.settings());
        String[] archiveTableComponents = new StringOps(Predef$.MODULE$.augmentString(fullArchiveTableName)).split('.');
        if (archiveTableComponents.length == 3) {
            tuple3 = new Tuple3((Object)new Some((Object)archiveTableComponents[0]), (Object)archiveTableComponents[1], (Object)archiveTableComponents[2]);
        } else if (archiveTableComponents.length == 2) {
            tuple3 = new Tuple3(this.schemaHandler().getDatabase(this.domain(), this.settings()), (Object)archiveTableComponents[0], (Object)archiveTableComponents[1]);
        } else {
            throw new Exception(new StringBuilder(66).append("Archive table name must be in the format <domain>.<table> but got ").append(fullArchiveTableName).toString());
        }
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        Option archiveDatabaseName = (Option)tuple32._1();
        String archiveDomainName = (String)tuple32._2();
        String archiveTableName = (String)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)archiveDatabaseName, (Object)archiveDomainName, (Object)archiveTableName);
        Option archiveDatabaseName2 = (Option)tuple33._1();
        String archiveDomainName2 = (String)tuple33._2();
        String archiveTableName2 = (String)tuple33._3();
        return new Tuple3((Object)archiveDatabaseName2, (Object)archiveDomainName2, (Object)archiveTableName2);
    }

    private ai.starlake.schema.model.Schema computeEffectiveInputSchema() {
        Format format = this.mergedMetadata().resolveFormat();
        if (((Object)Format$DSV$.MODULE$).equals(format)) {
            Tuple2 tuple2 = new Tuple2((Object)this.mergedMetadata().resolveWithHeader(), (Object)((TraversableLike)this.path().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.toString(), List$.MODULE$.canBuildFrom())).headOption());
            if (tuple2 != null) {
                Boolean bl = (Boolean)tuple2._1();
                Option option = (Option)tuple2._2();
                Boolean bl2 = Boolean.TRUE;
                Boolean bl3 = bl;
                if (!(bl2 != null ? !((Object)bl2).equals(bl3) : bl3 != null) && option instanceof Some) {
                    List effectiveAttributes;
                    Some some = (Some)option;
                    String sourceFile = (String)some.value();
                    List csvHeaders = (List)this.storageHandler().readAndExecute(new Path(sourceFile), Charset.forName(this.mergedMetadata().resolveEncoding()), (Function1 & Serializable & scala.Serializable)is -> (List)Using$.MODULE$.resource(is, (Function1 & Serializable & scala.Serializable)reader -> {
                        Predef$.MODULE$.assert(this.mergedMetadata().resolveQuote().length() <= 1, (Function0 & Serializable & scala.Serializable)() -> "quote must be a single character");
                        Predef$.MODULE$.assert(this.mergedMetadata().resolveEscape().length() <= 1, (Function0 & Serializable & scala.Serializable)() -> "quote must be a single character");
                        CsvParserSettings csvParserSettings = new CsvParserSettings();
                        CsvFormat format = new CsvFormat();
                        format.setDelimiter(this.mergedMetadata().resolveSeparator());
                        new StringOps(Predef$.MODULE$.augmentString(this.mergedMetadata().resolveQuote())).headOption().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                            format.setQuote(BoxesRunTime.unboxToChar((Object)x$1));
                            return BoxedUnit.UNIT;
                        });
                        new StringOps(Predef$.MODULE$.augmentString(this.mergedMetadata().resolveEscape())).headOption().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                            format.setQuoteEscape(BoxesRunTime.unboxToChar((Object)x$1));
                            return BoxedUnit.UNIT;
                        });
                        csvParserSettings.setFormat((com.univocity.parsers.common.Format)format);
                        csvParserSettings.setMaxColumns(this.schema().attributes().length() * 2);
                        csvParserSettings.setNullValue(this.mergedMetadata().resolveNullValue());
                        csvParserSettings.setHeaderExtractionEnabled(true);
                        csvParserSettings.setMaxCharsPerColumn(-1);
                        CsvParser csvParser = new CsvParser(csvParserSettings);
                        csvParser.beginParsing((Reader)reader);
                        csvParser.parseNextRecord();
                        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])csvParser.getRecordMetadata().headers())).toList();
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                    Map attributesMap = ((TraversableOnce)this.schema().attributes().map((Function1 & Serializable & scala.Serializable)attr -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr.name()), attr), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    List csvAttributesInOrders = (List)csvHeaders.map((Function1 & Serializable & scala.Serializable)h -> (Attribute)attributesMap.getOrElse(h, (Function0 & Serializable & scala.Serializable)() -> {
                        String x$1 = h;
                        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        None$ x$3 = None$.MODULE$;
                        String x$4 = Attribute$.MODULE$.apply$default$2();
                        Option<Object> x$5 = Attribute$.MODULE$.apply$default$3();
                        Option<TransformInput> x$6 = Attribute$.MODULE$.apply$default$5();
                        Option<String> x$7 = Attribute$.MODULE$.apply$default$6();
                        Option<String> x$8 = Attribute$.MODULE$.apply$default$7();
                        Option<MetricType> x$9 = Attribute$.MODULE$.apply$default$8();
                        List<Attribute> x$10 = Attribute$.MODULE$.apply$default$9();
                        Option<Position> x$11 = Attribute$.MODULE$.apply$default$10();
                        Option<String> x$12 = Attribute$.MODULE$.apply$default$11();
                        Set<String> x$13 = Attribute$.MODULE$.apply$default$12();
                        Option<Trim> x$14 = Attribute$.MODULE$.apply$default$13();
                        Option<String> x$15 = Attribute$.MODULE$.apply$default$14();
                        Option<String> x$16 = Attribute$.MODULE$.apply$default$15();
                        Option<String> x$17 = Attribute$.MODULE$.apply$default$17();
                        Option<String> x$18 = Attribute$.MODULE$.apply$default$18();
                        return new Attribute(x$1, x$4, x$5, (Option<Object>)x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option<Object>)x$2, x$17, x$18);
                    }), List$.MODULE$.canBuildFrom());
                    List x$19 = effectiveAttributes = (List)csvAttributesInOrders.$plus$plus((GenTraversableOnce)this.schema().attributes().diff((GenSeq)csvAttributesInOrders), List$.MODULE$.canBuildFrom());
                    String x$20 = this.schema().copy$default$1();
                    Pattern x$21 = this.schema().copy$default$2();
                    Option<Metadata> x$22 = this.schema().copy$default$4();
                    Option<String> x$23 = this.schema().copy$default$5();
                    List<String> x$24 = this.schema().copy$default$6();
                    List<String> x$25 = this.schema().copy$default$7();
                    Set<String> x$26 = this.schema().copy$default$8();
                    List<RowLevelSecurity> x$27 = this.schema().copy$default$9();
                    List<ExpectationItem> x$28 = this.schema().copy$default$10();
                    List<String> x$29 = this.schema().copy$default$11();
                    List<AccessControlEntry> x$30 = this.schema().copy$default$12();
                    Option<String> x$31 = this.schema().copy$default$13();
                    Option<String> x$32 = this.schema().copy$default$14();
                    Option<String> x$33 = this.schema().copy$default$15();
                    Option<String> x$34 = this.schema().copy$default$16();
                    return this.schema().copy(x$20, x$21, (List<Attribute>)x$19, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34);
                }
            }
            return this.schema();
        }
        return this.schema();
    }

    public Try<JobResult> applyBigQuerySecondStepSQL(List<TableId> firstStepTempTableId, ai.starlake.schema.model.Schema starlakeSchema) {
        StructType incomingSparkSchema = starlakeSchema.targetSparkSchemaWithoutIgnore(this.schemaHandler());
        String tempTable = ((TraversableOnce)((List)firstStepTempTableId.map((Function1 & Serializable & scala.Serializable)tableId -> BigQueryUtils$.MODULE$.tableIdToTableName((TableId)tableId), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$15 -> new StringBuilder(14).append("SELECT * FROM ").append((String)x$15).toString(), List$.MODULE$.canBuildFrom())).mkString("(", " UNION ALL ", ")");
        String targetTableName = new StringBuilder(1).append(this.domain().finalName()).append(".").append(this.schema().finalName()).toString();
        Option bigqueryEngine = this.settings().appConfig().jdbcEngines().get((Object)"bigquery");
        String sqlWithTransformedFields = starlakeSchema.buildSqlSelectOnLoad(tempTable, (Option<Settings.JdbcEngine>)bigqueryEngine);
        String x$1 = targetTableName;
        Some x$2 = new Some((Object)sqlWithTransformedFields);
        Option<String> x$3 = this.schemaHandler().getDatabase(this.domain(), this.settings());
        String x$4 = this.domain().finalName();
        String x$5 = this.schema().finalName();
        List<String> x$6 = this.schema().presql();
        List<String> x$7 = this.schema().postsql();
        Option<AllSinks> x$8 = this.mergedMetadata().sink();
        List<RowLevelSecurity> x$9 = this.schema().rls();
        List<ExpectationItem> x$10 = this.schema().expectations();
        List<AccessControlEntry> x$11 = this.schema().acl();
        Option<String> x$12 = this.schema().comment();
        Set<String> x$13 = this.schema().tags();
        Option<WriteStrategy> x$14 = this.mergedMetadata().writeStrategy();
        Some x$152 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Option<Freshness> x$16 = AutoTaskDesc$.MODULE$.apply$default$13();
        List<AttributeDesc> x$17 = AutoTaskDesc$.MODULE$.apply$default$14();
        Option<Path> x$18 = AutoTaskDesc$.MODULE$.apply$default$15();
        Option<String> x$19 = AutoTaskDesc$.MODULE$.apply$default$18();
        Option<String> x$20 = AutoTaskDesc$.MODULE$.apply$default$19();
        String x$21 = AutoTaskDesc$.MODULE$.apply$default$20();
        Option<String> x$22 = AutoTaskDesc$.MODULE$.apply$default$22();
        Option<Object> x$23 = AutoTaskDesc$.MODULE$.apply$default$23();
        Option<String> x$24 = AutoTaskDesc$.MODULE$.apply$default$24();
        Option<String> x$25 = AutoTaskDesc$.MODULE$.apply$default$25();
        AutoTaskDesc taskDesc = new AutoTaskDesc(x$1, (Option<String>)x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$16, x$17, x$18, x$13, x$14, x$19, x$20, x$21, (Option<Object>)x$152, x$22, x$23, x$24, x$25);
        BigQueryAutoTask job = new BigQueryAutoTask((Option<String>)Option$.MODULE$.apply((Object)this.ingestionJob.applicationId()), taskDesc, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<String>)None$.MODULE$, false, false, true, BigQueryAutoTask$.MODULE$.$lessinit$greater$default$8(), BigQueryAutoTask$.MODULE$.$lessinit$greater$default$9(), BigQueryAutoTask$.MODULE$.$lessinit$greater$default$10(), this.settings(), this.storageHandler(), this.schemaHandler());
        job.updateBigQueryTableSchema(incomingSparkSchema);
        Try<JobResult> jobResult = job.run();
        return jobResult;
    }

    private static final BqLoadInfo combineStats$1(BqLoadInfo bqLoadInfo1, BqLoadInfo bqLoadInfo2) {
        return new BqLoadInfo(bqLoadInfo1.totalAcceptedRows() + bqLoadInfo2.totalAcceptedRows(), bqLoadInfo1.totalRejectedRows() + bqLoadInfo2.totalRejectedRows(), new BigQueryJobResult((Option<TableResult>)None$.MODULE$, bqLoadInfo1.jobResult().totalBytesProcessed() + bqLoadInfo2.jobResult().totalBytesProcessed(), (Option<Job>)None$.MODULE$));
    }

    public static final Try ai$starlake$job$ingest$loaders$BigQueryNativeLoader$$updateRejectedCount$1(long nullCountValues, Try firstStepResult$1) {
        return firstStepResult$1.map((Function1 & Serializable & scala.Serializable)r -> r.copy(r.totalAcceptedRows() - nullCountValues, r.totalRejectedRows() + nullCountValues, r.copy$default$3()));
    }

    public BigQueryNativeLoader(IngestionJob ingestionJob, Option<String> accessToken, Settings settings) {
        this.ingestionJob = ingestionJob;
        this.accessToken = accessToken;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.domain = ingestionJob.domain();
        this.schema = ingestionJob.schema();
        this.storageHandler = ingestionJob.storageHandler();
        this.schemaHandler = ingestionJob.schemaHandler();
        this.path = ingestionJob.path();
        this.options = ingestionJob.options();
        this.strategy = ingestionJob.mergedMetadata().getStrategyOptions();
    }
}

