/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.ingest.loaders;

import ai.starlake.config.CometColumns$;
import ai.starlake.config.Settings;
import ai.starlake.extract.JdbcDbUtils$;
import ai.starlake.job.ingest.IngestionJob;
import ai.starlake.job.transform.JdbcAutoTask;
import ai.starlake.job.transform.JdbcAutoTask$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.handlers.StorageHandler$;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AllSinks;
import ai.starlake.schema.model.Attribute;
import ai.starlake.schema.model.Attribute$;
import ai.starlake.schema.model.AttributeDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.AutoTaskDesc$;
import ai.starlake.schema.model.Domain;
import ai.starlake.schema.model.ExpectationItem;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Format$DSV$;
import ai.starlake.schema.model.Format$JSON$;
import ai.starlake.schema.model.Format$JSON_FLAT$;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.MetricType;
import ai.starlake.schema.model.Position;
import ai.starlake.schema.model.PrimitiveType;
import ai.starlake.schema.model.PrimitiveType$variant$;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.TransformInput;
import ai.starlake.schema.model.Trim;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.schema.model.WriteStrategyType;
import ai.starlake.schema.model.WriteStrategyType$APPEND$;
import ai.starlake.sql.SQLUtils$;
import ai.starlake.utils.IngestionCounters;
import ai.starlake.utils.SparkUtils$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Statement;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011)\u0019!C\u0002w!A!\t\u0001B\u0001B\u0003%A\bC\u0003D\u0001\u0011\u0005A\tC\u0004K\u0001\t\u0007I\u0011A&\t\rQ\u0003\u0001\u0015!\u0003M\u0011\u001d\t\u0006A1A\u0005\u0002UCa!\u0017\u0001!\u0002\u00131\u0006b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u0007E\u0002\u0001\u000b\u0011\u0002/\t\u000f\r\u0004!\u0019!C\u0001I\"1\u0001\u000e\u0001Q\u0001\n\u0015Dq!\u001b\u0001C\u0002\u0013\u0005!\u000eC\u0004\u0002\b\u0001\u0001\u000b\u0011B6\t\u0013\u0005%\u0001A1A\u0005\u0002\u0005-\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u0015\u0002A1A\u0005\u0002\u0005\u001d\u0002\u0002CA\u0018\u0001\u0001\u0006I!!\u000b\t\u0015\u0005E\u0002\u0001#b\u0001\n\u0003\t\u0019\u0004C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0002\u0013\tV\u001c7\u000e\u00122OCRLg/\u001a'pC\u0012,'O\u0003\u0002\u001b7\u00059An\\1eKJ\u001c(B\u0001\u000f\u001e\u0003\u0019IgnZ3ti*\u0011adH\u0001\u0004U>\u0014'B\u0001\u0011\"\u0003!\u0019H/\u0019:mC.,'\"\u0001\u0012\u0002\u0005\u0005L7\u0001A\n\u0004\u0001\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-g5\tQF\u0003\u0002/_\u0005a1oY1mC2|wmZ5oO*\u0011\u0001'M\u0001\tif\u0004Xm]1gK*\t!'A\u0002d_6L!\u0001N\u0017\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u00031IgnZ3ti&|gNS8c!\t9\u0004(D\u0001\u001c\u0013\tI4D\u0001\u0007J]\u001e,7\u000f^5p]*{'-\u0001\u0005tKR$\u0018N\\4t+\u0005a\u0004CA\u001fA\u001b\u0005q$BA  \u0003\u0019\u0019wN\u001c4jO&\u0011\u0011I\u0010\u0002\t'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0015KEC\u0001$I!\t9\u0005!D\u0001\u001a\u0011\u0015QD\u0001q\u0001=\u0011\u0015)D\u00011\u00017\u0003\u0019!w.\\1j]V\tA\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)Qn\u001c3fY*\u0011\u0011kH\u0001\u0007g\u000eDW-\\1\n\u0005Ms%A\u0002#p[\u0006Lg.A\u0004e_6\f\u0017N\u001c\u0011\u0016\u0003Y\u0003\"!T,\n\u0005as%AB*dQ\u0016l\u0017-A\u0004tG\",W.\u0019\u0011\u0002\u001dM$xN]1hK\"\u000bg\u000e\u001a7feV\tA\f\u0005\u0002^A6\taL\u0003\u0002`!\u0006A\u0001.\u00198eY\u0016\u00148/\u0003\u0002b=\nq1\u000b^8sC\u001e,\u0007*\u00198eY\u0016\u0014\u0018aD:u_J\fw-\u001a%b]\u0012dWM\u001d\u0011\u0002\u001bM\u001c\u0007.Z7b\u0011\u0006tG\r\\3s+\u0005)\u0007CA/g\u0013\t9gLA\u0007TG\",W.\u0019%b]\u0012dWM]\u0001\u000fg\u000eDW-\\1IC:$G.\u001a:!\u0003\u0011\u0001\u0018\r\u001e5\u0016\u0003-\u00042\u0001\u001c;x\u001d\ti'O\u0004\u0002oc6\tqN\u0003\u0002qG\u00051AH]8pizJ\u0011\u0001K\u0005\u0003g\u001e\nq\u0001]1dW\u0006<W-\u0003\u0002vm\n!A*[:u\u0015\t\u0019x\u0005E\u0002y\u0003\u0007i\u0011!\u001f\u0006\u0003un\f!AZ:\u000b\u0005ql\u0018A\u00025bI>|\u0007O\u0003\u0002\u007f\u007f\u00061\u0011\r]1dQ\u0016T!!!\u0001\u0002\u0007=\u0014x-C\u0002\u0002\u0006e\u0014A\u0001U1uQ\u0006)\u0001/\u0019;iA\u00059q\u000e\u001d;j_:\u001cXCAA\u0007!!\ty!a\u0006\u0002\u001e\u0005ua\u0002BA\t\u0003'\u0001\"A\\\u0014\n\u0007\u0005Uq%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tYBA\u0002NCBT1!!\u0006(!\u0011\ty!a\b\n\t\u0005\u0005\u00121\u0004\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011=\u0004H/[8og\u0002\n\u0001b\u001d;sCR,w-_\u000b\u0003\u0003S\u00012!TA\u0016\u0013\r\tiC\u0014\u0002\u000e/JLG/Z*ue\u0006$XmZ=\u0002\u0013M$(/\u0019;fOf\u0004\u0013AD7fe\u001e,G-T3uC\u0012\fG/Y\u000b\u0003\u0003k\u00012!TA\u001c\u0013\r\tID\u0014\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006y!/Z9vSJ,Gk^8Ti\u0016\u00048\u000f\u0006\u0003\u0002@\u0005\u0015\u0003c\u0001\u0014\u0002B%\u0019\u00111I\u0014\u0003\u000f\t{w\u000e\\3b]\")\u0011\u000b\u0006a\u0001-\u0006\u0019!/\u001e8\u0015\u0005\u0005-\u0003CBA'\u0003'\n9&\u0004\u0002\u0002P)\u0019\u0011\u0011K\u0014\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003+\nyEA\u0002Uef\u0004B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;z\u0012!B;uS2\u001c\u0018\u0002BA1\u00037\u0012\u0011#\u00138hKN$\u0018n\u001c8D_VtG/\u001a:t\u0003m\u0019w.\u001c9vi\u0016,eMZ3di&4X-\u00138qkR\u001c6\r[3nCR\ta+\u0001\btS:<G.Z*uKBdu.\u00193\u0015\u0015\u0005-\u0014\u0011OA:\u0003o\nI\bE\u0002'\u0003[J1!a\u001c(\u0005\r\te.\u001f\u0005\u0007\u0015^\u0001\r!!\b\t\u000f\u0005Ut\u00031\u0001\u0002\u001e\u0005)A/\u00192mK\")\u0011k\u0006a\u0001-\")\u0011n\u0006a\u0001W\u0002")
public class DuckDbNativeLoader
implements StrictLogging {
    private Metadata mergedMetadata;
    private final IngestionJob ingestionJob;
    private final Settings settings;
    private final Domain domain;
    private final Schema schema;
    private final StorageHandler storageHandler;
    private final SchemaHandler schemaHandler;
    private final List<Path> path;
    private final Map<String, String> options;
    private final WriteStrategy strategy;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Settings settings() {
        return this.settings;
    }

    public Domain domain() {
        return this.domain;
    }

    public Schema schema() {
        return this.schema;
    }

    public StorageHandler storageHandler() {
        return this.storageHandler;
    }

    public SchemaHandler schemaHandler() {
        return this.schemaHandler;
    }

    public List<Path> path() {
        return this.path;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public WriteStrategy strategy() {
        return this.strategy;
    }

    private Metadata mergedMetadata$lzycompute() {
        DuckDbNativeLoader duckDbNativeLoader = this;
        synchronized (duckDbNativeLoader) {
            if (!this.bitmap$0) {
                this.mergedMetadata = this.ingestionJob.mergedMetadata();
                this.bitmap$0 = true;
            }
        }
        return this.mergedMetadata;
    }

    public Metadata mergedMetadata() {
        if (!this.bitmap$0) {
            return this.mergedMetadata$lzycompute();
        }
        return this.mergedMetadata;
    }

    private boolean requireTwoSteps(Schema schema) {
        return schema.hasTransformOrIgnoreOrScriptColumns() || this.strategy().isMerge() || !schema.isVariant() || schema.filter().nonEmpty() || this.settings().appConfig().archiveTable();
    }

    public Try<IngestionCounters> run() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Schema effectiveSchema = this.computeEffectiveInputSchema();
            Some x$12 = new Some((Object)this.mergedMetadata());
            String x$2 = effectiveSchema.copy$default$1();
            Pattern x$3 = effectiveSchema.copy$default$2();
            List<Attribute> x$4 = effectiveSchema.copy$default$3();
            Option<String> x$5 = effectiveSchema.copy$default$5();
            List<String> x$6 = effectiveSchema.copy$default$6();
            List<String> x$7 = effectiveSchema.copy$default$7();
            Set<String> x$8 = effectiveSchema.copy$default$8();
            List<RowLevelSecurity> x$9 = effectiveSchema.copy$default$9();
            List<ExpectationItem> x$10 = effectiveSchema.copy$default$10();
            List<String> x$11 = effectiveSchema.copy$default$11();
            List<AccessControlEntry> x$122 = effectiveSchema.copy$default$12();
            Option<String> x$13 = effectiveSchema.copy$default$13();
            Option<String> x$14 = effectiveSchema.copy$default$14();
            Option<String> x$15 = effectiveSchema.copy$default$15();
            Option<String> x$16 = effectiveSchema.copy$default$16();
            Schema schemaWithMergedMetadata = effectiveSchema.copy(x$2, x$3, x$4, (Option<Metadata>)x$12, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16);
            Settings.Connection sinkConnection = this.mergedMetadata().getSinkConnection(this.settings());
            boolean twoSteps = this.requireTwoSteps(effectiveSchema);
            if (twoSteps) {
                List tempTables = (List)this.path().map((Function1 & Serializable & scala.Serializable)p -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Loading {} to temporary table", new Object[]{p});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    String tempTable = SQLUtils$.MODULE$.temporaryTableName(effectiveSchema.finalName());
                    this.singleStepLoad(this.domain().finalName(), tempTable, schemaWithMergedMetadata, (List<Path>)new .colon.colon(p, (List)Nil$.MODULE$));
                    String filenameSQL = new StringBuilder(44).append("ALTER TABLE ").append(this.domain().finalName()).append(".").append(tempTable).append(" ADD COLUMN ").append(CometColumns$.MODULE$.cometInputFileNameColumn()).append(" STRING DEFAULT '").append(p).append("';").toString();
                    JdbcDbUtils$.MODULE$.withJDBCConnection(sinkConnection.options(), (Function1 & Serializable & scala.Serializable)conn -> JdbcDbUtils$.MODULE$.execute(filenameSQL, (Connection)conn), this.settings());
                    return tempTable;
                }, List$.MODULE$.canBuildFrom());
                String unionTempTables = ((TraversableOnce)tempTables.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(14).append("SELECT * FROM ").append((String)x$1).toString(), List$.MODULE$.canBuildFrom())).mkString("(", " UNION ALL ", ")");
                String targetTableName = new StringBuilder(1).append(this.domain().finalName()).append(".").append(this.schema().finalName()).toString();
                String sqlWithTransformedFields = this.schema().buildSqlSelectOnLoad(unionTempTables, this.schema().buildSqlSelectOnLoad$default$2());
                String x$17 = targetTableName;
                Some x$18 = new Some((Object)sqlWithTransformedFields);
                Option<String> x$19 = this.schemaHandler().getDatabase(this.domain(), this.settings());
                String x$20 = this.domain().finalName();
                String x$21 = this.schema().finalName();
                List<String> x$22 = this.schema().presql();
                List<String> x$23 = this.schema().postsql();
                Option<AllSinks> x$24 = this.mergedMetadata().sink();
                List<RowLevelSecurity> x$25 = this.schema().rls();
                List<ExpectationItem> x$26 = this.schema().expectations();
                List<AccessControlEntry> x$27 = this.schema().acl();
                Option<String> x$28 = this.schema().comment();
                Set<String> x$29 = this.schema().tags();
                Option<WriteStrategy> x$30 = this.mergedMetadata().writeStrategy();
                Some x$31 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                Option<Freshness> x$32 = AutoTaskDesc$.MODULE$.apply$default$13();
                List<AttributeDesc> x$33 = AutoTaskDesc$.MODULE$.apply$default$14();
                Option<Path> x$34 = AutoTaskDesc$.MODULE$.apply$default$15();
                Option<String> x$35 = AutoTaskDesc$.MODULE$.apply$default$18();
                Option<String> x$36 = AutoTaskDesc$.MODULE$.apply$default$19();
                String x$37 = AutoTaskDesc$.MODULE$.apply$default$20();
                Option<String> x$38 = AutoTaskDesc$.MODULE$.apply$default$22();
                Option<Object> x$39 = AutoTaskDesc$.MODULE$.apply$default$23();
                Option<String> x$40 = AutoTaskDesc$.MODULE$.apply$default$24();
                Option<String> x$41 = AutoTaskDesc$.MODULE$.apply$default$25();
                AutoTaskDesc taskDesc = new AutoTaskDesc(x$17, (Option<String>)x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$32, x$33, x$34, x$29, x$30, x$35, x$36, x$37, (Option<Object>)x$31, x$38, x$39, x$40, x$41);
                JdbcAutoTask job = new JdbcAutoTask((Option<String>)Option$.MODULE$.apply((Object)$this.ingestionJob.applicationId()), taskDesc, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<String>)None$.MODULE$, false, false, true, JdbcAutoTask$.MODULE$.$lessinit$greater$default$8(), JdbcAutoTask$.MODULE$.$lessinit$greater$default$9(), this.settings(), this.storageHandler(), this.schemaHandler());
                job.run();
                job.updateJdbcTableSchema(this.schema().targetSparkSchema(this.schemaHandler()), targetTableName);
                tempTables.foreach((Function1 & Serializable & scala.Serializable)tempTable -> {
                    JdbcDbUtils$.MODULE$.withJDBCConnection(sinkConnection.options(), (Function1 & Serializable & scala.Serializable)conn -> {
                        JdbcDbUtils$.MODULE$.dropTable(conn, new StringBuilder(1).append($this.domain().finalName()).append(".").append(tempTable).toString());
                        return BoxedUnit.UNIT;
                    }, this.settings());
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            return this.singleStepLoad(this.domain().finalName(), this.schema().finalName(), schemaWithMergedMetadata, this.path());
        }).map((Function1 & Serializable & scala.Serializable)$minus -> new IngestionCounters(-1L, -1L, -1L));
    }

    private Schema computeEffectiveInputSchema() {
        Format format = this.mergedMetadata().resolveFormat();
        if (((Object)Format$DSV$.MODULE$).equals(format)) {
            Tuple2 tuple2 = new Tuple2((Object)this.mergedMetadata().resolveWithHeader(), (Object)((TraversableLike)this.path().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), List$.MODULE$.canBuildFrom())).headOption());
            if (tuple2 != null) {
                Boolean bl = (Boolean)tuple2._1();
                Option option = (Option)tuple2._2();
                Boolean bl2 = Boolean.TRUE;
                Boolean bl3 = bl;
                if (!(bl2 != null ? !((Object)bl2).equals(bl3) : bl3 != null) && option instanceof Some) {
                    Map attributesMap;
                    Some some = (Some)option;
                    String sourceFile = (String)some.value();
                    List csvHeaders = (List)this.storageHandler().readAndExecute(new Path(sourceFile), Charset.forName(this.mergedMetadata().resolveEncoding()), (Function1 & Serializable & scala.Serializable)is -> (List)Using$.MODULE$.resource(is, (Function1 & Serializable & scala.Serializable)reader -> {
                        Predef$.MODULE$.assert(this.mergedMetadata().resolveQuote().length() <= 1, (Function0 & Serializable & scala.Serializable)() -> "quote must be a single character");
                        Predef$.MODULE$.assert(this.mergedMetadata().resolveEscape().length() <= 1, (Function0 & Serializable & scala.Serializable)() -> "quote must be a single character");
                        CsvParserSettings csvParserSettings = new CsvParserSettings();
                        CsvFormat format = new CsvFormat();
                        format.setDelimiter(this.mergedMetadata().resolveSeparator());
                        new StringOps(Predef$.MODULE$.augmentString(this.mergedMetadata().resolveQuote())).headOption().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                            format.setQuote(BoxesRunTime.unboxToChar((Object)x$1));
                            return BoxedUnit.UNIT;
                        });
                        new StringOps(Predef$.MODULE$.augmentString(this.mergedMetadata().resolveEscape())).headOption().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                            format.setQuoteEscape(BoxesRunTime.unboxToChar((Object)x$1));
                            return BoxedUnit.UNIT;
                        });
                        csvParserSettings.setFormat((com.univocity.parsers.common.Format)format);
                        csvParserSettings.setMaxColumns(this.schema().attributes().length() * 2);
                        csvParserSettings.setNullValue(this.mergedMetadata().resolveNullValue());
                        csvParserSettings.setHeaderExtractionEnabled(true);
                        csvParserSettings.setMaxCharsPerColumn(-1);
                        CsvParser csvParser = new CsvParser(csvParserSettings);
                        csvParser.beginParsing((Reader)reader);
                        csvParser.parseNextRecord();
                        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])csvParser.getRecordMetadata().headers())).toList();
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                    List csvAttributesInOrders = (List)csvHeaders.map(arg_0 -> DuckDbNativeLoader.$anonfun$computeEffectiveInputSchema$9(attributesMap = ((TraversableOnce)this.schema().attributes().map((Function1 & Serializable & scala.Serializable)attr -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr.name()), attr), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), arg_0), List$.MODULE$.canBuildFrom());
                    List effectiveAttributes = (List)csvAttributesInOrders.$plus$plus((GenTraversableOnce)this.schema().attributes().diff((GenSeq)csvAttributesInOrders), List$.MODULE$.canBuildFrom());
                    if (effectiveAttributes.length() > this.schema().attributes().length()) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(new StringBuilder(116).append("Attributes in the CSV file are bigger from the schema. ").append("Schema will be updated to match the CSV file. ").append("Schema: ").append(((TraversableOnce)this.schema().attributes().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), List$.MODULE$.canBuildFrom())).mkString(",")).append(". ").append("CSV: ").append(csvHeaders.mkString(",")).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        List x$19 = effectiveAttributes.take(this.schema().attributes().length());
                        String x$20 = this.schema().copy$default$1();
                        Pattern x$21 = this.schema().copy$default$2();
                        Option<Metadata> x$22 = this.schema().copy$default$4();
                        Option<String> x$23 = this.schema().copy$default$5();
                        List<String> x$24 = this.schema().copy$default$6();
                        List<String> x$25 = this.schema().copy$default$7();
                        Set<String> x$26 = this.schema().copy$default$8();
                        List<RowLevelSecurity> x$27 = this.schema().copy$default$9();
                        List<ExpectationItem> x$28 = this.schema().copy$default$10();
                        List<String> x$29 = this.schema().copy$default$11();
                        List<AccessControlEntry> x$30 = this.schema().copy$default$12();
                        Option<String> x$31 = this.schema().copy$default$13();
                        Option<String> x$32 = this.schema().copy$default$14();
                        Option<String> x$33 = this.schema().copy$default$15();
                        Option<String> x$34 = this.schema().copy$default$16();
                        return this.schema().copy(x$20, x$21, (List<Attribute>)x$19, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34);
                    }
                    List x$35 = effectiveAttributes;
                    String x$36 = this.schema().copy$default$1();
                    Pattern x$37 = this.schema().copy$default$2();
                    Option<Metadata> x$38 = this.schema().copy$default$4();
                    Option<String> x$39 = this.schema().copy$default$5();
                    List<String> x$40 = this.schema().copy$default$6();
                    List<String> x$41 = this.schema().copy$default$7();
                    Set<String> x$42 = this.schema().copy$default$8();
                    List<RowLevelSecurity> x$43 = this.schema().copy$default$9();
                    List<ExpectationItem> x$44 = this.schema().copy$default$10();
                    List<String> x$45 = this.schema().copy$default$11();
                    List<AccessControlEntry> x$46 = this.schema().copy$default$12();
                    Option<String> x$47 = this.schema().copy$default$13();
                    Option<String> x$48 = this.schema().copy$default$14();
                    Option<String> x$49 = this.schema().copy$default$15();
                    Option<String> x$50 = this.schema().copy$default$16();
                    return this.schema().copy(x$36, x$37, (List<Attribute>)x$35, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50);
                }
            }
            return this.schema();
        }
        return this.schema();
    }

    public Object singleStepLoad(String domain, String table, Schema schema, List<Path> path) {
        Settings.Connection sinkConnection = this.mergedMetadata().getSinkConnection(this.settings());
        StructType incomingSparkSchema = schema.targetSparkSchema(this.schemaHandler());
        String domainAndTableName = new StringBuilder(1).append(domain).append(".").append(table).toString();
        JdbcOptionsInWrite optionsWrite = new JdbcOptionsInWrite(sinkConnection.jdbcUrl(), domainAndTableName, sinkConnection.options());
        Map<String, Map<String, String>> ddlMap = this.schemaHandler().getDdlMapping(schema);
        Map<String, String> attrsWithDDLTypes = this.schemaHandler().getAttributesWithDDLType(schema, "duckdb");
        return JdbcDbUtils$.MODULE$.withJDBCConnection(sinkConnection.options(), (Function1 & Serializable & scala.Serializable)conn -> {
            Statement stmtExternal = conn.createStatement();
            stmtExternal.close();
            boolean tableExists = JdbcDbUtils$.MODULE$.tableExists((Connection)conn, sinkConnection.jdbcUrl(), domainAndTableName);
            JdbcDbUtils$.MODULE$.createSchema((Connection)conn, domain);
            WriteStrategyType writeStrategyType = this.strategy().getEffectiveType();
            if (((Object)WriteStrategyType$APPEND$.MODULE$).equals(writeStrategyType)) {
                if (tableExists) {
                    SparkUtils$.MODULE$.updateJdbcTableSchema((Connection)conn, sinkConnection.options(), domainAndTableName, incomingSparkSchema, attrsWithDDLTypes);
                } else {
                    SparkUtils$.MODULE$.createTable((Connection)conn, domainAndTableName, incomingSparkSchema, true, optionsWrite, ddlMap, this.settings());
                }
            } else {
                JdbcDbUtils$.MODULE$.dropTable((Connection)conn, domainAndTableName);
                SparkUtils$.MODULE$.createTable((Connection)conn, domainAndTableName, incomingSparkSchema, true, optionsWrite, ddlMap, this.settings());
            }
            String columnsString = ((TraversableOnce)attrsWithDDLTypes.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String attr = (String)tuple2._1();
                    String ddlType = (String)tuple2._2();
                    return new StringBuilder(6).append("'").append(attr).append("': '").append(ddlType).append("'").toString();
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
            String paths = ((TraversableOnce)path.map((Function1 & Serializable & scala.Serializable)p -> {
                String ps = p.toString();
                if (ps.startsWith("file:")) {
                    return StorageHandler$.MODULE$.localFile((Path)p).pathAsString();
                }
                if (ps.contains("://")) {
                    String string = ps.substring(2);
                    String defaultEndpoint = "gs".equals(string) ? "storage.googleapis.com" : ("s3".equals(string) ? "s3.amazonaws.com" : "s3.amazonaws.com");
                    String endpoint = (String)sinkConnection.options().getOrElse((Object)"s3_endpoint", (Function0 & Serializable & scala.Serializable)() -> defaultEndpoint);
                    String keyid = (String)sinkConnection.options().apply((Object)"s3_access_key_id");
                    String secret = (String)sinkConnection.options().apply((Object)"s3_secret_access_key");
                    JdbcDbUtils$.MODULE$.execute("INSTALL httpfs;", (Connection)conn);
                    JdbcDbUtils$.MODULE$.execute("LOAD httpfs;", (Connection)conn);
                    JdbcDbUtils$.MODULE$.execute(new StringBuilder(19).append("SET s3_endpoint='").append(endpoint).append("';").toString(), (Connection)conn);
                    JdbcDbUtils$.MODULE$.execute(new StringBuilder(24).append("SET s3_access_key_id='").append(keyid).append("';").toString(), (Connection)conn);
                    JdbcDbUtils$.MODULE$.execute(new StringBuilder(28).append("SET s3_secret_access_key='").append(secret).append("';").toString(), (Connection)conn);
                    return ps;
                }
                return ps;
            }, List$.MODULE$.canBuildFrom())).mkString("['", "','", "']");
            Format format = this.mergedMetadata().resolveFormat();
            if (((Object)Format$DSV$.MODULE$).equals(format)) {
                String nullstr = Option$.MODULE$.apply((Object)this.mergedMetadata().resolveNullValue()).isEmpty() ? "" : new StringBuilder(13).append("nullstr = '").append(this.mergedMetadata().resolveNullValue()).append("',").toString();
                Map<String, String> options = this.mergedMetadata().getOptions();
                String extraOptions = options.nonEmpty() ? ((TraversableOnce)options.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        return new StringBuilder(5).append(k).append(" = '").append(v).append("'").toString();
                    }
                    throw new MatchError((Object)tuple2);
                }, Iterable$.MODULE$.canBuildFrom())).mkString("", ",", ",") : "";
                String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(257).append("INSERT INTO ").append(domainAndTableName).append(" SELECT\n               | * FROM read_csv(\n               | ").append(paths).append(",\n               | delim = '").append(this.mergedMetadata().resolveSeparator()).append("',\n               | header = ").append(this.mergedMetadata().resolveWithHeader()).append(",\n               | quote = '").append(this.mergedMetadata().resolveQuote()).append("',\n               | escape = '").append(this.mergedMetadata().resolveEscape()).append("',\n               | ").append(nullstr).append("\n               | ").append(extraOptions).append("\n               | columns = { ").append(columnsString).append("});").toString())).stripMargin();
                return JdbcDbUtils$.MODULE$.execute(sql, (Connection)conn);
            }
            if (((Object)Format$JSON_FLAT$.MODULE$).equals(format) ? true : ((Object)Format$JSON$.MODULE$).equals(format)) {
                Some some;
                PrimitiveType primitiveType;
                String format2;
                String string = Predef$.MODULE$.Boolean2boolean(this.mergedMetadata().resolveArray()) ? "array" : (format2 = Predef$.MODULE$.Boolean2boolean(this.mergedMetadata().resolveMultiline()) ? "unstructured" : "newline_delimited");
                if (schema.isFlat()) {
                    String sql = new StringBuilder(68).append("INSERT INTO  ").append(domainAndTableName).append(" SELECT * FROM read_json(").append(paths).append(", format = '").append(format2).append("', columns = { ").append(columnsString).append("});").toString();
                    return JdbcDbUtils$.MODULE$.execute(sql, (Connection)conn);
                }
                Option<PrimitiveType> option = ((Attribute)schema.attributes().head()).primitiveType(this.schemaHandler());
                if (option instanceof Some && ((Object)PrimitiveType$variant$.MODULE$).equals(primitiveType = (PrimitiveType)(some = (Some)option).value())) {
                    String sql = new StringBuilder(60).append("INSERT INTO ").append(domainAndTableName).append(" SELECT * FROM read_json_objects(").append(paths).append(", format = '").append(format2).append("');").toString();
                    return JdbcDbUtils$.MODULE$.execute(sql, (Connection)conn);
                }
                return new StringBuilder(72).append("INSERT INTO ").append(domainAndTableName).append(" SELECT * FROM read_json(").append(paths).append(", auto_detect = true, format = '").append(format2).append("');").toString();
            }
            return BoxedUnit.UNIT;
        }, this.settings());
    }

    public static final /* synthetic */ Attribute $anonfun$computeEffectiveInputSchema$9(Map attributesMap$1, String h) {
        return (Attribute)attributesMap$1.getOrElse((Object)h, (Function0 & Serializable & scala.Serializable)() -> {
            String x$1 = h;
            Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            None$ x$3 = None$.MODULE$;
            String x$4 = Attribute$.MODULE$.apply$default$2();
            Option<Object> x$5 = Attribute$.MODULE$.apply$default$3();
            Option<TransformInput> x$6 = Attribute$.MODULE$.apply$default$5();
            Option<String> x$7 = Attribute$.MODULE$.apply$default$6();
            Option<String> x$8 = Attribute$.MODULE$.apply$default$7();
            Option<MetricType> x$9 = Attribute$.MODULE$.apply$default$8();
            List<Attribute> x$10 = Attribute$.MODULE$.apply$default$9();
            Option<Position> x$11 = Attribute$.MODULE$.apply$default$10();
            Option<String> x$12 = Attribute$.MODULE$.apply$default$11();
            Set<String> x$13 = Attribute$.MODULE$.apply$default$12();
            Option<Trim> x$14 = Attribute$.MODULE$.apply$default$13();
            Option<String> x$15 = Attribute$.MODULE$.apply$default$14();
            Option<String> x$16 = Attribute$.MODULE$.apply$default$15();
            Option<String> x$17 = Attribute$.MODULE$.apply$default$17();
            Option<String> x$18 = Attribute$.MODULE$.apply$default$18();
            return new Attribute(x$1, x$4, x$5, (Option<Object>)x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option<Object>)x$2, x$17, x$18);
        });
    }

    public DuckDbNativeLoader(IngestionJob ingestionJob, Settings settings) {
        this.ingestionJob = ingestionJob;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.domain = ingestionJob.domain();
        this.schema = ingestionJob.schema();
        this.storageHandler = ingestionJob.storageHandler();
        this.schemaHandler = ingestionJob.schemaHandler();
        this.path = ingestionJob.path();
        this.options = ingestionJob.options();
        this.strategy = ingestionJob.mergedMetadata().getStrategyOptions();
    }
}

