/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.metrics;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.job.metrics.ExpectationAssertionHandler;
import ai.starlake.job.metrics.ExpectationReport;
import ai.starlake.job.transform.AutoTask;
import ai.starlake.job.transform.AutoTask$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.handlers.StorageHandler;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AllSinks;
import ai.starlake.schema.model.AttributeDesc;
import ai.starlake.schema.model.AutoTaskDesc;
import ai.starlake.schema.model.AutoTaskDesc$;
import ai.starlake.schema.model.ConnectionType;
import ai.starlake.schema.model.ConnectionType$GCPLOG$;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.Engine$JDBC$;
import ai.starlake.schema.model.ExpectationItem;
import ai.starlake.schema.model.Freshness;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.utils.GcpUtils$;
import ai.starlake.utils.IngestionCounters;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.SparkJob;
import ai.starlake.utils.SparkJobResult;
import ai.starlake.utils.Utils$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\t\u0012\u0001iA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005Q!Aq\u0007\u0001B\u0001B\u0003%1\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u0003,\u0011!I\u0004A!A!\u0002\u0013Q\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011I\u0003!\u0011!Q\u0001\nMC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\t7\u0002\u0011)\u0019!C\u00029\"A1\r\u0001B\u0001B\u0003%Q\fC\u0003e\u0001\u0011\u0005Q\rC\u0003r\u0001\u0011\u0005#\u000fC\u0003t\u0001\u0011\u0005C\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0004\u0002\f\u0001!\t%!\u0004\u0003\u001d\u0015C\b/Z2uCRLwN\u001c&pE*\u0011!cE\u0001\b[\u0016$(/[2t\u0015\t!R#A\u0002k_\nT!AF\f\u0002\u0011M$\u0018M\u001d7bW\u0016T\u0011\u0001G\u0001\u0003C&\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0016\u0003\u0015)H/\u001b7t\u0013\t13E\u0001\u0005Ta\u0006\u00148NS8c\u0003\u0015\t\u0007\u000f]%e!\ra\u0012fK\u0005\u0003Uu\u0011aa\u00149uS>t\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/;5\tqF\u0003\u000213\u00051AH]8pizJ!AM\u000f\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eu\t\u0001\u0002Z1uC\n\f7/Z\u0001\u000bI>l\u0017-\u001b8OC6,\u0017AC:dQ\u0016l\u0017MT1nK\u0006aQ\r\u001f9fGR\fG/[8ogB\u00191\bQ\"\u000f\u0005qrdB\u0001\u0018>\u0013\u0005q\u0012BA \u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0011\"\u0003\t1K7\u000f\u001e\u0006\u0003\u007fu\u0001\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u000b5|G-\u001a7\u000b\u0005!+\u0012AB:dQ\u0016l\u0017-\u0003\u0002K\u000b\nyQ\t\u001f9fGR\fG/[8o\u0013R,W.\u0001\bti>\u0014\u0018mZ3IC:$G.\u001a:\u0011\u00055\u0003V\"\u0001(\u000b\u0005=;\u0015\u0001\u00035b]\u0012dWM]:\n\u0005Es%AD*u_J\fw-\u001a%b]\u0012dWM]\u0001\u000eg\u000eDW-\\1IC:$G.\u001a:\u0011\u00055#\u0016BA+O\u00055\u00196\r[3nC\"\u000bg\u000e\u001a7fe\u0006I1/\u001d7Sk:tWM\u001d\t\u00031fk\u0011!E\u0005\u00035F\u00111$\u0012=qK\u000e$\u0018\r^5p]\u0006\u001b8/\u001a:uS>t\u0007*\u00198eY\u0016\u0014\u0018\u0001C:fiRLgnZ:\u0016\u0003u\u0003\"AX1\u000e\u0003}S!\u0001Y\u000b\u0002\r\r|gNZ5h\u0013\t\u0011wL\u0001\u0005TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\nM&T7\u000e\\7o_B$\"a\u001a5\u0011\u0005a\u0003\u0001\"B.\f\u0001\bi\u0006\"B\u0014\f\u0001\u0004A\u0003\"\u0002\u001c\f\u0001\u0004A\u0003\"B\u001c\f\u0001\u0004Y\u0003\"\u0002\u001d\f\u0001\u0004Y\u0003\"B\u001d\f\u0001\u0004Q\u0004\"B&\f\u0001\u0004a\u0005\"\u0002*\f\u0001\u0004\u0019\u0006\"\u0002,\f\u0001\u00049\u0016\u0001\u00028b[\u0016,\u0012aK\u0001\u000eCB\u0004H.[2bi&|g.\u00133\u0015\u0003-\n\u0001\u0002\\8dWB\u000bG\u000f\u001b\u000b\u0004o\u0006\u001d\u0001c\u0001=\u0002\u00045\t\u0011P\u0003\u0002{w\u0006\u0011am\u001d\u0006\u0003yv\fa\u0001[1e_>\u0004(B\u0001@\u0000\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011A\u0001\u0004_J<\u0017bAA\u0003s\n!\u0001+\u0019;i\u0011\u0019\tIA\u0004a\u0001W\u0005!\u0001/\u0019;i\u0003\r\u0011XO\u001c\u000b\u0003\u0003\u001f\u0001b!!\u0005\u0002\u0018\u0005mQBAA\n\u0015\r\t)\"H\u0001\u0005kRLG.\u0003\u0003\u0002\u001a\u0005M!a\u0001+ssB\u0019!%!\b\n\u0007\u0005}1EA\u0005K_\n\u0014Vm];mi\u0002")
public class ExpectationJob
implements SparkJob {
    private final Option<String> appId;
    private final Option<String> database;
    private final String domainName;
    private final String schemaName;
    private final List<ExpectationItem> expectations;
    private final StorageHandler storageHandler;
    private final SchemaHandler schemaHandler;
    private final ExpectationAssertionHandler sqlRunner;
    private final Settings settings;
    private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv;
    private SparkSession session;
    private final String appName;
    private final Logger logger;
    private volatile byte bitmap$0;

    @Override
    public SparkConf withExtraSparkConf(SparkConf sourceConfig) {
        return SparkJob.withExtraSparkConf$(this, sourceConfig);
    }

    @Override
    public String getTableLocation(String domain, String schema) {
        return SparkJob.getTableLocation$(this, domain, schema);
    }

    @Override
    public String getTableLocation(String fullTableName) {
        return SparkJob.getTableLocation$(this, fullTableName);
    }

    @Override
    public void registerUdf(String udf) {
        SparkJob.registerUdf$(this, udf);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv$lzycompute() {
        ExpectationJob expectationJob = this;
        synchronized (expectationJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.ai$starlake$utils$SparkJob$$sparkEnv = SparkJob.ai$starlake$utils$SparkJob$$sparkEnv$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.ai$starlake$utils$SparkJob$$sparkEnv;
    }

    @Override
    public SparkEnv ai$starlake$utils$SparkJob$$sparkEnv() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.ai$starlake$utils$SparkJob$$sparkEnv$lzycompute();
        }
        return this.ai$starlake$utils$SparkJob$$sparkEnv;
    }

    private SparkSession session$lzycompute() {
        ExpectationJob expectationJob = this;
        synchronized (expectationJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.session = SparkJob.session$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.session;
    }

    @Override
    public SparkSession session() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.session$lzycompute();
        }
        return this.session;
    }

    @Override
    public String appName() {
        return this.appName;
    }

    @Override
    public void ai$starlake$utils$JobBase$_setter_$appName_$eq(String x$1) {
        this.appName = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return "Check Expectations";
    }

    @Override
    public String applicationId() {
        return (String)this.appId.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.applicationId());
    }

    public Path lockPath(String path) {
        return new Path(this.settings().appConfig().lock().path(), new StringBuilder(17).append("expectations").append(path.replace("{{domain}}", this.domainName).replace("{{schema}}", this.schemaName).replace(":", "_").replace('/', '_')).append(".lock").toString());
    }

    @Override
    public Try<JobResult> run() {
        Try<JobResult> try_;
        String string;
        ObjectRef bqSlThisCTE = ObjectRef.create((Object)"");
        Option<String> option = this.database;
        if (option instanceof Some) {
            Some some = (Some)option;
            String db = (String)some.value();
            string = new StringBuilder(2).append(db).append(".").append(this.domainName).append(".").append(this.schemaName).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(1).append(this.domainName).append(".").append(this.schemaName).toString();
        } else {
            throw new MatchError(option);
        }
        String fullTableName = string;
        bqSlThisCTE.elem = new StringBuilder(33).append("WITH SL_THIS AS (SELECT * FROM ").append(fullTableName).append(")\n").toString();
        String macros = this.schemaHandler.jinjavaMacros();
        List expectationReports = (List)this.expectations.map((Function1 & Serializable & scala.Serializable)expectation -> {
            BoxedUnit boxedUnit;
            String expectationWithMacroDefinitions = new .colon.colon((Object)macros, (List)new .colon.colon((Object)expectation.queryCall(), (List)Nil$.MODULE$)).mkString("\n");
            String sql = new StringBuilder(0).append((String)bqSlThisCTE$1.elem).append(Utils$.MODULE$.parseJinja(expectationWithMacroDefinitions, $this.schemaHandler.activeEnvVars($this.schemaHandler.activeEnvVars$default$1(), $this.schemaHandler.activeEnvVars$default$2(), $this.schemaHandler.activeEnvVars$default$3()), this.settings())).toString();
            String assertion = Utils$.MODULE$.parseJinja(expectation.expect(), $this.schemaHandler.activeEnvVars($this.schemaHandler.activeEnvVars$default$1(), $this.schemaHandler.activeEnvVars$default$2(), $this.schemaHandler.activeEnvVars$default$3()), this.settings());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Applying expectation: {} with request {}", new Object[]{expectation.query(), sql});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Map<String, Object> expectationResult = $this.sqlRunner.handle(sql, assertion, this.settings());
                return new ExpectationReport(this.applicationId(), $this.database, $this.domainName, $this.schemaName, Timestamp.from(Instant.now()), "", expectation.query(), (Option<String>)new Some((Object)sql), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)expectationResult.apply((Object)"count")))), (Option<String>)None$.MODULE$, BoxesRunTime.unboxToBoolean((Object)expectationResult.apply((Object)"assertion")));
            });
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable e = failure.exception();
                if (e instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)e;
                    illegalArgumentException.printStackTrace();
                    return new ExpectationReport(this.applicationId(), $this.database, $this.domainName, $this.schemaName, Timestamp.from(Instant.now()), "", expectation.query(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)Utils$.MODULE$.exceptionAsString(illegalArgumentException)), false);
                }
            }
            if (bl) {
                Throwable e = failure.exception();
                e.printStackTrace();
                new ExpectationReport(this.applicationId(), $this.database, $this.domainName, $this.schemaName, Timestamp.from(Instant.now()), "", expectation.query(), (Option<String>)new Some((Object)sql), (Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)Utils$.MODULE$.exceptionAsString(e)), false);
                throw new Exception(e);
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ExpectationReport value = (ExpectationReport)success.value();
                return value;
            }
            throw new MatchError((Object)try_);
        }, List$.MODULE$.canBuildFrom());
        if (expectationReports.nonEmpty()) {
            expectationReports.foreach((Function1 & Serializable & scala.Serializable)r -> {
                ExpectationJob.$anonfun$run$3(this, r);
                return BoxedUnit.UNIT;
            });
            Sink auditSink = this.settings().appConfig().audit().getSink(this.settings());
            ConnectionType connectionType = auditSink.getConnectionType(this.settings());
            if (((Object)ConnectionType$GCPLOG$.MODULE$).equals(connectionType)) {
                String logName = this.settings().appConfig().audit().getDomainExpectation(this.settings());
                expectationReports.foreach((Function1 & Serializable & scala.Serializable)log -> {
                    GcpUtils$.MODULE$.sinkToGcpCloudLogging(log.asMap(), "expectation", logName, this.settings());
                    return BoxedUnit.UNIT;
                });
                try_ = new Success((Object)new JobResult(null){

                    public List<Map<String, Object>> asMap() {
                        return JobResult.asMap$(this);
                    }

                    public String prettyPrint(String format, boolean dryRun) {
                        return JobResult.prettyPrint$(this, format, dryRun);
                    }

                    public boolean prettyPrint$default$2() {
                        return JobResult.prettyPrint$default$2$(this);
                    }

                    public String prettyPrint(String format, List<String> headers, List<List<String>> values) {
                        return JobResult.prettyPrint$(this, format, headers, values);
                    }
                    {
                        JobResult.$init$(this);
                    }
                });
            } else {
                Engine engine;
                Option<String> x$25;
                Option<Object> x$24;
                String x$23;
                Option<String> x$22;
                Option<String> x$21;
                Option<WriteStrategy> x$20;
                Set<String> x$19;
                Option<Path> x$18;
                List<AttributeDesc> x$17;
                Option<Freshness> x$16;
                Option<String> x$15;
                List<AccessControlEntry> x$14;
                List<ExpectationItem> x$13;
                String sqls = ((TraversableOnce)expectationReports.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asSelect(this.settings().appConfig().audit().sink().getSink(this.settings()).getConnection(this.settings()).getJdbcEngineName(), this.settings()), List$.MODULE$.canBuildFrom())).mkString("", " UNION ", "");
                String x$1 = this.applicationId();
                Some x$26 = new Some((Object)sqls);
                Option<String> x$32 = this.settings().appConfig().audit().getDatabase(this.settings());
                String x$4 = this.settings().appConfig().audit().getDomain(this.settings());
                String x$5 = "expectations";
                Nil$ x$6 = Nil$.MODULE$;
                Nil$ x$7 = Nil$.MODULE$;
                Option<String> x$8 = this.settings().appConfig().audit().sink().connectionRef();
                Some x$9 = new Some((Object)this.settings().appConfig().audit().sink());
                Some x$10 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                Some x$11 = new Some((Object)"expectations");
                List<RowLevelSecurity> x$12 = AutoTaskDesc$.MODULE$.apply$default$9();
                AutoTaskDesc taskDesc = new AutoTaskDesc(x$1, (Option<String>)x$26, x$32, x$4, x$5, (List<String>)x$6, (List<String>)x$7, (Option<AllSinks>)x$9, x$12, x$13 = AutoTaskDesc$.MODULE$.apply$default$10(), x$14 = AutoTaskDesc$.MODULE$.apply$default$11(), x$15 = AutoTaskDesc$.MODULE$.apply$default$12(), x$16 = AutoTaskDesc$.MODULE$.apply$default$13(), x$17 = AutoTaskDesc$.MODULE$.apply$default$14(), x$18 = AutoTaskDesc$.MODULE$.apply$default$15(), x$19 = AutoTaskDesc$.MODULE$.apply$default$16(), x$20 = AutoTaskDesc$.MODULE$.apply$default$17(), x$21 = AutoTaskDesc$.MODULE$.apply$default$18(), x$22 = AutoTaskDesc$.MODULE$.apply$default$19(), x$23 = AutoTaskDesc$.MODULE$.apply$default$20(), (Option<Object>)x$10, (Option<String>)x$11, x$24 = AutoTaskDesc$.MODULE$.apply$default$23(), x$25 = AutoTaskDesc$.MODULE$.apply$default$24(), x$8);
                boolean bl = taskDesc.getSinkConnection(this.settings()).isJdbcUrl();
                if (bl) {
                    engine = Engine$JDBC$.MODULE$;
                } else if (!bl) {
                    engine = taskDesc.getSinkConnection(this.settings()).getEngine();
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                Engine$JDBC$ engine2 = engine;
                Option x$262 = Option$.MODULE$.apply((Object)this.applicationId());
                AutoTaskDesc x$27 = taskDesc;
                Map x$28 = Predef$.MODULE$.Map().empty();
                None$ x$29 = None$.MODULE$;
                boolean x$30 = false;
                Engine$JDBC$ x$31 = engine2;
                boolean x$322 = false;
                boolean x$33 = false;
                Option<String> x$34 = AutoTask$.MODULE$.task$default$9();
                int x$35 = AutoTask$.MODULE$.task$default$10();
                boolean x$36 = AutoTask$.MODULE$.task$default$11();
                Settings x$37 = this.settings();
                StorageHandler x$38 = this.storageHandler;
                SchemaHandler x$39 = this.schemaHandler;
                AutoTask task = AutoTask$.MODULE$.task((Option<String>)x$262, x$27, (Map<String, String>)x$28, (Option<String>)x$29, x$30, x$33, x$31, x$322, x$34, x$35, x$36, x$37, x$38, x$39);
                Try<JobResult> res = task.run();
                try_ = Utils$.MODULE$.logFailure(res, this.logger());
            }
        } else {
            try_ = new Try<JobResult>((Object)new SparkJobResult((Option<Dataset<Row>>)None$.MODULE$, (Option<IngestionCounters>)None$.MODULE$));
        }
        Try<JobResult> result = try_;
        int failed = expectationReports.count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExpectationJob.$anonfun$run$6(x$3)));
        if (this.settings().appConfig().expectations().failOnError() && failed > 0) {
            return new Failure((Throwable)new Exception(new StringBuilder(20).append(failed).append(" Expectations failed").toString()));
        }
        return result;
    }

    public static final /* synthetic */ void $anonfun$run$3(ExpectationJob $this, ExpectationReport r) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info(r.toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$run$6(ExpectationReport x$3) {
        return !x$3.success();
    }

    public ExpectationJob(Option<String> appId, Option<String> database, String domainName, String schemaName, List<ExpectationItem> expectations, StorageHandler storageHandler, SchemaHandler schemaHandler, ExpectationAssertionHandler sqlRunner, Settings settings) {
        this.appId = appId;
        this.database = database;
        this.domainName = domainName;
        this.schemaName = schemaName;
        this.expectations = expectations;
        this.storageHandler = storageHandler;
        this.schemaHandler = schemaHandler;
        this.sqlRunner = sqlRunner;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        SparkJob.$init$(this);
    }
}

