/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.metrics;

import ai.starlake.job.metrics.Metrics;
import ai.starlake.job.metrics.Metrics$CatCountFreq$;
import ai.starlake.job.metrics.Metrics$CountDistinct$;
import ai.starlake.job.metrics.Metrics$CountMissValues$;
import ai.starlake.job.metrics.Metrics$CountMissValuesDiscrete$;
import ai.starlake.job.metrics.Metrics$Kurtosis$;
import ai.starlake.job.metrics.Metrics$Max$;
import ai.starlake.job.metrics.Metrics$Mean$;
import ai.starlake.job.metrics.Metrics$Median$;
import ai.starlake.job.metrics.Metrics$Min$;
import ai.starlake.job.metrics.Metrics$Percentile25$;
import ai.starlake.job.metrics.Metrics$Percentile75$;
import ai.starlake.job.metrics.Metrics$Skewness$;
import ai.starlake.job.metrics.Metrics$Stddev$;
import ai.starlake.job.metrics.Metrics$Sum$;
import ai.starlake.job.metrics.Metrics$Variance$;
import ai.starlake.utils.DataTypeEx$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Metrics$
implements StrictLogging {
    public static Metrics$ MODULE$;
    private final List<Metrics.ContinuousMetric> continuousMetrics;
    private final List<Metrics.DiscreteMetric> discreteMetrics;
    private final Logger logger;

    static {
        new Metrics$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public List<Metrics.ContinuousMetric> continuousMetrics() {
        return this.continuousMetrics;
    }

    private Column customMetric(Column e, String metricName, Function1<Column, Column> metricFunction) {
        String aliasMetricName = new StringBuilder(2).append(metricName).append("(").append(e.toString()).append(")").toString();
        return ((Column)metricFunction.apply((Object)e)).as(aliasMetricName);
    }

    public Column ai$starlake$job$metrics$Metrics$$customMean(Column e2) {
        return this.customMetric(e2, "mean", (Function1<Column, Column>)(Function1 & Serializable & scala.Serializable)e -> functions$.MODULE$.mean(e));
    }

    public Column ai$starlake$job$metrics$Metrics$$customVariance(Column e2) {
        return this.customMetric(e2, "variance", (Function1<Column, Column>)(Function1 & Serializable & scala.Serializable)e -> functions$.MODULE$.variance(e));
    }

    public Column ai$starlake$job$metrics$Metrics$$customStddev(Column e2) {
        return this.customMetric(e2, "standardDev", (Function1<Column, Column>)(Function1 & Serializable & scala.Serializable)e -> functions$.MODULE$.stddev(e));
    }

    private Column customMetricUDF(Column e, String metricName, Function2<String, Seq<Column>, Column> metricFunction, String approxMethod, double approxValue) {
        String aliasMetric = new StringBuilder(2).append(metricName).append("(").append(e.toString()).append(")").toString();
        return ((Column)metricFunction.apply((Object)approxMethod, (Object)new .colon.colon((Object)e, (List)new .colon.colon((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)approxValue)), (List)Nil$.MODULE$)))).as(aliasMetric);
    }

    public Column percentile25(Column e) {
        return this.customMetricUDF(e, "percentile25", (Function2<String, Seq<Column>, Column>)(Function2 & Serializable & scala.Serializable)(udfName, cols) -> functions$.MODULE$.call_udf(udfName, cols), "percentile_approx", 0.25);
    }

    public Column ai$starlake$job$metrics$Metrics$$customMedian(Column e) {
        return this.customMetricUDF(e, "median", (Function2<String, Seq<Column>, Column>)(Function2 & Serializable & scala.Serializable)(udfName, cols) -> functions$.MODULE$.call_udf(udfName, cols), "percentile_approx", 0.5);
    }

    public Column percentile75(Column e) {
        return this.customMetricUDF(e, "percentile75", (Function2<String, Seq<Column>, Column>)(Function2 & Serializable & scala.Serializable)(udfName, cols) -> functions$.MODULE$.call_udf(udfName, cols), "percentile_approx", 0.75);
    }

    public Column ai$starlake$job$metrics$Metrics$$customCountMissValues(Column e) {
        String nameCol = e.toString();
        String aliasCountMissValues = new StringBuilder(15).append("missingValues(").append(nameCol).append(")").toString();
        Column unionMissingValues = functions$.MODULE$.sum(functions$.MODULE$.when(e.isNull().$bar$bar((Object)e.$eq$eq$eq((Object)"")), (Object)BoxesRunTime.boxToInteger((int)1)).otherwise((Object)BoxesRunTime.boxToInteger((int)0)));
        return unionMissingValues.as(aliasCountMissValues);
    }

    private Dataset<Row> regroupContinuousMetricsByVariable(String nameCol, Dataset<Row> metricFrame) {
        String[] listColumns = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metricFrame.columns())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains(new StringBuilder(2).append("(").append(nameCol).append(")").toString()))))).sorted((Ordering)Ordering.String$.MODULE$);
        Dataset selectedListColumns = metricFrame.select((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])listColumns)).head(), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])listColumns)).tail())).toIndexedSeq());
        Dataset broundColumns = selectedListColumns.select((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedListColumns.columns())).map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.bround(functions$.MODULE$.col(c), 3).alias(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).toIndexedSeq());
        Dataset addVariablesColumn = broundColumns.withColumn("attribute", functions$.MODULE$.lit((Object)nameCol));
        List removeNameColumnMetric = (List)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])addVariablesColumn.columns())).toList().map((Function1 & Serializable & scala.Serializable)str -> str.replaceAll(new StringBuilder(4).append("\\(").append(nameCol).append("\\)").toString(), ""), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> new StringOps(Predef$.MODULE$.augmentString(x$2)).capitalize(), List$.MODULE$.canBuildFrom());
        return addVariablesColumn.toDF((Seq)removeNameColumnMetric);
    }

    private List<String> extractMetricsAttributes(Dataset<Row> dataset, List<String> continuousAttributes) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        List datasetAttributes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fields())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Metrics$.$anonfun$extractMetricsAttributes$1(x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Valid Continuous datasetAttributes Attrs ={}", new Object[]{datasetAttributes});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        List intersectionAttributes = (List)datasetAttributes.intersect(continuousAttributes);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Valid intersectionAttributes Attrs ={}", new Object[]{intersectionAttributes});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (intersectionAttributes.nonEmpty()) {
            return intersectionAttributes;
        }
        return Nil$.MODULE$;
    }

    public Option<Dataset<Row>> computeContinuousMetric(Dataset<Row> dataset, List<String> continuousAttributes, List<Metrics.ContinuousMetric> operations) {
        BoxedUnit boxedUnit;
        List<String> attributeChecked = this.extractMetricsAttributes(dataset, continuousAttributes);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Continuous attributes : {}", new Object[]{attributeChecked});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String string = "attribute";
        List colRenamed = ((List)operations.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), List$.MODULE$.canBuildFrom())).$colon$colon((Object)string);
        List metrics = (List)attributeChecked.flatMap((Function1 & Serializable & scala.Serializable)name -> (List)operations.map((Function1 & Serializable & scala.Serializable)metric -> (Column)metric.function().apply((Object)functions$.MODULE$.col(name)), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        List dropAttributes = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fields())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList().filterNot((Function1)continuousAttributes.toSet());
        List list = metrics;
        if (Nil$.MODULE$.equals(list)) {
            return None$.MODULE$;
        }
        Dataset droppedDataset = dataset.drop((Seq)dropAttributes);
        Dataset metricFrame = droppedDataset.agg((Column)metrics.head(), (Seq)metrics.tail());
        Dataset matrixMetric = (Dataset)((TraversableOnce)attributeChecked.map((Function1 & Serializable & scala.Serializable)x -> MODULE$.regroupContinuousMetricsByVariable((String)x, (Dataset<Row>)metricFrame), List$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> x$8.union(x$9));
        Dataset res = matrixMetric.select((String)colRenamed.head(), (Seq)colRenamed.tail()).withColumn("cometMetric", functions$.MODULE$.lit((Object)"Continuous"));
        return new Some((Object)res);
    }

    public List<Metrics.DiscreteMetric> discreteMetrics() {
        return this.discreteMetrics;
    }

    private Dataset<Row> dataToMetricData(Tuple2<Column, Dataset<Row>> colNamDataCatCountFreq, List<Metrics.DiscreteMetric> operations) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNamDataCatCountFreq;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Column colVar = (Column)tuple2._1();
        Dataset dataCatCountFreq = (Dataset)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)colVar, (Object)dataCatCountFreq);
        Column colVar2 = (Column)tuple22._1();
        Dataset dataCatCountFreq2 = (Dataset)tuple22._2();
        List listCol = (List)operations.map((Function1 & Serializable & scala.Serializable)metric -> (Column)metric.function().apply((Object)new Tuple2((Object)colVar2, (Object)dataCatCountFreq2)), List$.MODULE$.canBuildFrom());
        return dataCatCountFreq2.withColumn("cat_count_freq", functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("Category").cast((DataType)StringType$.MODULE$).as("category"), functions$.MODULE$.col("CountDiscrete").cast((DataType)LongType$.MODULE$).as("countDiscrete"), functions$.MODULE$.col("Frequencies").cast((DataType)DoubleType$.MODULE$).as("frequency")}))).agg((Column)listCol.head(), (Seq)listCol.tail()).withColumn("attribute", functions$.MODULE$.lit((Object)colVar2.toString()));
    }

    private Tuple2<Column, Dataset<Row>> categoryCountFreqDataframe(Column e, Dataset<Row> dataInit) {
        Dataset dataCatCount = dataInit.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{e})).count().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Category", "CountDiscrete"}));
        long sumValues = dataInit.count();
        Dataset dataCatCountFreq = dataCatCount.withColumn("Frequencies", functions$.MODULE$.bround(dataCatCount.apply("CountDiscrete").$div((Object)BoxesRunTime.boxToLong((long)sumValues)), 3)).withColumn("NumMissVals", functions$.MODULE$.when(functions$.MODULE$.col("Category").isNotNull(), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))).otherwise((Object)functions$.MODULE$.col("CountDiscrete"))).withColumn("CategoryChange", functions$.MODULE$.col("Category"));
        return new Tuple2((Object)e, (Object)dataCatCountFreq);
    }

    private Column metricCategory(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.collect_list(functions$.MODULE$.col("Category"));
    }

    private Column metricCountDiscret(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.collect_list(functions$.MODULE$.map((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("CategoryChange"), functions$.MODULE$.col("CountDiscrete")}))).as("countByCategory");
    }

    private Column metricFrequency(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.collect_list(functions$.MODULE$.map((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("CategoryChange"), functions$.MODULE$.col("Frequencies")}))).as("frequencies");
    }

    private Column metricCountDistinct(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.count(functions$.MODULE$.col("Category"));
    }

    private Column metricCatCountFreq(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.collect_list(functions$.MODULE$.col("cat_count_freq")).as("catCountFreq");
    }

    private Column metricMissingValues(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.sum(functions$.MODULE$.col("NumMissVals"));
    }

    private Column customMetricDiscret(Column e, Dataset<Row> dataCategoryCount, String metricName, Function1<Dataset<Row>, Column> metricFunction) {
        String aliasMetricName = metricName;
        return ((Column)metricFunction.apply(dataCategoryCount)).as(aliasMetricName);
    }

    public Column customCategory(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Column colVar = (Column)tuple2._1();
        Dataset dataCatCount = (Dataset)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
        Column colVar2 = (Column)tuple22._1();
        Dataset dataCatCount2 = (Dataset)tuple22._2();
        return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "category", (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)dataCategoryCount -> MODULE$.metricCategory((Dataset<Row>)dataCategoryCount));
    }

    public Column ai$starlake$job$metrics$Metrics$$customCountDistinct(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Column colVar = (Column)tuple2._1();
        Dataset dataCatCount = (Dataset)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
        Column colVar2 = (Column)tuple22._1();
        Dataset dataCatCount2 = (Dataset)tuple22._2();
        return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "countDistinct", (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)dataCategoryCount -> MODULE$.metricCountDistinct((Dataset<Row>)dataCategoryCount));
    }

    public Column ai$starlake$job$metrics$Metrics$$customCatCountFreq(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Column colVar = (Column)tuple2._1();
        Dataset dataCatCount = (Dataset)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
        Column colVar2 = (Column)tuple22._1();
        Dataset dataCatCount2 = (Dataset)tuple22._2();
        return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "catCountFreq", (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)dataCategoryCount -> MODULE$.metricCatCountFreq((Dataset<Row>)dataCategoryCount));
    }

    public Column ai$starlake$job$metrics$Metrics$$customCountDiscrete(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Column colVar = (Column)tuple2._1();
        Dataset dataCatCount = (Dataset)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
        Column colVar2 = (Column)tuple22._1();
        Dataset dataCatCount2 = (Dataset)tuple22._2();
        return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "countByCategory", (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)dataCategoryCount -> MODULE$.metricCountDiscret((Dataset<Row>)dataCategoryCount));
    }

    public Column customFrequencies(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Column colVar = (Column)tuple2._1();
        Dataset dataCatCount = (Dataset)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
        Column colVar2 = (Column)tuple22._1();
        Dataset dataCatCount2 = (Dataset)tuple22._2();
        return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "frequencies", (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)dataCategoryCount -> MODULE$.metricFrequency((Dataset<Row>)dataCategoryCount));
    }

    public Column ai$starlake$job$metrics$Metrics$$customCountMissValuesDiscrete(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Column colVar = (Column)tuple2._1();
        Dataset dataCatCount = (Dataset)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
        Column colVar2 = (Column)tuple22._1();
        Dataset dataCatCount2 = (Dataset)tuple22._2();
        return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "missingValuesDiscrete", (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)dataCategoryCount -> MODULE$.metricMissingValues((Dataset<Row>)dataCategoryCount));
    }

    public Option<Dataset<Row>> computeDiscretMetric(Dataset<Row> dataInit, List<String> discreteAttrs, List<Metrics.DiscreteMetric> operations) {
        BoxedUnit boxedUnit;
        List attributeChecked;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        List headerDataUse = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataInit.schema().fields())).filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)Metrics$.$anonfun$computeDiscretMetric$1(x$17))))).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(20).append("Discrete Headers -> ").append(headerDataUse.mkString(",")).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        List intersectionHeaderAttributes = (List)headerDataUse.intersect(discreteAttrs);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(40).append("intersectionHeaderAttributes Headers -> ").append(intersectionHeaderAttributes.mkString(",")).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String[] dropAttributes = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataInit.schema().fields())).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filterNot((Function1)discreteAttrs.toSet());
        Object object = attributeChecked = intersectionHeaderAttributes.nonEmpty() ? intersectionHeaderAttributes : Nil$.MODULE$;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(28).append("attributeChecked Headers -> ").append(attributeChecked.mkString(",")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List list = attributeChecked;
        if (Nil$.MODULE$.equals(list)) {
            return None$.MODULE$;
        }
        Dataset dataset = dataInit.drop((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dropAttributes)).toIndexedSeq());
        String string = "attribute";
        List colRenamed = ((List)operations.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.name(), List$.MODULE$.canBuildFrom())).$colon$colon((Object)string);
        Dataset matrixMetric = (Dataset)((TraversableOnce)((List)attributeChecked.map((Function1 & Serializable & scala.Serializable)name -> MODULE$.categoryCountFreqDataframe(functions$.MODULE$.col(name), (Dataset<Row>)dataset), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)colData -> MODULE$.dataToMetricData((Tuple2<Column, Dataset<Row>>)colData, operations), List$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$22, x$23) -> x$22.union(x$23));
        Dataset res = matrixMetric.select((String)colRenamed.head(), (Seq)colRenamed.tail()).withColumn("cometMetric", functions$.MODULE$.lit((Object)"Discrete"));
        return new Some((Object)res);
    }

    public static final /* synthetic */ boolean $anonfun$extractMetricsAttributes$1(StructField x$3) {
        return DataTypeEx$.MODULE$.DataTypeEx(x$3.dataType()).isOfValidContinuousType();
    }

    public static final /* synthetic */ boolean $anonfun$computeDiscretMetric$1(StructField x$17) {
        return DataTypeEx$.MODULE$.DataTypeEx(x$17.dataType()).isOfValidDiscreteType();
    }

    private Metrics$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.continuousMetrics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Metrics.ContinuousMetric[]{Metrics$Min$.MODULE$, Metrics$Max$.MODULE$, Metrics$Mean$.MODULE$, Metrics$CountMissValues$.MODULE$, Metrics$Variance$.MODULE$, Metrics$Stddev$.MODULE$, Metrics$Sum$.MODULE$, Metrics$Skewness$.MODULE$, Metrics$Kurtosis$.MODULE$, Metrics$Percentile25$.MODULE$, Metrics$Median$.MODULE$, Metrics$Percentile75$.MODULE$}));
        this.discreteMetrics = new .colon.colon((Object)Metrics$CountDistinct$.MODULE$, (List)new .colon.colon((Object)Metrics$CatCountFreq$.MODULE$, (List)new .colon.colon((Object)Metrics$CountMissValuesDiscrete$.MODULE$, (List)Nil$.MODULE$)));
    }
}

