/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.config.Settings;
import better.files.File;
import better.files.File$;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class BigQueryJobBase$
implements StrictLogging {
    public static BigQueryJobBase$ MODULE$;
    private final Logger logger;

    static {
        new BigQueryJobBase$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Schema dictToBQSchema(Map<String, String> dictField) {
        return Schema.of((Iterable)((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)dictField.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String fieldName = (String)tuple2._1();
                String description = (String)tuple2._2();
                return Field.newBuilder((String)fieldName, (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setDescription(description).build();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava()));
    }

    public DatasetId ai$starlake$job$sink$bigquery$BigQueryJobBase$$getBqDatasetId(TableId tableId) {
        Option<String> projectId = this.getProjectIdPrefix((Option<String>)Option$.MODULE$.apply((Object)tableId.getProject()));
        Option option = Option$.MODULE$.apply(projectId);
        if (option instanceof Some) {
            return DatasetId.of((String)tableId.getProject(), (String)tableId.getDataset());
        }
        if (None$.MODULE$.equals(option)) {
            return DatasetId.of((String)tableId.getDataset());
        }
        throw new MatchError((Object)option);
    }

    public String getBqTableForSpark(TableId tableId) {
        Option<String> projectId = this.getProjectIdPrefix((Option<String>)Option$.MODULE$.apply((Object)tableId.getProject()));
        Option<String> option = projectId;
        if (None$.MODULE$.equals(option)) {
            return new StringBuilder(1).append(tableId.getDataset()).append(".").append(tableId.getTable()).toString();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String projectId2 = (String)some.value();
            return new StringBuilder(2).append(projectId2).append(":").append(tableId.getDataset()).append(".").append(tableId.getTable()).toString();
        }
        throw new MatchError(option);
    }

    public String getBqTableForNative(TableId tableId) {
        Option<String> projectId = this.getProjectIdPrefix((Option<String>)Option$.MODULE$.apply((Object)tableId.getProject()));
        Option<String> option = projectId;
        if (None$.MODULE$.equals(option)) {
            return new StringBuilder(1).append(tableId.getDataset()).append(".").append(tableId.getTable()).toString();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String projectId2 = (String)some.value();
            return new StringBuilder(4).append("`").append(projectId2).append(".").append(tableId.getDataset()).append(".").append(tableId.getTable()).append("`").toString();
        }
        throw new MatchError(option);
    }

    public TableId extractProjectDatasetAndTable(Option<String> databaseId, String datasetId, String tableId) {
        Option option = databaseId.filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)BigQueryJobBase$.$anonfun$extractProjectDatasetAndTable$1(x$22)));
        if (option instanceof Some) {
            Some some = (Some)option;
            String dbId = (String)some.value();
            return this.extractProjectDatasetAndTable(new StringBuilder(2).append(dbId).append(":").append(datasetId).append(".").append(tableId).toString());
        }
        if (None$.MODULE$.equals(option)) {
            return this.extractProjectDatasetAndTable(new StringBuilder(1).append(datasetId).append(".").append(tableId).toString());
        }
        throw new MatchError((Object)option);
    }

    public TableId extractProjectDatasetAndTable(String resourceId) {
        Tuple2 tuple2;
        Option project2;
        block3: {
            Tuple2 tuple22;
            block2: {
                int sepIndex = resourceId.indexOf(":");
                Tuple2 tuple23 = tuple22 = sepIndex > 0 ? new Tuple2((Object)new Some((Object)resourceId.substring(0, sepIndex)), (Object)BigQueryJobBase$.extractDatasetAndTable$1(resourceId.substring(sepIndex + 1), resourceId)) : new Tuple2((Object)None$.MODULE$, (Object)BigQueryJobBase$.extractDatasetAndTable$1(resourceId, resourceId));
                if (tuple22 == null) break block2;
                project2 = (Option)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String dataset = (String)tuple2._1();
        String table = (String)tuple2._2();
        Tuple3 tuple3 = new Tuple3((Object)project2, (Object)dataset, (Object)table);
        Option project3 = (Option)tuple3._1();
        String dataset2 = (String)tuple3._2();
        String table2 = (String)tuple3._3();
        return (TableId)project3.map((Function1 & Serializable & scala.Serializable)project -> TableId.of((String)project, (String)dataset2, (String)table2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> TableId.of((String)ServiceOptions.getDefaultProjectId(), (String)dataset2, (String)table2));
    }

    public DatasetId extractProjectDataset(String value) {
        Tuple2 tuple2;
        int sepIndex = value.indexOf(":");
        Tuple2 tuple22 = tuple2 = sepIndex > 0 ? new Tuple2((Object)new Some((Object)value.substring(0, sepIndex)), (Object)value.substring(sepIndex + 1)) : new Tuple2((Object)None$.MODULE$, (Object)value);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option project2 = (Option)tuple2._1();
        String dataset = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)project2, (Object)dataset);
        Option project3 = (Option)tuple23._1();
        String dataset2 = (String)tuple23._2();
        return (DatasetId)project3.map((Function1 & Serializable & scala.Serializable)project -> DatasetId.of((String)project, (String)dataset2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> DatasetId.of((String)ServiceOptions.getDefaultProjectId(), (String)dataset2));
    }

    private Option<String> getProjectIdPrefix(Option<String> projectId) {
        return projectId.filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)BigQueryJobBase$.$anonfun$getProjectIdPrefix$1(x$25)));
    }

    public String projectId(Option<String> outputDatabase) {
        return (String)outputDatabase.filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)BigQueryJobBase$.$anonfun$projectId$1(x$26))).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getPropertyOrEnv("SL_DATABASE")).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getPropertyOrEnv("GCP_PROJECT")).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getPropertyOrEnv("GOOGLE_CLOUD_PROJECT")).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)ServiceOptions.getDefaultProjectId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("GCP Project ID must be defined");
        });
    }

    private Option<String> getPropertyOrEnv(String envVar) {
        return Option$.MODULE$.apply((Object)System.getProperty(envVar, System.getenv(envVar)));
    }

    public Option<Credentials> ai$starlake$job$sink$bigquery$BigQueryJobBase$$bigQueryCredentials(Map<String, String> connectionOptions, Option<String> accessToken) {
        Option<String> option = accessToken;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            String token = (String)some.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Using inline access token credentials");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            GoogleCredentials cred = GoogleCredentials.create((AccessToken)new AccessToken(token, null));
            return Option$.MODULE$.apply((Object)cred);
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Using {} credentials", new Object[]{connectionOptions.apply((Object)"authType")});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String string = (String)connectionOptions.apply((Object)"authType");
            if ("APPLICATION_DEFAULT".equals(string)) {
                boolean refreshToken = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)connectionOptions.getOrElse((Object)"refreshToken", (Function0 & Serializable & scala.Serializable)() -> "true"))).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
                if (refreshToken) {
                    String[] scopes = new StringOps(Predef$.MODULE$.augmentString((String)connectionOptions.getOrElse((Object)"authScopes", (Function0 & Serializable & scala.Serializable)() -> "https://www.googleapis.com/auth/cloud-platform"))).split(',');
                    GoogleCredentials cred = GoogleCredentials.getApplicationDefault().createScoped(scopes);
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cred.refresh());
                    if (try_ instanceof Failure) {
                        BoxedUnit boxedUnit2;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Error refreshing credentials: {}", new Object[]{e.getMessage()});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        return None$.MODULE$;
                    }
                    if (try_ instanceof Success) {
                        return new Some((Object)cred);
                    }
                    throw new MatchError((Object)try_);
                }
                return Option$.MODULE$.apply((Object)GoogleCredentials.getApplicationDefault());
            }
            if ("SERVICE_ACCOUNT_JSON_KEYFILE".equals(string)) {
                ByteArrayInputStream credentialsStream = this.getJsonKeyStream(connectionOptions);
                return Option$.MODULE$.apply((Object)ServiceAccountCredentials.fromStream((InputStream)credentialsStream));
            }
            if ("USER_CREDENTIALS".equals(string)) {
                String clientId = (String)connectionOptions.apply((Object)"clientId");
                String clientSecret = (String)connectionOptions.apply((Object)"clientSecret");
                String refreshToken = (String)connectionOptions.apply((Object)"refreshToken");
                UserCredentials cred = UserCredentials.newBuilder().setClientId(clientId).setClientSecret(clientSecret).setRefreshToken(refreshToken).build();
                return Option$.MODULE$.apply((Object)cred);
            }
            if ("ACCESS_TOKEN".equals(string)) {
                String accessToken2 = (String)connectionOptions.apply((Object)"gcpAccessToken");
                GoogleCredentials cred = GoogleCredentials.create((AccessToken)new AccessToken(accessToken2, null));
                return Option$.MODULE$.apply((Object)cred);
            }
            throw new MatchError((Object)string);
        }
        throw new MatchError(option);
    }

    public Option<String> ai$starlake$job$sink$bigquery$BigQueryJobBase$$bigQueryCredentials$default$2() {
        return None$.MODULE$;
    }

    public com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials ai$starlake$job$sink$bigquery$BigQueryJobBase$$gcsCredentials(Map<String, String> connectionOptions) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Using {} Credentials from GCS", new Object[]{connectionOptions.apply((Object)"authType")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String string = (String)connectionOptions.apply((Object)"authType");
        if ("APPLICATION_DEFAULT".equals(string)) {
            String[] scopes = new StringOps(Predef$.MODULE$.augmentString((String)connectionOptions.getOrElse((Object)"authScopes", (Function0 & Serializable & scala.Serializable)() -> "https://www.googleapis.com/auth/cloud-platform"))).split(',');
            com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials cred = com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials.getApplicationDefault().createScoped(scopes);
            cred.refresh();
            return cred;
        }
        if ("SERVICE_ACCOUNT_JSON_KEYFILE".equals(string)) {
            ByteArrayInputStream credentialsStream = this.getJsonKeyStream(connectionOptions);
            return com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.ServiceAccountCredentials.fromStream((InputStream)credentialsStream);
        }
        if ("USER_CREDENTIALS".equals(string)) {
            String clientId = (String)connectionOptions.apply((Object)"clientId");
            String clientSecret = (String)connectionOptions.apply((Object)"clientSecret");
            String refreshToken = (String)connectionOptions.apply((Object)"refreshToken");
            return com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.UserCredentials.newBuilder().setClientId(clientId).setClientSecret(clientSecret).setRefreshToken(refreshToken).build();
        }
        if ("ACCESS_TOKEN".equals(string)) {
            String accessToken = (String)connectionOptions.apply((Object)"gcpAccessToken");
            return com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials.create((com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken)new com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken(accessToken, null));
        }
        throw new MatchError((Object)string);
    }

    public ByteArrayInputStream getJsonKeyStream(Map<String, String> connectionOptions) {
        String gcpSAJsonKeyAsString = this.getJsonKeyContent(connectionOptions);
        ByteArrayInputStream credentialsStream = new ByteArrayInputStream(gcpSAJsonKeyAsString.getBytes(StandardCharsets.UTF_8.name()));
        return credentialsStream;
    }

    public String getJsonKeyContent(Map<String, String> connectionOptions) {
        String gcpSAJsonKey = (String)connectionOptions.apply((Object)"jsonKeyfile");
        File path = File$.MODULE$.apply(gcpSAJsonKey, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        return this.getJsonKeyContent(path);
    }

    public String getJsonKeyContent(File path) {
        if (!path.exists(path.exists$default$1())) {
            throw new Exception(new StringBuilder(25).append("Invalid GCP SA KEY Path: ").append(path).toString());
        }
        String gcpSAJsonKeyAsString = path.contentAsString(path.contentAsString$default$1());
        return gcpSAJsonKeyAsString;
    }

    public BigQuery bigquery(Option<String> connectionRef, Option<String> accessToken, Option<String> outputDatabase, Settings settings) {
        BigQuery bigQuery;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Option connectionName = connectionRef.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)settings.appConfig().connectionRef()));
        Option connection = connectionName.flatMap((Function1 & Serializable & scala.Serializable)name -> settings.appConfig().connections().get(name));
        Map connectionOptions = (Map)connection.map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.options()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Getting BQ credentials for connection {}", new Object[]{connectionName});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("{}", new Object[]{connectionName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BigQueryOptions.Builder bqOptionsBuilder = BigQueryOptions.newBuilder().setLocation((String)connectionOptions.getOrElse((Object)"location", (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(51).append("location is required but not present in connection ").append(connectionName).toString());
        }));
        Option<Credentials> credentials = this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$bigQueryCredentials((Map<String, String>)connectionOptions, accessToken);
        BigQueryOptions.Builder bqOptions = (BigQueryOptions.Builder)bqOptionsBuilder.setProjectId(this.projectId(outputDatabase));
        Option<Credentials> option = credentials;
        if (None$.MODULE$.equals(option)) {
            bigQuery = (BigQuery)bqOptions.build().getService();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Credentials credentials2 = (Credentials)some.value();
            bigQuery = (BigQuery)((BigQueryOptions.Builder)bqOptions.setCredentials(credentials2)).build().getService();
        } else {
            throw new MatchError(option);
        }
        BigQuery bqService = bigQuery;
        return bqService;
    }

    public Try<Object> executeUpdate(String sql, String connectionRef, Option<String> accessToken, Settings settings) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            BigQuery bq = MODULE$.bigquery((Option<String>)new Some((Object)connectionRef), accessToken, (Option<String>)None$.MODULE$, settings);
            TableResult _ = bq.query(QueryJobConfiguration.of((String)sql), new BigQuery.JobOption[0]);
            return true;
        });
    }

    public static final /* synthetic */ boolean $anonfun$extractProjectDatasetAndTable$1(String x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22)).nonEmpty();
    }

    private static final Tuple2 extractDatasetAndTable$1(String str, String resourceId$1) {
        int sepIndex = str.indexOf(46);
        if (sepIndex > 0) {
            return new Tuple2((Object)str.substring(0, sepIndex), (Object)str.substring(sepIndex + 1));
        }
        throw new Exception(new StringBuilder(47).append("Dataset cannot be null in BigQuery view name (").append(resourceId$1).append(")").toString());
    }

    public static final /* synthetic */ boolean $anonfun$getProjectIdPrefix$1(String x$25) {
        return new StringOps(Predef$.MODULE$.augmentString(x$25.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$projectId$1(String x$26) {
        return new StringOps(Predef$.MODULE$.augmentString(x$26)).nonEmpty();
    }

    private BigQueryJobBase$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

