/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.config.Settings;
import ai.starlake.job.ingest.BqLoadInfo;
import ai.starlake.job.sink.bigquery.BigQueryJobBase;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.job.sink.bigquery.BigQueryJobResult;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.job.sink.bigquery.BigQueryNativeJob$;
import ai.starlake.schema.model.ClusteringInfo;
import ai.starlake.schema.model.FieldPartitionInfo;
import ai.starlake.schema.model.Format;
import ai.starlake.schema.model.Format$DSV$;
import ai.starlake.schema.model.Format$JSON$;
import ai.starlake.schema.model.Format$JSON_FLAT$;
import ai.starlake.schema.model.IamPolicyTags;
import ai.starlake.schema.model.Materialization;
import ai.starlake.schema.model.Materialization$MATERIALIZED_VIEW$;
import ai.starlake.schema.model.Materialization$TABLE$;
import ai.starlake.schema.model.Metadata;
import ai.starlake.schema.model.TableInfo$;
import ai.starlake.sql.SQLUtils$;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import better.files.File$;
import com.google.api.gax.paging.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.LoadConfiguration;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.MaterializedViewDefinition;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.manticore.jsqlformatter.JSQLFormatter;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.util.UUID;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import org.threeten.bp.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0001\t}e\u0001B\u0016-\u0001]B\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t%\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0015\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002\u00032\u0001\u0005\u000b\u0007I1A2\t\u0011)\u0004!\u0011!Q\u0001\n\u0011DQa\u001b\u0001\u0005\u00021DQ\u0001\u001e\u0001\u0005BUDQA\u001e\u0001\u0005\u0002]D\u0011\"a\t\u0001#\u0003%\t!!\n\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAE\u0001\u0011\u0005\u00111\u0012\u0005\b\u0003K\u0003A\u0011BAT\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!a1\u0001\t\u0013\t)\rC\u0004\u0002n\u0002!I!a<\t\u000f\u0005E\b\u0001\"\u0001\u0002t\"I!Q\u0003\u0001\u0012\u0002\u0013\u0005!q\u0003\u0005\n\u00057\u0001\u0011\u0013!C\u0001\u0005;A\u0011B!\t\u0001#\u0003%\tA!\b\t\u0013\t\r\u0002!%A\u0005\u0002\t\u0015\u0002b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005{\u0001A\u0011\tB \u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017B\u0011Ba\u0016\u0001#\u0003%\tAa\u0006\t\u000f\te\u0003\u0001\"\u0001\u0003\\!I!q\f\u0001\u0012\u0002\u0013\u0005!q\u0003\u0005\b\u0005C\u0002A\u0011\u0001B2\u0011%\u0011y\u0007AI\u0001\n\u0003\u00119\u0002C\u0005\u0003r\u0001\t\n\u0011\"\u0001\u0003t!I!q\u000f\u0001\u0012\u0002\u0013\u0005!Q\u0004\u0005\b\u0005s\u0002A\u0011\u0001B>\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u0003C\u0011Ba#\u0001#\u0003%\tAa\u0006\t\u0013\t5\u0005!%A\u0005\u0002\t\u0015r!\u0003BHY\u0005\u0005\t\u0012\u0001BI\r!YC&!A\t\u0002\tM\u0005BB6(\t\u0003\u0011)\nC\u0005\u0003\u0018\u001e\n\n\u0011\"\u0001\u0003\u001a\"I!QT\u0014\u0012\u0002\u0013\u0005!Q\u0004\u0002\u0012\u0005&<\u0017+^3ss:\u000bG/\u001b<f\u0015>\u0014'BA\u0017/\u0003!\u0011\u0017nZ9vKJL(BA\u00181\u0003\u0011\u0019\u0018N\\6\u000b\u0005E\u0012\u0014a\u00016pE*\u00111\u0007N\u0001\tgR\f'\u000f\\1lK*\tQ'\u0001\u0002bS\u000e\u00011\u0003\u0002\u00019}\u0011\u0003\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012a!\u00118z%\u00164\u0007CA C\u001b\u0005\u0001%BA!3\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0005IA\u0004K_\n\u0014\u0015m]3\u0011\u0005\u00153U\"\u0001\u0017\n\u0005\u001dc#a\u0004\"jOF+XM]=K_\n\u0014\u0015m]3\u0002\u0013\rd\u0017nQ8oM&<W#\u0001&\u0011\u0005\u0015[\u0015B\u0001'-\u0005I\u0011\u0015nZ)vKJLHj\\1e\u0007>tg-[4\u0002\u0015\rd\u0017nQ8oM&<\u0007%A\u0002tc2\u0004\"\u0001U,\u000f\u0005E+\u0006C\u0001*;\u001b\u0005\u0019&B\u0001+7\u0003\u0019a$o\\8u}%\u0011aKO\u0001\u0007!J,G-\u001a4\n\u0005aK&AB*ue&twM\u0003\u0002Wu\u0005q!/Z:vYR\u0004\u0016mZ3TSj,\u0007CA\u001d]\u0013\ti&H\u0001\u0003M_:<\u0017\u0001\u00046pERKW.Z8vi6\u001b\bcA\u001da7&\u0011\u0011M\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0011M,G\u000f^5oON,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003OJ\naaY8oM&<\u0017BA5g\u0005!\u0019V\r\u001e;j]\u001e\u001c\u0018!C:fiRLgnZ:!\u0003\u0019a\u0014N\\5u}Q)Q\u000e]9sgR\u0011an\u001c\t\u0003\u000b\u0002AQA\u0019\u0005A\u0004\u0011DQ\u0001\u0013\u0005A\u0002)CQA\u0014\u0005A\u0002=CqA\u0017\u0005\u0011\u0002\u0003\u00071\fC\u0004_\u0011A\u0005\t\u0019A0\u0002\t9\fW.Z\u000b\u0002\u001f\u0006iAn\\1e!\u0006$\bn\u001d+p\u0005F#R\u0001_A\u0005\u0003;\u00012!\u001f?\u007f\u001b\u0005Q(BA>;\u0003\u0011)H/\u001b7\n\u0005uT(a\u0001+ssB\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002a\u00051\u0011N\\4fgRLA!a\u0002\u0002\u0002\tQ!)\u001d'pC\u0012LeNZ8\t\u000f\u0005-!\u00021\u0001\u0002\u000e\u0005IA/\u00192mK&sgm\u001c\t\u0005\u0003\u001f\tI\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0015iw\u000eZ3m\u0015\r\t9BM\u0001\u0007g\u000eDW-\\1\n\t\u0005m\u0011\u0011\u0003\u0002\n)\u0006\u0014G.Z%oM>D\u0011\"a\b\u000b!\u0003\u0005\r!!\t\u00025Q\f'\r\\3J]\u001a|w+\u001b;i\t\u00164\u0017-\u001e7u\u0007>dW/\u001c8\u0011\te\u0002\u0017QB\u0001\u0018Y>\fG\rU1uQN$vNQ)%I\u00164\u0017-\u001e7uII*\"!a\n+\t\u0005\u0005\u0012\u0011F\u0016\u0003\u0003W\u0001B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0007\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002:\u0005=\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061Bn\\1e\u0019>\u001c\u0017\r\u001c$jY\u0016\u0004\u0016\r\u001e5t)>\u0014\u0015\u000b\u0006\u0005\u0002@\u0005U\u0013qLA5!\u0011\t\t%!\u0015\u000e\u0005\u0005\r#bA\u0017\u0002F)!\u0011qIA%\u0003\u0015\u0019Gn\\;e\u0015\u0011\tY%!\u0014\u0002\r\u001d|wn\u001a7f\u0015\t\ty%A\u0002d_6LA!a\u0015\u0002D\t\u0019!j\u001c2\t\u000f\u0005]C\u00021\u0001\u0002Z\u0005A!-]*dQ\u0016l\u0017\r\u0005\u0003\u0002B\u0005m\u0013\u0002BA/\u0003\u0007\u0012aaU2iK6\f\u0007bBA1\u0019\u0001\u0007\u00111M\u0001\u000eM>\u0014X.\u0019;PaRLwN\\:\u0011\t\u0005\u0005\u0013QM\u0005\u0005\u0003O\n\u0019EA\u0007G_Jl\u0017\r^(qi&|gn\u001d\u0005\b\u0003Wb\u0001\u0019AA7\u0003)\u0019x.\u001e:dKV\u0013\u0016j\u001d\t\u0006\u0003_\nIh\u0014\b\u0005\u0003c\n)HD\u0002S\u0003gJ\u0011aO\u0005\u0004\u0003oR\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003w\niH\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t9HO\u0001\u0015]\u0016<(j\u001c2JI^KG\u000f\u001b'pG\u0006$\u0018n\u001c8\u0015\u0005\u0005\r\u0005\u0003BA!\u0003\u000bKA!a\"\u0002D\t)!j\u001c2JI\u0006aq-\u001a;UC\ndW-\u00138g_R1\u0011QBAG\u0003/Cq!a$\u000f\u0001\u0004\t\t*A\u0004uC\ndW-\u00133\u0011\t\u0005\u0005\u00131S\u0005\u0005\u0003+\u000b\u0019EA\u0004UC\ndW-\u00133\t\u000f\u0005ee\u00021\u0001\u0002\u001c\u0006QAo\u001c\"R'\u000eDW-\\1\u0011\u000fe\ni*!)\u0002Z%\u0019\u0011q\u0014\u001e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\b\u0003GKA!!\u0018\u0002\u0012\u0005a!-\u001d'pC\u0012\u001cuN\u001c4jORA\u0011\u0011VAX\u0003c\u000b\u0019\f\u0005\u0003\u0002B\u0005-\u0016\u0002BAW\u0003\u0007\u0012A\u0003T8bI*{'mQ8oM&<WO]1uS>t\u0007bBA,\u001f\u0001\u0007\u0011\u0011\f\u0005\b\u0003Cz\u0001\u0019AA2\u0011\u0019\tYg\u0004a\u0001\u001f\u0006!\"-\u001d'pC\u0012dunY1GS2,7i\u001c8gS\u001e$b!!/\u0002@\u0006\u0005\u0007\u0003BA!\u0003wKA!!0\u0002D\tIrK]5uK\u000eC\u0017M\u001c8fY\u000e{gNZ5hkJ\fG/[8o\u0011\u001d\t9\u0006\u0005a\u0001\u00033Bq!!\u0019\u0011\u0001\u0004\t\u0019'A\bd_:4\u0017nZ;sK\n\u000bHj\\1e+\u0011\t9-!4\u0015\r\u0005%\u0017q]Av!\u0011\tY-!4\r\u0001\u00119\u0011qZ\tC\u0002\u0005E'!\u0001+\u0012\t\u0005M\u0017\u0011\u001c\t\u0004s\u0005U\u0017bAAlu\t9aj\u001c;iS:<\u0007\u0003BAn\u0003CtA!!\u0011\u0002^&!\u0011q\\A\"\u0003Eau.\u00193D_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003G\f)OA\u0004Ck&dG-\u001a:\u000b\t\u0005}\u00171\t\u0005\b\u0003S\f\u0002\u0019AAe\u0003)aw.\u00193D_:4\u0017n\u001a\u0005\b\u0003/\n\u0002\u0019AA-\u0003M\u0011\u0017\u000fT8bI\u001a{'/\\1u\u001fB$\u0018n\u001c8t)\t\t\u0019'A\nsk:Le\u000e^3sC\u000e$\u0018N^3Rk\u0016\u0014\u0018\u0010\u0006\u0006\u0002v\u0006u(1\u0001B\u0004\u0005\u0017\u0001B!\u001f?\u0002xB\u0019Q)!?\n\u0007\u0005mHFA\tCS\u001e\fV/\u001a:z\u0015>\u0014'+Z:vYRD\u0011\"a@\u0014!\u0003\u0005\rA!\u0001\u0002\u000fQD\u0017n]*rYB\u0019\u0011\bY(\t\u0011\t\u00151\u0003%AA\u0002}\u000b\u0001\u0002]1hKNK'0\u001a\u0005\t\u0005\u0013\u0019\u0002\u0013!a\u0001?\u0006\t\u0012/^3ss*{'\rV5nK>,H/T:\t\u0013\t51\u0003%AA\u0002\t=\u0011A\u00023ssJ+h\u000eE\u0002:\u0005#I1Aa\u0005;\u0005\u001d\u0011un\u001c7fC:\fQD];o\u0013:$XM]1di&4X-U;fef$C-\u001a4bk2$H%M\u000b\u0003\u00053QCA!\u0001\u0002*\u0005i\"/\u001e8J]R,'/Y2uSZ,\u0017+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0003 )\u001aq,!\u000b\u0002;I,h.\u00138uKJ\f7\r^5wKF+XM]=%I\u00164\u0017-\u001e7uIM\nQD];o\u0013:$XM]1di&4X-U;fef$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005OQCAa\u0004\u0002*\u0005\u0019\u0012\r\u001a3V\t\u001a#v.U;fef\u001cuN\u001c4jOR!!Q\u0006B\u001d!\u0011\u0011yC!\u000e\u000f\t\u0005\u0005#\u0011G\u0005\u0005\u0005g\t\u0019%A\u000bRk\u0016\u0014\u0018PS8c\u0007>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005\r(q\u0007\u0006\u0005\u0005g\t\u0019\u0005C\u0004\u0003<a\u0001\rA!\f\u0002\u0017E,XM]=D_:4\u0017nZ\u0001\u0004eVtGC\u0001B!!\u0011IHPa\u0011\u0011\u0007}\u0012)%C\u0002\u0003H\u0001\u0013\u0011BS8c%\u0016\u001cX\u000f\u001c;\u0002!I,h.\u00118e'&t7.Q:WS\u0016<H\u0003\u0002B'\u0005+\u0002B!\u001f?\u0003PA!\u0011\u0011\tB)\u0013\u0011\u0011\u0019&a\u0011\u0003\u000bQ\u000b'\r\\3\t\u0013\u0005}(\u0004%AA\u0002\t\u0005\u0011A\u0007:v]\u0006sGmU5oW\u0006\u001bh+[3xI\u0011,g-Y;mi\u0012\n\u0014\u0001\b:v]\u0006sGmU5oW\u0006\u001bX*\u0019;fe&\fG.\u001b>fIZKWm\u001e\u000b\u0005\u0005\u001b\u0012i\u0006C\u0005\u0002\u0000r\u0001\n\u00111\u0001\u0003\u0002\u00051#/\u001e8B]\u0012\u001c\u0016N\\6Bg6\u000bG/\u001a:jC2L'0\u001a3WS\u0016<H\u0005Z3gCVdG\u000fJ\u0019\u0002#I,h.\u00118e'&t7.Q:UC\ndW\r\u0006\u0005\u0002v\n\u0015$q\rB7\u0011%\tyP\bI\u0001\u0002\u0004\u0011\t\u0001C\u0005\u0003jy\u0001\n\u00111\u0001\u0003l\u0005\tB/\u0019:hKR$\u0016M\u00197f'\u000eDW-\\1\u0011\te\u0002\u0017\u0011\f\u0005\t\u0005\u0013q\u0002\u0013!a\u0001?\u0006Y\"/\u001e8B]\u0012\u001c\u0016N\\6BgR\u000b'\r\\3%I\u00164\u0017-\u001e7uIE\n1D];o\u0003:$7+\u001b8l\u0003N$\u0016M\u00197fI\u0011,g-Y;mi\u0012\u0012TC\u0001B;U\u0011\u0011Y'!\u000b\u00027I,h.\u00118e'&t7.Q:UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00134\u0003!9W\r\u001e+bE2,G\u0003\u0002B'\u0005{Bq!a$#\u0001\u0004\t\t*A\u0007sk:\u0014\u0015\r^2i#V,'/\u001f\u000b\u0007\u0005\u0007\u0013)Ia\"\u0011\ted\u0018q\b\u0005\n\u0003\u007f\u001c\u0003\u0013!a\u0001\u0005\u0003A\u0011B!#$!\u0003\u0005\rAa\u0004\u0002\t]\f\u0017\u000e^\u0001\u0018eVt')\u0019;dQF+XM]=%I\u00164\u0017-\u001e7uIE\nqC];o\u0005\u0006$8\r[)vKJLH\u0005Z3gCVdG\u000f\n\u001a\u0002#\tKw-U;feft\u0015\r^5wK*{'\r\u0005\u0002FOM\u0011q\u0005\u000f\u000b\u0003\u0005#\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTC\u0001BNU\rY\u0016\u0011F\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b")
public class BigQueryNativeJob
implements JobBase,
BigQueryJobBase {
    private final BigQueryLoadConfig cliConfig;
    private final String sql;
    private final long resultPageSize;
    private final Option<Object> jobTimeoutMs;
    private final Settings settings;
    private Option<String> connectionName;
    private Option<Settings.Connection> connection;
    private Map<String, String> connectionOptions;
    private Option<Storage> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage;
    private Option<BigQuery> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery;
    private TableId tableId;
    private DatasetId datasetId;
    private String bqTable;
    private String bqNativeTable;
    private final String appName;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$4() {
        return BigQueryNativeJob$.MODULE$.$lessinit$greater$default$4();
    }

    public static long $lessinit$greater$default$3() {
        return BigQueryNativeJob$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public Try<BoxedUnit> applyRLSAndCLS(boolean forceApply, Settings settings) {
        return BigQueryJobBase.applyRLSAndCLS$(this, forceApply, settings);
    }

    @Override
    public boolean applyRLSAndCLS$default$1() {
        return BigQueryJobBase.applyRLSAndCLS$default$1$(this);
    }

    @Override
    public BigQuery bigquery(boolean alwaysCreate, Option<String> accessToken, Settings settings) {
        return BigQueryJobBase.bigquery$(this, alwaysCreate, accessToken, settings);
    }

    @Override
    public boolean bigquery$default$1() {
        return BigQueryJobBase.bigquery$default$1$(this);
    }

    @Override
    public Storage gcsStorage(Settings settings) {
        return BigQueryJobBase.gcsStorage$(this, settings);
    }

    @Override
    public Try<BoxedUnit> applyIamPolicyTags(IamPolicyTags iamPolicyTags, Settings settings) {
        return BigQueryJobBase.applyIamPolicyTags$(this, iamPolicyTags, settings);
    }

    @Override
    public List<String> prepareRLS() {
        return BigQueryJobBase.prepareRLS$(this);
    }

    @Override
    public <T> Try<T> recoverBigqueryException(Function0<T> bigqueryProcess) {
        return BigQueryJobBase.recoverBigqueryException$(this, bigqueryProcess);
    }

    @Override
    public boolean tableExists(TableId tableId, Settings settings) {
        return BigQueryJobBase.tableExists$(this, tableId, settings);
    }

    @Override
    public boolean tableExists(Option<String> databaseName, String datasetName, String tableName, Settings settings) {
        return BigQueryJobBase.tableExists$(this, databaseName, datasetName, tableName, settings);
    }

    @Override
    public boolean dropTable(TableId tableId, Settings settings) {
        return BigQueryJobBase.dropTable$(this, tableId, settings);
    }

    @Override
    public boolean dropTable(Option<String> databaseName, String datasetName, String tableName, Settings settings) {
        return BigQueryJobBase.dropTable$(this, databaseName, datasetName, tableName, settings);
    }

    @Override
    public TableId getTableId(Option<String> databaseName, String datasetName, String tableName) {
        return BigQueryJobBase.getTableId$(this, databaseName, datasetName, tableName);
    }

    @Override
    public Schema getBQSchema(TableId tableId, Settings settings) {
        return BigQueryJobBase.getBQSchema$(this, tableId, settings);
    }

    @Override
    public Try<StandardTableDefinition> updateTableSchema(TableId tableId, Schema tableSchema, Settings settings) {
        return BigQueryJobBase.updateTableSchema$(this, tableId, tableSchema, settings);
    }

    @Override
    public Try<Dataset> getOrCreateDataset(Option<String> domainDescription, Option<String> datasetName, Settings settings) {
        return BigQueryJobBase.getOrCreateDataset$(this, domainDescription, datasetName, settings);
    }

    @Override
    public Option<String> getOrCreateDataset$default$2() {
        return BigQueryJobBase.getOrCreateDataset$default$2$(this);
    }

    @Override
    public Try<Tuple2<Table, StandardTableDefinition>> getOrCreateTable(Option<String> domainDescription, ai.starlake.schema.model.TableInfo tableInfo, Option<org.apache.spark.sql.Dataset<Row>> dataFrame, Settings settings) {
        return BigQueryJobBase.getOrCreateTable$(this, domainDescription, tableInfo, dataFrame, settings);
    }

    @Override
    public void setTagsOnTable(Table table) {
        BigQueryJobBase.setTagsOnTable$(this, table);
    }

    @Override
    public Table updateTableDescription(Table bqTable, String description, Settings settings) {
        return BigQueryJobBase.updateTableDescription$(this, bqTable, description, settings);
    }

    @Override
    public Map<String, String> getFieldsDescriptionSource(String sql, Settings settings) {
        return BigQueryJobBase.getFieldsDescriptionSource$(this, sql, settings);
    }

    @Override
    public Table updateColumnsDescription(Schema schema, Settings settings) {
        return BigQueryJobBase.updateColumnsDescription$(this, schema, settings);
    }

    @Override
    public TimePartitioning.Builder timePartitioning(String partitionField, Option<Object> days, boolean requirePartitionFilter) {
        return BigQueryJobBase.timePartitioning$(this, partitionField, days, requirePartitionFilter);
    }

    @Override
    public Option<Object> timePartitioning$default$2() {
        return BigQueryJobBase.timePartitioning$default$2$(this);
    }

    @Override
    public StandardTableDefinition getTableDefinition(TableId tableId, Settings settings) {
        return BigQueryJobBase.getTableDefinition$(this, tableId, settings);
    }

    @Override
    public String applicationId() {
        return JobBase.applicationId$(this);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(org.apache.spark.sql.Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    private Option<String> connectionName$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.connectionName = BigQueryJobBase.connectionName$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.connectionName;
    }

    @Override
    public Option<String> connectionName() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.connectionName$lzycompute();
        }
        return this.connectionName;
    }

    private Option<Settings.Connection> connection$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.connection = BigQueryJobBase.connection$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.connection;
    }

    @Override
    public Option<Settings.Connection> connection() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.connection$lzycompute();
        }
        return this.connection;
    }

    private Map<String, String> connectionOptions$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.connectionOptions = BigQueryJobBase.connectionOptions$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.connectionOptions;
    }

    @Override
    public Map<String, String> connectionOptions() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.connectionOptions$lzycompute();
        }
        return this.connectionOptions;
    }

    @Override
    public Option<Storage> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage() {
        return this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage_$eq(Option<Storage> x$1) {
        this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage = x$1;
    }

    @Override
    public Option<BigQuery> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery() {
        return this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery_$eq(Option<BigQuery> x$1) {
        this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery = x$1;
    }

    private TableId tableId$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.tableId = BigQueryJobBase.tableId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.tableId;
    }

    @Override
    public TableId tableId() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.tableId$lzycompute();
        }
        return this.tableId;
    }

    private DatasetId datasetId$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.datasetId = BigQueryJobBase.datasetId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.datasetId;
    }

    @Override
    public DatasetId datasetId() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.datasetId$lzycompute();
        }
        return this.datasetId;
    }

    private String bqTable$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.bqTable = BigQueryJobBase.bqTable$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.bqTable;
    }

    @Override
    public String bqTable() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.bqTable$lzycompute();
        }
        return this.bqTable;
    }

    private String bqNativeTable$lzycompute() {
        BigQueryNativeJob bigQueryNativeJob = this;
        synchronized (bigQueryNativeJob) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.bqNativeTable = BigQueryJobBase.bqNativeTable$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.bqNativeTable;
    }

    @Override
    public String bqNativeTable() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.bqNativeTable$lzycompute();
        }
        return this.bqNativeTable;
    }

    @Override
    public String appName() {
        return this.appName;
    }

    @Override
    public void ai$starlake$utils$JobBase$_setter_$appName_$eq(String x$1) {
        this.appName = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public BigQueryLoadConfig cliConfig() {
        return this.cliConfig;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return new StringBuilder(7).append("bqload-").append(this.bqNativeTable()).toString();
    }

    public Try<BqLoadInfo> loadPathsToBQ(ai.starlake.schema.model.TableInfo tableInfo, Option<ai.starlake.schema.model.TableInfo> tableInfoWithDefaultColumn) {
        return this.getOrCreateTable(this.cliConfig().domainDescription(), (ai.starlake.schema.model.TableInfo)tableInfoWithDefaultColumn.getOrElse((Function0 & Serializable & scala.Serializable)() -> tableInfo), (Option<org.apache.spark.sql.Dataset<Row>>)None$.MODULE$, this.settings()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Schema bqSchema = (Schema)tableInfo.maybeSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new RuntimeException("Should never happen");
            });
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("BigQuery Schema: {}", new Object[]{bqSchema});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            FormatOptions formatOptions = this.bqLoadFormatOptions();
            Either<String, org.apache.spark.sql.Dataset<Row>> either = this.cliConfig().source();
            if (either instanceof Left) {
                Left left = (Left)either;
                String sourceURIs = (String)left.value();
                String uri = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceURIs.split(","))).head();
                boolean localFiles = uri.startsWith("file:");
                return this.recoverBigqueryException((Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    Job job;
                    Job job2;
                    if (localFiles) {
                        job2 = this.loadLocalFilePathsToBQ(bqSchema, formatOptions, (Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])sourceURIs.split(",")));
                    } else {
                        LoadJobConfiguration loadConfig = this.bqLoadConfig(bqSchema, formatOptions, sourceURIs);
                        JobId jobId = this.newJobIdWithLocation();
                        Option<String> x$1 = this.cliConfig().accessToken();
                        boolean x$2 = this.bigquery$default$1();
                        job2 = job = this.bigquery(x$2, x$1, this.settings()).create(JobInfo.newBuilder((JobConfiguration)loadConfig).setJobId(jobId).build(), new BigQuery.JobOption[0]);
                    }
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Waiting for job {}", new Object[]{job.getJobId()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return job.waitFor(new RetryOption[]{RetryOption.totalTimeout((Duration)Duration.ofMillis((long)BoxesRunTime.unboxToLong((Object)$this.jobTimeoutMs.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.settings().appConfig().longJobTimeoutMs()))))});
                }).map((Function1 & Serializable & scala.Serializable)jobResult -> {
                    if (Option$.MODULE$.apply((Object)jobResult.getStatus().getError()).isEmpty()) {
                        BoxedUnit boxedUnit;
                        JobStatistics.LoadStatistics stats = (JobStatistics.LoadStatistics)jobResult.getStatistics();
                        this.applyRLSAndCLS(this.applyRLSAndCLS$default$1(), this.settings()).recover((PartialFunction)new scala.Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ BigQueryNativeJob $outer;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                Utils$.MODULE$.logException(this.$outer.logger(), A1);
                                throw A1;
                            }

                            public final boolean isDefinedAt(Throwable x1) {
                                Throwable throwable = x1;
                                return true;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("bq-ingestion-summary -> files: [{}], domain: {}, schema: {}, input: {}, accepted: {}, rejected:{}", new Object[]{sourceURIs, this.tableId().getDataset(), this.tableId().getTable(), BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(stats.getOutputRows()) + Predef$.MODULE$.Long2long(stats.getBadRecords()))), stats.getOutputRows(), stats.getBadRecords()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return new BqLoadInfo(Predef$.MODULE$.Long2long(stats.getOutputRows()), Predef$.MODULE$.Long2long(stats.getBadRecords()), new BigQueryJobResult((Option<TableResult>)None$.MODULE$, Predef$.MODULE$.Long2long(stats.getInputBytes()), (Option<Job>)new Some(jobResult)));
                    }
                    throw new Exception(new StringBuilder(59).append("BigQuery was unable to load into the table due to an error:").append(jobResult.getStatus().getError()).toString());
                });
            }
            if (either instanceof Right) {
                throw new Exception("Should never happen");
            }
            throw new MatchError(either);
        }).flatten(Predef$.MODULE$.$conforms()));
    }

    public Option<ai.starlake.schema.model.TableInfo> loadPathsToBQ$default$2() {
        return None$.MODULE$;
    }

    private Job loadLocalFilePathsToBQ(Schema bqSchema, FormatOptions formatOptions, Iterable<String> sourceURIs) {
        WriteChannelConfiguration loadConfig = this.bqLoadLocaFileConfig(bqSchema, formatOptions);
        JobId jobId = this.newJobIdWithLocation();
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> x$1 = this.cliConfig().accessToken();
            boolean x$2 = this.bigquery$default$1();
            return this.bigquery(x$2, x$1, this.settings()).writer(jobId, loadConfig);
        }, (Function1 & Serializable & scala.Serializable)writer -> {
            BigQueryNativeJob.$anonfun$loadLocalFilePathsToBQ$2(sourceURIs, writer);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Option<String> x$3 = this.cliConfig().accessToken();
        boolean x$4 = this.bigquery$default$1();
        return this.bigquery(x$4, x$3, this.settings()).getJob(jobId, new BigQuery.JobOption[0]);
    }

    private JobId newJobIdWithLocation() {
        String jobName = UUID.randomUUID().toString();
        JobId.Builder jobIdBuilder = JobId.newBuilder().setJob(jobName);
        jobIdBuilder.setProject(BigQueryJobBase$.MODULE$.projectId(this.cliConfig().outputDatabase()));
        jobIdBuilder.setLocation((String)this.connectionOptions().getOrElse((Object)"location", (Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(51).append("location is required but not present in connection ").append(this.connectionName()).toString());
        }));
        JobId jobId = jobIdBuilder.build();
        return jobId;
    }

    public ai.starlake.schema.model.TableInfo getTableInfo(TableId tableId, Function1<ai.starlake.schema.model.Schema, Schema> toBQSchema) {
        Seq<String> seq;
        return new ai.starlake.schema.model.TableInfo(tableId, this.cliConfig().outputTableDesc(), (Option<Schema>)this.cliConfig().starlakeSchema().map(toBQSchema), (Option<FieldPartitionInfo>)this.cliConfig().outputPartition().map((Function1 & Serializable & scala.Serializable)partitionField -> new FieldPartitionInfo((String)partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter())), (Option<ClusteringInfo>)(Nil$.MODULE$.equals(seq = this.cliConfig().outputClustering()) ? None$.MODULE$ : new Some((Object)new ClusteringInfo((List<String>)this.cliConfig().outputClustering().toList()))), TableInfo$.MODULE$.apply$default$6());
    }

    private LoadJobConfiguration bqLoadConfig(Schema bqSchema, FormatOptions formatOptions, String sourceURIs) {
        LoadJobConfiguration.Builder loadConfig = LoadJobConfiguration.newBuilder((TableId)this.tableId(), (java.util.List)((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceURIs.split(","))).toList()).asJava()), (FormatOptions)formatOptions);
        return this.configureBqLoad(loadConfig, bqSchema).build();
    }

    private WriteChannelConfiguration bqLoadLocaFileConfig(Schema bqSchema, FormatOptions formatOptions) {
        WriteChannelConfiguration.Builder loadConfig = WriteChannelConfiguration.newBuilder((TableId)this.tableId()).setFormatOptions(formatOptions);
        return this.configureBqLoad(loadConfig, bqSchema).build();
    }

    private <T extends LoadConfiguration.Builder> T configureBqLoad(T loadConfig, Schema bqSchema) {
        block7: {
            loadConfig.setIgnoreUnknownValues(Predef$.MODULE$.boolean2Boolean(true)).setCreateDisposition(JobInfo.CreateDisposition.valueOf((String)this.cliConfig().createDisposition())).setWriteDisposition(JobInfo.WriteDisposition.valueOf((String)this.cliConfig().writeDisposition())).setSchema(bqSchema);
            String string = this.cliConfig().writeDisposition();
            String string2 = JobInfo.WriteDisposition.WRITE_APPEND.toString();
            Object object = !(string != null ? !string.equals(string2) : string2 != null) ? loadConfig.setSchemaUpdateOptions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION, (List)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION, (List)Nil$.MODULE$))).asJava()) : BoxedUnit.UNIT;
            Object object2 = !this.settings().appConfig().rejectAllOnError() ? loadConfig.setMaxBadRecords(Predef$.MODULE$.int2Integer(this.settings().appConfig().rejectMaxRecords())) : BoxedUnit.UNIT;
            Option<String> option = this.cliConfig().outputPartition();
            if (option instanceof Some) {
                Some some = (Some)option;
                String partitionField = (String)some.value();
                TimePartitioning partitioning = this.timePartitioning(partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter()).build();
                loadConfig.setTimePartitioning(partitioning);
            } else if (None$.MODULE$.equals(option)) {
            } else {
                throw new MatchError(option);
            }
            Seq<String> seq = this.cliConfig().outputClustering();
            if (Nil$.MODULE$.equals(seq)) {
            } else {
                Clustering clustering = Clustering.newBuilder().setFields((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(seq).asJava()).build();
                loadConfig.setClustering(clustering);
            }
            Option option2 = this.cliConfig().starlakeSchema().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.metadata());
            if (!(option2 instanceof Some)) break block7;
            Some some = (Some)option2;
            Metadata metadata = (Metadata)some.value();
            Format format = metadata.resolveFormat();
            if (((Object)Format$DSV$.MODULE$).equals(format)) {
                metadata.nullValue().foreach((Function1 & Serializable & scala.Serializable)x$1 -> loadConfig.setNullMarker(x$1));
            }
        }
        return loadConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FormatOptions bqLoadFormatOptions() {
        Option option = this.cliConfig().starlakeSchema().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.metadata());
        if (option instanceof Some) {
            FormatOptions formatOptions;
            Some some = (Some)option;
            Metadata metadata = (Metadata)some.value();
            Format format = metadata.resolveFormat();
            if (((Object)Format$DSV$.MODULE$).equals(format)) {
                CsvOptions.Builder formatOptions2 = CsvOptions.newBuilder().setAllowQuotedNewLines(true).setAllowJaggedRows(true);
                Object object = Predef$.MODULE$.Boolean2boolean(metadata.resolveWithHeader()) ? formatOptions2.setSkipLeadingRows(1L).build() : BoxedUnit.UNIT;
                formatOptions2.setEncoding(metadata.resolveEncoding());
                formatOptions2.setFieldDelimiter(metadata.resolveSeparator());
                metadata.quote().map((Function1 & Serializable & scala.Serializable)quote -> formatOptions2.setQuote(quote));
                formatOptions2.setAllowJaggedRows(true);
                formatOptions = formatOptions2.build();
                return formatOptions;
            } else {
                if (!(((Object)Format$JSON$.MODULE$).equals(format) ? true : ((Object)Format$JSON_FLAT$.MODULE$).equals(format))) throw new Exception(new StringBuilder(21).append("Should never happen: ").append(metadata.resolveFormat()).toString());
                formatOptions = FormatOptions.json();
            }
            return formatOptions;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            throw new Exception("Should never happen");
        }
    }

    public Try<BigQueryJobResult> runInteractiveQuery(Option<String> thisSql, Option<Object> pageSize, Option<Object> queryJobTimeoutMs, boolean dryRun) {
        Try result;
        BoxedUnit boxedUnit;
        String targetSQL = ((String)thisSql.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.sql)).trim();
        if (targetSQL.startsWith("DESCRIBE")) {
            Option<String> x$12 = this.cliConfig().accessToken();
            boolean x$2 = this.bigquery$default$1();
            Table table = this.bigquery(x$2, x$12, this.settings()).getTable(this.tableId(), new BigQuery.TableOption[0]);
            Schema bqSchema = table.getDefinition().getSchema();
            return new Success((Object)new BigQueryJobResult((Option<TableResult>)new Some((Object)TableResult.newBuilder().setTotalRows(Predef$.MODULE$.long2Long(0L)).setPageNoSchema((Page)new PageImpl(null, null, null)).setSchema(bqSchema).build()), -1L, (Option<Job>)None$.MODULE$));
        }
        QueryJobConfiguration.Builder queryConfig = QueryJobConfiguration.newBuilder((String)targetSQL).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true)).setMaximumBytesBilled((Long)this.connectionOptions().get((Object)"maximumBytesBilled").map((Function1 & Serializable & scala.Serializable)x$1 -> Long.valueOf(x$1)).orNull(Predef$.MODULE$.$conforms()));
        String sqlId = UUID.randomUUID().toString();
        String formattedSQL = SQLUtils$.MODULE$.format(targetSQL, JSQLFormatter.OutputFormat.PLAIN);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("running BigQuery statement with Id {}: {}", new Object[]{sqlId, formattedSQL});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        QueryJobConfiguration.Builder queryConfigWithUDF = this.addUDFToQueryConfig(queryConfig);
        QueryJobConfiguration finalConfiguration = queryConfigWithUDF.setPriority(QueryJobConfiguration.Priority.INTERACTIVE).setDryRun(Predef$.MODULE$.boolean2Boolean(dryRun)).build();
        Try try_ = result = this.recoverBigqueryException((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            JobId jobId = this.newJobIdWithLocation();
            Option<String> x$3 = this.cliConfig().accessToken();
            boolean x$4 = this.bigquery$default$1();
            Job queryJob = this.bigquery(x$4, x$3, this.settings()).create(JobInfo.newBuilder((JobConfiguration)finalConfiguration).setJobId(jobId).build(), new BigQuery.JobOption[0]);
            if (!dryRun) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Waiting for job {}", new Object[]{jobId});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return queryJob.waitFor(new RetryOption[]{RetryOption.maxAttempts((int)0), RetryOption.totalTimeout((Duration)Duration.ofMinutes((long)BoxesRunTime.unboxToLong((Object)queryJobTimeoutMs.orElse((Function0 & Serializable & scala.Serializable)() -> $this.jobTimeoutMs).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.settings().appConfig().longJobTimeoutMs()))))});
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Dry run {}", new Object[]{jobId});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return queryJob;
        }).map((Function1 & Serializable & scala.Serializable)jobResult -> {
            Long totalBytesProcessed = ((JobStatistics.QueryStatistics)jobResult.getStatistics()).getTotalBytesProcessed();
            if (!dryRun) {
                BoxedUnit boxedUnit;
                TableResult results = jobResult.getQueryResults(new BigQuery.QueryResultsOption[]{BigQuery.QueryResultsOption.pageSize((long)BoxesRunTime.unboxToLong((Object)pageSize.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.resultPageSize)))});
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Query large results performed successfully on query with Id {}: {} rows returned.", new Object[]{sqlId, BoxesRunTime.boxToLong((long)results.getTotalRows())});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new BigQueryJobResult((Option<TableResult>)new Some((Object)results), Predef$.MODULE$.Long2long(totalBytesProcessed), (Option<Job>)new Some(jobResult));
            }
            return new BigQueryJobResult((Option<TableResult>)None$.MODULE$, Predef$.MODULE$.Long2long(totalBytesProcessed), (Option<Job>)new Some(jobResult));
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit2;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(43).append("Error while running BigQuery query with id ").append(sqlId).toString(), new Object[]{e.getMessage()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return new Failure(e);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            BigQueryJobResult jobResult2 = (BigQueryJobResult)success.value();
            return new Success((Object)jobResult2);
        }
        throw new MatchError((Object)try_);
    }

    private QueryJobConfiguration.Builder addUDFToQueryConfig(QueryJobConfiguration.Builder queryConfig) {
        this.settings().appConfig().getEffectiveUdfs().foreach((Function1 & Serializable & scala.Serializable)udf -> {
            if (udf.contains("://")) {
                return queryConfig.setUserDefinedFunctions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)UserDefinedFunction.fromUri((String)udf), (List)Nil$.MODULE$)).asJava());
            }
            return BoxedUnit.UNIT;
        });
        return queryConfig;
    }

    @Override
    public Try<JobResult> run() {
        String string = this.datasetId().getDataset();
        String string2 = this.settings().appConfig().audit().getDomain(this.settings());
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (this.settings().appConfig().internal().forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.bqAuditSaveInBatchMode()))) {
                return this.runBatchQuery(this.runBatchQuery$default$1(), this.runBatchQuery$default$2()).map((Function1 & Serializable & scala.Serializable)x$5 -> new BigQueryJobResult((Option<TableResult>)None$.MODULE$, 0L, (Option<Job>)None$.MODULE$));
            }
            Option<Object> x$1 = this.jobTimeoutMs;
            Option<String> x$2 = this.runAndSinkAsTable$default$1();
            Option<Schema> x$3 = this.runAndSinkAsTable$default$2();
            return this.runAndSinkAsTable(x$2, x$3, x$1);
        }
        Materialization materialization = this.cliConfig().materialization();
        Materialization$TABLE$ materialization$TABLE$ = Materialization$TABLE$.MODULE$;
        if (!(materialization != null ? !((Object)materialization).equals(materialization$TABLE$) : materialization$TABLE$ != null)) {
            Option<Object> x$42 = this.jobTimeoutMs;
            Option<String> x$52 = this.runAndSinkAsTable$default$1();
            Option<Schema> x$6 = this.runAndSinkAsTable$default$2();
            return this.runAndSinkAsTable(x$52, x$6, x$42);
        }
        Materialization materialization2 = this.cliConfig().materialization();
        Materialization$MATERIALIZED_VIEW$ materialization$MATERIALIZED_VIEW$ = Materialization$MATERIALIZED_VIEW$.MODULE$;
        if (!(materialization2 != null ? !((Object)materialization2).equals(materialization$MATERIALIZED_VIEW$) : materialization$MATERIALIZED_VIEW$ != null)) {
            return this.runAndSinkAsMaterializedView(this.runAndSinkAsMaterializedView$default$1()).map((Function1 & Serializable & scala.Serializable)table -> new BigQueryJobResult((Option<TableResult>)None$.MODULE$, 0L, (Option<Job>)None$.MODULE$));
        }
        return this.runAndSinkAsView(this.runAndSinkAsView$default$1()).map((Function1 & Serializable & scala.Serializable)table -> new BigQueryJobResult((Option<TableResult>)None$.MODULE$, 0L, (Option<Job>)None$.MODULE$));
    }

    public Option<String> runInteractiveQuery$default$1() {
        return None$.MODULE$;
    }

    public Option<Object> runInteractiveQuery$default$2() {
        return None$.MODULE$;
    }

    public Option<Object> runInteractiveQuery$default$3() {
        return None$.MODULE$;
    }

    public boolean runInteractiveQuery$default$4() {
        return false;
    }

    public Try<Table> runAndSinkAsView(Option<String> thisSql) {
        return this.getOrCreateDataset((Option<String>)None$.MODULE$, this.getOrCreateDataset$default$2(), this.settings()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ViewDefinition.Builder viewDefinitionBuilder = ViewDefinition.newBuilder((String)((String)thisSql.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.sql)));
            Option<String> x$1 = this.cliConfig().accessToken();
            boolean x$2 = this.bigquery$default$1();
            Table table = this.bigquery(x$2, x$1, this.settings()).create(TableInfo.of((TableId)this.tableId(), (TableDefinition)viewDefinitionBuilder.build()), new BigQuery.TableOption[0]);
            return table;
        }));
    }

    public Option<String> runAndSinkAsView$default$1() {
        return None$.MODULE$;
    }

    public Try<Table> runAndSinkAsMaterializedView(Option<String> thisSql) {
        return this.getOrCreateDataset((Option<String>)None$.MODULE$, this.getOrCreateDataset$default$2(), this.settings()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            MaterializedViewDefinition.Builder materializedViewDefinitionBuilder = MaterializedViewDefinition.newBuilder((String)((String)thisSql.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.sql)));
            Option<String> option = this.cliConfig().outputPartition();
            if (option instanceof Some) {
                Some some = (Some)option;
                String partitionField = (String)some.value();
                TimePartitioning partitioning = this.timePartitioning(partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter()).build();
                materializedViewDefinitionBuilder.setTimePartitioning(partitioning);
            } else if (None$.MODULE$.equals(option)) {
            } else {
                throw new MatchError(option);
            }
            Seq<String> seq = this.cliConfig().outputClustering();
            if (Nil$.MODULE$.equals(seq)) {
            } else {
                Clustering clustering = Clustering.newBuilder().setFields((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(seq).asJava()).build();
                materializedViewDefinitionBuilder.setClustering(clustering);
            }
            Option<Object> option2 = this.cliConfig().enableRefresh();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                boolean x = BoxesRunTime.unboxToBoolean((Object)some.value());
                materializedViewDefinitionBuilder.setEnableRefresh(Predef$.MODULE$.boolean2Boolean(x));
            } else if (None$.MODULE$.equals(option2)) {
            } else {
                throw new MatchError(option2);
            }
            Option<Object> option3 = this.cliConfig().refreshIntervalMs();
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                long x = BoxesRunTime.unboxToLong((Object)some.value());
                materializedViewDefinitionBuilder.setRefreshIntervalMs(Predef$.MODULE$.long2Long(x));
            } else if (None$.MODULE$.equals(option3)) {
            } else {
                throw new MatchError(option3);
            }
            Option<String> x$1 = this.cliConfig().accessToken();
            boolean x$2 = this.bigquery$default$1();
            Table table = this.bigquery(x$2, x$1, this.settings()).create(TableInfo.of((TableId)this.tableId(), (TableDefinition)materializedViewDefinitionBuilder.build()), new BigQuery.TableOption[0]);
            this.setTagsOnTable(table);
            return table;
        }));
    }

    public Option<String> runAndSinkAsMaterializedView$default$1() {
        return None$.MODULE$;
    }

    public Try<BigQueryJobResult> runAndSinkAsTable(Option<String> thisSql, Option<Schema> targetTableSchema, Option<Object> queryJobTimeoutMs) {
        return this.getOrCreateDataset((Option<String>)None$.MODULE$, this.getOrCreateDataset$default$2(), this.settings()).flatMap((Function1 & Serializable & scala.Serializable)targetDataset -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            QueryJobConfiguration.Builder queryConfigWithClustering;
            QueryJobConfiguration.Builder builder;
            BoxedUnit boxedUnit3;
            QueryJobConfiguration.Builder queryConfigWithPartitioningAndSchemaUpdate;
            BoxedUnit boxedUnit4;
            QueryJobConfiguration.Builder builder2;
            BoxedUnit boxedUnit5;
            QueryJobConfiguration.Builder queryConfig = QueryJobConfiguration.newBuilder((String)((String)thisSql.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.sql))).setCreateDisposition(JobInfo.CreateDisposition.valueOf((String)this.cliConfig().createDisposition())).setWriteDisposition(JobInfo.WriteDisposition.valueOf((String)this.cliConfig().writeDisposition())).setDefaultDataset(targetDataset.getDatasetId()).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).setMaximumBytesBilled((Long)this.connectionOptions().get((Object)"maximumBytesBilled").map((Function1 & Serializable & scala.Serializable)x$1 -> Long.valueOf(x$1)).orNull(Predef$.MODULE$.$conforms())).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Computing partitionning");
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            Option<String> option = this.cliConfig().outputPartition();
            if (option instanceof Some) {
                Some some = (Some)option;
                String partitionField = (String)some.value();
                TimePartitioning partitioning = this.timePartitioning(partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter()).build();
                builder2 = queryConfig.setTimePartitioning(partitioning);
            } else if (None$.MODULE$.equals(option)) {
                builder2 = queryConfig;
            } else {
                throw new MatchError(option);
            }
            QueryJobConfiguration.Builder queryConfigWithPartition = builder2;
            boolean tableExists = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                Option<String> x$1 = this.cliConfig().accessToken();
                boolean x$2 = this.bigquery$default$1();
                return this.bigquery(x$2, x$1, this.settings()).getTable(this.tableId(), new BigQuery.TableOption[0]).exists();
            }).toOption().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Schema update options");
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            String string = this.cliConfig().writeDisposition();
            String string2 = JobInfo.WriteDisposition.WRITE_APPEND.toString();
            QueryJobConfiguration.Builder builder3 = !(string != null ? !string.equals(string2) : string2 != null) && tableExists ? queryConfigWithPartition.setSchemaUpdateOptions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION, (List)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION, (List)Nil$.MODULE$))).asJava()) : (queryConfigWithPartitioningAndSchemaUpdate = queryConfigWithPartition);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Computing clustering");
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            Seq<String> seq = this.cliConfig().outputClustering();
            if (Nil$.MODULE$.equals(seq)) {
                builder = queryConfigWithPartitioningAndSchemaUpdate;
            } else {
                Clustering clustering = Clustering.newBuilder().setFields((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(seq).asJava()).build();
                builder = queryConfigWithClustering = queryConfigWithPartitioningAndSchemaUpdate.setClustering(clustering);
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Add user defined functions");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            QueryJobConfiguration.Builder queryConfigWithUDF = this.addUDFToQueryConfig(queryConfigWithClustering);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Executing BQ Query {}", new Object[]{$this.sql});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            QueryJobConfiguration finalConfiguration = queryConfigWithUDF.setDestinationTable(this.tableId()).build();
            return this.recoverBigqueryException((Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                JobId jobId = this.newJobIdWithLocation();
                Option<String> x$3 = this.cliConfig().accessToken();
                boolean x$4 = this.bigquery$default$1();
                Job jobInfo = this.bigquery(x$4, x$3, this.settings()).create(JobInfo.newBuilder((JobConfiguration)finalConfiguration).setJobId(jobId).build(), new BigQuery.JobOption[0]);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Waiting for job {}", new Object[]{jobId});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return jobInfo.waitFor(new RetryOption[]{RetryOption.totalTimeout((Duration)Duration.ofMinutes((long)BoxesRunTime.unboxToLong((Object)queryJobTimeoutMs.orElse((Function0 & Serializable & scala.Serializable)() -> $this.jobTimeoutMs).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.settings().appConfig().longJobTimeoutMs()))))});
            }).map((Function1 & Serializable & scala.Serializable)jobResult -> {
                BoxedUnit boxedUnit;
                Long totalBytesProcessed = ((JobStatistics.QueryStatistics)jobResult.getStatistics()).getTotalBytesProcessed();
                TableResult results = jobResult.getQueryResults(new BigQuery.QueryResultsOption[]{BigQuery.QueryResultsOption.pageSize((long)$this.resultPageSize)});
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Query large results performed successfully: {} rows inserted and processed {} bytes.", new Object[]{BoxesRunTime.boxToLong((long)results.getTotalRows()), totalBytesProcessed});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option<String> x$5 = this.cliConfig().accessToken();
                boolean x$6 = this.bigquery$default$1();
                Table table = this.bigquery(x$6, x$5, this.settings()).getTable(this.tableId(), new BigQuery.TableOption[0]);
                this.setTagsOnTable(table);
                this.applyRLSAndCLS(this.applyRLSAndCLS$default$1(), this.settings()).recover((PartialFunction)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BigQueryNativeJob $outer;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Utils$.MODULE$.logException(this.$outer.logger(), A1);
                        throw new Exception(A1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.updateTableDescription(table, (String)this.cliConfig().outputTableDesc().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), this.settings());
                targetTableSchema.map((Function1 & Serializable & scala.Serializable)schema -> this.updateColumnsDescription((Schema)schema, this.settings())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.updateColumnsDescription(BigQueryJobBase$.MODULE$.dictToBQSchema(this.getFieldsDescriptionSource($this.sql, this.settings())), this.settings()));
                return new BigQueryJobResult((Option<TableResult>)new Some((Object)results), Predef$.MODULE$.Long2long(totalBytesProcessed), (Option<Job>)new Some(jobResult));
            });
        }).flatten(Predef$.MODULE$.$conforms()));
    }

    public Option<String> runAndSinkAsTable$default$1() {
        return None$.MODULE$;
    }

    public Option<Schema> runAndSinkAsTable$default$2() {
        return None$.MODULE$;
    }

    public Option<Object> runAndSinkAsTable$default$3() {
        return None$.MODULE$;
    }

    public Try<Table> getTable(TableId tableId) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> x$1 = this.cliConfig().accessToken();
            boolean x$2 = this.bigquery$default$1();
            return this.bigquery(x$2, x$1, this.settings()).getTable(tableId, new BigQuery.TableOption[0]);
        });
    }

    public Try<Job> runBatchQuery(Option<String> thisSql, boolean wait) {
        return this.getOrCreateDataset((Option<String>)None$.MODULE$, this.getOrCreateDataset$default$2(), this.settings()).flatMap((Function1 & Serializable & scala.Serializable)targetDataset -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                BoxedUnit boxedUnit3;
                JobId jobId = this.newJobIdWithLocation();
                QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)((String)thisSql.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.sql))).setCreateDisposition(JobInfo.CreateDisposition.valueOf((String)this.cliConfig().createDisposition())).setWriteDisposition(JobInfo.WriteDisposition.valueOf((String)this.cliConfig().writeDisposition())).setDefaultDataset(targetDataset.getDatasetId()).setDestinationTable(this.tableId()).setPriority(QueryJobConfiguration.Priority.BATCH).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).setSchemaUpdateOptions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION, (List)new .colon.colon((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION, (List)Nil$.MODULE$))).asJava()).setMaximumBytesBilled((Long)this.connectionOptions().get((Object)"maximumBytesBilled").map((Function1 & Serializable & scala.Serializable)x$1 -> Long.valueOf(x$1)).orNull(Predef$.MODULE$.$conforms())).build();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Executing batch BQ Query {}", new Object[]{$this.sql});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                Option<String> x$12 = this.cliConfig().accessToken();
                boolean x$2 = this.bigquery$default$1();
                Job job = this.bigquery(x$2, x$12, this.settings()).create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(jobId).build(), new BigQuery.JobOption[0]);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Batch query wth jobId {} sent to BigQuery ", new Object[]{jobId});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (job == null) {
                    throw new Exception(new StringBuilder(48).append("Job for ").append($this.sql).append(" not executed since it no longer exists.").toString());
                }
                if (wait) {
                    BoxedUnit boxedUnit4;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Waiting for job {}", new Object[]{jobId});
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    boxedUnit = job.waitFor(new RetryOption[]{RetryOption.totalTimeout((Duration)Duration.ofMinutes((long)BoxesRunTime.unboxToLong((Object)$this.jobTimeoutMs.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.settings().appConfig().longJobTimeoutMs()))))});
                } else if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("{} is running in background", new Object[]{job.getJobId()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return job;
            });
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(32).append("Error while running batch query ").append($this.sql).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new Failure(e);
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Job job = (Job)success.value();
                return new Success((Object)job);
            }
            throw new MatchError((Object)try_);
        });
    }

    public Option<String> runBatchQuery$default$1() {
        return None$.MODULE$;
    }

    public boolean runBatchQuery$default$2() {
        return false;
    }

    public static final /* synthetic */ long $anonfun$loadLocalFilePathsToBQ$3(OutputStream outputStream$1, String uri) {
        return Files.copy(File$.MODULE$.apply(new URI(uri)).path(), outputStream$1);
    }

    public static final /* synthetic */ void $anonfun$loadLocalFilePathsToBQ$2(Iterable sourceURIs$2, TableDataWriteChannel writer) {
        OutputStream outputStream = Channels.newOutputStream((WritableByteChannel)writer);
        sourceURIs$2.foreach((Function1 & Serializable & scala.Serializable)uri -> BoxesRunTime.boxToLong((long)BigQueryNativeJob.$anonfun$loadLocalFilePathsToBQ$3(outputStream, uri)));
    }

    public BigQueryNativeJob(BigQueryLoadConfig cliConfig, String sql, long resultPageSize, Option<Object> jobTimeoutMs, Settings settings) {
        BoxedUnit boxedUnit;
        this.cliConfig = cliConfig;
        this.sql = sql;
        this.resultPageSize = resultPageSize;
        this.jobTimeoutMs = jobTimeoutMs;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        BigQueryJobBase.$init$(this);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("BigQuery Config {}", new Object[]{cliConfig});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

