/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.job.sink.bigquery.BigQueryJobBase;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.job.sink.bigquery.BigQuerySparkJob$;
import ai.starlake.schema.model.AttributeDesc;
import ai.starlake.schema.model.ClusteringInfo;
import ai.starlake.schema.model.FieldPartitionInfo;
import ai.starlake.schema.model.IamPolicyTags;
import ai.starlake.schema.model.Schema$;
import ai.starlake.schema.model.TableInfo;
import ai.starlake.utils.IngestionCounters;
import ai.starlake.utils.JobBase;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.SparkJob;
import ai.starlake.utils.SparkJobResult;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.common.io.BaseEncoding;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DatasetLogging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001\u0002\u000e\u001c\u0001\u0019B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0005\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002C6\u0001\u0005\u000b\u0007I1\u00017\t\u0011M\u0004!\u0011!Q\u0001\n5DQ\u0001\u001e\u0001\u0005\u0002UD\u0001\" \u0001\t\u0006\u0004%\tA \u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011%\t\u0019\u0002\u0001b\u0001\n\u0003\t)\u0002\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\f\u0011%\ty\u0003\u0001b\u0001\n\u0003\t\t\u0002C\u0004\u00022\u0001\u0001\u000b\u0011\u0002(\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\t)\t\u0001C\u0001\u0003\u000f;\u0011\"a#\u001c\u0003\u0003E\t!!$\u0007\u0011iY\u0012\u0011!E\u0001\u0003\u001fCa\u0001^\u000b\u0005\u0002\u0005E\u0005\"CAJ+E\u0005I\u0011AAK\u0011%\tY+FI\u0001\n\u0003\ti\u000bC\u0005\u00022V\t\n\u0011\"\u0001\u00024\n\u0001\")[4Rk\u0016\u0014\u0018p\u00159be.TuN\u0019\u0006\u00039u\t\u0001BY5hcV,'/\u001f\u0006\u0003=}\tAa]5oW*\u0011\u0001%I\u0001\u0004U>\u0014'B\u0001\u0012$\u0003!\u0019H/\u0019:mC.,'\"\u0001\u0013\u0002\u0005\u0005L7\u0001A\n\u0005\u0001\u001dj3\u0007\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]Ej\u0011a\f\u0006\u0003a\u0005\nQ!\u001e;jYNL!AM\u0018\u0003\u0011M\u0003\u0018M]6K_\n\u0004\"\u0001N\u001b\u000e\u0003mI!AN\u000e\u0003\u001f\tKw-U;fefTuN\u0019\"bg\u0016\f\u0011b\u00197j\u0007>tg-[4\u0016\u0003e\u0002\"\u0001\u000e\u001e\n\u0005mZ\"A\u0005\"jOF+XM]=M_\u0006$7i\u001c8gS\u001e\f!b\u00197j\u0007>tg-[4!\u00035i\u0017-\u001f2f\u0005F\u001c6\r[3nCB\u0019\u0001fP!\n\u0005\u0001K#AB(qi&|g\u000e\u0005\u0002C\u00156\t1I\u0003\u0002\u001d\t*\u0011QIR\u0001\u0006G2|W\u000f\u001a\u0006\u0003\u000f\"\u000baaZ8pO2,'\"A%\u0002\u0007\r|W.\u0003\u0002L\u0007\n11k\u00195f[\u0006\fQ#\\1zE\u0016$\u0016M\u00197f\t\u0016\u001c8M]5qi&|g\u000eE\u0002)\u007f9\u0003\"a\u0014,\u000f\u0005A#\u0006CA)*\u001b\u0005\u0011&BA*&\u0003\u0019a$o\\8u}%\u0011Q+K\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002VS\u0005q\u0011\r\u001e;sS\n,H/Z:EKN\u001c\u0007cA.aG:\u0011AL\u0018\b\u0003#vK\u0011AK\u0005\u0003?&\nq\u0001]1dW\u0006<W-\u0003\u0002bE\n!A*[:u\u0015\ty\u0016\u0006\u0005\u0002eS6\tQM\u0003\u0002gO\u0006)Qn\u001c3fY*\u0011\u0001.I\u0001\u0007g\u000eDW-\\1\n\u0005),'!D!uiJL'-\u001e;f\t\u0016\u001c8-\u0001\u0005tKR$\u0018N\\4t+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019\"\u0003\u0019\u0019wN\u001c4jO&\u0011!o\u001c\u0002\t'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bYL(p\u001f?\u0015\u0005]D\bC\u0001\u001b\u0001\u0011\u0015Y\u0007\u0002q\u0001n\u0011\u00159\u0004\u00021\u0001:\u0011\u001di\u0004\u0002%AA\u0002yBq\u0001\u0014\u0005\u0011\u0002\u0003\u0007Q\nC\u0004Z\u0011A\u0005\t\u0019\u0001.\u0002!\r|gN\\3di>\u0014x\n\u001d;j_:\u001cX#A@\u0011\r\u0005\u0005\u00111\u0002(O\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C5n[V$\u0018M\u00197f\u0015\r\tI!K\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0007\u0003\u0007\u00111!T1q\u0003\u0011q\u0017-\\3\u0016\u00039\u000bAaY8oMV\u0011\u0011q\u0003\t\u0005\u00033\tI#\u0004\u0002\u0002\u001c)!\u00111CA\u000f\u0015\u0011\ty\"!\t\u0002\r!\fGm\\8q\u0015\u0011\t\u0019#!\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9#A\u0002pe\u001eLA!a\u000b\u0002\u001c\ti1i\u001c8gS\u001e,(/\u0019;j_:\fQaY8oM\u0002\naAY;dW\u0016$\u0018a\u00022vG.,G\u000fI\u0001\faJ,\u0007/\u0019:f\u0007>tg\r\u0006\u0002\u0002\u0018\u0005q!/\u001e8Ta\u0006\u00148n\u0016:ji\u0016\u0014HCAA\u001e!\u0019\ti$a\u0011\u0002H5\u0011\u0011q\b\u0006\u0004\u0003\u0003J\u0013\u0001B;uS2LA!!\u0012\u0002@\t\u0019AK]=\u0011\u00079\nI%C\u0002\u0002L=\u0012ab\u00159be.TuN\u0019*fgVdG/\u0001\bsk:\u001c\u0006/\u0019:l%\u0016\fG-\u001a:\u0015\t\u0005E\u0013q\u000f\t\u0007\u0003{\t\u0019%a\u0015\u0011\t\u0005U\u0013\u0011\u000f\b\u0005\u0003/\niG\u0004\u0003\u0002Z\u0005\u001dd\u0002BA.\u0003GrA!!\u0018\u0002b9\u0019\u0011+a\u0018\n\u0005\u0005\u001d\u0012\u0002BA\u0012\u0003KIA!!\u001a\u0002\"\u0005)1\u000f]1sW&!\u0011\u0011NA6\u0003\r\u0019\u0018\u000f\u001c\u0006\u0005\u0003K\n\t#C\u0002`\u0003_RA!!\u001b\u0002l%!\u00111OA;\u0005%!\u0015\r^1Ge\u0006lWMC\u0002`\u0003_Ba!!\u001b\u0012\u0001\u0004q\u0015a\u0001:v]R\u0011\u0011Q\u0010\t\u0007\u0003{\t\u0019%a \u0011\u00079\n\t)C\u0002\u0002\u0004>\u0012\u0011BS8c%\u0016\u001cX\u000f\u001c;\u0002\u000bE,XM]=\u0015\t\u0005E\u0013\u0011\u0012\u0005\u0007\u0003S\u001a\u0002\u0019\u0001(\u0002!\tKw-U;fef\u001c\u0006/\u0019:l\u0015>\u0014\u0007C\u0001\u001b\u0016'\t)r\u0005\u0006\u0002\u0002\u000e\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a&+\u0007y\nIj\u000b\u0002\u0002\u001cB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016!C;oG\",7m[3e\u0015\r\t)+K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAU\u0003?\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0016\u0016\u0004\u001b\u0006e\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u00026*\u001a!,!'")
public class BigQuerySparkJob
implements SparkJob,
BigQueryJobBase {
    private scala.collection.immutable.Map<String, String> connectorOptions;
    private final BigQueryLoadConfig cliConfig;
    private final Option<Schema> maybeBqSchema;
    private final Option<String> maybeTableDescription;
    private final List<AttributeDesc> attributesDesc;
    private final Settings settings;
    private final Configuration conf;
    private final String bucket;
    private Option<String> connectionName;
    private Option<Settings.Connection> connection;
    private scala.collection.immutable.Map<String, String> connectionOptions;
    private Option<Storage> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage;
    private Option<BigQuery> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery;
    private TableId tableId;
    private DatasetId datasetId;
    private String bqTable;
    private String bqNativeTable;
    private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv;
    private SparkSession session;
    private final String appName;
    private final Logger logger;
    private volatile int bitmap$0;

    public static List<AttributeDesc> $lessinit$greater$default$4() {
        return BigQuerySparkJob$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return BigQuerySparkJob$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Schema> $lessinit$greater$default$2() {
        return BigQuerySparkJob$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public Try<BoxedUnit> applyRLSAndCLS(boolean forceApply, Settings settings) {
        return BigQueryJobBase.applyRLSAndCLS$(this, forceApply, settings);
    }

    @Override
    public boolean applyRLSAndCLS$default$1() {
        return BigQueryJobBase.applyRLSAndCLS$default$1$(this);
    }

    @Override
    public BigQuery bigquery(boolean alwaysCreate, Option<String> accessToken, Settings settings) {
        return BigQueryJobBase.bigquery$(this, alwaysCreate, accessToken, settings);
    }

    @Override
    public boolean bigquery$default$1() {
        return BigQueryJobBase.bigquery$default$1$(this);
    }

    @Override
    public Storage gcsStorage(Settings settings) {
        return BigQueryJobBase.gcsStorage$(this, settings);
    }

    @Override
    public Try<BoxedUnit> applyIamPolicyTags(IamPolicyTags iamPolicyTags, Settings settings) {
        return BigQueryJobBase.applyIamPolicyTags$(this, iamPolicyTags, settings);
    }

    @Override
    public List<String> prepareRLS() {
        return BigQueryJobBase.prepareRLS$(this);
    }

    @Override
    public <T> Try<T> recoverBigqueryException(Function0<T> bigqueryProcess) {
        return BigQueryJobBase.recoverBigqueryException$(this, bigqueryProcess);
    }

    @Override
    public boolean tableExists(TableId tableId, Settings settings) {
        return BigQueryJobBase.tableExists$(this, tableId, settings);
    }

    @Override
    public boolean tableExists(Option<String> databaseName, String datasetName, String tableName, Settings settings) {
        return BigQueryJobBase.tableExists$(this, databaseName, datasetName, tableName, settings);
    }

    @Override
    public boolean dropTable(TableId tableId, Settings settings) {
        return BigQueryJobBase.dropTable$(this, tableId, settings);
    }

    @Override
    public boolean dropTable(Option<String> databaseName, String datasetName, String tableName, Settings settings) {
        return BigQueryJobBase.dropTable$(this, databaseName, datasetName, tableName, settings);
    }

    @Override
    public TableId getTableId(Option<String> databaseName, String datasetName, String tableName) {
        return BigQueryJobBase.getTableId$(this, databaseName, datasetName, tableName);
    }

    @Override
    public Schema getBQSchema(TableId tableId, Settings settings) {
        return BigQueryJobBase.getBQSchema$(this, tableId, settings);
    }

    @Override
    public Try<StandardTableDefinition> updateTableSchema(TableId tableId, Schema tableSchema, Settings settings) {
        return BigQueryJobBase.updateTableSchema$(this, tableId, tableSchema, settings);
    }

    @Override
    public Try<Dataset> getOrCreateDataset(Option<String> domainDescription, Option<String> datasetName, Settings settings) {
        return BigQueryJobBase.getOrCreateDataset$(this, domainDescription, datasetName, settings);
    }

    @Override
    public Option<String> getOrCreateDataset$default$2() {
        return BigQueryJobBase.getOrCreateDataset$default$2$(this);
    }

    @Override
    public Try<Tuple2<Table, StandardTableDefinition>> getOrCreateTable(Option<String> domainDescription, TableInfo tableInfo, Option<org.apache.spark.sql.Dataset<Row>> dataFrame, Settings settings) {
        return BigQueryJobBase.getOrCreateTable$(this, domainDescription, tableInfo, dataFrame, settings);
    }

    @Override
    public void setTagsOnTable(Table table) {
        BigQueryJobBase.setTagsOnTable$(this, table);
    }

    @Override
    public Table updateTableDescription(Table bqTable, String description, Settings settings) {
        return BigQueryJobBase.updateTableDescription$(this, bqTable, description, settings);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getFieldsDescriptionSource(String sql, Settings settings) {
        return BigQueryJobBase.getFieldsDescriptionSource$(this, sql, settings);
    }

    @Override
    public Table updateColumnsDescription(Schema schema, Settings settings) {
        return BigQueryJobBase.updateColumnsDescription$(this, schema, settings);
    }

    @Override
    public TimePartitioning.Builder timePartitioning(String partitionField, Option<Object> days, boolean requirePartitionFilter) {
        return BigQueryJobBase.timePartitioning$(this, partitionField, days, requirePartitionFilter);
    }

    @Override
    public Option<Object> timePartitioning$default$2() {
        return BigQueryJobBase.timePartitioning$default$2$(this);
    }

    @Override
    public StandardTableDefinition getTableDefinition(TableId tableId, Settings settings) {
        return BigQueryJobBase.getTableDefinition$(this, tableId, settings);
    }

    @Override
    public SparkConf withExtraSparkConf(SparkConf sourceConfig) {
        return SparkJob.withExtraSparkConf$(this, sourceConfig);
    }

    @Override
    public String getTableLocation(String domain, String schema) {
        return SparkJob.getTableLocation$(this, domain, schema);
    }

    @Override
    public String getTableLocation(String fullTableName) {
        return SparkJob.getTableLocation$(this, fullTableName);
    }

    @Override
    public void registerUdf(String udf) {
        SparkJob.registerUdf$(this, udf);
    }

    @Override
    public String applicationId() {
        return JobBase.applicationId$(this);
    }

    @Override
    public <T> DatasetLogging.DatasetHelper<T> DatasetHelper(org.apache.spark.sql.Dataset<T> ds) {
        return DatasetLogging.DatasetHelper$(this, ds);
    }

    private Option<String> connectionName$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 2) == 0) {
                this.connectionName = BigQueryJobBase.connectionName$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.connectionName;
    }

    @Override
    public Option<String> connectionName() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.connectionName$lzycompute();
        }
        return this.connectionName;
    }

    private Option<Settings.Connection> connection$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 4) == 0) {
                this.connection = BigQueryJobBase.connection$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.connection;
    }

    @Override
    public Option<Settings.Connection> connection() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.connection$lzycompute();
        }
        return this.connection;
    }

    private scala.collection.immutable.Map<String, String> connectionOptions$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 8) == 0) {
                this.connectionOptions = BigQueryJobBase.connectionOptions$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.connectionOptions;
    }

    @Override
    public scala.collection.immutable.Map<String, String> connectionOptions() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.connectionOptions$lzycompute();
        }
        return this.connectionOptions;
    }

    @Override
    public Option<Storage> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage() {
        return this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage_$eq(Option<Storage> x$1) {
        this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_gcsStorage = x$1;
    }

    @Override
    public Option<BigQuery> ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery() {
        return this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery;
    }

    @Override
    public void ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery_$eq(Option<BigQuery> x$1) {
        this.ai$starlake$job$sink$bigquery$BigQueryJobBase$$_bigquery = x$1;
    }

    private TableId tableId$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableId = BigQueryJobBase.tableId$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.tableId;
    }

    @Override
    public TableId tableId() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.tableId$lzycompute();
        }
        return this.tableId;
    }

    private DatasetId datasetId$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.datasetId = BigQueryJobBase.datasetId$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.datasetId;
    }

    @Override
    public DatasetId datasetId() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.datasetId$lzycompute();
        }
        return this.datasetId;
    }

    private String bqTable$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.bqTable = BigQueryJobBase.bqTable$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.bqTable;
    }

    @Override
    public String bqTable() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.bqTable$lzycompute();
        }
        return this.bqTable;
    }

    private String bqNativeTable$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.bqNativeTable = BigQueryJobBase.bqNativeTable$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.bqNativeTable;
    }

    @Override
    public String bqNativeTable() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.bqNativeTable$lzycompute();
        }
        return this.bqNativeTable;
    }

    private SparkEnv ai$starlake$utils$SparkJob$$sparkEnv$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.ai$starlake$utils$SparkJob$$sparkEnv = SparkJob.ai$starlake$utils$SparkJob$$sparkEnv$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.ai$starlake$utils$SparkJob$$sparkEnv;
    }

    @Override
    public SparkEnv ai$starlake$utils$SparkJob$$sparkEnv() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.ai$starlake$utils$SparkJob$$sparkEnv$lzycompute();
        }
        return this.ai$starlake$utils$SparkJob$$sparkEnv;
    }

    private SparkSession session$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.session = SparkJob.session$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.session;
    }

    @Override
    public SparkSession session() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.session$lzycompute();
        }
        return this.session;
    }

    @Override
    public String appName() {
        return this.appName;
    }

    @Override
    public void ai$starlake$utils$JobBase$_setter_$appName_$eq(String x$1) {
        this.appName = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public BigQueryLoadConfig cliConfig() {
        return this.cliConfig;
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    private scala.collection.immutable.Map<String, String> connectorOptions$lzycompute() {
        BigQuerySparkJob bigQuerySparkJob = this;
        synchronized (bigQuerySparkJob) {
            if ((this.bitmap$0 & 1) == 0) {
                this.connectorOptions = (scala.collection.immutable.Map)this.connectionOptions().$minus$minus((GenTraversableOnce)new .colon.colon((Object)"allowFieldAddition", (List)new .colon.colon((Object)"allowFieldRelaxation", (List)Nil$.MODULE$)));
                this.bitmap$0 |= 1;
            }
        }
        return this.connectorOptions;
    }

    public scala.collection.immutable.Map<String, String> connectorOptions() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.connectorOptions$lzycompute();
        }
        return this.connectorOptions;
    }

    @Override
    public String name() {
        Option<TableId> option = this.cliConfig().outputTableId();
        if (option instanceof Some) {
            return new StringBuilder(7).append("bqload-").append(this.bqTable()).toString();
        }
        return "bqload-query";
    }

    public Configuration conf() {
        return this.conf;
    }

    public String bucket() {
        return this.bucket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration prepareConf() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("BigQuery Config {}", new Object[]{this.cliConfig()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option bucketFromExtraConf = this.connectorOptions().get((Object)"temporaryGcsBucket").orElse((Function0 & Serializable & scala.Serializable)() -> this.settings().storageHandler(this.settings().storageHandler$default$1()).extraConf().get((Object)"temporaryGcsBucket")).orElse((Function0 & Serializable & scala.Serializable)() -> this.connectorOptions().get((Object)"gcsBucket")).orElse((Function0 & Serializable & scala.Serializable)() -> this.settings().storageHandler(this.settings().storageHandler$default$1()).extraConf().get((Object)"fs.gs.system.bucket")).orElse((Function0 & Serializable & scala.Serializable)() -> this.settings().storageHandler(this.settings().storageHandler$default$1()).extraConf().get((Object)"fs.defaultFS"));
        Option bucket2 = bucketFromExtraConf.orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.conf().get("fs.gs.system.bucket"))).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.conf().get("fs.defaultFS")));
        bucket2.foreach((Function1 & Serializable & scala.Serializable)bucket -> {
            BigQuerySparkJob.$anonfun$prepareConf$7(this, bucket);
            return BoxedUnit.UNIT;
        });
        JobInfo.WriteDisposition writeDisposition = JobInfo.WriteDisposition.valueOf((String)this.cliConfig().writeDisposition());
        this.conf().set(BigQueryConfiguration.OUTPUT_TABLE_WRITE_DISPOSITION.getKey(), writeDisposition.toString());
        this.conf().set(BigQueryConfiguration.OUTPUT_TABLE_CREATE_DISPOSITION.getKey(), this.cliConfig().createDisposition());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Using {} Credentials from GCS", new Object[]{this.connectionOptions().apply((Object)"authType")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<String> option = this.cliConfig().accessToken();
        if (option instanceof Some) {
            Some some = (Some)option;
            String accessToken = (String)some.value();
            this.session().conf().set("gcpAccessToken", accessToken);
            return this.conf();
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            String string = (String)this.connectionOptions().apply((Object)"authType");
            if ("APPLICATION_DEFAULT".equals(string)) {
                String[] scopes = new StringOps(Predef$.MODULE$.augmentString((String)this.connectionOptions().getOrElse((Object)"authScopes", (Function0 & Serializable & scala.Serializable)() -> "https://www.googleapis.com/auth/cloud-platform"))).split(',');
                GoogleCredentials cred = GoogleCredentials.getApplicationDefault().createScoped(scopes);
                cred.refresh();
                AccessToken accessToken = cred.getAccessToken();
                this.session().conf().set("gcpAccessToken", accessToken.getTokenValue());
                return this.conf();
            } else if ("SERVICE_ACCOUNT_JSON_KEYFILE".equals(string)) {
                String jsonKeyContent = BigQueryJobBase$.MODULE$.getJsonKeyContent(this.connectionOptions());
                String jsonKeyInBase64 = BaseEncoding.base64().encode(jsonKeyContent.getBytes(StandardCharsets.UTF_8));
                this.session().conf().set("credentials", jsonKeyInBase64);
                return this.conf();
            } else if ("SERVICE_ACCOUNT_JSON_KEY_BASE64".equals(string)) {
                String jsonKeyInBase64 = (String)this.connectionOptions().apply((Object)"jsonKeyBase64");
                this.session().conf().set("credentials", jsonKeyInBase64);
                return this.conf();
            } else {
                if (!"ACCESS_TOKEN".equals(string)) throw new MatchError((Object)string);
                String accessToken = (String)this.connectionOptions().apply((Object)"gcpAccessToken");
                this.session().conf().set("gcpAccessToken", accessToken);
            }
        }
        return this.conf();
    }

    public Try<SparkJobResult> runSparkWriter() {
        this.prepareConf();
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            StorageLevel cacheStorageLevel = (StorageLevel)this.settings().appConfig().internal().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.cacheStorageLevel()).getOrElse((Function0 & Serializable & scala.Serializable)() -> StorageLevel$.MODULE$.MEMORY_AND_DISK());
            Either<String, org.apache.spark.sql.Dataset<Row>> either = this.cliConfig().source();
            if (either instanceof Left) {
                Left left = (Left)either;
                String path = (String)left.value();
                return this.session().read().format(this.settings().appConfig().defaultWriteFormat()).load(path).persist(cacheStorageLevel);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                org.apache.spark.sql.Dataset df = (org.apache.spark.sql.Dataset)right.value();
                return df.persist(cacheStorageLevel);
            }
            throw new MatchError(either);
        }).flatMap((Function1 & Serializable & scala.Serializable)sourceDF -> {
            Option partitionField2 = this.cliConfig().outputPartition().map((Function1 & Serializable & scala.Serializable)partitionField -> new FieldPartitionInfo((String)partitionField, this.cliConfig().days(), this.cliConfig().requirePartitionFilter()));
            Seq<String> seq = this.cliConfig().outputClustering();
            None$ clusteringFields = Nil$.MODULE$.equals(seq) ? None$.MODULE$ : new Some((Object)new ClusteringInfo((List<String>)seq.toList()));
            return this.getOrCreateTable(this.cliConfig().domainDescription(), new TableInfo(this.tableId(), $this.maybeTableDescription, $this.maybeBqSchema, (Option<FieldPartitionInfo>)partitionField2, (Option<ClusteringInfo>)clusteringFields, $this.attributesDesc), (Option<org.apache.spark.sql.Dataset<Row>>)new Some(sourceDF), this.settings()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Table table = (Table)tuple2._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(sourceDF), (Object)table);
                }
                throw new MatchError((Object)tuple2);
            });
        }).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                Tuple2 tuple22;
                String string;
                String pretendingIntermediateFormat;
                BoxedUnit boxedUnit3;
                org.apache.spark.sql.Dataset sourceDF = (org.apache.spark.sql.Dataset)tuple2._1();
                Table table = (Table)tuple2._2();
                LazyBoolean containsArrayOfRecords$lzy = new LazyBoolean();
                Option materializationDataset = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.settings().sparkConfig().getString("datasource.bigquery.materializationDataset")).toOption();
                this.getOrCreateDataset((Option<String>)None$.MODULE$, (Option<String>)materializationDataset, this.settings());
                Option<String> x$1 = this.cliConfig().accessToken();
                boolean x$2 = this.bigquery$default$1();
                StandardTableDefinition stdTableDefinition = (StandardTableDefinition)this.bigquery(x$2, x$1, this.settings()).getTable(table.getTableId(), new BigQuery.TableOption[0]).getDefinition();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("BigQuery Saving to  {} which contained {} rows", new Object[]{table.getTableId(), stdTableDefinition.getNumRows()});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                Option intermediateFormatSettings = this.settings().appConfig().internal().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.intermediateBigqueryFormat());
                String string2 = pretendingIntermediateFormat = (String)intermediateFormatSettings.getOrElse((Function0 & Serializable & scala.Serializable)() -> "parquet");
                String string3 = "parquet";
                String intermediateFormat = !(string2 != null ? !string2.equals(string3) : string3 != null) && this.containsArrayOfRecords$1(containsArrayOfRecords$lzy) ? "orc" : pretendingIntermediateFormat;
                String string4 = string = this.cliConfig().writeDisposition();
                if ("WRITE_TRUNCATE".equals(string4)) {
                    tuple22 = new Tuple2((Object)SaveMode.Overwrite, this.connectorOptions());
                } else if (table.exists()) {
                    tuple22 = new Tuple2((Object)SaveMode.Append, (Object)this.connectorOptions().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"allowFieldAddition"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"allowFieldRelaxation"), (Object)"true")}))));
                } else {
                    throw new Exception(new StringBuilder(37).append("Invalid write disposition ").append(string).append(" for table ").append(table.getTableId()).toString());
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                SaveMode saveMode = (SaveMode)tuple23._1();
                scala.collection.immutable.Map withFieldRelaxationOptions = (scala.collection.immutable.Map)tuple23._2();
                Tuple2 tuple24 = new Tuple2((Object)saveMode, (Object)withFieldRelaxationOptions);
                SaveMode saveMode2 = (SaveMode)tuple24._1();
                scala.collection.immutable.Map withFieldRelaxationOptions2 = (scala.collection.immutable.Map)tuple24._2();
                if (this.logger().underlying().isDebugEnabled()) {
                    sourceDF.show();
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                scala.collection.mutable.Seq tableColNames = (scala.collection.mutable.Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)stdTableDefinition.getSchema().getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Buffer$.MODULE$.canBuildFrom());
                scala.collection.immutable.Map fieldsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDF.schema().fields())).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)field.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                Seq orderedFields = ((SeqLike)tableColNames.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(fieldsMap.get(key)), Seq$.MODULE$.canBuildFrom())).toSeq();
                org.apache.spark.sql.Dataset orderedDF = sourceDF.select((Seq)orderedFields.map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), scala.collection.Seq$.MODULE$.canBuildFrom()));
                orderedDF.write().mode(saveMode2).format("bigquery").option("table", this.bqTable()).option("intermediateFormat", intermediateFormat).options((Map)withFieldRelaxationOptions2).save();
                Success output = new Success((Object)BoxesRunTime.boxToLong((long)0L));
                Option<String> x$32 = this.cliConfig().accessToken();
                boolean x$4 = this.bigquery$default$1();
                StandardTableDefinition stdTableDefinitionAfter = (StandardTableDefinition)this.bigquery(x$4, x$32, this.settings()).getTable(table.getTableId(), new BigQuery.TableOption[0]).getDefinition();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("BigQuery Saved to {} now contains {} rows", new Object[]{table.getTableId(), stdTableDefinitionAfter.getNumRows()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                scala.collection.immutable.Map attributesDescMap = ((TraversableOnce)$this.attributesDesc.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    AttributeDesc attributeDesc = x0$3;
                    if (attributeDesc != null) {
                        String name = attributeDesc.name();
                        String desc = attributeDesc.comment();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)desc);
                    }
                    throw new MatchError((Object)attributeDesc);
                }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Object object = attributesDescMap.nonEmpty() ? this.updateColumnsDescription(BigQueryJobBase$.MODULE$.dictToBQSchema((scala.collection.immutable.Map<String, String>)attributesDescMap), this.settings()) : BoxedUnit.UNIT;
                this.updateTableDescription(table, (String)$this.maybeTableDescription.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), this.settings());
                return output.map((Function1 & Serializable & scala.Serializable)rejected -> BigQuerySparkJob.$anonfun$runSparkWriter$20(BoxesRunTime.unboxToLong((Object)rejected)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Try<org.apache.spark.sql.Dataset<Row>> runSparkReader(String sql) {
        boolean hasMaterializationDataset = this.settings().sparkConfig().hasPath("datasource.bigquery.materializationDataset");
        boolean hasViewsEnabled = this.settings().sparkConfig().hasPath("datasource.bigquery.viewsEnabled");
        if (hasMaterializationDataset && hasViewsEnabled) {
            this.prepareConf();
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.session().read().format("bigquery").load(sql));
        }
        throw new Exception("Make sure the keys spark.datasource.bigquery.materializationDataset and spark.datasource.bigquery.viewsEnabled are set in the application.sl.yml file.");
    }

    @Override
    public Try<JobResult> run() {
        Try<SparkJobResult> res = this.runSparkWriter();
        return Utils$.MODULE$.logFailure(res, this.logger());
    }

    public Try<org.apache.spark.sql.Dataset<Row>> query(String sql) {
        Try<org.apache.spark.sql.Dataset<Row>> res = this.runSparkReader(sql);
        return Utils$.MODULE$.logFailure(res, this.logger());
    }

    public static final /* synthetic */ void $anonfun$prepareConf$7(BigQuerySparkJob $this, String bucket) {
        BoxedUnit boxedUnit;
        String bucketName;
        BoxedUnit boxedUnit2;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Temporary GCS path {}", new Object[]{bucket});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        int prefix = bucket.indexOf("gs://");
        String string = bucketName = prefix >= 0 ? bucket.substring(prefix + "gs://".length()) : bucket;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Temporary GCS Name {}", new Object[]{bucketName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $this.session().conf().set("temporaryGcsBucket", bucketName);
    }

    private final /* synthetic */ boolean containsArrayOfRecords$lzycompute$1(LazyBoolean containsArrayOfRecords$lzy$1) {
        boolean bl;
        LazyBoolean lazyBoolean = containsArrayOfRecords$lzy$1;
        synchronized (lazyBoolean) {
            boolean bl2;
            if (containsArrayOfRecords$lzy$1.initialized()) {
                bl2 = containsArrayOfRecords$lzy$1.value();
            } else {
                Option maybeStarlakeSchema = this.cliConfig().starlakeSchema().orElse((Function0 & Serializable & scala.Serializable)() -> this.cliConfig().source().toOption().map((Function1 & Serializable & scala.Serializable)df -> Schema$.MODULE$.fromSparkSchema("df_schema", new StructField("ignore", (DataType)df.schema(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))));
                bl2 = containsArrayOfRecords$lzy$1.initialize(maybeStarlakeSchema.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.containsArrayOfRecords())));
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean containsArrayOfRecords$1(LazyBoolean containsArrayOfRecords$lzy$1) {
        if (containsArrayOfRecords$lzy$1.initialized()) {
            return containsArrayOfRecords$lzy$1.value();
        }
        return this.containsArrayOfRecords$lzycompute$1(containsArrayOfRecords$lzy$1);
    }

    public static final /* synthetic */ SparkJobResult $anonfun$runSparkWriter$20(long rejected) {
        return new SparkJobResult((Option<org.apache.spark.sql.Dataset<Row>>)None$.MODULE$, (Option<IngestionCounters>)new Some((Object)new IngestionCounters(0L, 0L, rejected)));
    }

    public BigQuerySparkJob(BigQueryLoadConfig cliConfig, Option<Schema> maybeBqSchema, Option<String> maybeTableDescription, List<AttributeDesc> attributesDesc, Settings settings) {
        BoxedUnit boxedUnit;
        this.cliConfig = cliConfig;
        this.maybeBqSchema = maybeBqSchema;
        this.maybeTableDescription = maybeTableDescription;
        this.attributesDesc = attributesDesc;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        DatasetLogging.$init$(this);
        JobBase.$init$(this);
        SparkJob.$init$(this);
        BigQueryJobBase.$init$(this);
        this.conf = this.session().sparkContext().hadoopConfiguration();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("BigQuery Config {}", new Object[]{cliConfig});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.bucket = this.conf().get("fs.defaultFS");
    }
}

