/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.config.Settings;
import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig;
import ai.starlake.job.sink.bigquery.BigQueryLoadConfig$;
import ai.starlake.job.sink.bigquery.BigQuerySparkJob;
import ai.starlake.job.sink.bigquery.BigQuerySparkJob$;
import ai.starlake.schema.model.AccessControlEntry;
import ai.starlake.schema.model.AttributeDesc;
import ai.starlake.schema.model.BigQuerySink;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.EsSink;
import ai.starlake.schema.model.FsSink;
import ai.starlake.schema.model.Materialization;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.Schema;
import ai.starlake.schema.model.Sink;
import ai.starlake.schema.model.WriteMode;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.TableId;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class BigQuerySparkWriter$
implements StrictLogging {
    public static BigQuerySparkWriter$ MODULE$;
    private final Logger logger;

    static {
        new BigQuerySparkWriter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Dataset<Row> setNullable(Dataset<Row> df) {
        String[] fieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return (Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).foldLeft(df, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Dataset df = (Dataset)tuple2._1();
                String colName = (String)tuple2._2();
                return df.withColumn(colName, functions$.MODULE$.when(functions$.MODULE$.col(colName).isNotNull(), (Object)functions$.MODULE$.col(colName)).otherwise((Object)functions$.MODULE$.lit(null)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Try<BoxedUnit> sinkInAudit(Dataset<Row> df, String tableName, Option<String> maybeTableDescription, Option<com.google.cloud.bigquery.Schema> maybeSchema, WriteMode writeMode, Option<String> accessToken, Settings settings) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Sink sink = settings.appConfig().audit().sink().getSink(settings);
            if (sink instanceof BigQuerySink) {
                Try<JobResult> result;
                BigQuerySink bigQuerySink = (BigQuerySink)sink;
                Right source = package$.MODULE$.Right().apply(MODULE$.setNullable(df));
                Tuple2<String, String> tuple2 = Utils$.MODULE$.getDBDisposition(writeMode);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String createDisposition = (String)tuple2._1();
                String writeDisposition = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)createDisposition, (Object)writeDisposition);
                String createDisposition2 = (String)tuple22._1();
                String writeDisposition2 = (String)tuple22._2();
                Some x$1 = new Some((Object)settings.appConfig().audit().getConnectionRef(settings));
                Right x$2 = source;
                Some x$3 = new Some((Object)BigQueryJobBase$.MODULE$.extractProjectDatasetAndTable(settings.appConfig().audit().getDatabase(settings), settings.appConfig().audit().getDomain(settings), tableName));
                String x$4 = settings.appConfig().defaultWriteFormat();
                String x$5 = createDisposition2;
                String x$6 = writeDisposition2;
                Option<String> x$7 = bigQuerySink.getPartitionColumn();
                scala.collection.immutable.Seq x$8 = (scala.collection.immutable.Seq)bigQuerySink.clustering().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                Option<Object> x$9 = bigQuerySink.days();
                boolean x$10 = BoxesRunTime.unboxToBoolean((Object)bigQuerySink.requirePartitionFilter().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                Nil$ x$11 = Nil$.MODULE$;
                Nil$ x$12 = Nil$.MODULE$;
                Option<String> x$13 = settings.appConfig().audit().getDatabase(settings);
                Option x$14 = accessToken;
                Engine x$15 = BigQueryLoadConfig$.MODULE$.apply$default$12();
                List<String> x$16 = BigQueryLoadConfig$.MODULE$.apply$default$13();
                Option<Schema> x$17 = BigQueryLoadConfig$.MODULE$.apply$default$15();
                Set<String> x$18 = BigQueryLoadConfig$.MODULE$.apply$default$16();
                Option<String> x$19 = BigQueryLoadConfig$.MODULE$.apply$default$17();
                Materialization x$20 = BigQueryLoadConfig$.MODULE$.apply$default$18();
                Option<String> x$21 = BigQueryLoadConfig$.MODULE$.apply$default$19();
                List<AttributeDesc> x$22 = BigQueryLoadConfig$.MODULE$.apply$default$20();
                Option<Object> x$23 = BigQueryLoadConfig$.MODULE$.apply$default$22();
                Option<Object> x$24 = BigQueryLoadConfig$.MODULE$.apply$default$23();
                BigQueryLoadConfig bqLoadConfig = new BigQueryLoadConfig((Option<String>)x$1, (Either<String, Dataset<Row>>)x$2, (Option<TableId>)x$3, x$7, (Seq<String>)x$8, x$4, x$5, x$6, x$9, (List<RowLevelSecurity>)x$11, x$10, x$15, x$16, (List<AccessControlEntry>)x$12, x$17, x$18, x$19, x$20, x$21, x$22, x$13, x$23, x$24, (Option<String>)x$14);
                Try<JobResult> try_ = result = new BigQuerySparkJob(bqLoadConfig, maybeSchema, maybeTableDescription, BigQuerySparkJob$.MODULE$.$lessinit$greater$default$4(), settings).run();
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        throw e;
                    }
                    throw new MatchError(try_);
                }
                return;
            }
            if (sink instanceof EsSink) {
                throw new Exception("Sinking Audit log to Elasticsearch not yet supported");
            }
            if (sink instanceof FsSink) {
                return;
            }
        });
    }

    private BigQuerySparkWriter$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

