/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.http;

import ai.starlake.job.sink.http.HttpSinkClient;
import ai.starlake.utils.Utils$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.Set;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001e4AAC\u0006\u0001-!A\u0011\b\u0001B\u0001B\u0003%!\bC\u0003K\u0001\u0011\u00051\nC\u0004P\u0001\t\u0007I\u0011\u0002)\t\rU\u0003\u0001\u0015!\u0003R\u0011\u001d1\u0006A1A\u0005\nACaa\u0016\u0001!\u0002\u0013\t\u0006b\u0002-\u0001\u0005\u0004%\t!\u0017\u0005\u0007;\u0002\u0001\u000b\u0011\u0002.\t\u000by\u0003A\u0011I0\u0003\u0013!#H\u000f\u001e9TS:\\'B\u0001\u0007\u000e\u0003\u0011AG\u000f\u001e9\u000b\u00059y\u0011\u0001B:j].T!\u0001E\t\u0002\u0007)|'M\u0003\u0002\u0013'\u0005A1\u000f^1sY\u0006\\WMC\u0001\u0015\u0003\t\t\u0017n\u0001\u0001\u0014\t\u00019rd\f\t\u00031ui\u0011!\u0007\u0006\u00035m\tA\u0001\\1oO*\tA$\u0001\u0003kCZ\f\u0017B\u0001\u0010\u001a\u0005\u0019y%M[3diB\u0011\u0001%L\u0007\u0002C)\u0011!eI\u0001\ngR\u0014X-Y7j]\u001eT!\u0001J\u0013\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO&\u0011a&\t\u0002\u0005'&t7\u000e\u0005\u00021o5\t\u0011G\u0003\u00023g\u0005a1oY1mC2|wmZ5oO*\u0011A'N\u0001\tif\u0004Xm]1gK*\ta'A\u0002d_6L!\u0001O\u0019\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005w\u0011;uI\u0004\u0002=\u0005B\u0011Q\bQ\u0007\u0002})\u0011q(F\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0002\rA\u0013X\rZ3g\u0013\t)eIA\u0002NCBT!a\u0011!\u0011\u0005mB\u0015BA%G\u0005\u0019\u0019FO]5oO\u00061A(\u001b8jiz\"\"\u0001\u0014(\u0011\u00055\u0003Q\"A\u0006\t\u000be\u0012\u0001\u0019\u0001\u001e\u0002\u00159,XNU3ue&,7/F\u0001R!\t\u00116+D\u0001A\u0013\t!\u0006IA\u0002J]R\f1B\\;n%\u0016$(/[3tA\u0005i!/\u001a;ss&sG/\u001a:wC2\faB]3uefLe\u000e^3sm\u0006d\u0007%\u0001\u0004dY&,g\u000e^\u000b\u00025B\u0011QjW\u0005\u00039.\u0011a\u0002\u0013;uaNKgn[\"mS\u0016tG/A\u0004dY&,g\u000e\u001e\u0011\u0002\u0011\u0005$GMQ1uG\"$2\u0001Y2i!\t\u0011\u0016-\u0003\u0002c\u0001\n!QK\\5u\u0011\u0015!\u0017\u00021\u0001f\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\u0004\"A\u00154\n\u0005\u001d\u0004%\u0001\u0002'p]\u001eDQ![\u0005A\u0002)\fA\u0001Z1uCB\u00111N\u001e\b\u0003YRt!!\\:\u000f\u00059\u0014hBA8r\u001d\ti\u0004/C\u0001-\u0013\tQ3&\u0003\u0002)S%\u0011aeJ\u0005\u0003k\u0016\nq\u0001]1dW\u0006<W-\u0003\u0002xq\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003k\u0016\u0002")
public class HtttpSink
implements Sink,
StrictLogging {
    private final int numRetries;
    private final int retryInterval;
    private final HttpSinkClient client;
    private final Logger logger;

    public String name() {
        return Sink.name$((Sink)this);
    }

    public StructType schema() {
        return Sink.schema$((Sink)this);
    }

    public Set<TableCapability> capabilities() {
        return Sink.capabilities$((Sink)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int numRetries() {
        return this.numRetries;
    }

    private int retryInterval() {
        return this.retryInterval;
    }

    public HttpSinkClient client() {
        return this.client;
    }

    public void addBatch(long batchId, Dataset<Row> data) {
        BooleanRef success = BooleanRef.create((boolean)false);
        IntRef retried = IntRef.create((int)0);
        while (!success.elem && retried.elem < this.numRetries()) {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ++retried$1.elem;
                this.client().send(data);
                success$1.elem = true;
            });
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                success.elem = false;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(Utils$.MODULE$.exceptionAsString(e));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (retried.elem < this.numRetries()) {
                    BoxedUnit boxedUnit2;
                    int sleepTime = this.retryInterval() * retried.elem;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("will retry to send after {}ms", new Object[]{BoxesRunTime.boxToInteger((int)sleepTime)});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    Thread.sleep(sleepTime);
                    continue;
                }
                throw e;
            }
            if (try_ instanceof Success) {
                continue;
            }
            throw new MatchError((Object)try_);
        }
    }

    public HtttpSink(Map<String, String> parameters) {
        Sink.$init$((Sink)this);
        StrictLogging.$init$((StrictLogging)this);
        this.numRetries = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"numRetries", (Function0 & Serializable & scala.Serializable)() -> "3"))).toInt();
        this.retryInterval = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"retryInterval", (Function0 & Serializable & scala.Serializable)() -> "1000"))).toInt();
        this.client = new HttpSinkClient(parameters);
    }
}

