/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.jdbc;

import ai.starlake.config.Settings;
import ai.starlake.job.Cmd;
import ai.starlake.job.sink.jdbc.JdbcConnectionLoadConfig;
import ai.starlake.job.sink.jdbc.JdbcConnectionLoadConfig$;
import ai.starlake.schema.handlers.SchemaHandler;
import ai.starlake.schema.model.ConnectionType;
import ai.starlake.schema.model.ConnectionType$JDBC$;
import ai.starlake.schema.model.Engine;
import ai.starlake.schema.model.RowLevelSecurity;
import ai.starlake.schema.model.WriteStrategy;
import ai.starlake.schema.model.WriteStrategy$;
import ai.starlake.schema.model.WriteStrategyType;
import ai.starlake.utils.CliConfig;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.JobResult;
import ai.starlake.utils.JobResult$;
import ai.starlake.workflow.IngestionWorkflow;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.fusesource.scalate.TemplateEngine;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.OParserSetup;
import scopt.Read$;

public final class JdbcConnectionLoadCmd$
implements Cmd<JdbcConnectionLoadConfig> {
    public static JdbcConnectionLoadCmd$ MODULE$;
    private final String command;
    private final OParser<BoxedUnit, JdbcConnectionLoadConfig> parser;
    private final String shell;
    private final TemplateEngine engine;
    private final OParserSetup setup;

    static {
        new JdbcConnectionLoadCmd$();
    }

    @Override
    public final Try<JobResult> run(Seq<String> args, SchemaHandler schemaHandler, Settings settings) {
        return Cmd.run$(this, args, schemaHandler, settings);
    }

    @Override
    public IngestionWorkflow workflow(SchemaHandler schemaHandler, Settings settings) {
        return Cmd.workflow$(this, schemaHandler, settings);
    }

    @Override
    public String usage() {
        return CliConfig.usage$(this);
    }

    @Override
    public String markdown(int pageIndex) {
        return CliConfig.markdown$(this, pageIndex);
    }

    @Override
    public String shell() {
        return this.shell;
    }

    @Override
    public void ai$starlake$job$Cmd$_setter_$shell_$eq(String x$1) {
        this.shell = x$1;
    }

    @Override
    public TemplateEngine engine() {
        return this.engine;
    }

    @Override
    public OParserSetup setup() {
        return this.setup;
    }

    @Override
    public void ai$starlake$utils$CliConfig$_setter_$engine_$eq(TemplateEngine x$1) {
        this.engine = x$1;
    }

    @Override
    public void ai$starlake$utils$CliConfig$_setter_$setup_$eq(OParserSetup x$1) {
        this.setup = x$1;
    }

    @Override
    public String command() {
        return this.command;
    }

    public void checkTablePresent(Settings.Connection jdbcOptions, Settings.JdbcEngine jdbcEngine, String outputDomainAndTablename, Settings settings) {
        ConnectionType connectionType = jdbcOptions.type();
        ConnectionType$JDBC$ connectionType$JDBC$ = ConnectionType$JDBC$.MODULE$;
        Predef$.MODULE$.assert(!(connectionType != null ? !((Object)connectionType).equals(connectionType$JDBC$) : connectionType$JDBC$ != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Only JDBC connections are supported ").append(jdbcOptions.type()).toString());
        Option table2 = jdbcEngine.tables().get(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(outputDomainAndTablename)).split('.'))).last());
        table2.foreach((Function1 & Serializable & scala.Serializable)table -> {
            JdbcConnectionLoadCmd$.$anonfun$checkTablePresent$2(jdbcOptions, outputDomainAndTablename, settings, table);
            return BoxedUnit.UNIT;
        });
    }

    public JdbcConnectionLoadConfig fromComet(String connectionRef, Settings.AppConfig comet, Either<String, Dataset<Row>> sourceFile, String outputTable, WriteStrategy strategy, boolean createTableIfAbsent, Settings settings) {
        Settings.Connection starlakeConnection = (Settings.Connection)comet.connections().apply((Object)connectionRef);
        Engine jdbcEngineName = starlakeConnection.getJdbcEngineName();
        if (createTableIfAbsent) {
            comet.jdbcEngines().get((Object)jdbcEngineName.toString()).foreach((Function1 & Serializable & scala.Serializable)jdbcEngine -> {
                JdbcConnectionLoadCmd$.MODULE$.checkTablePresent(starlakeConnection, jdbcEngine, outputTable, settings);
                return BoxedUnit.UNIT;
            });
        }
        Either dfWithUppercaseColumns = sourceFile.map((Function1 & Serializable & scala.Serializable)df -> (Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).foldLeft(df, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Dataset df = (Dataset)tuple2._1();
                String colName = (String)tuple2._2();
                return df.withColumnRenamed(colName, colName.toUpperCase());
            }
            throw new MatchError((Object)tuple2);
        }));
        return new JdbcConnectionLoadConfig((Either<String, Dataset<Row>>)dfWithUppercaseColumns, outputTable.toUpperCase(), strategy, (String)starlakeConnection.sparkDatasource().getOrElse((Function0 & Serializable & scala.Serializable)() -> "jdbc"), starlakeConnection.options(), JdbcConnectionLoadConfig$.MODULE$.apply$default$6(), JdbcConnectionLoadConfig$.MODULE$.apply$default$7());
    }

    @Override
    public OParser<BoxedUnit, JdbcConnectionLoadConfig> parser() {
        return this.parser;
    }

    @Override
    public Option<JdbcConnectionLoadConfig> parse(Seq<String> args) {
        return OParser$.MODULE$.parse(this.parser(), args, (Object)new JdbcConnectionLoadConfig(JdbcConnectionLoadConfig$.MODULE$.apply$default$1(), JdbcConnectionLoadConfig$.MODULE$.apply$default$2(), JdbcConnectionLoadConfig$.MODULE$.apply$default$3(), JdbcConnectionLoadConfig$.MODULE$.apply$default$4(), JdbcConnectionLoadConfig$.MODULE$.apply$default$5(), JdbcConnectionLoadConfig$.MODULE$.apply$default$6(), JdbcConnectionLoadConfig$.MODULE$.apply$default$7()), this.setup());
    }

    @Override
    public Try<JobResult> run(JdbcConnectionLoadConfig config, SchemaHandler schemaHandler, Settings settings) {
        return this.workflow(schemaHandler, settings).jdbcload(config).map((Function1 & Serializable & scala.Serializable)x$1 -> JobResult$.MODULE$.empty());
    }

    public static final /* synthetic */ void $anonfun$checkTablePresent$4(Settings.JdbcEngine.TableDdl table$1, String outputDomainAndTablename$1, Statement stmt$1) {
        String pingSql = table$1.effectivePingSql(outputDomainAndTablename$1);
        ResultSet rs = stmt$1.executeQuery(pingSql);
        rs.close();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$checkTablePresent$3(Connection conn$1, Settings.JdbcEngine.TableDdl table$1, String outputDomainAndTablename$1, Settings settings$1) {
        stmt = conn$1.createStatement();
        var6_5 = false;
        var7_6 = null;
        var8_7 = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$checkTablePresent$4(ai.starlake.config.Settings$JdbcEngine$TableDdl java.lang.String java.sql.Statement ), ()V)((Settings.JdbcEngine.TableDdl)table$1, (String)outputDomainAndTablename$1, (Statement)stmt));
        if (!(var8_7 instanceof Failure)) ** GOTO lbl-1000
        var6_5 = true;
        var7_6 = (Failure)var8_7;
        e = var7_6.exception();
        if (e instanceof SQLException) {
            stmt.executeUpdate(Formatter$.MODULE$.RichFormatter(table$1.createSql()).richFormat((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)outputDomainAndTablename$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writeFormat"), (Object)settings$1.appConfig().defaultWriteFormat())}))), (Map<String, Object>)Predef$.MODULE$.Map().empty(), settings$1));
            conn$1.commit();
        } else lbl-1000:
        // 2 sources

        {
            if (var6_5) {
                e = var7_6.exception();
                throw e;
            }
            if (var8_7 instanceof Success) {
            } else {
                throw new MatchError((Object)var8_7);
            }
        }
        stmt.close();
    }

    public static final /* synthetic */ void $anonfun$checkTablePresent$2(Settings.Connection jdbcOptions$1, String outputDomainAndTablename$1, Settings settings$1, Settings.JdbcEngine.TableDdl table) {
        Connection conn = DriverManager.getConnection((String)jdbcOptions$1.options().apply((Object)"url"), (String)jdbcOptions$1.options().apply((Object)"user"), (String)jdbcOptions$1.options().apply((Object)"password"));
        Try$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JdbcConnectionLoadCmd$.$anonfun$checkTablePresent$3(conn, table, outputDomainAndTablename$1, settings$1)));
        conn.close();
    }

    private JdbcConnectionLoadCmd$() {
        MODULE$ = this;
        CliConfig.$init$(this);
        Cmd.$init$(this);
        this.command = "cnxload";
        OParserBuilder builder = OParser$.MODULE$.builder();
        this.parser = OParser$.MODULE$.sequence(builder.programName(new StringBuilder(1).append(this.shell()).append(" ").append(this.command()).toString()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OParser[]{builder.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.shell(), this.command(), "[options]"})), builder.note(new StringOps(Predef$.MODULE$.augmentString("\n             |Load parquet file into JDBC Table.\n             |")).stripMargin()), builder.opt("source_file", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((Either<String, Dataset<Row>>)package$.MODULE$.Left().apply(x), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7())).text("Full Path to source file").required(), builder.opt("output_table", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            String x$1 = x;
            Either<String, Dataset<Row>> x$2 = c.copy$default$1();
            WriteStrategy x$3 = c.copy$default$3();
            String x$4 = c.copy$default$4();
            Map<String, String> x$5 = c.copy$default$5();
            Option<List<RowLevelSecurity>> x$6 = c.copy$default$6();
            boolean x$7 = c.copy$default$7();
            return c.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7);
        }).text("JDBC Output Table").required(), builder.opt("options", Read$.MODULE$.mapRead(Read$.MODULE$.stringRead(), Read$.MODULE$.stringRead())).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            Map x$8 = x;
            Either<String, Dataset<Row>> x$9 = c.copy$default$1();
            String x$10 = c.copy$default$2();
            WriteStrategy x$11 = c.copy$default$3();
            String x$12 = c.copy$default$4();
            Option<List<RowLevelSecurity>> x$13 = c.copy$default$6();
            boolean x$14 = c.copy$default$7();
            return c.copy(x$9, x$10, x$11, x$12, (Map<String, String>)x$8, x$13, x$14);
        }).text("Connection options eq for jdbc : driver, user, password, url, partitions, batchSize"), builder.opt("write_strategy", Read$.MODULE$.stringRead()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
            WriteStrategy x$15 = new WriteStrategy((Option<WriteStrategyType>)new Some((Object)new WriteStrategyType((String)x)), WriteStrategy$.MODULE$.apply$default$2(), WriteStrategy$.MODULE$.apply$default$3(), WriteStrategy$.MODULE$.apply$default$4(), WriteStrategy$.MODULE$.apply$default$5(), WriteStrategy$.MODULE$.apply$default$6(), WriteStrategy$.MODULE$.apply$default$7(), WriteStrategy$.MODULE$.apply$default$8());
            Either<String, Dataset<Row>> x$16 = c.copy$default$1();
            String x$17 = c.copy$default$2();
            String x$18 = c.copy$default$4();
            Map<String, String> x$19 = c.copy$default$5();
            Option<List<RowLevelSecurity>> x$20 = c.copy$default$6();
            boolean x$21 = c.copy$default$7();
            return c.copy(x$16, x$17, x$15, x$18, x$19, x$20, x$21);
        }).text("One of the write strategies: APPEND, OVERWRITE (see strategy types)")}));
    }
}

